{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*       --- PASCAL EXTERNAL PROCEDURE/FUNCTION DEFINITIONS ---          *
*                                                                       *
*               ---  Version 3.2-A0 -- 31/10/2016 ---                   *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////



}


{************     CPAS  version    *************}

        {************************************}
        {*                                  *}
        {*   Procedures/Function and main   *}
        {*                                  *}
        {************************************}






       { Basic procedures and functions }
       {********************************}  


procedure SRC_ERROR_S( modulesy:   error_mdnam;
                       number:     integer;
                       severity:   error_sev;
                       var id1, id2: [optional] id_name );
external;


function SEARCH_IN_PATH( in_var path: string; fspc: string; dsep: char := '/' ): string;
external;


procedure DATA_FORMAT_SET( ty: typ_ptr );
external;


function  TAB_NEW( sz: integer ): tab_ptr;
external;


procedure TAB_FREE( var p: tab_ptr );
external;


procedure VAL_NEW( var p: val_ptr; ty: typ_ptr );
external;


procedure VAL_FREE( var p: val_ptr );
external;


procedure VAL_FREE_TREE( var p: val_ptr );
external;


procedure VAL_COPY( var v1, v2: val_ptr; bfree: boolean );
external;


procedure ALL_NEW( var p: all_ptr; ty: typ_ptr; id: ide_ptr; kind: var_kind );
external;


procedure ALL_FREE( p: all_ptr );
external;


function  ALL_NEW_TMP( ty: typ_ptr; id: ide_ptr := nil ): lgt_ptr;
external;


procedure LGT_NEW( var p: lgt_ptr;
                               ty: typ_ptr; knd: lgt_kinds; prm: lgt_ptr );
external;


procedure LGT_NEW_COPY( model: lgt_ptr; var copy: lgt_ptr );
external;


procedure LGT_COPY_TREE( src: lgt_ptr; var dst: lgt_ptr );
external;


procedure LGT_FREE( var p: lgt_ptr );
external;


procedure LGT_FREE_TREE( var p: lgt_ptr );
external;


function  LGT_NEW_ECONST( ty: typ_ptr; iv: integer ): lgt_ptr;
external;


function  LGT_NEW_ECONSTR( ty: typ_ptr; rv: double ): lgt_ptr;
external;


function  LGT_GET_ECONST( lgt: lgt_ptr; idf: integer ): integer;
external;


function  LGT_IMASKP2( lgt: lgt_ptr ): integer;
external;


function  LGT_NEW_CODE( pcd: pcod_codes; par: lgt_ptr ): lgt_ptr;
external;


function  LGT_NEW_CALL( pty: typ_ptr; pro: pro_ptr; par: lgt_ptr ): lgt_ptr;
external;


function  LGT_LINK( lgt: lgt_ptr ): lgt_ptr;
external;


function  LGT_NEW_IDREF( id: ide_ptr; lnk: lgt_ptr ): lgt_ptr;
external;


function  LGT_TMPREF( ty: typ_ptr; nwt, frt: boolean ): lgt_ptr;
external;


function  LGT_NEW_ADDSUB( bsub, bfree: boolean; lgt1, lgt2: lgt_ptr ): lgt_ptr;
external;


procedure NEW_DISP_LEVEL( ow: pro_ptr; kind: disp_kinds );
external;


procedure IDE_RESERVE_DISP( prv: integer );
external;


function  MATCH( in_var s1, s2: id_name ): integer;
external;


function  NEW_INT_NAME( head: int_preffix;
                        var nbs: integer ): nam_ptr;
external;


function  LEVEL_SEARCH( fp: ide_ptr ): ide_ptr;
external;


function  LEX_SEARCH( disp: integer ): ide_ptr;
external;


function  ANY_CLASS( fs: set_class_types ): class_types;
external;


function  IDE_SEARCH( fs: set_class_types ): ide_ptr;
external;
 
 
procedure IDE_NEW( fc: class_types; ty: typ_ptr; var ip: ide_ptr );
external;


procedure GEN_CNTXVAR( pr: pro_ptr; id: nam_ptr );
external;


function  LGT_NEW_LINE( pr:  pro_ptr; lgp: lgt_ptr; icd: integer ): lgt_ptr;
external;


procedure GEN_LINETRACE( pr: pro_ptr; var lgh, lgl: lgt_ptr; icd: integer );
external;


procedure LABEL_PURGE( var prv_cntx: ide_ptr );
external;


function  TYP_ALIGNEMENT( iaddr: integer; aln: align_byte ): integer;
external;


function  IDE_TYP_ALIGN( iaddr: integer; ty: typ_ptr ): integer;
external;


procedure ALL_TYP_ALLOCATE( var iaddr: integer; al: all_ptr );
external;


procedure CTE_ALLOCATE( vp: val_ptr; id: ide_ptr );
external;


procedure IDE_NEW_TYP( frm: typ_forms; var p: typ_ptr );
external;


procedure IDE_NEW_TYP_RANGE( min, max: integer;  { effective limit range id. }
                             parent: typ_ptr;    { parent type id. pointer }
                             var typ: typ_ptr ); { result type pointer }
external;


procedure TMPSTK_ALLOCATE( lgt: lgt_ptr; ty: typ_ptr );
external;


procedure TMPSTK_FREE( stkp: stk_ptr );
external;


procedure FREE_TYP_LIST( var p: typ_ptr);
external;


procedure FREE_IDE_LIST( var p: ide_ptr );
external;


procedure IDE_FREE_LEX ( p: pro_ptr );
external;


procedure FREE_GENERIC_LIST ( var f, l: gen_ptr );
external;


procedure IDE_CREATE_NAME( var name: [readonly] string );
external;


procedure IDE_INT_LABEL;
external;


function  IDE_SEARCH_FROM_NAMEID( ip: ide_ptr ): ide_ptr;
external;


procedure SET_GBL_DEF_NAM( var trg: nam_ptr; var src: id_name; ach: char );
external;


procedure SET_ENV_FILE_SPC( pcur: env_ptr );
external;


procedure WIEW_OPER_DEF( op: operator );
external;


function  CREATE_MAC_IDENT( in_var id: id_name; cmdf: boolean := false ): macsymb_ptr;
external;


procedure REBUILD_MCTREE;
external;


procedure IDE_INIT;
external;


procedure GEN_CONV_ENTRY( tsrc, tdst: typ_ptr; pcd: pcod_codes );
external;



procedure COMPILE_SET_TITLE;
external;


procedure COMPILE_SET_SBTTL( prc: pro_ptr );
external;


procedure SET_SRCFILESPC( icd: integer );
external;


procedure INSYMBOL_SRC;
external;


procedure INSYMBOL;
external;


procedure SKIP_MSYMBOL( in_var smb: setsymb; rflg: boolean := false );
external;


procedure SKIP_SYMBOL( tosymbol: symbol; errflg: boolean := false; rflg: boolean := false );
external;


procedure INSY_INIT;
external;


procedure SET_STRNAME( var nam: nam_ptr );
external;


procedure SET_STDNAME( pr: pro_ptr );
external;


function  COMP_TYPE( eff, frm: typ_ptr; exact: boolean ): boolean;
external;


function COMP_PROC_ARG( epr, fpr: pro_ptr ): boolean;
external;


function  SAME_TYPE( ty1, ty2: typ_ptr ): boolean;
external;


function COMPARE_ENTRY( pr1, pr2: pro_ptr ): boolean;
external;


function COMPARE_PROC_ARGID( pgc, pgl: gen_ptr; ent: pro_ptr ): gen_ptr;
external;


procedure TYPE_PARM_CTE_INIT( ty: typ_ptr; var lghf, lghl: lgt_ptr; var count: integer );
external;


procedure TYPE_PARM_CTE_RELEASE( ty: typ_ptr );
external;


procedure STRING_IN_ARRAY( lgt: lgt_ptr; ty: typ_ptr );
external;


procedure STRING_IN_SUBSTRING( lgt: lgt_ptr; ty: typ_ptr );
external;


function  EXP_VAL_UNA( puna: lgt_ptr; p: gen_ptr ): lgt_ptr;
external;


function  EXP_VAL_BIN( ob1: lgt_ptr; p: gen_ptr ): lgt_ptr;
external;


function  LOOK_FOR_DESCRIPTOR( lgt: lgt_ptr ): lgt_ptr;
external;


procedure CALL_SETTING( var lgt: lgt_ptr );
external;


procedure GENERIC_SEARCH( var id:       id_name;
                              npa:      integer;
                          var pg:       gen_ptr;
                              parm_lst: lgt_ptr );
external;


function EXP_GENOPER( var id: id_name; p: gen_ptr; oblst: lgt_ptr ): lgt_ptr;
external;


function EXP_GENOP( op: operator; oblst: lgt_ptr ): lgt_ptr;
external;


function  LGT_GEN_STORE( prm: lgt_ptr; bstd, bovr: boolean ): lgt_ptr;
external;


function GENERATE_CALL( ip: ide_ptr; lgp: lgt_ptr;
                        np: integer := 0; bsnsea: boolean := false ): lgt_ptr;
external;


procedure INITIALIZE_VARBL( ip: ide_ptr );
external;


procedure INIT_D_DYN(     ty:         typ_ptr;
                          trg:        lgt_ptr;
                      var lgth, lgtl: lgt_ptr;
                          bindir:     boolean;
                          ide:        ide_ptr := nil );
external;


procedure INIT_D_VARBL( ip: ide_ptr );
external;


procedure TYPE_CHECK_PARM( lgt: lgt_ptr );
external;


function TYPE_PARM_SET( ip: ide_ptr; lgt: lgt_ptr ): typ_ptr;
external;


procedure CMP_BLOCK( owner: pro_ptr; bproc: boolean; glicd: integer );
external;


procedure CMP_INIT;
external;


function  CMP_COMPILE( interactive: boolean ): error_sev;
external;


function LGT_TYPE_EVAL( troot, prm_actual: lgt_ptr; ty: typ_ptr := nil; elm_arr: boolean := false ): lgt_ptr;
external;


procedure LGT_GEN_ROUTINE( ty: typ_ptr );
external;


function LGT_TYPE_COMPUTE( expr, expe: lgt_ptr; dvl: integer; obj: lgt_ptr ): lgt_ptr;
external;


procedure LGT_EXTRACT_SIMPLE_CTE( lgt: lgt_ptr );
external;


procedure LGT_SCAN( head: lgt_ptr );
external;


procedure LGT_ALL_FPARM( pr: pro_ptr );
external;


procedure LGT_PASS1_COMPLET( pr: pro_ptr );
external;


function IN_UNSIGNED( p: $wild_pointer ): unsigned;
external;


procedure LGT_WRITE_TREE( icol: integer; p: lgt_ptr );
external;


procedure LGT_WRITE( icol, is: integer; p1: lgt_ptr );
external;


procedure DUMP_TYPES( icol: integer; ty: typ_ptr );
external;


procedure LGT_DUMP_PROC( pr: pro_ptr );
external;


procedure VAL_DUMP( pv: val_ptr; icol, icnt, ishc: integer := 0 );
external;


procedure LGT_DUMP_ROUTINES;
external;


procedure LGT_DUMP_STATIC( pr: pro_ptr );
external;


function  BINARY_OBJF_OPEN: integer;
external;


procedure BINARY_OBJF_CLOSE;
external;


procedure LGT_ALLOCATE_PARM_ADDR( proc: pro_ptr );
external;


procedure GENERATION_SETTING;
external;


procedure GENERATION_PRAGMA;
external;


procedure GENERATE_CODE_P1( proc: pro_ptr );
external;


procedure GENERATE_CODE_P2;
external;


procedure GENERATE_START;
external;


procedure PAS_READ_ENV_FILE;
external;


procedure PAS_WRITE_ENV_FILE;
external;

