/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B3/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 640 ) = {
 11,  11, 115, 114,  99,  95, 109, 101, 120, 112, 101, 110, 100,  64,  64,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  51,  47,  99, 112,
 97, 115,  95,  98,  95,  95, 118,  50, 115, 114,  99,  46, 112,  97, 115,  10,
 10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  12,  12, 115, 114,  99,
 95,  97, 108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,  95, 102,
114, 101, 101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,  13,  13,
115, 114,  99,  95, 102, 105, 108, 101,  95, 111, 112, 101, 110,  14,  14, 115,
114,  99,  95, 110, 101, 119,  95, 115, 111, 117, 114,  99, 101,  17,  17, 115,
114,  99,  95,  97,  99, 116, 105, 118, 101,  95, 115, 111, 117, 114,  99, 101,
 16,  16, 115, 114,  99,  95, 115, 101, 116,  95, 109,  97,  99, 114, 111,  95,
 99,  98,  16,  16, 115, 114,  99,  95, 100, 101, 108,  95, 109,  97,  99, 114,
111,  95,  99,  98,  14,  14, 115, 114,  99,  95, 109,  97,  99, 114, 111,  95,
111, 112, 101, 110,  10,  10, 115, 114,  99,  95, 114, 101, 116, 117, 114, 110,
 17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 116, 101, 120, 116,  95, 108,
105, 110, 101,  11,  11, 115, 114,  99,  95, 111, 117, 116, 108, 105, 110, 101,
 17,  17, 115, 114,  99,  95, 111, 117, 116, 101, 114, 114,  95,  98,  97, 110,
110, 101, 114,  40,  40,  32,  37,  42,  43,  42,  43,  42,  32, 101, 114, 114,
111, 114,  40, 115,  41,  32, 119,  97, 115,  32, 100, 101, 116, 101,  99, 116,
101, 100,  32,  97, 116,  32, 108, 105, 110, 101,  32,  35,  32,  16,  16,  32,
105, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  58,  32,  34,  13,
 13, 115, 114,  99,  95, 111, 117, 116,  95, 101, 114, 114, 111, 114,  34,  34,
 32,  60,  60,  60,  32,  42,  42,  42,  32,  77,  97, 120, 105, 109, 117, 109,
 32, 110, 117, 109,  98, 101, 114,  32, 111, 102,  32, 101, 114, 114, 111, 114,
 32,  40,  52,  52,  41,  32, 105, 115,  32, 114, 101,  97,  99, 104, 101, 100,
 46,  32,  83,  82,  67,  95,  76, 105,  98, 114,  97, 114, 121,  32, 115, 116,
111, 112,  32, 111, 117, 114,  32,  83, 111, 102, 116, 119,  97, 114, 101,  46,
 32,  42,  42,  42,  32,  62,  62,  62,  17,  17, 115, 114,  99,  95, 111, 117,
116,  95, 109,  97,  99,  95, 101, 114, 114, 111, 114,   9,   9, 115, 114,  99,
 95, 101, 114, 114, 111, 114,  17,  17, 115, 114,  99,  95, 103, 101, 116,  95,
105, 110, 112, 117, 116, 108, 105, 110, 101,  14,  14, 115, 114,  99,  95, 112,
117, 116,  95, 112, 114, 111, 109, 112, 116,  12,  12, 115, 114,  99,  95, 103,
101, 116,  95, 108, 105, 110, 101,  15,  15, 115, 114,  99,  95, 101, 110, 100,
 95, 111, 102,  95, 108, 105, 110, 101,   4,   4,  83,  95,  71,  76,  12,  12,
115, 114,  99,  95, 103, 101, 116,  95,  99, 104,  97, 114,  12,  12, 115, 107,
105, 112,  95,  99, 111, 109, 109, 101, 110, 116,  10,  10, 115, 114,  99,  95,
105, 110,  99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 110, 101, 120, 116,
 95,  99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 115, 101, 116,  95, 102,
108,  97, 103, 115,   8,   8, 115, 114,  99,  95, 105, 110, 105, 116,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 24 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Global C type definitions */
typedef  V (*Re0)(V);

/* Declaration of external variables. */
extern V V_src_hde;
extern V V_src_control;
extern SL V_src_openerr;
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_def_prompt;
extern V V_lst_current;
extern SL V_src_lstinsnb;
extern SL V_src_maxerror;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;
extern V V_src_cont_base;


/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);


/* Procedure/Function : " src_mexpend "  */
void BASIC_SC_V2_src_mexpend(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register SL Rv2;
  V Rv3;
  SL Rv4;
  register V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=143; /* line # 143 */
  if (Ri.v[0]==NULL) {
    Ri.v[0]=PAS__NEW(1036);
    ((SL *)Ri.v[0])[0]=1024;
    Rv0=Ri.v[0];
    ((SL *)Rv0)[1]=0;
    ((SL *)Rv0)[2]=0;
  }
  else {
    Ra.sl[6]=150; /* line # 150 */
    if (((SL *)Ri.v[0])[0]<=((SL *)Ri.v[0])[1]) {
      Rv1=Ri.v[0];
      Rv2=((SL *)Rv1)[0]+1024;
      Rv3=PAS__NEW(Rv2+12);
      ((SL *)Rv3)[0]=Rv2;
      Ra.sl[6]=155; /* line # 155 */
      ((SL *)Rv3)[1]=((SL *)Rv1)[1];
      ((SL *)Rv3)[2]=((SL *)Rv1)[2];
      Rv4=1;
      for( Rf0=((SL *)Rv1)[1];Rf0>0;Rf0-- ) {
        ((C *)Rv3)[Rv4+11]=((C *)Rv1)[Rv4+11];
        Rv4++;
      }
      PAS__DISPOSE(Ri.v);
      Ra.sl[6]=160; /* line # 160 */
      Ri.v[0]=Rv3;
    }
  }
  Rv5=Ri.v[0];
  ((SL *)Rv5)[1]=((SL *)Rv5)[1]+1;
  ((C *)Rv5)[((SL *)Rv5)[1]+11]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_r_init "  */
void BASIC_SC_V2_src_r_init(V F_p, UB F_macflg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+79;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=173; /* line # 173 */
  if (F_p!=NULL) {
    Rv0=F_p;
    ((V *)Rv0)[0]=V_src_hde;
    Ra.sl[6]=178; /* line # 178 */
    ((V *)Rv0)[1]=NULL;
    ((SL *)Rv0)[4]=0;
    ((SL *)Rv0)[5]=0;
    ((SL *)Rv0)[6]=0;
    ((SL *)Rv0)[7]=0;
    Ra.sl[6]=183; /* line # 183 */
    ((SL *)Rv0)[8]=0;
    ((SL *)Rv0)[9]=0;
    ((SL *)Rv0)[10]=0;
    ((SL *)Rv0)[11]=1;
    ((SL *)Rv0)[12]=255;
    Ra.sl[6]=188; /* line # 188 */
    ((C *)Rv0)[52]=0;
    ((C *)Rv0)[53]=1;
    if (F_macflg) ((C *)Rv0)[54]=77;
    else((C *)Rv0)[54]=32;
    ((C *)Rv0)[55]=32;
    Ra.sl[6]=193; /* line # 193 */
    Rv1=1;
    for( Rf0=8;Rf0>0;Rf0-- ) {
      ((V *)Rv0)[Rv1*3+6]=NULL;
      Rv1++;
    }
    if (!F_macflg) {
      Ra.sl[6]=198; /* line # 198 */
      if (32768&((UL *)Rv0)[62]) {
        ((V *)Rv0)[32]=NULL;
        ((V *)Rv0)[34]=NULL;
        ((V *)Rv0)[33]=NULL;
      }
      Ra.sl[6]=204; /* line # 204 */
      ((UL *)Rv0)[62]=2120;
      ((UB *)Rv0)[252]=0;
      if (((V *)Rv0)[32]==NULL) {
        ((V *)Rv0)[32]=PAS__NEW(257);
        ((UB *)((V *)Rv0)[32])[0]=255;
      }
      ((UB *)((V *)Rv0)[32])[1]=0;
      if (((V *)Rv0)[35]!=NULL) {
        Ra.sl[6]=209; /* line # 209 */
        PAS__DISPOSE(((V *)Rv0)+35);
        ((V *)Rv0)[35]=NULL;
      }
    }
    else {
      if (!(32768&((UL *)Rv0)[62])) {
        Ra.sl[6]=215; /* line # 215 */
        if (((V *)Rv0)[32]!=NULL) PAS__DISPOSE(((V *)Rv0)+32);
        if (((V *)Rv0)[35]!=NULL) PAS__DISPOSE(((V *)Rv0)+35);
      }
      ((UL *)Rv0)[62]=34880;
      ((UB *)Rv0)[252]=4;
      Ra.sl[6]=220; /* line # 220 */
      ((V *)Rv0)[32]=NULL;
      ((V *)Rv0)[33]=NULL;
      ((V *)Rv0)[34]=NULL;
      ((SL *)Rv0)[70]=0;
    }
  }
  Ra.sl[6]=226; /* line # 226 */
  V_src_hde=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V BASIC_SC_V2_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=239; /* line # 239 */
  Rv0=PAS__NEW(288);
  Rv1=Rv0;
  ((UL *)Rv1)[62]=32768;
  ((V *)Rv1)[32]=NULL;
  Ra.sl[6]=244; /* line # 244 */
  ((V *)Rv1)[35]=NULL;
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=259; /* line # 259 */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_src_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[6]=265; /* line # 265 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Ra.sl[6]=270; /* line # 270 */
    Rv2=(*F_p);
    if (!(32768&((UL *)Rv2)[62])) {
      if (((V *)Rv2)[32]!=NULL) PAS__DISPOSE(((V *)Rv2)+32);
      Ra.sl[6]=275; /* line # 275 */
      if (((V *)Rv2)[35]!=NULL) PAS__DISPOSE(((V *)Rv2)+35);
    }
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    Ra.sl[6]=281; /* line # 281 */
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+115;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=297; /* line # 297 */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (16384&((UL *)Rv0)[62]) {
      Ra.sl[6]=303; /* line # 303 */
      if (32768&((UL *)Rv0)[62]) {
        ((V *)Rv0)[32]=NULL;
        ((V *)Rv0)[34]=NULL;
        ((V *)Rv0)[33]=NULL;
      }
      else {
        Ra.sl[6]=311; /* line # 311 */
        if (128&((UL *)Rv0)[62]) Rv1=2048;
        else Rv1=0;
        PAS__CLOSE(((V *)Rv0)+33,Rv1);
        if (8&((UL *)Rv0)[62]) PAS__CLOSE(((V *)Rv0)+34,0);
        if (((V *)Rv0)[35]!=NULL) {
          Ra.sl[6]=317; /* line # 317 */
          PAS__DISPOSE(((V *)Rv0)+35);
          ((V *)Rv0)[35]=NULL;
        }
      }
      if (((V *)Rv0)[1]!=NULL&&V_src_control==(*F_p)) {
        Ra.sl[6]=322; /* line # 322 */
        V_src_control=((V *)Rv0)[1];
      }
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~16384;
    }
    Ra.sl[6]=327; /* line # 327 */
    if (F_bfree) P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_file_open "  */
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+126;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=352; /* line # 352 */
  V_src_openerr=0;
  if (F_srcp==NULL) {
    Rv0=0;
    F_srcp=BASIC_SC_V2_src_allocate();
  }
  else {
    Ra.sl[6]=360; /* line # 360 */
    Rv0=1;
    P_src_close(&F_srcp,0);
  }
  BASIC_SC_V2_src_r_init(F_srcp,0);
  Ra.sl[6]=365; /* line # 365 */
  Rv1=F_srcp;
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[33],PAS__f_input);
    Ra.sl[6]=370; /* line # 370 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16;
    PAS__iostatus=0;
  }
  else PAS__OPEN(((V *)Rv1)+33,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  Ra.sl[6]=375; /* line # 375 */
  if (PAS__iostatus==0) {
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8;
    if (PAS__TTY_FILE(((V *)Rv1)[33])) {
      Ra.sl[6]=381; /* line # 381 */
      if (((UB *)F_fspc)[1]==0) {
        _FILE_DUPLICATE(((V *)Rv1)[34],PAS__f_output);
        PAS__iostatus=0;
      }
      else {
        Ra.sl[6]=386; /* line # 386 */
        PAS__OPEN(((V *)Rv1)+34,0, F_fspc,4098,0,-1);
      }
      if (PAS__iostatus!=0) {
        V_src_openerr=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+33,0);
      }
      else {
        Ra.sl[6]=393; /* line # 393 */
        ((V *)Rv1)[35]=PAS__NEW(65);
        ((UB *)((V *)Rv1)[35])[0]=63;
        PAS__STR_TO_STR(((V *)Rv1)[35],V_def_prompt);
        ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16392;
      }
    }
    else {
      Ra.sl[6]=400; /* line # 400 */
      if (F_bdel) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|128;
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
    }
  }
  else V_src_openerr=PAS__iostatus;
  Ra.sl[6]=405; /* line # 405 */
  if (V_src_openerr!=0) {
    if (Rv0) BASIC_SC_V2_src_r_init(F_srcp,0);
    else P_src_free(&F_srcp);
  }
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_new_source "  */
void P_src_new_source(V F_fspc, UB F_binc, UB F_bdel){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+141;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=431; /* line # 431 */
  Rv0=P_src_file_open(F_fspc,F_bdel,NULL);
  if (V_src_openerr==0) {
    Rv1=Rv0;
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    Ra.sl[6]=436; /* line # 436 */
    if (F_binc) ((SL *)Rv1)[7]=((SL *)Rv1)[7]+1;
    ((SL *)Rv1)[8]=((SL *)V_src_control)[8];
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv1)[11]=((SL *)V_src_control)[11];
    ((SL *)Rv1)[12]=((SL *)V_src_control)[12];
    Ra.sl[6]=441; /* line # 441 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|((UL *)V_src_control)[62]&103;
    if (F_binc) {
      ((V *)Rv1)[1]=V_src_control;
      Ra.sl[6]=446; /* line # 446 */
      V_src_control=Rv0;
    }
    else {
      ((V *)Rv1)[1]=((V *)V_src_control)[1];
      Ra.sl[6]=451; /* line # 451 */
      P_src_close(&Rv0, F_bdel);
      V_src_control=Rv0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_active_source "  */
void P_src_active_source(V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+157;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=466; /* line # 466 */
  if (F_srcp!=NULL&&V_src_control!=NULL) {
    Rv0=V_src_control;
    Ra.sl[6]=473; /* line # 473 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|262144;
    Rv1=F_srcp;
    ((V *)Rv1)[1]=V_src_control;
    Ra.sl[6]=478; /* line # 478 */
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    ((SL *)Rv1)[8]=((SL *)Rv1)[7];
    ((C *)Rv1)[52]=0;
    ((C *)Rv1)[53]=((C *)V_src_control)[52];
    Ra.sl[6]=483; /* line # 483 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|65536;
    V_src_control=F_srcp;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_set_macro_cb "  */
void P_src_set_macro_cb(V F_call_back(V F_mp)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+176;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=498; /* line # 498 */
  Ri.v[1]=(V)(*F_call_back);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_del_macro_cb "  */
void P_src_del_macro_cb(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=506; /* line # 506 */
  Ri.v[1]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_macro_open "  */
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+212;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=529; /* line # 529 */
  if (F_srcp==NULL) {
    Rv0=0;
    F_srcp=BASIC_SC_V2_src_allocate();
  }
  else {
    Ra.sl[6]=536; /* line # 536 */
    Rv0=1;
    P_src_close(&F_srcp,0);
  }
  BASIC_SC_V2_src_r_init(F_srcp,1);
  Rv1=F_srcp;
  Ra.sl[6]=542; /* line # 542 */
  if (F_mtxt!=NULL) {
    ((V *)Rv1)[32]=F_mtxt;
    ((SL *)Rv1)[12]=((UB *)F_mtxt)[1];
    if (((SL *)Rv1)[12]>0) {
      Ra.sl[6]=548; /* line # 548 */
      ((C *)Rv1)[53]=0;
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~2048;
    }
  }
  ((V *)Rv1)[34]=F_uobj;
  Ra.sl[6]=553; /* line # 553 */
  if (F_ucbf!=NULL) ((V *)Rv1)[33]=F_ucbf;
  else((V *)Rv1)[33]=Ri.v[1];
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
  if (F_fact&&V_src_control!=NULL) P_src_active_source(F_srcp);
  Ra.sl[6]=559; /* line # 559 */
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_return "  */
C P_src_return(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+228;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=574; /* line # 574 */
  Rv0=V_src_control;
  if (Rv0!=NULL) Rv1=((V *)Rv0)[1];
  if (Rv0!=NULL&&Rv1!=NULL) {
    Ra.sl[6]=584; /* line # 584 */
    Rv2=Rv0;
    ((UL *)Rv2)[62]=((UL *)Rv2)[62]&~65536;
    Rv3=Rv1;
    ((C *)Rv3)[52]=((C *)Rv0)[52];
    Ra.sl[6]=589; /* line # 589 */
    V_src_control=Rv1;
    P_src_close(&Rv0, F_bfree);
    Ret=((C *)Rv3)[53];
  }
  else {
    Ra.sl[6]=594; /* line # 594 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SC_V2_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+240;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=606; /* line # 606 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Rv1=V_lst_current;
  if (F_bterm) Rv2=80;
  else Rv2=((SL *)Rv1)[16];
  Ra.sl[6]=611; /* line # 611 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Rv0=Rv0+1;
    if (Rv0>Rv2) {
      Ra.sl[6]=616; /* line # 616 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      if (!F_bterm) ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[6]=622; /* line # 622 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SC_V2_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+259;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=635; /* line # 635 */
  Rv0=V_src_control;
  if (V_src_lstinsnb!=((SL *)Rv0)[6]) {
    V_src_lstinsnb=((SL *)Rv0)[6];
    Ra.sl[6]=640; /* line # 640 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[6],5,0);
  }
  else {
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[54]);
  PAS__WRITE_CHAR(((C *)Rv0)[55]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[6]=645; /* line # 645 */
  Rv1=((V *)Rv0)[32];
  Rv2=V_lst_current;
  if (F_bterm) Rv3=80;
  else Rv3=((SL *)Rv2)[16];
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[6]=650; /* line # 650 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Rv4=20;
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=655; /* line # 655 */
      Rv4=Rv4+1;
      if (Rv4>Rv3) {
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        if (!F_bterm) ((SL *)Rv2)[12]=((SL *)Rv2)[12]+1;
        Ra.sl[6]=660; /* line # 660 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=666; /* line # 666 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[32],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SC_V2_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+272;
  Ra.v[35]=Rd.s+13;
  Ra.sl[72]=685; /* line # 685 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.ub[1]=Ra.ub[0];
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[72]=691; /* line # 691 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[11]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Rv5=(((S *)Rv0)+Rv4*24+32);
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  if (((UB *)((V *)Rv0)[32])[1]>((SL *)Rv0)[12]) {
    Ra.sl[72]=698; /* line # 698 */
    Rv6=((SL *)Rv0)[12]+1;
    for( Rf0=(((UB *)((V *)Rv0)[32])[1]+1)-(((SL *)Rv0)[12]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.ub[1]=((UB *)((V *)Rv0)[32])[1];
  }
  else Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[9]*6+8];
  Ra.sl[72]=703; /* line # 703 */
  BASIC_SC_V2_src_out_text_line(F_f,Ra.s,F_bterm);
  if (F_bterm) {
    P_lst_newline();
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
  }
  Ra.sl[72]=709; /* line # 709 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+291,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],5,0);
  PAS__WRITE_EOLN();
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+333,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+292,((V *)Rv0)[33]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SC_V2_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+351;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=718; /* line # 718 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if ((1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7])&&!(64&((UB *)Rv1)[72])
  ) {
    Ra.sl[6]=723; /* line # 723 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
    BASIC_SC_V2_src_outerr_banner(((V *)Rv1)+10,0);
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=728; /* line # 728 */
      P_lst_newline();
      ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      P_err_display(((V *)Rv1)+10,Rv2,(((S *)Rv0)+Rv2*24+32));
      Rv2++;
    }
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[10]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=734; /* line # 734 */
  if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) {
    if (!F_bmac) BASIC_SC_V2_src_outline(&PAS__f_output,1);
    BASIC_SC_V2_src_outerr_banner(&PAS__f_output,1);
    Rv3=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=739; /* line # 739 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*24+32));
      Rv3++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[6]=744; /* line # 744 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*3+6));
    Rv4++;
  }
  if (Ri.sl[4]>V_src_maxerror) {
    Ra.sl[6]=749; /* line # 749 */
    P_lst_newline();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+366,-1,-1,32);
    PAS__WRITE_INT(V_src_maxerror,0,0);
    PAS__WRITE_STR(Rd.s+402,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+456;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=760; /* line # 760 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (((SL *)Rv0)[9]>0) {
    if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) (*F_out_mac_line)(&PAS__f_output,1);
    BASIC_SC_V2_src_out_error(1);
    Ra.sl[6]=765; /* line # 765 */
    ((SL *)Rv0)[9]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+475;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=781; /* line # 781 */
  Rv0=V_src_control;
  if (((SL *)Rv0)[4]<((SL *)Rv0)[11]) ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  else {
    if (((SL *)Rv0)[4]>((SL *)Rv0)[12]) ((SL *)Rv0)[4]=((SL *)Rv0)[12];
  }
  Ra.sl[6]=787; /* line # 787 */
  if (((SL *)Rv0)[9]>=8) {
    ((SL *)Rv0)[9]=8;
    Rv1=0;
  }
  else {
    Ra.sl[6]=793; /* line # 793 */
    Rv1=1;
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      if (((SL *)Rv0)[4]==((SL *)Rv0)[Rv2*6+8]) Rv1=0;
      Rv2++;
    }
    if (Rv1) ((SL *)Rv0)[9]=((SL *)Rv0)[9]+1;
  }
  Ra.sl[6]=799; /* line # 799 */
  if (Rv1) {
    Rv3=(((S *)Rv0)+((SL *)Rv0)[9]*24+32);
    ((SL *)Rv3)[0]=((SL *)Rv0)[4];
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[6]=804; /* line # 804 */
    ((SL *)Rv3)[1]=F_number;
    ((UB *)Rv3)[8]=F_severity;
    memcpy(Rv3+9,Ra.s+28,4);
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[9]*24+32));
  }
  else {
    Ra.sl[6]=811; /* line # 811 */
    if (((UB *)Rv0)[((SL *)Rv0)[9]*24+40]<F_severity) ((UB *)Rv0)[((SL *)Rv0)[9]
    *24+40]=F_severity;
  }
  if (!(32768&((UL *)Rv0)[62]||PAS__TTY_FILE(((V *)Rv0)[33]))) {
    if (PAS__EOF(((V *)Rv0)[33])) BASIC_SC_V2_src_out_error(0);
  }
  Ra.sl[6]=816; /* line # 816 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  if (F_severity>1) Ri.sl[4]=Ri.sl[4]+1;
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+486;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=840; /* line # 840 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[6]=845; /* line # 845 */
  ((UB *)Rv0)[1]=0;
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    if (Rv2==9) while (1){
      Ra.sl[6]=851; /* line # 851 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      if (Rv2>=32) {
        Ra.sl[6]=856; /* line # 856 */
        if (((UB *)Rv0)[1]<255) {
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[6]=861; /* line # 861 */
          ((UL *)Rv1)[62]=((UL *)Rv1)[62]|256;
        }
      }
    }
  }
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|8192;
  else {
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  ((SL *)Rv1)[10]=((SL *)Rv1)[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+505;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=875; /* line # 875 */
  if (F_pstr!=NULL) {
    Rv0=V_src_control;
    if (8&((UL *)Rv0)[62]) {
      Ra.sl[6]=880; /* line # 880 */
      PAS__SELECT_OUT(((V *)Rv0)[34]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SC_V2_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+521;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=891; /* line # 891 */
  Rv0=V_src_control;
  ((SL *)Rv0)[5]=((SL *)Rv0)[11]-1;
  ((SL *)Rv0)[9]=0;
  Ra.sl[6]=896; /* line # 896 */
  if (32768&((UL *)Rv0)[62]) {
    if (((V *)Rv0)[33]!=NULL) ((V *)Rv0)[32]=(*(Re0)((V *)Rv0)[33])(((V *)Rv0)[34]
    );
    ((SL *)Rv0)[10]=((SL *)Rv0)[10]+1;
  }
  else {
    Ra.sl[6]=905; /* line # 905 */
    if (8&((UL *)Rv0)[62]) P_src_put_prompt(((V *)Rv0)[35]);
    P_src_get_inputline(((V *)Rv0)+33,((V *)Rv0)+32);
    if (32&((UL *)Rv0)[62]) {
      Ra.sl[6]=910; /* line # 910 */
      if (8&((UL *)Rv0)[62]) P_lst_put_string(((V *)Rv0)[35]);
      P_lst_put_string(((V *)Rv0)[32]);
      P_lst_eoln();
    }
  }
  Ra.sl[6]=915; /* line # 915 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+535;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=926; /* line # 926 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  if (256&((UL *)Rv0)[62]) {
    Ra.sl[6]=931; /* line # 931 */
    ((SL *)Rv0)[4]=((SL *)Rv0)[12]-1;
    P_src_error(Rd.s+554,1,2);
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~256;
  }
  if (1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7]) {
    if (!(64&((UB *)Rv1)[72])) {
      Ra.sl[6]=938; /* line # 938 */
      P_lst_newline();
      BASIC_SC_V2_src_outline(((V *)Rv1)+10,0);
    }
  }
  if (((SL *)Rv0)[9]>0) BASIC_SC_V2_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SC_V2_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+558;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=952; /* line # 952 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  while (!(8192&((UL *)Rv0)[62])&&2048&((UL *)Rv0)[62]){
    Ra.sl[6]=959; /* line # 959 */
    if (((SL *)Rv0)[10]>0&&!(1048576&((UL *)Rv0)[62])) P_src_end_of_line();
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~1050624;
    BASIC_SC_V2_src_get_line();
    Ra.sl[6]=965; /* line # 965 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|512;
    if (((C *)Rv0)[54]!=67) {
      Rs.c[0]=((C *)Rv0)[54];
      ((C *)Rv0)[54]=67;
    }
  }
  if (!(8192&((UL *)Rv0)[62])) {
    Ra.sl[6]=970; /* line # 970 */
    if (((SL *)Rv0)[5]>=((SL *)Rv0)[12]||((SL *)Rv0)[5]>=((UB *)Rv1)[1]) {
      if (1048576&((UL *)Rv0)[62]&&((SL *)Rv0)[10]>0) P_src_end_of_line();
      if ((525312&((UL *)Rv0)[62])!=0) {
        Ra.sl[6]=975; /* line # 975 */
        Rv2=1;
      }
      else Rv2=32;
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|2048;
    }
    else {
      Ra.sl[6]=980; /* line # 980 */
      ((SL *)Rv0)[5]=((SL *)Rv0)[5]+1;
      Rv2=((C *)Rv1)[((SL *)Rv0)[5]+1];
    }
  }
  else {
    Ra.sl[6]=988; /* line # 988 */
    if (65536&((UL *)Rv0)[62]&&((V *)Rv0)[1]!=NULL) Rv2=P_src_return(!(131072&((
    UL *)Rv0)[62]));
    else {
      Ra.sl[6]=1000; /* line # 1000 */
      Rv2=4;
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|4096;
    }
  }
  Ra.sl[6]=1005; /* line # 1005 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SC_V2_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+572;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1017; /* line # 1017 */
  Rv0=0;
  Rv1=V_src_control;
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|1024;
  Ra.sl[6]=1022; /* line # 1022 */
  Rv2=((UB *)Rv1)[252];
  ((UB *)Rv1)[252]=4;
  while (1){
    while (1){
      Rv3=BASIC_SC_V2_src_get_char();
      if ((Rv3==4||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[6]=1028; /* line # 1028 */
    switch (Rv2) {
      case 0:Rv0=F_stp==125&&Rv3==F_stp||Rv3==4;
      if (F_stp==42&&Rv3!=4) {
        Ra.sl[6]=1034; /* line # 1034 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) {
          Rv0=((C *)((V *)Rv1)[32])[(((SL *)Rv1)[5]+1)+1]==41;
          if (Rv0) Rv3=BASIC_SC_V2_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[6]=1043; /* line # 1043 */
      if (Rv3!=4) {
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) Rv3=BASIC_SC_V2_src_get_char();
        Rv0=Rv3==47;
      }
      else Rv0=1;
      break;
      case 2:
      case 3:
      case 4:Ra.sl[6]=1052; /* line # 1052 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[6]=1057; /* line # 1057 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~1024;
  ((UB *)Rv1)[252]=Rv2;
  if (Rv3!=4) {
    if (Rv3==1&&!(524288&((UL *)Rv1)[62])||Rv3>1) {
      Ra.sl[6]=1062; /* line # 1062 */
      Rv3=32;
    }
  }
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+586;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1078; /* line # 1078 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Rv2=BASIC_SC_V2_src_get_char();
  switch (((UB *)Rv0)[252]) {
    case 0:Ra.sl[6]=1084; /* line # 1084 */
    if (Rv2==123) Rv2=BASIC_SC_V2_skip_comment(125,0);
    else {
      if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
          Rv2=BASIC_SC_V2_src_get_char();
          Ra.sl[6]=1089; /* line # 1089 */
          Rv2=BASIC_SC_V2_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=1094; /* line # 1094 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
        Rv2=BASIC_SC_V2_src_get_char();
        Rv2=BASIC_SC_V2_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[6]=1101; /* line # 1101 */
    if (Rv2==59) Rv2=BASIC_SC_V2_skip_comment(59,1);
    break;
    case 2:if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==45) {
        Ra.sl[6]=1106; /* line # 1106 */
        Rv2=BASIC_SC_V2_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[6]=1111; /* line # 1111 */
    break;
  }
  if (512&((UL *)Rv0)[62]) {
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[6]=1116; /* line # 1116 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~512;
      if (((C *)Rv0)[54]==67) ((C *)Rv0)[54]=Rs.c[0];
    }
  }
  ((C *)Rv0)[52]=((C *)Rv0)[53];
  Ra.sl[6]=1121; /* line # 1121 */
  ((C *)Rv0)[53]=Rv2;
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+598;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1136; /* line # 1136 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  if (((SL *)Rv0)[5]>=((UB *)Rv1)[1]||((SL *)Rv0)[5]>=((SL *)Rv0)[12]) Ret=32;
  else Ret=((C *)Rv1)[(((SL *)Rv0)[5]+1)+1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_set_flags "  */
void P_src_set_flags(UL F_flg, UB F_fclr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+613;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1153; /* line # 1153 */
  Rv0=V_src_control;
  if (F_fclr) ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~F_flg;
  else((UL *)Rv0)[62]=((UL *)Rv0)[62]|F_flg;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+628;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1174; /* line # 1174 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Rv0=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv0]=0;
    Rv0++;
  }
  V_error_result=0;
  Ra.sl[6]=1179; /* line # 1179 */
  V_src_control=NULL;
  if (((UB *)F_def_src)[1]>0) V_src_control=P_src_file_open(F_def_src,0,NULL);
  if (V_src_openerr==0) {
    Rv1=V_src_control;
    Ra.sl[6]=1185; /* line # 1185 */
    ((SL *)Rv1)[7]=1;
    ((SL *)Rv1)[8]=1;
  }
  else V_src_control=NULL;
  V_src_hde=V_src_control;
  Ra.sl[6]=1190; /* line # 1190 */
  V_src_cont_base=V_src_control;
  Ri.sl[4]=0;
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}
