{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*            - - -  Source Read  Manager Library  - - -                 *
*                                                                       *
*           - - -   version 2.0-A  -- 31/08/2016   - - -                *
*                                                                       *
*                       For C-Pascal  3.1-B3                            *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
[inherit ('LIB:BASIC_ENV_STR',                  { String manager def. }
          'LIB:BASIC_ENV_TXF',                  { Text file manager def. }
          'LIB:BASIC_ENV_LST',                  { List file manager def. }
          'LIB:BASIC_ENV_SRC')]                 { SRC file manager def. }
*)
module BASIC_SRC_V2;                            { Use input and output }




%include 'pasenv:cpas_b__v2src_env';


{ ****************************  Begin of PASCAL System Code Section  **************************** }

%pragma code_option (c_interface,               { To authorize the use of "standard" keyword }
    c_code '#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc',
    c_code '#define _FILE_CLEAR(fdst) fdst = NULL'
  );


  procedure DUPLICATE_FILE( f1, f2: $wild_file ); standard '_FILE_DUPLICATE';
  procedure CLEAR_FILE( f: $wild_file ); standard '_FILE_CLEAR';

%pragma code_option noc_interface;              { To disable usage of "standard" keyword }

{ *****************************  End of PASCAL System Code Section  ***************************** }




const
  mac_exp_incr         =          1024; { Macro expanssion text allocation increment }


type

  mac_exp_text(size: integer) = record  { * Define the macro expanssion text buffer record * }
    length,                             { Current buffer used length }
    smbidx:                    integer; { Current macro symbol index in the buffer }
    mtext:      array[1..size] of char  { The macro expanssion text buffer }
  end;

  mac_exp_ptr          = ^mac_exp_text; { Define the macro expanssion text pointer }




[global]
var
  def_prompt:           str_ptr := nil; { Default prompt }

  src_openerr,                          { Source open error code as set by SRC_OPEN_FILE }
  src_maxerror,                         { Maximum number of error before compiler stop }
  src_lstinsnb:         integer :=   0; { Last instruction number }

  src_control,                          { Current source file pointer }
  src_cont_base,                        { Basis source file pointer }

  src_hde:              src_ptr := nil; { Used source list header }

  src_listing:          lst_ptr := nil; { Listing and error source file pointer }



var
  mac_exp:      mac_exp_ptr    :=  nil; { Macro expanssion text pointer }

  maccb_ptr:    src_callback   :=  nil; { Default is no callback for macro }

  src_errorcnt: integer        :=    0; { Count of error in source file }

  fchcd_sav:                      char; { To save the current src_fchcd first listing flag character }





procedure BACK_TRACING( var f: text ); external 'PAS__BACK_TRACING';




{********************************************************}
{***********    Source Managment Routines    ************}
{********************************************************}



procedure SRC_MEXPEND( ch: char );
{ Routine to create or expand the macro output text pack.
}
var
  p: mac_exp_ptr;

begin { SRC_MEXPEND }
  if mac_exp = nil then
  begin
    NEW( mac_exp, mac_exp_incr );
    with mac_exp^ do
    begin  length := 0; smbidx := 0  end
  end
  else
    if mac_exp^.size <= mac_exp^.length then
    begin
      with mac_exp^ do
      begin
        NEW( p, size+mac_exp_incr );
        p^.length := length;
        p^.smbidx := smbidx;
        for ii := 1 to length do  p^.mtext[ii] := mtext[ii];
      end;
      DISPOSE( mac_exp );
      mac_exp := p
    end;

  with mac_exp^ do
  begin  length := length + 1; mtext[length] := ch  end
end SRC_MEXPEND;



procedure SRC_R_INIT( p: src_ptr; macflg: boolean := false );
{ Routine to initialize a source file/macro context record.
}
begin { SRC_R_INIT }
  if p <> nil then
  with p^ do
  begin
    { *** src_next is never initialized here *** }
    src_next            :=     src_hde;         { Link in the used source file list };
    src_previous        :=         nil;         { No previous source until showed otherwise }
    src_wchpt           :=           0;         { Clear the Word pointer in src_cmdline }
    src_chidx           :=           0;         { Character pointer to begin of line }
    src_insnb           :=           0;         { Clear instruction count }
    src_level           :=           0;         { Clear source level }
    src_lstmxlev        :=           0;         { Clear Source listing level }
    src_errnb           :=           0;         { Clear number of error in the current line }
    src_linenbr         :=           0;         { Clear line number in this file }
    src_frspos          :=           1;         { First valid column to use set to first column }
    src_lstpos          :=         255;         { Last valid column to use at maximum }
    src_prvchar         := src_ch_null;         { Set the Previous and current source character ... }
    src_curchar         := src_ch_eoln;         { ... to be our NULL and EOLN mark characters. }
    if macflg then src_fchcd    := 'M'          { Set the flag code characters to be "M3 for macro source file }
              else src_fchcd    := ' ';         { Set the flag code characters to be spaces for real source file }
    src_schcd           :=         ' ';
    for i := 1 to src_maxerrline do             { Set message table to empty, Source status flag set, ... }
      src_coltb[i].err_msg  :=     nil;         { ... Input used, and error echo. }

    if not macflg then
    begin                                       { We want a real source file ... }
      if src_macro in src_flags then            { ... but we have an old macro source file record. }
      begin
        src_cmdline     :=         nil;         { We do not destroy the old macro text }
        src_mobject     :=         nil;         { We must destroy the macro object link => nil -> src_prompt }
        src_usrcb       :=         nil          { Clear of the call back user routine pointer. }
      end;
      src_flags := [src_bterminal, src_echerr, src_eoln];
      src_commentty     :=      src_pascomment; { Default to pascal comment mode }
      if src_cmdline = nil then NEW( src_cmdline, 255 );
      src_cmdline^.length       :=           0; { Set the source input line to empty }
      if src_prompt <> nil then
      begin  DISPOSE( src_prompt ); src_prompt := nil  end
    end
    else
    begin                                       { We want a macro source file ... }
      if not (src_macro in src_flags) then      { ... but we have an old real source file record }
      begin
        if src_cmdline <> nil then DISPOSE( src_cmdline );
        if src_prompt <> nil then DISPOSE( src_prompt )
      end;
      src_flags := [src_macro, src_echerr, src_eoln];
      src_commentty     :=       src_nocomment;
      src_cmdline       :=                 nil; { Initialization without Macro text }
      src_usrcb         :=                 nil; { Clear macro call back routine pointer (and Pascal file variables), ... }
      src_mobject       :=                 nil; { ... also initialize the user macro object pointer and ... }
      src_macidx        :=                   0  { ... the macro index }
    end
  end;
  src_hde := p                                  { Link this Source file in the source list }
end SRC_R_INIT;



function SRC_ALLOCATE: src_ptr;
{ Procedure to allocate a source file/macro context record,
  return the new file context record address.
}
var
  ps: src_ptr;

begin { SRC_ALLOCATE }
  NEW( ps );
  with ps^ do
  begin
    src_flags          :=  [src_macro];         { Must be initialized before call SRC_R_INIT }
    src_cmdline        :=          nil;         { No string allocation and SRC_R_INIT will perform ... }
    src_prompt         :=          nil;         { ... the Pascal files clear for Real source file. }
  end;
  SRC_ALLOCATE := ps
end SRC_ALLOCATE;



[global]
procedure SRC_FREE( var p: src_ptr );
{ Procedure to free an unused source file/macro context record.
}
var
  p1, p2: src_ptr;

begin { SRC_FREE }
  p2 := nil; 
  if p <> nil then
  begin
    p1 := src_hde;                              { Init for used file search }
    while (p1 <> p) and (p1 <> nil) do
    begin                                       { Localize the file to de-allocate }
      p2 := p1; p1 := p1^.src_next
    end
  end else p1 := nil;
  if p1 <> nil then                             { Found file }
  begin
    with p^ do
    begin
      if not (src_macro in src_flags) then
      begin
        if src_cmdline <> nil then DISPOSE( src_cmdline );
        if src_prompt  <> nil then DISPOSE( src_prompt )
      end;
      { Put out from the file context from used list }
      if p2 = nil then src_hde := src_next
                  else p2^.src_next := src_next
    end;
    DISPOSE( p );
    p := nil
  end
end SRC_FREE;



[global]
procedure SRC_CLOSE( var p: src_ptr; bfree: boolean );
{ Close a source file/macro, if bfree then the source
  file/macro context record is free.
}
var
  disp: flags_file;

begin { SRC_CLOSE }
  if p <> nil then
  begin
    with p^ do
    begin
      if src_fopen in src_flags then
      begin                             { Close text file and delete if required }
        if src_macro in src_flags then
        begin                           { Performe a formal close of the Macro source file }
          src_cmdline := nil;
          src_mobject := nil;
          src_usrcb   := nil
        end
        else
        begin
          if src_delete in src_flags then disp := [del_file]
                                     else disp := [];
          CLOSE( src_file, disp )        { The free is always };
          if src_bterminal in src_flags then CLOSE( src_promptf );
          if src_prompt <> nil then
          begin
            DISPOSE( src_prompt ); src_prompt := nil
          end
        end;
        if (src_previous <> nil) and (src_control = p) then
        begin
          src_control := src_previous
        end;
        src_flags := src_flags - [src_fopen]
      end
    end;
    if bfree then SRC_FREE( p )
  end
end SRC_CLOSE;



[global]
function  SRC_FILE_OPEN( in_var   fspc:                 string; { File specification }
                                  bdel: boolean     :=   false; { When true the source file will be deleted on close time }
                                  srcp: src_ptr     :=     nil  { Source file structure pointer (to use a preallocated one) }
                       ): src_ptr;
{ Open a real source file (not a memory macro file) :
  p        is the pointer of a previous source context that can be re-used
           when it is opened, it will be closed before to open the new source file,
  fspc     is the file specification (with absolute or relative path),
  bdel     If it is true, the new source file will be deleted on the close time.
  
  On any open error, SRC_OPEN_FILE return nil and src_openerr is the Open File error code,
  else (on open file Success) src_open allocate the source context if p = nil 
  and close a previously opened file. SRC_OPEN_FILE return the pointer of the new source file context.
}
var
  ballocated:  boolean;

begin { SRC_OPEN_FILE }
  src_openerr := 0;
  if srcp = nil then
  begin
    ballocated := false;
    srcp := SRC_ALLOCATE
  end
  else                                          { Already allocated }
  begin
    ballocated := true;
    SRC_CLOSE( srcp, false )                    { Can be opened }
  end;
  SRC_R_INIT( srcp, false );                    { Initialize the record for a real source file }
  
  with srcp^ do
  begin
    if fspc.length = 0 then                     { The zero length file specification => standard input file. }
    begin
      DUPLICATE_FILE( src_file, input );        { We use the standard input descriptor }
      src_flags := src_flags + [src_stdin];
      iostatus := 0                             { Force the Success Open Status }
    end
    else OPEN( src_file, fspc, [read_file,error_file] + lst_spc_mode ); { Open the specified file }

    if iostatus = 0 then                        { Success }
    begin
      { Set terminal mode if open on terminal }
      src_flags := src_flags - [src_bterminal];
      if TTY_FILE( src_file ) then
      begin
        if fspc.length = 0 then
        begin
          DUPLICATE_FILE( src_promptf, output );{ We use the standard input descriptor }
          iostatus := 0                         { Force the Success Open Status }
        end
        else OPEN( src_promptf, fspc, [write_file,error_file] );
        if iostatus <> 0 then
        begin
          src_openerr := iostatus; CLOSE( src_file )
        end
        else
        begin { The prompt file is opened, we set the prompt stri,ng default }
          NEW( src_prompt, 63 );
          src_prompt^ := def_prompt^;           { We set the default prompt }
          src_flags := src_flags + [src_bterminal,src_fopen]
        end
      end
      else { Success on not a terminal file, => it is a disk file }
      begin
        if bdel then src_flags := src_flags + [src_delete];
        src_flags := src_flags + [src_fopen]     { Mark the source file as opened }
      end
    end
    else src_openerr := iostatus;
    if src_openerr <> 0 then
      if ballocated then SRC_R_INIT( srcp )
                    else SRC_FREE( srcp )
  end;
  SRC_FILE_OPEN := srcp
end SRC_FILE_OPEN;



[global]
procedure SRC_NEW_SOURCE( in_var  fspc:                 string; { File specificatrion of the new source }
                                  binc: boolean     :=    true; { True: Include the source file, False: new source replace the old one }
                                  bdel: boolean     :=   false  { Delete the new source on the close time }
                       );
{ Open a NEW real source file with automatic link with the presently opened (and selected) source.
  binc      Is true, the new source file is opened as an included file and an
            automatic return is to the previous source is done on the EOF of the new source.
            If binc is false, the previous source is closed and the new one is readden as
            the continuation of the previous one.
  bdel      If true, the new dource file will be deleted on its close time.
}
var
  ierr:        integer;
  srcp:        src_ptr;

begin
  srcp := SRC_FILE_OPEN( fspc, bdel );
  if src_openerr = 0 then
  with srcp^ do
  begin
    src_level  := src_control^.src_level;       { The file include level is set, but ... }
    if binc then src_level := src_level + 1;    { ... must be incremented for an include. }
    src_lstmxlev := src_control^.src_lstmxlev;  { The other characteristics are inherit from ... }
    src_insnb  := src_control^.src_insnb;       { ... the previous source file. }
    src_frspos := src_control^.src_frspos;
    src_lstpos := src_control^.src_lstpos;
    src_flags  := src_flags +
                  src_control^.src_flags * [src_blist,src_bmacroex,src_bphys,src_becho,src_echerr];
    if binc then
    begin
      src_previous := src_control;              { Link the file to the previous src. }
      src_control  := srcp                      { Select the new source file for input } 
    end
    else
    begin
      src_previous := src_control^.src_previous;{ Set the previous source as the previous of old source file }
      SRC_CLOSE( srcp, bdel );                  { Close the old source file }
      src_control := srcp                       { The new source is now selected for input }
    end
  end
end SRC_NEW_SOURCE;



[global]
procedure SRC_ACTIVE_SOURCE( srcp: src_ptr );
{ Procedure to link and activate the source file (or macro) p^
  as the current source file with an automatic return to The
  previous one when an src_eof character is read by SRC_INSCHAR.
}
begin
  if (srcp <> nil) and (src_control <> nil) then
  begin
    with src_control^ do
    begin
(*
WRITELN( 'prev = "', src_prvchar, '", cur = "', src_curchar, '".' );
*)
      src_flags   := src_flags + [src_autopch]  { Repeat the previous read character on return }
    end;
    with srcp^ do
    begin
      src_previous :=              src_control; { Link to current source file (becomes parent source file) }
      src_insnb    :=   src_control^.src_insnb; { Start from the current instruction count }
      src_level    :=   src_control^.src_level; { Set as the same listing level ... }
      src_lstmxlev :=                src_level; { ... and the same maximum listing level. }
      src_prvchar  :=              src_ch_null; { We have no previous character before to read its first one. }
      src_curchar  := src_control^.src_prvchar; { Get the last read char from the previous source context. }
      src_flags    := src_flags + [src_autoret] { Set marker to reread at the return of macroSet the auto return mode for the end of Macro code }
     end;
    src_control   :=                      srcp  { Now the new control source file is our macro source. }
(*
; with p^ do
WRITELN( ' Macro Source is "', p^.src_cmdline^, '" ', src_frspos:0, ' ', src_lstpos:0 )
*)
  end
end SRC_ACTIVE_SOURCE;



[global]
procedure SRC_SET_MACRO_CB( function CALL_BACK( mp: $wild_pointer ): str_ptr );
begin
  maccb_ptr := src_callback[CALL_BACK]
end SRC_SET_MACRO_CB;



[global]
procedure SRC_DEL_MACRO_CB;
begin
  maccb_ptr := nil
end SRC_DEL_MACRO_CB;



[global]
function SRC_MACRO_OPEN( mtxt:                 str_ptr; { First Macro text pointer }
                         ucbf: src_callback     := nil; { User call back function for macro process }
                         uobj: $wild_pointer    := nil; { User remated macro obeject pointer }
                         fact: boolean  :=        true; { To activate as sub-source of previous source }
                         srcp: src_ptr  :=         nil  { Source file structure pointer (to use a preallocated one) }
                       ): src_ptr;
{ Open a macro source file :
  p is the pointer of the newsource context, txt is the initial source
  line, p1 and p2 are some user free pointer that can be used to specify
  some dat to the user procedure VSR_NEXTSTRING. These pointer are
  respectively stored in the record fields src_mptr_1 and src_mptr_2.
}
var
  
  ballocated: boolean;

begin
  if srcp = nil then
  begin
    ballocated := false;
    srcp := SRC_ALLOCATE
  end
  else                                          { Already allocated }
  begin
    ballocated := true;
    SRC_CLOSE( srcp, false )                    { Can be opened }
  end;
  SRC_R_INIT( srcp, true );                     { Initialize the record for a macro source file }
  with srcp^ do
  begin
    if mtxt <> nil then
    begin
      src_cmdline := mtxt;                      { Set the text line and ... }
      src_lstpos  := mtxt^.length;              { ... adapt the last legal position to the string length. }
      if src_lstpos > 0 then                    { When a first line is provided, ... }
      begin
        src_curchar := src_ch_null;             { Set this character to be ignored }
        src_flags   := src_flags - [src_eoln]   { when the first line is provided, we must clear EOLN }
      end
    end;
    src_mobject     :=                    uobj; { Set the macro object address }
    if ucbf <> nil then src_usrcb :=      ucbf  { Set the first and list macro list (if used) }
                   else src_usrcb := maccb_ptr;
    src_flags       := src_flags + [src_fopen]; { Set the macro source file as opened. }
    if fact and src_control <> nil then         { When the auto-link to context is required ... }
      SRC_ACTIVE_SOURCE( srcp )                 { ... we link and activate it. }
  end;
  SRC_MACRO_OPEN := srcp
end SRC_MACRO_OPEN;



[global]
function SRC_RETURN( bfree: boolean ): char;
{ This routine must be called to return from Macro source,
  to the parent source file. 
}
var
  p, q:      src_ptr;

begin
(* WRITELN( ' M Return.' ); *)
  p := src_control;
  if p <> nil then q := p^.src_previous;
  if (p <> nil) and (q <> nil) then
  begin
(*
with q^ do
begin
  WRITELN( ' Parent : prv = "', src_prvchar, '", cur = "', src_curchar, '", lvl = ', src_level:2, ', EOF = ', src_eof in src_flags );
end;
*)
    with p^ do
      src_flags := src_flags - [src_autoret];
    with q^ do
    begin { Update the parent source file }
      src_prvchar := p^.src_prvchar;    { Put the previous character from the current source. }
      src_control := q;                 { The parent source file is set at the current one. }
      SRC_CLOSE( p, bfree );            { Close the finished source file (optional free). }
      SRC_RETURN  := src_curchar        { Return the current character as returned by SRC_INCHAR ... }
    end
  end
  else SRC_RETURN := src_ch_null
end SRC_RETURN;



procedure SRC_OUT_TEXT_LINE( var f: text; var st: string; bterm: boolean );
{ To output a line of text to the Listing file.
}
var
  i, j, lim: integer;

begin { SRC_OUT_TEXT_LINE }
  WRITE( f, ' ':20 ); j := 20;
  with st, lst_current^ do
  begin
    if bterm then lim := 80
             else lim := lst_lnsize;
    for i := 1 to length do
    begin
      j := j + 1;
      if j > lim then
      begin
        WRITELN( f );
        if not bterm then lst_lncnt := SUCC( lst_lncnt );
        j := 20; WRITE( f, ' ':20 )
      end;
      WRITE( f, body[i] )
    end;
    WRITELN( f )
  end
end SRC_OUT_TEXT_LINE;



procedure SRC_OUTLINE( var f: text; bterm: boolean );
{ Basic procedure to output a listing.
}
var
  i, j, maxline: integer;

begin { SRC_OUTLINE }
  with src_control^ do
  begin
    if src_lstinsnb <> src_insnb then
    begin
      src_lstinsnb := src_insnb;
      WRITE( f, ' ', src_insnb:5 )
    end
    else WRITE( f, ' ':6 );                     { Output the statement number if changed }
    { Show level of source }
    WRITE( f, ' ', src_fchcd, src_schcd, ' ', src_level:3, ' ' );
    with src_cmdline^, lst_current^ do
    begin
      if bterm then maxline := 80
               else maxline := lst_lnsize;
      WRITE( f, src_linenbr:4, ' ':2 );
      if length > (maxline - 20) then
      begin
        j := 20;
        for i := 1 to length do
        begin
          j := j + 1;
          if j > maxline then
          begin
            WRITELN( f );
            if not bterm then lst_lncnt := SUCC( lst_lncnt );
            j := 20; WRITE( f, ' ':20 )
          end;
          WRITE( f, body[i] )
        end;
        WRITELN( f )
      end
      else  WRITELN( f, src_cmdline )
    end
  end
end SRC_OUTLINE;



{******************************************************}
{*********    Error managment procedures  *************}
{******************************************************}


procedure SRC_OUTERR_BANNER( var f: text; bterm: boolean );
{ Output error locator banner line on specified text file.
}
var
  sbanner: string( 255 );

begin { SRC_OUTERR_BANNER }
  with src_control^, lst_current^, sbanner do
  begin
    length := capacity;
    for i := 1 to length do body[i] := '_';     { Marked as visible line }
    { Mark in shadding the unusable column }
    { S_USE must be lower than lst_lnsize or 80 (if bterm is true ) }
    for i := 1 to src_frspos - 1 do body[i] := '\';
    for i := 1 to src_errnb do                  { For each error entry }
    with src_coltb[i] do
      body[err_pos] := CHR( ORD( '0' ) + i )    { Set error index };
    if src_cmdline^.length > src_lstpos then
    begin
      { Mark in shadding the unusable column }
      for i := src_lstpos+1 to src_cmdline^.length do body[i] :='\';
      length := src_cmdline^.length
    end
      else length := src_coltb[src_errnb].err_pos;
    { Now output banner line }
    SRC_OUT_TEXT_LINE( f, sbanner, bterm );
    if bterm then
    begin
      LST_NEWLINE;
      lst_lncnt := SUCC( lst_lncnt )
    end;
    WRITELN( f, ' %*+*+* error(s) was detected at line # ', src_linenbr:5 );
    WRITELN( f, ' in the file : "', FILE_SPECIFICATION( src_file ), '"' )
  end
end SRC_OUTERR_BANNER;



procedure SRC_OUT_ERROR( bmac: boolean := false );
begin { SRC_OUT_ERROR }
  with src_control^, lst_current^ do
  begin
    if (src_blist in src_flags) and (src_lstmxlev >= src_level) and
       (not (lstf_virtual in lst_flagsw)) then
    begin
      lst_lncnt := SUCC( lst_lncnt );           { Skip to next line without page skip }
      { Output banner locator line }
      SRC_OUTERR_BANNER( lst_file, false );
      for i := 1 to src_errnb do
      begin
        LST_NEWLINE;
        lst_lncnt := SUCC( lst_lncnt );         { To allocate two lines }
        ERR_DISPLAY( lst_file, i, src_coltb[i] )
      end;
      LST_NEWLINE; WRITELN( lst_file )
    end;
    if (src_echerr in src_flags) or (lstf_virtual in lst_flagsw) then
    begin
      if not bmac then SRC_OUTLINE( output, true );
      SRC_OUTERR_BANNER( output, true );        { Output banner locator line }
      for i := 1 to src_errnb do
        ERR_DISPLAY( output, i, src_coltb[i] );
      WRITELN
    end;
    { Free all error messages }
    for i := 1 to src_errnb do
      DISPOSE( src_coltb[i].err_msg )
  end;
  if src_errorcnt > src_maxerror then
  with lst_current^ do
  begin
    LST_NEWLINE;
    WRITELN( ' <<< *** Maximum number of error (', src_maxerror:0, ') is reached. SRC_Library stop our Software. *** >>>' );
    PASCAL_EXIT( 4 )
  end
end SRC_OUT_ERROR;



[global]
procedure SRC_OUT_MAC_ERROR( procedure OUT_MAC_LINE( var f: text; btt: boolean ) );
begin { SRC_OUT_MAC_ERROR }
  with src_control^, lst_current^ do
    if src_errnb > 0 then
    begin
      if (src_echerr in src_flags) or (lstf_virtual in lst_flagsw) then OUT_MAC_LINE( output, true );
      SRC_OUT_ERROR( true );
      src_errnb := 0
    end
end SRC_OUT_MAC_ERROR;



[global]
procedure SRC_ERROR( modulesy:   error_mdnam;
                     number:     integer;
                     severity:   error_sev );
{ To set an error in src processing.
  Must be called for all source errors }
var
  bok: boolean;

begin { SRC_ERROR }
  with src_control^ do
  begin
    { Set position of error in the src line limits range }
    if src_wchpt < src_frspos then src_wchpt := src_frspos
    else if src_wchpt > src_lstpos then src_wchpt := src_lstpos;

    if src_errnb >= src_maxerrline then         { Max error by line reached  ? }
    begin
      src_errnb := src_maxerrline; bok := false { Ignore this error }
    end
    else
    begin
      bok := true;
      for i := 1 to src_errnb do
        if src_wchpt = src_coltb[i].err_pos then bok := false;
      if bok then src_errnb := src_errnb + 1
    end;

    if bok then
    with src_coltb[src_errnb] do
    begin
      err_pos  := src_wchpt;                    { Set word position }
      if err_pos < 1 then err_pos := 1;
      err_code := number;                       { Set error number }
      err_sv   := severity;                     { Set severity }
      err_mdn  := modulesy;                     { Set the module name }
      ERR_GETMSG( src_coltb[src_errnb] )        { Set err_msg }
    end
    { Set the last error severity }
    else
      if src_coltb[src_errnb].err_sv < severity then
        src_coltb[src_errnb].err_sv := severity;
    if not ((src_macro in src_flags) or TTY_FILE( src_file )) then
      if EOF( src_file ) then SRC_OUT_ERROR
  end;
  error_cnt[severity] := SUCC( error_cnt[severity] );
  if severity > e_warning then src_errorcnt := src_errorcnt + 1;
  if error_result < severity then error_result := severity
end SRC_ERROR;





{*******************************************************}
{*******   Input line management procedures  ***********}
{*******************************************************}


[global]
procedure SRC_GET_INPUTLINE( var f: text; var pstr: str_ptr );
{ Get a line from the specified file }
{ If btrm then terminal mode, else file mode }
{ Must not be used with a macro file }
{ Read the line with an auto-chage of tabulation character }
var
  ch: char;

begin { SRC_GET_INPUTLINE }
  if lst_current^.lst_currline^.length > 0 then LST_EOLN;

  if pstr = nil then NEW( pstr, 255 );
  with pstr^, src_control^ do
  begin
    length := 0;
    while not EOLN( f ) and not EOF( f ) do
    begin
      READ( f, ch );
      if ch = src_ch_tab then { ASCII TAB }
        repeat
          if length < 255 then length := length + 1;
          body[length] := ' '
        until (length >= 255) or (length mod 8 = 0)
      else
        if ch >= ' ' then
          if length < 255 then
          begin
            length := SUCC( length ); body[length] := ch
          end
          else
            src_flags := src_flags + [src_toolong]
    end;
    if EOF( f ) then src_flags := src_flags + [src_eof]
                else READLN( f );
    src_linenbr := SUCC( src_linenbr )
  end
end SRC_GET_INPUTLINE;



[global]
procedure SRC_PUT_PROMPT( pstr: str_ptr );
{ Generate a string output on the prompt file }
begin { SRC_PUT_PROMPT }
  if pstr <> nil then
    with src_control^ do
      if src_bterminal in src_flags then
      begin
        (*  if sys_system = systyp_vms  then WRITELN( src_promptf ); *)
        WRITE( src_promptf, pstr^ )
      end
end SRC_PUT_PROMPT;



procedure SRC_GET_LINE;
{ Procedure to get a line from the control src file, internal use only }
{ Skip the unused column, generates the prompt echo }
{ Must not be used with a macro }
begin { SRC_GET_LINE }
  with src_control^ do
  begin
    src_chidx := src_frspos-1;                  { Set to first character in the future new line }
    src_errnb := 0;                             { Set to no error in this new line }
    { Get a line sequence with prompt or echo managment }
    if src_macro in src_flags then
    begin { Virtual macro input file case }
      if src_usrcb <> nil then                  { Back call to user routine to get a new input string or EOF }
        src_cmdline := src_usrcb^( src_mobject );
      src_linenbr := SUCC( src_linenbr )
    end
    else
    begin { True input file }
      { Input from a terminal file (Associated to the prompt file) }
      if src_bterminal in src_flags then SRC_PUT_PROMPT( src_prompt );
      { Now get the input line }
      SRC_GET_INPUTLINE( src_file, src_cmdline );
      if src_becho in src_flags then            { Echo to generate }
      begin
        if src_bterminal in src_flags then LST_PUT_STRING( src_prompt^ );
        LST_PUT_STRING( src_cmdline^ );
        LST_EOLN
      end
    end;
    src_wchpt := src_frspos                     { Init word index for error message }
  end
end SRC_GET_LINE;



[global]
procedure SRC_END_OF_LINE;
{ Procedure to output a line with all appropriate error messages,
  to be called by src_inchar }
begin { SRC_END_OF_LINE }
  with src_control^, lst_current^ do
  begin
    if src_toolong in src_flags then
    begin
      { Push the too long error if possible }
      src_wchpt := src_lstpos - 1; SRC_ERROR( 'S_GL', 1, e_error );
      src_flags := src_flags - [src_toolong]
    end;
    if (src_blist in src_flags) and (src_lstmxlev >= src_level) then
    if not (lstf_virtual in lst_flagsw) then
    begin
      { Write the source line on listing }
      LST_NEWLINE;
      SRC_OUTLINE( lst_file, false )
    end;
    if src_errnb > 0 then SRC_OUT_ERROR         { Output errors };
  end
end SRC_END_OF_LINE;



function SRC_GET_CHAR: char;
var
  ch: char;

begin
  with src_control^, src_cmdline^ do
  begin
    while not (src_eof in src_flags)
          and (src_eoln in src_flags) do
    { An other source line is required }
    begin
      { Nothing to generate if first line of source file }
      if (src_linenbr > 0) and not (src_listbyline in src_flags) then
        SRC_END_OF_LINE;                        { Generate listing and error message }
      { Take off eoln for data mode };
      src_flags := src_flags - [src_eoln,src_listbyline];
      SRC_GET_LINE;                             { Get the next line }
      { Set comment flag at a begin of line }
      src_flags := src_flags + [src_commentflg];
      if src_fchcd <> 'C' then
      begin  fchcd_sav := src_fchcd; src_fchcd := 'C'  end;
    end;
    if not (src_eof in src_flags) then
      if (src_chidx >= src_lstpos) or (src_chidx >= length) then
      begin
        if (src_listbyline in src_flags) and (src_linenbr > 0) then
          SRC_END_OF_LINE;
        if [src_linemode,src_eolcomment] * src_flags <> [] then
          ch := src_ch_eoln else ch := ' ';
        src_flags := src_flags + [src_eoln]
      end
      else
      begin
        src_chidx := SUCC( src_chidx );
        ch := body[src_chidx]
(*
; if src_macro in src_flags then WRITELN( ' Macro ch = "', ch, '"' )
*)
      end
    else
    begin { EOF of the current source file }
      if (src_autoret in src_flags) and         { We must perform an auto return to the initial source }
         (src_previous <> nil) then             { A parent source must be defined }
      begin
(*     WRITELN( ' SRC_GET_CHAR lvl ', src_level:2, ',  auto source return on EOF.' ); *)
        ch := SRC_RETURN( not (src_autonfree in src_flags) )
      end
      else
      begin
(*
WRITELN( ' SRC_GET_CHAR lvl ', src_level:3, ', Sends File Eof to user.' );
BACK_TRACING( output );
*)
        ch := src_ch_eof;                       { End of file seen }
        src_flags := src_flags + [src_eofrc]
      end
    end
  end;
  SRC_GET_CHAR := ch
end SRC_GET_CHAR;



function SKIP_COMMENT( stp: char; nlmd: boolean ): char;
var
  ch, fchcd_sav:  char;
  savmode:   src_comty;
  ct:          boolean;

begin { SKIP_COMMENT }
  ct := false;
  with src_control^ do
  begin
    { If no significant character in the line set the comment flag char. }
    if nlmd then src_flags := src_flags + [src_eolcomment];
    savmode := src_commentty;
    src_commentty := src_nocomment;             { Do not proceed recursive comment }
    repeat
      repeat
        ch := SRC_GET_CHAR;
      until (ch = src_ch_eof) or (ch = stp) or (nlmd and (ch = src_ch_eoln));
      case savmode of
        src_pascomment:
          begin
            ct := ((stp = '}') and (ch = stp)) or (ch = src_ch_eof);
            if (stp = '*') and (ch <> src_ch_eof) then
            begin
              if src_chidx < src_cmdline^.length then
              begin
                ct := ( src_cmdline^.body[src_chidx + 1] = ')' );
                if ct then ch := SRC_GET_CHAR
              end
            end
          end;

        src_plicomment:
          if ch <> src_ch_eof then
          begin
            if src_chidx < src_cmdline^.length then ch := SRC_GET_CHAR;
            ct := (ch = '/')
          end else ct := true;

        src_nocomment,                          { Must never seen }

        src_adacomment,
        src_lispcomment:  ct := true;           { Always a good stop comment }

      end;

    until ct;
    if nlmd then src_flags := src_flags - [src_eolcomment];
    src_commentty := savmode;
    { All comments are equivalent to one space }
    if ch <> src_ch_eof then
      if ((ch = src_ch_eoln) and not (src_linemode in src_flags))
         or (ch > src_ch_eoln) then ch := ' ';
      
  end;
  SKIP_COMMENT := ch
end SKIP_COMMENT;



[global]
function SRC_INCHAR: char;
{ Can be used for real (terminal or other device) file or macro text,
  to get one character from input }
var
  ch: char;

begin { SRC_INCHAR }
  with src_control^, src_cmdline^ do
  begin                                         { Normal SRC_INCHAR call return a new character ... }
    ch := SRC_GET_CHAR;                         { ... from the source but skip any comments. }
    case src_commentty of

      src_pascomment:
        if ch = '{' then ch := SKIP_COMMENT( '}', false ) else
          if src_chidx < length then
            if (ch = '(') and (body[src_chidx+1] = '*' ) then
            begin
              ch := SRC_GET_CHAR;
              ch := SKIP_COMMENT( '*', false )
            end;

      src_plicomment:
        if src_chidx < length then
          if (ch = '/') and (body[src_chidx+1] = '*' ) then
          begin
            ch := SRC_GET_CHAR;
            ch := SKIP_COMMENT( '*', false )
          end;

      src_lispcomment:
        if ch = ';' then ch := SKIP_COMMENT( ';', true );

      src_adacomment:
        if src_chidx < length then
          if (ch = '-') and (body[src_chidx+1] = '-' ) then
            ch := SKIP_COMMENT( src_ch_eoln, true );

      src_nocomment:
        { Nothing to do }

    end { Case };

    if src_commentflg in src_flags then                 { When we find the first character not in some ... }
      if (ch <> ' ') and (ch > src_ch_eoln) then
      begin                                             { ...  comment(s) and this character is not a ... }
        src_flags := src_flags - [src_commentflg];
        if src_fchcd = 'C' then src_fchcd := fchcd_sav  { ...  space, we load the original flag character. }
      end;

    src_prvchar := src_curchar;                         { Keep the previous character. }
    src_curchar := ch;                                  { Keep a copy of the current character that will become  ... }
    SRC_INCHAR  := ch                                   { ... the previous one at the next SRC_INCHAR call. }
  end
(*
;WRITELN( ' SRC_INCHAR -> "', ch, '" = ', ORD( ch ):-3:8 );
*)
end SRC_INCHAR;



[global]
function SRC_NEXT_CHAR: char;
{ Function to get the next character without to change the current one.
}
begin
  with src_control^, src_cmdline^ do
    if (src_chidx >= length) or (src_chidx >= src_lstpos) then
      SRC_NEXT_CHAR := ' '
    else
      SRC_NEXT_CHAR := body[src_chidx+1]
end SRC_NEXT_CHAR;



[global]
function SRC_SEARCH_CHAR: char;
{ Function to search the first not spacing character in the current line.
}
var
  b:   boolean;
  c:      char;
  i:   integer;

begin
  with src_control^, src_cmdline^ do
  begin
    i := src_chidx;
    b := true;
    while b do
      if (i <= length) and (i<= src_lstpos) then
      begin
        c := body[i];
        if c = ' ' then i := i + 1
                   else b := false
      end
      else
      begin
        b := false;
        c := ' '
      end
  end;
  SRC_SEARCH_CHAR := c
end SRC_SEARCH_CHAR;



{********************************************************}
{*********    Common initialization routines    *********}
{********************************************************}


[global]
procedure SRC_SET_FLAGS( flg: src_flagw; fclr: boolean := false );
begin
  with src_control^ do
    if fclr then
      src_flags := src_flags - flg
    else
      src_flags := src_flags + flg;
end SRC_SET_FLAGS;



[global]
procedure SRC_INIT( in_var def_prt, def_src: string );
{ Common command source initialization routine.
  Must be called after lst_txf_st_init procedure(s).
  this call open the default listing file as current listing,
  here we assume that this current file is the output error message file.
}
var
  ierr: integer := -1;

begin { SRC_INIT }
  { Set the default prompt }
  STR_COPY_LIM( def_prompt, def_prt, 64 );
  { Initialize error sub_system }
  for error_result := e_success to e_fatal do error_cnt[error_result] := 0;
  error_result := e_success;
  { Create a source for input/ouput managment }
  src_control := nil;                           { Allocate source }
  if def_src.length > 0 then                    { Some file specification given }
    src_control := SRC_FILE_OPEN( def_src );
  if src_openerr = 0 then
    with src_control^ do
    begin
      src_level    := 1;                        { File is at level one };
      src_lstmxlev := 1                         { Set last listing level to 1 }
    end
  else src_control := nil;
  src_hde       := src_control;
  src_cont_base := src_control;
  src_errorcnt  :=           0;                 { Count of error in source file }
  src_maxerror := 31                            { Can be changed by the user }
end SRC_INIT;





end BASIC_SRC_V2.
