/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.2A0/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 656 ) = {
 11,  11, 115, 114,  99,  95, 109, 101, 120, 112, 101, 110, 100,  62,  62,  47,
104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,
 97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  50,  65,  48,  47,  99, 112,
 97, 115,  95,  98,  95,  95, 115, 114,  99,  46, 112,  97, 115,  10,  10, 115,
114,  99,  95, 114,  95, 105, 110, 105, 116,  12,  12, 115, 114,  99,  95,  97,
108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,  95, 102, 114, 101,
101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,  13,  13, 115, 114,
 99,  95, 102, 105, 108, 101,  95, 111, 112, 101, 110,  14,  14, 115, 114,  99,
 95, 110, 101, 119,  95, 115, 111, 117, 114,  99, 101,  17,  17, 115, 114,  99,
 95,  97,  99, 116, 105, 118, 101,  95, 115, 111, 117, 114,  99, 101,  16,  16,
115, 114,  99,  95, 115, 101, 116,  95, 109,  97,  99, 114, 111,  95,  99,  98,
 16,  16, 115, 114,  99,  95, 100, 101, 108,  95, 109,  97,  99, 114, 111,  95,
 99,  98,  14,  14, 115, 114,  99,  95, 109,  97,  99, 114, 111,  95, 111, 112,
101, 110,  10,  10, 115, 114,  99,  95, 114, 101, 116, 117, 114, 110,  17,  17,
115, 114,  99,  95, 111, 117, 116,  95, 116, 101, 120, 116,  95, 108, 105, 110,
101,  11,  11, 115, 114,  99,  95, 111, 117, 116, 108, 105, 110, 101,  17,  17,
115, 114,  99,  95, 111, 117, 116, 101, 114, 114,  95,  98,  97, 110, 110, 101,
114,  40,  40,  32,  37,  42,  43,  42,  43,  42,  32, 101, 114, 114, 111, 114,
 40, 115,  41,  32, 119,  97, 115,  32, 100, 101, 116, 101,  99, 116, 101, 100,
 32,  97, 116,  32, 108, 105, 110, 101,  32,  35,  32,  16,  16,  32, 105, 110,
 32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  58,  32,  34,  13,  13, 115,
114,  99,  95, 111, 117, 116,  95, 101, 114, 114, 111, 114,  34,  34,  32,  60,
 60,  60,  32,  42,  42,  42,  32,  77,  97, 120, 105, 109, 117, 109,  32, 110,
117, 109,  98, 101, 114,  32, 111, 102,  32, 101, 114, 114, 111, 114,  32,  40,
 52,  52,  41,  32, 105, 115,  32, 114, 101,  97,  99, 104, 101, 100,  46,  32,
 83,  82,  67,  95,  76, 105,  98, 114,  97, 114, 121,  32, 115, 116, 111, 112,
 32, 111, 117, 114,  32,  83, 111, 102, 116, 119,  97, 114, 101,  46,  32,  42,
 42,  42,  32,  62,  62,  62,  17,  17, 115, 114,  99,  95, 111, 117, 116,  95,
109,  97,  99,  95, 101, 114, 114, 111, 114,   9,   9, 115, 114,  99,  95, 101,
114, 114, 111, 114,  17,  17, 115, 114,  99,  95, 103, 101, 116,  95, 105, 110,
112, 117, 116, 108, 105, 110, 101,  14,  14, 115, 114,  99,  95, 112, 117, 116,
 95, 112, 114, 111, 109, 112, 116,  12,  12, 115, 114,  99,  95, 103, 101, 116,
 95, 108, 105, 110, 101,  15,  15, 115, 114,  99,  95, 101, 110, 100,  95, 111,
102,  95, 108, 105, 110, 101,   4,   4,  83,  95,  71,  76,  12,  12, 115, 114,
 99,  95, 103, 101, 116,  95,  99, 104,  97, 114,  12,  12, 115, 107, 105, 112,
 95,  99, 111, 109, 109, 101, 110, 116,  10,  10, 115, 114,  99,  95, 105, 110,
 99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 110, 101, 120, 116,  95,  99,
104,  97, 114,  15,  15, 115, 114,  99,  95, 115, 101,  97, 114,  99, 104,  95,
 99, 104,  97, 114,  13,  13, 115, 114,  99,  95, 115, 101, 116,  95, 102, 108,
 97, 103, 115,   8,   8, 115, 114,  99,  95, 105, 110, 105, 116,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 24 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Global C type definitions */
typedef  V (*Re0)(V);

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_openerr = 0;
SL V_src_maxerror = 0;
SL V_src_lstinsnb = 0;
V V_src_control = NULL;
V V_src_cont_base = NULL;
V V_src_hde = NULL;
V V_src_listing = NULL;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);


/* Procedure/Function : " src_mexpend "  */
void BASIC_SC_V2_src_mexpend(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register SL Rv2;
  V Rv3;
  SL Rv4;
  register V Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=153; /* line # 153 */
  if (Ri.v[0]==NULL) {
    Ra.sl[6]=155; /* line # 155 */
    Ri.v[0]=PAS__NEW(1036);
    ((SL *)Ri.v[0])[0]=1024;
    Ra.sl[6]=156; /* line # 156 */
    Rv0=Ri.v[0];
    Ra.sl[6]=157; /* line # 157 */
    ((SL *)Rv0)[1]=0;
    ((SL *)Rv0)[2]=0;
  }
  else {
    Ra.sl[6]=160; /* line # 160 */
    if (((SL *)Ri.v[0])[0]<=((SL *)Ri.v[0])[1]) {
      Ra.sl[6]=162; /* line # 162 */
      Rv1=Ri.v[0];
      Ra.sl[6]=164; /* line # 164 */
      Rv2=((SL *)Rv1)[0]+1024;
      Rv3=PAS__NEW(Rv2+12);
      ((SL *)Rv3)[0]=Rv2;
      Ra.sl[6]=165; /* line # 165 */
      ((SL *)Rv3)[1]=((SL *)Rv1)[1];
      Ra.sl[6]=166; /* line # 166 */
      ((SL *)Rv3)[2]=((SL *)Rv1)[2];
      Ra.sl[6]=167; /* line # 167 */
      Rv4=1;
      for( Rf0=((SL *)Rv1)[1];Rf0>0;Rf0-- ) {
        ((C *)Rv3)[Rv4+11]=((C *)Rv1)[Rv4+11];
        Rv4++;
      }
      Ra.sl[6]=169; /* line # 169 */
      PAS__DISPOSE(Ri.v);
      Ra.sl[6]=170; /* line # 170 */
      Ri.v[0]=Rv3;
    }
  }
  Ra.sl[6]=173; /* line # 173 */
  Rv5=Ri.v[0];
  Ra.sl[6]=174; /* line # 174 */
  ((SL *)Rv5)[1]=((SL *)Rv5)[1]+1;
  ((C *)Rv5)[((SL *)Rv5)[1]+11]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_r_init "  */
void BASIC_SC_V2_src_r_init(V F_p, UB F_macflg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=183; /* line # 183 */
  if (F_p!=NULL) {
    Ra.sl[6]=184; /* line # 184 */
    Rv0=F_p;
    Ra.sl[6]=187; /* line # 187 */
    ((V *)Rv0)[0]=V_src_hde;
    Ra.sl[6]=188; /* line # 188 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=189; /* line # 189 */
    ((SL *)Rv0)[4]=0;
    Ra.sl[6]=190; /* line # 190 */
    ((SL *)Rv0)[5]=0;
    Ra.sl[6]=191; /* line # 191 */
    ((SL *)Rv0)[6]=0;
    Ra.sl[6]=192; /* line # 192 */
    ((SL *)Rv0)[7]=0;
    Ra.sl[6]=193; /* line # 193 */
    ((SL *)Rv0)[8]=0;
    Ra.sl[6]=194; /* line # 194 */
    ((SL *)Rv0)[9]=0;
    Ra.sl[6]=195; /* line # 195 */
    ((SL *)Rv0)[10]=0;
    Ra.sl[6]=196; /* line # 196 */
    ((SL *)Rv0)[11]=1;
    Ra.sl[6]=197; /* line # 197 */
    ((SL *)Rv0)[12]=255;
    Ra.sl[6]=198; /* line # 198 */
    ((C *)Rv0)[52]=0;
    Ra.sl[6]=199; /* line # 199 */
    ((C *)Rv0)[53]=1;
    Ra.sl[6]=200; /* line # 200 */
    if (F_macflg) ((C *)Rv0)[54]=77;
    else {
      Ra.sl[6]=201; /* line # 201 */
      ((C *)Rv0)[54]=32;
    }
    Ra.sl[6]=202; /* line # 202 */
    ((C *)Rv0)[55]=32;
    Ra.sl[6]=203; /* line # 203 */
    Rv1=1;
    for( Rf0=8;Rf0>0;Rf0-- ) {
      Ra.sl[6]=204; /* line # 204 */
      ((V *)Rv0)[Rv1*3+6]=NULL;
      Rv1++;
    }
    Ra.sl[6]=206; /* line # 206 */
    if (!F_macflg) {
      Ra.sl[6]=208; /* line # 208 */
      if (32768&((UL *)Rv0)[62]) {
        Ra.sl[6]=210; /* line # 210 */
        ((V *)Rv0)[32]=NULL;
        Ra.sl[6]=211; /* line # 211 */
        ((V *)Rv0)[34]=NULL;
        Ra.sl[6]=212; /* line # 212 */
        ((V *)Rv0)[33]=NULL;
      }
      Ra.sl[6]=214; /* line # 214 */
      ((UL *)Rv0)[62]=2120;
      Ra.sl[6]=215; /* line # 215 */
      ((UB *)Rv0)[252]=0;
      Ra.sl[6]=216; /* line # 216 */
      if (((V *)Rv0)[32]==NULL) {
        ((V *)Rv0)[32]=PAS__NEW(257);
        ((UB *)((V *)Rv0)[32])[0]=255;
      }
      Ra.sl[6]=217; /* line # 217 */
      ((UB *)((V *)Rv0)[32])[1]=0;
      Ra.sl[6]=218; /* line # 218 */
      if (((V *)Rv0)[35]!=NULL) {
        Ra.sl[6]=219; /* line # 219 */
        PAS__DISPOSE(((V *)Rv0)+35);
        ((V *)Rv0)[35]=NULL;
      }
    }
    else {
      Ra.sl[6]=223; /* line # 223 */
      if (!(32768&((UL *)Rv0)[62])) {
        Ra.sl[6]=225; /* line # 225 */
        if (((V *)Rv0)[32]!=NULL) PAS__DISPOSE(((V *)Rv0)+32);
        Ra.sl[6]=226; /* line # 226 */
        if (((V *)Rv0)[35]!=NULL) PAS__DISPOSE(((V *)Rv0)+35);
      }
      Ra.sl[6]=228; /* line # 228 */
      ((UL *)Rv0)[62]=34880;
      Ra.sl[6]=229; /* line # 229 */
      ((UB *)Rv0)[252]=4;
      Ra.sl[6]=230; /* line # 230 */
      ((V *)Rv0)[32]=NULL;
      Ra.sl[6]=231; /* line # 231 */
      ((V *)Rv0)[33]=NULL;
      Ra.sl[6]=232; /* line # 232 */
      ((V *)Rv0)[34]=NULL;
      Ra.sl[6]=233; /* line # 233 */
      ((SL *)Rv0)[70]=0;
    }
  }
  Ra.sl[6]=236; /* line # 236 */
  V_src_hde=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V BASIC_SC_V2_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+89;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=249; /* line # 249 */
  Rv0=PAS__NEW(288);
  Ra.sl[6]=250; /* line # 250 */
  Rv1=Rv0;
  Ra.sl[6]=252; /* line # 252 */
  ((UL *)Rv1)[62]=32768;
  Ra.sl[6]=253; /* line # 253 */
  ((V *)Rv1)[32]=NULL;
  Ra.sl[6]=254; /* line # 254 */
  ((V *)Rv1)[35]=NULL;
  Ra.sl[6]=256; /* line # 256 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+103;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=269; /* line # 269 */
  Rv0=NULL;
  Ra.sl[6]=270; /* line # 270 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=272; /* line # 272 */
    Rv1=V_src_hde;
    Ra.sl[6]=273; /* line # 273 */
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[6]=275; /* line # 275 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else {
    Ra.sl[6]=277; /* line # 277 */
    Rv1=NULL;
  }
  Ra.sl[6]=278; /* line # 278 */
  if (Rv1!=NULL) {
    Ra.sl[6]=280; /* line # 280 */
    Rv2=(*F_p);
    Ra.sl[6]=282; /* line # 282 */
    if (!(32768&((UL *)Rv2)[62])) {
      Ra.sl[6]=284; /* line # 284 */
      if (((V *)Rv2)[32]!=NULL) PAS__DISPOSE(((V *)Rv2)+32);
      Ra.sl[6]=285; /* line # 285 */
      if (((V *)Rv2)[35]!=NULL) PAS__DISPOSE(((V *)Rv2)+35);
    }
    Ra.sl[6]=288; /* line # 288 */
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else {
      Ra.sl[6]=289; /* line # 289 */
      ((V *)Rv0)[0]=((V *)Rv2)[0];
    }
    Ra.sl[6]=291; /* line # 291 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=292; /* line # 292 */
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+113;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=307; /* line # 307 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=309; /* line # 309 */
    Rv0=(*F_p);
    Ra.sl[6]=311; /* line # 311 */
    if (16384&((UL *)Rv0)[62]) {
      Ra.sl[6]=313; /* line # 313 */
      if (32768&((UL *)Rv0)[62]) {
        Ra.sl[6]=315; /* line # 315 */
        ((V *)Rv0)[32]=NULL;
        Ra.sl[6]=316; /* line # 316 */
        ((V *)Rv0)[34]=NULL;
        Ra.sl[6]=317; /* line # 317 */
        ((V *)Rv0)[33]=NULL;
      }
      else {
        Ra.sl[6]=321; /* line # 321 */
        if (128&((UL *)Rv0)[62]) Rv1=2048;
        else {
          Ra.sl[6]=322; /* line # 322 */
          Rv1=0;
        }
        Ra.sl[6]=323; /* line # 323 */
        PAS__CLOSE(((V *)Rv0)+33,Rv1);
        Ra.sl[6]=324; /* line # 324 */
        if (8&((UL *)Rv0)[62]) PAS__CLOSE(((V *)Rv0)+34,0);
        Ra.sl[6]=325; /* line # 325 */
        if (((V *)Rv0)[35]!=NULL) {
          Ra.sl[6]=327; /* line # 327 */
          PAS__DISPOSE(((V *)Rv0)+35);
          ((V *)Rv0)[35]=NULL;
        }
      }
      Ra.sl[6]=330; /* line # 330 */
      if (((V *)Rv0)[1]!=NULL&&V_src_control==(*F_p)) {
        Ra.sl[6]=332; /* line # 332 */
        V_src_control=((V *)Rv0)[1];
      }
      Ra.sl[6]=334; /* line # 334 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~16384;
    }
    Ra.sl[6]=337; /* line # 337 */
    if (F_bfree) P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_file_open "  */
V P_src_file_open(V F_fspc, UB F_bdel, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+124;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=362; /* line # 362 */
  V_src_openerr=0;
  Ra.sl[6]=363; /* line # 363 */
  if (F_srcp==NULL) {
    Ra.sl[6]=365; /* line # 365 */
    Rv0=0;
    Ra.sl[6]=366; /* line # 366 */
    F_srcp=BASIC_SC_V2_src_allocate();
  }
  else {
    Ra.sl[6]=370; /* line # 370 */
    Rv0=1;
    Ra.sl[6]=371; /* line # 371 */
    P_src_close(&F_srcp,0);
  }
  Ra.sl[6]=373; /* line # 373 */
  BASIC_SC_V2_src_r_init(F_srcp,0);
  Ra.sl[6]=375; /* line # 375 */
  Rv1=F_srcp;
  Ra.sl[6]=377; /* line # 377 */
  if (((UB *)F_fspc)[1]==0) {
    Ra.sl[6]=379; /* line # 379 */
    _FILE_DUPLICATE(((V *)Rv1)[33],PAS__f_input);
    Ra.sl[6]=380; /* line # 380 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16;
    Ra.sl[6]=381; /* line # 381 */
    PAS__iostatus=0;
  }
  else {
    Ra.sl[6]=383; /* line # 383 */
    PAS__OPEN(((V *)Rv1)+33,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  }
  Ra.sl[6]=385; /* line # 385 */
  if (PAS__iostatus==0) {
    Ra.sl[6]=388; /* line # 388 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8;
    Ra.sl[6]=389; /* line # 389 */
    if (PAS__TTY_FILE(((V *)Rv1)[33])) {
      Ra.sl[6]=391; /* line # 391 */
      if (((UB *)F_fspc)[1]==0) {
        Ra.sl[6]=393; /* line # 393 */
        _FILE_DUPLICATE(((V *)Rv1)[34],PAS__f_output);
        Ra.sl[6]=394; /* line # 394 */
        PAS__iostatus=0;
      }
      else {
        Ra.sl[6]=396; /* line # 396 */
        PAS__OPEN(((V *)Rv1)+34,0, F_fspc,4098,0,-1);
      }
      Ra.sl[6]=397; /* line # 397 */
      if (PAS__iostatus!=0) {
        Ra.sl[6]=399; /* line # 399 */
        V_src_openerr=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+33,0);
      }
      else {
        Ra.sl[6]=403; /* line # 403 */
        ((V *)Rv1)[35]=PAS__NEW(65);
        ((UB *)((V *)Rv1)[35])[0]=63;
        Ra.sl[6]=404; /* line # 404 */
        PAS__STR_TO_STR(((V *)Rv1)[35],V_def_prompt);
        Ra.sl[6]=405; /* line # 405 */
        ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16392;
      }
    }
    else {
      Ra.sl[6]=410; /* line # 410 */
      if (F_bdel) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|128;
      Ra.sl[6]=411; /* line # 411 */
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
    }
  }
  else {
    Ra.sl[6]=414; /* line # 414 */
    V_src_openerr=PAS__iostatus;
  }
  Ra.sl[6]=415; /* line # 415 */
  if (V_src_openerr!=0) {
    Ra.sl[6]=416; /* line # 416 */
    if (Rv0) BASIC_SC_V2_src_r_init(F_srcp,0);
    else {
      Ra.sl[6]=417; /* line # 417 */
      P_src_free(&F_srcp);
    }
  }
  Ra.sl[6]=419; /* line # 419 */
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_new_source "  */
void P_src_new_source(V F_fspc, UB F_binc, UB F_bdel){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+139;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=441; /* line # 441 */
  Rv0=P_src_file_open(F_fspc,F_bdel,NULL);
  Ra.sl[6]=442; /* line # 442 */
  if (V_src_openerr==0) {
    Ra.sl[6]=443; /* line # 443 */
    Rv1=Rv0;
    Ra.sl[6]=445; /* line # 445 */
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    Ra.sl[6]=446; /* line # 446 */
    if (F_binc) ((SL *)Rv1)[7]=((SL *)Rv1)[7]+1;
    Ra.sl[6]=447; /* line # 447 */
    ((SL *)Rv1)[8]=((SL *)V_src_control)[8];
    Ra.sl[6]=448; /* line # 448 */
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    Ra.sl[6]=449; /* line # 449 */
    ((SL *)Rv1)[11]=((SL *)V_src_control)[11];
    Ra.sl[6]=450; /* line # 450 */
    ((SL *)Rv1)[12]=((SL *)V_src_control)[12];
    Ra.sl[6]=451; /* line # 451 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|((UL *)V_src_control)[62]&103;
    Ra.sl[6]=453; /* line # 453 */
    if (F_binc) {
      Ra.sl[6]=455; /* line # 455 */
      ((V *)Rv1)[1]=V_src_control;
      Ra.sl[6]=456; /* line # 456 */
      V_src_control=Rv0;
    }
    else {
      Ra.sl[6]=460; /* line # 460 */
      ((V *)Rv1)[1]=((V *)V_src_control)[1];
      Ra.sl[6]=461; /* line # 461 */
      P_src_close(&Rv0, F_bdel);
      Ra.sl[6]=462; /* line # 462 */
      V_src_control=Rv0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_active_source "  */
void P_src_active_source(V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=476; /* line # 476 */
  if (F_srcp!=NULL&&V_src_control!=NULL) {
    Ra.sl[6]=478; /* line # 478 */
    Rv0=V_src_control;
    Ra.sl[6]=483; /* line # 483 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|262144;
    Ra.sl[6]=485; /* line # 485 */
    Rv1=F_srcp;
    Ra.sl[6]=487; /* line # 487 */
    ((V *)Rv1)[1]=V_src_control;
    Ra.sl[6]=488; /* line # 488 */
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    Ra.sl[6]=489; /* line # 489 */
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    Ra.sl[6]=490; /* line # 490 */
    ((SL *)Rv1)[8]=((SL *)Rv1)[7];
    Ra.sl[6]=491; /* line # 491 */
    ((C *)Rv1)[52]=0;
    Ra.sl[6]=492; /* line # 492 */
    ((C *)Rv1)[53]=((C *)V_src_control)[52];
    Ra.sl[6]=493; /* line # 493 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|65536;
    Ra.sl[6]=495; /* line # 495 */
    V_src_control=F_srcp;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_set_macro_cb "  */
void P_src_set_macro_cb(V F_call_back(V F_mp)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+174;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=508; /* line # 508 */
  Ri.v[1]=(V)(*F_call_back);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_del_macro_cb "  */
void P_src_del_macro_cb(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+192;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=516; /* line # 516 */
  Ri.v[1]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_macro_open "  */
V P_src_macro_open(V F_mtxt, V F_ucbf, V F_uobj, UB F_fact, V F_srcp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+210;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=539; /* line # 539 */
  if (F_srcp==NULL) {
    Ra.sl[6]=541; /* line # 541 */
    Rv0=0;
    Ra.sl[6]=542; /* line # 542 */
    F_srcp=BASIC_SC_V2_src_allocate();
  }
  else {
    Ra.sl[6]=546; /* line # 546 */
    Rv0=1;
    Ra.sl[6]=547; /* line # 547 */
    P_src_close(&F_srcp,0);
  }
  Ra.sl[6]=549; /* line # 549 */
  BASIC_SC_V2_src_r_init(F_srcp,1);
  Ra.sl[6]=550; /* line # 550 */
  Rv1=F_srcp;
  Ra.sl[6]=552; /* line # 552 */
  if (F_mtxt!=NULL) {
    Ra.sl[6]=554; /* line # 554 */
    ((V *)Rv1)[32]=F_mtxt;
    Ra.sl[6]=555; /* line # 555 */
    ((SL *)Rv1)[12]=((UB *)F_mtxt)[1];
    Ra.sl[6]=556; /* line # 556 */
    if (((SL *)Rv1)[12]>0) {
      Ra.sl[6]=558; /* line # 558 */
      ((C *)Rv1)[53]=0;
      Ra.sl[6]=559; /* line # 559 */
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~2048;
    }
  }
  Ra.sl[6]=562; /* line # 562 */
  ((V *)Rv1)[34]=F_uobj;
  Ra.sl[6]=563; /* line # 563 */
  if (F_ucbf!=NULL) ((V *)Rv1)[33]=F_ucbf;
  else {
    Ra.sl[6]=564; /* line # 564 */
    ((V *)Rv1)[33]=Ri.v[1];
  }
  Ra.sl[6]=565; /* line # 565 */
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
  Ra.sl[6]=566; /* line # 566 */
  if (F_fact&&V_src_control!=NULL) {
    Ra.sl[6]=567; /* line # 567 */
    P_src_active_source(F_srcp);
  }
  Ra.sl[6]=569; /* line # 569 */
  Ret=F_srcp;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_return "  */
C P_src_return(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+226;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=584; /* line # 584 */
  Rv0=V_src_control;
  Ra.sl[6]=585; /* line # 585 */
  if (Rv0!=NULL) Rv1=((V *)Rv0)[1];
  Ra.sl[6]=586; /* line # 586 */
  if (Rv0!=NULL&&Rv1!=NULL) {
    Ra.sl[6]=594; /* line # 594 */
    Rv2=Rv0;
    Ra.sl[6]=595; /* line # 595 */
    ((UL *)Rv2)[62]=((UL *)Rv2)[62]&~65536;
    Ra.sl[6]=596; /* line # 596 */
    Rv3=Rv1;
    Ra.sl[6]=598; /* line # 598 */
    ((C *)Rv3)[52]=((C *)Rv0)[52];
    Ra.sl[6]=599; /* line # 599 */
    V_src_control=Rv1;
    Ra.sl[6]=600; /* line # 600 */
    P_src_close(&Rv0, F_bfree);
    Ra.sl[6]=601; /* line # 601 */
    Ret=((C *)Rv3)[53];
  }
  else {
    Ra.sl[6]=604; /* line # 604 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SC_V2_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+238;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=616; /* line # 616 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Ra.sl[6]=617; /* line # 617 */
  Rv1=V_lst_current;
  Ra.sl[6]=619; /* line # 619 */
  if (F_bterm) Rv2=80;
  else {
    Ra.sl[6]=620; /* line # 620 */
    Rv2=((SL *)Rv1)[16];
  }
  Ra.sl[6]=621; /* line # 621 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Ra.sl[6]=623; /* line # 623 */
    Rv0=Rv0+1;
    Ra.sl[6]=624; /* line # 624 */
    if (Rv0>Rv2) {
      Ra.sl[6]=626; /* line # 626 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      Ra.sl[6]=627; /* line # 627 */
      if (!F_bterm) ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Ra.sl[6]=628; /* line # 628 */
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    Ra.sl[6]=630; /* line # 630 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[6]=632; /* line # 632 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SC_V2_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+257;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=645; /* line # 645 */
  Rv0=V_src_control;
  Ra.sl[6]=647; /* line # 647 */
  if (V_src_lstinsnb!=((SL *)Rv0)[6]) {
    Ra.sl[6]=649; /* line # 649 */
    V_src_lstinsnb=((SL *)Rv0)[6];
    Ra.sl[6]=650; /* line # 650 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[6],5,0);
  }
  else {
    Ra.sl[6]=652; /* line # 652 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  Ra.sl[6]=654; /* line # 654 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[54]);
  PAS__WRITE_CHAR(((C *)Rv0)[55]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[6]=655; /* line # 655 */
  Rv1=((V *)Rv0)[32];
  Rv2=V_lst_current;
  Ra.sl[6]=657; /* line # 657 */
  if (F_bterm) Rv3=80;
  else {
    Ra.sl[6]=658; /* line # 658 */
    Rv3=((SL *)Rv2)[16];
  }
  Ra.sl[6]=659; /* line # 659 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[6]=660; /* line # 660 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Ra.sl[6]=662; /* line # 662 */
    Rv4=20;
    Ra.sl[6]=663; /* line # 663 */
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=665; /* line # 665 */
      Rv4=Rv4+1;
      Ra.sl[6]=666; /* line # 666 */
      if (Rv4>Rv3) {
        Ra.sl[6]=668; /* line # 668 */
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        Ra.sl[6]=669; /* line # 669 */
        if (!F_bterm) ((SL *)Rv2)[12]=((SL *)Rv2)[12]+1;
        Ra.sl[6]=670; /* line # 670 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      Ra.sl[6]=672; /* line # 672 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    Ra.sl[6]=674; /* line # 674 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=676; /* line # 676 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[32],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SC_V2_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+270;
  Ra.v[35]=Rd.s+13;
  Ra.sl[72]=695; /* line # 695 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[72]=697; /* line # 697 */
  Ra.ub[1]=Ra.ub[0];
  Ra.sl[72]=698; /* line # 698 */
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[72]=701; /* line # 701 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[11]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Ra.sl[72]=702; /* line # 702 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[72]=703; /* line # 703 */
    Rv5=(((S *)Rv0)+Rv4*24+32);
    Ra.sl[72]=704; /* line # 704 */
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  Ra.sl[72]=705; /* line # 705 */
  if (((UB *)((V *)Rv0)[32])[1]>((SL *)Rv0)[12]) {
    Ra.sl[72]=708; /* line # 708 */
    Rv6=((SL *)Rv0)[12]+1;
    for( Rf0=(((UB *)((V *)Rv0)[32])[1]+1)-(((SL *)Rv0)[12]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.sl[72]=709; /* line # 709 */
    Ra.ub[1]=((UB *)((V *)Rv0)[32])[1];
  }
  else {
    Ra.sl[72]=711; /* line # 711 */
    Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[9]*6+8];
  }
  Ra.sl[72]=713; /* line # 713 */
  BASIC_SC_V2_src_out_text_line(F_f,Ra.s,F_bterm);
  Ra.sl[72]=714; /* line # 714 */
  if (F_bterm) {
    Ra.sl[72]=716; /* line # 716 */
    P_lst_newline();
    Ra.sl[72]=717; /* line # 717 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
  }
  Ra.sl[72]=719; /* line # 719 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+289,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],5,0);
  PAS__WRITE_EOLN();
  Ra.sl[72]=720; /* line # 720 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+331,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+292,((V *)Rv0)[33]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SC_V2_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+349;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=728; /* line # 728 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=730; /* line # 730 */
  if ((1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7])&&!(64&((UB *)Rv1)[72])
  ) {
    Ra.sl[6]=733; /* line # 733 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
    Ra.sl[6]=735; /* line # 735 */
    BASIC_SC_V2_src_outerr_banner(((V *)Rv1)+10,0);
    Ra.sl[6]=736; /* line # 736 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=738; /* line # 738 */
      P_lst_newline();
      Ra.sl[6]=739; /* line # 739 */
      ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Ra.sl[6]=740; /* line # 740 */
      P_err_display(((V *)Rv1)+10,Rv2,(((S *)Rv0)+Rv2*24+32));
      Rv2++;
    }
    Ra.sl[6]=742; /* line # 742 */
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[10]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=744; /* line # 744 */
  if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) {
    Ra.sl[6]=746; /* line # 746 */
    if (!F_bmac) BASIC_SC_V2_src_outline(&PAS__f_output,1);
    Ra.sl[6]=747; /* line # 747 */
    BASIC_SC_V2_src_outerr_banner(&PAS__f_output,1);
    Ra.sl[6]=748; /* line # 748 */
    Rv3=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=749; /* line # 749 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*24+32));
      Rv3++;
    }
    Ra.sl[6]=750; /* line # 750 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=753; /* line # 753 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[6]=754; /* line # 754 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*3+6));
    Rv4++;
  }
  Ra.sl[6]=756; /* line # 756 */
  if (Ri.sl[4]>V_src_maxerror) {
    Ra.sl[6]=757; /* line # 757 */
    Ra.sl[6]=759; /* line # 759 */
    P_lst_newline();
    Ra.sl[6]=760; /* line # 760 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+364,-1,-1,32);
    PAS__WRITE_INT(V_src_maxerror,0,0);
    PAS__WRITE_STR(Rd.s+400,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=761; /* line # 761 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+454;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=770; /* line # 770 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=771; /* line # 771 */
  if (((SL *)Rv0)[9]>0) {
    Ra.sl[6]=773; /* line # 773 */
    if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) (*F_out_mac_line)(&PAS__f_output,1);
    Ra.sl[6]=774; /* line # 774 */
    BASIC_SC_V2_src_out_error(1);
    Ra.sl[6]=775; /* line # 775 */
    ((SL *)Rv0)[9]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+473;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=791; /* line # 791 */
  Rv0=V_src_control;
  Ra.sl[6]=794; /* line # 794 */
  if (((SL *)Rv0)[4]<((SL *)Rv0)[11]) ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  else {
    Ra.sl[6]=795; /* line # 795 */
    if (((SL *)Rv0)[4]>((SL *)Rv0)[12]) ((SL *)Rv0)[4]=((SL *)Rv0)[12];
  }
  Ra.sl[6]=797; /* line # 797 */
  if (((SL *)Rv0)[9]>=8) {
    Ra.sl[6]=799; /* line # 799 */
    ((SL *)Rv0)[9]=8;
    Rv1=0;
  }
  else {
    Ra.sl[6]=803; /* line # 803 */
    Rv1=1;
    Ra.sl[6]=804; /* line # 804 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=805; /* line # 805 */
      if (((SL *)Rv0)[4]==((SL *)Rv0)[Rv2*6+8]) Rv1=0;
      Rv2++;
    }
    Ra.sl[6]=806; /* line # 806 */
    if (Rv1) ((SL *)Rv0)[9]=((SL *)Rv0)[9]+1;
  }
  Ra.sl[6]=809; /* line # 809 */
  if (Rv1) {
    Ra.sl[6]=810; /* line # 810 */
    Rv3=(((S *)Rv0)+((SL *)Rv0)[9]*24+32);
    Ra.sl[6]=812; /* line # 812 */
    ((SL *)Rv3)[0]=((SL *)Rv0)[4];
    Ra.sl[6]=813; /* line # 813 */
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[6]=814; /* line # 814 */
    ((SL *)Rv3)[1]=F_number;
    Ra.sl[6]=815; /* line # 815 */
    ((UB *)Rv3)[8]=F_severity;
    Ra.sl[6]=816; /* line # 816 */
    memcpy(Rv3+9,Ra.s+28,4);
    Ra.sl[6]=817; /* line # 817 */
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[9]*24+32));
  }
  else {
    Ra.sl[6]=821; /* line # 821 */
    if (((UB *)Rv0)[((SL *)Rv0)[9]*24+40]<F_severity) {
      Ra.sl[6]=822; /* line # 822 */
      ((UB *)Rv0)[((SL *)Rv0)[9]*24+40]=F_severity;
    }
  }
  Ra.sl[6]=823; /* line # 823 */
  if (!(32768&((UL *)Rv0)[62]||PAS__TTY_FILE(((V *)Rv0)[33]))) {
    Ra.sl[6]=824; /* line # 824 */
    if (PAS__EOF(((V *)Rv0)[33])) BASIC_SC_V2_src_out_error(0);
  }
  Ra.sl[6]=826; /* line # 826 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  Ra.sl[6]=827; /* line # 827 */
  if (F_severity>1) Ri.sl[4]=Ri.sl[4]+1;
  Ra.sl[6]=828; /* line # 828 */
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+484;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=850; /* line # 850 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  Ra.sl[6]=852; /* line # 852 */
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Ra.sl[6]=853; /* line # 853 */
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[6]=855; /* line # 855 */
  ((UB *)Rv0)[1]=0;
  Ra.sl[6]=856; /* line # 856 */
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    Ra.sl[6]=858; /* line # 858 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    Ra.sl[6]=859; /* line # 859 */
    if (Rv2==9) while (1){
      Ra.sl[6]=861; /* line # 861 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      Ra.sl[6]=862; /* line # 862 */
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      Ra.sl[6]=865; /* line # 865 */
      if (Rv2>=32) {
        Ra.sl[6]=866; /* line # 866 */
        if (((UB *)Rv0)[1]<255) {
          Ra.sl[6]=868; /* line # 868 */
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[6]=871; /* line # 871 */
          ((UL *)Rv1)[62]=((UL *)Rv1)[62]|256;
        }
      }
    }
  }
  Ra.sl[6]=873; /* line # 873 */
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|8192;
  else {
    Ra.sl[6]=874; /* line # 874 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  Ra.sl[6]=875; /* line # 875 */
  ((SL *)Rv1)[10]=((SL *)Rv1)[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+503;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=885; /* line # 885 */
  if (F_pstr!=NULL) {
    Ra.sl[6]=886; /* line # 886 */
    Rv0=V_src_control;
    Ra.sl[6]=887; /* line # 887 */
    if (8&((UL *)Rv0)[62]) {
      Ra.sl[6]=890; /* line # 890 */
      PAS__SELECT_OUT(((V *)Rv0)[34]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SC_V2_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+519;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=901; /* line # 901 */
  Rv0=V_src_control;
  Ra.sl[6]=903; /* line # 903 */
  ((SL *)Rv0)[5]=((SL *)Rv0)[11]-1;
  Ra.sl[6]=904; /* line # 904 */
  ((SL *)Rv0)[9]=0;
  Ra.sl[6]=906; /* line # 906 */
  if (32768&((UL *)Rv0)[62]) {
    Ra.sl[6]=908; /* line # 908 */
    if (((V *)Rv0)[33]!=NULL) {
      Ra.sl[6]=909; /* line # 909 */
      ((V *)Rv0)[32]=(*(Re0)((V *)Rv0)[33])(((V *)Rv0)[34]);
    }
    Ra.sl[6]=910; /* line # 910 */
    ((SL *)Rv0)[10]=((SL *)Rv0)[10]+1;
  }
  else {
    Ra.sl[6]=915; /* line # 915 */
    if (8&((UL *)Rv0)[62]) P_src_put_prompt(((V *)Rv0)[35]);
    Ra.sl[6]=917; /* line # 917 */
    P_src_get_inputline(((V *)Rv0)+33,((V *)Rv0)+32);
    Ra.sl[6]=918; /* line # 918 */
    if (32&((UL *)Rv0)[62]) {
      Ra.sl[6]=920; /* line # 920 */
      if (8&((UL *)Rv0)[62]) P_lst_put_string(((V *)Rv0)[35]);
      Ra.sl[6]=921; /* line # 921 */
      P_lst_put_string(((V *)Rv0)[32]);
      Ra.sl[6]=922; /* line # 922 */
      P_lst_eoln();
    }
  }
  Ra.sl[6]=925; /* line # 925 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+533;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=936; /* line # 936 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=938; /* line # 938 */
  if (256&((UL *)Rv0)[62]) {
    Ra.sl[6]=941; /* line # 941 */
    ((SL *)Rv0)[4]=((SL *)Rv0)[12]-1;
    P_src_error(Rd.s+552,1,2);
    Ra.sl[6]=942; /* line # 942 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~256;
  }
  Ra.sl[6]=944; /* line # 944 */
  if (1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7]) {
    Ra.sl[6]=945; /* line # 945 */
    if (!(64&((UB *)Rv1)[72])) {
      Ra.sl[6]=948; /* line # 948 */
      P_lst_newline();
      Ra.sl[6]=949; /* line # 949 */
      BASIC_SC_V2_src_outline(((V *)Rv1)+10,0);
    }
  }
  Ra.sl[6]=951; /* line # 951 */
  if (((SL *)Rv0)[9]>0) BASIC_SC_V2_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SC_V2_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+556;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=962; /* line # 962 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=964; /* line # 964 */
  while (!(8192&((UL *)Rv0)[62])&&2048&((UL *)Rv0)[62]){
    Ra.sl[6]=969; /* line # 969 */
    if (((SL *)Rv0)[10]>0&&!(1048576&((UL *)Rv0)[62])) {
      Ra.sl[6]=970; /* line # 970 */
      P_src_end_of_line();
    }
    Ra.sl[6]=972; /* line # 972 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~1050624;
    Ra.sl[6]=973; /* line # 973 */
    BASIC_SC_V2_src_get_line();
    Ra.sl[6]=975; /* line # 975 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|512;
    Ra.sl[6]=976; /* line # 976 */
    if (((C *)Rv0)[54]!=67) {
      Ra.sl[6]=977; /* line # 977 */
      Rs.c[0]=((C *)Rv0)[54];
      ((C *)Rv0)[54]=67;
    }
  }
  Ra.sl[6]=979; /* line # 979 */
  if (!(8192&((UL *)Rv0)[62])) {
    Ra.sl[6]=980; /* line # 980 */
    if (((SL *)Rv0)[5]>=((SL *)Rv0)[12]||((SL *)Rv0)[5]>=((UB *)Rv1)[1]) {
      Ra.sl[6]=982; /* line # 982 */
      if (1048576&((UL *)Rv0)[62]&&((SL *)Rv0)[10]>0) {
        Ra.sl[6]=983; /* line # 983 */
        P_src_end_of_line();
      }
      Ra.sl[6]=984; /* line # 984 */
      if ((525312&((UL *)Rv0)[62])!=0) {
        Ra.sl[6]=985; /* line # 985 */
        Rv2=1;
      }
      else Rv2=32;
      Ra.sl[6]=986; /* line # 986 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|2048;
    }
    else {
      Ra.sl[6]=990; /* line # 990 */
      ((SL *)Rv0)[5]=((SL *)Rv0)[5]+1;
      Ra.sl[6]=991; /* line # 991 */
      Rv2=((C *)Rv1)[((SL *)Rv0)[5]+1];
    }
  }
  else {
    Ra.sl[6]=998; /* line # 998 */
    if (65536&((UL *)Rv0)[62]&&((V *)Rv0)[1]!=NULL) {
      Ra.sl[6]=1002; /* line # 1002 */
      Rv2=P_src_return(!(131072&((UL *)Rv0)[62]));
    }
    else {
      Ra.sl[6]=1010; /* line # 1010 */
      Rv2=4;
      Ra.sl[6]=1011; /* line # 1011 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|4096;
    }
  }
  Ra.sl[6]=1015; /* line # 1015 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SC_V2_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+570;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1027; /* line # 1027 */
  Rv0=0;
  Ra.sl[6]=1028; /* line # 1028 */
  Rv1=V_src_control;
  Ra.sl[6]=1031; /* line # 1031 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|1024;
  Ra.sl[6]=1032; /* line # 1032 */
  Rv2=((UB *)Rv1)[252];
  Ra.sl[6]=1033; /* line # 1033 */
  ((UB *)Rv1)[252]=4;
  while (1){
    while (1){
      Ra.sl[6]=1036; /* line # 1036 */
      Rv3=BASIC_SC_V2_src_get_char();
      if ((Rv3==4||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[6]=1038; /* line # 1038 */
    switch (Rv2) {
      case 0:Ra.sl[6]=1041; /* line # 1041 */
      Rv0=F_stp==125&&Rv3==F_stp||Rv3==4;
      Ra.sl[6]=1042; /* line # 1042 */
      if (F_stp==42&&Rv3!=4) {
        Ra.sl[6]=1044; /* line # 1044 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) {
          Ra.sl[6]=1046; /* line # 1046 */
          Rv0=((C *)((V *)Rv1)[32])[(((SL *)Rv1)[5]+1)+1]==41;
          Ra.sl[6]=1047; /* line # 1047 */
          if (Rv0) Rv3=BASIC_SC_V2_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[6]=1053; /* line # 1053 */
      if (Rv3!=4) {
        Ra.sl[6]=1055; /* line # 1055 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) Rv3=BASIC_SC_V2_src_get_char();
        Ra.sl[6]=1056; /* line # 1056 */
        Rv0=Rv3==47;
      }
      else {
        Ra.sl[6]=1057; /* line # 1057 */
        Rv0=1;
      }
      break;
      case 2:
      case 3:
      case 4:Ra.sl[6]=1062; /* line # 1062 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[6]=1067; /* line # 1067 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~1024;
  Ra.sl[6]=1068; /* line # 1068 */
  ((UB *)Rv1)[252]=Rv2;
  Ra.sl[6]=1070; /* line # 1070 */
  if (Rv3!=4) {
    Ra.sl[6]=1071; /* line # 1071 */
    if (Rv3==1&&!(524288&((UL *)Rv1)[62])||Rv3>1) {
      Ra.sl[6]=1072; /* line # 1072 */
      Rv3=32;
    }
  }
  Ra.sl[6]=1075; /* line # 1075 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+584;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1088; /* line # 1088 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=1090; /* line # 1090 */
  Rv2=BASIC_SC_V2_src_get_char();
  Ra.sl[6]=1091; /* line # 1091 */
  switch (((UB *)Rv0)[252]) {
    case 0:Ra.sl[6]=1094; /* line # 1094 */
    if (Rv2==123) Rv2=BASIC_SC_V2_skip_comment(125,0);
    else {
      Ra.sl[6]=1095; /* line # 1095 */
      if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
        Ra.sl[6]=1096; /* line # 1096 */
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
          Ra.sl[6]=1098; /* line # 1098 */
          Rv2=BASIC_SC_V2_src_get_char();
          Ra.sl[6]=1099; /* line # 1099 */
          Rv2=BASIC_SC_V2_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:Ra.sl[6]=1103; /* line # 1103 */
    if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=1104; /* line # 1104 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
        Ra.sl[6]=1106; /* line # 1106 */
        Rv2=BASIC_SC_V2_src_get_char();
        Ra.sl[6]=1107; /* line # 1107 */
        Rv2=BASIC_SC_V2_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[6]=1111; /* line # 1111 */
    if (Rv2==59) Rv2=BASIC_SC_V2_skip_comment(59,1);
    break;
    case 2:Ra.sl[6]=1114; /* line # 1114 */
    if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=1115; /* line # 1115 */
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==45) {
        Ra.sl[6]=1116; /* line # 1116 */
        Rv2=BASIC_SC_V2_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[6]=1121; /* line # 1121 */
    break;
  }
  Ra.sl[6]=1123; /* line # 1123 */
  if (512&((UL *)Rv0)[62]) {
    Ra.sl[6]=1124; /* line # 1124 */
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[6]=1126; /* line # 1126 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~512;
      Ra.sl[6]=1127; /* line # 1127 */
      if (((C *)Rv0)[54]==67) ((C *)Rv0)[54]=Rs.c[0];
    }
  }
  Ra.sl[6]=1130; /* line # 1130 */
  ((C *)Rv0)[52]=((C *)Rv0)[53];
  Ra.sl[6]=1131; /* line # 1131 */
  ((C *)Rv0)[53]=Rv2;
  Ra.sl[6]=1132; /* line # 1132 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+596;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1146; /* line # 1146 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=1147; /* line # 1147 */
  if (((SL *)Rv0)[5]>=((UB *)Rv1)[1]||((SL *)Rv0)[5]>=((SL *)Rv0)[12]) {
    Ra.sl[6]=1148; /* line # 1148 */
    Ret=32;
  }
  else {
    Ra.sl[6]=1150; /* line # 1150 */
    Ret=((C *)Rv1)[(((SL *)Rv0)[5]+1)+1];
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+611;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1165; /* line # 1165 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=1167; /* line # 1167 */
  Rv2=((SL *)Rv0)[5];
  Ra.sl[6]=1168; /* line # 1168 */
  Rv3=1;
  Ra.sl[6]=1169; /* line # 1169 */
  while (Rv3){
    Ra.sl[6]=1170; /* line # 1170 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[12]) {
      Ra.sl[6]=1172; /* line # 1172 */
      Rv4=((C *)Rv1)[Rv2+1];
      Ra.sl[6]=1173; /* line # 1173 */
      if (Rv4==32) Rv2=Rv2+1;
      else {
        Ra.sl[6]=1174; /* line # 1174 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1178; /* line # 1178 */
      Rv3=0;
      Ra.sl[6]=1179; /* line # 1179 */
      Rv4=32;
    }
  }
  Ra.sl[6]=1182; /* line # 1182 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_set_flags "  */
void P_src_set_flags(UL F_flg, UB F_fclr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+628;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1195; /* line # 1195 */
  Rv0=V_src_control;
  Ra.sl[6]=1196; /* line # 1196 */
  if (F_fclr) {
    Ra.sl[6]=1197; /* line # 1197 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~F_flg;
  }
  else {
    Ra.sl[6]=1199; /* line # 1199 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|F_flg;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+13;
  Ra.sl[6]=1216; /* line # 1216 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Ra.sl[6]=1218; /* line # 1218 */
  Rv0=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv0]=0;
    Rv0++;
  }
  Ra.sl[6]=1219; /* line # 1219 */
  V_error_result=0;
  Ra.sl[6]=1221; /* line # 1221 */
  V_src_control=NULL;
  Ra.sl[6]=1222; /* line # 1222 */
  if (((UB *)F_def_src)[1]>0) {
    Ra.sl[6]=1223; /* line # 1223 */
    V_src_control=P_src_file_open(F_def_src,0,NULL);
  }
  Ra.sl[6]=1224; /* line # 1224 */
  if (V_src_openerr==0) {
    Ra.sl[6]=1225; /* line # 1225 */
    Rv1=V_src_control;
    Ra.sl[6]=1227; /* line # 1227 */
    ((SL *)Rv1)[7]=1;
    Ra.sl[6]=1228; /* line # 1228 */
    ((SL *)Rv1)[8]=1;
  }
  else {
    Ra.sl[6]=1230; /* line # 1230 */
    V_src_control=NULL;
  }
  Ra.sl[6]=1231; /* line # 1231 */
  V_src_hde=V_src_control;
  Ra.sl[6]=1232; /* line # 1232 */
  V_src_cont_base=V_src_control;
  Ra.sl[6]=1233; /* line # 1233 */
  Ri.sl[4]=0;
  Ra.sl[6]=1234; /* line # 1234 */
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}
