/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.2A0/cpas_defs.h"


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nerr);


/* Procedure/Function : " sinh_g "  */
G PAS__SHG(G F_v){
  /* Local variable stored in C variable */
  G Rv0;
  register G Ret;

  /* Code of procedure/function */
  Rv0=exp(F_v);
  Ret=5.000000000000000E-001*(Rv0-1.000000000000000E+000/Rv0);
  return(Ret);
}


/* Procedure/Function : " cosh_g "  */
G PAS__CHG(G F_v){
  /* Local variable stored in C variable */
  G Rv0;
  register G Ret;

  /* Code of procedure/function */
  Rv0=exp(F_v);
  Ret=5.000000000000000E-001*(Rv0+1.000000000000000E+000/Rv0);
  return(Ret);
}


/* Procedure/Function : " tanh_g "  */
G PAS__THG(G F_v){
  /* Local variable stored in C variable */
  G Rv0;
  register G Ret;

  /* Code of procedure/function */
  Rv0=exp(-2.000000000000000E+000*fabs(F_v));
  Rv0=(1.000000000000000E+000-Rv0)/(1.000000000000000E+000+Rv0);
  if (F_v>0.000000000000000E-001) Ret=Rv0;
  else Ret=-Rv0;
  return(Ret);
}


/* Procedure/Function : " argsinh_g "  */
G PAS__ASHG(G F_v){
  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  Rv0=log(fabs(F_v)+sqrt(F_v*F_v+1.000000000000000E+000));
  if (F_v<0.000000000000000E-001) Ret=-Rv0;
  else Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " argcosh_g "  */
G PAS__ACHG(G F_v){
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  if (F_v<1.000000000000000E+000) PAS__ERROR(805);
  Ret=log(F_v+sqrt(F_v*F_v-1.000000000000000E+000));
  return(Ret);
}


/* Procedure/Function : " argtanh_g "  */
G PAS__ATHG(G F_v){
  register G Ret;

  /* Code of procedure/function */
  if (fabs(F_v)>=1.000000000000000E+000) PAS__ERROR(806);
  Ret=log((1.000000000000000E+000+F_v)/(1.000000000000000E+000-F_v))*5.000000000000000E-001;
  return(Ret);
}
