/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 456 ) = {
 10,  10, 109,  97, 106, 111, 114,  95,  99, 104,  97, 114,  63,  63,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47,  99, 112,  97,
115,  95,  95, 115, 116, 114, 105, 110, 103,  46, 112,  97, 115,  10,  10, 109,
105, 110, 111, 114,  95,  99, 104,  97, 114,  11,  11,  99, 104,  97, 114,  95,
105, 110,  95, 115, 116, 114,   7,   7,  99, 104,  97,  95,  99, 112, 121,  10,
 10,  99, 104, 116,  95, 116, 111,  95,  99, 104, 116,  10,  10,  99, 104, 116,
 95, 116, 111,  95, 115, 116, 114,   7,   7, 115, 116, 114,  95,  99, 112, 121,
  8,   8, 115, 101, 116,  95,  99,  97, 115, 101,   9,   9,  99, 111, 110,  99,
 97, 116,  95,  99,  99,   9,   9,  99, 111, 110,  99,  97, 116,  95, 115,  99,
  9,   9,  99, 111, 110,  99,  97, 116,  95,  99, 115,   9,   9,  99, 111, 110,
 99,  97, 116,  95, 115, 115,   9,   9,  99, 111, 110,  99,  97, 116,  95, 116,
 99,   9,   9,  99, 111, 110,  99,  97, 116,  95,  99, 116,   9,   9,  99, 111,
110,  99,  97, 116,  95, 115, 116,   9,   9,  99, 111, 110,  99,  97, 116,  95,
116, 115,   9,   9,  99, 111, 110,  99,  97, 116,  95, 116, 116,   6,   6, 115,
117,  98, 115, 116, 114,   6,   6, 115, 117,  98, 115, 116, 114,   9,   9, 105,
110, 100, 101, 120,  95,  99, 104,  97,   9,   9, 105, 110, 100, 101, 120,  95,
115, 116, 114,  10,  10, 110, 105, 110, 100, 101, 120,  95,  99, 104,  97,  10,
 10, 110, 105, 110, 100, 101, 120,  95, 115, 116, 114,   7,   7, 115, 116, 114,
 95, 108, 101, 110,   9,   9, 115, 116, 114,  95, 109,  97, 116,  99, 104,   9,
  9,  99, 104, 116,  95, 109,  97, 116,  99, 104,  17,  17, 115, 116, 114, 105,
110, 103,  95, 108, 111,  99,  97, 116, 101,  95, 115, 101, 112,   6,   6, 115,
116, 114,  95, 108, 116,   6,   6, 115, 116, 114,  95, 108, 101,   6,   6, 115,
116, 114,  95, 103, 101,   6,   6, 115, 116, 114,  95, 103, 116,   6,   6, 115,
116, 114,  95, 101, 113,   6,   6, 115, 116, 114,  95, 110, 101,   6,   6, 115,
116, 114,  95, 108, 101,   6,   6, 115, 116, 114,  95, 103, 101,   6,   6, 115,
116, 114,  95, 103, 116,   6,   6, 115, 116, 114,  95, 101, 113,   6,   6, 115,
116, 114,  95, 110, 101,   0,   0,   0
};




/* Procedure/Function : " major_char "  */
C PAS__MAJOR_CHAR(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=68; /* line # 68 */
  if (F_ch>=97&&F_ch<=122) Ret=(C)((SL)F_ch-32);
  else {
    Ra.sl[6]=69; /* line # 69 */
    Ret=F_ch;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " minor_char "  */
C PAS__MINOR_CHAR(C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+77;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=76; /* line # 76 */
  if (F_ch>=65&&F_ch<=90) Ret=(C)((SL)F_ch+32);
  else {
    Ra.sl[6]=77; /* line # 77 */
    Ret=F_ch;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " char_in_str "  */
V PAS__CHAR_IN_STR(V Ret, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  ((UB *)Ret)[0]=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+89;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=84; /* line # 84 */
  ((C *)Ret)[2]=F_ch;
  Ra.sl[6]=85; /* line # 85 */
  ((UB *)Ret)[1]=1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cha_cpy "  */
void PAS__CHA_TO_STR(V F_dst, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+102;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=95; /* line # 95 */
  ((UB *)F_dst)[1]=1;
  Ra.sl[6]=96; /* line # 96 */
  ((C *)F_dst)[2]=F_ch;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cht_to_cht "  */
void PAS__CHT_TO_CHT(V F_dst, SL F_sd, V F_src, SL F_ss){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=107; /* line # 107 */
  if (F_ss>F_sd) Rv0=F_sd;
  else {
    Ra.sl[6]=108; /* line # 108 */
    Rv0=F_ss;
  }
  Ra.sl[6]=109; /* line # 109 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1-1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
  Ra.sl[6]=110; /* line # 110 */
  if (F_ss<F_sd) {
    Ra.sl[6]=111; /* line # 111 */
    Rv2=Rv0+1;
    for( Rf0=(F_sd+1)-(Rv0+1);Rf0>0;Rf0-- ) {
      ((C *)F_dst)[Rv2-1]=32;
      Rv2++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cht_to_str "  */
void PAS__CHT_TO_STR(V F_dst, V F_src, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+123;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=122; /* line # 122 */
  Ra.sl[6]=124; /* line # 124 */
  if (F_sz>((UB *)F_dst)[0]) Rv0=((UB *)F_dst)[0];
  else {
    Ra.sl[6]=125; /* line # 125 */
    Rv0=F_sz;
  }
  Ra.sl[6]=126; /* line # 126 */
  ((UB *)F_dst)[1]=Rv0;
  Ra.sl[6]=127; /* line # 127 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)F_dst)[Rv1+1]=((C *)F_src)[Rv1-1];
    Rv1++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_cpy "  */
void PAS__STR_TO_STR(V F_dst, V F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+135;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=138; /* line # 138 */
  if (F_src!=F_dst&&F_dst!=NULL) {
    Ra.sl[6]=139; /* line # 139 */
    Rv0=F_dst;
    Ra.sl[6]=140; /* line # 140 */
    if (F_src!=NULL) {
      Ra.sl[6]=142; /* line # 142 */
      Rv1=((UB *)F_src)[1];
      Ra.sl[6]=143; /* line # 143 */
      if (Rv1>((UB *)Rv0)[0]) Rv1=((UB *)Rv0)[0];
      Ra.sl[6]=144; /* line # 144 */
      ((UB *)Rv0)[1]=Rv1;
      Ra.sl[6]=145; /* line # 145 */
      Rv2=1;
      for( Rf0=Rv1;Rf0>0;Rf0-- ) {
        ((C *)Rv0)[Rv2+1]=((C *)F_src)[Rv2+1];
        Rv2++;
      }
    }
    else {
      Ra.sl[6]=147; /* line # 147 */
      ((UB *)Rv0)[1]=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_case "  */
void PAS__SET_CASE(V F_s, UB F_maj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+144;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=154; /* line # 154 */
  if (F_maj) {
    Ra.sl[6]=156; /* line # 156 */
    Rv0=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=157; /* line # 157 */
      if (((C *)F_s)[Rv0+1]>=97&&((C *)F_s)[Rv0+1]<=122) ((C *)F_s)[Rv0+1]=(C)((
      SL)((C *)F_s)[Rv0+1]-32);
      Rv0++;
    }
  }
  else {
    Ra.sl[6]=161; /* line # 161 */
    Rv1=1;
    for( Rf0=((UB *)F_s)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=162; /* line # 162 */
      if (((C *)F_s)[Rv1+1]>=65&&((C *)F_s)[Rv1+1]<=90) ((C *)F_s)[Rv1+1]=(C)((SL)
      ((C *)F_s)[Rv1+1]+32);
      Rv1++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " concat_cc "  */
V PAS__CON_CHA_CHA(V Ret, C F_c1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  ((UB *)Ret)[0]=2;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+154;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=170; /* line # 170 */
  ((UB *)Ret)[1]=2;
  Ra.sl[6]=171; /* line # 171 */
  ((C *)Ret)[2]=F_c1;
  Ra.sl[6]=172; /* line # 172 */
  ((C *)Ret)[3]=F_c2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_sc "  */
V PAS__CON_STR_CHA(V Ret, V F_s1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+165;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=182; /* line # 182 */
  Rv0=((UB *)F_s1)[1];
  Ra.sl[6]=183; /* line # 183 */
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  Ra.sl[6]=184; /* line # 184 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=185; /* line # 185 */
  ((C *)Ret)[(Rv0+1)+1]=F_c2;
  Ra.sl[6]=186; /* line # 186 */
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_cs "  */
V PAS__CON_CHA_STR(V Ret, C F_c1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+176;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=197; /* line # 197 */
  Rv0=((UB *)F_s2)[1];
  Ra.sl[6]=198; /* line # 198 */
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  Ra.sl[6]=199; /* line # 199 */
  ((C *)Ret)[2]=F_c1;
  Ra.sl[6]=200; /* line # 200 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=201; /* line # 201 */
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ss "  */
V PAS__CON_STR_STR(V Ret, V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+187;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=211; /* line # 211 */
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else {
    Ra.sl[6]=212; /* line # 212 */
    Rv0=((UB *)F_s1)[1];
  }
  Ra.sl[6]=213; /* line # 213 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=214; /* line # 214 */
  Rv2=((UB *)Ret)[0]-Rv0;
  Ra.sl[6]=215; /* line # 215 */
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Ra.sl[6]=216; /* line # 216 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=218; /* line # 218 */
    Rv0=Rv0+1;
    Ra.sl[6]=219; /* line # 219 */
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  Ra.sl[6]=221; /* line # 221 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_tc "  */
V PAS__CON_CHT_CHA(V Ret, V F_s1, SL F_l1, C F_c2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=232; /* line # 232 */
  Rv0=((UB *)Ret)[0];
  Ra.sl[6]=233; /* line # 233 */
  if (F_l1>=((UB *)Ret)[0]) {
    Ra.sl[6]=235; /* line # 235 */
    Rv1=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
      Rv1++;
    }
    Ra.sl[6]=236; /* line # 236 */
    ((UB *)Ret)[1]=Rv0;
  }
  else {
    Ra.sl[6]=240; /* line # 240 */
    Rv2=1;
    for( Rf0=F_l1;Rf0>0;Rf0-- ) {
      ((C *)Ret)[Rv2+1]=((C *)F_s1)[Rv2-1];
      Rv2++;
    }
    Ra.sl[6]=241; /* line # 241 */
    ((C *)Ret)[(F_l1+1)+1]=F_c2;
    Ra.sl[6]=242; /* line # 242 */
    ((UB *)Ret)[1]=F_l1+1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ct "  */
V PAS__CON_CHA_CHT(V Ret, C F_c1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+209;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=254; /* line # 254 */
  Rv0=F_l2;
  Ra.sl[6]=255; /* line # 255 */
  if (Rv0>=((UB *)Ret)[0]) Rv0=((UB *)Ret)[0]-1;
  Ra.sl[6]=256; /* line # 256 */
  ((C *)Ret)[2]=F_c1;
  Ra.sl[6]=257; /* line # 257 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[(Rv1+1)+1]=((C *)F_s2)[Rv1-1];
    Rv1++;
  }
  Ra.sl[6]=258; /* line # 258 */
  ((UB *)Ret)[1]=Rv0+1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_st "  */
V PAS__CON_STR_CHT(V Ret, V F_s1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+220;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=269; /* line # 269 */
  if (((UB *)F_s1)[1]>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else {
    Ra.sl[6]=270; /* line # 270 */
    Rv0=((UB *)F_s1)[1];
  }
  Ra.sl[6]=271; /* line # 271 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=272; /* line # 272 */
  Rv2=((UB *)Ret)[0]-Rv0;
  Ra.sl[6]=273; /* line # 273 */
  if (Rv2>F_l2) Rv2=F_l2;
  Ra.sl[6]=274; /* line # 274 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=276; /* line # 276 */
    Rv0=Rv0+1;
    Ra.sl[6]=277; /* line # 277 */
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  Ra.sl[6]=279; /* line # 279 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_ts "  */
V PAS__CON_CHT_STR(V Ret, V F_s1, SL F_l1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+231;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=290; /* line # 290 */
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else {
    Ra.sl[6]=291; /* line # 291 */
    Rv0=F_l1;
  }
  Ra.sl[6]=292; /* line # 292 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Ra.sl[6]=293; /* line # 293 */
  Rv2=((UB *)Ret)[0]-Rv0;
  Ra.sl[6]=294; /* line # 294 */
  if (Rv2>((UB *)F_s2)[1]) Rv2=((UB *)F_s2)[1];
  Ra.sl[6]=295; /* line # 295 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=297; /* line # 297 */
    Rv0=Rv0+1;
    Ra.sl[6]=298; /* line # 298 */
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3+1];
    Rv3++;
  }
  Ra.sl[6]=300; /* line # 300 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " concat_tt "  */
V PAS__CON_CHT_CHT(V Ret, V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+242;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=311; /* line # 311 */
  if (F_l1>((UB *)Ret)[0]) Rv0=((UB *)Ret)[0];
  else {
    Ra.sl[6]=312; /* line # 312 */
    Rv0=F_l1;
  }
  Ra.sl[6]=313; /* line # 313 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv1+1]=((C *)F_s1)[Rv1-1];
    Rv1++;
  }
  Ra.sl[6]=314; /* line # 314 */
  Rv2=((UB *)Ret)[0]-Rv0;
  Ra.sl[6]=315; /* line # 315 */
  if (Rv2>F_l2) Rv2=F_l2;
  Ra.sl[6]=316; /* line # 316 */
  Rv3=1;
  for( Rf0=Rv2;Rf0>0;Rf0-- ) {
    Ra.sl[6]=318; /* line # 318 */
    Rv0=Rv0+1;
    Ra.sl[6]=319; /* line # 319 */
    ((C *)Ret)[Rv0+1]=((C *)F_s2)[Rv3-1];
    Rv3++;
  }
  Ra.sl[6]=321; /* line # 321 */
  ((UB *)Ret)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_STR(V Ret, V F_s, SL F_i, SL F_j){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+253;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=331; /* line # 331 */
  if (F_i<1) F_i=1;
  else {
    Ra.sl[6]=332; /* line # 332 */
    if (F_i>((UB *)F_s)[1]) {
      Ra.sl[6]=333; /* line # 333 */
      F_j=0;
      goto L_l_0;
    }
  }
  Ra.sl[6]=335; /* line # 335 */
  if (F_j<=0) F_j=(((UB *)F_s)[1]-F_i)+1;
  else {
    Ra.sl[6]=336; /* line # 336 */
    if ((F_j+F_i)-1>((UB *)F_s)[1]) F_j=(((UB *)F_s)[1]-F_i)+1;
  }
  Ra.sl[6]=338; /* line # 338 */
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Ra.sl[6]=340; /* line # 340 */
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)+1];
    Rv0++;
  }
L_l_0:
  Ra.sl[6]=342; /* line # 342 */
  ((UB *)Ret)[1]=F_j;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " substr "  */
V PAS__SUBSTR_CHT(V Ret, V F_s, SL F_sz, SL F_i, SL F_j){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  ((UB *)Ret)[0]=255;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+261;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=351; /* line # 351 */
  if (F_i<1) F_i=1;
  else {
    Ra.sl[6]=352; /* line # 352 */
    if (F_i>F_sz) {
      Ra.sl[6]=353; /* line # 353 */
      F_j=0;
      goto L_l_0;
    }
  }
  Ra.sl[6]=355; /* line # 355 */
  if (F_j<=0) F_j=(F_sz-F_i)+1;
  else {
    Ra.sl[6]=356; /* line # 356 */
    if ((F_j+F_i)-1>F_sz) F_j=(F_sz-F_i)+1;
  }
  Ra.sl[6]=358; /* line # 358 */
  if (F_j>((UB *)Ret)[0]) F_j=((UB *)Ret)[0];
  Ra.sl[6]=360; /* line # 360 */
  Rv0=1;
  for( Rf0=F_j;Rf0>0;Rf0-- ) {
    ((C *)Ret)[Rv0+1]=((C *)F_s)[((Rv0+F_i)-1)-1];
    Rv0++;
  }
L_l_0:
  Ra.sl[6]=362; /* line # 362 */
  ((UB *)Ret)[1]=F_j;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " index_cha "  */
SL PAS__INDEX_CHA(V F_s1, SL F_l1, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+269;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=375; /* line # 375 */
  Rv0=0;
  Ra.sl[6]=376; /* line # 376 */
  Rv1=0;
  Ra.sl[6]=377; /* line # 377 */
  while (Rv0<F_l1&&!Rv1){
    Ra.sl[6]=379; /* line # 379 */
    Rv0=Rv0+1;
    Ra.sl[6]=380; /* line # 380 */
    Rv1=F_ch==((C *)F_s1)[Rv0-1];
  }
  Ra.sl[6]=382; /* line # 382 */
  if (!Rv1) Rv0=0;
  Ra.sl[6]=383; /* line # 383 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " index_str "  */
SL PAS__INDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  C Rv2;
  SL Rv3;
  SL Rv4;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+280;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=396; /* line # 396 */
  if (F_s1==F_s2) Rv0=1;
  else {
    Ra.sl[6]=399; /* line # 399 */
    Rv1=0;
    Ra.sl[6]=400; /* line # 400 */
    Rv0=0;
    Ra.sl[6]=401; /* line # 401 */
    if (F_l2>0&&F_l1>=F_l2) {
      Ra.sl[6]=403; /* line # 403 */
      Rv2=((C *)F_s2)[0];
      Ra.sl[6]=404; /* line # 404 */
      while (Rv0<=F_l1-F_l2&&!Rv1){
        Ra.sl[6]=406; /* line # 406 */
        Rv0=Rv0+1;
        Ra.sl[6]=407; /* line # 407 */
        if (Rv2==((C *)F_s1)[Rv0-1]) {
          Ra.sl[6]=409; /* line # 409 */
          Rv3=Rv0+1;
          Ra.sl[6]=410; /* line # 410 */
          Rv4=2;
          Ra.sl[6]=411; /* line # 411 */
          while (Rv4<=F_l2&&((C *)F_s1)[Rv3-1]==((C *)F_s2)[Rv4-1]){
            Ra.sl[6]=413; /* line # 413 */
            Rv4=Rv4+1;
            Ra.sl[6]=414; /* line # 414 */
            Rv3=Rv3+1;
          }
          Ra.sl[6]=416; /* line # 416 */
          Rv1=Rv4>F_l2;
        }
      }
    }
    Ra.sl[6]=420; /* line # 420 */
    if (!Rv1) Rv0=0;
  }
  Ra.sl[6]=422; /* line # 422 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nindex_cha "  */
SL PAS__NINDEX_CHA(V F_s, SL F_l, C F_c, SL F_nb, SL F_ip, UB F_nc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  C Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+291;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=438; /* line # 438 */
  Rv0=0;
  Ra.sl[6]=439; /* line # 439 */
  if (F_nb==0) F_nb=1;
  Ra.sl[6]=440; /* line # 440 */
  if (!F_nc) F_c=PAS__MAJOR_CHAR(F_c);
  Ra.sl[6]=441; /* line # 441 */
  if (F_l>0) {
    Ra.sl[6]=442; /* line # 442 */
    if (F_nb>0) {
      Ra.sl[6]=444; /* line # 444 */
      if (F_ip<=0) F_ip=1;
      Ra.sl[6]=445; /* line # 445 */
      while (F_ip<=F_l&&!Rv0){
        Ra.sl[6]=447; /* line # 447 */
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else {
          Ra.sl[6]=448; /* line # 448 */
          Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        }
        Ra.sl[6]=449; /* line # 449 */
        if (F_c==Rv1) {
          Ra.sl[6]=451; /* line # 451 */
          F_nb=F_nb -1;
          Ra.sl[6]=452; /* line # 452 */
          Rv0=F_nb==0;
        }
        Ra.sl[6]=454; /* line # 454 */
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      Ra.sl[6]=459; /* line # 459 */
      F_nb= -F_nb;
      Ra.sl[6]=460; /* line # 460 */
      if (F_ip<0||F_ip>F_l) F_ip=F_l;
      Ra.sl[6]=461; /* line # 461 */
      while (F_ip>1&&!Rv0){
        Ra.sl[6]=463; /* line # 463 */
        if (F_nc) Rv1=((C *)F_s)[F_ip-1];
        else {
          Ra.sl[6]=464; /* line # 464 */
          Rv1=PAS__MAJOR_CHAR(((C *)F_s)[F_ip-1]);
        }
        Ra.sl[6]=465; /* line # 465 */
        if (F_c==Rv1) {
          Ra.sl[6]=467; /* line # 467 */
          F_nb=F_nb -1;
          Ra.sl[6]=468; /* line # 468 */
          Rv0=F_nb==0;
        }
        Ra.sl[6]=470; /* line # 470 */
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  Ra.sl[6]=474; /* line # 474 */
  if (!Rv0) F_ip=0;
  Ra.sl[6]=475; /* line # 475 */
  Ret=F_ip;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " nindex_str "  */
SL PAS__NINDEX_STR(V F_s1, SL F_l1, V F_s2, SL F_l2, SL F_nb, SL F_ip, UB F_nc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  C Rv2;
  C Rv3;
  SL Rv4;
  SL Rv5;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+303;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=492; /* line # 492 */
  Rv0=0;
  Ra.sl[6]=493; /* line # 493 */
  if (F_nb==0) F_nb=1;
  Ra.sl[6]=494; /* line # 494 */
  if (F_l2>0&&F_l1>=F_l2) {
    Ra.sl[6]=496; /* line # 496 */
    Rv1=(F_l1-F_l2)+1;
    Ra.sl[6]=497; /* line # 497 */
    if (F_nb>0) {
      Ra.sl[6]=499; /* line # 499 */
      if (F_ip<=0) F_ip=1;
      Ra.sl[6]=500; /* line # 500 */
      if (F_nc) Rv2=((C *)F_s2)[0];
      else {
        Ra.sl[6]=501; /* line # 501 */
        Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      }
      Ra.sl[6]=502; /* line # 502 */
      while (F_ip<=Rv1&&!Rv0){
        Ra.sl[6]=504; /* line # 504 */
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else {
          Ra.sl[6]=505; /* line # 505 */
          Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        }
        Ra.sl[6]=506; /* line # 506 */
        if (Rv2==Rv3) {
          Ra.sl[6]=508; /* line # 508 */
          Rv4=F_ip+1;
          Ra.sl[6]=509; /* line # 509 */
          Rv5=2;
          Ra.sl[6]=510; /* line # 510 */
          Rv0=1;
          Ra.sl[6]=511; /* line # 511 */
          while (Rv5<=F_l2&&Rv0){
            Ra.sl[6]=513; /* line # 513 */
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else {
              Ra.sl[6]=514; /* line # 514 */
              Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)F_s2)
              [Rv5-1]);
            }
            Ra.sl[6]=515; /* line # 515 */
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          Ra.sl[6]=517; /* line # 517 */
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        Ra.sl[6]=519; /* line # 519 */
        if (!Rv0) F_ip=F_ip+1;
      }
    }
    else {
      Ra.sl[6]=524; /* line # 524 */
      F_nb= -F_nb;
      Ra.sl[6]=525; /* line # 525 */
      if (F_ip<0||F_ip>Rv1) F_ip=Rv1;
      Ra.sl[6]=526; /* line # 526 */
      if (F_nc) Rv2=((C *)F_s2)[0];
      else {
        Ra.sl[6]=527; /* line # 527 */
        Rv2=PAS__MAJOR_CHAR(((C *)F_s2)[0]);
      }
      Ra.sl[6]=528; /* line # 528 */
      while (F_ip>0&&!Rv0){
        Ra.sl[6]=530; /* line # 530 */
        if (F_nc) Rv3=((C *)F_s1)[F_ip-1];
        else {
          Ra.sl[6]=531; /* line # 531 */
          Rv3=PAS__MAJOR_CHAR(((C *)F_s1)[F_ip-1]);
        }
        Ra.sl[6]=532; /* line # 532 */
        if (Rv2==Rv3) {
          Ra.sl[6]=534; /* line # 534 */
          Rv4=F_ip+1;
          Ra.sl[6]=535; /* line # 535 */
          Rv5=2;
          Ra.sl[6]=536; /* line # 536 */
          Rv0=1;
          Ra.sl[6]=537; /* line # 537 */
          while (Rv5<=F_l2&&Rv0){
            Ra.sl[6]=539; /* line # 539 */
            if (F_nc) Rv0=((C *)F_s1)[Rv4-1]==((C *)F_s2)[Rv5-1];
            else {
              Ra.sl[6]=540; /* line # 540 */
              Rv0=PAS__MAJOR_CHAR(((C *)F_s1)[Rv4-1])==PAS__MAJOR_CHAR(((C *)F_s2)
              [Rv5-1]);
            }
            Ra.sl[6]=541; /* line # 541 */
            Rv4=Rv4+1;
            Rv5=Rv5+1;
          }
          Ra.sl[6]=543; /* line # 543 */
          if (Rv0) {
            F_nb=F_nb -1;
            Rv0=F_nb==0;
          }
        }
        Ra.sl[6]=545; /* line # 545 */
        if (!Rv0) F_ip=F_ip-1;
      }
    }
  }
  Ra.sl[6]=549; /* line # 549 */
  if (!Rv0) F_ip=0;
  Ra.sl[6]=550; /* line # 550 */
  Ret=F_ip;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_len "  */
SL PAS__LENGTH_STR(V F_s){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+315;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=558; /* line # 558 */
  Ret=((UB *)F_s)[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_match "  */
SL PAS__MATCH_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+324;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=569; /* line # 569 */
  if (((UB *)F_s1)[1]<((UB *)F_s2)[1]) Rv0=((UB *)F_s1)[1];
  else {
    Ra.sl[6]=570; /* line # 570 */
    Rv0=((UB *)F_s2)[1];
  }
  Ra.sl[6]=571; /* line # 571 */
  Rv1=1;
  Ra.sl[6]=572; /* line # 572 */
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1+1]==((C *)F_s2)[Rv1+1])
  Rv1=Rv1+1;
  Ra.sl[6]=573; /* line # 573 */
  if (Rv1>Rv0) {
    Ra.sl[6]=574; /* line # 574 */
    Rv2=((UB *)F_s1)[1]-((UB *)F_s2)[1];
  }
  else {
    Ra.sl[6]=576; /* line # 576 */
    Rv2=(SL)((C *)F_s1)[Rv1+1]-(SL)((C *)F_s2)[Rv1+1];
  }
  Ra.sl[6]=577; /* line # 577 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cht_match "  */
SL PAS__MATCH_CHT(V F_s1, SL F_cap1, SL F_l1, V F_s2, SL F_cap2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+335;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=590; /* line # 590 */
  if (F_l1<=0) F_l1=F_cap1;
  Ra.sl[6]=591; /* line # 591 */
  if (F_l2<=0) F_l2=F_cap2;
  Ra.sl[6]=592; /* line # 592 */
  if (F_l1<F_l2) Rv0=11;
  else {
    Ra.sl[6]=593; /* line # 593 */
    Rv0=F_l2;
  }
  Ra.sl[6]=594; /* line # 594 */
  Rv1=1;
  Ra.sl[6]=595; /* line # 595 */
  while (Rv1<=Rv0&&((C *)F_s1)[Rv1-1]==((C *)F_s2)[Rv1-1])
  Rv1=Rv1+1;
  Ra.sl[6]=596; /* line # 596 */
  if (Rv1>Rv0) {
    Ra.sl[6]=597; /* line # 597 */
    Rv2=F_l1-F_l2;
  }
  else {
    Ra.sl[6]=599; /* line # 599 */
    Rv2=(SL)((C *)F_s1)[Rv1-1]-(SL)((C *)F_s2)[Rv1-1];
  }
  Ra.sl[6]=600; /* line # 600 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " string_locate_sep "  */
void PAS__STR_LSEP(V F_st, SL F_l, V F_sp, SL F_n, V F_tp, SL F_nsp, SL *F_ie){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+346;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=614; /* line # 614 */
  (*F_ie)=0;
  Ra.sl[6]=615; /* line # 615 */
  Rv0=1;
  for( Rf0=F_l;Rf0>0;Rf0-- ) {
    Ra.sl[6]=617; /* line # 617 */
    Rv1=1;
    Ra.sl[6]=618; /* line # 618 */
    while (Rv1<=F_n&&((C *)F_sp)[Rv1-1]!=((C *)F_st)[Rv0-1])
    Rv1=Rv1+1;
    Ra.sl[6]=619; /* line # 619 */
    if (Rv1<=F_n) {
      Ra.sl[6]=621; /* line # 621 */
      (*F_ie)=(*F_ie)+1;
      Ra.sl[6]=622; /* line # 622 */
      if ((*F_ie)>=F_nsp) {
        (*F_ie)= -((*F_ie) -1);
        goto L_l_0;
      }
      Ra.sl[6]=623; /* line # 623 */
      ((UB *)F_tp)[(*F_ie)-1]=Rv1;
      (*F_ie)=(*F_ie)+1;
      ((UB *)F_tp)[(*F_ie)-1]=Rv0;
    }
    Rv0++;
  }
L_l_0:
  Ra.sl[6]=627; /* line # 627 */
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_lt "  */
UB PAS__LT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+365;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=635; /* line # 635 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+373;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=642; /* line # 642 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)<=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+381;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=649; /* line # 649 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+389;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=656; /* line # 656 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+397;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=663; /* line # 663 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)==0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_CHT(V F_s1, SL F_l1, V F_s2, SL F_l2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+405;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=670; /* line # 670 */
  Ret=PAS__MATCH_CHT(F_s1,F_l1, F_l1, F_s2,F_l2, F_l2)!=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_le "  */
UB PAS__LE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+413;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=675; /* line # 675 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)<=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ge "  */
UB PAS__GE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+421;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=680; /* line # 680 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_gt "  */
UB PAS__GT_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+429;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=685; /* line # 685 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)>0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_eq "  */
UB PAS__EQ_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+437;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=690; /* line # 690 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)==0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " str_ne "  */
UB PAS__NE_STR(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+445;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=695; /* line # 695 */
  Ret=PAS__MATCH_STR(F_s1,F_s2)!=0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
