%pragma list_on;
{
 *************************************************************************
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                      MMM    MMM   XXX      XXX  DDDDDDDD              *
 *                      MMMM  MMMM    XXX    XXX   DDDDDDDDDD            *
 *                      MM MMMM MM     XXX  XXX    DD      DDD           *
 *                      MM  MM  MM      XXXXXX     DD       DD           *
 *                      MM      MM       XXXX      DD       DD           *
 *        T  H  E       MM      MM       XXXX      DD       DD           *
 *                      MM      MM      XXXXXX     DD       DD           *
 *                      MM      MM     XXX  XXX    DD      DDD           *
 *                      MM      MM    XXX    XXX   DDDDDDDDDD            *
 *                     MMMM    MMMM  XXX      XXX  DDDDDDDD              *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *              SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M              *
 *             S       Y   Y  S         T    E      MM   MM              *
 *             S        Y Y   S         T    E      M M M M              *
 *              SSSS     Y     SSSS     T    EEEEE  M  M  M              *
 *                  S    Y         S    T    E      M     M              *
 *                  S    Y         S    T    E      M     M  ..          *
 *             SSSSS     Y    SSSSS     T    EEEEEE M     M  ..          *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                                                                       *
 *                        P. WOLFERS Software                            *
 *                                                                       *
 *                  Laboratoire de Cristallographie                      *
 *                                                                       *
 *                         B.P. 166 C.N.R.S.                             *
 *                                                                       *
 *                      25 Avenue des Martyrs                            *
 *                                                                       *
 *                      F 38042 GRENOBLE CEDEX 9                         *
 *                                                                       *
 *                                                                       *
 *************************************************************************

 /////////////////////////////////////////////////////////////////////////
 //                                                                     //
 //                    General Public License                           //
 //                                                                     //
 // This file is part of the V C++ GUI Framework, and is covered        //
 // under the terms of the GNU Library General Public License,          //
 // Version 2. This program has NO WARRANTY. See the source file        //
 // vapp.cxx for more complete information about license terms.         //
 //                                                                     //
 // This license described in this file overrides all other licenses    //
 // that might be specified in other files for this library.            //
 //                                                                     //
 // This program is free software; you can redistribute it and/or       //
 // modify it under the terms of the GNU Lesser General Public          //
 // License as published by the Free Software Foundation; either        //
 // version 2.1 of the License, or (at your option) any later version.  //
 //                                                                     //
 // This software is distributed in the hope that it will be useful,    //
 // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
 // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
 // Library General Public License for more details.                    //
 //                                                                     //
 // You should have received a copy of the GNU Lesser General Public    //
 // License along with this library (see COPYING.LIB); if not, write to //
 // the Free Software Foundation :                                      //
 //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
 //                                                                     //
 /////////////////////////////////////////////////////////////////////////
}

{
  ***********************************************************
  *                                                         *
  *                                                         *
  *            G E N   S P A C E   G R O U P                *
  *                                                         *
  *                                                         *
  *                   P R O G R A M                         *
  *                                                         *
  *                                                         *
  *    S P A C E    G R O U P    R E L A T I O N S H I P    *
  *                                                         *
  *                       T A B L E                         *
  *                                                         *
  *                                                         *
  *            Version 1.1-D  -  20-oct- 2010               *
  *                                                         *
  *                                                         *
  *   To generate the space group matrix from the name      *
  *             or number of space group.                   *
  *                                                         *
  *                                                         *
  *                                                         *
  ***********************************************************
}

const
  f_l_mon =   3;
  l_l_mon =  15;
  f_l_ort =  16;
  l_l_ort =  74;

  sgrp_tabl = sgrp_tbty[ 237,
     [ [ 2,      'P1'],   1,   0, ope_unit,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_tri ],
     [ [ 3,     'P-1'],   2,   0,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_tri ],

     [ [ 2,      'P2'],   3,   0,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 3,     'P21'],   4,   0,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 2,      'B2'],   5,   0,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 2,      'Pm'],   6,   0,   ope_mz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 2,      'Pb'],   7,   0,   ope_mz,[ 0,12, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 2,      'Bm'],   8,   0,   ope_mz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 2,      'Bb'],   9,   0,   ope_mz,[ 0,12, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 4,    'P2/m'],  10,   6,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 5,   'P21/m'],  11,   2,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 4,    'B2/m'],  12,   6,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 4,    'P2/b'],  13,   2,   ope_2z,[ 0,12, 0], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 5,   'P21/b'],  14,   2,   ope_2z,[ 0,12,12], [ 0, 0, 0], l_xyz, l_mon ],
     [ [ 4,    'B2/b'],  15,   2,   ope_2z,[ 0,12, 0], [ 0, 0, 0], l_xyz, l_mon ],

     [ [ 4,    'P222'],  16,   3,   ope_2x,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'P2221'],  17,   3,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 6,  'P21212'],  18,   3,   ope_2x,[12,12, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 7, 'P212121'],  19,   4,   ope_2x,[12,12, 0], [ 6, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'C2221'],  20,   3,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'C222'],  21,   3,   ope_2x,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'F222'],  22,   3,   ope_2x,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'I222'],  23,   3,   ope_2x,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 7, 'I212121'],  24,   4,   ope_2x,[12,12, 0], [ 6, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pmm2'],  25,   3,   ope_my,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'Pmc21'],  26,   6,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'Pcc2'],  27,   3,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pma2'],  28,   3,   ope_mx,[12, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'Pca21'],  29,   4,   ope_mx,[12, 0,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pnc2'],  30,   3,   ope_mx,[ 0,12,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'Pmn21'],  31,   6,   ope_2z,[12, 0,12], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'Pba2'],  32,   3,   ope_mx,[12,12, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'Pna21'],  33,   4,   ope_mx,[12,12,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pnn2'],  34,   3,   ope_mx,[12,12,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Cmm2'],  35,   3,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 5,   'Cmc21'],  36,   6,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'Ccc2'],  37,   3,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Amm2'],  38,   3,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Abm2'],  39,   3,   ope_mx,[ 0,12, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Ama2'],  40,   3,   ope_mx,[12, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Aba2'],  41,   3,   ope_mx,[12,12, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Fmm2'],  42,   3,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Fdd2'],  43,   3,   ope_mx,[ 6, 6, 6], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Imm2'],  44,   3,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Iba2'],  45,   3,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Ima2'],  46,   3,   ope_mx,[12, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pmmm'],  47,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pnnn'],  48,  16,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_ort ], { Org: 222* }
     [ [ 4,    'Pccm'],  49,  27,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pban'],  50,  16,  ope_inv,[12,12, 0], [ 0, 0, 0], l_xyz, l_ort ], { Org: 222* }
     [ [ 4,    'Pmma'],  51,  28,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xzy, l_ort ],
     [ [ 4,    'Pnna'],  52,  17,  ope_inv,[ 0, 0, 0], [ 6, 6, 6], l_xzy, l_ort ], { * }
     [ [ 4,    'Pmna'],  53,  17,  ope_inv,[ 0, 0, 0], [ 6, 0, 0], l_xyz, l_ort ], { * }
     [ [ 4,    'Pcca'],  54,  17,  ope_inv,[ 0, 0, 0], [ 6, 0, 6], l_zyx, l_ort ],
     [ [ 4,    'Pbam'],  55,  18,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],
     [ [ 4,    'Pccn'],  56,  18,  ope_inv,[ 0, 0, 0], [ 6, 6, 6], l_xyz, l_ort ],
     [ [ 4,    'Pbcm'],  57,  18,  ope_inv,[ 0, 0, 0], [ 0, 6, 0], l_zxy, l_ort ], { * }
     [ [ 4,    'Pnnm'],  58,  18,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_xyz, l_ort ],
     [ [ 4,    'Pmmn'],  59,  18,  ope_inv,[12,12, 0], [ 0, 0, 0], l_xyz, l_ort ], { Org: mmn }
     [ [ 4,    'Pbcn'],  60,  18,  ope_inv,[ 0, 0, 0], [ 0, 6, 6], l_yzx, l_ort ], { * }
     [ [ 4,    'Pbca'],  61,  19,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'Pnma'],  62,  19,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_zxy, l_ort ],
     [ [ 4,    'Cmcm'],  63,  40,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_zyx, l_ort ],
     [ [ 4,    'Cmca'],  64,  19,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_zxy, l_ort ], { * }
     [ [ 4,    'Cmmm'],  65,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ],

     [ [ 4,    'Cccm'],  66,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_yxz, l_ort ],
     [ [ 4,    'Cmma'],  67,  16,  ope_inv,[ 0, 0, 0], [ 6, 0, 0], l_zxy, l_ort ],
     [ [ 4,    'Ccca'],  68,  16,  ope_inv,[12, 0,12], [ 0, 0, 0], l_xyz, l_ort ], { Org: 222 * }
     [ [ 4,    'Fmmm'],  69,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ], { * }

     [ [ 4,    'Fddd'],  70,  19,  ope_inv,[ 6, 6, 6], [ 0, 0, 0], l_xyz, l_ort ], { * }
     [ [ 4,    'Immm'],  71,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ], { * }
     [ [ 4,    'Ibam'],  72,  16,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_yxz, l_ort ],
     [ [ 4,    'Ibca'],  73,  19,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_ort ], { * }
     [ [ 4,    'Imma'],  74,  19,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_xyz, l_ort ], { * }

     [ [ 2,      'P4'],  75,   3,   ope_4z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'P41'],  76,   4,   ope_4z,[ 0, 0, 6], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'P42'],  77,   3,   ope_4z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'P43'],  78,   4,   ope_4z,[ 0, 0,18], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 2,      'I4'],  79,   3,   ope_4z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'I41'],  80,   3,   ope_4z,[ 0,12, 6], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'P-4'],  81,   3,  ope_4bz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 3,     'I-4'],  82,   3,  ope_4bz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'P4/m'],  83,  75,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { (-1|0,0,0)*P4 }
     [ [ 5,   'P42/m'],  84,  77,   ope_mz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'P4/n'],  85,  81,   ope_mz,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ], { (mz|1/4,1/4,0)*P-4 }
     [ [ 5,   'P42/n'],  86,  81,   ope_mz,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ], { (mz|1/4,1/4,1/4)*P-4 }
     [ [ 4,    'I4/m'],  87,  75,   ope_mz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], 
     [ [ 5,   'I41/a'],  88,  81,  ope_inv,[12, 0,18], [ 0, 0, 0], l_xyz, l_qua ], { Org: -4 : (-1|0,1/4,0)*P-4 }

     [ [ 4,    'P422'],  89,  75,   ope_2v,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { * }
     [ [ 5,   'P4212'],  90,  75,   ope_2u,[ 0, 0, 0], [12, 0, 0], l_xyz, l_qua ], { (2u|0,0,0)*P4 }
     [ [ 5,   'P4122'],  91,  76,   ope_2y,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { * }
     [ [ 6,  'P41212'],  92,  76,   ope_2u,[ 0, 0, 0], [12, 0, 0], l_xyz, l_qua ], { * }
     [ [ 5,   'P4222'],  93,  77,   ope_2y,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P42212'],  94,  77,   ope_2u,[ 0, 0, 0], [12, 0, 0], l_xyz, l_qua ], { (2u|0,0,0)*P42 }
     [ [ 5,   'P4322'],  95,  78,   ope_2y,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { * }
     [ [ 6,  'P43212'],  96,  78,   ope_2u,[ 0, 0, 0], [12, 0, 0], l_xyz, l_qua ], { * }
     [ [ 4,    'I422'],  97,  75,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { * }
     [ [ 5,   'I4122'],  98,  76,   ope_2u,[ 0, 0, 0], [ 6,-6, 0], l_xyz, l_qua ], { * }

     [ [ 4,    'P4mm'],  99,  75,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ], { * }
     [ [ 4,    'P4bm'], 100,  75,   ope_my,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ], { ... }
     [ [ 5,   'P42cm'], 101,  77,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P42nm'], 102,  77,   ope_mv,[ 0, 0, 0], [12, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'P4cc'], 103,  75,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'P4nc'], 104,  75,   ope_my,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P42mc'], 105,  77,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P42bc'], 106,  77,   ope_my,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'I4mm'], 107,  75,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 4,    'I4cm'], 108,  75,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'I41md'], 109,  76,   ope_mx,[ 0, 0, 0], [ 6,-6, 0], l_xyz, l_qua ],
     [ [ 5,   'I41cd'], 110,  76,   ope_mx,[ 0, 0,12], [ 6,-6, 0], l_xyz, l_qua ],
     [ [ 5,   'P-42m'], 111,  81,   ope_2y,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P-42c'], 112,  81,   ope_2y,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P-421m'], 113,  81,   ope_2y,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P-421c'], 114,  81,   ope_2y,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P-4m2'], 115,  81,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P-4c2'], 116,  81,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P-4b2'], 117,  81,   ope_mx,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'P-4n2'], 118,  81,   ope_mx,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'I-4m2'], 119,  81,   ope_mx,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'I-4c2'], 120,  81,   ope_mx,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'I-42m'], 121,  81,   ope_2y,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 5,   'I-42d'], 122,  81,   ope_2y,[12, 0,18], [ 0, 0, 0], l_xyz, l_qua ],

     [ [ 6,  'P4/mmm'], 123,  99,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/mcc'], 124, 103,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/nbm'], 125,  89,  ope_inv,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/nnc'], 126,  89,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/mbm'], 127,  83,   ope_2y,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/mnc'], 128,  83,   ope_2y,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/nmm'], 129, 115,   ope_mz,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'P4/ncc'], 130,  85,   ope_2x,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/mmc'], 131,  84,   ope_2x,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/mcm'], 132,  84,   ope_2x,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/nbc'], 133,  86,   ope_2x,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/nnm'], 134, 111,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/mbc'], 135,  84,   ope_2x,[12,12, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/mnm'], 136, 102,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/nmc'], 137, 115,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'P42/ncm'], 138, 101,  ope_inv,[12,12,12], [12, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'I4/mmm'], 139,  99,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 6,  'I4/mcm'], 140,  83,   ope_2x,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'I41/amd'], 141, 119,  ope_inv,[ 0,12, 6], [ 0, 0, 0], l_xyz, l_qua ],
     [ [ 7, 'I41/acd'], 142,  88,   ope_2x,[ 0,12,18], [ 0, 0, 0], l_xyz, l_qua ],

     [ [ 2,      'P3'], 143,   0, ope_3z_h,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'P31'], 144,   0, ope_3z_h,[ 0, 0, 8], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'P32'], 145,   0, ope_3z_h,[ 0, 0,16], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 2,      'R3'], 146,   0,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_rho ],
     [ [ 3,     'P-3'], 147, 143,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'R-3'], 148, 146,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_rho ],

     [ [ 4,    'P312'], 149, 143,   ope_2v,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'P321'], 150, 143,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P3112'], 151, 144, ope_2u_h,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P3121'], 152, 144,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P3212'], 153, 145, ope_2u_h,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P3221'], 154, 145,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'R32'], 155, 146,   ope_2v,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_rho ],

     [ [ 4,    'P3m1'], 156, 143,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'P31m'], 157, 143,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'P3c1'], 158, 143,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'P31c'], 159, 143,   ope_mv,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'R3m'], 160, 146,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_rho ],
     [ [ 3,     'R3c'], 161, 146,   ope_mv,[12,12,12], [ 0, 0, 0], l_xyz, l_rho ],

     [ [ 5,   'P-31m'], 162, 147,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P-31c'], 163, 147,   ope_mv,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P-3m1'], 164, 147,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 5,   'P-3c1'], 165, 147,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'R-3m'], 166, 148,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_rho ],
     [ [ 4,    'R-3c'], 167, 148,   ope_mv,[12,12,12], [ 0, 0, 0], l_xyz, l_rho ],

     [ [ 2,      'P6'], 168, 143,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P61'], 169, 144,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P65'], 170, 145,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P62'], 171, 145,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P64'], 172, 144,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P63'], 173, 143,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 3,     'P-6'], 174, 143,   ope_mz,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 4,    'P6/m'], 175, 147,   ope_2z,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P63/m'], 176, 147,   ope_2z,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],

     [ [ 4,    'P622'], 177, 168,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P6122'], 178, 169,   ope_2u,[ 0, 0, 8], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P6522'], 179, 170,   ope_2u,[ 0, 0,16], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P6222'], 180, 171,   ope_2u,[ 0, 0,16], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P6422'], 181, 172,   ope_2u,[ 0, 0, 8], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P6322'], 182, 173,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],

     [ [ 4,    'P6mm'], 183, 168,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 4,    'P6cc'], 184, 168,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P63cm'], 185, 173,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P63mc'], 186, 173,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],

     [ [ 5,   'P-6m2'], 187, 174,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P-6c2'], 188, 174,   ope_mu,[ 0, 0,12], [ 0, 0, 6], l_xyz, l_hex ],
     [ [ 5,   'P-62m'], 189, 174,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 5,   'P-62c'], 190, 174,   ope_2u,[ 0, 0, 0], [ 0, 0, 6], l_xyz, l_hex ],

     [ [ 6,  'P6/mmm'], 191, 177,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],
     [ [ 6,  'P6/mcc'], 192, 177,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_xyz, l_hex ],
     [ [ 7, 'P63/mcm'], 193, 182,  ope_inv,[ 0, 0, 0], [ 0, 0, 6], l_xyz, l_hex ],
     [ [ 7, 'P63/mmc'], 194, 182,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_hex ],

     [ [ 3,     'P23'], 195,  16,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 3,     'F23'], 196,  16,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 3,     'I23'], 197,  16,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'P213'], 198,  19,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'I213'], 199,  19,   ope_3r,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Pm-3'], 200, 195,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Pn-3'], 201, 195,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Fm-3'], 202, 195,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Fd-3'], 203, 195,  ope_inv,[ 6, 6, 6], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Im-3'], 204, 195,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Pa-3'], 205, 199,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'Ia-3'], 206, 199,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],

     [ [ 4,    'P432'], 207, 195,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'P4232'], 208, 195,   ope_2u,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'F432'], 209, 195,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'F4132'], 210, 195,   ope_2u,[18, 6,18], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 4,    'I432'], 211, 195,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'P4332'], 212, 198,   ope_2u,[ 6,18,18], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'P4132'], 213, 198,   ope_2u,[18, 6, 6], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'I4132'], 214, 198,   ope_2u,[18, 6, 6], [ 0, 0, 0], l_xyz, l_cub ],

     [ [ 5,   'P-43m'], 215, 195,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'F-43m'], 216, 195,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'I-43m'], 217, 195,   ope_mv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'P-43n'], 218, 195,   ope_mv,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'F-43c'], 219, 195,   ope_mv,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'I-43d'], 220, 199,   ope_mv,[ 6, 6, 6], [ 0, 0, 0], l_xyz, l_cub ],

     [ [ 5,   'Pm-3m'], 221, 207,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Pn-3n'], 222, 207,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Pm-3n'], 223, 208,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Pn-3m'], 224, 208,  ope_inv,[12,12,12], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Fm-3m'], 225, 207,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Fm-3c'], 226, 208,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Fd-3m'], 227, 210,  ope_inv,[ 6, 6, 6], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Fd-3c'], 228, 210,  ope_inv,[18,18,18], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Im-3m'], 229, 207,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],
     [ [ 5,   'Ia-3d'], 230, 214,  ope_inv,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_cub ],

     [ [ 2,      'H3'], 146,   0, ope_3z_h,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'H-3'], 148,   0,ope_3bz_h,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'H32'], 155, 143,   ope_2u,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'H3m'], 160, 143,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 3,     'H3c'], 161, 143,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'H-3m'], 166, 147,   ope_mu,[ 0, 0, 0], [ 0, 0, 0], l_xyz, l_trg ],
     [ [ 4,    'H-3c'], 167, 147,   ope_mu,[ 0, 0,12], [ 0, 0, 0], l_xyz, l_trg ]
  ];


  sgrp_cvtb = sgrp_tbct[ 239,

{ * * *  Permuttations for Monoclinic Space Groupes   * * * }

     [ [ 6,  'P1_1_2'], l_xyz, 3 ], [ [ 6,  'P2_1_1'], l_zxy, 3 ], [ [ 6,  'P1_2_1'], l_yzx, 3 ],
     [ [ 7, 'P1_1_21'], l_xyz, 4 ], [ [ 7, 'P21_1_1'], l_zxy, 4 ], [ [ 7, 'P1_21_1'], l_yzx, 4 ],

     [ [ 6,  'B1_1_2'], l_xyz, 5 ], [ [ 6,  'B2_1_1'], l_zyx, 5 ],
     [ [ 6,  'C2_1_1'], l_zxy, 5 ], [ [ 6,  'C1_2_1'], l_xzy, 5 ], [ [ 2,      'C2'], l_xzy, 5 ],
     [ [ 6,  'A1_2_1'], l_yzx, 5 ], [ [ 6,  'A1_1_2'], l_yxz, 5 ],

     [ [ 6,  'P1_1_m'], l_xyz, 6 ], [ [ 6,  'Pm_1_1'], l_zxy, 6 ], [ [ 6,  'P1_m_1'], l_yzx, 6 ],

     [ [ 6,  'P1_1_b'], l_xyz, 7 ], [ [ 6,  'P1_1_a'], l_yxz, 7 ],
     [ [ 6,  'Pc_1_1'], l_zxy, 7 ], [ [ 6,  'Pb_1_1'], l_zyx, 7 ],
     [ [ 6,  'P1_a_1'], l_yzx, 7 ], [ [ 6,  'P1_c_1'], l_xzy, 7 ], [ [ 2,      'Pc'], l_xzy, 7 ],

     [ [ 6,  'B1_1_m'], l_xyz, 8 ], [ [ 6,  'Bm_1_1'], l_zyx, 8 ],
     [ [ 6,  'Cm_1_1'], l_zxy, 8 ], [ [ 6,  'C1_m_1'], l_xzy, 8 ], [ [ 2,      'Cm'], l_xzy, 8 ],
     [ [ 6,  'A1_m_1'], l_yzx, 8 ], [ [ 6,  'A1_1_m'], l_yxz, 8 ],

     [ [ 6,  'B1_1_b'], l_xyz, 9 ], [ [ 6,  'Bb_1_1'], l_zyx, 9 ],
     [ [ 6,  'Cc_1_1'], l_zxy, 9 ], [ [ 6,  'C1_c_1'], l_xzy, 9 ], [ [ 2,      'Cc'], l_xzy, 9 ],
     [ [ 6,  'A1_a_1'], l_yzx, 9 ], [ [ 6,  'A1_1_a'], l_yxz, 9 ],

     [ [ 8,'P1_1_2/m'], l_xyz,10 ], [ [ 8,'P2/m_1_1'], l_zxy,10 ], [ [ 8,'P1_2/m_1'], l_yzx,10 ],
     [ [9,'P1_1_21/m'], l_xyz,11 ], [ [9,'P21/m_1_1'], l_zxy,11 ], [ [9,'P1_21/m_1'], l_yzx,11 ],

     [ [ 8,'B1_1_2/m'], l_xyz,12 ], [ [ 8,'B2/m_1_1'], l_zyx,12 ],
     [ [ 8,'C2/m_1_1'], l_zxy,12 ], [ [ 8,'C1_2/m_1'], l_xzy,12 ], [ [ 4,    'C2/m'], l_xzy,12 ],
     [ [ 8,'A1_2/m_1'], l_yzx,12 ], [ [ 8,'A1_1_2/m'], l_yxz,12 ],

     [ [ 8,'P1_1_2/b'], l_xyz,13 ], [ [ 8,'P1_1_2/a'], l_yxz,13 ],
     [ [ 8,'P2/c_1_1'], l_zxy,13 ], [ [ 8,'P2/b_1_1'], l_zyx,13 ],
     [ [ 8,'P1_2/a_1'], l_yzx,13 ], [ [ 8,'P1_2/c_1'], l_xzy,13 ], [ [ 4,    'P2/c'], l_xzy,13 ],

     [ [9,'P1_1_21/b'], l_xyz,14 ], [ [9,'P1_1_21/a'], l_yxz,14 ],
     [ [9,'P21/c_1_1'], l_zxy,14 ], [ [9,'P21/b_1_1'], l_zyx,14 ],
     [ [9,'P1_21/a_1'], l_yzx,14 ], [ [9,'P1_21/c_1'], l_xzy,14 ], [ [ 5,   'P21/c'], l_xzy,14 ],

     [ [ 8,'B1_1_2/b'], l_xyz,15 ], [ [ 8,'B2/b_1_1'], l_zyx,15 ],
     [ [ 8,'C2/c_1_1'], l_zxy,15 ], [ [ 8,'C1_2/c_1'], l_xzy,15 ], [ [ 4,    'C2/c'], l_xzy,15 ],
     [ [ 8,'A1_2/a_1'], l_yzx,15 ], [ [ 8,'A1_1_2/a'], l_yxz,15 ],

{ * * *  Permuttations for Orthorhombic Space Groupes   * * * }

     [ [ 5,   'P2122'], l_zxy,17 ], [ [ 5,   'P2212'], l_yzx,17 ],
     [ [ 6,  'P22121'], l_zxy,18 ], [ [ 6,  'P21221'], l_yzx,18 ],
     [ [ 5,   'A2122'], l_zxy,20 ], [ [ 5,   'B2212'], l_yzx,20 ],
     [ [ 4,    'A222'], l_zxy,21 ], [ [ 4,    'B222'], l_yzx,21 ],

     [ [ 4,    'P2mm'], l_zxy,25 ], [ [ 4,    'Pm2m'], l_yzx,25 ],
     [ [ 5,   'P21ma'], l_zxy,26 ], [ [ 5,   'Pb21m'], l_yzx,26 ],
     [ [ 5,   'Pm21b'], l_xzy,26 ], [ [ 5,   'Pcm21'], l_yxz,26 ], [ [ 5,   'P21am'], l_zyx,26 ],

     [ [ 4,    'P2aa'], l_zxy,27 ], [ [ 4,    'Pb2b'], l_yzx,27 ],

     [ [ 4,    'P2mb'], l_zxy,28 ], [ [ 4,    'Pc2m'], l_yzx,28 ],
     [ [ 4,    'Pm2a'], l_xzy,28 ], [ [ 4,    'Pbm2'], l_yxz,28 ], [ [ 4,    'P2cm'], l_zyx,28 ],

     [ [ 5,   'P21ab'], l_zxy,29 ], [ [ 5,   'Pc21b'], l_yzx,29 ],
     [ [ 5,   'Pb21a'], l_xzy,29 ], [ [ 5,   'Pbc21'], l_yxz,29 ], [ [ 5,   'P21ca'], l_zyx,29 ],

     [ [ 4,    'P2na'], l_zxy,30 ], [ [ 4,    'Pb2n'], l_yzx,30 ],
     [ [ 4,    'Pn2b'], l_xzy,30 ], [ [ 4,    'Pcn2'], l_yxz,30 ], [ [ 4,    'P2an'], l_zyx,30 ],

     [ [ 5,   'P21mn'], l_zxy,31 ], [ [ 5,   'Pn21m'], l_yzx,31 ],
     [ [ 5,   'Pm21n'], l_xzy,31 ], [ [ 5,   'Pnm21'], l_yxz,31 ], [ [ 5,   'P21nm'], l_zyx,31 ],

     [ [ 4,    'P2cb'], l_zxy,32 ], [ [ 4,    'Pc2a'], l_yzx,32 ],

     [ [ 5,   'P21nb'], l_zxy,33 ], [ [ 5,   'Pc21n'], l_yzx,33 ],
     [ [ 5,   'Pn21a'], l_xzy,33 ], [ [ 5,   'Pbn21'], l_yxz,33 ], [ [ 5,   'P21cn'], l_zyx,33 ],

     [ [ 4,    'P2nn'], l_zxy,34 ], [ [ 4,    'Pn2n'], l_yzx,34 ],
     [ [ 4,    'A2mm'], l_zxy,35 ], [ [ 4,    'Bm2m'], l_yzx,35 ],

     [ [ 5,   'A21ma'], l_zxy,36 ], [ [ 5,   'Bb21m'], l_yzx,36 ],
     [ [ 5,   'Bm21b'], l_xzy,36 ], [ [ 5,   'Ccm21'], l_yxz,36 ], [ [ 5,   'A21am'], l_zyx,36 ],

     [ [ 4,    'A2aa'], l_zxy,37 ], [ [ 4,    'Bb2b'], l_yzx,37 ],

     [ [ 4,    'B2mm'], l_zxy,38 ], [ [ 4,    'Cm2m'], l_yzx,38 ],
     [ [ 4,    'Am2m'], l_xzy,38 ], [ [ 4,    'Bmm2'], l_yxz,38 ], [ [ 4,    'C2mm'], l_zyx,38 ],

     [ [ 4,    'B2cm'], l_zxy,39 ], [ [ 4,    'Cm2a'], l_yzx,39 ],
     [ [ 4,    'Ac2m'], l_xzy,39 ], [ [ 4,    'Bma2'], l_yxz,39 ], [ [ 4,    'C2mb'], l_zyx,39 ],

     [ [ 4,    'B2mb'], l_zxy,40 ], [ [ 4,    'Cc2m'], l_yzx,40 ],
     [ [ 4,    'Am2a'], l_xzy,40 ], [ [ 4,    'Bbm2'], l_yxz,40 ], [ [ 4,    'C2cm'], l_zyx,40 ],

     [ [ 4,    'B2cb'], l_zxy,41 ], [ [ 4,    'Cc2a'], l_yzx,41 ],
     [ [ 4,    'Ac2a'], l_xzy,41 ], [ [ 4,    'Bba2'], l_yxz,41 ], [ [ 4,    'C2cb'], l_zyx,41 ],

     [ [ 4,    'F2mm'], l_zxy,42 ], [ [ 4,    'Fm2m'], l_yzx,42 ],
     [ [ 4,    'F2dd'], l_zxy,43 ], [ [ 4,    'Fd2d'], l_yzx,43 ],
     [ [ 4,    'I2mm'], l_zxy,44 ], [ [ 4,    'Im2m'], l_yzx,44 ],
     [ [ 4,    'I2cb'], l_zxy,45 ], [ [ 4,    'Ic2a'], l_yzx,45 ],

     [ [ 4,    'I2mb'], l_zxy,46 ], [ [ 4,    'Ic2m'], l_yzx,46 ],
     [ [ 4,    'Im2a'], l_xzy,46 ], [ [ 4,    'Ibm2'], l_yxz,46 ], [ [ 4,    'I2cm'], l_zyx,46 ],

     [ [ 4,    'Pmaa'], l_zxy,49 ], [ [ 4,    'Pbmb'], l_yzx,49 ],
     [ [ 4,    'Pncb'], l_zxy,50 ], [ [ 4,    'Pcna'], l_yzx,50 ],

     [ [ 4,    'Pbmm'], l_zxy,51 ], [ [ 4,    'Pmcm'], l_yzx,51 ],
     [ [ 4,    'Pmam'], l_xzy,51 ], [ [ 4,    'Pmmb'], l_yxz,51 ], [ [ 4,    'Pcmm'], l_zyx,51 ],

     [ [ 4,    'Pbnn'], l_zxy,52 ], [ [ 4,    'Pncn'], l_yzx,52 ],
     [ [ 4,    'Pnan'], l_xzy,52 ], [ [ 4,    'Pnnb'], l_yxz,52 ], [ [ 4,    'Pcnn'], l_zyx,52 ],

     [ [ 4,    'Pbmn'], l_zxy,53 ], [ [ 4,    'Pncm'], l_yzx,53 ],
     [ [ 4,    'Pman'], l_xzy,53 ], [ [ 4,    'Pnmb'], l_yxz,53 ], [ [ 4,    'Pcnm'], l_zyx,53 ],

     [ [ 4,    'Pbaa'], l_zxy,54 ], [ [ 4,    'Pbcb'], l_yzx,54 ],
     [ [ 4,    'Pbab'], l_xzy,54 ], [ [ 4,    'Pccb'], l_yxz,54 ], [ [ 4,    'Pcaa'], l_zyx,54 ],

     [ [ 4,    'Pmcb'], l_zxy,55 ], [ [ 4,    'Pcma'], l_yzx,55 ],
     [ [ 4,    'Pnaa'], l_zxy,56 ], [ [ 4,    'Pbnb'], l_yzx,56 ],

     [ [ 4,    'Pmca'], l_zxy,57 ], [ [ 4,    'Pbma'], l_yzx,57 ],
     [ [ 4,    'Pcmb'], l_xzy,57 ], [ [ 4,    'Pcam'], l_yxz,57 ], [ [ 4,    'Pmab'], l_zyx,57 ],

     [ [ 4,    'Pmnn'], l_zxy,58 ], [ [ 4,    'Pnmn'], l_yzx,58 ],
     [ [ 4,    'Pnmm'], l_zxy,59 ], [ [ 4,    'Pmnm'], l_yzx,59 ],

     [ [ 4,    'Pnca'], l_zxy,60 ], [ [ 4,    'Pbna'], l_yzx,60 ],
     [ [ 4,    'Pcnb'], l_xzy,60 ], [ [ 4,    'Pcan'], l_yxz,60 ], [ [ 4,    'Pnab'], l_zyx,60 ],

     [ [ 4,    'Pcab'], l_xzy,61 ],

     [ [ 4,    'Pbnm'], l_zxy,62 ], [ [ 4,    'Pmcn'], l_yzx,62 ],
     [ [ 4,    'Pnam'], l_xzy,62 ], [ [ 4,    'Pmnb'], l_yxz,62 ], [ [ 4,    'Pcmn'], l_zyx,62 ],

     [ [ 4,    'Amma'], l_zxy,63 ], [ [ 4,    'Bbmm'], l_yzx,63 ],
     [ [ 4,    'Bmmb'], l_xzy,63 ], [ [ 4,    'Ccmm'], l_yxz,63 ], [ [ 4,    'Amam'], l_zyx,63 ],

     [ [ 4,    'Abma'], l_zxy,64 ], [ [ 4,    'Bbcm'], l_yzx,64 ],
     [ [ 4,    'Bmab'], l_xzy,64 ], [ [ 4,    'Ccmb'], l_yxz,64 ], [ [ 4,    'Acam'], l_zyx,64 ],

     [ [ 4,    'Ammm'], l_zxy,65 ], [ [ 4,    'Bmmm'], l_yzx,65 ],
     [ [ 4,    'Amaa'], l_zxy,66 ], [ [ 4,    'Bbmb'], l_yzx,66 ],

     [ [ 4,    'Abmm'], l_zxy,67 ], [ [ 4,    'Bmcm'], l_yzx,67 ],
     [ [ 4,    'Bmam'], l_xzy,67 ], [ [ 4,    'Cmmb'], l_yxz,67 ], [ [ 4,    'Acmm'], l_zyx,67 ],

     [ [ 4,    'Abaa'], l_zxy,68 ], [ [ 4,    'Bbcb'], l_yzx,68 ],
     [ [ 4,    'Bbab'], l_xzy,68 ], [ [ 4,    'Cccb'], l_yxz,68 ], [ [ 4,    'Acaa'], l_zyx,68 ],

     [ [ 4,    'Imcb'], l_zxy,72 ], [ [ 4,    'Icma'], l_yzx,72 ],
     [ [ 4,    'Icab'], l_xzy,73 ],

     [ [ 4,    'Ibmm'], l_zxy,74 ], [ [ 4,    'Imcm'], l_yzx,74 ],
     [ [ 4,    'Imam'], l_xzy,74 ], [ [ 4,    'Immb'], l_yxz,74 ], [ [ 4,    'Acmm'], l_zyx,74 ]
 ];
