
[global]
function EXP_VAL_UNA( puna: lgt_ptr; p: gen_ptr; rty: typ_ptr ): lgt_ptr;
const
  mdnam = 'ECUN';

var
  r:   double;
  lgt: lgt_ptr;

begin
  if p^.gen_atb <> nil then
  with p^, gen_atb^[1] do
  begin
    { At begin do the conversion }
    if oar_cve <> cv_nop then puna := EXP_VAL_UNA( puna, oparg_cvtab[oar_cve] );
    with puna^ do
    if lgt_kind = lgt_const then
    with lgt_cte^ do
    begin
      lgt_status := [lgt_in];
      case gen_cod of
        pcod_not:    val_ival := ORD( val_ival <= 0 );

        pcod_succ:   val_ival := val_ival + 1;

        pcod_pred:   val_ival := val_ival - 1;

        pcod_iodd:   val_ival := ORD( ODD( val_ival ) );

        pcod_com:    if (val_kind = form_set) or (val_kind = form_wset) then
                       if val_set.siv >= 0
                       then val_set.siv := -1 - val_set.siv
                       else val_set.siv := -(1 + val_set.siv);

        pcod_ineg:   val_ival := - val_ival;
        pcod_fneg,
        pcod_gneg:   val_rval := - val_rval;

        pcod_iabs:   val_ival := ABS( val_ival );
        pcod_fabs,
        pcod_gabs:   val_rval := ABS( val_rval );

        pcod_isqr:   val_ival := SQR( val_ival );
        pcod_fsqr,
        pcod_gsqr:   val_rval := SQR( val_rval );

        pcod_cvif,
        pcod_cvig:   val_rval := val_ival;
        pcod_cvfi,
        pcod_cvgi:   val_ival := ROUND( val_rval );
        pcod_ftrunc,
        pcod_gtrunc:  val_ival := TRUNC( val_rval );

        pcod_sqrt,
        pcod_gsqrt: if val_rval < 0.0 then SRC_ERROR( mdnam, 801, e_error )
                                      else val_rval := SQRT(val_rval);

        pcod_sin,
        pcod_gsin:  val_rval := SIN( val_rval );
        pcod_cos,
        pcod_gcos:  val_rval := COS( val_rval );
        pcod_tan,
        pcod_gtan:  val_rval := TAN( val_rval );

        pcod_asin,
        pcod_gasin:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 802, e_error )
                                     else val_rval := ARCSIN( val_rval );
        pcod_acos,
        pcod_gacos:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 803, e_error )
                                     else val_rval := ARCCOS( val_rval );
        pcod_atan,
        pcod_gatan:  val_rval := ARCTAN( val_rval );

        pcod_sinh,
        pcod_gsinh: val_rval := SINH( val_rval );
        pcod_cosh,
        pcod_gcosh: val_rval := COSH( val_rval );
        pcod_tanh,
        pcod_gtanh: val_rval := TANH( val_rval );

        pcod_asinh,
        pcod_gasinh: val_rval := ARGSINH( val_rval );
        pcod_acosh,
        pcod_gacosh:
            if val_rval < 1.0 then SRC_ERROR( mdnam, 805, e_error )
                              else val_rval := ARGCOSH( val_rval );
        pcod_atanh,
        pcod_gatanh:
            if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 806, e_error )
                                     else val_rval := ARGTANH( val_rval );

        pcod_exp,
        pcod_gexp: val_rval := EXP( val_rval );
        pcod_log,
        pcod_glog:
            if val_rval <= 0.0 then SRC_ERROR( mdnam, 804, e_error ) else
              val_rval := LN(val_rval);
      otherwise { no op in compile time }
        { no operation }
      end;
      lgt_lide := nil;                         { Delete all previous link to a const identifier }
      { update the type }
      if (gen_res = typ_std[form_equv]) or
         (gen_res = typ_std[form_eqst]) then lgt_typ := puna^.lgt_typ
                                        else lgt_typ := gen_res;
      val_typ  := lgt_typ;
      val_kind := lgt_typ^.typ_form
    end
    else                                       { Not a constante }
    begin
      if not (lgt_in in puna^.lgt_status) then SRC_ERROR( mdnam, 851, e_error );
      if (gen_pcode <> pcod_noop) or
         (puna^.lgt_typ^.typ_size <> gen_result^.typ_size) then
      begin { Create an unary node to link with present object }
        LGT_NEW( lgt, gen_result, lgt_codep, puna );
        with lgt^ do
        begin
          if (lgt_typ = typ_std[form_equv]) or
             (lgt_typ = typ_std[form_eqst]) then lgt_typ := puna^.lgt_typ;

          lgt_nxt := puna^.lgt_nxt;            { Copy the old next link }
          lgt_pcode := gen_pcode;
          lgt_status := puna^.lgt_status - [lgt_out]
        end;
        lgt_nxt := nil;                        { Clear the old next link }
        puna := lgt
      end
      else puna^.lgt_typ := gen_result         { Set the new type }
    end
  end;
  EXP_VAL_UNA := puna
end EXP_VAL_UNA;



[global]
function EXP_VAL_BIN( ob1: lgt_ptr; p: gen_ptr ): lgt_ptr;
const
  mdnam = 'EXPB';

type
  wenm = 0..max_setw - 1;

var
  iby:        wenm;
  ic, jc:     integer;
  rc:         double;
  ob2:        lgt_ptr;
  nod_create: boolean;

begin 
  ob2 := ob1^.lgt_nxt;
  if p^.gen_atb <> nil then
  with p^ do
  begin
    { At begin do the conversions }
    with gen_atb^[1] do
      if oar_cve <> cv_nop then ob1 := EXP_VAL_UNA( ob1, oparg_cvtab[oar_cve] );
    with gen_atb^[2] do
      if oar_cve <> cv_nop then ob2 := EXP_VAL_UNA( ob2, oparg_cvtab[oar_cve] );
    ob1^.lgt_nxt := ob2; { Set the new link (on conversion result and no effect when no conevrsion) }
    if (ob1^.lgt_kind = lgt_const) and
       (ob2^.lgt_kind = lgt_const) then
    begin
      with ob1^.lgt_cte^, ob2^ do
      case gen_cod of
        pcod_ipow: val_ival := val_ival ** lgt_cte^.val_ival;
        pcod_fpow,
        pcod_gpow: val_rval := val_rval ** lgt_cte^.val_rval;
        pcod_fipw,
        pcod_gipw: val_rval := val_rval ** lgt_cte^.val_ival;

        pcod_iadd: val_ival := val_ival + lgt_cte^.val_ival;
        pcod_isub: val_ival := val_ival - lgt_cte^.val_ival;
        pcod_imul: val_ival := val_ival * lgt_cte^.val_ival;
        pcod_idiv: val_ival := val_ival div lgt_cte^.val_ival;
        pcod_imod: val_ival := val_ival mod lgt_cte^.val_ival;
        pcod_irem: val_ival := val_ival rem lgt_cte^.val_ival;

        pcod_fadd,
        pcod_gadd: val_rval := val_rval + lgt_cte^.val_rval;
        pcod_fsub,
        pcod_gsub: val_rval := val_rval - lgt_cte^.val_rval;
        pcod_fmul,
        pcod_gmul: val_rval := val_rval * lgt_cte^.val_rval;
        pcod_fdiv,
        pcod_gdiv: val_rval := val_rval / lgt_cte^.val_rval;

        pcod_and:  val_ival := ORD((val_ival > 0) and (lgt_cte^.val_ival > 0));
        pcod_or:   val_ival := ORD((val_ival > 0) or  (lgt_cte^.val_ival > 0));
        pcod_xor:  val_ival := ORD((val_ival > 0) <>  (lgt_cte^.val_ival > 0));

        { Set Operators }
        pcod_band: val_set.ssv := val_set.ssv * lgt_cte^.val_set.ssv;
        pcod_bxor: val_set.ssv := (val_set.ssv + lgt_cte^.val_set.ssv)
                                 -(val_set.ssv * lgt_cte^.val_set.ssv);
        pcod_bic:  val_set.ssv := val_set.ssv - lgt_cte^.val_set.ssv;
        pcod_bis:  val_set.ssv := val_set.ssv + lgt_cte^.val_set.ssv;
        pcod_bit:  val_ival := ORD((val_set.ssv * lgt_cte^.val_set.ssv)<>[]);

        pcod_setgen:                           { Never called here };
        pcod_lsetgen:                          { Never called here };
        pcod_lsetaddel:                        { Never called here };

        pcod_setlt, pcod_setle, pcod_setge,
        pcod_setgt, pcod_seteq, pcod_setne:
          begin
            case gen_cod of
              pcod_setlt,
              pcod_setle: ic := ORD( val_set.ssv <= lgt_cte^.val_set.ssv );
              pcod_setge,
              pcod_setgt: ic := ORD( val_set.ssv >= lgt_cte^.val_set.ssv );
              pcod_seteq: ic := ORD( val_set.ssv <> lgt_cte^.val_set.ssv );
              pcod_setne: ic := ORD( val_set.ssv =  lgt_cte^.val_set.ssv );
            otherwise
            end;
            val_kind := form_lit;
            val_size := 0;
            val_ival := ic
          end;

        pcod_inset: ic := ORD( val_ival in lgt_cte^.val_set.ssv );

        pcod_ult, pcod_ule, pcod_uge, pcod_ugt, pcod_ne, pcod_eq,
        pcod_ilt, pcod_ile, pcod_ige, pcod_igt:
          begin { Unsigned and Signed are same (does not it ?) }
            ic := val_ival - lgt_cte^.val_ival;
            case gen_cod of
              pcod_ult, pcod_ilt: val_ival := ORD( ic < 0 );
              pcod_ule, pcod_ile: val_ival := ORD( ic <= 0 );
              pcod_uge, pcod_ige: val_ival := ORD( ic >= 0 );
              pcod_ugt, pcod_igt: val_ival := ORD( ic > 0 );
                        pcod_ne:  val_ival := ORD( ic <> 0 );
                        pcod_eq:  val_ival := ORD( ic = 0 )
            end
          end;
        pcod_flt, pcod_fle, pcod_fge, pcod_fgt, pcod_fne, pcod_feq,
        pcod_glt, pcod_gle, pcod_gge, pcod_ggt, pcod_gne, pcod_geq:
          begin
            rc := val_rval - lgt_cte^.val_rval;
            case gen_cod of
              pcod_flt, pcod_glt: val_ival := ORD( rc < 0 );
              pcod_fle, pcod_gle: val_ival := ORD( rc <= 0 );
              pcod_fge, pcod_gge: val_ival := ORD( rc >= 0 );
              pcod_fgt, pcod_ggt: val_ival := ORD( rc > 0 );
              pcod_fne, pcod_gne: val_ival := ORD( rc <> 0 );
              pcod_feq, pcod_geq: val_ival := ORD( rc = 0 )
            end
          end;

        pcod__ne, pcod__eq:
          begin
            { /// block compare }
          end; 

        pcod_gphas,
        pcod_phas:  val_rval := ARCTAN( val_rval, lgt_cte^.val_rval )

      otherwise
      end;
      with ob1^, lgt_cte^ do
      begin { Set the result type }
        lgt_lide := nil;                       { Delete all previous link to a const identifier }
        { Update the type }
        if (gen_res = typ_std[form_equv]) or
           (gen_res = typ_std[form_eqst]) then lgt_typ := ob1^.lgt_typ
                                          else lgt_typ := gen_res;
        val_typ  := lgt_typ;
        val_kind := lgt_typ^.typ_form
      end;
      ob1^.lgt_nxt := nil;                     { Supress the parameter link }
      LGT_FREE( ob2 )                          { Free the old second const node }
    end
    else
    begin { The two operands are not constant }
      nod_create := true;                      { Assume node create until showed otherwise }
      case gen_cod of
        pcod_inset:
          if ob1^.lgt_kind = lgt_const then
          begin
            with ob1^ do
            begin
              iby := lgt_cte^.val_ival;
              lgt_typ := ob2^.lgt_typ;
              VAL_FREE( lgt_cte );
              VAL_NEW( lgt_cte, lgt_typ );
              with lgt_cte^ do
              begin
                val_size := (iby + 7) div 8;
                val_set.ssv := [iby] 
              end
            end;
            LGT_NEW( ob2, gen_res, lgt_codep, ob1 );
            with ob2^ do
            begin
              lgt_status := [lgt_in];
              lgt_pcode :=  pcod_bit
            end;
            nod_create := false
          end;

        pcod_and:
          if ob1^.lgt_kind = lgt_const then
          with ob1^ do
          begin { "<cte> and <exp>" }
            ob1^.lgt_nxt := nil;
            nod_create := false;
            if lgt_cte^.val_ival <= 0 then
            begin { "false and <exp>" => false }
              LGT_FREE_TREE( ob2 );
              ob2 := ob1
            end
            else
              LGT_FREE( ob1 )                  { "true and <exp>" => <exp> }
          end
          else
            if ob2^.lgt_kind = lgt_const then
            with ob2^ do
            begin { "<exp> and <cte>" }
              ob1^.lgt_nxt := nil;
              nod_create := false;
              if lgt_cte^.val_ival <= 0 then
                LGT_FREE_TREE( ob1 )           { "<exp> and false" => false }
              else
              begin { "<exp> and true" => <exp> }
                LGT_FREE( ob2 );
                ob2 := ob1
              end
            end;

        pcod_or:
          if ob1^.lgt_kind = lgt_const then
          with ob1^ do
          begin { "<cte> or <exp>" }
            ob1^.lgt_nxt := nil;
            nod_create := false;
            if lgt_cte^.val_ival > 0 then
            begin { "true or <exp>" => true }
              LGT_FREE_TREE( ob2 );
              ob2 := ob1
            end
            else
              LGT_FREE( ob1 )                  { "false or <exp>" => <exp> }
          end
          else
            if ob2^.lgt_kind = lgt_const then
            with ob2^ do
            begin { "<exp> or <cte>" }
              ob1^.lgt_nxt := nil;
              nod_create := false;
              if lgt_cte^.val_ival > 0 then
                LGT_FREE_TREE( ob1 )           { "<exp> or true" => true }
              else
              begin { "<exp> or false" => <exp> }
                LGT_FREE( ob2 );
                ob2 := ob1
              end
            end;

        pcod_istore, pcod_fstore, pcod_gstore, pcod_store:
          begin
            with ob1^ do
            begin
              lgt_status := lgt_status + [lgt_wrt];
              if not (lgt_out in lgt_status) then SRC_ERROR( mdnam, 852, e_error )
            end;
            with ob2^ do
            begin
              if not (lgt_in in lgt_status) then
                SRC_ERROR( mdnam, 851, e_warning);
              if (gen_cod <> pcod_store) and
                 (lgt_kind = lgt_call) and                     { Call of ... }
                 (lgt_typ <> nil) then                         { ... a function }
                with lgt_pro^ do
                if pro_parmlst <> nil then
                  if pro_parmlst^.ide_vkind = var_result then
                  begin { * We can supress any temporary location for result }
                    ob1^.lgt_nxt := lgt_parmlst^.lgt_nxt;      { Set link to true parm }
                    LGT_FREE( lgt_parmlst );                   { Free this node }
                    lgt_status := lgt_status + [lgt_cas];      { Set the direct assignation mode flag (the function result is directly in the assignation target) }
                    lgt_parmlst := ob1                         { ob1 is the new result target };
                    nod_create := false
                  end
            end
          end
      otherwise
        if not ((lgt_in in ob1^.lgt_status) and (lgt_in in ob2^.lgt_status))
          then SRC_ERROR( mdnam, 851, e_warning )
      end;
      if nod_create then
      begin
        LGT_NEW( ob2, gen_res, lgt_codep, ob1 );
        with ob2^ do
        begin
          if (lgt_typ = typ_std[form_equv]) or
             (lgt_typ = typ_std[form_eqst]) then lgt_typ := ob1^.lgt_typ;
          lgt_status := [lgt_in];
          lgt_pcode :=  gen_cod
        end
      end;
      ob1 := ob2
    end
  end;
  EXP_VAL_BIN := ob1
end EXP_VAL_BIN;




[global]
function  LOOK_FOR_DESCRIPTOR( lgt: lgt_ptr; ty: typ_ptr ): lgt_ptr;
{ Used to Find the descriptor where the ty (a form_range) is defined.
  The search start from the node lst.
}
var
  lgr: lgt_ptr;

begin
  lgr := lgt;
  while (lgr <> nil) and (lgr^.lgt_typ <> nil) do
    with lgr^, lgt_typ^ do
    begin
  exit if (typ_descr_size > 0);
      if (lgt_kind = lgt_offset) or
         (lgt_kind = lgt_index)  or
         (lgt_kind = lgt_refer)  or
         (lgt_kind = lgt_null)   then lgr := lgt_parmlst
                                 else lgr := nil;
    end;
    if lgr = nil then lgr := lgt;
(*
WRITELN( lst_current^.lst_file, ' Find Descr stop of kind ', lgr^.lgt_kind, ', disp = ', lgr^.lgt_disp );
if lgr^.lgt_typ <> nil then
WRITELN( lst_current^.lst_file, ' type form is ', lgr^.lgt_typ^.typ_form );
*)
  LOOK_FOR_DESCRIPTOR := lgr
end LOOK_FOR_DESCRIPTOR;



[global]
procedure CALL_SETTING( var lgt: lgt_ptr );
{ To verify the IN OUT setting of each parameter and selec
  the default value for the ungiven parm.
  this procedure can be change the LoGical Tree configuration.
}
const
  mdnam = 'CALL';
var
  b_def, b_sa, b_ch:                   boolean;
  ch:                                     char;
  pr:                                  pro_ptr;
  pf:                                  ide_ptr;
  pe, pre, lgi, lgj, lgc, objb, descr: lgt_ptr;
  et, ft, it, iti, rty:                typ_ptr;

begin
  b_def := false;
  pr    :=   nil;
  if lgt <> nil then                                    { Existing node }
  with lgt^ do
  begin
    if lgt_pro <> nil then  pr := lgt_pro;              { Existing procedure }
    pe := lgt_parmlst;                                  { Get the first effective parameter pointer }
    if lgt_kind = lgt_icall then pe := pe^.lgt_nxt      { for indirect call, skip the entry expression }
  end;

  if pr <> nil then
  with pr^ do
  begin
    pre := nil;                                         { No return TMP variable }
    rty := nil;                                         { Equivalent type pointer init }
    pf := pro_parmlst;                                  { Get the first formal parameter pointer }
    if pro_typ <> nil then                              { For a function, we create the return value identifier }
    with pro_typ^ do
      if not typ_simple then
      begin { Note: the simple types are only the following:
              form_wlit,    form_ennum,   form_nil,     form_eqse,
              form_char,    form_lit,     form_int,     form_single,  form_double,
              form_set,     form_wset,    form_wwset,   form_pointer, form_range,
              form_file,    form_wfile,   form_fpro. }
        { Temporary return function var_result }
        { Set by procdecl/parmlist }
        pre := LGT_NEW_IDREF( wildtmp_ide, pe );        { Create an identifier to keep the returned value }
        pre^.lgt_typ  := pro_typ;                       { Set the return type }
        pre^.lgt_lide := pro_geneide;                   { Set the related ide (as rec. field) }
        lgt^.lgt_parmlst := pre;
        pf := pf^.ide_nxt                               { Skip to true formal parameter }
      end;

    while pf <> nil do { * Loop on all formal parameters }
    begin
      ft   :=   nil;                                    { Assume that it is not a conformant model }
      b_sa := false;
      b_ch := false;
      objb :=    pe;                                    { Set head of effective argument object base }
      with pf^ do
      begin
        if pe <> nil then                               { If effective parameter list is not finished }
        begin
          if pe^.lgt_kind = lgt_empty then b_def := true
          else
          begin                                         { Effective parameter is present }
            if ide_typ <> nil then
            begin
              with ide_typ^ do                          { With the effective parameter type }
              case typ_form { Form of formal type } of
                form_record: { * Effective is a character and formal is a string }
                  if COMP_TYPE( ide_typ, typ_std[form_record], false ) and
                     COMP_TYPE( pe^.lgt_typ, typ_std[form_char], true ) then
                    if pe^.lgt_kind = lgt_const then
                    begin                               { Change the Cte char to a Cte string }
                      ch := CHR( pe^.lgt_cte^.val_ival );
                      VAL_FREE( pe^.lgt_cte );
                      VAL_NEW( pe^.lgt_cte, typ_std[form_record] );
                      pe^.lgt_typ := typ_std[form_record];
                      with pe^.lgt_cte^ do
                      begin
                        val_kind := form_string;
                        val_size := 1;
                        NEW( val_str, 1);
                        val_str^ := ch
                      end
                    end
                    else
                    begin                               { Generate a conversion from character to string }
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      pe := GENERATE_CALL( gen_std_string1, pe,, true );
                      pe^.lgt_nxt := lgc;
                      pe^.lgt_status := [lgt_add,lgt_in];
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe
                    end;

                form_array,
                form_conf:
                  begin  { * Formal is an array or a conformant array }
                    if COMP_TYPE( pe^.lgt_typ, typ_std[form_record], false ) then
                    { The effective parameter is a string }
                    begin                               { Pass the <string>.body as the effective parameter }
                      b_sa := true;
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      LGT_NEW( pe, typ_std[form_record]^.typ_lastfield^.ide_typ, lgt_offset, pe );
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe;
                      pe^.lgt_disp := typ_std[form_record]^.typ_lastfield^.ide_offset;
                      pe^.lgt_nxt  := lgc
                    end
                    else
                    if COMP_TYPE( pe^.lgt_typ, typ_std[form_char], false ) then
                    begin  b_sa := true; b_ch := true  end;
                    if typ_form = form_conf then ft  := ide_typ                      { Keep the conformant schema typ_rec }
                  end;

                form_nil,    form_wlit,   form_ennum,
                form_wset,   form_wlset,  form_wwset,
                form_wrecord,form_wild,   form_equv:
                  begin { * For a wild type equivalence keep type pointer }
                    if rty = nil then rty := pe^.lgt_typ
                    else                                { Update when no same category }
                      if (rty^.typ_simple and not pe^.lgt_typ^.typ_simple) or
                         (rty^.typ_size < pe^.lgt_typ^.typ_size) then rty := pe^.lgt_typ
                  end;

              otherwise
              end;

              { Now we check the access right }
              case ide_vkind of
                var_formal: { * By Reference }
                  begin { For copy in a memory for register/immediat value }
                    if not (lgt_add in pe^.lgt_status) then
                    begin
                      with pe^ do { * Flag the possible write/modification of value }
                        if var_out in ide_vacc then lgt_status := lgt_status + [lgt_wrt];
                      lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                      LGT_NEW( pe, pe^.lgt_typ, lgt_refer, pe );
                      pe^.lgt_nxt := lgc;               { Rebuilt the normal param link }
                      { ... and link to previous are call node }
                      if pre = nil then lgt^.lgt_parmlst := pe
                                   else pre^.lgt_nxt := pe
                    end
                  end;

                var_refer: { * By access reference (address is keep as the effective parm. }
                  begin
                    lgc := pe^.lgt_nxt; pe^.lgt_nxt := nil;
                    LGT_NEW( pe, pe^.lgt_typ, lgt_refer, pe );
                    pe^.lgt_status := pe^.lgt_status + [lgt_add];
                    pe^.lgt_nxt := lgc;                 { Rebuilt the normal parm. link }
                    { ... and link to previous are call node }
                    if pre = nil then lgt^.lgt_parmlst := pe
                                 else pre^.lgt_nxt := pe
                  end;

              otherwise
              end;
              b_def := false
            end
          end
        end
        else
        begin { No lgt node }
          LGT_NEW( pe, ide_typ, lgt_const, nil );
          { Link the added default parameter }
          if pre = nil then lgt^.lgt_parmlst := pe
                       else pre^.lgt_nxt := pe;
          b_def := true
        end;

        if b_def then                                   { The default parameter must be specified }
          if var_optional in ide_vacc then
          with pe^ do
          begin
            lgt_kind := lgt_empty;
            lgt_typ  := ide_typ;
            lgt_lide := nil
          end
          else
          if ide_inival <> nil then
          with pe^ do
          begin                                         { Set the default parameter value }
            lgt_kind := lgt_const;
            lgt_typ  := ide_typ;
            lgt_cte  := ide_inival;                     { Set the default value }
            VAL_NEW( lgt_cte, ide_typ );
            lgt_lide := nil
          end
          else SRC_ERROR_S( mdnam, 854, e_error, ide_name^ );   { Default value was not specified }

        pre := pe
      end;

      if ft <> nil then
      if ft^.typ_indtype <> nil then                    { For a defined index type }
      with ft^.typ_indtype^ do
      if (typ_low <> nil) and (typ_high <> nil) then    { For legal conformant type only }
      begin                                             { Get the conformant array bounds as extra parameters }
        with objb^ do
          if lgt_kind = lgt_call then lgt_status := lgt_status + [lgt_cas];

        iti := ft^.typ_indtype;                         { Get the formal index type }
        lgi := nil; lgj := nil;                         { Set the special effective argument list to empty }

        if b_sa then                                    { String given as an array of char (it is a special case) }
        begin
(*   ?????????? *)
          repeat
            if iti^.typ_parent <> nil then iti := iti^.typ_parent
          until (iti^.typ_parent = nil) or (iti^.typ_form <> form_range);

          if b_ch then
          begin { Form single char 'c' in a packed array[...] of char }
            lgi := LGT_NEW_ECONST( iti, 1 );
            pf := pf^.ide_nxt;                          { Skip special formal in the list }
            if typ_low^.lgt_kind <> lgt_const then      { Two parameters conformant model }
            begin
              lgj := LGT_NEW_ECONST( iti, 1 ); lgi^.lgt_nxt := lgj;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
            end
            else lgj := lgi                             { One parameter conformant model }
          end
          else
          begin { Form string as a packed array[...] of char }
            if typ_low^.lgt_kind <> lgt_const then
            begin { Two parameters conformant model }
              lgi := LGT_NEW_ECONST( iti, 1 );          { Low index bound is always 1 }
              lgj := lgi;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
            end;
            if objb^.lgt_kind = lgt_const then
              lgc := LGT_NEW_ECONST( iti, objb^.lgt_cte^.val_size )
            else
            begin
              LGT_NEW( lgc, typ_std[form_record]^.typ_parmlst^.ide_typ, lgt_offset, LGT_LINK( objb ) );
              { Give the length for in_var formal and the capacity for out_var and var formal }
              if not (var_out in pf^.ide_vacc) then lgc^.lgt_disp := typ_std[form_record]^.typ_firstfield^.ide_offset;
              { Adjust the special argument as required }
              if lgc^.lgt_typ <> iti then
              begin
                lgc := LGT_NEW_CODE( pcod_noop, lgc );
                lgc^.lgt_typ := iti
              end
            end;
            pf := pf^.ide_nxt;                          { Skip special formal in the list }
            if lgj = nil then lgi := lgc
                         else lgj^.lgt_nxt := lgc;
            lgj := lgc
          end
        end { if b_sa then }
        else
        begin { Insert the extra parameter(s) for standard conformant array }
          et := pe^.lgt_typ;
          if et <> nil then
          while (ft <> nil) and (et <> nil) do
            if (ft^.typ_form = form_conf) and
               ((et^.typ_form = form_conf) or
                (et^.typ_form = form_array)) then
            begin
              it  := et^.typ_indtype;                   { Get the effective index array type }
              iti := ft^.typ_indtype;                   { Get the formal index array type }
(* ????????????? *)
              repeat
                if iti^.typ_parent <> nil then iti := iti^.typ_parent
              until (iti^.typ_parent = nil) or (iti^.typ_form <> form_range);

              if it^.typ_form = form_range then descr := LOOK_FOR_DESCRIPTOR( objb, it )
                                           else descr := objb;
(*
WRITELN( lst_current^.lst_file, ' Used Descritor found :' ); LGT_WRITE_TREE( 8, descr );
*)
              if typ_low^.lgt_kind <> lgt_const then
              begin { Two special arguments conformant schema }
                if it^.typ_form = form_range then
                begin
                  lgc := LGT_TYPE_EVAL( it^.typ_low, descr );
                  if it^.typ_size <> iti^.typ_size then
                  begin
                    lgc := LGT_NEW_CODE( pcod_noop, lgc );
                    lgc^.lgt_typ := iti
                  end
                end
                else lgc := LGT_NEW_ECONST( iti, it^.typ_min );
                if lgj = nil then lgi := lgc
                             else lgj^.lgt_nxt := lgc;
                lgj := lgc;
                pf := pf^.ide_nxt;                      { Skip special formal in the list }
              end;

              if it^.typ_form = form_range then
              begin
                lgc := LGT_TYPE_EVAL( it^.typ_high, descr );
                if it <> iti then
                begin
                  lgc := LGT_NEW_CODE( pcod_noop, lgc );
                  lgc^.lgt_typ := iti
                end
              end
              else lgc := LGT_NEW_ECONST( iti, it^.typ_max );
              if lgj = nil then lgi := lgc
                           else lgj^.lgt_nxt := lgc;
              lgj := lgc;
              pf := pf^.ide_nxt;                        { Skip special formal in the list }
              et  := et^.typ_aeltype;
              ft  := ft^.typ_aeltype
            end else ft := nil;                         { while ... do  if ... }

          with pe^ do                                   { Adjust the conformant array base address }
            if lgt_typ^.typ_descr_size > 0 then
              lgt_disp := lgt_disp + lgt_typ^.typ_descr_size
        end { if b_sa then ... : else code };

        { Attach the special arguments to the user's one }
        if lgi <> nil then
        begin
          lgj^.lgt_nxt := pe^.lgt_nxt;          { Link the last special parg to the next user's one }
          pe^.lgt_nxt := lgi;                   { Link the current user arg. to the first special one }
          pe := lgj                             { pe -> the last actual arg. ... }
        end;
        pre := pe                               { ... that is also the future previous arg. }
      end { if ft <> nil then };

      if pe <> nil then pe := pe^.lgt_nxt;
      pf := pf^.ide_nxt
    end { End loop on formal };

    if pro_typ <> nil then
    with lgt^ do
    begin  { For any function: Management of Equv and eqst special types }
      if (pro_typ^.typ_form = form_equv) or
         (pro_typ^.typ_form = form_eqst) then
      begin { Equivalent type to largest effective parameter }
        lgt_typ := rty;
        if (not rty^.typ_simple) and (lgt_parmlst <> nil) then
          lgt_parmlst^.lgt_typ := rty
      end;

      { Allocate the space for returned value }
      if not pro_typ^.typ_simple then
        TMPSTK_ALLOCATE( lgt_parmlst, lgt_parmlst^.lgt_typ )
    end
  end
end CALL_SETTING;



[global]
procedure GENERIC_SEARCH( var id:   id_name;
                              npa:  integer;
                          var pg:   gen_ptr;
                          parm_lst: lgt_ptr );
{ Procedure to find the procedure to choice in a generic list.
  npa is the given parameter number,   
  pg ins in/out pointer in the generic list,
  On a success the procedure CALL_SETTING is called just before return
  if the selected action is a procedure/function (not a builtin operator).
}
const
  mdnam = 'GENS';

var
  found, comp, bequ, bset: boolean;
  p1:                      ide_ptr;
  is, iconf:               integer;
  lgt1, lgte:              lgt_ptr;
  ty:                      typ_ptr;
  nn: [static] integer := 0;

(*
procedure WRITEADDR( p: $wild_pointer );
var
 eq: record case boolean of
       false:( pp: $wild_pointer );
       true:(  iv: integer )
     end;
begin
  eq.pp := p;
  WRITE( eq.iv:-10 )
end;
 *)
(*
%ifdef %DEBUG %then*)
var
  q: gen_ptr;

procedure WRTT( pt: typ_ptr );
begin
  if pt <> nil then WRITE( pt^.typ_form  )
  else WRITE( '------ ' )
end WRTT;

procedure WRT( in_var arg: oparg_rec );
var
  b: boolean := false;

begin
  with arg do
  begin
    WRITE( '<' );
    WRTT( oar_typ );
    WRITE( ',', oar_cve, ',[' );
    for el := oparg_flagty"first to oparg_flagty"last do
    begin
      if b then WRITE( ',' ) else b := true;
      if el in oar_prp then WRITE( el )
    end;
    WRITE( ']>' )
  end
end WRT;

procedure SHOW_REQUEST;
begin
  WRITE( ' Generic_Search for np = ', npa:0, ' with ' );
  if parm_lst <> nil then
  with parm_lst^ do
  begin
    WRITE( 'Arg_1 f_type ' ); WRTT( lgt_typ );
    if lgt_nxt <> nil then
    begin
      WRITE( ', Arg_2 f_type ' ); WRTT( lgt_nxt^.lgt_typ )
    end;
    WRITELN
  end else WRITELN( 'No arg.' );
end SHOW_REQUEST;

procedure SHOW_ENTRY( pg: gen_ptr; bt: boolean );
begin
  with pg^ do
    if gen_blt and (npa <= 2) then
    begin
      if bt then WRITE( ' Ok for Entry : ' )
      else WRITE( '    Entry ' );
      if gen_atb <> nil then
      begin
        WRT( gen_atb^[1] ); WRITE( ', ' );  WRT( gen_atb^[2] ); WRITE( ' -> ' )
      end;
      WRT( gen_res ); WRITELN( ' -> code = ', gen_cod )
    end
end SHOW_ENTRY;

procedure DUMP;
begin
  SHOW_REQUEST;
  while q <> nil do
  with q^ do
  begin
    SHOW_ENTRY( q, false );
    q := gen_link
  end 
end DUMP;
(*
%endif
*)

begin { GENERIC_SEARCH }
(*
%ifdef %DEBUG %then
 *)
  q := pg;
(*
%endif
 *)
  if DEBUG_MOD then SHOW_REQUEST;
  found := false;
  while not found and (pg <> nil) do
  begin
    lgt1 := parm_lst;                          { Get effective parameter list }
    with pg^ do
      if gen_blt and (npa <= 2) then { *** Builtin Operator Definition *** }
      begin
        with lgt1^ do
        case npa of
          0: found := (gen_p1 = nil) and (gen_p2 = nil);
          1: found := (gen_p2 = nil) and COMP_TYPE( lgt_typ, gen_p1, false );
          2:
             if (lgt_typ^.typ_size > 0) and
                (lgt_nxt^.lgt_typ^.typ_size > 0) then
             case gen_p1^.typ_form of
               form_eqst: { * Type exactly same and without (type) parameter }
                 found := COMP_TYPE(lgt_nxt^.lgt_typ, lgt_typ, true ) and       { Exactly the same types, ... }
                          (lgt_typ^.typ_descr_size = 0) and                     { ... No descriptor, ... }
                          (lgt_typ^.typ_size = lgt_nxt^.lgt_typ^.typ_size) and  { .. exactly the same size ... }
                          COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );         { ... and compatible type with the model. }

               form_equv: { * The two arg. types must be compatible }
                 found := (COMP_TYPE( lgt_nxt^.lgt_typ, lgt_typ, false ) or     { Compare the parent child relation in ... }
                           COMP_TYPE( lgt_typ, lgt_nxt^.lgt_typ, false )) and   { ... the two directions, and the compatibility ... }
                          COMP_TYPE( lgt_typ, gen_p2, false ) and               { ... of each effective argument to the formel ones. }
                          COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );
                        
               form_eqse: { * The type of second element must be a set of the type of the first element }
               found :=
                 COMP_TYPE( lgt_nxt^.lgt_typ, typ_std[form_wwset], false ) and  { The second argument must be a set, ... }
                 COMP_TYPE( lgt_typ, lgt_nxt^.lgt_typ^.typ_seltype, false )     { ... the first one must be compatible with ... }
                 and COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, false );              { ... its set element and with the formal type. }
                 
             otherwise
               found := COMP_TYPE( lgt_typ, gen_p1, true ) and
                        COMP_TYPE( lgt_nxt^.lgt_typ, gen_p2, true );
             end;
        end
      end
      else { *** User Defined *** }
        with gen_proc^ do
        if pro_nparm >= npa then
        begin                                  { The number of Formal is >= than the Effective parameter number }
          p1 := pro_parmlst;
          if pro_parmlst <> nil then
            if pro_parmlst^.ide_vkind = var_result then
              p1 := p1^.ide_nxt                { Skip function result when used };
          { Special function/procedure }
          if (npa = 2) and (pro_nparm = 2) and
             ((pro_pkind = pro_standard) or (pro_pkind = pro_external)) then
          with lgt1^ do
          begin                                { For Special Standard Procedure/Function model }
            case p1^.ide_typ^.typ_form of
              form_eqst: { * Type exactly same and without (type) parameter }
                found := (lgt_nxt^.lgt_typ = lgt_typ) and
                         (lgt_typ^.typ_descr_size = 0) and  
                         COMP_TYPE( lgt_typ, p1^.ide_nxt^.ide_typ, false );

              form_equv: { * Force binary op to have compatible types }
                found := (COMP_TYPE( lgt_nxt^.lgt_typ, lgt_typ, false ) or
                          COMP_TYPE( lgt_typ, lgt_nxt^.lgt_typ, false )) and
                         COMP_TYPE( lgt_typ, p1^.ide_nxt^.ide_typ, false ) and
                         COMP_TYPE( lgt_nxt^.lgt_typ, p1^.ide_nxt^.ide_typ, false );

              form_eqse: { * Type of equivalent set element }
                if COMP_TYPE( lgt_nxt^.lgt_typ, typ_std[form_wwset], false )
                then
                  found := COMP_TYPE( lgt_typ,
                                      lgt_nxt^.lgt_typ^.typ_seltype, false )
                       and COMP_TYPE( lgt_nxt^.lgt_typ,
                                      p1^.ide_nxt^.ide_typ, false );
            otherwise
              found := false
            end
          end;
          if not found then
          begin
            found := true;                     { Until shown otherwise }
            while found and (p1 <> nil) do     { Formal/Effective argument (formal and effective) loop }
            begin
              iconf := 0;
              with p1^ do                      { With this formal parameter }
                if lgt1 <> nil then            { User list not finished }
                with lgt1^ do
                begin
                  if lgt_kind = lgt_empty then { Empty parameter given }
                    if (ide_inival = nil) and not (var_optional in ide_vacc) then
                      { Default value does not exist } found := false
                    else
                    begin                      { Empty parameter is allowed }
                      p1 := ide_nxt; lgt1 := lgt_nxt
                    end
                  else { Parameter is provided }
                  begin
                    comp := COMP_TYPE( lgt_typ, ide_typ, ide_vkind <> var_vformal );

                    { Some special opportunities for Cte effective parameters }
                    if (not comp) and (lgt_kind = lgt_const) then
                    { When the effective parameter is a constant }
                    with ide_typ^ do
                    case typ_form of           { case on formal parameter type kind }
(*                    form_single: { * The constant must be converted to single }
                        if lgt_typ^.typ_form = form_double then
                        begin
                          lgt_typ := typ_std[form_single]; comp := true
                        end;
*)
                      form_double: { * The constant must be converted to double }
                        if lgt_typ^.typ_form = form_single then
                        begin
                          lgt_typ := typ_std[form_double]; comp := true
                        end;

(*
                      form_record:
                        if COMP_TYPE( ide_typ, typ_std[form_record], false )
                        then
                          { The Standard String are always compatible with
                            any Character constant ... }
                          if COMP_TYPE( lgt_typ, typ_std[form_char], false )
                          then comp := true
                          else
                          { ... and any Constant Array[<integer>] of char }
                          with lgt_typ^ do
                          if (typ_form = form_array) and
                            COMP_TYPE( typ_aeltype, typ_std[form_char], false)
                            and (typ_indtype^.typ_form = form_int)
                          then comp := true;
*)

                      form_array,
                      form_conf: { * Conformant array of char is compatible with any Cte string or char }
                        if COMP_TYPE( typ_aeltype, typ_std[form_char], true )
                           and (typ_indtype^.typ_form = form_int) and (typ_descr_size = 0) then
                          { When the formal is an array[] of char (without descriptor) }
                          if COMP_TYPE( lgt_typ, typ_std[form_record], false )
                          then                 { It must be compatible with a Cte string
                                                 (passed as fixed array size) when sizes match }
                            if typ_form = form_array then
                              with typ_indtype^ do
                                comp := ((typ_max - typ_min + 1) =
                                                lgt_cte^.val_size)
                            else
                              comp := true
                          else                 { OR with a Cte char }
                            if COMP_TYPE( lgt_typ, typ_std[form_char], false )
                            then
                              if typ_form = form_conf then comp := true
                              else comp := (typ_max = typ_min);

                    otherwise
                    end;
                    { Set conformant supplementary parameter count }
                    if comp then
                    begin
                      if ide_typ <> nil then
                        if ide_typ^.typ_form = form_conf then
                          iconf := ide_typ^.typ_idim;
                      p1 := ide_nxt; lgt1 := lgt_nxt
                    end else found := false;

                    { Verify also the access code matching * * * Patch 1.9 L * * * }
                    if found then
                    begin
                      if ide_vkind = var_vformal then
                      begin                    { Formal By Value }
                        if not (lgt_in in lgt_status) then found := false
                      end
                      else                     { Formal By Reference }
                        if lgt_add in lgt_status then
                        begin
                          if var_in in ide_vacc then
                            if not (lgt_in in lgt_status) then found := false;
                          if var_out in ide_vacc then
                            if not (lgt_out in lgt_status) then found := false
                        end
                        else { The in_var formal parameter must be accept any expression - can be copied ina memory location }
                          if var_out in ide_vacc then found := false
                    end
                  end
                end
                else                           { End of caller parameter list reached }
                  if (ide_inival = nil) and not (var_optional in ide_vacc) then
                    found := false             { Default value not exists }
                  else                         { Empty parameter is allowed }
                    p1 := ide_nxt;

              if iconf > 0 then                { Skip formal supplementary parameter count (for Form_conf) }
              repeat
                p1 := p1^.ide_nxt; iconf := iconf - 1
              until iconf = 0
            end
          end
        end;
    if not found then  pg := pg^.gen_link      { Skip to next definition }
  end;
  if not found then                            { We have not found the procedure/function to use }
  begin
    DUMP;
    SRC_ERROR_S( mdnam, 113, e_severe, id )
  end

(*
%ifdef %DEBUG %then
*)
  else if DEBUG_MOD then SHOW_ENTRY( pg, true )
(*
%endif
*)
end GENERIC_SEARCH;



[global]
function EXP_GENOPER( var id: id_name; p: gen_ptr; oblst: lgt_ptr ): lgt_ptr;
{ Procedure to handle any unary and binary operator as defined with :
  - id      the identifier name of ,
  - p       the head entry pointer of the Generic Search List,
  - oblst   the list of effective parameters (1 or 2 parameters only). }
var
  n:   integer;
  lgt: lgt_ptr;

begin
  n := 1 + ORD( oblst^.lgt_nxt <> nil );
  GENERIC_SEARCH( id, n, p, oblst );                   { Look for the generic call }
  if p <> nil then
  with p^ do
  begin
    if gen_blt then                                    { For built-in operator, ... }
    begin                                              { if pcod definition exist }
      if n = 1 then lgt := EXP_VAL_UNA( oblst, p )     { Unary operator }
               else lgt := EXP_VAL_BIN( oblst, p );    { Binary operator }
      if lgt^.lgt_typ = typ_std[form_equv] then lgt^.lgt_typ := oblst^.lgt_typ
    end
    else
    begin { For any user definition }
      with gen_proc^ do
      begin
        lgt := LGT_NEW_CALL( pro_typ, gen_proc, oblst );       { Create a new node }
        if pro_typ = typ_std[form_equv] then lgt^.lgt_typ := oblst^.lgt_typ
      end;
      CALL_SETTING( lgt )                              { Complete the call }
    end;
    EXP_GENOPER := lgt
  end else EXP_GENOPER := oblst                        { No procedure/function/operator founded }
end EXP_GENOPER;



[global]
function GENERATE_CALL( ip: ide_ptr; lgp: lgt_ptr;
                        np: integer := 0; bsnsea: boolean := false ): lgt_ptr;
{ Generate a complet call Sequence of generic name specified by the ip identifier,
  and with the lgp effective parameter list. When bsnsea is true, a previous IDE_SEARCH
  is performed to locate any possible redefinition of generic. }
var
  pg:     gen_ptr;
  lg, re: lgt_ptr;

begin
  if bsnsea then IDE_SEARCH_FROM_NAMEID( ip );
  pg := ip^.ide_gfirst;                                { Get generic list head }
  if np <= 0 then
  begin
    lg := lgp;
    while lg <> nil do
    begin  lg := lg^.lgt_nxt; np := np + 1  end
  end;
  re := nil;
  if (np = 1) or (np = 2) then
    re := EXP_GENOPER( ip^.ide_name^, pg, lgp )
  else
  begin                                                { Other case }
    { Look for matched procedure/function }
    GENERIC_SEARCH( ip^.ide_name^, np, pg, lgp );
    if pg <> nil then with pg^ do                      { We have found a good gen_rec user definition }
      if gen_proc <> nil then
      begin                                            { Allocated a node for the call }
        re := LGT_NEW_CALL( gen_proc^.pro_typ, gen_proc, lgp );
        CALL_SETTING( re );                            { Complete the call }
        if gen_proc^.pro_typ = typ_std[form_equv] then re^.lgt_typ := lgp^.lgt_typ
      end
  end;
  GENERATE_CALL := re
end GENERATE_CALL;



[global]
function EXP_GENOP( op: operator; oblst: lgt_ptr ): lgt_ptr;
begin
  EXP_GENOP := EXP_GENOPER( opname[op], ope_table[op]^.ope_gfirst, oblst );
end EXP_GENOP;



[global]
function  LGT_GEN_STORE( prm: lgt_ptr; bstd, bovr: boolean ): lgt_ptr;
{ To generate a Builtin Store of any object }
{ Any possible Read Protection is By-Passed }
var
  lgr, pr2: lgt_ptr;
  pgf:      gen_ptr;
  s1, s2:   lgt_states;

begin
  if bstd then pgf := std_store_dgf                    { Use Standard Env. Only }
          else pgf := ope_table[ass_op]^.ope_gfirst;   { Use Current Environment }
  pr2 := prm^.lgt_nxt;
  s1 := prm^.lgt_status;
  s2 := pr2^.lgt_status;
  if bovr then
  begin
    prm^.lgt_status := s1 + [lgt_out,lgt_in];
    pr2^.lgt_status := s2 + [lgt_in]
  end;
  lgr := EXP_GENOPER( opname[ass_op], pgf, prm );
  if bovr then
  begin
    prm^.lgt_status := s1;
    pr2^.lgt_status := s2
  end;
  return lgr
end LGT_GEN_STORE;
