/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 88 ) = {
  8,   8, 115, 116, 114,  95,  99, 111, 112, 121,  64,  64,  47, 104, 111, 109,
101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112,
115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95,
115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47, 101, 120, 116, 114,  97,
105, 116,  95, 105, 100, 101, 110, 116,  46, 112,  97, 115,   8,   8, 118,  97,
108,  95,  99, 111, 112, 121,   0,   0
};

/* Declaration of external variables. */
extern SL V_curr_lex;


/* Function/procedure prototypes. */
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);


/* Procedure/Function : " str_copy "  */
void P_str_copy(V *F_target, V *F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=95; /* line # 95 */
  if ((*F_target)!=(*F_src)) {
    if ((*F_src)==NULL) {
      if ((*F_target)!=NULL) ((UB *)(*F_target))[1]=0;
    }
    else {
      Ra.sl[6]=103; /* line # 103 */
      if (((UB *)(*F_src))[1]>0&&(*F_target)==NULL) {
        Rv0=((UB *)(*F_src))[1];
        (*F_target)=PAS__NEW((SL)Rv0+2);
        ((UB *)(*F_target))[0]=Rv0;
      }
      (*F_target)=(*F_src);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_copy "  */
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=120; /* line # 120 */
  if ((*F_v2)!=NULL) P_val_free(F_v2);
  if ((*F_v1)==NULL) (*F_v2)=NULL;
  else {
    if (F_bfree&&((SL *)(*F_v1))[3]==1) {
      Ra.sl[6]=125; /* line # 125 */
      (*F_v2)=(*F_v1);
      (*F_v1)=NULL;
    }
    else {
      P_val_new(F_v2,((V *)(*F_v1))[4]);
      Ra.sl[6]=130; /* line # 130 */
      memcpy((*F_v2),(*F_v1),64);
      Rv0=(*F_v2);
      ((V *)Rv0)[0]=NULL;
      ((SL *)Rv0)[3]=1;
      Ra.sl[6]=135; /* line # 135 */
      ((SL *)Rv0)[7]=V_curr_lex;
      switch (((UB *)Rv0)[48]) {
        case 29:if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[6]=140; /* line # 140 */
          ((V *)Rv0)[7]=NULL;
          P_str_copy(((V *)Rv0)+7,((V *)(*F_v1))+7);
        }
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=145; /* line # 145 */
        if (((V *)Rv0)[7]!=NULL) {
          Rv1=((V *)Rv0)[7];
          ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
        }
        break;
        case 21:Ra.sl[6]=151; /* line # 151 */
        ((V *)Rv0)[7]=P_tab_new(((SL *)Rv0)[6]);
        Rv2=((V *)(*F_v1))[7];
        Rv3=0;
        for( Rf0=(((SL *)Rv0)[6]-1)+1;Rf0>0;Rf0-- ) {
          ((SL *)((V *)Rv0)[7])[Rv3]=((SL *)Rv2)[Rv3];
          Rv3++;
        }
        break;
        default:break;
      }
      Ra.sl[6]=160; /* line # 160 */
      if (F_bfree) P_val_free(F_v1);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}
