/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 152 ) = {
  8,   8,  82, 117, 110,  32, 116, 104, 101,  32,   4,   4,  32,  97, 116,  32,
  2,   2,  27,  92,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,   3,   3,
 32,  45,  32,   8,   8,  72,  69,  65,  68,  73,  78,  71,  32,   6,   6,  84,
 73,  84,  76,  69,  32,   7,   7,  84,  73,  84,  76,  69,  32,  48,   9,   9,
 83,  85,  66,  84,  73,  84,  76,  69,  32,  10,  10,  83,  85,  66,  84,  73,
 84,  76,  69,  32,  48,   0,   0,   0,   0,   0,   0,   5,   5,  80,  97, 103,
101,  32,  10,  10,  92,  83,  75,  73,  80,  76,  73,  78,  69,  32,   3,   3,
 78,  78,  78,   3,   3,  78,  78,  78,  11,  11,  92,  67,  72,  65,  82,  95,
 65,  84,  84,  82,  32,  10,  10,  84,  69,  83,  84,  95,  76,  73,  78,  69,
 32,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;

/* Declaration of global variables. */
V V_lst_current = NULL;
V V_lst_hde = NULL;
UL V_lst_spc_mode = 0;
Blk(V_lst_date, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_lst_time, 16 ) = {
 14,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
void P_vls_nextstring();


/* Procedure/Function : " str_copy_lim "  */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim){
  /* Local variable stored in C variable */
  SL Rv0;
  register UB Rv1;

  /* Code of procedure/function */
  Rv0=((UB *)F_src)[1];
  if (F_lim==0) F_lim=Rv0;
  else {
    if (Rv0>F_lim) Rv0=F_lim;
  }
  if ((*F_trg)!=NULL) PAS__DISPOSE(F_trg);
  if (Rv0>0) {
    Rv1=Rv0;
    (*F_trg)=PAS__NEW((SL)Rv1+2);
    ((UB *)(*F_trg))[0]=Rv1;
    PAS__STR_TO_STR((*F_trg),F_src);
  }
  else (*F_trg)=NULL;
}


/* Procedure/Function : " lst_init "  */
void P_lst_init(V F_p){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=F_p;
  ((V *)Rv0)[1]=NULL;
  ((V *)Rv0)[2]=NULL;
  ((V *)Rv0)[4]=NULL;
  ((V *)Rv0)[5]=NULL;
  ((SL *)Rv0)[12]=0;
  ((SL *)Rv0)[13]=0;
  ((SL *)Rv0)[14]=0;
  ((SL *)Rv0)[15]=0;
  ((SL *)Rv0)[16]=0;
  ((SL *)Rv0)[17]=0;
  ((UB *)Rv0)[72]=0;
  _FILE_CLEAR(((V *)Rv0)[10]);
}


/* Procedure/Function : " lst_allocate "  */
V P_lst_allocate(){
  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Rv0=PAS__NEW(88);
  ((V *)Rv0)[0]=V_lst_hde;
  V_lst_hde=Rv0;
  ((V *)Rv0)[3]=PAS__NEW(34);
  ((UB *)((V *)Rv0)[3])[0]=32;
  P_lst_init(Rv0);
  Ret=Rv0;
  return(Ret);
}


/* Procedure/Function : " lst_free "  */
void P_lst_free(V *F_p){
  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=NULL;
  if ((*F_p)!=NULL) {
    Rv1=V_lst_hde;
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else Rv1=NULL;
  if (Rv1!=NULL) {
    Rv2=(*F_p);
    if (((V *)Rv2)[1]!=NULL) PAS__DISPOSE(((V *)Rv2)+1);
    if (((V *)Rv2)[3]!=NULL) PAS__DISPOSE(((V *)Rv2)+3);
    if (((V *)Rv2)[2]!=NULL) PAS__DISPOSE(((V *)Rv2)+2);
    if (((V *)Rv2)[4]!=NULL) PAS__DISPOSE(((V *)Rv2)+4);
    if (((V *)Rv2)[5]!=NULL) PAS__DISPOSE(((V *)Rv2)+5);
    if (Rv0==NULL) V_lst_hde=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(F_p);
    (*F_p)=NULL;
  }
}


/* Procedure/Function : " lst_close "  */
void P_lst_close(V *F_p, UB F_bfree){
  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  if ((*F_p)!=NULL) {
    Rv0=(*F_p);
    if (1&((UB *)Rv0)[72]) Rv1=1024;
    else Rv1=0;
    if ((68&((UB *)Rv0)[72])==0) PAS__CLOSE(((V *)Rv0)+10,Rv1);
    PAS__DISPOSE(((V *)Rv0)+1);
    ((V *)Rv0)[1]=NULL;
    if (((V *)Rv0)[2]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+2);
      ((V *)Rv0)[2]=NULL;
    }
    if (((V *)Rv0)[4]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+4);
      ((V *)Rv0)[4]=NULL;
    }
    if (((V *)Rv0)[5]!=NULL) {
      PAS__DISPOSE(((V *)Rv0)+5);
      ((V *)Rv0)[5]=NULL;
    }
    if (F_bfree) P_lst_free(F_p);
    else P_lst_init((*F_p));
  }
}


/* Procedure/Function : " lst_change_heading "  */
void P_lst_change_heading(V F_str, UB F_bskp){
  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  Rv1=((((SL *)Rv0)[16]-32)-4)-12;
  if (Rv1<60) Rv1=60;
  P_str_copy_lim(((V *)Rv0)+2,F_str,Rv1);
  PAS__DATE_STR(V_lst_date.s);
  PAS__TIME_STR(V_lst_time.s);
  PAS__VWRITE_INIT(((V *)Rv0)[3],1);
  PAS__WRITE_STR(Rd.s,-1,-1,32);
  PAS__WRITE_STR(V_lst_date.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+10,-1,-1,32);
  PAS__WRITE_STR(V_lst_time.s,-1,-1,32);
  PAS__WRITE_EOLN();
  if (((SL *)Rv0)[17]<0) {
    if (((V *)Rv0)[2]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+20,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[2])[1]+((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
      PAS__WRITE_STR(Rd.s+30,-1,-1,32);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+35,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[3])[1],0,0);
      PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
}


/* Procedure/Function : " lst_change_title "  */
void P_lst_change_title(V F_str, UB F_bskp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+4,F_str,((SL *)Rv0)[16]-1);
  if (((SL *)Rv0)[17]<0) {
    if (((V *)Rv0)[4]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+45,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[4])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+53,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
}


/* Procedure/Function : " lst_change_subtitle "  */
void P_lst_change_subtitle(V F_str, UB F_bskp){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  P_str_copy_lim(((V *)Rv0)+5,F_str,((SL *)Rv0)[16]-1);
  if (((SL *)Rv0)[17]<0) {
    if (((V *)Rv0)[5]!=NULL) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+62,-1,-1,32);
      PAS__WRITE_INT(((UB *)((V *)Rv0)[5])[1],0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+73,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    if (F_bskp) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
}


/* Procedure/Function : " lst_open "  */
void P_lst_open(V *F_p, V F_fspc, V F_heading, V F_title, V F_sbttl, SL F_lnsize
, SL F_pgsize, UB F_bunknown, UB F_bprint, UB F_bappend, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 776 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UL Rv2;
  register UB Rv3;
  SL Rv4;
  UB Rv5;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  if (F_heading!=NULL) PAS__STR_TO_STR(Ra.s,F_heading);
  else PAS__STR_TO_STR(Ra.s,Rd.s+85);
  if (F_title!=NULL) PAS__STR_TO_STR(Ra.s+257,F_title);
  else PAS__STR_TO_STR(Ra.s+257,Rd.s+87);
  if (F_sbttl!=NULL) PAS__STR_TO_STR(Ra.s+514,F_sbttl);
  else PAS__STR_TO_STR(Ra.s+514,Rd.s+89);
  Rv0=(*F_p)!=NULL;
  if ((*F_p)==NULL) (*F_p)=P_lst_allocate();
  else P_lst_close(F_p,0);
  Rv1=(*F_p);
  if (((UB *)F_fspc)[1]==0) {
    _FILE_DUPLICATE(((V *)Rv1)[10],PAS__f_output);
    ((UB *)Rv1)[72]=4;
    PAS__iostatus=0;
  }
  else {
    Rv2=4098|V_lst_spc_mode;
    if (F_bprint) ((UB *)Rv1)[72]=1;
    if (F_bappend) Rv2=Rv2|4;
    if (F_bunknown) Rv2=Rv2|64;
    PAS__OPEN(((V *)Rv1)+10,0, F_fspc,Rv2,0,-1);
  }
  if (PAS__iostatus==0) {
    if (PAS__TTY_FILE(((V *)Rv1)[10])) {
      ((UB *)Rv1)[72]=((UB *)Rv1)[72]|2;
      ((UB *)Rv1)[72]=((UB *)Rv1)[72]&~1;
      if (F_lnsize<0) F_lnsize=80;
      if (F_pgsize<0) F_pgsize=0;
    }
    else {
      if (F_lnsize<0) F_lnsize=132;
      if (F_pgsize==0) F_pgsize=-1;
      else {
        if (F_pgsize<0) F_pgsize=60;
      }
    }
    Rv3=F_lnsize;
    ((V *)Rv1)[1]=PAS__NEW((SL)Rv3+2);
    ((UB *)((V *)Rv1)[1])[0]=Rv3;
    ((UB *)((V *)Rv1)[1])[1]=0;
    Rv4=F_lnsize-1;
    ((SL *)Rv1)[17]=F_pgsize;
    ((SL *)Rv1)[16]=F_lnsize;
    ((SL *)Rv1)[15]=((SL *)Rv1)[16];
    ((SL *)Rv1)[12]=((SL *)Rv1)[17];
    Rv5=0;
    if (Ra.ub[1]>0) {
      Rv5=1;
      P_lst_change_heading(Ra.s,0);
    }
    if (Ra.ub[258]>0) {
      Rv5=1;
      P_lst_change_title(Ra.s+257,0);
    }
    if (Ra.ub[515]>0) {
      Rv5=1;
      P_lst_change_subtitle(Ra.s+514,1);
    }
    if (Rv5&&((SL *)Rv1)[17]<0) {
      PAS__SELECT_OUT(((V *)Rv1)[10]);
      PAS__WRITE_EOLN();
    }
    (*F_ierr)=0;
  }
  else (*F_ierr)=2000+PAS__iostatus;
  if ((*F_ierr)!=0) {
    if (!Rv0) P_lst_free(F_p);
  }
}


/* Procedure/Function : " lst_newline "  */
void P_lst_newline(){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  if (!(64&((UB *)Rv0)[72])) {
    if (((SL *)Rv0)[17]>=10) {
      ((SL *)Rv0)[12]=((SL *)Rv0)[12]+1;
      if (((SL *)Rv0)[12]>=((SL *)Rv0)[17]) {
        ((SL *)Rv0)[12]=0;
        ((SL *)Rv0)[13]=((SL *)Rv0)[13]+1;
        PAS__PAGE(((V *)Rv0)[10]);
        if (((V *)Rv0)[2]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_STR(((V *)Rv0)[2],-1,-1,32);
          if (((SL *)Rv0)[16]<110) {
            ((SL *)Rv0)[12]=1;
            PAS__SELECT_OUT(((V *)Rv0)[10]);
            PAS__WRITE_EOLN();
          }
          else {
            PAS__SELECT_OUT(((V *)Rv0)[10]);
            PAS__WRITE_STR(Rd.s+30,-1,-1,32);
          }
          PAS__DATE_STR(V_lst_date.s);
          PAS__TIME_STR(V_lst_time.s);
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
          PAS__WRITE_FCHAR(32,4,-1,1,32);
          PAS__WRITE_STR(Rd.s+91,-1,-1,32);
          PAS__WRITE_INT(((SL *)Rv0)[13],3,0);
          PAS__WRITE_EOLN();
        }
        if (((V *)Rv0)[4]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[4],-1,-1,32);
        }
        PAS__SELECT_OUT(((V *)Rv0)[10]);
        PAS__WRITE_EOLN();
        if (((V *)Rv0)[5]!=NULL) {
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_EOLN();
          PAS__SELECT_OUT(((V *)Rv0)[10]);
          PAS__WRITE_STR(((V *)Rv0)[5],-1,-1,32);
          PAS__WRITE_EOLN();
          ((SL *)Rv0)[12]=((SL *)Rv0)[12]+2;
        }
        PAS__SELECT_OUT(((V *)Rv0)[10]);
        PAS__WRITE_EOLN();
        ((SL *)Rv0)[12]=((SL *)Rv0)[12]+3;
      }
    }
  }
}


/* Procedure/Function : " lst_eoln "  */
void P_lst_eoln(){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  P_lst_newline();
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (64&((UB *)Rv0)[72]) {
    P_vls_nextstring();
    ((UB *)Rv0)[72]=((UB *)Rv0)[72]&~8;
  }
  else {
    if (((UB *)Rv1)[1]>0) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(((V *)Rv0)[1],-1,-1,32);
      ((UB *)Rv1)[1]=0;
    }
    if (8&((UB *)Rv0)[72]) ((UB *)Rv0)[72]=((UB *)Rv0)[72]&~8;
    else {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_EOLN();
    }
  }
  while (((UB *)Rv1)[1]<((SL *)Rv0)[14]){
    ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
    ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
  }
}


/* Procedure/Function : " lst_breakoutput "  */
void P_lst_breakoutput(){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  ((UB *)Rv0)[72]=((UB *)Rv0)[72]|8;
  P_lst_eoln();
}


/* Procedure/Function : " lst_page "  */
void P_lst_page(){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  P_lst_eoln();
  Rv0=V_lst_current;
  if (((SL *)Rv0)[17]>=10) ((SL *)Rv0)[12]=((SL *)Rv0)[17];
  else {
    if (!(64&((UB *)Rv0)[72])) PAS__PAGE(((V *)Rv0)[10]);
  }
}


/* Procedure/Function : " lst_set_column "  */
void P_lst_set_column(SL F_col){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (F_col>((SL *)Rv0)[15]) P_lst_eoln();
  else {
    F_col=F_col-1;
    if (((UB *)Rv1)[1]>F_col) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_col){
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
}


/* Procedure/Function : " lst_set_margin "  */
void P_lst_set_margin(SL F_lm, SL F_rm){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if ((F_lm>=0&&F_rm>F_lm)&&F_rm<=((SL *)Rv0)[16]) {
    Rv2=((SL *)Rv0)[14];
    ((SL *)Rv0)[14]=F_lm;
    ((SL *)Rv0)[15]=F_rm;
    if (((UB *)Rv1)[1]>Rv2) P_lst_eoln();
    else while (((UB *)Rv1)[1]<F_lm){
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=32;
    }
  }
}


/* Procedure/Function : " lst_skip_line "  */
void P_lst_skip_line(SL F_nli){

  /* Code of procedure/function */
  if (((SL *)V_lst_current)[17]<0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+98,-1,-1,32);
    PAS__WRITE_INT(F_nli,0,0);
    PAS__WRITE_EOLN();
  }
  else while (F_nli>0){
    P_lst_eoln();
    F_nli=F_nli-1;
  }
}


/* Procedure/Function : " lst_set_char_attr "  */
void P_lst_set_char_attr(V F_sattr){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[17]<0) {
    Rv1=1;
    PAS__CHT_TO_CHT(Ra.s,3, Rd.s+112,3);
    Rv2=1;
    for( Rf0=((UB *)F_sattr)[1];Rf0>0;Rf0-- ) {
      switch (((C *)F_sattr)[Rv2+1]) {
        case 43:Rv1=1;
        break;
        case 45:Rv1=0;
        break;
        case 66:
        case 71:
        case 98:
        case 103:if (Rv1) Ra.c[0]=66;
        else Ra.c[0]=78;
        break;
        case 73:
        case 105:if (Rv1) Ra.c[1]=73;
        else Ra.c[1]=78;
        break;
        case 83:
        case 85:
        case 115:
        case 117:if (Rv1) Ra.c[2]=83;
        else Ra.c[2]=78;
        break;
        case 78:
        case 110:Rv1=1;
        PAS__CHT_TO_CHT(Ra.s,3, Rd.s+117,3);
        break;
        default:break;
      }
      Rv2++;
    }
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+120,-1,-1,32);
    PAS__WRITE_STR(F_sattr,-1,-1,32);
    PAS__WRITE_EOLN();
  }
}


/* Procedure/Function : " lst_test_line "  */
void P_lst_test_line(SL F_iskip, SL F_tstli){
  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  if (((SL *)Rv0)[17]>10) {
    if (F_tstli>((SL *)Rv0)[17]/2) F_tstli=((SL *)Rv0)[17]/2;
    if (F_iskip>F_tstli) F_iskip=F_tstli;
    if (((SL *)Rv0)[17]-((SL *)Rv0)[12]>=F_tstli) P_lst_skip_line(F_iskip);
    else((SL *)Rv0)[12]=((SL *)Rv0)[17]+1;
  }
  else {
    if (((SL *)Rv0)[17]<0) {
      PAS__SELECT_OUT(((V *)Rv0)[10]);
      PAS__WRITE_STR(Rd.s+16,-1,-1,32);
      PAS__WRITE_STR(Rd.s+133,-1,-1,32);
      PAS__WRITE_INT(F_iskip,0,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(F_tstli,0,0);
      PAS__WRITE_EOLN();
    }
  }
}


/* Procedure/Function : " lst_put_char "  */
void P_lst_put_char(C F_ch){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)Rv1)[1]>=((SL *)Rv0)[15]) P_lst_eoln();
  ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
  ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
}


/* Procedure/Function : " lst_put_mchar "  */
void P_lst_put_mchar(C F_ch, SL F_m){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  if (F_m>0) while (F_m>0){
    P_lst_put_char(F_ch);
    F_m=F_m-1;
  }
  else {
    Rv1=((V *)Rv0)[1];
    F_m= -F_m-1;
    if (F_m>=((UB *)Rv1)[0]) F_m=0;
    if (((UB *)Rv1)[1]>F_m) P_lst_eoln();
    while (((UB *)Rv1)[1]<F_m){
      ((UB *)Rv1)[1]=((UB *)Rv1)[1]+1;
      ((C *)Rv1)[((UB *)Rv1)[1]+1]=F_ch;
    }
  }
}


/* Procedure/Function : " lst_put_string "  */
void P_lst_put_string(V F_str){
  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((UB *)F_str)[1]>0) {
    Rv2=((SL *)Rv0)[15]-((SL *)Rv0)[14];
    if (Rv2>=((UB *)F_str)[1]) {
      if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<((UB *)F_str)[1]) P_lst_eoln();
      Rv3=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        P_lst_put_char(((C *)F_str)[Rv3+1]);
        Rv3++;
      }
    }
    else {
      Rv4=1;
      for( Rf0=((UB *)F_str)[1];Rf0>0;Rf0-- ) {
        P_lst_put_char(((C *)F_str)[Rv4+1]);
        Rv4++;
      }
    }
  }
}


/* Procedure/Function : " lst_put_int "  */
void P_lst_put_int(SL F_int, SL F_size, SL F_base){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=34;
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<abs(F_size)) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_INT(F_int, F_size, F_base);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
}


/* Procedure/Function : " lst_put_float "  */
void P_lst_put_float(G F_dv, SL F_fs, SL F_dcsz, SL F_es){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_es);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
}


/* Procedure/Function : " lst_put_fixed "  */
void P_lst_put_fixed(G F_dv, SL F_fs, SL F_dcsz, SL F_dcmin){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Rv0=V_lst_current;
  Rv1=((V *)Rv0)[1];
  if (((SL *)Rv0)[15]-((UB *)Rv1)[1]<F_fs) P_lst_eoln();
  PAS__VWRITE_INIT(Ra.s,1);
  PAS__WRITE_DBLE(F_dv, F_fs, F_dcsz, F_dcmin);
  PAS__WRITE_EOLN();
  P_lst_put_string(Ra.s);
}


/* Procedure/Function : " lst_g_init "  */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr){

  /* Code of procedure/function */
  V_lst_hde=NULL;
  V_lst_current=NULL;
  P_lst_open(&V_lst_current, F_def_lst,F_def_heading,Rd.s+145,Rd.s+145,132,0,0,0,0,
  F_ierr);
}
