/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local static Initialized section. */
static Blk( Ri, 40 ) = {
 74,  65,  78,  70,  69,  66,  77,  65,  82,  65,  80,  82,  77,  65,  89,  74,
 85,  78,  74,  85,  76,  65,  85,  71,  83,  69,  80,  79,  67,  84,  78,  79,
 86,  68,  69,  67,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(PAS__curtim, 40 );


/* Function/procedure prototypes. */
void PAS__N_TIME(V F_tmtb, SL F_ss, UB F_gmt);


/* Procedure/Function : " date_cht "  */
void PAS__DATE_CHT(V F_t, SL F_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;

  /* Code of procedure/function */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Rv0=PAS__curtim.sl[3];
  Rv1=PAS__curtim.sl[4];
  Rv2=PAS__curtim.sl[5];
  if (F_sz>=11) {
    ((C *)F_t)[0]=(C)(Rv0/10+48);
    ((C *)F_t)[1]=(C)(PAS__I_MOD(Rv0,10)+48);
    ((C *)F_t)[2]=45;
    ((C *)F_t)[3]=Ri.c[Rv1*3-3];
    ((C *)F_t)[4]=Ri.c[Rv1*3-2];
    ((C *)F_t)[5]=Ri.c[Rv1*3-1];
    ((C *)F_t)[6]=45;
    ((C *)F_t)[7]=(C)(Rv2/1000+48);
    Rv2=PAS__I_MOD(Rv2,1000);
    ((C *)F_t)[8]=(C)(Rv2/100+48);
    Rv2=PAS__I_MOD(Rv2,100);
    ((C *)F_t)[9]=(C)(Rv2/10+48);
    ((C *)F_t)[10]=(C)(PAS__I_MOD(Rv2,10)+48);
    Rv3=12;
    for( Rf0=F_sz-11;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv3-1]=32;
      Rv3++;
    }
  }
  else {
    Rv4=1;
    for( Rf0=F_sz;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv4-1]=32;
      Rv4++;
    }
  }
}


/* Procedure/Function : " time_cht "  */
void PAS__TIME_CHT(V F_t, SL F_sz){
  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;

  /* Code of procedure/function */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Rv0=PAS__curtim.sl[0];
  Rv1=PAS__curtim.sl[1];
  Rv2=PAS__curtim.sl[2];
  if (F_sz>=8) {
    ((C *)F_t)[0]=(C)(Rv2/10+48);
    ((C *)F_t)[1]=(C)(PAS__I_MOD(Rv2,10)+48);
    ((C *)F_t)[2]=58;
    ((C *)F_t)[3]=(C)(Rv1/10+48);
    ((C *)F_t)[4]=(C)(PAS__I_MOD(Rv1,10)+48);
    ((C *)F_t)[5]=58;
    ((C *)F_t)[6]=(C)(Rv0/10+48);
    ((C *)F_t)[7]=(C)(PAS__I_MOD(Rv0,10)+48);
    Rv3=9;
    for( Rf0=F_sz-8;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv3-1]=32;
      Rv3++;
    }
  }
  else {
    Rv4=1;
    for( Rf0=F_sz;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv4-1]=32;
      Rv4++;
    }
  }
}
