/*  P A S - P. WOLFERS SOFTWARE: V3.1-B4 OF 30-SEP-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Declaration of external variables. */
extern V PAS__curr_iptr;




/* Procedure/Function : " read_long_val "  */
void PAS__QUD_IO_read_long_val(V F_lv, SL F_fld, UB F_base, UB F_bs, UB F_bu){
  /* Local variable stored in C variable */
  UB Rv0;
  SL Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  C Rv6;

  /* Code of procedure/function */
  Rv0=0;
  Rv1=0;
  Rv2=0;
  Rv3=0;
  Rv4=0;
  Rv5=0;
  while (1){
    if (PAS__UFB(PAS__curr_iptr)) PAS__GET(PAS__curr_iptr);
    if (PAS__CURR_EOF()||Rv0>0&&PAS__CURR_EOLN())  break;
    Rv6=((C *)((V *)PAS__curr_iptr)[0])[0];
    if (Rv6>=97&&Rv6<=102) Rv6=(C)((SL)Rv6-32);
    if (Rv0<2) switch (Rv6) {
      case 95:if (!F_bs) Rv0=2;
      break;
      case 43:
      case 45:if (Rv0==0) {
        if (Rv6==45) {
          if (F_bu) {
            Rv0=2;
            Rv1=1;
          }
          else {
            Rv0=1;
            Rv2=1;
          }
        }
      }
      else Rv0=2;
      break;
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
      case 65:
      case 66:
      case 67:
      case 68:
      case 69:
      case 70:if (Rv6>57) Rv3=((SL)Rv6-65)+10;
      else Rv3=(SL)Rv6-48;
      if (Rv3>=F_base) Rv0=2;
      else {
        Rv0=1;
        if (Rv3>0||Rv4>0) {
          if (F_bu) ((UQ *)F_lv)[0]=((UQ *)F_lv)[0]*F_base+Rv3;
          else((SQ *)F_lv)[0]=((SQ *)F_lv)[0]*F_base+Rv3;
          Rv4=Rv4+1;
        }
      }
      break;
      default:if (Rv0>0) Rv0=2;
      break;
    }
    Rv5=Rv5+1;
    if (Rv5==F_fld||F_fld==0&&Rv0==2)  break;
  }
  if (F_bu) {
    if (Rv2) ((SQ *)F_lv)[0]= -((SQ *)F_lv)[0];
  }
}


/* Procedure/Function : " read_long_unsigned "  */
void PAS__READ_LUNS(UQ *F_lv, SL F_fld, UB F_base, UB F_bs){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );


  /* Code of procedure/function */
  PAS__QUD_IO_read_long_val(Ra.s,F_fld, F_base, F_bs,1);
  (*F_lv)=Ra.uq[0];
}


/* Procedure/Function : " read_long_integer "  */
void PAS__READ_LINT(SQ *F_lv, SL F_fld, UB F_base, UB F_bs){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );


  /* Code of procedure/function */
  PAS__QUD_IO_read_long_val(Ra.s,F_fld, F_base, F_bs,0);
  (*F_lv)=Ra.sq[0];
}


/* Procedure/Function : " write_long_val "  */
void PAS__QUD_IO_write_long_val(V F_lv, SL F_fld, UB F_base, UB F_frq, C F_sch, 
UB F_bu){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  UB Rv0;
  C Rv1;
  SL Rv2;
  SL Rv3;
  SQ Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+65,F_lv,8);
  Rv0=0;
  Rv1=32;
  if (Ra.sq[8]==0) {
    Ra.c[0]=48;
    Rv2=1;
    Rv0=0;
  }
  else {
    if (!F_bu) {
      if (Ra.sq[8]<0) Rv0=1;
    }
    if (F_base<2||F_base>16) F_base=10;
    if (F_bu) {
      Rv3=abs(Ra.uq[8]%F_base);
      Rv4=Ra.uq[8]/F_base;
    }
    else {
      Rv3=abs(Ra.uq[8]%F_base);
      Rv4=Ra.sq[8]/F_base;
    }
    if (Rv3>9) Ra.c[0]=(C)((Rv3+65)-10);
    else Ra.c[0]=(C)(Rv3+48);
    Rv2=1;
    Rv5=1;
    while (Rv4!=0){
      if (Rv5==F_frq) {
        Ra.c[Rv2-1]=F_sch;
        Rv2=Rv2+1;
        Rv5=0;
      }
      Rv2=Rv2+1;
      Rv5=Rv5+1;
      Rv3=abs(Rv4%F_base);
      if (Rv3>9) Ra.c[Rv2-1]=(C)((Rv3+65)-10);
      else Ra.c[Rv2-1]=(C)(Rv3+48);
      Rv4=Rv4/F_base;
    }
  }
  if (F_fld==0) F_fld=Rv2+(SL)Rv0;
  else {
    if (F_fld<0) {
      Rv1=48;
      F_fld= -F_fld;
    }
  }
  Rv6=F_fld-Rv2;
  if (Rv0) Rv6=Rv6-1;
  if (Rv6>=0) {
    if (Rv0&&Rv1==48) PAS__WRITE_CHAR(45);
    for( Rf0=Rv6;Rf0>0;Rf0-- )
    PAS__WRITE_CHAR(Rv1);
    if (Rv0&&Rv1==32) PAS__WRITE_CHAR(45);
    while (Rv2>0){
      PAS__WRITE_CHAR(Ra.c[Rv2-1]);
      Rv2=Rv2-1;
    }
  }
  else for( Rf0=F_fld;Rf0>0;Rf0-- )
  PAS__WRITE_CHAR(42);
}


/* Procedure/Function : " write_long_unsigned "  */
void PAS__WRITE_LUNS(UQ F_lv, SL F_f, UB F_ba, UB F_fr, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );


  /* Code of procedure/function */
  Ra.uq[0]=F_lv;
  PAS__QUD_IO_write_long_val(Ra.s,F_f, F_ba, F_fr, F_ch,1);
}


/* Procedure/Function : " write_long_integer "  */
void PAS__WRITE_LINT(SQ F_lv, SL F_f, UB F_ba, UB F_fr, C F_ch){
  /* Define the automatic variable space. */
  Blk( Ra, 8 );


  /* Code of procedure/function */
  Ra.sq[0]=F_lv;
  PAS__QUD_IO_write_long_val(Ra.s,F_f, F_ba, F_fr, F_ch,0);
}
