/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc
#define _FILE_CLEAR(fdst) fdst = NULL

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B4/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 584 ) = {
 10,  10, 115, 114,  99,  95, 114,  95, 105, 110, 105, 116,  62,  62,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  52,  47,  99, 112,  97,
115,  95,  98,  95,  95, 115, 114,  99,  46, 112,  97, 115,  12,  12, 115, 114,
 99,  95,  97, 108, 108, 111,  99,  97, 116, 101,   8,   8, 115, 114,  99,  95,
102, 114, 101, 101,   9,   9, 115, 114,  99,  95,  99, 108, 111, 115, 101,   8,
  8, 115, 114,  99,  95, 111, 112, 101, 110,  17,  17, 115, 114,  99,  95,  97,
 99, 116, 105, 118, 101,  95, 115, 111, 117, 114,  99, 101,  14,  14, 115, 114,
 99,  95, 109,  97,  99, 114, 111,  95, 111, 112, 101, 110,  10,  10, 115, 114,
 99,  95, 114, 101, 116, 117, 114, 110,  17,  17, 115, 114,  99,  95, 111, 117,
116,  95, 116, 101, 120, 116,  95, 108, 105, 110, 101,  11,  11, 115, 114,  99,
 95, 111, 117, 116, 108, 105, 110, 101,  17,  17, 115, 114,  99,  95, 111, 117,
116, 101, 114, 114,  95,  98,  97, 110, 110, 101, 114,  40,  40,  32,  37,  42,
 43,  42,  43,  42,  32, 101, 114, 114, 111, 114,  40, 115,  41,  32, 119,  97,
115,  32, 100, 101, 116, 101,  99, 116, 101, 100,  32,  97, 116,  32, 108, 105,
110, 101,  32,  35,  32,  16,  16,  32, 105, 110,  32, 116, 104, 101,  32, 102,
105, 108, 101,  32,  58,  32,  34,  13,  13, 115, 114,  99,  95, 111, 117, 116,
 95, 101, 114, 114, 111, 114,  34,  34,  32,  60,  60,  60,  32,  42,  42,  42,
 32,  77,  97, 120, 105, 109, 117, 109,  32, 110, 117, 109,  98, 101, 114,  32,
111, 102,  32, 101, 114, 114, 111, 114,  32,  40,  52,  52,  41,  32, 105, 115,
 32, 114, 101,  97,  99, 104, 101, 100,  46,  32,  83,  82,  67,  95,  76, 105,
 98, 114,  97, 114, 121,  32, 115, 116, 111, 112,  32, 111, 117, 114,  32,  83,
111, 102, 116, 119,  97, 114, 101,  46,  32,  42,  42,  42,  32,  62,  62,  62,
 17,  17, 115, 114,  99,  95, 111, 117, 116,  95, 109,  97,  99,  95, 101, 114,
114, 111, 114,   9,   9, 115, 114,  99,  95, 101, 114, 114, 111, 114,  17,  17,
115, 114,  99,  95, 103, 101, 116,  95, 105, 110, 112, 117, 116, 108, 105, 110,
101,  14,  14, 115, 114,  99,  95, 112, 117, 116,  95, 112, 114, 111, 109, 112,
116,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95, 108, 105, 110, 101,  15,
 15, 115, 114,  99,  95, 101, 110, 100,  95, 111, 102,  95, 108, 105, 110, 101,
  4,   4,  83,  95,  71,  76,  12,  12, 115, 114,  99,  95, 103, 101, 116,  95,
 99, 104,  97, 114,  12,  12, 115, 107, 105, 112,  95,  99, 111, 109, 109, 101,
110, 116,  10,  10, 115, 114,  99,  95, 105, 110,  99, 104,  97, 114,  13,  13,
115, 114,  99,  95, 110, 101, 120, 116,  95,  99, 104,  97, 114,  15,  15, 115,
114,  99,  95, 115, 101,  97, 114,  99, 104,  95,  99, 104,  97, 114,  13,  13,
115, 114,  99,  95, 115, 101, 116,  95, 102, 108,  97, 103, 115,   8,   8, 115,
114,  99,  95, 105, 110, 105, 116,   0
};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern V PAS__f_input;
extern SL PAS__iostatus;
extern UL V_lst_spc_mode;
extern V PAS__f_output;
extern V V_lst_current;
extern Blk(V_error_cnt, 24 );
extern UB V_error_result;

/* Declaration of global variables. */
V V_def_prompt = NULL;
SL V_src_maxerror;
SL V_src_lstinsnb;
V V_src_control;
V V_src_cont_base;
V V_src_hde;
V V_src_listing;

/* Function/procedure prototypes. */
void P_str_copy_lim(V *F_trg, V F_src, SL F_lim);
void P_lst_newline();
void P_lst_eoln();
void P_lst_put_string(V F_str);
void P_err_getmsg(V F_erren);
void P_err_display(V *F_f, SL F_ie, V F_erren);
void P_vsr_nextstring();


/* Procedure/Function : " src_r_init "  */
void BASIC_SRC_src_r_init(V F_p, UB F_macflg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=121; /* line # 121 */
  if (F_p!=NULL) {
    Ra.sl[6]=122; /* line # 122 */
    Rv0=F_p;
    Ra.sl[6]=125; /* line # 125 */
    ((V *)Rv0)[0]=V_src_hde;
    Ra.sl[6]=126; /* line # 126 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=127; /* line # 127 */
    ((SL *)Rv0)[4]=0;
    Ra.sl[6]=128; /* line # 128 */
    ((SL *)Rv0)[5]=0;
    Ra.sl[6]=129; /* line # 129 */
    ((SL *)Rv0)[6]=0;
    Ra.sl[6]=130; /* line # 130 */
    ((SL *)Rv0)[7]=0;
    Ra.sl[6]=131; /* line # 131 */
    ((SL *)Rv0)[8]=0;
    Ra.sl[6]=132; /* line # 132 */
    ((SL *)Rv0)[9]=0;
    Ra.sl[6]=133; /* line # 133 */
    ((SL *)Rv0)[10]=0;
    Ra.sl[6]=134; /* line # 134 */
    ((SL *)Rv0)[11]=1;
    Ra.sl[6]=135; /* line # 135 */
    ((SL *)Rv0)[12]=255;
    Ra.sl[6]=136; /* line # 136 */
    ((C *)Rv0)[52]=0;
    Ra.sl[6]=137; /* line # 137 */
    ((C *)Rv0)[53]=1;
    Ra.sl[6]=138; /* line # 138 */
    if (F_macflg) ((C *)Rv0)[54]=77;
    else {
      Ra.sl[6]=139; /* line # 139 */
      ((C *)Rv0)[54]=32;
    }
    Ra.sl[6]=140; /* line # 140 */
    ((C *)Rv0)[55]=32;
    Ra.sl[6]=141; /* line # 141 */
    Rv1=1;
    for( Rf0=8;Rf0>0;Rf0-- ) {
      Ra.sl[6]=142; /* line # 142 */
      ((V *)Rv0)[Rv1*3+6]=NULL;
      Rv1++;
    }
    Ra.sl[6]=144; /* line # 144 */
    if (!F_macflg) {
      Ra.sl[6]=146; /* line # 146 */
      if (32768&((UL *)Rv0)[62]) {
        Ra.sl[6]=148; /* line # 148 */
        ((V *)Rv0)[32]=NULL;
        Ra.sl[6]=149; /* line # 149 */
        ((V *)Rv0)[33]=NULL;
        Ra.sl[6]=150; /* line # 150 */
        ((V *)Rv0)[34]=NULL;
        Ra.sl[6]=151; /* line # 151 */
        ((V *)Rv0)[35]=NULL;
      }
      Ra.sl[6]=153; /* line # 153 */
      ((UL *)Rv0)[62]=2120;
      Ra.sl[6]=154; /* line # 154 */
      ((UB *)Rv0)[252]=0;
      Ra.sl[6]=155; /* line # 155 */
      if (((V *)Rv0)[32]==NULL) {
        ((V *)Rv0)[32]=PAS__NEW(257);
        ((UB *)((V *)Rv0)[32])[0]=255;
      }
      Ra.sl[6]=156; /* line # 156 */
      ((UB *)((V *)Rv0)[32])[1]=0;
      Ra.sl[6]=157; /* line # 157 */
      if (((V *)Rv0)[33]!=NULL) {
        Ra.sl[6]=158; /* line # 158 */
        PAS__DISPOSE(((V *)Rv0)+33);
        ((V *)Rv0)[33]=NULL;
      }
    }
    else {
      Ra.sl[6]=162; /* line # 162 */
      if (!(32768&((UL *)Rv0)[62])) {
        Ra.sl[6]=164; /* line # 164 */
        if (((V *)Rv0)[32]!=NULL) PAS__DISPOSE(((V *)Rv0)+32);
        Ra.sl[6]=165; /* line # 165 */
        if (((V *)Rv0)[33]!=NULL) PAS__DISPOSE(((V *)Rv0)+33);
      }
      Ra.sl[6]=167; /* line # 167 */
      ((UL *)Rv0)[62]=34880;
      Ra.sl[6]=168; /* line # 168 */
      ((UB *)Rv0)[252]=4;
      Ra.sl[6]=169; /* line # 169 */
      ((V *)Rv0)[32]=NULL;
      Ra.sl[6]=170; /* line # 170 */
      ((V *)Rv0)[33]=NULL;
      Ra.sl[6]=171; /* line # 171 */
      ((V *)Rv0)[34]=NULL;
      Ra.sl[6]=172; /* line # 172 */
      ((V *)Rv0)[35]=NULL;
    }
  }
  Ra.sl[6]=175; /* line # 175 */
  V_src_hde=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_allocate "  */
V BASIC_SRC_src_allocate(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=187; /* line # 187 */
  Rv0=PAS__NEW(288);
  Ra.sl[6]=188; /* line # 188 */
  Rv1=Rv0;
  Ra.sl[6]=190; /* line # 190 */
  ((UL *)Rv1)[62]=32768;
  Ra.sl[6]=191; /* line # 191 */
  ((V *)Rv1)[32]=NULL;
  Ra.sl[6]=192; /* line # 192 */
  ((V *)Rv1)[33]=NULL;
  Ra.sl[6]=194; /* line # 194 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_free "  */
void P_src_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+90;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=206; /* line # 206 */
  Rv0=NULL;
  Ra.sl[6]=207; /* line # 207 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=209; /* line # 209 */
    Rv1=V_src_hde;
    Ra.sl[6]=210; /* line # 210 */
    while (Rv1!=(*F_p)&&Rv1!=NULL){
      Ra.sl[6]=212; /* line # 212 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[0];
    }
  }
  else {
    Ra.sl[6]=214; /* line # 214 */
    Rv1=NULL;
  }
  Ra.sl[6]=215; /* line # 215 */
  if (Rv1!=NULL) {
    Ra.sl[6]=217; /* line # 217 */
    Rv2=(*F_p);
    Ra.sl[6]=219; /* line # 219 */
    if (!(32768&((UL *)Rv2)[62])) {
      Ra.sl[6]=221; /* line # 221 */
      if (((V *)Rv2)[32]!=NULL) PAS__DISPOSE(((V *)Rv2)+32);
      Ra.sl[6]=222; /* line # 222 */
      if (((V *)Rv2)[33]!=NULL) PAS__DISPOSE(((V *)Rv2)+33);
    }
    Ra.sl[6]=225; /* line # 225 */
    if (Rv0==NULL) V_src_hde=((V *)Rv2)[0];
    else {
      Ra.sl[6]=226; /* line # 226 */
      ((V *)Rv0)[0]=((V *)Rv2)[0];
    }
    Ra.sl[6]=228; /* line # 228 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=229; /* line # 229 */
    (*F_p)=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_close "  */
void P_src_close(V *F_p, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+100;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=242; /* line # 242 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=244; /* line # 244 */
    Rv0=(*F_p);
    Ra.sl[6]=246; /* line # 246 */
    if (16384&((UL *)Rv0)[62]) {
      Ra.sl[6]=248; /* line # 248 */
      if (32768&((UL *)Rv0)[62]) {
        Ra.sl[6]=250; /* line # 250 */
        ((V *)Rv0)[32]=NULL;
        Ra.sl[6]=251; /* line # 251 */
        ((V *)Rv0)[33]=NULL;
        Ra.sl[6]=252; /* line # 252 */
        ((V *)Rv0)[34]=NULL;
        Ra.sl[6]=253; /* line # 253 */
        ((V *)Rv0)[35]=NULL;
      }
      else {
        Ra.sl[6]=257; /* line # 257 */
        if (128&((UL *)Rv0)[62]) Rv1=2048;
        else {
          Ra.sl[6]=258; /* line # 258 */
          Rv1=0;
        }
        Ra.sl[6]=259; /* line # 259 */
        PAS__CLOSE(((V *)Rv0)+35,Rv1);
        Ra.sl[6]=260; /* line # 260 */
        if (8&((UL *)Rv0)[62]) PAS__CLOSE(((V *)Rv0)+34,0);
        Ra.sl[6]=261; /* line # 261 */
        if (((V *)Rv0)[33]!=NULL) {
          Ra.sl[6]=263; /* line # 263 */
          PAS__DISPOSE(((V *)Rv0)+33);
          ((V *)Rv0)[33]=NULL;
        }
      }
      Ra.sl[6]=266; /* line # 266 */
      if (((V *)Rv0)[1]!=NULL&&V_src_control==(*F_p)) {
        Ra.sl[6]=268; /* line # 268 */
        V_src_control=((V *)Rv0)[1];
      }
      Ra.sl[6]=270; /* line # 270 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~16384;
    }
    Ra.sl[6]=273; /* line # 273 */
    if (F_bfree) P_src_free(F_p);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_open "  */
void P_src_open(V *F_p, V F_fspc, UB F_bdelete, SL *F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+111;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=292; /* line # 292 */
  (*F_ierr)=0;
  Ra.sl[6]=293; /* line # 293 */
  if ((*F_p)==NULL) {
    Ra.sl[6]=295; /* line # 295 */
    Rv0=0;
    Ra.sl[6]=296; /* line # 296 */
    (*F_p)=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[6]=300; /* line # 300 */
    Rv0=1;
    Ra.sl[6]=301; /* line # 301 */
    P_src_close(F_p,0);
  }
  Ra.sl[6]=303; /* line # 303 */
  BASIC_SRC_src_r_init((*F_p),0);
  Ra.sl[6]=305; /* line # 305 */
  Rv1=(*F_p);
  Ra.sl[6]=307; /* line # 307 */
  if (((UB *)F_fspc)[1]==0) {
    Ra.sl[6]=309; /* line # 309 */
    _FILE_DUPLICATE(((V *)Rv1)[35],PAS__f_input);
    Ra.sl[6]=310; /* line # 310 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16;
    Ra.sl[6]=311; /* line # 311 */
    PAS__iostatus=0;
  }
  else {
    Ra.sl[6]=313; /* line # 313 */
    PAS__OPEN(((V *)Rv1)+35,0, F_fspc,4097|V_lst_spc_mode,0,-1);
  }
  Ra.sl[6]=315; /* line # 315 */
  if (PAS__iostatus==0) {
    Ra.sl[6]=318; /* line # 318 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~8;
    Ra.sl[6]=319; /* line # 319 */
    if (PAS__TTY_FILE(((V *)Rv1)[35])) {
      Ra.sl[6]=321; /* line # 321 */
      if (((UB *)F_fspc)[1]==0) {
        Ra.sl[6]=323; /* line # 323 */
        _FILE_DUPLICATE(((V *)Rv1)[34],PAS__f_output);
        Ra.sl[6]=324; /* line # 324 */
        PAS__iostatus=0;
      }
      else {
        Ra.sl[6]=326; /* line # 326 */
        PAS__OPEN(((V *)Rv1)+34,0, F_fspc,4098,0,-1);
      }
      Ra.sl[6]=327; /* line # 327 */
      if (PAS__iostatus!=0) {
        Ra.sl[6]=329; /* line # 329 */
        (*F_ierr)=PAS__iostatus;
        PAS__CLOSE(((V *)Rv1)+35,0);
      }
      else {
        Ra.sl[6]=333; /* line # 333 */
        ((V *)Rv1)[33]=PAS__NEW(65);
        ((UB *)((V *)Rv1)[33])[0]=63;
        Ra.sl[6]=334; /* line # 334 */
        PAS__STR_TO_STR(((V *)Rv1)[33],V_def_prompt);
        Ra.sl[6]=335; /* line # 335 */
        ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16392;
      }
    }
    else {
      Ra.sl[6]=340; /* line # 340 */
      if (F_bdelete) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|128;
      Ra.sl[6]=341; /* line # 341 */
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
    }
  }
  else {
    Ra.sl[6]=344; /* line # 344 */
    (*F_ierr)=PAS__iostatus;
  }
  Ra.sl[6]=345; /* line # 345 */
  if ((*F_ierr)!=0) {
    Ra.sl[6]=346; /* line # 346 */
    if (Rv0) BASIC_SRC_src_r_init((*F_p),0);
    else {
      Ra.sl[6]=347; /* line # 347 */
      P_src_free(F_p);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_active_source "  */
void P_src_active_source(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=360; /* line # 360 */
  if (F_p!=NULL&&V_src_control!=NULL) {
    Ra.sl[6]=362; /* line # 362 */
    Rv0=V_src_control;
    Ra.sl[6]=367; /* line # 367 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|262144;
    Ra.sl[6]=369; /* line # 369 */
    Rv1=F_p;
    Ra.sl[6]=371; /* line # 371 */
    ((V *)Rv1)[1]=V_src_control;
    Ra.sl[6]=372; /* line # 372 */
    ((SL *)Rv1)[6]=((SL *)V_src_control)[6];
    Ra.sl[6]=373; /* line # 373 */
    ((SL *)Rv1)[7]=((SL *)V_src_control)[7];
    Ra.sl[6]=374; /* line # 374 */
    ((SL *)Rv1)[8]=((SL *)Rv1)[7];
    Ra.sl[6]=375; /* line # 375 */
    ((C *)Rv1)[52]=0;
    Ra.sl[6]=376; /* line # 376 */
    ((C *)Rv1)[53]=((C *)V_src_control)[52];
    Ra.sl[6]=377; /* line # 377 */
    ((UL *)Rv1)[62]=((UL *)Rv1)[62]|65536;
    Ra.sl[6]=379; /* line # 379 */
    V_src_control=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_macro_open "  */
void P_src_macro_open(V *F_p, V F_txt, V F_p0, V F_p1, V F_p2, UB F_fact){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+140;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=405; /* line # 405 */
  if ((*F_p)==NULL) {
    Ra.sl[6]=407; /* line # 407 */
    Rv0=0;
    Ra.sl[6]=408; /* line # 408 */
    (*F_p)=BASIC_SRC_src_allocate();
  }
  else {
    Ra.sl[6]=412; /* line # 412 */
    Rv0=1;
    Ra.sl[6]=413; /* line # 413 */
    P_src_close(F_p,0);
  }
  Ra.sl[6]=415; /* line # 415 */
  BASIC_SRC_src_r_init((*F_p),1);
  Ra.sl[6]=416; /* line # 416 */
  Rv1=(*F_p);
  Ra.sl[6]=418; /* line # 418 */
  if (F_txt!=NULL) {
    Ra.sl[6]=420; /* line # 420 */
    ((V *)Rv1)[32]=F_txt;
    Ra.sl[6]=421; /* line # 421 */
    ((SL *)Rv1)[12]=((UB *)F_txt)[1];
    Ra.sl[6]=422; /* line # 422 */
    if (((SL *)Rv1)[12]>0) {
      Ra.sl[6]=424; /* line # 424 */
      ((C *)Rv1)[53]=0;
      Ra.sl[6]=425; /* line # 425 */
      ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~2048;
    }
  }
  Ra.sl[6]=428; /* line # 428 */
  ((V *)Rv1)[33]=F_p0;
  Ra.sl[6]=429; /* line # 429 */
  ((V *)Rv1)[34]=F_p1;
  Ra.sl[6]=430; /* line # 430 */
  ((V *)Rv1)[35]=F_p2;
  Ra.sl[6]=431; /* line # 431 */
  ((UL *)Rv1)[62]=((UL *)Rv1)[62]|16384;
  Ra.sl[6]=432; /* line # 432 */
  if (F_fact&&V_src_control!=NULL) {
    Ra.sl[6]=433; /* line # 433 */
    P_src_active_source((*F_p));
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_return "  */
C P_src_return(UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+156;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=449; /* line # 449 */
  Rv0=V_src_control;
  Ra.sl[6]=450; /* line # 450 */
  if (Rv0!=NULL) Rv1=((V *)Rv0)[1];
  Ra.sl[6]=451; /* line # 451 */
  if (Rv0!=NULL&&Rv1!=NULL) {
    Ra.sl[6]=459; /* line # 459 */
    Rv2=Rv0;
    Ra.sl[6]=460; /* line # 460 */
    ((UL *)Rv2)[62]=((UL *)Rv2)[62]&~65536;
    Ra.sl[6]=461; /* line # 461 */
    Rv3=Rv1;
    Ra.sl[6]=463; /* line # 463 */
    ((C *)Rv3)[52]=((C *)Rv0)[52];
    Ra.sl[6]=464; /* line # 464 */
    V_src_control=Rv1;
    Ra.sl[6]=465; /* line # 465 */
    P_src_close(&Rv0, F_bfree);
    Ra.sl[6]=466; /* line # 466 */
    Ret=((C *)Rv3)[53];
  }
  else {
    Ra.sl[6]=469; /* line # 469 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_out_text_line "  */
void BASIC_SRC_src_out_text_line(V *F_f, V F_st, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+168;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=481; /* line # 481 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_FCHAR(32,20,-1,1,32);
  Rv0=20;
  Ra.sl[6]=482; /* line # 482 */
  Rv1=V_lst_current;
  Ra.sl[6]=484; /* line # 484 */
  if (F_bterm) Rv2=80;
  else {
    Ra.sl[6]=485; /* line # 485 */
    Rv2=((SL *)Rv1)[16];
  }
  Ra.sl[6]=486; /* line # 486 */
  Rv3=1;
  for( Rf0=((UB *)F_st)[1];Rf0>0;Rf0-- ) {
    Ra.sl[6]=488; /* line # 488 */
    Rv0=Rv0+1;
    Ra.sl[6]=489; /* line # 489 */
    if (Rv0>Rv2) {
      Ra.sl[6]=491; /* line # 491 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_EOLN();
      Ra.sl[6]=492; /* line # 492 */
      if (!F_bterm) ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Ra.sl[6]=493; /* line # 493 */
      Rv0=20;
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_FCHAR(32,20,-1,1,32);
    }
    Ra.sl[6]=495; /* line # 495 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(((C *)F_st)[Rv3+1]);
    Rv3++;
  }
  Ra.sl[6]=497; /* line # 497 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outline "  */
void BASIC_SRC_src_outline(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+187;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=509; /* line # 509 */
  Rv0=V_src_control;
  Ra.sl[6]=511; /* line # 511 */
  if (V_src_lstinsnb!=((SL *)Rv0)[6]) {
    Ra.sl[6]=513; /* line # 513 */
    V_src_lstinsnb=((SL *)Rv0)[6];
    Ra.sl[6]=514; /* line # 514 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[6],5,0);
  }
  else {
    Ra.sl[6]=516; /* line # 516 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_FCHAR(32,6,-1,1,32);
  }
  Ra.sl[6]=518; /* line # 518 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_CHAR(32);
  PAS__WRITE_CHAR(((C *)Rv0)[54]);
  PAS__WRITE_CHAR(((C *)Rv0)[55]);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(((SL *)Rv0)[7],3,0);
  PAS__WRITE_CHAR(32);
  Ra.sl[6]=519; /* line # 519 */
  Rv1=((V *)Rv0)[32];
  Rv2=V_lst_current;
  Ra.sl[6]=521; /* line # 521 */
  if (F_bterm) Rv3=80;
  else {
    Ra.sl[6]=522; /* line # 522 */
    Rv3=((SL *)Rv2)[16];
  }
  Ra.sl[6]=523; /* line # 523 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_INT(((SL *)Rv0)[10],4,0);
  PAS__WRITE_FCHAR(32,2,-1,1,32);
  Ra.sl[6]=524; /* line # 524 */
  if (((UB *)Rv1)[1]>Rv3-20) {
    Ra.sl[6]=526; /* line # 526 */
    Rv4=20;
    Ra.sl[6]=527; /* line # 527 */
    Rv5=1;
    for( Rf0=((UB *)Rv1)[1];Rf0>0;Rf0-- ) {
      Ra.sl[6]=529; /* line # 529 */
      Rv4=Rv4+1;
      Ra.sl[6]=530; /* line # 530 */
      if (Rv4>Rv3) {
        Ra.sl[6]=532; /* line # 532 */
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_EOLN();
        Ra.sl[6]=533; /* line # 533 */
        if (!F_bterm) ((SL *)Rv2)[12]=((SL *)Rv2)[12]+1;
        Ra.sl[6]=534; /* line # 534 */
        Rv4=20;
        PAS__SELECT_OUT((*F_f));
        PAS__WRITE_FCHAR(32,20,-1,1,32);
      }
      Ra.sl[6]=536; /* line # 536 */
      PAS__SELECT_OUT((*F_f));
      PAS__WRITE_CHAR(((C *)Rv1)[Rv5+1]);
      Rv5++;
    }
    Ra.sl[6]=538; /* line # 538 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[6]=540; /* line # 540 */
    PAS__SELECT_OUT((*F_f));
    PAS__WRITE_STR(((V *)Rv0)[32],-1,-1,32);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_outerr_banner "  */
void BASIC_SRC_src_outerr_banner(V *F_f, UB F_bterm){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+200;
  Ra.v[35]=Rd.s+12;
  Ra.sl[72]=559; /* line # 559 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[72]=561; /* line # 561 */
  Ra.ub[1]=Ra.ub[0];
  Ra.sl[72]=562; /* line # 562 */
  Rv2=1;
  for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
    Ra.c[Rv2+1]=95;
    Rv2++;
  }
  Ra.sl[72]=565; /* line # 565 */
  Rv3=1;
  for( Rf0=((SL *)Rv0)[11]-1;Rf0>0;Rf0-- ) {
    Ra.c[Rv3+1]=92;
    Rv3++;
  }
  Ra.sl[72]=566; /* line # 566 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[72]=567; /* line # 567 */
    Rv5=(((S *)Rv0)+Rv4*24+32);
    Ra.sl[72]=568; /* line # 568 */
    Ra.c[((SL *)Rv5)[0]+1]=(C)(48+Rv4);
    Rv4++;
  }
  Ra.sl[72]=569; /* line # 569 */
  if (((UB *)((V *)Rv0)[32])[1]>((SL *)Rv0)[12]) {
    Ra.sl[72]=572; /* line # 572 */
    Rv6=((SL *)Rv0)[12]+1;
    for( Rf0=(((UB *)((V *)Rv0)[32])[1]+1)-(((SL *)Rv0)[12]+1);Rf0>0;Rf0-- ) {
      Ra.c[Rv6+1]=92;
      Rv6++;
    }
    Ra.sl[72]=573; /* line # 573 */
    Ra.ub[1]=((UB *)((V *)Rv0)[32])[1];
  }
  else {
    Ra.sl[72]=575; /* line # 575 */
    Ra.ub[1]=((SL *)Rv0)[((SL *)Rv0)[9]*6+8];
  }
  Ra.sl[72]=577; /* line # 577 */
  BASIC_SRC_src_out_text_line(F_f,Ra.s,F_bterm);
  Ra.sl[72]=578; /* line # 578 */
  if (F_bterm) {
    Ra.sl[72]=580; /* line # 580 */
    P_lst_newline();
    Ra.sl[72]=581; /* line # 581 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
  }
  Ra.sl[72]=583; /* line # 583 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+219,-1,-1,32);
  PAS__WRITE_INT(((SL *)Rv0)[10],5,0);
  PAS__WRITE_EOLN();
  Ra.sl[72]=584; /* line # 584 */
  PAS__SELECT_OUT((*F_f));
  PAS__WRITE_STR(Rd.s+261,-1,-1,32);
  PAS__WRITE_STR(PAS__FILE_SPC(Ra.s+292,((V *)Rv0)[35]),-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " src_out_error "  */
void BASIC_SRC_src_out_error(UB F_bmac){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+279;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=592; /* line # 592 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=594; /* line # 594 */
  if ((1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7])&&!(64&((UB *)Rv1)[72])
  ) {
    Ra.sl[6]=597; /* line # 597 */
    ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
    Ra.sl[6]=599; /* line # 599 */
    BASIC_SRC_src_outerr_banner(((V *)Rv1)+10,0);
    Ra.sl[6]=600; /* line # 600 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=602; /* line # 602 */
      P_lst_newline();
      Ra.sl[6]=603; /* line # 603 */
      ((SL *)Rv1)[12]=((SL *)Rv1)[12]+1;
      Ra.sl[6]=604; /* line # 604 */
      P_err_display(((V *)Rv1)+10,Rv2,(((S *)Rv0)+Rv2*24+32));
      Rv2++;
    }
    Ra.sl[6]=606; /* line # 606 */
    P_lst_newline();
    PAS__SELECT_OUT(((V *)Rv1)[10]);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=608; /* line # 608 */
  if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) {
    Ra.sl[6]=610; /* line # 610 */
    if (!F_bmac) BASIC_SRC_src_outline(&PAS__f_output,1);
    Ra.sl[6]=611; /* line # 611 */
    BASIC_SRC_src_outerr_banner(&PAS__f_output,1);
    Ra.sl[6]=612; /* line # 612 */
    Rv3=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=613; /* line # 613 */
      P_err_display(&PAS__f_output, Rv3,(((S *)Rv0)+Rv3*24+32));
      Rv3++;
    }
    Ra.sl[6]=614; /* line # 614 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  Ra.sl[6]=617; /* line # 617 */
  Rv4=1;
  for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
    Ra.sl[6]=618; /* line # 618 */
    PAS__DISPOSE((((V *)Rv0)+Rv4*3+6));
    Rv4++;
  }
  Ra.sl[6]=620; /* line # 620 */
  if (Rs.sl[0]>V_src_maxerror) {
    Ra.sl[6]=621; /* line # 621 */
    Ra.sl[6]=623; /* line # 623 */
    P_lst_newline();
    Ra.sl[6]=624; /* line # 624 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+294,-1,-1,32);
    PAS__WRITE_INT(V_src_maxerror,0,0);
    PAS__WRITE_STR(Rd.s+330,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[6]=625; /* line # 625 */
    PAS__EXIT(4);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_out_mac_error "  */
void P_src_out_mac_error(void F_out_mac_line(V *F_f, UB F_btt)){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+384;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=634; /* line # 634 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=635; /* line # 635 */
  if (((SL *)Rv0)[9]>0) {
    Ra.sl[6]=637; /* line # 637 */
    if (64&((UL *)Rv0)[62]||64&((UB *)Rv1)[72]) (*F_out_mac_line)(&PAS__f_output,1);
    Ra.sl[6]=638; /* line # 638 */
    BASIC_SRC_src_out_error(1);
    Ra.sl[6]=639; /* line # 639 */
    ((SL *)Rv0)[9]=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error "  */
void P_src_error(V F_modulesy, SL F_number, UB F_severity){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  register V Rv3;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_modulesy,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+403;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=655; /* line # 655 */
  Rv0=V_src_control;
  Ra.sl[6]=658; /* line # 658 */
  if (((SL *)Rv0)[4]<((SL *)Rv0)[11]) ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  else {
    Ra.sl[6]=659; /* line # 659 */
    if (((SL *)Rv0)[4]>((SL *)Rv0)[12]) ((SL *)Rv0)[4]=((SL *)Rv0)[12];
  }
  Ra.sl[6]=661; /* line # 661 */
  if (((SL *)Rv0)[9]>=8) {
    Ra.sl[6]=663; /* line # 663 */
    ((SL *)Rv0)[9]=8;
    Rv1=0;
  }
  else {
    Ra.sl[6]=667; /* line # 667 */
    Rv1=1;
    Ra.sl[6]=668; /* line # 668 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[9];Rf0>0;Rf0-- ) {
      Ra.sl[6]=669; /* line # 669 */
      if (((SL *)Rv0)[4]==((SL *)Rv0)[Rv2*6+8]) Rv1=0;
      Rv2++;
    }
    Ra.sl[6]=670; /* line # 670 */
    if (Rv1) ((SL *)Rv0)[9]=((SL *)Rv0)[9]+1;
  }
  Ra.sl[6]=673; /* line # 673 */
  if (Rv1) {
    Ra.sl[6]=674; /* line # 674 */
    Rv3=(((S *)Rv0)+((SL *)Rv0)[9]*24+32);
    Ra.sl[6]=676; /* line # 676 */
    ((SL *)Rv3)[0]=((SL *)Rv0)[4];
    Ra.sl[6]=677; /* line # 677 */
    if (((SL *)Rv3)[0]<1) ((SL *)Rv3)[0]=1;
    Ra.sl[6]=678; /* line # 678 */
    ((SL *)Rv3)[1]=F_number;
    Ra.sl[6]=679; /* line # 679 */
    ((UB *)Rv3)[8]=F_severity;
    Ra.sl[6]=680; /* line # 680 */
    memcpy(Rv3+9,Ra.s+28,4);
    Ra.sl[6]=681; /* line # 681 */
    P_err_getmsg((((S *)Rv0)+((SL *)Rv0)[9]*24+32));
  }
  else {
    Ra.sl[6]=685; /* line # 685 */
    if (((UB *)Rv0)[((SL *)Rv0)[9]*24+40]<F_severity) {
      Ra.sl[6]=686; /* line # 686 */
      ((UB *)Rv0)[((SL *)Rv0)[9]*24+40]=F_severity;
    }
  }
  Ra.sl[6]=687; /* line # 687 */
  if (!(32768&((UL *)Rv0)[62]||PAS__TTY_FILE(((V *)Rv0)[35]))) {
    Ra.sl[6]=688; /* line # 688 */
    if (PAS__EOF(((V *)Rv0)[35])) BASIC_SRC_src_out_error(0);
  }
  Ra.sl[6]=690; /* line # 690 */
  V_error_cnt.sl[F_severity]=V_error_cnt.sl[F_severity]+1;
  Ra.sl[6]=691; /* line # 691 */
  if (F_severity>1) Rs.sl[0]=Rs.sl[0]+1;
  Ra.sl[6]=692; /* line # 692 */
  if (V_error_result<F_severity) V_error_result=F_severity;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_inputline "  */
void P_src_get_inputline(V *F_f, V *F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+414;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=714; /* line # 714 */
  if (((UB *)((V *)V_lst_current)[1])[1]>0) P_lst_eoln();
  Ra.sl[6]=716; /* line # 716 */
  if ((*F_pstr)==NULL) {
    (*F_pstr)=PAS__NEW(257);
    ((UB *)(*F_pstr))[0]=255;
  }
  Ra.sl[6]=717; /* line # 717 */
  Rv0=(*F_pstr);
  Rv1=V_src_control;
  Ra.sl[6]=719; /* line # 719 */
  ((UB *)Rv0)[1]=0;
  Ra.sl[6]=720; /* line # 720 */
  while (!PAS__EOLN((*F_f))&&!PAS__EOF((*F_f))){
    Ra.sl[6]=722; /* line # 722 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_CHAR(&Rv2);
    Ra.sl[6]=723; /* line # 723 */
    if (Rv2==9) while (1){
      Ra.sl[6]=725; /* line # 725 */
      if (((UB *)Rv0)[1]<255) ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
      Ra.sl[6]=726; /* line # 726 */
      ((C *)Rv0)[((UB *)Rv0)[1]+1]=32;
      if (((UB *)Rv0)[1]>=255||(((UB *)Rv0)[1]&7)==0)  break;
    }
    else {
      Ra.sl[6]=729; /* line # 729 */
      if (Rv2>=32) {
        Ra.sl[6]=730; /* line # 730 */
        if (((UB *)Rv0)[1]<255) {
          Ra.sl[6]=732; /* line # 732 */
          ((UB *)Rv0)[1]=((UB *)Rv0)[1]+1;
          ((C *)Rv0)[((UB *)Rv0)[1]+1]=Rv2;
        }
        else {
          Ra.sl[6]=735; /* line # 735 */
          ((UL *)Rv1)[62]=((UL *)Rv1)[62]|256;
        }
      }
    }
  }
  Ra.sl[6]=737; /* line # 737 */
  if (PAS__EOF((*F_f))) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|8192;
  else {
    Ra.sl[6]=738; /* line # 738 */
    PAS__SELECT_INP((*F_f));
    PAS__READ_EOLN();
  }
  Ra.sl[6]=739; /* line # 739 */
  ((SL *)Rv1)[10]=((SL *)Rv1)[10]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_put_prompt "  */
void P_src_put_prompt(V F_pstr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+433;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=749; /* line # 749 */
  if (F_pstr!=NULL) {
    Ra.sl[6]=750; /* line # 750 */
    Rv0=V_src_control;
    Ra.sl[6]=751; /* line # 751 */
    if (8&((UL *)Rv0)[62]) {
      Ra.sl[6]=754; /* line # 754 */
      PAS__SELECT_OUT(((V *)Rv0)[34]);
      PAS__WRITE_STR(F_pstr,-1,-1,32);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_line "  */
void BASIC_SRC_src_get_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+449;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=765; /* line # 765 */
  Rv0=V_src_control;
  Ra.sl[6]=767; /* line # 767 */
  ((SL *)Rv0)[5]=((SL *)Rv0)[11]-1;
  Ra.sl[6]=768; /* line # 768 */
  ((SL *)Rv0)[9]=0;
  Ra.sl[6]=770; /* line # 770 */
  if (32768&((UL *)Rv0)[62]) {
    Ra.sl[6]=772; /* line # 772 */
    P_vsr_nextstring();
    Ra.sl[6]=773; /* line # 773 */
    ((SL *)Rv0)[10]=((SL *)Rv0)[10]+1;
  }
  else {
    Ra.sl[6]=778; /* line # 778 */
    if (8&((UL *)Rv0)[62]) P_src_put_prompt(((V *)Rv0)[33]);
    Ra.sl[6]=780; /* line # 780 */
    P_src_get_inputline(((V *)Rv0)+35,((V *)Rv0)+32);
    Ra.sl[6]=781; /* line # 781 */
    if (32&((UL *)Rv0)[62]) {
      Ra.sl[6]=783; /* line # 783 */
      if (8&((UL *)Rv0)[62]) P_lst_put_string(((V *)Rv0)[33]);
      Ra.sl[6]=784; /* line # 784 */
      P_lst_put_string(((V *)Rv0)[32]);
      Ra.sl[6]=785; /* line # 785 */
      P_lst_eoln();
    }
  }
  Ra.sl[6]=788; /* line # 788 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[11];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_end_of_line "  */
void P_src_end_of_line(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+463;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=799; /* line # 799 */
  Rv0=V_src_control;
  Rv1=V_lst_current;
  Ra.sl[6]=801; /* line # 801 */
  if (256&((UL *)Rv0)[62]) {
    Ra.sl[6]=804; /* line # 804 */
    ((SL *)Rv0)[4]=((SL *)Rv0)[12]-1;
    P_src_error(Rd.s+482,1,2);
    Ra.sl[6]=805; /* line # 805 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~256;
  }
  Ra.sl[6]=807; /* line # 807 */
  if (1&((UL *)Rv0)[62]&&((SL *)Rv0)[8]>=((SL *)Rv0)[7]) {
    Ra.sl[6]=808; /* line # 808 */
    if (!(64&((UB *)Rv1)[72])) {
      Ra.sl[6]=811; /* line # 811 */
      P_lst_newline();
      Ra.sl[6]=812; /* line # 812 */
      BASIC_SRC_src_outline(((V *)Rv1)+10,0);
    }
  }
  Ra.sl[6]=814; /* line # 814 */
  if (((SL *)Rv0)[9]>0) BASIC_SRC_src_out_error(0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_get_char "  */
C BASIC_SRC_src_get_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+486;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=825; /* line # 825 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=827; /* line # 827 */
  while (!(8192&((UL *)Rv0)[62])&&2048&((UL *)Rv0)[62]){
    Ra.sl[6]=832; /* line # 832 */
    if (((SL *)Rv0)[10]>0&&!(1048576&((UL *)Rv0)[62])) {
      Ra.sl[6]=833; /* line # 833 */
      P_src_end_of_line();
    }
    Ra.sl[6]=835; /* line # 835 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~1050624;
    Ra.sl[6]=836; /* line # 836 */
    BASIC_SRC_src_get_line();
    Ra.sl[6]=838; /* line # 838 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|512;
    Ra.sl[6]=839; /* line # 839 */
    if (((C *)Rv0)[54]!=67) {
      Ra.sl[6]=840; /* line # 840 */
      Rs.c[4]=((C *)Rv0)[54];
      ((C *)Rv0)[54]=67;
    }
  }
  Ra.sl[6]=842; /* line # 842 */
  if (!(8192&((UL *)Rv0)[62])) {
    Ra.sl[6]=843; /* line # 843 */
    if (((SL *)Rv0)[5]>=((SL *)Rv0)[12]||((SL *)Rv0)[5]>=((UB *)Rv1)[1]) {
      Ra.sl[6]=845; /* line # 845 */
      if (1048576&((UL *)Rv0)[62]&&((SL *)Rv0)[10]>0) {
        Ra.sl[6]=846; /* line # 846 */
        P_src_end_of_line();
      }
      Ra.sl[6]=847; /* line # 847 */
      if ((525312&((UL *)Rv0)[62])!=0) {
        Ra.sl[6]=848; /* line # 848 */
        Rv2=1;
      }
      else Rv2=32;
      Ra.sl[6]=849; /* line # 849 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|2048;
    }
    else {
      Ra.sl[6]=853; /* line # 853 */
      ((SL *)Rv0)[5]=((SL *)Rv0)[5]+1;
      Ra.sl[6]=854; /* line # 854 */
      Rv2=((C *)Rv1)[((SL *)Rv0)[5]+1];
    }
  }
  else {
    Ra.sl[6]=861; /* line # 861 */
    if (65536&((UL *)Rv0)[62]&&((V *)Rv0)[1]!=NULL) {
      Ra.sl[6]=865; /* line # 865 */
      Rv2=P_src_return(!(131072&((UL *)Rv0)[62]));
    }
    else {
      Ra.sl[6]=873; /* line # 873 */
      Rv2=4;
      Ra.sl[6]=874; /* line # 874 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]|4096;
    }
  }
  Ra.sl[6]=878; /* line # 878 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " skip_comment "  */
C BASIC_SRC_skip_comment(C F_stp, UB F_nlmd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  UB Rv2;
  C Rv3;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+500;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=890; /* line # 890 */
  Rv0=0;
  Ra.sl[6]=891; /* line # 891 */
  Rv1=V_src_control;
  Ra.sl[6]=894; /* line # 894 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]|1024;
  Ra.sl[6]=895; /* line # 895 */
  Rv2=((UB *)Rv1)[252];
  Ra.sl[6]=896; /* line # 896 */
  ((UB *)Rv1)[252]=4;
  while (1){
    while (1){
      Ra.sl[6]=899; /* line # 899 */
      Rv3=BASIC_SRC_src_get_char();
      if ((Rv3==4||Rv3==F_stp)||F_nlmd&&Rv3==1)  break;
    }
    Ra.sl[6]=901; /* line # 901 */
    switch (Rv2) {
      case 0:Ra.sl[6]=904; /* line # 904 */
      Rv0=F_stp==125&&Rv3==F_stp||Rv3==4;
      Ra.sl[6]=905; /* line # 905 */
      if (F_stp==42&&Rv3!=4) {
        Ra.sl[6]=907; /* line # 907 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) {
          Ra.sl[6]=909; /* line # 909 */
          Rv0=((C *)((V *)Rv1)[32])[(((SL *)Rv1)[5]+1)+1]==41;
          Ra.sl[6]=910; /* line # 910 */
          if (Rv0) Rv3=BASIC_SRC_src_get_char();
        }
      }
      break;
      case 1:Ra.sl[6]=916; /* line # 916 */
      if (Rv3!=4) {
        Ra.sl[6]=918; /* line # 918 */
        if (((SL *)Rv1)[5]<((UB *)((V *)Rv1)[32])[1]) Rv3=BASIC_SRC_src_get_char();
        Ra.sl[6]=919; /* line # 919 */
        Rv0=Rv3==47;
      }
      else {
        Ra.sl[6]=920; /* line # 920 */
        Rv0=1;
      }
      break;
      case 2:
      case 3:
      case 4:Ra.sl[6]=925; /* line # 925 */
      Rv0=1;
      break;
    }
    if (Rv0)  break;
  }
  Ra.sl[6]=930; /* line # 930 */
  if (F_nlmd) ((UL *)Rv1)[62]=((UL *)Rv1)[62]&~1024;
  Ra.sl[6]=931; /* line # 931 */
  ((UB *)Rv1)[252]=Rv2;
  Ra.sl[6]=933; /* line # 933 */
  if (Rv3!=4) {
    Ra.sl[6]=934; /* line # 934 */
    if (Rv3==1&&!(524288&((UL *)Rv1)[62])||Rv3>1) {
      Ra.sl[6]=935; /* line # 935 */
      Rv3=32;
    }
  }
  Ra.sl[6]=938; /* line # 938 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_inchar "  */
C P_src_inchar(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  C Rv2;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+514;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=951; /* line # 951 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=953; /* line # 953 */
  Rv2=BASIC_SRC_src_get_char();
  Ra.sl[6]=954; /* line # 954 */
  switch (((UB *)Rv0)[252]) {
    case 0:Ra.sl[6]=957; /* line # 957 */
    if (Rv2==123) Rv2=BASIC_SRC_skip_comment(125,0);
    else {
      Ra.sl[6]=958; /* line # 958 */
      if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
        Ra.sl[6]=959; /* line # 959 */
        if (Rv2==40&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
          Ra.sl[6]=961; /* line # 961 */
          Rv2=BASIC_SRC_src_get_char();
          Ra.sl[6]=962; /* line # 962 */
          Rv2=BASIC_SRC_skip_comment(42,0);
        }
      }
    }
    break;
    case 1:Ra.sl[6]=966; /* line # 966 */
    if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=967; /* line # 967 */
      if (Rv2==47&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==42) {
        Ra.sl[6]=969; /* line # 969 */
        Rv2=BASIC_SRC_src_get_char();
        Ra.sl[6]=970; /* line # 970 */
        Rv2=BASIC_SRC_skip_comment(42,0);
      }
    }
    break;
    case 3:Ra.sl[6]=974; /* line # 974 */
    if (Rv2==59) Rv2=BASIC_SRC_skip_comment(59,1);
    break;
    case 2:Ra.sl[6]=977; /* line # 977 */
    if (((SL *)Rv0)[5]<((UB *)Rv1)[1]) {
      Ra.sl[6]=978; /* line # 978 */
      if (Rv2==45&&((C *)Rv1)[(((SL *)Rv0)[5]+1)+1]==45) {
        Ra.sl[6]=979; /* line # 979 */
        Rv2=BASIC_SRC_skip_comment(1,1);
      }
    }
    break;
    case 4:Ra.sl[6]=984; /* line # 984 */
    break;
  }
  Ra.sl[6]=986; /* line # 986 */
  if (512&((UL *)Rv0)[62]) {
    Ra.sl[6]=987; /* line # 987 */
    if (Rv2!=32&&Rv2>1) {
      Ra.sl[6]=989; /* line # 989 */
      ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~512;
      Ra.sl[6]=990; /* line # 990 */
      if (((C *)Rv0)[54]==67) ((C *)Rv0)[54]=Rs.c[4];
    }
  }
  Ra.sl[6]=993; /* line # 993 */
  ((C *)Rv0)[52]=((C *)Rv0)[53];
  Ra.sl[6]=994; /* line # 994 */
  ((C *)Rv0)[53]=Rv2;
  Ra.sl[6]=995; /* line # 995 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_next_char "  */
C P_src_next_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+526;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1009; /* line # 1009 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=1010; /* line # 1010 */
  if (((SL *)Rv0)[5]>=((UB *)Rv1)[1]||((SL *)Rv0)[5]>=((SL *)Rv0)[12]) {
    Ra.sl[6]=1011; /* line # 1011 */
    Ret=32;
  }
  else {
    Ra.sl[6]=1013; /* line # 1013 */
    Ret=((C *)Rv1)[(((SL *)Rv0)[5]+1)+1];
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_search_char "  */
C P_src_search_char(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  UB Rv3;
  C Rv4;
  register C Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+541;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1028; /* line # 1028 */
  Rv0=V_src_control;
  Rv1=((V *)Rv0)[32];
  Ra.sl[6]=1030; /* line # 1030 */
  Rv2=((SL *)Rv0)[5];
  Ra.sl[6]=1031; /* line # 1031 */
  Rv3=1;
  Ra.sl[6]=1032; /* line # 1032 */
  while (Rv3){
    Ra.sl[6]=1033; /* line # 1033 */
    if (Rv2<=((UB *)Rv1)[1]&&Rv2<=((SL *)Rv0)[12]) {
      Ra.sl[6]=1035; /* line # 1035 */
      Rv4=((C *)Rv1)[Rv2+1];
      Ra.sl[6]=1036; /* line # 1036 */
      if (Rv4==32) Rv2=Rv2+1;
      else {
        Ra.sl[6]=1037; /* line # 1037 */
        Rv3=0;
      }
    }
    else {
      Ra.sl[6]=1041; /* line # 1041 */
      Rv3=0;
      Ra.sl[6]=1042; /* line # 1042 */
      Rv4=32;
    }
  }
  Ra.sl[6]=1045; /* line # 1045 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " src_set_flags "  */
void P_src_set_flags(UL F_flg, UB F_fclr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+558;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1058; /* line # 1058 */
  Rv0=V_src_control;
  Ra.sl[6]=1059; /* line # 1059 */
  if (F_fclr) {
    Ra.sl[6]=1060; /* line # 1060 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]&~F_flg;
  }
  else {
    Ra.sl[6]=1062; /* line # 1062 */
    ((UL *)Rv0)[62]=((UL *)Rv0)[62]|F_flg;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_init "  */
void P_src_init(V F_def_prt, V F_def_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Rv0=-1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+573;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=1079; /* line # 1079 */
  P_str_copy_lim(&V_def_prompt, F_def_prt,64);
  Ra.sl[6]=1081; /* line # 1081 */
  Rv1=0;
  for( Rf0=5;Rf0>0;Rf0-- ) {
    V_error_cnt.sl[Rv1]=0;
    Rv1++;
  }
  Ra.sl[6]=1082; /* line # 1082 */
  V_error_result=0;
  Ra.sl[6]=1084; /* line # 1084 */
  V_src_control=NULL;
  Ra.sl[6]=1085; /* line # 1085 */
  if (((UB *)F_def_src)[1]>0) {
    Ra.sl[6]=1086; /* line # 1086 */
    P_src_open(&V_src_control, F_def_src,0, &Rv0);
  }
  Ra.sl[6]=1087; /* line # 1087 */
  if (Rv0==0) {
    Ra.sl[6]=1088; /* line # 1088 */
    Rv2=V_src_control;
    Ra.sl[6]=1090; /* line # 1090 */
    ((SL *)Rv2)[7]=1;
    Ra.sl[6]=1091; /* line # 1091 */
    ((SL *)Rv2)[8]=1;
  }
  else {
    Ra.sl[6]=1093; /* line # 1093 */
    V_src_control=NULL;
  }
  Ra.sl[6]=1094; /* line # 1094 */
  V_src_hde=V_src_control;
  Ra.sl[6]=1095; /* line # 1095 */
  V_src_cont_base=V_src_control;
  Ra.sl[6]=1096; /* line # 1096 */
  V_src_maxerror=31;
  PAS__curr_cntx=Ra.v[0];
}
