{
*************************************************************************
*                                                                       *
*                                                                       *
*                   *  C P A S  *  S Y S T E M  *                       *
*                                                                       *
*                                                                       *
*          * * *   S t a n d a r d   L i b r a r y   * * *              *
*                                                                       *
*                                                                       *
*            - - -  Source Read  Manager Library  - - -                 *
*                                                                       *
*           - - -   version 2.0-A  -- 15/08/2016   - - -                *
*                                                                       *
*                       For C-Pascal  3.1-B3                            *
*                                                                       *
*         by :                                                          *
*                                                                       *
*             P. Wolfers                                                *
*                 c.n.r.s.                                              *
*                 Institut Louis Neel                                   *
*                 B.P.  166 X   38042  Grenoble Cedex                   *
*                                             FRANCE.                   *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

(*
[inherit ('LIB:BASIC_ENV_STR',                  { String manager def. }
          'LIB:BASIC_ENV_TXF',                  { Text file manager def. }
          'LIB:BASIC_ENV_LST',                  { List file manager def. }
          'LIB:BASIC_ENV_SRC')]                 { SRC file manager def. }
*)
module BASIC_SRC_V2;                            { Use input and output }




%include 'pasenv:cpas_b__v2src_env';


{ ****************************  Begin of PASCAL System Code Section  **************************** }

%pragma code_option (c_interface,               { To authorize the use of "standard" keyword }
    c_code '#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc',
    c_code '#define _FILE_CLEAR(fdst) fdst = NULL'
  );


  procedure DUPLICATE_FILE( f1, f2: $wild_file ); standard '_FILE_DUPLICATE';
  procedure CLEAR_FILE( f: $wild_file ); standard '_FILE_CLEAR';

%pragma code_option noc_interface;              { To disable usage of "standard" keyword }

{ *****************************  End of PASCAL System Code Section  ***************************** }




const
  mac_exp_incr         =          1024; { Macro expanssion text allocation increment }


type

  mac_exp_text(size: integer) = record  { * Define the macro expanssion text buffer record * }
    length,                             { Current buffer used length }
    smbidx:                    integer; { Current macro symbol index in the buffer }
    mtext:      array[1..size] of char  { The macro expanssion text buffer }
  end;

  mac_exp_ptr          = ^mac_exp_text; { Define the macro expanssion text pointer }




[global]
var





var
  mac_exp:      mac_exp_ptr    :=  nil; { Macro expanssion text pointer }

  macrocb_ptr:  src_callback   :=  nil; { Default is no callback for macro }





procedure BACK_TRACING( var f: text ); external 'PAS__BACK_TRACING';




{********************************************************}
{***********    Source Managment Routines    ************}
{********************************************************}



procedure SRC_MEXPEND( ch: char );
var
  p: mac_exp_ptr;

begin
  if mac_exp = nil then
  begin
    NEW( mac_exp, mac_exp_incr );
    with mac_exp^ do
    begin  length := 0; smbidx := 0  end
  end
  else
    if mac_exp^.size <= mac_exp^.length then
    begin
      with mac_exp^ do
      begin
        NEW( p, size+mac_exp_incr );
        p^.length := length;
        p^.smbidx := smbidx;
        for ii := 1 to length do  p^.mtext[ii] := mtext[ii];
      end;
      DISPOSE( mac_exp );
      mac_exp := p
    end;

  with mac_exp^ do
  begin  length := length + 1; mtext[length] := ch  end
end SRC_MEXPEND;



procedure SRC_R_INIT( p: src_ptr; macflg: boolean := false );
begin { SRC_R_INIT }
  if p <> nil then
  with p^ do
  begin
    { *** src_next is never initialized here *** }
    src_next            :=     src_hde;         { Link in the used source file list };
    src_previous        :=         nil;         { No previous source until showed otherwise }
    src_wchpt           :=           0;         { Clear the Word pointer in src_cmdline }
    src_chidx           :=           0;         { Character pointer to begin of line }
    src_insnb           :=           0;         { Clear instruction count }
    src_level           :=           0;         { Clear source level }
    src_lstmxlev        :=           0;         { Clear Source listing level }
    src_errnb           :=           0;         { Clear number of error in the current line }
    src_linenbr         :=           0;         { Clear line number in this file }
    src_frspos          :=           1;         { First valid column to use set to first column }
    src_lstpos          :=         255;         { Last valid column to use at maximum }
    src_prvchar         := src_ch_null;         { Set the Previous and current source character ... }
    src_curchar         := src_ch_eoln;         { ... to be our NULL and EOLN mark characters. }
    if macflg then src_fchcd    := 'M'          { Set the flag code characters to be "M3 for macro source file }
              else src_fchcd    := ' ';         { Set the flag code characters to be spaces for real source file }
    src_schcd           :=         ' ';
    for i := 1 to src_maxerrline do             { Set message table to empty, Source status flag set, ... }
      src_coltb[i].err_msg  :=     nil;         { ... Input used, and error echo. }

    if not macflg then
    begin                                       { We want a real source file ... }
      if src_macro in src_flags then            { ... but we have an old macro source file record. }
      begin
        src_cmdline     :=         nil;         { We do not destroy the old macro text }
        src_mobject     :=         nil;         { We must destroy the macro object link => nil -> src_prompt }
        src_usrcb       :=         nil          { Clear of the call back user routine pointer. }
      end;
      src_flags := [src_bterminal, src_echerr, src_eoln];
      src_commentty     :=      src_pascomment; { Default to pascal comment mode }
      if src_cmdline = nil then NEW( src_cmdline, 255 );
      src_cmdline^.length       :=           0; { Set the source input line to empty }
      if src_prompt <> nil then
      begin  DISPOSE( src_prompt ); src_prompt := nil  end
    end
    else
    begin                                       { We want a macro source file ... }
      if not (src_macro in src_flags) then      { ... but we have an old real source file record }
      begin
        if src_cmdline <> nil then DISPOSE( src_cmdline );
        if src_prompt <> nil then DISPOSE( src_prompt )
      end;
      src_flags := [src_macro, src_echerr, src_eoln];
      src_commentty     :=       src_nocomment;
      src_cmdline       :=                 nil; { Initialization without Macro text }
      src_mobject       :=                 nil; { Initialize to no attached macro object and ... }
      src_usrcb         :=                 nil  { Clear macro call back routine pointer }
    end
  end;
  src_hde := p                                  { Link this Source file in the source list }
end SRC_R_INIT;



function SRC_ALLOCATE: src_ptr;
{ Procedure to allocate a source file,
  give a file context address at return time }
var
  ps: src_ptr;

begin { SRC_ALLOCATE }
  NEW( ps );
  with ps^ do
  begin
    src_flags          :=  [src_macro];         { Must be initialized before call SRC_R_INIT }
    src_cmdline        :=          nil;         { No string allocation and SRC_R_INIT will perform ... }
    src_prompt         :=          nil;         { ... the Pascal files clear for Real source file. }
  end;
  SRC_ALLOCATE := ps
end SRC_ALLOCATE;



[global]
procedure SRC_FREE( var p: src_ptr );
{ Procedure to free an unused source input file }
var
  p1, p2: src_ptr;

begin { SRC_FREE }
  p2 := nil; 
  if p <> nil then
  begin
    p1 := src_hde;                              { Init for used file search }
    while (p1 <> p) and (p1 <> nil) do
    begin                                       { Localize the file to de-allocate }
      p2 := p1; p1 := p1^.src_next
    end
  end else p1 := nil;
  if p1 <> nil then                             { Found file }
  begin
    with p^ do
    begin
      if not (src_macro in src_flags) then
      begin
        if src_cmdline <> nil then DISPOSE( src_cmdline );
        if src_prompt  <> nil then DISPOSE( src_prompt )
      end;
      { Put out from the file context from used list }
      if p2 = nil then src_hde := src_next
                  else p2^.src_next := src_next
    end;
    DISPOSE( p );
    p := nil
  end
end SRC_FREE;



[global]
procedure SRC_CLOSE( var p: src_ptr; bfree: boolean );
{ Close a source file, if bfree then the source variable is free }
var
  disp: flags_file;

begin { SRC_CLOSE }
  if p <> nil then
  begin
    with p^ do
    begin
      if src_fopen in src_flags then
      begin                             { Close text file and delete if required }
        if src_macro in src_flags then
        begin                           { Performe a formal close of the Macro source file }
          src_cmdline := nil;
          src_mobject := nil;
          src_usrcb   := nil
        end
        else
        begin
          if src_delete in src_flags then disp := [del_file]
                                     else disp := [];
          CLOSE( src_file, disp )        { The free is always };
          if src_bterminal in src_flags then CLOSE( src_promptf );
          if src_prompt <> nil then
          begin
            DISPOSE( src_prompt ); src_prompt := nil
          end
        end;
        if (src_previous <> nil) and (src_control = p) then
        begin
          src_control := src_previous
        end;
        src_flags := src_flags - [src_fopen]
      end
    end;
    if bfree then SRC_FREE( p )
  end
end SRC_CLOSE;



[global]
procedure SRC_OPEN_FILE( var    p:             src_ptr;
                         in_var fspc:           string;
                                bdelete:       boolean;
                         var    ierr:          integer
                       );
{ Open a source file }
{   p is the pointer of source context, fspc is the file specification }
{   ierr is the return error code }
{ SRC_OPEN allocate the source context if p = nil 
  and close a previously opened file }
{ if bdelete is true the file is set for delete on close time }
var
  ballocated: boolean;

begin { SRC_OPEN }
  ierr := 0;
  if p = nil then
  begin
    ballocated := false;
    p := SRC_ALLOCATE
  end
  else                                          { Already allocated }
  begin
    ballocated := true;
    SRC_CLOSE( p, false )                       { Can be opened }
  end;
  SRC_R_INIT( p, false );                       { Initialize the record for a real source file }
  
  with p^ do
  begin
    if fspc.length = 0 then
    begin
      DUPLICATE_FILE( src_file, input );        { We use the standard input descriptor }
      src_flags := src_flags + [src_stdin];
      iostatus := 0                             { Force the Success Open Status }
    end
    else OPEN( src_file, fspc, [read_file,error_file] + lst_spc_mode ); { Open the specified file }

    if iostatus = 0 then                        { Success }
    begin
      { Set terminal mode if open on terminal }
      src_flags := src_flags - [src_bterminal];
      if TTY_FILE( src_file ) then
      begin
        if fspc.length = 0 then
        begin
          DUPLICATE_FILE( src_promptf, output );{ We use the standard input descriptor }
          iostatus := 0                         { Force the Success Open Status }
        end
        else OPEN( src_promptf, fspc, [write_file,error_file] );
        if iostatus <> 0 then
        begin
          ierr := iostatus; CLOSE( src_file )
        end
        else
        begin { The prompt file is opened, we set the prompt stri,ng default }
          NEW( src_prompt, 63 );
          src_prompt^ := def_prompt^;           { We set the default prompt }
          src_flags := src_flags + [src_bterminal,src_fopen]
        end
      end
      else { Success on not a terminal file, => it is a disk file }
      begin
        if bdelete then src_flags := src_flags + [src_delete];
        src_flags := src_flags + [src_fopen]     { Mark the source file as opened }
      end
    end
    else ierr := iostatus;
    if ierr <> 0 then
      if ballocated then SRC_R_INIT( p )
                    else SRC_FREE( p )
  end
end SRC_OPEN_FILE;



[global]
procedure SRC_ACTIVE_SOURCE( p: src_ptr );
{ Procedure to link and activate the source file (or macro) p^
  as the current source file with an automatic return to The
  previous one when an src_eof character is read by SRC_INSCHAR.
}
begin
  if (p <> nil) and (src_control <> nil) then
  begin
    with src_control^ do
    begin
(*
WRITELN( 'prev = "', src_prvchar, '", cur = "', src_curchar, '".' );
*)
      src_flags   := src_flags + [src_autopch]  { Repeat the previous read character on return }
    end;
    with p^ do
    begin
      src_previous :=              src_control; { Link to current source file (becomes parent source file) }
      src_insnb    :=   src_control^.src_insnb; { Start from the current instruction count }
      src_level    :=   src_control^.src_level; { Set as the same listing level ... }
      src_lstmxlev :=                src_level; { ... and the same maximum listing level. }
      src_prvchar  :=              src_ch_null; { We have no previous character before to read its first one. }
      src_curchar  := src_control^.src_prvchar; { Get the last read char from the previous source context. }
      src_flags    := src_flags + [src_autoret] { Set marker to reread at the return of macroSet the auto return mode for the end of Macro code }
     end;
    src_control   :=                         p  { Now the new control source file is our macro source. }
(*
; with p^ do
WRITELN( ' Macro Source is "', p^.src_cmdline^, '" ', src_frspos:0, ' ', src_lstpos:0 )
*)
  end
end SRC_ACTIVE_SOURCE;



[global]
procedure SRC_SET_MACRO_CB( function CALL_BACK( mp: $wild_pointer; flg: boolean ): str_ptr );
begin
  macrocb_ptr := src_callback[CALL_BACK]
end SRC_SET_MACRO_CB;

[global]
procedure SRC_DEL_MACRO_CB;
begin
  macrocb_ptr := nil
end SRC_DEL_MACRO_CB;



[global]
procedure SRC_MACRO_OPEN( var p:   src_ptr;                    { Pointer to the source file record }
                               txt: str_ptr;                    { First text pointer }
                               p0, p1, p2: $wild_pointer := nil;{ Three other user pointers }
                               fact: boolean := true            { To activate as sub-source of previous source }
                        );
{ Open a macro source file :
  p is the pointer of the newsource context, txt is the initial source
  line, p1 and p2 are some user free pointer that can be used to specify
  some dat to the user procedure VSR_NEXTSTRING. These pointer are
  respectively stored in the record fields src_mptr_1 and src_mptr_2.
}
var
  ballocated: boolean;

begin
  if p = nil then
  begin
    ballocated := false;
    p := SRC_ALLOCATE
  end
  else                                          { Already allocated }
  begin
    ballocated := true;
    SRC_CLOSE( p, false )                       { Can be opened }
  end;
  SRC_R_INIT( p, true );                        { Initialize the record for a macro source file }
  with p^ do
  begin
    if txt <> nil then
    begin
      src_cmdline := txt;                       { Set the text line and ... }
      src_lstpos  := txt^.length;               { ... adapt the last legal position to the string length. }
      if src_lstpos > 0 then                    { When a first line is provided, ... }
      begin
        src_curchar := src_ch_null;             { Set this character to be ignored }
        src_flags := src_flags - [src_eoln]     { when the first line is provided, we must clear EOLN }
      end
    end;
    src_mobject :=                  p0;         { Set the macro object address }
    src_usrcb   :=         macrocb_ptr;         { Set the first and list macro list (if used) }
    src_flags := src_flags + [src_fopen];       { Set the macro source file as opened. }
    if fact and src_control <> nil then         { When the auto-link to context is required ... }
      SRC_ACTIVE_SOURCE( p )                    { ... we link and activate it. }
  end
end SRC_MACRO_OPEN;



[global]
function SRC_RETURN( bfree: boolean ): char;
{ This routine must be called to return from Macro source,
  to the parent source file. 
}
var
  p, q:      src_ptr;

begin
(* WRITELN( ' M Return.' ); *)
  p := src_control;
  if p <> nil then q := p^.src_previous;
  if (p <> nil) and (q <> nil) then
  begin
(*
with q^ do
begin
  WRITELN( ' Parent : prv = "', src_prvchar, '", cur = "', src_curchar, '", lvl = ', src_level:2, ', EOF = ', src_eof in src_flags );
end;
*)
    with p^ do
      src_flags := src_flags - [src_autoret];
    with q^ do
    begin { Update the parent source file }
      src_prvchar := p^.src_prvchar;    { Put the previous character from the current source. }
      src_control := q;                 { The parent source file is set at the current one. }
      SRC_CLOSE( p, bfree );            { Close the finished source file (optional free). }
      SRC_RETURN  := src_curchar        { Return the current character as returned by SRC_INCHAR ... }
    end
  end
  else SRC_RETURN := src_ch_null
end SRC_RETURN;


procedure test( p: src_ptr );
begin
  SRC_DEL_MACRO_CB;
end;

end BASIC_SRC_V2.
