{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *  ---  Routines to scan a directory with a filter LVL-1 --- *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Institut Louis Neel                                *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{%pragma trace 0; }

(*
module PAS__SCAN_DIR_ENV;

*)

type
  flt_ptr = ^flt_rec;                          { Define a Filtre Profil Entry Pointer }

  set_cha = set of char;                       { Definition of a set of char }

  flt_rec = record                             { * Record Definition for string filtre profile }
              flt_nxt: flt_ptr;                { Link to next filtre element }
              flt_siz,                         { Total size of the entry (in char) }
              flt_pnch,                        { Prefix size }
              flt_snch: byte;                  { Suffix size }
              flt_flt,                         { To flag the floatting position entry }
              flt_first: boolean;              { To flag the first entry }
              case flt_fst: boolean of         { To flag the string_entry/meta_character_entry }
                true:( flt_str: ^string );     { The related string }
                false:( flt_mch: set_cha )     { The set of available meta character }
            end;

  efl_ptr = ^efl_rec;                          { Define a Filtre (entry List) pointer }

  efl_rec = record                             { * Record Definition for Element Filtre Entry List }
              efl_nxt,                         { Pointer to next one }
              efl_prv:   efl_ptr;              { Pointer to previous one }
              efl_flt:   flt_ptr;              { Header of Element Filtre entry list }
              efl_wild:  boolean;              { Wild element if true }
              efl_name:  ^string;              { Related Fix part of name when not wild }
              efl_dir: $wild_pointer           { Pointer to opened directory }
            end;

  efl_blk = record                             { * Record to keep the user scan point }
              efb_head,                        { Head of efl_rec record }
              efb_stk:  efl_ptr                { and current stack pointer }
            end;

  efb_ptr = ^efl_blk;                          { Pointer for user reference }


  file_chtab = array[1..28] of cc__int;        { File charac. table (for GET_FILE_INFO) }


var
  [external 'fspc_File_info']
  fspc_file_info: file_chtab;                  { Current File attribute Characteristic }



function FSPC_CREATE_FILTER( in_var filtre: string ): flt_ptr; external;


procedure FSPC_FREE_FILTER( var hp: flt_ptr ); external;


function FSPC_MATCH( pf: flt_ptr; in_var spc: string ): boolean; external;


function FSPC_OPEN( in_var spc: string; imd: flags_file := [] ): efb_ptr; external;


procedure FSPC_CLOSE( u: efb_ptr ); external;


procedure FSPC_SCAN( u: efb_ptr; var fname: string; var categ: integer ); external;


(*
end.
*)
