/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B3/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 224 ) = {
 10,  10, 114, 100, 102,  95,  99, 114, 101,  97, 116, 101,  64,  64,  47, 104,
111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97,
108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  51,  47, 116, 101, 115,
116,  95,  98,  97,  99, 107,  99,  97, 108, 108,  46, 112,  97, 115,  14,  14,
 32,  79, 112, 101, 110,  32,  69, 114, 114, 111, 114,  32,  35,  32,   8,   8,
114, 100, 102,  95, 114, 101,  97, 100,   6,   6, 111, 117, 114,  95,  99,  98,
  2,   2,  32,  34,  25,  25,  10,  32,  84, 104, 101,  32, 102, 105, 108, 101,
110,  97, 109, 101,  32, 108, 101, 110, 103, 116, 104,  32, 105, 115,  32,   7,
  7,  32,  98, 121, 116, 101, 115,  46,  20,  20,  32,  80,  97, 115,  99,  97,
108,  32,  78, 111, 114, 109,  97, 108,  32,  69, 110, 100,  46,  10,   9,   9,
 98,  97,  99, 107,  95,  99,  97, 108, 108,  20,  20,  32,  71, 105, 118, 101,
 32,  97,  32, 102, 105, 108, 101,  32,  78,  97, 109, 101,  32,  62,  32,  15,
 15,  32,  83, 116, 111, 112,  32, 111, 110,  32, 101, 114, 114, 111, 114,  46
};

/* Define the local static Initialized section. */
static Blk( Ri, 272 ) = {
  0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 64 );

/* Global C type definitions */
typedef  void (*Re0)(V,SL,UB);

/* Declaration of external variables. */
extern SL PAS__iostatus;
extern V PAS__f_output;
extern V PAS__f_input;




/* Procedure/Function : " rdf_create "  */
SL P_rdf_create(V F_fnm, void F_cb_line(V F_obj, SL F_len, UB F_feof), V F_uobj, 
V F_buff){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=73; /* line # 73 */
  Rs.v[0]=(V)(*F_cb_line);
  Rs.v[1]=F_uobj;
  Rs.v[2]=F_buff;
  Ra.sl[6]=81; /* line # 81 */
  PAS__OPEN(Rs.v+3,0, F_fnm,4097,0,-1);
  Rv0=PAS__iostatus;
  Ra.sl[6]=86; /* line # 86 */
  if (Rv0!=0) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+78,-1,-1,32);
    PAS__WRITE_INT(PAS__iostatus,0,0);
    PAS__WRITE_EOLN();
  }
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " rdf_read "  */
void P_rdf_read(){
  /* Define the automatic variable space. */
  Blk( Ra, 296 );

  /* Local variable stored in C variable */
  SL Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[33]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+264;
  Ra.v[34]=Rd.s+94;
  Ra.v[35]=Rd.s+12;
  Ra.sl[72]=99; /* line # 99 */
  while (!PAS__EOF(Rs.v[3])){
    PAS__SELECT_INP(Rs.v[3]);
    PAS__READ_STR(Ra.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[72]=104; /* line # 104 */
    if (Ra.ub[1]>0) {
      Rv0=1;
      for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
        ((C *)Rs.v[2])[Rv0-1]=Ra.c[Rv0+1];
        Rv0++;
      }
      (*(Re0)Rs.v[0])(Rs.v[1],Ra.ub[1],PAS__EOF(Rs.v[3]));
    }
  }
  Ra.sl[72]=110; /* line # 110 */
  if (PAS__EOF(Rs.v[3])) PAS__CLOSE(Rs.v+3,0);
  PAS__curr_cntx=Ra.v[33];
}


/* Procedure/Function : " our_cb "  */
void BACK_CALL_our_cb(V F_purc, SL F_siz, UB F_beof){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+104;
  Ra.v[2]=Rd.s+12;
  Ra.sl[6]=146; /* line # 146 */
  Rv0=F_purc;
  Rv1=Rv0;
  ((UB *)Rv1)[1]=F_siz;
  Ri.sl[0]=Ri.sl[0]+1;
  Ra.sl[6]=151; /* line # 151 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_CHAR(32);
  PAS__WRITE_INT(Ri.sl[0],4,0);
  PAS__WRITE_STR(Rd.s+112,-1,-1,32);
  PAS__WRITE_STR(Rv1,-1,-1,32);
  PAS__WRITE_CHAR(34);
  PAS__WRITE_EOLN();
  Ri.sl[1]=Ri.sl[1]+1;
  if (Ri.sl[1]&1) Ri.sl[1]=Ri.sl[1]+1;
  Ri.sl[1]=Ri.sl[1]+F_siz;
  Ra.sl[6]=156; /* line # 156 */
  if (F_beof) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+116,-1,-1,32);
    PAS__WRITE_INT(Ri.sl[1],0,0);
    PAS__WRITE_STR(Rd.s+143,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+152,-1,-1,32);
    PAS__WRITE_EOLN();
    PAS__EXIT(0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " back_call "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[4]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+32;
  Rs.v[5]=Rd.s+174;
  Rs.v[6]=Rd.s+12;
  Rs.sl[14]=169; /* line # 169 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+185,-1,-1,32);
  PAS__SELECT_INP(PAS__f_input);
  PAS__READ_STR(Ri.s+8,0,0);
  PAS__READ_EOLN();
  Rv0=PAS__NEW(258);
  ((UB *)Rv0)[0]=255;
  Rv1=Rv0;
  ((UB *)Rv1)[1]=0;
  Rs.sl[14]=174; /* line # 174 */
  ((UB *)Rv1)[257]=0;
  Rv2=P_rdf_create(Ri.s+8,BACK_CALL_our_cb,Rv0, Rv0+2);
  if (Rv2!=0) PAS__EXIT(1);
  P_rdf_read();
  Rs.sl[14]=179; /* line # 179 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+207,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__EXIT(1);
  PAS__curr_cntx=Rs.v[4];
  PAS__EXIT( 0 );
}
