{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*               ---   SERVICE ROUTINES PASCAL MODULE   ---              *
*                                                                       *
*           ---  Version  3.1-B3-A  --  30/09/2016 ---                  *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

{************     CPAS  version    *************}


(*
  [inherit(   'lib:cpas_b__src_env',            { Use the Basic Library Definitions }
              'lib:pas_env')]                   { Use the pas env definitions }
*)
module PAS_IDENT;

{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';


{ Basic environment for identifier operation }

const
  debug = false;                                { Output for Debug }

var { * For the repeat context mode, we insert the context expression at the begining }
  prv_ident: ide_ptr;                           { To keep the previous identifier for IDE_NEW }
  id_left: boolean;                             { ... and the last match result }

  id_sflg: boolean := false;                    { To flag the use of id_save }
  id_save: string( 255 );                       { To save sy_string when we creat an internal id. }





       {********************************}
       { Basic Procedures and Functions }
       {********************************}

[global]
function  TAB_NEW( sz: integer ): tab_ptr;
{ To Allocate a table of a specified number of integer }
begin
  TAB_NEW := PAS$$NEW( sz*integer"size )
end TAB_NEW;



[global]
procedure TAB_FREE( var p: tab_ptr );
{ To Free an Allocated Table (Created by TAB_NEW) }
begin
  DISPOSE( p );
  p := nil
end { TAB_FREE };



[global]
procedure STR_COPY( var target, src: str_ptr );
{ To copy a string, allocate it when it is not existing }
var
  l: integer;

begin { STR_COPY }
  if target <> src then
    if src = nil then                           { No source string }
    begin
      if target <> nil then target^.length := 0
    end
    else
    begin                                       { True source string }
      { No existing target, create it }
      if (src^.length > 0) and (target = nil) then NEW( target, src^.length );
      target := src
    end
end STR_COPY;



[global]
procedure SRC_ERROR_S( modulesy:   error_mdnam;
                       number:     integer;
                       severity:   error_sev;
                       var id1, id2: [optional] id_name );
var
  smb: string( 32 );

begin
  if id1"address <> nil then
  with id1 do
  begin
    smb.length := l;
    for i := 1 to l do  smb[i] := s[i];
    ERR_PUT_SYMBOL( smb )
  end;
  if id2"address <> nil then
  with id2 do
  begin
    smb.length := l;
    for i := 1 to l do  smb[i] := s[i];
    ERR_PUT_SYMBOL( smb )
  end;
  SRC_ERROR( modulesy, number, severity )
end SRC_ERROR_S;



[global]
procedure VAL_NEW( var p: val_ptr; ty: typ_ptr );
{ To allocate (or set a new reference of) a Value Record }
begin
  if p = nil then
  begin
    if val_free_list = nil then
      NEW( p )
    else
    begin
      p := val_free_list;
      val_free_list := p^.val_next
    end;
    with p^ do
    begin
      val_next  := nil;
      val_descr :=   0;
      val_nuse  :=   1;
      val_acc   := [var_in,var_hidden];
      val_psect :=  -1;
      val_size  :=   0;
      val_lex   := curr_lex;
      val_typ   :=  ty;
      val_all   := nil;
      if ty = nil then val_kind := form_null
      else
      begin
        val_kind := ty^.typ_form;
        case val_kind of
          form_char, form_lit, form_wlit,
          form_ennum, form_int, form_range:
            val_ival :=   0;
          form_single, form_double:
            val_rval := 0.0;
          form_string:
            val_str  := nil;
          form_conf, form_array, form_record:
            val_lst  := nil;
          form_lset, form_wlset:
            val_sar  := nil;
          form_fentry:
            val_pro  := nil;
          form_nil, form_pointer:
            val_lnk  := nil;
          form_wild:
            val_tab  := nil;
        otherwise
        end
      end
    end
  end
  else
    with p^ do
      val_nuse := val_nuse + 1
end VAL_NEW;



[global]
procedure VAL_FREE( var p: val_ptr );
{ To Free (or Unset a reference of) a Value Record }
begin
  with p^ do
    if (val_nuse = 1) and (val_kind <> form_free) then
    begin
      case val_kind of
        form_string: if val_str <> nil then DISPOSE( val_str );
        form_conf, form_array, form_record:
                     VAL_FREE_TREE( val_lst );
        form_wild:   if val_tab <> nil then TAB_FREE( val_tab );
        form_lset:   if val_sar <> nil then DISPOSE( val_sar );
      otherwise
      end;
      val_nuse  := 0;
      val_kind  := form_free;
      val_next  := val_free_list;
      val_descr := 0;
      val_free_list := p
    end
    else
      if val_nuse > 1 then val_nuse := val_nuse - 1
                      else SRC_ERROR( 'VFRE', 998, e_warning );
  p := nil
end VAL_FREE;



[global]
procedure VAL_FREE_TREE( var p: val_ptr );
{ To Free all a tree of Value record }
var
  p1, p2: val_ptr;

begin
  p1 := p;
  p  := nil;
  while p1 <> nil do
  begin
    p2 := p1;
    if p1^.val_nuse > 1 then p1 := nil          { Do not free the next other val_rec }
                        else p1 := p1^.val_next;
    VAL_FREE( p2 )
  end
end VAL_FREE_TREE;



[global]
procedure VAL_COPY( var v1, v2: val_ptr; bfree: boolean );
{ To copy a constant (Value Record) (v1 -> v2) from a block to
  an other block and (if bfree = true) free the source block }
{ if an old block was allocated to the target, then it is free }
var
  i:  integer;
  pv: val_ptr;

begin
  if v2 <> nil then VAL_FREE( v2 );
  if v1 = nil then v2 := nil
  else
  if bfree and (v1^.val_nuse = 1) then
  begin
    v2 := v1; v1 := nil
  end
  else
  begin
    VAL_NEW( v2, v1^.val_typ );
    v2^ := v1^;
    with v2^ do
    begin
      val_next := nil;
      val_nuse :=   1;
      val_lex  := curr_lex;
      case val_kind of
        form_string:
          if val_str <> nil then
          begin
            val_str := nil;
            STR_COPY( val_str, v1^.val_str )
          end;

        form_conf, form_array, form_record:
          if val_lst <> nil then
            with val_lst^ do
              val_nuse := val_nuse + 1;

        form_wild: { case table }
          begin
            val_tab := TAB_NEW( val_size );
            with v1^.val_tab^ do
              for i := 0 to val_size - 1 do
                val_tab^.lw[i] := lw[i]
          end;

      otherwise
      end
    end;
    if bfree then VAL_FREE( v1 )
  end
end VAL_COPY;



[global]
procedure ALL_NEW( var p: all_ptr; ty: typ_ptr; id: ide_ptr; kind: var_kind );
{ To allocate a Memory Allocation Record }
{ Use the current lex level for the owner link }
begin
  if all_free_list = nil then NEW( p )
  else
  begin
    p := all_free_list; all_free_list := p^.all_nxt
  end;
  with p^, ty^ do
  begin
    all_nxt             :=                 nil;
    all_prd             :=                 nil;
    all_align           :=           typ_align; { Set alignment specification }
    all_typ             :=                  ty; { Form of type form granulometry }
    all_acc             :=                  []; { Init the access flags }
    all_kind            :=                kind; { Set the kind of allocation }
    all_owner           :=         pro_current; { Set the default owner }
    all_psect           :=                  -1; { Set the default program section number to local automatic }
    all_size            :=     ABS( typ_size ); { Set the type related size }
    all_reg             :=                  -1; { Init to no used register }
    all_lex             :=            curr_lex; { Set the default lex to current lex }
    all_lexid           :=                  -1; { Init the lex index to use }
    all_disp            :=                  -1; { Displacement to use }
    all_size_exp        :=                 nil; { Set size expression as unknown }
    all_first_u         :=                 nil; { First use pointer }
    all_last_u          :=                 nil; { Last use pointer }
    all_ide             :=                  id; { Set the link to associated identifier }
    all_cte             :=                 nil; { No initial cte value }

    if (id <> nil) and (typ_size > 0) then
      with id^ do
      begin
        all_lex         :=             ide_lex; { Set the identifier lex }
        all_owner       :=           ide_owner; { Set the identifier ownerlink }
        case ide_class of                       { Set the size of the related cte value }
          cla_fentry:
            begin { * Formal Entry Reference * }
              all_acc   :=        [var_hidden]; { Set the Idden access flag }
              if ide_entry <> nil then          { For any formal entry, set the internal access flag for internal entry }
                if prf_intaccess in ide_entry^.pro_flags then all_acc := all_acc + [var_intaccess]
            end;

          cla_varbl:
            begin { * Variable Reference * }
              all_psect := ide_psect;           { Set the allocation program section number ... }
              all_acc   := ide_vacc             { ... and the variable access flags }
            end;

          cla_konst:
            begin { * Constant Reference * }
              if ide_value <> nil then          { When a value is actually defined, ... }
                with ide_value^ do
                begin
                  all_psect := val_psect;       { ... we get the program section number ... }
                  all_acc   := val_acc + [var_used]     { ... and set the used access flag }
                end
              else                              { Else, ... }
                all_acc := [var_used,var_in,var_hidden];{ ... we set the constant access flags }

              if curr_lex <> all_lex then       { For any not local constant reference ... }
                all_acc := all_acc + [var_intaccess]    { ... we set the internal access flag }
            end;

        otherwise
        end
      end
    else
    begin { No related identifier or dynamic size }
      all_acc   :=   [var_used,var_in,var_out]; { Set default access flags ... }
      if (curr_lex > 1) or not cmp_genenv then  { ... with hidden mode for any local ... }
        all_acc := all_acc + [var_hidden]       { ... and not external module object }
    end
  end
end ALL_NEW;



[global]
procedure ALL_FREE( p: all_ptr );
{ To free a Memory Allocation Record }
begin
  { Remove from the owner list }
  with p^, all_owner^ do
  begin
    if all_prd <> nil then
      all_prd^.all_nxt := all_nxt { Link any next to previous }
    else
      case all_kind of
        var_global, var_static: ;

      otherwise
        { Set next as the first if it is the first }
        if pro_fdyn_all = p then pro_fdyn_all := all_nxt;
        { Set previous as the last if it is the last }
        if pro_ldyn_all = p then pro_ldyn_all := all_prd
      end;
    { Remove any cte variable location }
    if all_cte <> nil then VAL_FREE( all_cte )
  end;
  { Set in the free list }
  if p <> nil then
  begin
    p^.all_nxt := all_free_list; all_free_list := p
  end
end ALL_FREE;



[global]
procedure LGT_NEW( var  p: lgt_ptr;
                       ty: typ_ptr; knd: lgt_kinds; prm: lgt_ptr );
{ To allocate a Logical Tree Record (LGT) }
{ p is the returned LGT pointer, ty is the related type pointer,
  knd is the kind of LGT record and prm is the head list of the LGT
  related parameter(s) }
begin
  p := nil;
  if lgt_free_list = nil then NEW( p )
  else
  begin
    p := lgt_free_list; lgt_free_list := lgt_free_list^.lgt_nxt
  end;
  with p^ do
  begin
    lgt_nxt     := nil;
    lgt_parmlst := prm;
    lgt_disp    :=   0;
    lgt_status  :=  [lgt_in, lgt_out];
    lgt_typ     :=  ty;
    lgt_lide    := nil;
    lgt_kind    := knd;
    case knd of
      lgt_dynall,
      lgt_freerec, lgt_null,
      lgt_index,   lgt_indir,
      lgt_offset,  lgt_refer,
      lgt_address:     { * Nodes for addressing/access to object }
        begin
          if prm <> nil then lgt_status := prm^.lgt_status + [lgt_add]
                        else lgt_status := [lgt_in,lgt_add];
          lgt_typlnk    :=         nil
        end;

      lgt_vartmp:
        begin
          lgt_tmplnk    :=         nil;
          lgt_tmpall    :=         nil
        end;

      lgt_agregat:
          lgt_isz       :=           0;

      lgt_ctlflow:
        begin
          lgt_stm   :=    stm_parallel;
          lgt_lab       :=         nil
        end;

      lgt_codep:
        lgt_pcode       :=   pcod_noop;

      lgt_srvcall:
        lgt_srvfunc     :=         nil;

      lgt_srvret,   lgt_srvref,   lgt_empty,
      lgt_srcinfo,  lgt_specific:
          lgt_icode     :=           0;

      lgt_icall,    lgt_call,     lgt_iproref,
      lgt_eproref,  lgt_proref,   lgt_result:
          lgt_pro       :=         nil;

      lgt_varbl:
        begin
          lgt_ide       :=         nil;
          lgt_alloc     :=         nil
        end;

      lgt_const:
        begin
          lgt_nct       :=         nil;
          lgt_cte       :=         nil;
          lgt_status    :=    [lgt_in];
          if ty <> nil then
            if not ty^.typ_simple then lgt_status := [lgt_in,lgt_add]
        end;

    otherwise
      { lgt_dynall,   lgt_freerec,  lgt_null: }
      lgt_typlnk        :=         nil
    end;
  end
end LGT_NEW;



[global]
function ALL_NEW_TMP( ty: typ_ptr; id: ide_ptr := nil ): lgt_ptr;
{ To allocate a Temporary Memory Allocation Record }
{ Use the current lex level or a specified identifier ones for the owner link }
var
  pal: all_ptr;
  lgt: lgt_ptr;

begin
  if all_free_list = nil then NEW( pal )
  else
  begin
    pal := all_free_list; all_free_list := pal^.all_nxt
  end;
  LGT_NEW( lgt, ty, lgt_varbl, nil );
  lgt^.lgt_alloc := pal;
  with pal^, ty^ do
  begin
    all_nxt            :=          nil;
    all_prd            :=          nil;
    all_align          :=    typ_align;        { Set alignment specification }
    all_typ            :=           ty;        { Form of type form granulometry }
    all_acc            := [var_used,var_in,var_out,var_hidden];
    all_kind           :=      var_tmp;        { Set the kind of allocation }
    if id = nil then
    begin
      all_owner        :=  pro_current;        { Set the default owner }
      all_lex          :=     curr_lex
    end
    else
    begin
      all_owner        := id^.ide_owner;       { Set the identifier owner }
      all_lex          :=  id^.ide_lex
    end;
    all_psect          :=           -1;        { Defaulted to local section }
    all_size       :=  ABS( typ_size );        { Set the size of this object in byte(s) }
    all_reg            :=           -1;        { No used register }
    all_lexid          :=           -1;        { Set with no lex identifier }
    all_disp           :=           -1;        { Displacement to use }
    all_size_exp       :=          nil;        { Set size expression as unknown }
    all_first_u        :=          nil;        { First use pointer }
    all_last_u         :=          nil;        { Last use pointer }
    all_ide            :=          nil;        { Set the link to associated identifier }
    all_cte            :=          nil         { No initial cte value }
  end;
  ALL_NEW_TMP := lgt
end ALL_NEW_TMP;



[global]
procedure LGT_NEW_COPY( model: lgt_ptr; var copy: lgt_ptr );
{ TO Create a copy of a specified LGT Record }
begin
  copy := nil;
  if lgt_free_list = nil then NEW( copy )
  else
  begin
    copy := lgt_free_list; lgt_free_list := lgt_free_list^.lgt_nxt
  end;
  copy^ := model^;
  with copy^ do
    if lgt_kind = lgt_const then
      if lgt_cte <> nil then with lgt_cte^ do val_nuse := val_nuse + 1;
  copy^.lgt_nxt := nil
end LGT_NEW_COPY;



[global]
procedure LGT_COPY_TREE( src: lgt_ptr; var dst: lgt_ptr );
var
  srca, dsta, dsth, dstl: lgt_ptr;

begin
  if src <> nil then
    if src^.lgt_kind = lgt_null then LGT_COPY_TREE( src^.lgt_parmlst, dst )
    else
    begin
      srca := src^.lgt_parmlst;
      dsth := nil;
      while srca <> nil do
      begin
        LGT_COPY_TREE( srca, dsta );
        if dsth = nil then dsth := dsta
                      else dstl^.lgt_nxt := dsta;
        dstl := dsta;
        srca := srca^.lgt_nxt
      end;
      LGT_NEW_COPY( src, dst );
      dst^.lgt_parmlst := dsth
    end
end LGT_COPY_TREE;



[global]
procedure LGT_FREE( var p: lgt_ptr );
{ To Free a LGT Record }
begin
  with p^ do
  if lgt_kind <> lgt_freerec then
  begin
    if lgt_kind = lgt_const then
      if lgt_cte <> nil then VAL_FREE( lgt_cte );
    lgt_nxt := lgt_free_list;
    lgt_kind := lgt_freerec;
    lgt_free_list := p
  end;
  p := nil
end LGT_FREE;



[global]
procedure LGT_FREE_TREE( var p: lgt_ptr );
{ To Free a LGT Record Tree }
var
  p1, p2: lgt_ptr;

begin
  p1 := p;
  while p1 <> nil do
    if p1^.lgt_kind = lgt_freerec then  p1 := nil else
    begin
      if p1^.lgt_kind <> lgt_null then
        LGT_FREE_TREE( p1^.lgt_parmlst );      { Free all tree parameters }
      p2 := p1^.lgt_nxt;
      LGT_FREE( p1 );
      p1 := p2
    end;
  p := nil
end LGT_FREE_TREE;



[global]
function  LGT_NEW_ECONST( ty: typ_ptr; iv: integer ): lgt_ptr;
{ To Create An ennumerated type Constant LGT Record }
var
  lgt: lgt_ptr;

begin
  LGT_NEW( lgt, ty, lgt_const, nil );
  with lgt^ do
  begin
    lgt_cte := nil;
    VAL_NEW( lgt_cte, ty );
    lgt_cte^.val_ival := iv
  end;
  LGT_NEW_ECONST := lgt
end LGT_NEW_ECONST;



[global]
function  LGT_NEW_ECONSTR( ty: typ_ptr; rv: double ): lgt_ptr;
{ To Create A floating type Constant LGT Record }
var
  lgt: lgt_ptr;

begin
  LGT_NEW( lgt, ty, lgt_const, nil );
  with lgt^ do
  begin
    lgt_cte := nil;
    VAL_NEW( lgt_cte, ty );
    lgt_cte^.val_rval := rv
  end;
  LGT_NEW_ECONSTR := lgt
end LGT_NEW_ECONSTR;



[global]
function  LGT_GET_ECONST( lgt: lgt_ptr; idf: integer ): integer;
{ To get the Value of an ennumerated type LGT Constant }
var
  iv: integer;

begin
  iv := idf;
  if lgt <> nil then
  with lgt^ do
    if (lgt_kind = lgt_const) and (lgt_cte <> nil) then
    with lgt_cte^ do
      case val_kind of
        form_char, form_int, form_lit: iv := val_ival
      otherwise
      end;
  LGT_GET_ECONST := iv
end LGT_GET_ECONST;



[global]
function LGT_IMASKP2( lgt: lgt_ptr ): integer;
{ For the LGT Record of an ennumerated constant,
  When the value is 2**n, set the new value as 2**n - 1
                          and return the value of n (Log(base 2) of 2**n } 
var
  iv, jv: integer;

begin
  jv := -1;
  if lgt <> nil then
  with lgt^ do
    if (lgt_kind = lgt_const) and (lgt_cte <> nil) then
    with lgt_cte^ do
    begin
      case val_kind of
        form_char, form_int, form_lit:
          begin
            iv := val_ival;
            if iv <> 0 then
            begin
              jv := 0;
              while not ODD( iv ) do
              begin  iv := iv div 2; jv := jv + 1  end;
              if iv = 1 then
              begin
                iv := val_ival - 1; val_ival := iv
              end
              else
                jv := -1
            end
          end;
      otherwise
      end
    end;
  LGT_IMASKP2 := jv                            { Set then Log(base 2) as result }
end LGT_IMASKP2;



[global]
function  LGT_NEW_CODE( pcd: pcod_codes; par: lgt_ptr ): lgt_ptr;
{ Create a Code Operator LGT Record }
var
  lgt: lgt_ptr;

begin
  LGT_NEW( lgt, int_typ, lgt_codep, par );
  lgt^.lgt_pcode := pcd;
  LGT_NEW_CODE := lgt
end LGT_NEW_CODE;



[global]
function  LGT_NEW_CALL( pty: typ_ptr; pro: pro_ptr; par: lgt_ptr ): lgt_ptr;
{ Create a Call Function/Procedure Operator LGT Record }
var
  lgt: lgt_ptr;

begin
  LGT_NEW( lgt, pty, lgt_call, par );
  if pty <> nil then
    if not pty^.typ_simple then
      with lgt^ do
        lgt_status := lgt_status + [lgt_add];
  lgt^.lgt_pro    := pro;
  LGT_NEW_CALL   := lgt
end LGT_NEW_CALL;



[global]
function  LGT_LINK( lgt: lgt_ptr ): lgt_ptr;
{ To Create a Null LGT Record to make a Link in the LGT Tree }
var
  lgt1: lgt_ptr;

begin
  LGT_NEW( lgt1, lgt^.lgt_typ, lgt_null, lgt );
  lgt1^.lgt_status := lgt^.lgt_status;
  lgt^.lgt_status := lgt^.lgt_status + [lgt_lrf];
  LGT_LINK := lgt1
end LGT_LINK;



[global]
function  LGT_NEW_IDREF( id: ide_ptr; lnk: lgt_ptr ): lgt_ptr;
{ To Create an Identifier (Varbl/Constant) reference LGT Record }
var
  lg: lgt_ptr;

begin
  lg := nil;
  with id^ do
  begin
    case ide_class of
      cla_varbl:
        begin
          LGT_NEW( lg, ide_typ, lgt_varbl, nil );
          with lg^ do
          begin
            lgt_nxt    := lnk;
            lgt_lide   := id;
            lgt_ide    := id;
            ide_vacc   := ide_vacc + [var_used];
            lgt_alloc  := id^.ide_all;
            lgt_status := [lgt_add];
            if var_in  in ide_vacc then lgt_status := lgt_status + [lgt_in];
            if var_out in ide_vacc then lgt_status := lgt_status + [lgt_out];
          end
        end;

      cla_konst:
        begin
          LGT_NEW( lg, ide_typ, lgt_const, nil );
          with lg^ do
          begin
            lgt_nxt  := lnk;
            lgt_lide := id;
            if lgt_typ <> nil then
            if lgt_typ^.typ_simple then
            begin
              VAL_COPY( ide_value, lgt_cte, false );
              with lgt_cte^ do
              begin
                val_typ  := lgt_typ;
                val_kind := lgt_typ^.typ_form
              end
            end;
            if lgt_cte = nil then              { not simple or error }
            begin
              lgt_cte  := ide_value;
              VAL_NEW( lgt_cte, nil { nil unused} )
            end
          end
        end;

    otherwise
    end;

(* ///
    if (lg <> nil) and (ide_typ <> nil) then
    with ide_typ^, lg^ do
      case typ_form of
        form_record,
        form_variant: lgt_disp := 0;
      otherwise
        lgt_disp  := id^.ide_typ^.typ_descr_size
      end
*)

  end;
  LGT_NEW_IDREF := lg
end LGT_NEW_IDREF;



[global]
function LGT_TMPREF( ty: typ_ptr; nwt, frt: boolean ): lgt_ptr;
var
  lg: lgt_ptr;

begin
  LGT_NEW( lg, ty, lgt_vartmp, nil );
  with lg^ do
  begin
    lgt_tmplnk := nil;
    lgt_tmpall := nil;
    if nwt then lgt_status := lgt_status + [lgt_nwt];
    if frt then lgt_status := lgt_status + [lgt_frt]
  end;
  LGT_TMPREF := lg
end LGT_TMPREF;



[global]
function LGT_NEW_ADDSUB( bsub, bfree: boolean; lgt1, lgt2: lgt_ptr ): lgt_ptr;
var
  iv1, iv2: integer;
  ty:       typ_ptr;
  lgr:      lgt_ptr;

begin
  lgr := nil;
  ty  := lgt1^.lgt_typ;
  if lgt1^.lgt_kind = lgt_const then
  begin { lgt1 constant }
    iv1 := lgt1^.lgt_cte^.val_ival;
    if lgt2^.lgt_kind = lgt_const then
    begin                                      { lgt1 and lgt2 constant }
      iv2 := lgt2^.lgt_cte^.val_ival;
      if bsub then lgr := LGT_NEW_ECONST( ty, iv1 - iv2 )
              else lgr := LGT_NEW_ECONST( ty, iv1 + iv2 );
      if bfree then
      begin
        LGT_FREE( lgt1 ); LGT_FREE( lgt2 )
      end
    end
    else
      if iv1 = 0 then
      begin                                    { lgt1 constant = 0 and lgt2 variable }
        if bfree then LGT_FREE( lgt1 );
        if bsub then lgr := LGT_NEW_CODE( pcod_ineg, lgt2 )
                else lgr := lgt2
      end
  end
  else                                         { lgt1 variable }
    if lgt2^.lgt_kind = lgt_const then
      if lgt2^.lgt_cte^.val_ival = 0 then
      begin                                    { lgt2 = constant = 0 }
        lgr := lgt1;
        if bfree then LGT_FREE( lgt2 )
      end;

  if lgr = nil then
  begin                                        { no constant }
    lgt1^.lgt_nxt := lgt2;
    if bsub then lgr := LGT_NEW_CODE( pcod_isub, lgt1 )
            else lgr := LGT_NEW_CODE( pcod_iadd, lgt1 )
  end;
  lgr^.lgt_typ := ty;
  LGT_NEW_ADDSUB := lgr
end LGT_NEW_ADDSUB;



[global]
procedure NEW_DISP_LEVEL( ow: pro_ptr; kind: disp_kinds );
{ To create a new identifier display level }
const
  mdnam = 'NDLV';

begin { NEW_DISP_LEVEL }
  if curr_disp < max_disp then
  begin
    curr_disp := SUCC( curr_disp );
    if curr_disp > 0 then
      lex_ident_tree[curr_disp] := lex_ident_tree[curr_disp - 1];
    with lex_ident_tree[curr_disp] do
    begin
      disp_lex         :=     curr_lex;        { Set the lex as the current lex }
      if ow <> nil then                        { Default owner is old owner }
        disp_owner     :=           ow;        { Set the owner }
      disp_tree        :=          nil;        { Set the identifier tree to empty state }
      disp_lgt         :=          nil;        { Set current logical tree root }
      disp_kind        :=         kind;        { Kind of display level }
      disp_ide_last    :=          nil;        { Clear the last pointer of identifier list }
      disp_typ_hde     :=          nil;        { Initialize the type def. list }
      disp_data_size   :=            0         { Init size of the static/data space }
    end
  end else SRC_ERROR( mdnam, 1001, e_severe )
end NEW_DISP_LEVEL;



[global]
procedure IDE_RESERVE_DISP( prv: integer );
{ Append the specified display in the reserved list }
var
  ow: pro_ptr;

begin
  ow := lex_ident_tree[ curr_disp ].disp_owner;
(*
  ow := lex_ident_tree[ lex_ident_level[ curr_lex ] ].disp_owner;
*)
  if ow <> nil then
  with lex_ident_tree[curr_disp], ow^ do
    if disp_ide_last <> nil then
    begin
      disp_ide_last^.ide_nxt := pro_reserved;
      pro_reserved := disp_tree
    end;
  curr_disp := prv
end IDE_RESERVE_DISP;



[global]
function  MATCH( in_var s1, s2: id_name ): integer;
{ Compare two identifier names:
  return 0 when the identifers are same,
	>0 when s1 > s2 else <0. 
}
var
  m, i, n: integer;
  b: boolean;

begin { MATCH }
  if s1.l < s2.l then n := s1.l
                 else n := s2.l;
  i := 1;
  m := 0;
  while (i <= n) and (m = 0) do
  begin
    m := ORD( s1.s[i] ) - ORD( s2.s[i] ); i := i + 1
  end;
  if (i > n) and (m = 0) then m := s1.l - s2.l;
  MATCH := m
end MATCH;



[global]
function  NEW_INT_NAME( head: int_preffix;
                       var nbs: integer ): nam_ptr;
{ Built the internal identifier name as: <head>||STRING( <nbs>, -4 ) }
const
  maxfigures = 8;

var
  p:    nam_ptr;
  i, n: integer;

begin
  p := nil;
  NEW( p ); { Create the name record }
  with p^ do
  begin
    for i := 1 to 4 do  s[i] := head[i];
    i := 4 + maxfigures; l := i;
    n := nbs;
    while i > 4 do
    begin
      s[i] := CHR( ORD( '0' ) + ( n mod 10 ) );
      n := n div 10;
      i := i - 1
    end
  end;
  nbs := nbs + 1;
  NEW_INT_NAME := p
end NEW_INT_NAME;



[global]
function  LEVEL_SEARCH( fp: ide_ptr ): ide_ptr;
{ Search the sy_ident identifier in s specified identifier display tree }
var
  p:     ide_ptr;
  i:     integer;
  found: boolean;

begin { LEVEL_SEARCH }
  p := fp;
  found := false;
  prv_ident := nil;
  while not found and (p <> nil) do
  with p^ do
  begin
    prv_ident := p;
    if curr_ident = nil then i := MATCH( ide_name^, sy_ident )
                        else i := MATCH( ide_name^, curr_ident^ );
    if i = 0 then found := true
             else if i > 0 then begin
                                  id_left := true;
                                  p := p^.ide_left
                                end
                           else begin
                                  id_left := false;
                                  p := p^.ide_right
                                end
  end;
  LEVEL_SEARCH := p
end LEVEL_SEARCH;



[global]
function LEX_SEARCH( disp: integer ): ide_ptr;
var
  ip, ip1: ide_ptr;
  cdsp:    disp_kinds;
  lft:     boolean;

begin
  ident_disp := disp;
  if lex_ident_tree[ident_disp].disp_kind = dsp_proc then cdsp := dsp_proc
                                                     else cdsp := dsp_null;
  repeat
    ip := LEVEL_SEARCH( lex_ident_tree[ident_disp].disp_tree );
    if ident_disp = disp then begin
                                ip1 := prv_ident;
                                lft := id_left
                              end;
    ident_disp := ident_disp - 1;
  until (ip <> nil) or (ident_disp < lex_ident_level[curr_lex])
                    or (cdsp <> lex_ident_tree[ident_disp].disp_kind);
  prv_ident := ip1; id_left := lft;
  LEX_SEARCH := ip
end LEX_SEARCH; 



[global]
function  ANY_CLASS( fs: set_class_types ): class_types;
{ return the first present class in the given set of identifier class }
var
  elem: class_types;

begin { ANY_CLASS }
  elem := cla_separ;
  if fs <> [] then
    while not (elem in fs) do elem := SUCC( elem );
  ANY_CLASS := elem
end ANY_CLASS;



[global]
procedure IDE_NEW( fc: class_types; ty: typ_ptr; var ip: ide_ptr );
{ To create the identifier sy_ident with the specified class in
  the current display level tree. If it is already present, then it is not
  created and an error message is edited.}
const
  mdnam = 'NEWI';

var
  c:               class_types;
  own:                 pro_ptr;
  p:                   ide_ptr;
  i, ndisp:            integer;
  errps, twdcl:        boolean;

begin { IDE_NEW }
  { Look for place in the tree and for previous declaration }
  if fc = cla_label then ndisp := cprc_disp
                    else ndisp := curr_disp;

  p := LEX_SEARCH( ndisp );

  { If p <> nil then the specified identifier is existing ... }
  { else prv_ident is nil (tree is empty) or must be used
    to attach the new ident, id_left must be use to set the link }

  if p <> nil then
  begin
    with p^ do
      case ide_class of
        cla_varbl: twdcl := (ide_vkind = var_external);
        cla_konst: twdcl := (ide_ckind = var_external);
      otherwise
        twdcl := false
      end;
    { To flag a multi declaration }
    if not (twdcl and cmp_twicedclon) then
    begin
      cmp_twicedcl := true;
      SRC_ERROR_S( mdnam, 101, e_error, sy_ident )
    end
    else
      p^.ide_nxt := nil { Clear the previous declaration list link }
  end
  else
  begin { Not already existing identifier }
    p := nil;
    case fc of
      cla_label: begin
                   NEW( p, cla_label );
                   with p^ do
                   begin
                     ide_labflg :=  [];
                     ide_labnxt := nil;
                     ide_lablnk := nil;
                     ide_labsyn := nil;
                     ide_lablgt := nil;
                     ide_lablvl :=   0;
                     ide_labadr :=  -1
                   end
                 end;

      cla_statement:
                 begin
                    NEW( p, cla_statement );
                    with p^ do
                    begin
                     ide_stafirst :=   nil;
                     ide_stalast  :=   nil
                   end
                 end;

      cla_fentry:
                 begin
                   NEW( p, cla_fentry );
                   with p^ do
                   begin
                     ide_defentry := nil;
                     ide_entry    := nil;
                     ide_f_all    := nil
                   end
                 end;

      cla_genwfent,
      cla_type,
      cla_generic: begin
                   NEW( p, cla_generic );
                   with p^ do
                   begin
                     ide_forlnk := nil;
                     ide_gproc  := nil;
                     ide_gfirst := nil;
                     ide_glast  := nil
                   end
                 end;

      cla_konst: begin
                   NEW( p, cla_konst );
                   with p^ do
                   begin
                     ide_value := nil;
                     ide_kall  := nil;
                     ide_ckind := var_data
                   end
                 end;

      cla_tparam: begin
                   NEW( p, cla_tparam );
                   with p^ do
                   begin
                     ide_toffset :=   0;
                     ide_tkind   := tpa_sub;
                     ide_tlink   := nil;
                     ide_tlink2  := nil;
                     ide_cteval  := nil
                   end
                 end;

      cla_varbl: begin
                   NEW( p, cla_varbl );
                   with p^ do
                   begin
                     if curr_lex > 1 then
                     begin
                       ide_psect := -1;
                       ide_vacc  := [var_hidden]
                     end
                     else
                     begin
                       ide_psect := cmp_igenv;
                       ide_vacc  := []
                     end;
                     ide_vkind   := var_tmp;
                     ide_inival  := nil;
                     ide_extnam  := nil;
                     ide_all     := nil
                   end;
                   if sy_var_init_mod then { Init pascal mode }
                     if std_inp_file = nil then std_inp_file := p
                     else
                     if std_out_file = nil then std_out_file := p
                     else
                     if std_err_file = nil then std_err_file := p
                 end;

      cla_field: begin
                   NEW( p, cla_field );
                   p^.ide_offset := 0
                 end;

      cla_attr:  begin
                   NEW( p, cla_attr );
                   p^.ide_attr := attr_addr
                 end;

      cla_separ: begin
                   NEW( p, cla_separ );
                   p^.ide_sym := sym_rec[ nothing, no_op]
                 end;

    end;

    { Now set the identifier pointers }
    with p^ do
    begin
      ide_class := fc;
      NEW( ide_name );
      with ide_name^ do
      begin
        l := sy_ident.l;
        for i := 1 to l do s[i] := sy_ident.s[i]
      end;
      ide_left  := nil;
      ide_right := nil;
      ide_nxt   := nil;
      ide_typ   :=  ty;
      ide_lex   := curr_lex;
      ide_owner := lex_ident_tree[ndisp].disp_owner
    end;

    { Now attach the new identifier to the identifier tree }
    if prv_ident = nil then lex_ident_tree[ndisp].disp_tree := p
                       else if id_left then prv_ident^.ide_left := p
                                       else prv_ident^.ide_right := p;

    with lex_ident_tree[ndisp] do
    begin
      if disp_ide_last <> nil then disp_ide_last^.ide_nxt := p;
      disp_ide_last := p
    end;

    cmp_twicedcl := false
  end;
  if id_sflg then
  begin { When required restore }
    sy_string := id_save;
    id_sflg   := false
  end;
  ip := p
end IDE_NEW;



[global]
function  IDE_SEARCH( fs: set_class_types ): ide_ptr;
{ Search the sy_ident identifier in the current identifier scope
  in a specified set of identifier class. If it is founded in an
  another class then the result is nil. If the identifier is not
  existing then
    if err_ptr is true then the class corresponding undeclared
  identifier pointer is returned,
    else nil is returned.
  In all case if err_ptr is true, then an error message is generated.}

const
  mdnam = 'SRCI';

var
  ilvl: integer;
  p:    ide_ptr;

begin { IDE_SEARCH }
  ident_disp := curr_disp; { set to predefined identifier lex level }
  repeat
    p := LEVEL_SEARCH( lex_ident_tree[ident_disp].disp_tree );
    if p <> nil then
    begin
      if not (p^.ide_class in fs) then
      begin
        if err_prt then SRC_ERROR_S( mdnam, 103, e_error, sy_ident );
        p := nil;
        ident_disp := PRED( ident_disp )
      end
    end
    else ident_disp := PRED( ident_disp )
  until (p <> nil) or (ident_disp < 0);
  if (p = nil) and err_prt then
  begin { Send an ERROR Message and Create a wild identifier }
    SRC_ERROR_S( mdnam, 104, e_severe, sy_ident );

    p := ide_udptr[ANY_CLASS(fs)]
  end;
  IDE_SEARCH := p
end IDE_SEARCH;



[global]
procedure GEN_CNTXVAR( pr: pro_ptr; id: nam_ptr );
{ To Create a context variable for backtracing and debugging }
{ Warning: The identifier name strings are not copied (only there addresses are copied) }
begin
  with pr^ do
  begin
    NEW( pro_cntxide, cla_varbl );
    cntx_varbl := pro_cntxide;
    with pro_cntxide^ do
    begin
      ide_name   :=  id;
      ide_left   := nil; { Unused links }
      ide_right  := nil;
      ide_nxt    := nil;
      ide_typ    := cntx_typ;
      ide_lex    := curr_lex;
      ide_owner  :=  pr;
      ide_class  := cla_varbl;
      ide_psect  :=  -1;
      ide_vacc   := [var_used,var_hidden];
      if curr_lex <= 1 then ide_vkind := var_static
                       else ide_vkind := var_decl;
      ide_inival := nil;
      ide_extnam := pro_stdname;
      ide_all    := nil
    end
  end
end GEN_CNTXVAR;




[global]
function LGT_NEW_LINE( pr:  pro_ptr; lgp: lgt_ptr; icd: integer ): lgt_ptr;
{ To Create all back tracing lgt statements }
{ icd : Source Line info:  0 set new line,
                           1 Forced set new line,
                           2 Forced set new line with reset context,
                           3 Call procedure,
                           4 Return.
                           5 Init tracing,
                           6 Exit tracing.
}
var
  i, l:       integer;
  lgt1, lgt2: lgt_ptr;
  upd, src:   boolean;

begin
  lgt1 := nil;
  upd  := false;
  src  := false;
  if cmp_trace > 0 then { When tracing is enable }
  with src_control^, pr^ do
  begin
    if (cmp_tracecount <= src_linenbr) or (icd <> 0) then
    begin { Ok to generate or modify the source code }
      { Force info when source is changed }
      if cntx_srinf and (icd = 0) then icd := 1;
      case icd of
        0, 1, 2: { line info with or without reset link }
          begin
            if (lgp = pro_srcinfo) and (lgp <> nil) then
            case lgp^.lgt_icode of
              0, 1, 2, 4: upd := true;
            otherwise
            end;
            src := cntx_srinf
          end;
        3, 5: { Call or Init }
          src := true;

      otherwise
        { 4, 6 for Return or Exit }
      end;
      cntx_srinf := false;

      if src then
      begin { A source file name parameter must be generated }
        LGT_NEW( lgt1, typ_std[form_record], lgt_const, nil );
        with lgt1^, srf_list^ do
        begin
          lgt_cte := srf_value;
          VAL_NEW( lgt_cte, typ_std[form_record] );
          with lgt_cte^ do
          if val_nuse <= 2 then
          begin
            val_typ  := lgt_typ;
            val_kind := form_string;
            val_size := val_str^.length
          end
        end { lgt1 -> <src_id> }
      end;

      if upd then
      begin
        with lgp^ do
        if lgt_parmlst <> nil then
        begin { We update the previous lgt node }
          lgt_disp := src_linenbr;
          if src then
            if lgt_icode < 2 then
            with lgt_parmlst^ do
            begin { the source file name is the second parameter }
              if lgt_parmlst <> nil then LGT_FREE_TREE( lgt_parmlst );
              lgt_parmlst := lgt1
            end
            else
            with lgt_parmlst^ do
            if lgt_parmlst <> nil then
            with lgt_parmlst^ do
            begin  { the source file name is the third parameter }
              if lgt_parmlst <> nil then LGT_FREE_TREE( lgt_parmlst );
              lgt_parmlst := lgt1
            end
        end
      end
      else
      begin { We create a new lgt source information node }
        if (icd = 3) or (icd = 5) then 
        begin { Set a new symbol in the context stack }
          LGT_NEW( lgt2, typ_std[form_record], lgt_const, nil );
          with lgt2^ do
          begin
            lgt_cte := nil;
            VAL_NEW( lgt_cte, typ_std[form_record] );
            with lgt_cte^, cntx_varbl^ do
            begin
              val_kind := form_string;
              NEW( val_str, ide_name^.l );
              with val_str^, ide_name^ do
              begin
                length   := capacity;
                for i := 1 to capacity do body[i] := s[i];
                val_size := capacity
              end
            end
          end;
          lgt2^.lgt_nxt := lgt1;
          lgt1 := lgt2
        end; { lgt1 -> <proc_id> [, <src_id> ] }
        lgt1 := LGT_NEW_IDREF( cntx_varbl, lgt1 );
        LGT_NEW( lgt1, nil, lgt_srcinfo, lgt1 );
        with lgt1^ do
        begin
          lgt_disp  := src_linenbr;
          lgt_icode := icd
        end;
        pr^.pro_srcinfo := lgt1
      end; { lgt1 -> <srcinfo_node> [, <proc_id> [, <src_id> ]] }
      cmp_tracecount := src_linenbr + cmp_trace
    end
  end;
  if upd then LGT_NEW_LINE := nil
         else LGT_NEW_LINE := lgt1
end LGT_NEW_LINE;




(*
[global]
function LGT_NEW_LINE( pr:  pro_ptr; lgp: lgt_ptr; icd: integer ): lgt_ptr;
{ ** To Create all back tracing lgt statements **

  Formal Arguments :
  
  pr   -> current module/main/procedure/function,

  lgp  -> Previous instruction tree node pointer (used for update mode).

  icd : Source Line info:  0 set new line,
                           1 Forced set new line,
                           2 Forced set new line with reset context,
                           3 Call procedure,
                           4 Return.
                           5 Init tracing,
                           6 Exit tracing.
}
var
  i, l:       integer;
  lgt1, lgt2, lgt3: lgt_ptr;
  upd, src:   boolean;

begin
  lgt1 := nil;
  upd  := false;
  src  := false;

  if cmp_trace > 0 then { When tracing is enable }
  with src_control^, pr^ do
  begin
    if (cmp_tracecount <= src_linenbr) or (icd <> 0) then
    begin { Ok to generate or modify the source code }
      { Force info when source is changed }
      if cntx_srinf and (icd = 0) then icd := 1;
      case icd of
        0, 1, 2: { line info with or without reset link }
          begin
            if (lgp = pro_srcinfo) and (lgp <> nil) then
            case lgp^.lgt_icode of
              0, 1, 2: upd := true;
            otherwise
            end;
            src := cntx_srinf           { Mode src when the source file inchanged }
          end;
        3, 5: { Call or Init }
          src := true;                  { Mode src also when Call entry or Init tracing }

      otherwise
        { 4, 6 for Return or Exit }
      end;
      cntx_srinf := false;
upd := false; src:= true;
   
      if src then
      begin { A source file name argument must be generated }
        LGT_NEW( lgt1, typ_std[form_record], lgt_const, nil );
        with lgt1^, srf_list^ do
        begin
          lgt_cte := srf_value;
          VAL_NEW( lgt_cte, typ_std[form_record] );
          with lgt_cte^ do
          if val_nuse <= 2 then
          begin
            val_typ  := lgt_typ;
            val_kind := form_string;
            val_size := val_str^.length
          end
        end { lgt1 -> <src_id> }
      end;

      if upd then
      begin
        with lgp^ do
        if lgt_parmlst <> nil then
        begin { We update the previous lgt node }
          lgt_disp := src_linenbr;
          if src then
            if lgt_icode < 2 then       { Just change the code line number }
            with lgt_parmlst^ do
            begin { The entry name is the second arg. and the source file name is the third one }
              if lgt_parmlst <> nil then LGT_FREE_TREE( lgt_parmlst );  { with must suppress the second and the third arguments }
              lgt_parmlst := lgt1
            end
            else                        { icode = 2,  }
            with lgt_parmlst^ do
              if lgt_parmlst <> nil then { lgt_nxt plutot ??? }
              with lgt_parmlst^ do { lgt_nxt plutot ??? }
              begin  { The source file name is the third parameter }
                if lgt_parmlst <> nil then LGT_FREE_TREE( lgt_parmlst );
                lgt_parmlst := lgt1
              end
        end
      end
      else
      begin { We create a new lgt source information node }
        
        if (icd = 3) or (icd = 5) then 
        begin { Set a new symbol in the context stack }
          { Generate the source file string reference }
          LGT_NEW( lgt3, typ_std[form_record], lgt_const, nil );
          with lgt3^, srf_list^ do
          begin
            lgt_cte := srf_value;
            VAL_NEW( lgt_cte, typ_std[form_record] );
            with lgt_cte^ do
            if val_nuse <= 2 then
            begin
              val_typ  := lgt_typ;
              val_kind := form_string;
              val_size := val_str^.length
            end
          end; { lgt3 -> <src_id> }
          { Generate the Entry (procedure of function) name string reference }
          LGT_NEW( lgt2, typ_std[form_record], lgt_const, nil );
          with lgt2^ do
          begin
            lgt_cte := nil;
            VAL_NEW( lgt_cte, typ_std[form_record] );
            with lgt_cte^, cntx_varbl^ do
            begin
              val_kind := form_string;
              NEW( val_str, ide_name^.l );
              with val_str^, ide_name^ do
              begin
                length   := capacity;
                for i := 1 to capacity do body[i] := s[i];
                val_size := capacity
              end
            end
          end;
          { link it together }
          lgt2^.lgt_nxt := lgt3
        end { lgt1 -> <proc_id> [, <src_id> ] }
        else lgt2 := nil;
        { Generate the context record refernce parameter }
        lgt1 := LGT_NEW_IDREF( cntx_varbl, lgt1 );
        LGT_NEW( lgt1, nil, lgt_srcinfo, lgt1 );
        with lgt1^ do
        begin
          lgt_disp  := src_linenbr;
          lgt_icode := icd
        end;
        lgt1^.lgt_nxt := lgt2;
        pr^.pro_srcinfo := lgt1
      end; { lgt1 -> <srcinfo_node> [, <proc_id> [, <src_id> ]] }
      cmp_tracecount := src_linenbr + cmp_trace
    end
  end;

  if upd then LGT_NEW_LINE := nil
         else LGT_NEW_LINE := lgt1
end LGT_NEW_LINE;
*)





[global]
procedure GEN_LINETRACE( pr: pro_ptr; var lgh, lgl: lgt_ptr; icd: integer );
{ To Create all back tracing lgt statements }
var
  lgt:  lgt_ptr;

begin
  if lgh = nil then lgl := nil;
  lgt := LGT_NEW_LINE( pr, lgl, icd );
  if lgt <> nil then
  begin { a node was created by LGT_NEW_LINE }
    if lgh = nil then lgh := lgt
                 else lgl^.lgt_nxt := lgt;
    lgl := lgt
  end
end GEN_LINETRACE;



[global]
procedure LABEL_PURGE( var prv_cntx: ide_ptr );
{ To Purge the current label list of all defined label }
const
  mdnam = 'LABP';

var
  p1, p2: ide_ptr;

begin
  p1 := cntx_label;
  cntx_label := prv_cntx;
  while (p1 <> prv_cntx) and (p1 <> nil) do
  begin
    with p1^ do
    begin
      p2 := ide_lablnk;
      { The locally defined labels must be set hidden and
        the other labels must be set in the more global list }
      if lab_defined in ide_labflg then
      begin                                    { locally defined label must be set hidden }
        ide_labflg := ide_labflg + [lab_hidden];
        ide_lablnk := nil
      end
      else
      begin                                    { Referenced but not defined label }
        if lab_inref in ide_labflg then
          { A label with internal reference must be in the local lex }
          SRC_ERROR_S( mdnam, 67, e_severe, ide_name^ );
        ide_lablnk := cntx_label;
        cntx_label := p1
      end
    end;
    p1 := p2
  end;
  cntx_lblvl := cntx_lblvl - 1;
  prv_cntx := cntx_label
end LABEL_PURGE;



[global]
function TYP_ALIGNEMENT( iaddr: integer; aln: align_byte ): integer;
{ To apply an Alignement Requirement to the Offset/address iaddr }
var
  iequ, ity: align_long;

begin
  with iequ do
  begin
    int := iaddr + aln.int; ity.int := aln.int;
    bits := bits - ity.bits;
    TYP_ALIGNEMENT := int
  end
end TYP_ALIGNEMENT;



[global]
function  IDE_TYP_ALIGN( iaddr: integer; ty: typ_ptr ): integer;
{ To apply an type Alignement Requirement to the Offset/address iaddr }
var
  iequ, ity: align_long;

begin
  with ty^, iequ do
  begin
    int := iaddr + typ_align.int; ity.int := typ_align.int;
    bits := bits - ity.bits;
    IDE_TYP_ALIGN := int
  end
end IDE_TYP_ALIGN;



[global]
procedure ALL_TYP_ALLOCATE( var iaddr: integer; al: all_ptr );
{ To set an address (iaddr) to a specified to allocation block }
var
  iequ, ity: align_long;

begin
  with al^, iequ do
  begin
    int        :=  iaddr + all_align.int;      { Add the alignement quantity }
    ity.int    :=        all_align.int;        { Copy it in a long alignement }
    bits       :=      bits - ity.bits;        { Clear the alignement bits }
    all_disp   :=                  int;        { Deposit the allocation start address }
    iaddr      := int + ABS( all_size )        { Update the allocation count }
  end
end ALL_TYP_ALLOCATE;



[global]
procedure CTE_ALLOCATE( vp: val_ptr; id: ide_ptr );
{ To allocate (create Allocation record) for a constant LGT Record }
var
  svsz: integer;
  ty:   typ_ptr;

begin
  if id = nil then ty := vp^.val_typ
              else ty := id^.ide_typ;
  if ty <> nil then
  with ty^, vp^ do
  if (not typ_simple) and (val_kind <> form_wild) then
  begin
    svsz := typ_size;
    if val_size > 0 then
      if ty = typ_std[form_record] then
        typ_size := val_size + typ_descr_size
      else
        typ_size := val_size
    else typ_size := 0;
    ALL_NEW( val_all, ty, id, var_data );
    if id <> nil then id^.ide_kall := val_all;
    typ_size := svsz;
    if all_fdata = nil then all_fdata := val_all
                       else all_ldata^.all_nxt := val_all;
    val_all^.all_prd := all_ldata;
    all_ldata := val_all;
    with val_all^ do
    begin
      all_cte  := vp;
      with all_cte^ do val_nuse := val_nuse + 1
    end
  end
end CTE_ALLOCATE;



[global]
procedure IDE_NEW_TYP( frm: typ_forms; var p: typ_ptr );
{ To create a new Type Record }
begin
  NEW( p );
  if p <> nil then
  with p^ do
  begin
    typ_parent         :=          nil;         { Init all type record fields }
    typ_attsub         :=          nil;
    with lex_ident_tree[curr_disp] do           { Link the new type to owner display }
    begin
      typ_nxt := disp_typ_hde;
      disp_typ_hde := p
    end;
    typ_ide            :=          nil;
    typ_parmlst        :=          nil;
    typ_descr_size     :=            0;
    typ_size           :=    inte_size;
    typ_align.int      :=            0;        { Default is to do not alignement }
    typ_actual         :=          nil;
    typ_sizesrv        :=          nil;        { Assume no specific size computing routine }
    typ_comp_size      :=          nil;
    typ_inival         :=          nil;        { No attached initial value }
    typ_fxdrange       :=        false;        { Until showed otherwise }
    typ_subtype        :=        false;
    typ_hasidsc        :=        false;        { Assume no internal descriptor }
    case frm of
      form_wlit, form_ennum, form_nil,   form_eqse,
      form_char, form_lit,   form_int,   form_single,  form_double,
      form_set,  form_wset,  form_wwset, form_pointer, form_range,
      form_file, form_wfile, form_fentry:
        typ_simple     :=         true;
    otherwise
      typ_simple       :=        false
    end;
    typ_form           :=          frm
  end
end IDE_NEW_TYP;



[global]
procedure IDE_NEW_TYP_RANGE( min, max: integer;        { Effective limit range id. }
                             parent: typ_ptr;          { Parent type id. pointer }
                             var typ: typ_ptr );       { Result type pointer }
{ To Create a type Record for a type Range type }
begin
  IDE_NEW_TYP( form_int, typ );                { Create the type record }
  with typ^ do
  begin
    typ_idelist        :=          nil;        { Begining without identifier list }
    typ_idetab         :=          nil;        { and no identifier table }
    if parent <> nil then
    begin
      typ_parent       :=       parent;
      typ_form         := parent^.typ_form;
      typ_size         := parent^.typ_size;
      typ_align        := parent^.typ_align;
      typ_unsigned     := parent^.typ_unsigned
    end
    else
    begin
      typ_align.int    :=            0;        { Do not word alignement }
      typ_unsigned     :=   (min >= 0);
      typ_size         :=            4         { Long word size default }
    end;
    typ_fxdrange       :=  true;
    typ_min := min; typ_max := max
  end
end IDE_NEW_TYP_RANGE;



[global]
procedure TMPSTK_ALLOCATE( lgt: lgt_ptr; ty: typ_ptr );
var
  nwstk: stk_ptr;

begin
  NEW( nwstk );                                { Allocate the tmp stack block }
  nwstk^.stk_prev   :=     wildtmp_stk;        { Set the previous stack link }
  nwstk^.stk_lgt    :=             lgt;        { Set the reference link }
  if wildtmp_stk <> nil then                   { Set the new stack bottom }
    nwstk^.stk_bott := wildtmp_stk^.stk_top    { Get the last top }
  else
    nwstk^.stk_bott :=               0;        { ... 0 for first one }
  { Set the New Allocation Offset }
  nwstk^.stk_top   := TYP_ALIGNEMENT( nwstk^.stk_bott, ty^.typ_align );
  lgt^.lgt_disp    :=   nwstk^.stk_top;        { Set the displacement }
(* ///
  if (ty^.typ_form <> form_record) and (ty^.typ_descr_size > 0) then
    nwstk^.stk_top := nwstk^.stk_top + ABS( ty^.typ_descr_size ); { & top }
/// *)
  nwstk^.stk_top   := nwstk^.stk_top + ABS( ty^.typ_size ); { & top }
  { Update the Tmp stack Variable Alignement When Required }
  if wildtmp_typ^.typ_align.int < ty^.typ_align.int then
  begin
    wildtmp_pal    := wildtmp_typ^.typ_align;  { Save last tmp Align mode }
    wildtmp_typ^.typ_align  := ty^.typ_align
  end;
  { Update the Tmp stack Variable Size When Required }
  if wildtmp_typ^.typ_size < nwstk^.stk_top then
  begin
    wildtmp_psz           := wildtmp_typ^.typ_size;
    wildtmp_typ^.typ_size := nwstk^.stk_top
  end;
  wildtmp_stk      :=            nwstk         { Set the new stack state }
end TMPSTK_ALLOCATE;



[global]
procedure TMPSTK_FREE( stkp: stk_ptr );
var
  tmpstk: stk_ptr;

begin
  while (stkp <> wildtmp_stk) and (wildtmp_stk <> nil) do
  begin
    tmpstk := wildtmp_stk;
    wildtmp_stk := wildtmp_stk^.stk_prev;
    DISPOSE( tmpstk )
  end
end TMPSTK_FREE;



[global]
procedure FREE_IDE_LIST( var p: ide_ptr );
{ To Free an Identifier List }
var
  p1: ide_ptr;
  pg: gen_ptr;
  st: sta_ptr;

begin
  while p <> nil do
  begin
    with p^ do
    begin
      p1 := p^.ide_nxt;
      case ide_class of
        cla_null,
        cla_label:  DISPOSE( p {, cla_label } );

        cla_konst:
          begin
            VAL_FREE( ide_value ); DISPOSE( p {, cla_konst} )
          end;

        cla_tparam:
          begin
            if ide_cteval <> nil then
              VAL_FREE( ide_cteval );
            DISPOSE( p {, cla_tparam} )
          end;

        cla_varbl:
          begin
            if ide_inival <> nil then
              VAL_FREE( ide_inival );
            DISPOSE( p {, cla_varbl} )
          end;

        cla_field:  DISPOSE( p {, cla_field} );

        cla_statement:
          begin
            st := ide_stafirst;
            while st <> nil do
            begin
              st := ide_stafirst^.sta_nxt;
              { Should be dispose for all specification - but it is dangerous }
              DISPOSE( ide_stafirst );
              ide_stafirst := st
            end;
            DISPOSE( p {, cla_statement } )
          end;

        cla_fentry:
          begin
            with ide_entry^ do
            begin
              FREE_IDE_LIST( pro_parmlst );
              FREE_TYP_LIST( pro_prmtyls )
            end;
            DISPOSE( ide_entry );
            DISPOSE( p {, cla_formalproc} )
          end;

        cla_separ: DISPOSE( p {, cla_separ} );

        cla_genwfent,
        cla_type,
        cla_generic:
          begin
            FREE_GENERIC_LIST( ide_gfirst, ide_glast );
            DISPOSE( p {, cla_generic} )
          end
      otherwise
      end
    end;
    p := p1
  end
end FREE_IDE_LIST;



[global]
procedure FREE_TYP_LIST( var p: typ_ptr);
{ To Free a Type Record List }
var
  p1: typ_ptr;

begin
  while p <> nil do
  begin
    with p^ do
    begin
      if typ_inival <> nil then
        VAL_FREE( typ_inival );
      FREE_IDE_LIST( typ_parmlst );
      LGT_FREE_TREE( typ_comp_size );
      p1 := typ_nxt;
      case typ_form of
        form_char,
        form_lit,
        form_int:     begin
                        FREE_IDE_LIST( typ_idelist );
                        LGT_FREE( typ_idetab )
                      end;
        form_array:   LGT_FREE_TREE( typ_el_comp_size );
        form_variant,
        form_record:  begin
                        if typ_form = form_record then
                          FREE_IDE_LIST( typ_firstfield ); { free all the field }
                        LGT_FREE_TREE( typ_recvar )        { and any tagfield spc. }
                      end;
        form_range:   begin
                        if typ_nvalue <> nil then LGT_FREE_TREE( typ_nvalue );
                        if typ_low <> nil then LGT_FREE_TREE( typ_low );
                        if typ_high <> nil then LGT_FREE_TREE( typ_high )
                      end;
        form_fentry:  begin
                        with typ_entry^ do
                        begin
                          FREE_IDE_LIST( pro_parmlst );
                          FREE_TYP_LIST( pro_prmtyls )
                        end;
                        DISPOSE( typ_entry )
                      end;
      otherwise
      end;
      LGT_FREE_TREE( typ_actual );
      DISPOSE( p )
    end;
    p := p1
  end
end FREE_TYP_LIST;



procedure FREE_OPE_LIST( var p: ope_ptr );
{ To Free an Operator Definition List }
var
  pg: gen_ptr;
  po: ope_ptr;

begin
  while p <> nil do
  begin
    with p^ do 
    begin
      ope_table[ope_operator] := ope_llnk; { restore old ope definitions}
      FREE_GENERIC_LIST( ope_gfirst, ope_glast );
      po := ope_nxt
    end;
    DISPOSE( p );
    p := po
  end
end FREE_OPE_LIST;



[global]
procedure FREE_GENERIC_LIST ( var f, l: gen_ptr );
{ To Free a Generic Definition List }
var
  pg: gen_ptr;

begin
  if f <> nil then
  repeat
    pg := f;
    with pg^ do
      if not gen_blt then
      begin
        with gen_proc^ do
        begin
          if pro_pkind = pro_inline then
          begin
            FREE_IDE_LIST( pro_loclst );       { Free all local identifier }
            FREE_IDE_LIST( pro_reserved );     { Free all reserved identifier}
            FREE_TYP_LIST( pro_typlst );       { Free all local type descr. }
            FREE_OPE_LIST( pro_opelst )        { Free all local operator def. }
          end;
          FREE_IDE_LIST( pro_parmlst );        { Free all parameter identifiers }
          FREE_TYP_LIST( pro_prmtyls );        { Free all parameter type descr. }

          { Free all allocation descriptors }
          if pro_pkind = pro_decl then
          begin
            if pro_fdyn_all <> nil then
            begin
              pro_ldyn_all^.all_nxt := all_free_list;
              all_free_list := pro_fdyn_all
            end
          end
        end;
        DISPOSE( gen_proc )
      end;
    if f <> l then f := f^.gen_link;
    DISPOSE( pg );
  until f = l;
  f := nil; l := nil
end FREE_GENERIC_LIST;



[global]
procedure IDE_FREE_LEX ( p: pro_ptr );
{ To free all type and identifier record definition in the current
  display level }
{ p is the owner procedure pointer }

begin { IDE_FREE_LEX }
  if p <> nil then
  with p^ do
  if pro_pkind <> pro_inline then
  { It must be preserved for inline procedure }
  begin
    FREE_IDE_LIST( pro_loclst );
    FREE_IDE_LIST( pro_reserved );
    FREE_TYP_LIST( pro_typlst );
    FREE_OPE_LIST( pro_opelst )
  end
end IDE_FREE_LEX;



[global]
procedure IDE_CREATE_NAME( var name: [readonly] string );
{ Load a given identifier name in sy_ident for an internal declaration }
var
  i, l: integer;

begin { IDE_CREATE_NAME }
  id_save := sy_string;     { Save the current identifier }
  id_sflg := true;
  l := LENGTH( name );
  if l > id_maxsize then l := id_maxsize;
  for i := 1 to l do
    sy_ident.s[i] := name.body[i];
  sy_ident.l := l
end IDE_CREATE_NAME;



[global]
procedure IDE_INT_LABEL;
{ To code the integer sy_ival as an identifier name }
const
  mdnam = 'ILAB';

var
  i, iv, j, l: integer;

begin
  iv := sy_ival;
  if (iv <= 0) or (iv > 9999) then
  begin
    SRC_ERROR( mdnam, 68, e_severe );
    iv := 0
  end;
  j  := 5;
  while j > 1 do
  begin
    sy_ident.s[j] := CHR( (iv mod 10) + ORD( '0' ) );
    j := j - 1;
    iv := iv div 10
  end;
  sy_ident.s[1] := '.';
  sy_ident.l    :=   5;
  sy_sym.sy := identsy
end IDE_INT_LABEL;



[global]
function IDE_SEARCH_FROM_NAMEID( ip: ide_ptr ): ide_ptr;
{ Load a given identifier in sy_ident and re-search it }
{ use to get internal access of user defined generic of
  standard procedure/function }
var
  i, sz: integer;
  ir:    ide_ptr;

begin { IDE_SEARCH_FROM_NAMEID }
  ir := nil;
  if ip <> nil then
  with ip^ do
  if ide_name <> nil then
  begin
    curr_ident := ip^.ide_name;
    ir := IDE_SEARCH( [ide_class] );
    curr_ident := nil
  end;
  IDE_SEARCH_FROM_NAMEID := ir
end IDE_SEARCH_FROM_NAMEID;



[global]
procedure SET_GBL_DEF_NAM( var trg: nam_ptr; var src: id_name; ach: char );
{ To Generate a Global Name Identifier }
var
  i: integer;

begin
  NEW( trg );
  with trg^ do
  begin
    s[1] := ach; s[2] := '_';
    if src.l <= (id_maxsize - 2) then
    begin
      for i := 1 to src.l do  s[i+2] := src.s[i];
      l := src.l + 2
    end
    else
    begin
      for i := 1 to id_maxsize - 4 do  s[i+2] := src.s[i];
      for i := src.l - 3 to src.l do  s[i+2] := src.s[i];
      l := id_maxsize
    end
  end
end SET_GBL_DEF_NAM;



[global]
procedure SET_ENV_FILE_SPC( pcur: env_ptr );
{ To set a Environment File Specification }
var
  i:          integer;
  str:        str_ptr;
  envp, enpr: env_ptr;
  bfnd:       boolean;

begin
  bfnd := false;
  envp := env_first;
  enpr := nil;
  str  := nil;
  NEW( str, sy_string.length );
  str^ := sy_string;
  while (not bfnd) and (envp <> nil) do
  begin
    if STR_MATCH( str^, envp^.env_spc^ ) = 0 then bfnd := true
    else
    begin
      enpr := envp;
      envp := envp^.env_nxt
    end
  end;

  if bfnd then DISPOSE( str )
  else
  begin
    NEW( envp );
    with envp^ do
    begin
      env_nxt := pcur;
      env_spc := str;
      env_idx := 0
    end;
    if pcur <> nil then
    begin
      if pcur = env_first then env_first := envp
    end
    else
    begin
      if env_first = nil then env_first := envp
                         else env_last^.env_nxt := envp;
      env_last := envp
    end
  end
end SET_ENV_FILE_SPC;



[global]
procedure WIEW_OPER_DEF( op: operator );
var
  pg:     gen_ptr;
  pf:     ide_ptr;

begin
  WRITELN( ' * Here is the ', opname[op].s:opname[op].l, ' entry definition list:' );
  pg := ope_table[op]^.ope_gfirst;
  while pg <> nil do
    with pg^ do
    begin
      WRITE( ' ':8 );
      if gen_blt then
      begin
        WRITE( '(' );
        if gen_p1 <> nil then WRITE( ' ', gen_p1^.typ_form );
        if gen_p2 <> nil then WRITE( ', ', gen_p2^.typ_form );
        WRITE( ')' );
        if gen_result <> nil then WRITE( ' => ', gen_result^.typ_form );
        WRITELN
      end
      else
      with gen_proc^ do
      begin
        WRITE ( ' ':8 );
        if pro_typ = nil then WRITE( 'Procedure ' )
                         else WRITE( 'Function ' );
        with pro_stdname^ do WRITE( s:l, '(' );
        pf := pro_parmlst;
        while pf <> nil do
          with pf^ do
          begin
            if ide_vkind <> var_result then
            begin
              with ide_name^ do WRITE( ' ', s:l, ': ' );
              with ide_typ^ do
                if typ_ide <> nil then
                  with typ_ide^.ide_name^ do WRITE( s:l )
                else
                  WRITE( '<FRM=', typ_form, '>' );
              if ide_nxt <> nil then WRITE( ', ' );
            end;
            pf := ide_nxt
          end;
        WRITE( ')' );
        if pro_typ <> nil then
        with pro_typ^ do
        begin
          WRITE( ': ' );
          if typ_ide <> nil then
            with typ_ide^.ide_name^ do WRITE( s:l )
          else
            WRITE( '<FRM=', typ_form, '>' )
        end;
        WRITELN( ';' )
      end;
      pg := gen_link
    end;
  WRITELN
end;


end.
