{    **************************************************************
     *                                                            *
     *                                                            *
     *              *  C P A S  *  S Y S T E M  *                 *
     *                                                            *
     *                                                            *
     *      * * *   S t a n d a r d   L i b r a r y   * * *       *
     *                                                            *
     *                                                            *
     *               ---  I/O String Library  ---                 *
     *                                                            *
     *   by :                                                     *
     *                                                            *
     *       P. Wolfers                                           *
     *         c.n.r.s.                                           *
     *         Laboratoire de Cristallographie                    *
     *         B.P.  166 X   38042  Grenoble Cedex                *
     *                           FRANCE.                          *
     *                                                            *
     **************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////


*************************************************************************
*                                                                       *
*        Last revision of 28-APR-2005 for CPASCAL Version 1.9 L         *
*                                                                       *
*************************************************************************
}
%pragma trace 0;
module CPAS__IOSTR;

var
  [external 'PAS__curr_iptr']  curr_input: text; { The current input --- Patch  27/04/2005 }


(************   Character(s) input procedures  **************)


[global 'PAS__READ_FCHAR']
procedure READ_FCHAR( var ch: char; fld: integer );
{ Read fld character, the first one is put in ch } 
var
  ch1: char;

begin
  READ$OBJECT( ch );
  while (fld > 1) and not CURRENT_EOLN do
  begin  READ$OBJECT( ch1 ); fld := fld - 1  end
end READ_FCHAR;



[global 'PAS__READ_CHAR_ARRAY']
function  READ_CHAR_ARRAY( var chtb: packed array[len: integer] of char;
                               fld: integer := 0; bsep: boolean := false ): integer;
{ Read an array of char st.
  If fld > 0 fld is the number of read character except if EOF or EOLN
  are reached. The number of stored character in st is also limited by
  the capacity of the string. If bsep  the preffix character Space or
  Tab are ignored and the read is stopped by the first Space or TAB.
}
var
  i, j: integer;
  ch:      char;
  bi:   boolean;

begin
  i := 0;
  if fld <= 0 then fld := -1;
  if bsep then
  begin
    bi := false;
    repeat
      if UFB( curr_input ) then GET( curr_input ); { --- Patch  28/04/2005 }
    exit if CURRENT_EOF;                     { The EOLN is take as a space }
      if fld > 0 then fld := fld - 1;
      ch := curr_input^; { Get the current character --- Patch  28/04/2005 }
    exit if bi and (ch <= ' ');
      if ch > ' ' then
      begin
        i := i + 1; chtb[i] := ch; bi := true
      end;
      GET( curr_input )                           { Get the next character }
    until (fld = 0) or (i >= len);        { Stop when the field is expired }
  end
  else { The normal input string mode (- ended by EOLN or string full }
    while not CURRENT_EOLN and (i < len) and (fld <> 0) do
    begin
      if fld >= 0 then fld := fld - 1;
      i := i + 1; chtb[i] := curr_input^; GET( curr_input )
    end;
  READ_CHAR_ARRAY := i
end READ_CHAR_ARRAY;



[global 'PAS__READ_STR']
procedure READ_STRING(    var  st: string;
                               fld: integer := 0; bsep: boolean := false );
{ Read a string st.
  If fld > 0 fld is the number of read character except if EOF or EOLN
  are reached. The number of stored character in st is also limited by
  the capacity of the string. If bsep  the preffix character Space or
  Tab are ignored and the read is stopped by the first Space or TAB.
}
var
  i, len: integer;
  ch: char;

begin
  st.length := READ_CHAR_ARRAY( st.body, fld, bsep );
(*
  len := st.capacity; { Get the capacity of the caller string }
  i   := 0;
  if fld <= 0 then fld := -1;
  if bsep then
  begin
    { Skip the preffix separators }
    while not CURRENT_EOLN and (fld <> 0) do
    begin
      READ$OBJECT( ch );
    exit if ch > ' ';
      if fld > 0 then fld := fld - 1;
    end;

    { Read the string until EOLN or separator }
    st.body[1] := ch; i := 1;
    while not CURRENT_EOLN and (i < len) and (fld <> 0) do
    begin
      if fld > 0 then fld := fld - 1;
      READ$OBJECT( ch );
    exit if ch <= ' ';
      i := i + 1;
      st.body[i] := ch
    end
  end
  else
    while not CURRENT_EOLN and (i < len) do
    begin
      if fld >= 0 then fld := fld - 1;
      i := i + 1;
      READ$OBJECT( st.body[i] );
    exit if fld = 0;
    end;
  st.length := i
*)
end READ_STRING;


[global 'PAS__READ_CHT']
procedure READ_CHARRAY( var chtb: packed array[len: integer] of char;
                             fld: integer := 0; bsep: boolean := false );
{ Read an array of char st.
  If fld > 0 fld is the number of read character except if EOF or EOLN
  are reached. The number of stored character in st is also limited by
  the capacity of the string. If bsep  the preffix character Space or
  Tab are ignored and the read is stopped by the first Space or TAB.
}
var
  i:  integer;
  ch: char;

begin
  i := READ_CHAR_ARRAY( chtb, fld, bsep );
(*
  i   := 0;
  if fld <= 0 then fld := -1;
  if bsep then
  begin
    { Skip the preffix separators }
    while not CURRENT_EOLN and (fld <> 0) do
    begin
      READ$OBJECT( ch );
    exit if ch > ' ';
      if fld > 0 then fld := fld - 1;
    end;

    { Read the string until EOLN or separator }
    chtb[1] := ch; i := 1;
    while not CURRENT_EOLN and (i < len) and (fld <> 0) do
    begin
      if fld > 0 then fld := fld - 1;
      READ$OBJECT( ch );
    exit if ch <= ' ';
      chtb[i] := ch;
      i := i + 1
    end
  end
  else
    while not CURRENT_EOLN and (i < len) do
    begin
      if fld >= 0 then fld := fld - 1;
      i := i + 1;
      READ$OBJECT( chtb[i] );
    exit if fld = 0;
    end;
*)
  for j := i+1 to len do chtb[j] := ' '
end READ_CHARRAY;




(************   Character(s)  Output procedures  **************)


procedure GET_FORMAT( sz, p, f: integer; var bl, md, el: integer );
begin
  if f <= 0 then { NO specified field }
  begin
    md := sz; bl := 0; el := 0
  end
  else
    if f <= sz then { string too long }
    begin 
      md := f; bl := 0; el := 0
    end
    else
    begin
      md := sz;
      if p < 0 then { string at left }
      begin
        bl := 0; el := f - sz
      end
      else
        if p > 0 then { string at right }
        begin
          bl := f - sz; el := 0
        end   
        else 
        begin { string centered }
          el := f - sz;
          bl := el div 2; el := el - bl
        end
    end
end GET_FORMAT;


[global 'PAS__WRITE_MCHAR']
procedure WRITE_MCHAR( ch: char; rep: integer );
begin
  for i := 1 to rep do WRITE$OBJECT( ch )
end WRITE_MCHAR;


[global 'PAS__WRITE_STR']
procedure WRITE_STRING( in_var st: string; f, p: integer := -1;
                                           sp: char := ' ' );
var
  bl, el, len: integer;

begin
  GET_FORMAT( st.length, p, f, bl, len, el );
  WRITE_MCHAR( sp, bl );
  for i := 1 to len do WRITE$OBJECT( st.body[i] );
  WRITE_MCHAR( sp, el )
end WRITE_STRING;



[global 'PAS__WRITE_CHT']
procedure WRITE_CHARRAY( in_var chtb: packed array[$sz: integer] of char;
                                           f, p: integer := -1;
                                           sp: char := ' ' );
var
  bl, el, len: integer;

begin
  GET_FORMAT( $sz, p, f, bl, len, el );
  WRITE_MCHAR( sp, bl );
  for i := 1 to len do  WRITE$OBJECT( chtb[i] );
  WRITE_MCHAR( sp, el )
end WRITE_CHARRAY;



[global 'PAS__WRITE_FCHAR']
procedure WRITE_FCHAR( ch: char;
                       f, p: integer := 0;
                       rep:  integer := 1;
                       sp:   char := ' ' );
var
  bl, el, md: integer;

begin
  if rep < 1 then rep := 1;
  GET_FORMAT( rep, p, f, bl, md, el );
  WRITE_MCHAR( sp, bl );
  WRITE_MCHAR( ch, rep );
  WRITE_MCHAR( sp, el )
end WRITE_FCHAR;



[global 'PAS__PAGE']
procedure SKIP_PAGE( fi: text );
const
  ff = CHAR( 12 );

begin
  WRITE( fi, ff )
end SKIP_PAGE;

end.
