/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B3/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 72 ) = {
  5,   5, 105, 103, 112, 111, 119,  62,  62,  47, 104, 111, 109, 101,  47, 112,
105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95,
107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95, 115, 114,  99,
 95,  86,  51,  46,  49,  66,  51,  47,  99, 112,  97, 115,  95,  95, 105, 103,
112, 111, 119,  46, 112,  97, 115,   0
};




/* Procedure/Function : " igpow "  */
G PAS__IGPOWER(G F_z, SL F_n){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  G Rv0;
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+7;
  Ra.sl[6]=57; /* line # 57 */
  Rv0=1.000000000000000E+000;
  Ra.sl[6]=58; /* line # 58 */
  if (F_n<0) {
    Ra.sl[6]=60; /* line # 60 */
    F_n= -F_n;
    F_z=Rv0/F_z;
  }
  Ra.sl[6]=62; /* line # 62 */
  while (F_n>0){
    Ra.sl[6]=63; /* line # 63 */
    if (F_n&1) {
      Ra.sl[6]=65; /* line # 65 */
      F_n=F_n-1;
      Rv0=Rv0*F_z;
    }
    else {
      Ra.sl[6]=69; /* line # 69 */
      F_n=F_n/2;
      F_z=F_z*F_z;
    }
  }
  Ra.sl[6]=71; /* line # 71 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
