/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.1B2/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 88 ) = {
  8,   8, 100,  97, 116, 101,  95,  99, 104, 116,  63,  63,  47, 104, 111, 109,
101,  47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112,
115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95,
115, 114,  99,  95,  86,  51,  46,  49,  66,  50,  47,  99, 112,  97, 115,  95,
 95, 116, 105, 109,  99, 104, 116,  46, 112,  97, 115,   8,   8, 116, 105, 109,
101,  95,  99, 104, 116,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 40 ) = {
 74,  65,  78,  70,  69,  66,  77,  65,  82,  65,  80,  82,  77,  65,  89,  74,
 85,  78,  74,  85,  76,  65,  85,  71,  83,  69,  80,  79,  67,  84,  78,  79,
 86,  68,  69,  67,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(PAS__curtim, 40 );


/* Function/procedure prototypes. */
void PAS__N_TIME(V F_tmtb, SL F_ss, UB F_gmt);


/* Procedure/Function : " date_cht "  */
void PAS__DATE_CHT(V F_t, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=73; /* line # 73 */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Ra.sl[6]=74; /* line # 74 */
  Rv0=PAS__curtim.sl[3];
  Ra.sl[6]=75; /* line # 75 */
  Rv1=PAS__curtim.sl[4];
  Ra.sl[6]=76; /* line # 76 */
  Rv2=PAS__curtim.sl[5];
  Ra.sl[6]=77; /* line # 77 */
  if (F_sz>=11) {
    Ra.sl[6]=79; /* line # 79 */
    ((C *)F_t)[0]=(C)(Rv0/10+48);
    Ra.sl[6]=80; /* line # 80 */
    ((C *)F_t)[1]=(C)(PAS__I_MOD(Rv0,10)+48);
    Ra.sl[6]=81; /* line # 81 */
    ((C *)F_t)[2]=45;
    Ra.sl[6]=82; /* line # 82 */
    ((C *)F_t)[3]=Ri.c[Rv1*3-3];
    Ra.sl[6]=83; /* line # 83 */
    ((C *)F_t)[4]=Ri.c[Rv1*3-2];
    Ra.sl[6]=84; /* line # 84 */
    ((C *)F_t)[5]=Ri.c[Rv1*3-1];
    Ra.sl[6]=85; /* line # 85 */
    ((C *)F_t)[6]=45;
    Ra.sl[6]=86; /* line # 86 */
    ((C *)F_t)[7]=(C)(Rv2/1000+48);
    Rv2=PAS__I_MOD(Rv2,1000);
    Ra.sl[6]=87; /* line # 87 */
    ((C *)F_t)[8]=(C)(Rv2/100+48);
    Rv2=PAS__I_MOD(Rv2,100);
    Ra.sl[6]=88; /* line # 88 */
    ((C *)F_t)[9]=(C)(Rv2/10+48);
    Ra.sl[6]=89; /* line # 89 */
    ((C *)F_t)[10]=(C)(PAS__I_MOD(Rv2,10)+48);
    Ra.sl[6]=90; /* line # 90 */
    Rv3=12;
    for( Rf0=F_sz-11;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv3-1]=32;
      Rv3++;
    }
  }
  else {
    Ra.sl[6]=93; /* line # 93 */
    Rv4=1;
    for( Rf0=F_sz;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv4-1]=32;
      Rv4++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " time_cht "  */
void PAS__TIME_CHT(V F_t, SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+75;
  Ra.v[2]=Rd.s+10;
  Ra.sl[6]=103; /* line # 103 */
  PAS__N_TIME(PAS__curtim.s,9,0);
  Ra.sl[6]=104; /* line # 104 */
  Rv0=PAS__curtim.sl[0];
  Ra.sl[6]=105; /* line # 105 */
  Rv1=PAS__curtim.sl[1];
  Ra.sl[6]=106; /* line # 106 */
  Rv2=PAS__curtim.sl[2];
  Ra.sl[6]=107; /* line # 107 */
  if (F_sz>=8) {
    Ra.sl[6]=109; /* line # 109 */
    ((C *)F_t)[0]=(C)(Rv2/10+48);
    Ra.sl[6]=110; /* line # 110 */
    ((C *)F_t)[1]=(C)(PAS__I_MOD(Rv2,10)+48);
    Ra.sl[6]=111; /* line # 111 */
    ((C *)F_t)[2]=58;
    Ra.sl[6]=112; /* line # 112 */
    ((C *)F_t)[3]=(C)(Rv1/10+48);
    Ra.sl[6]=113; /* line # 113 */
    ((C *)F_t)[4]=(C)(PAS__I_MOD(Rv1,10)+48);
    Ra.sl[6]=114; /* line # 114 */
    ((C *)F_t)[5]=58;
    Ra.sl[6]=115; /* line # 115 */
    ((C *)F_t)[6]=(C)(Rv0/10+48);
    Ra.sl[6]=116; /* line # 116 */
    ((C *)F_t)[7]=(C)(PAS__I_MOD(Rv0,10)+48);
    Ra.sl[6]=117; /* line # 117 */
    Rv3=9;
    for( Rf0=F_sz-8;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv3-1]=32;
      Rv3++;
    }
  }
  else {
    Ra.sl[6]=120; /* line # 120 */
    Rv4=1;
    for( Rf0=F_sz;Rf0>0;Rf0-- ) {
      ((C *)F_t)[Rv4-1]=32;
      Rv4++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}
