#!/bin/sh
#
# File to install the Standard CPAS PASCAL Run Time Library and Compiler (by calling cpsh).
# Release  of 12-oct_2014 for support CPASCAL V3.0A - 
#
if test "$INSTALL" != "slave"
then
  DIR_NAM="cpas"        # The target directory is common for the whole of CPAS kits.
  DIR_ENV="etc/cpas"    # To Set Access to /etc for cpsh shell.
#
# Set all related directories for installation.
#
  . ./logicals.sh
#
  echo " PAS_DIR = $PAS_DIR"
fi
#
#----------------------------------------------------------------------
# Install paslib library and gen_msgfile task.
#----------------------------------------------------------------------
#
cp cpas_defs.h               $PAS_INC
cp cpas_defs.h               $PAS_DIR
cp cpas_rtl_err.dat          $PAS_DIR
cp current_system_id.dat     $PAS_DIR
cp system.make               $PAS_DIR
cp logicals.sh               $PAS_DIR
cp cpas_std_env.cpas_init    $PAS_DIR
#
make -f cpaslib.make clean
make -f cpaslib.make all
#
# Generate the Run Time Library Error Massage File.
#
echo " Create the Run Time Error Message Files."
$PAS_DIR/gen_msgfile cpasrtlerr.dat $PAS_DIR/cpas_rtl.err
$PAS_DIR/gen_msgfile cpsh_err.dat $ENV_DIR/cpsh.err
#
cp cpsh_env.std   $ENV_DIR
cp cpas_lib_version.dat $PAS_DIR
#
echo " "
echo " The CPAS PASCAL Library and Cpas Shell are now installed."
echo " "
#
export PASENV=$PAS_DIR
#
# Continue install with cpsh
#
cpsh install
#
