/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[2];

/* Define the local data section. */
static Blk( Rd, 1208 ) = {
 12,  12, 105, 110, 105, 116,  95, 112,  97, 116, 116, 101, 114, 110,  55,  55,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 114, 112, 119,
100,  97, 116,  97,  95, 115, 114,  99,  47, 118, 105, 101, 119,  51, 100,  95,
105, 110, 112,  46, 112,  97, 115,  17,  17, 112,  97, 116, 116, 101, 114, 110,
 95, 105, 110, 102, 111,  95,  99, 111, 112, 121,   9,   9, 105, 110, 105, 116,
 95, 108, 111,  97, 100,  21,  21, 115, 101, 116,  95, 112,  97, 116, 116, 101,
114, 110,  95, 115, 101, 108, 101,  99, 116, 105, 111, 110,  10,  10, 114, 112,
119, 102,  95, 101, 114, 114, 111, 114,  20,  20,  82, 101,  97, 100,  32,  80,
 97, 116, 116, 101, 114, 110,  32, 102, 111, 114, 109,  97, 116,  34,   9,   9,
 34,  32, 101, 114, 114, 111, 114,  58,  32,  14,  14,  86,  73,  69,  87,  45,
 51,  68,  45,  68,  65,  84,  65,  58,  32,  13,  13, 115, 107, 105, 112,  95,
105, 110, 112,  95,  99, 104,  97, 114,  13,  13, 101, 108, 108, 105, 109, 105,
110,  97, 116, 101,  95,  99, 114,  10,  10, 115, 107, 105, 112,  95, 115, 112,
 97,  99, 101,  12,  12, 103, 101, 116,  95, 110, 101, 119,  95, 108, 105, 110,
101,  12,  12, 103, 101, 116,  95, 111, 110, 101,  95, 119, 111, 114, 100,  17,
 17, 103, 101, 116,  95, 114, 112, 119, 115, 116, 100,  95, 102, 111, 114, 109,
 97, 116,   8,   8,  70,  80,  68,  95,  68,  65,  84,  65,  20,  20,  66,  97,
100,  32, 100,  97, 116,  97,  32, 102, 105, 108, 101,  32, 102, 111, 114, 109,
 97, 116,   3,   3,  69,  79,  70,   7,   7,  80,  65,  84,  84,  69,  82,  78,
 60,  60,  70, 111, 114, 109,  97, 116,  32, 101, 114, 114, 111, 114,  32,  58,
 32, 101,  97,  99, 104,  32, 112,  97, 116, 116, 101, 114, 110,  32, 109, 117,
115, 116,  32,  98, 101, 103, 105, 110,  32,  98, 121,  32, 116, 104, 101,  32,
 34,  80,  65,  84,  84,  69,  82,  78,  34,  32, 119, 111, 114, 100,  31,  31,
 73, 110,  99, 111, 109, 112, 108, 101, 116, 101,  32,  80,  97, 116, 116, 101,
114, 110,  44,  32,  69,  79,  70,  32, 114, 101,  97,  99, 104, 101, 100,   5,
  5,  76,  65,  66,  69,  76,   8,   8,  73,  68,  78,  85,  77,  66,  69,  82,
  5,   5,  78,  85,  77,  79,  82,   5,   5,  68,  65,  84,  69,  72,   6,   6,
 83,  65,  77,  80,  76,  69,   6,   6,  76,  65,  77,  66,  68,  65,   4,   4,
 84,  69,  77,  80,   7,   7,  77,  79,  78,  84,  73,  77,  69,  11,  11,  84,
 82,  65,  78,  83,  76,  65,  84,  73,  79,  78,   9,   9,  80,  65,  82,  65,
 77,  69,  84,  69,  82,  11,  11,  79,  82,  73,  69,  78,  84,  65,  84,  73,
 79,  78,   4,   4,  68,  65,  84,  65,  61,  61,  70, 111, 114, 109,  97, 116,
 32, 101, 114, 114, 111, 114,  32,  58,  32,  84, 119, 111,  32,  68,  65,  84,
 65,  32,  66,  76,  79,  67,  75,  32, 100, 105, 114, 101,  99, 116, 105, 118,
101, 115,  32, 102, 111, 114,  32, 116, 104, 101,  32, 115,  97, 109, 101,  32,
112,  97, 116, 116, 101, 114, 110,   3,   3,  69,  79,  68,   7,   7,  80,  65,
 84,  84,  69,  82,  78,   3,   3,  69,  79,  70,  14,  14, 103, 101, 116,  95,
100,  49,  98,  95, 102, 111, 114, 109,  97, 116,   3,   3,  68,  49,  66,   6,
  6,  45,  49,  48,  48,  48,  48,  14,  14, 103, 101, 116,  95, 120, 121, 100,
 95, 102, 111, 114, 109,  97, 116,   6,   6,  88,  89,  68,  65,  84,  65,   1,
  1,  35,   6,   6,  88,  89,  68,  65,  84,  65,   1,   1,  35,   5,   5,  73,
 78,  84,  69,  82,   4,   4,  84,  69,  77,  80,  11,  11,  84,  69,  77,  80,
 69,  82,  65,  84,  85,  82,  69,   7,   7,  77,  79,  78,  73,  84,  79,  82,
  6,   6,  76,  65,  77,  66,  68,  65,   7,   7,  76,  65,  77,  66,  68,  65,
 50,   7,   7,  76,  65,  77,  66,  68,  65,  82,   6,   6,  83,  65,  77,  80,
 76,  69,   5,   5,  68,  65,  84,  69,  72,   6,   6,  79,  82,  73,  69,  78,
 84,  16,  16, 103, 101, 116,  95, 105, 110, 108, 114, 120,  95, 102, 111, 114,
109,  97, 116,   6,   6,  73,  78,  69,  76,  82,  88,  15,  15, 103, 101, 116,
 95, 115, 114,  97, 119,  95, 102, 111, 114, 109,  97, 116,  12,  12, 103, 101,
116,  95, 112,  97, 116, 116, 101, 114, 110, 115,  47,  47,  32,  42,  42,  42,
 32,  86,  73,  69,  87,  45,  51,  68,  45,  68,  65,  84,  65,  32,  69, 114,
114, 111, 114,  58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112, 101, 110,
 32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  34,   6,   6,  34,  46,  32,
 42,  42,  42,  71,  71,  32,  42,  42,  42,  32,  86,  73,  69,  87,  45,  51,
 68,  45,  68,  65,  84,  65,  32,  69, 114, 114, 111, 114,  58,  32,  85, 110,
115, 117, 112, 112, 111, 114, 116, 101, 100,  32, 111, 114,  32, 117, 110, 105,
109, 112, 108, 101, 109, 101, 110, 116, 101, 100,  32, 105, 110, 112, 117, 116,
 32, 102, 111, 114, 109,  97, 116,  46,  32,  42,  42,  42,  20,  20,  32,  86,
 73,  69,  87,  45,  51,  68,  45,  68,  65,  84,  65,  32,  70, 111, 117, 110,
100,  32,  23,  23,  32, 112,  97, 116, 116, 101, 114, 110, 115,  32, 105, 110,
 32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  34,   2,   2,  34,  46,  62,
 62,  32,  42,  42,  42,  32,  86,  73,  69,  87,  45,  51,  68,  45,  68,  65,
 84,  65,  32,  69, 114, 114, 111, 114,  58,  32,  67,  97, 110, 110, 111, 116,
 32, 119, 111, 114, 107,  32, 119, 105, 116, 104, 111, 117, 116,  32,  80,  97,
116, 116, 101, 114, 110,  32,  97, 110, 100,  32, 101, 120, 105, 116,  46,  17,
 17,  71, 108, 111,  98,  97, 108,  32,  83, 116,  97, 116, 105, 115, 116, 105,
 99, 115,  38,  38,  77, 105, 110, 105, 109, 117, 109,  32,  97, 110, 100,  32,
109,  97, 120, 105, 109, 117, 109,  32, 111, 102,  32,  50,  42,  84, 104, 101,
116,  97,  32,  65, 110, 103, 108, 101,  58,  32,   2,   2,  44,  32,  38,  38,
 77, 105, 110, 105, 109, 117, 109,  32,  97, 110, 100,  32, 109,  97, 120, 105,
109, 117, 109,  32, 111, 102,  32,  84, 101, 109, 112, 101, 114,  97, 116, 117,
114, 101,  58,  32,  32,  32,   2,   2,  44,  32,  38,  38,  77, 105, 110, 105,
109, 117, 109,  32,  97, 110, 100,  32, 109,  97, 120, 105, 109, 117, 109,  32,
111, 102,  32, 105, 110, 116, 101, 110, 115, 105, 116, 105, 101, 115,  58,  32,
 32,  32,   2,   2,  44,  32,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 296 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_pat_last;
extern Blk(V_mai_parm, 1312 );
extern Blk(V_tbpat, 256 );
extern SL V_npat;
extern F V_tmin;
extern F V_tmax;
extern F V_thmin;
extern F V_thmax;
extern F V_gmin;
extern F V_gmax;
extern F V_smin;
extern F V_smax;
extern V V_pat_first;
extern V V_sel_pat;
extern SL V_ndiat;
extern UB V_funcs;
extern Blk(V_tbtem, 128 );
extern V PAS__f_output;
extern V V_inp;
extern UB V_dat_celsius;
extern Blk(V_inp_name, 264 );
extern V V_pat_sel;
extern SL PAS__iostatus;
extern Blk(V_str_msg, 264 );
extern UB V_inp_frm;




/* Procedure/Function : " init_pattern "  */
void VIEW3D__INP_init_pattern(V F_r){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=65; /* line # 65 */
  Ra.sl[3]=67; /* line # 67 */
  ((V *)F_r)[1]=NULL;
  Ra.sl[3]=68; /* line # 68 */
  ((V *)F_r)[2]=V_pat_last;
  Ra.sl[3]=69; /* line # 69 */
  ((V *)F_r)[3]=NULL;
  Ra.sl[3]=70; /* line # 70 */
  ((SL *)F_r)[4]=0;
  Ra.sl[3]=71; /* line # 71 */
  ((SL *)F_r)[5]=-1;
  Ra.sl[3]=72; /* line # 72 */
  ((UB *)F_r)[25]=0;
  Ra.sl[3]=73; /* line # 73 */
  ((UB *)F_r)[89]=0;
  Ra.sl[3]=74; /* line # 74 */
  ((UB *)F_r)[153]=0;
  Ra.sl[3]=75; /* line # 75 */
  ((F *)F_r)[54]=(F)0.000000E-01;
  Ra.sl[3]=76; /* line # 76 */
  ((F *)F_r)[55]=(F)0.000000E-01;
  Ra.sl[3]=78; /* line # 78 */
  ((F *)F_r)[56]=V_mai_parm.f[322];
  Ra.sl[3]=79; /* line # 79 */
  ((F *)F_r)[57]=(F)0.000000E-01;
  Ra.sl[3]=80; /* line # 80 */
  ((F *)F_r)[58]=(F)0.000000E-01;
  Ra.sl[3]=81; /* line # 81 */
  ((F *)F_r)[59]=(F)0.000000E-01;
  Ra.sl[3]=82; /* line # 82 */
  ((F *)F_r)[60]=(F)0.000000E-01;
  Ra.sl[3]=83; /* line # 83 */
  ((F *)F_r)[61]=(F)0.000000E-01;
  Ra.sl[3]=84; /* line # 84 */
  ((F *)F_r)[62]=V_mai_parm.f[323];
  Ra.sl[3]=85; /* line # 85 */
  ((F *)F_r)[63]=(F)0.000000E-01;
  Ra.sl[3]=86; /* line # 86 */
  ((F *)F_r)[64]=(F)0.000000E-01;
  Ra.sl[3]=87; /* line # 87 */
  ((F *)F_r)[65]=(F)0.000000E-01;
  Ra.sl[3]=88; /* line # 88 */
  ((F *)F_r)[66]=(F)0.000000E-01;
  Ra.sl[3]=89; /* line # 89 */
  ((F *)F_r)[67]=(F)0.000000E-01;
  Ra.sl[3]=90; /* line # 90 */
  ((F *)F_r)[68]=(F)1.000000E+00;
  Ra.sl[3]=91; /* line # 91 */
  ((F *)F_r)[69]=(F)0.000000E-01;
  Ra.sl[3]=92; /* line # 92 */
  ((F *)F_r)[70]=(F)0.000000E-01;
  Ra.sl[3]=93; /* line # 93 */
  ((F *)F_r)[71]=(F)0.000000E-01;
  Ra.sl[3]=94; /* line # 94 */
  ((F *)F_r)[72]=(F)0.000000E-01;
  Ra.sl[3]=95; /* line # 95 */
  ((F *)F_r)[73]=(F)0.000000E-01;
  Ra.sl[3]=96; /* line # 96 */
  ((F *)F_r)[74]=(F)0.000000E-01;
  Ra.sl[3]=97; /* line # 97 */
  ((F *)F_r)[75]=(F)0.000000E-01;
  Ra.sl[3]=98; /* line # 98 */
  ((F *)F_r)[76]=(F)0.000000E-01;
  Ra.sl[3]=99; /* line # 99 */
  ((SL *)F_r)[77]=0;
  Ra.sl[3]=100; /* line # 100 */
  ((SL *)F_r)[78]=0;
  Ra.sl[3]=101; /* line # 101 */
  ((SL *)F_r)[79]=0;
  Ra.sl[3]=102; /* line # 102 */
  ((SL *)F_r)[80]=0;
  Ra.sl[3]=103; /* line # 103 */
  ((F *)F_r)[81]=(F)1.000000E+010;
  Ra.sl[3]=104; /* line # 104 */
  ((F *)F_r)[82]= -((F *)F_r)[81];
  Ra.sl[3]=105; /* line # 105 */
  ((F *)F_r)[83]=(F)1.000000E+010;
  Ra.sl[3]=106; /* line # 106 */
  ((F *)F_r)[84]= -((F *)F_r)[83];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pattern_info_copy "  */
void VIEW3D__INP_pattern_info_copy(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+71;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=114; /* line # 114 */
  Ra.sl[3]=116; /* line # 116 */
  ((V *)F_dst)[1]=NULL;
  Ra.sl[3]=117; /* line # 117 */
  ((V *)F_dst)[2]=V_pat_last;
  Ra.sl[3]=118; /* line # 118 */
  ((V *)F_dst)[3]=((V *)F_src)[3];
  Ra.sl[3]=119; /* line # 119 */
  ((SL *)F_dst)[4]=((SL *)F_src)[4];
  Ra.sl[3]=120; /* line # 120 */
  ((SL *)F_dst)[5]=((SL *)F_src)[5];
  Ra.sl[3]=121; /* line # 121 */
  PAS__STR_TO_STR(F_dst+24,F_src+24);
  Ra.sl[3]=122; /* line # 122 */
  PAS__STR_TO_STR(F_dst+88,F_src+88);
  Ra.sl[3]=123; /* line # 123 */
  PAS__STR_TO_STR(F_dst+152,F_src+152);
  Ra.sl[3]=124; /* line # 124 */
  ((F *)F_dst)[54]=((F *)F_src)[54];
  Ra.sl[3]=125; /* line # 125 */
  ((F *)F_dst)[55]=((F *)F_src)[55];
  Ra.sl[3]=127; /* line # 127 */
  ((F *)F_dst)[56]=((F *)F_src)[56];
  Ra.sl[3]=128; /* line # 128 */
  ((F *)F_dst)[57]=((F *)F_src)[57];
  Ra.sl[3]=129; /* line # 129 */
  ((F *)F_dst)[58]=((F *)F_src)[58];
  Ra.sl[3]=130; /* line # 130 */
  ((F *)F_dst)[59]=((F *)F_src)[59];
  Ra.sl[3]=131; /* line # 131 */
  ((F *)F_dst)[60]=((F *)F_src)[60];
  Ra.sl[3]=132; /* line # 132 */
  ((F *)F_dst)[61]=((F *)F_src)[61];
  Ra.sl[3]=133; /* line # 133 */
  ((F *)F_dst)[62]=((F *)F_src)[62];
  Ra.sl[3]=134; /* line # 134 */
  ((F *)F_dst)[63]=((F *)F_src)[63];
  Ra.sl[3]=135; /* line # 135 */
  ((F *)F_dst)[64]=((F *)F_src)[64];
  Ra.sl[3]=136; /* line # 136 */
  ((F *)F_dst)[65]=((F *)F_src)[65];
  Ra.sl[3]=137; /* line # 137 */
  ((F *)F_dst)[66]=((F *)F_src)[66];
  Ra.sl[3]=138; /* line # 138 */
  ((F *)F_dst)[67]=((F *)F_src)[67];
  Ra.sl[3]=139; /* line # 139 */
  ((F *)F_dst)[68]=((F *)F_src)[68];
  Ra.sl[3]=140; /* line # 140 */
  ((F *)F_dst)[69]=((F *)F_src)[69];
  Ra.sl[3]=141; /* line # 141 */
  ((F *)F_dst)[70]=((F *)F_src)[70];
  Ra.sl[3]=142; /* line # 142 */
  ((F *)F_dst)[71]=((F *)F_src)[71];
  Ra.sl[3]=143; /* line # 143 */
  ((F *)F_dst)[72]=((F *)F_src)[72];
  Ra.sl[3]=144; /* line # 144 */
  ((F *)F_dst)[73]=((F *)F_src)[73];
  Ra.sl[3]=145; /* line # 145 */
  ((F *)F_dst)[74]=((F *)F_src)[74];
  Ra.sl[3]=146; /* line # 146 */
  ((F *)F_dst)[75]=((F *)F_src)[75];
  Ra.sl[3]=147; /* line # 147 */
  ((F *)F_dst)[76]=((F *)F_src)[76];
  Ra.sl[3]=148; /* line # 148 */
  ((SL *)F_dst)[77]=((SL *)F_src)[77];
  Ra.sl[3]=149; /* line # 149 */
  ((SL *)F_dst)[78]=((SL *)F_src)[78];
  Ra.sl[3]=150; /* line # 150 */
  ((SL *)F_dst)[79]=((SL *)F_src)[79];
  Ra.sl[3]=151; /* line # 151 */
  ((SL *)F_dst)[80]=((SL *)F_src)[80];
  Ra.sl[3]=152; /* line # 152 */
  ((F *)F_dst)[81]=((F *)F_src)[81];
  Ra.sl[3]=153; /* line # 153 */
  ((F *)F_dst)[82]=((F *)F_src)[82];
  Ra.sl[3]=154; /* line # 154 */
  ((F *)F_dst)[83]=((F *)F_src)[83];
  Ra.sl[3]=155; /* line # 155 */
  ((F *)F_dst)[84]=((F *)F_src)[84];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_load "  */
void P_init_load(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+90;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=168; /* line # 168 */
  Rv0=1;
  for( Rf0=32;Rf0>0;Rf0-- ) {
    V_tbpat.v[PAS__RANGE(Rv0,1,64)-1]=NULL;
    Rv0++;
  }
  Ra.sl[3]=169; /* line # 169 */
  V_npat=0;
  Ra.sl[3]=171; /* line # 171 */
  V_tmin=(F)1.000000E+010;
  V_tmax= -V_tmin;
  Ra.sl[3]=172; /* line # 172 */
  V_thmin=(F)1.000000E+010;
  V_thmax= -V_thmin;
  Ra.sl[3]=173; /* line # 173 */
  V_gmin=(F)1.000000E+010;
  V_gmax= -V_gmin;
  Ra.sl[3]=174; /* line # 174 */
  V_smin=(F)1.000000E+010;
  V_smax= -V_smin;
  Ra.sl[3]=177; /* line # 177 */
  while (V_pat_first!=NULL){
    Ra.sl[3]=179; /* line # 179 */
    Rv1=V_pat_first;
    Ra.sl[3]=180; /* line # 180 */
    V_pat_first=((V *)Rv1)[1];
    Ra.sl[3]=181; /* line # 181 */
    PAS__DISPOSE(&Rv1);
  }
  Ra.sl[3]=183; /* line # 183 */
  V_pat_last=NULL;
  Ra.sl[3]=184; /* line # 184 */
  V_sel_pat=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_pattern_selection "  */
void P_set_pattern_selection(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+101;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=198; /* line # 198 */
  V_smin=(F)1.000000E+010;
  V_smax= -V_smin;
  Ra.sl[3]=199; /* line # 199 */
  Rv0=0;
  Ra.sl[3]=200; /* line # 200 */
  Rv1=V_pat_first;
  Ra.sl[3]=201; /* line # 201 */
  Rv2=1;
  Ra.sl[3]=202; /* line # 202 */
  while (Rv1!=NULL){
    Ra.sl[3]=204; /* line # 204 */
    Rv3=0;
    Ra.sl[3]=205; /* line # 205 */
    if (!Rv3) {
      Ra.sl[3]=206; /* line # 206 */
      Rv4=1;
      for( Rf0=V_ndiat;Rf0>0;Rf0-- ) {
        Ra.sl[3]=207; /* line # 207 */
        if (8&V_funcs) {
          Ra.sl[3]=209; /* line # 209 */
          if (fabs((((F *)Rv1)[63]-V_tbtem.f[PAS__RANGE(Rv4,1,32)-1])-(F)2.731600E+02)
          <(F)1.000000E-03) Rv3=1;
        }
        else {
          Ra.sl[3]=211; /* line # 211 */
          if (fabs(((F *)Rv1)[63]-V_tbtem.f[PAS__RANGE(Rv4,1,32)-1])<(F)1.000000E-03)
           Rv3=1;
        }
        Rv4++;
      }
    }
    Ra.sl[3]=212; /* line # 212 */
    if (Rv3) {
      Ra.sl[3]=214; /* line # 214 */
      if (V_smin>((F *)Rv1)[83]) V_smin=((F *)Rv1)[83];
      Ra.sl[3]=215; /* line # 215 */
      if (V_smax<((F *)Rv1)[84]) V_smax=((F *)Rv1)[84];
      Ra.sl[3]=216; /* line # 216 */
      Rv0=Rv0+1;
      Ra.sl[3]=217; /* line # 217 */
      V_tbpat.v[PAS__RANGE(Rv0,1,64)-1]=Rv1;
    }
    Ra.sl[3]=219; /* line # 219 */
    Rv2=Rv2+1;
    Ra.sl[3]=220; /* line # 220 */
    Rv1=((V *)Rv1)[1];
  }
  Ra.sl[3]=222; /* line # 222 */
  Rv5=Rv0+1;
  for( Rf0=65-(Rv0+1);Rf0>0;Rf0-- ) {
    V_tbpat.v[PAS__RANGE(Rv5,1,64)-1]=NULL;
    Rv5++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rpwf_error "  */
void VIEW3D__INP_PRC_00000000(V F_msg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+124;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=242; /* line # 242 */
  PAS__VWRITE_INIT(Lx[1].s,1);
  PAS__WRITE_STR(Rd.s+136,-1,-1,32);
  PAS__WRITE_STR(Lx[1].s+257,-1,-1,32);
  PAS__WRITE_STR(Rd.s+158,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=243; /* line # 243 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+169,-1,-1,32);
  PAS__WRITE_STR(Lx[1].s,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=244; /* line # 244 */
  longjmp((void *)Lx[1].v[74],1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_inp_char "  */
void VIEW3D__INP_PRC_00000001(SL F_nn){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  C Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=254; /* line # 254 */
  for( Rf0=F_nn;Rf0>0;Rf0-- ) {
    PAS__SELECT_INP(V_inp);
    PAS__READ_CHAR(&Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " elliminate_cr "  */
void VIEW3D__INP_PRC_00000002(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+200;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=264; /* line # 264 */
  Ra.sl[3]=265; /* line # 265 */
  if (((UB *)F_st)[1]>0) {
    Ra.sl[3]=266; /* line # 266 */
    if (((C *)F_st)[PAS__RANGE(((UB *)F_st)[1],1,(UL)((UB *)F_st)[0])+1]==13) ((
    UB *)F_st)[1]=((UB *)F_st)[1]-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_space "  */
void VIEW3D__INP_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=285; /* line # 285 */
  while (Lx[0].sl[0]>0&&Lx[0].c[PAS__RANGE(Lx[0].sl[0],1,(UL)Lx[0].ub[4])+5]<=32)

  Lx[0].sl[0]=Lx[0].sl[0]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_new_line "  */
void VIEW3D__INP_PRC_00000005(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=291; /* line # 291 */
  Lx[0].ub[5]=0;
  Ra.sl[3]=292; /* line # 292 */
  while (!PAS__EOF(V_inp)&&Lx[0].ub[5]==0){
    Ra.sl[3]=294; /* line # 294 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Lx[0].s+4,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=295; /* line # 295 */
    if (Lx[0].ub[5]>0) {
      Ra.sl[3]=296; /* line # 296 */
      if (Lx[0].c[PAS__RANGE(1,1,(UL)Lx[0].ub[4])+5]!=35&&Lx[0].c[PAS__RANGE(1,1,
      (UL)Lx[0].ub[4])+5]!=33) {
        Ra.sl[3]=298; /* line # 298 */
        while (Lx[0].ub[5]>0&&Lx[0].c[PAS__RANGE(Lx[0].ub[5],1,(UL)Lx[0].ub[4])+
5]<=32)
        Lx[0].ub[5]=Lx[0].ub[5]-1;
        Ra.sl[3]=299; /* line # 299 */
        Lx[0].sl[0]=1;
      }
      else {
        Ra.sl[3]=301; /* line # 301 */
        Lx[0].ub[5]=0;
      }
    }
    else {
      Ra.sl[3]=303; /* line # 303 */
      if (PAS__EOF(V_inp)) Lx[0].ub[261]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_one_word "  */
void VIEW3D__INP_PRC_00000006(V F_word, UB F_bwf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+241;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=311; /* line # 311 */
  ((UB *)F_word)[1]=0;
  Ra.sl[3]=312; /* line # 312 */
  while (Lx[0].sl[0]>=0&&((UB *)F_word)[1]==0){
    Ra.sl[3]=313; /* line # 313 */
    PAS__VREAD_INIT(Lx[0].s+6,(SL)Lx[0].ub[5],Lx[0].sl);
    PAS__READ_STR(F_word,((UB *)F_word)[0],1);
    PAS__READ_EOLN();
  }
  Ra.sl[3]=314; /* line # 314 */
  if (((UB *)F_word)[1]>0&&F_bwf) {
    Ra.sl[3]=316; /* line # 316 */
    PAS__SET_CASE(F_word,1);
    Ra.sl[3]=317; /* line # 317 */
    if (((UB *)F_word)[1]>16) ((UB *)F_word)[1]=16;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_rpwstd_format "  */
void VIEW3D__INP_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 672 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  register UB Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  register SL Rv8;
  F Rv9;
  F Rv10;
  SL Rv11;
  register V Rv12;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[4]=255;
  Ra.ub[262]=32;
  Ra.sl[74]=1;
  Ra.ub[320]=62;
  Ra.ub[384]=62;
  Ra.ub[448]=62;
  Ra.v[163]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+652;
  Ra.v[164]=Rd.s+255;
  Ra.v[165]=Rd.s+14;
  Ra.sl[166]=324; /* line # 324 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+274);
  Ra.sl[166]=325; /* line # 325 */
  Ra.ub[261]=0;
  Ra.sl[166]=326; /* line # 326 */
  Rv0=0;
  Ra.sl[166]=327; /* line # 327 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_STR(Ra.s+262,Ra.ub[262],1);
  PAS__READ_EOLN();
  Ra.sl[166]=328; /* line # 328 */
  PAS__SET_CASE(Ra.s+262,1);
  Ra.sl[166]=329; /* line # 329 */
  if (PAS__NE_STR(Ra.s+262,Lx[1].s+257)) VIEW3D__INP_PRC_00000000(Rd.s+284);
  Ra.sl[166]=331; /* line # 331 */
  VIEW3D__INP_PRC_00000005();
  Ra.sl[166]=332; /* line # 332 */
  VIEW3D__INP_PRC_00000006(Ra.s+262,1);
  Ra.sl[166]=333; /* line # 333 */
  while (!PAS__EOF(V_inp)&&PAS__NE_STR(Ra.s+262,Rd.s+306)){
    Ra.sl[166]=335; /* line # 335 */
    if (PAS__NE_STR(Ra.s+262,Rd.s+311)) VIEW3D__INP_PRC_00000000(Rd.s+320);
    Ra.sl[166]=337; /* line # 337 */
    VIEW3D__INP_init_pattern(Ra.s+296);
    Ra.sl[166]=339; /* line # 339 */
    Rv0=Rv0+1;
    Ra.sl[166]=341; /* line # 341 */
    Rv1=0;
    Ra.sl[166]=343; /* line # 343 */
    Ra.sl[166]=345; /* line # 345 */
    Rv2=NULL;
    Ra.sl[166]=346; /* line # 346 */
    VIEW3D__INP_PRC_00000004();
    PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
    PAS__READ_STR(Ra.s+448,0,0);
    PAS__READ_EOLN();
    while (1){
      Ra.sl[166]=348; /* line # 348 */
      if (Rv1) Rv1=0;
      else while (1){
        Ra.sl[166]=351; /* line # 351 */
        VIEW3D__INP_PRC_00000005();
        Ra.sl[166]=352; /* line # 352 */
        if (Ra.ub[261]) VIEW3D__INP_PRC_00000000(Rd.s+382);
        Ra.sl[166]=353; /* line # 353 */
        VIEW3D__INP_PRC_00000006(Ra.s+262,1);
        if (Ra.ub[263]>0)  break;
      }
      Ra.sl[166]=356; /* line # 356 */
      if (PAS__EQ_STR(Ra.s+262,Rd.s+415)) {
        Ra.sl[166]=357; /* line # 357 */
        VIEW3D__INP_PRC_00000004();
        Ra.sl[166]=358; /* line # 358 */
        Rv3=PAS__RANGE((Ra.ub[5]-Ra.sl[0])+1,0,255);
        Rv4=PAS__NEW((SL)Rv3+8);
        ((UB *)Rv4)[0]=Rv3;
        Ra.sl[166]=359; /* line # 359 */
        PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
        PAS__READ_CHT(Rv4+8,(UL)((UB *)Rv4)[0],0,0);
        PAS__READ_EOLN();
        Ra.sl[166]=360; /* line # 360 */
        ((V *)Rv4)[1]=NULL;
        Ra.sl[166]=361; /* line # 361 */
        if (Ra.v[77]==NULL) Ra.v[77]=Rv4;
        else {
          Ra.sl[166]=362; /* line # 362 */
          ((V *)Rv5)[1]=Rv4;
        }
        Ra.sl[166]=363; /* line # 363 */
        Rv5=Rv4;
      }
      else {
        Ra.sl[166]=366; /* line # 366 */
        if (PAS__EQ_STR(Ra.s+262,Rd.s+422)) {
          PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
          PAS__READ_SL(Ra.sl+78,0);
          PAS__READ_EOLN();
        }
        else {
          Ra.sl[166]=368; /* line # 368 */
          if (PAS__EQ_STR(Ra.s+262,Rd.s+432)) {
            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
            PAS__READ_SL(Ra.sl+79,0);
            PAS__READ_EOLN();
          }
          else {
            Ra.sl[166]=370; /* line # 370 */
            if (PAS__EQ_STR(Ra.s+262,Rd.s+439)) VIEW3D__INP_PRC_00000006(Ra.s+320,1);
            else {
              Ra.sl[166]=372; /* line # 372 */
              if (PAS__EQ_STR(Ra.s+262,Rd.s+446)) {
                VIEW3D__INP_PRC_00000004();
                PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                PAS__READ_STR(Ra.s+384,0,0);
                PAS__READ_EOLN();
              }
              else {
                Ra.sl[166]=374; /* line # 374 */
                if (PAS__EQ_STR(Ra.s+262,Rd.s+454)) {
                  PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                  PAS__READ_SNGL(Ra.f+140,0);
                  PAS__READ_SNGL(Ra.f+141,0);
                  PAS__READ_SNGL(Ra.f+142,0);
                  PAS__READ_EOLN();
                }
                else {
                  Ra.sl[166]=376; /* line # 376 */
                  if (PAS__EQ_STR(Ra.s+262,Rd.s+462)) {
                    PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                    PAS__READ_SNGL(Ra.f+137,0);
                    PAS__READ_SNGL(Ra.f+138,0);
                    PAS__READ_SNGL(Ra.f+139,0);
                    PAS__READ_EOLN();
                  }
                  else {
                    Ra.sl[166]=378; /* line # 378 */
                    if (PAS__EQ_STR(Ra.s+262,Rd.s+468)) {
                      PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                      PAS__READ_SNGL(Ra.f+128,0);
                      PAS__READ_SNGL(Ra.f+129,0);
                      PAS__READ_EOLN();
                    }
                    else {
                      Ra.sl[166]=380; /* line # 380 */
                      if (PAS__EQ_STR(Ra.s+262,Rd.s+477)) {
                        PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                        PAS__READ_SNGL(Ra.f+134,0);
                        PAS__READ_SNGL(Ra.f+135,0);
                        PAS__READ_EOLN();
                      }
                      else {
                        Ra.sl[166]=382; /* line # 382 */
                        if (PAS__EQ_STR(Ra.s+262,Rd.s+490)) {
                          Ra.sl[166]=383; /* line # 383 */
                          PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                          PAS__READ_SL(&Rv6,0);
                          PAS__READ_EOLN();
                          Ra.sl[166]=384; /* line # 384 */
                          switch (Rv6) {
                            case 0:Ra.sl[166]=385; /* line # 385 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SL(Ra.sl+153,0);
                            PAS__READ_EOLN();
                            break;
                            case 1:Ra.sl[166]=386; /* line # 386 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SL(Ra.sl+154,0);
                            PAS__READ_EOLN();
                            break;
                            case 2:Ra.sl[166]=387; /* line # 387 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+143,0);
                            PAS__READ_EOLN();
                            break;
                            case 3:Ra.sl[166]=388; /* line # 388 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+144,0);
                            PAS__READ_EOLN();
                            break;
                            case 4:Ra.sl[166]=389; /* line # 389 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+145,0);
                            PAS__READ_EOLN();
                            break;
                            case 5:Ra.sl[166]=390; /* line # 390 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+146,0);
                            PAS__READ_EOLN();
                            break;
                            case 6:Ra.sl[166]=391; /* line # 391 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+147,0);
                            PAS__READ_EOLN();
                            break;
                            case 7:Ra.sl[166]=392; /* line # 392 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+148,0);
                            PAS__READ_EOLN();
                            break;
                            case 8:Ra.sl[166]=393; /* line # 393 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+149,0);
                            PAS__READ_EOLN();
                            break;
                            case 9:Ra.sl[166]=394; /* line # 394 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+150,0);
                            PAS__READ_EOLN();
                            break;
                            default:break;
                          }
                        }
                        else {
                          Ra.sl[166]=399; /* line # 399 */
                          if (PAS__EQ_STR(Ra.s+262,Rd.s+501)) {
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+131,0);
                            PAS__READ_SNGL(Ra.f+132,0);
                            PAS__READ_SNGL(Ra.f+133,0);
                            PAS__READ_EOLN();
                          }
                          else {
                            Ra.sl[166]=401; /* line # 401 */
                            if (PAS__EQ_STR(Ra.s+262,Rd.s+514)) {
                              Ra.sl[166]=403; /* line # 403 */
                              if (Rv2!=NULL) VIEW3D__INP_PRC_00000000(Rd.s+520);
                              Ra.sl[166]=404; /* line # 404 */
                              PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                              PAS__READ_SL(&Rv7,0);
                              PAS__READ_EOLN();
                              Ra.sl[166]=405; /* line # 405 */
                              Rv8=Rv7;
                              Rv2=PAS__NEW(Rv8*16+340);
                              ((SL *)Rv2)[0]=Rv8;
                              ((UB *)Rv2)[24]=62;
                              ((UB *)Rv2)[88]=62;
                              ((UB *)Rv2)[152]=62;
                              Ra.sl[166]=406; /* line # 406 */
                              Ra.f[155]=(F)1.000000E+010;
                              Ra.f[156]= -Ra.f[155];
                              Ra.sl[166]=407; /* line # 407 */
                              Rv9=(F)1.000000E+010;
                              Rv10= -Rv9;
                              Ra.sl[166]=409; /* line # 409 */
                              Rv11=1;
                              for( Rf0=Rv7;Rf0>0;Rf0-- ) {
                                Ra.sl[166]=410; /* line # 410 */
                                Rv12=(((S *)Rv2)+PAS__RANGE(Rv11,1,((SL *)Rv2)[0]
                                )*16+324);
                                Ra.sl[166]=412; /* line # 412 */
                                VIEW3D__INP_PRC_00000005();
                                Ra.sl[166]=413; /* line # 413 */
                                PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                                PAS__READ_SW(((SW *)Rv12)+6,0);
                                PAS__READ_SNGL(((F *)Rv12),0);
                                PAS__READ_SNGL(((F *)Rv12)+1,0);
                                PAS__READ_EOLN();
                                Ra.sl[166]=414; /* line # 414 */
                                if (Ra.sl[0]>0) {
                                  PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                                  PAS__READ_SNGL(((F *)Rv12)+2,0);
                                  PAS__READ_EOLN();
                                }
                                else {
                                  Ra.sl[166]=415; /* line # 415 */
                                  ((F *)Rv12)[2]=sqrt(((F *)Rv12)[1]);
                                }
                                Ra.sl[166]=416; /* line # 416 */
                                if (Rv9>((F *)Rv12)[1]) Rv9=((F *)Rv12)[1];
                                Ra.sl[166]=417; /* line # 417 */
                                if (Rv10<((F *)Rv12)[1]) Rv10=((F *)Rv12)[1];
                                Ra.sl[166]=418; /* line # 418 */
                                if (Ra.f[156]<((F *)Rv12)[0]) Ra.f[156]=((F *)Rv12)
                                [0];
                                Ra.sl[166]=419; /* line # 419 */
                                if (Ra.f[155]>((F *)Rv12)[0]) Ra.f[155]=((F *)Rv12)
                                [0];
                                Ra.sl[166]=420; /* line # 420 */
                                ((UB *)Rv12)[14]=0;
                                Rv11++;
                              }
                              Ra.sl[166]=423; /* line # 423 */
                              VIEW3D__INP_PRC_00000005();
                              Ra.sl[166]=424; /* line # 424 */
                              VIEW3D__INP_PRC_00000006(Ra.s+262,1);
                              Ra.sl[166]=425; /* line # 425 */
                              if (PAS__NE_STR(Ra.s+262,Rd.s+583)) Rv1=1;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if ((Ra.ub[261]||PAS__EQ_STR(Ra.s+262,Rd.s+588))||PAS__EQ_STR(Ra.s+262,Rd.
      s+597))  break;
    }
    Ra.sl[166]=432; /* line # 432 */
    Ra.f[130]=Ra.f[155];
    Ra.sl[166]=433; /* line # 433 */
    Ra.f[157]=Rv9;
    Ra.f[158]=Rv10;
    Ra.sl[166]=434; /* line # 434 */
    if (Ra.f[137]!=(F)0.000000E-01) {
      Ra.sl[166]=436; /* line # 436 */
      if (V_tmin>Ra.f[137]) V_tmin=Ra.f[137];
      Ra.sl[166]=437; /* line # 437 */
      if (V_tmax<Ra.f[137]) V_tmax=Ra.f[137];
    }
    Ra.sl[166]=439; /* line # 439 */
    if (V_thmin>Ra.f[155]) V_thmin=Ra.f[155];
    Ra.sl[166]=440; /* line # 440 */
    if (V_thmax<Ra.f[156]) V_thmax=Ra.f[156];
    Ra.sl[166]=441; /* line # 441 */
    if (V_gmin>Rv9) V_gmin=Rv9;
    Ra.sl[166]=442; /* line # 442 */
    if (V_gmax<Rv10) V_gmax=Rv10;
    Ra.sl[166]=444; /* line # 444 */
    if (V_dat_celsius||Ra.f[139]<=(F)0.000000E-01) {
      Ra.sl[166]=446; /* line # 446 */
      Ra.f[137]=Ra.f[137]+(F)2.731600E+02;
      Ra.sl[166]=447; /* line # 447 */
      Ra.f[138]=Ra.f[138]+(F)2.731600E+02;
      Ra.sl[166]=448; /* line # 448 */
      Ra.f[139]=Ra.f[139]+(F)2.731600E+02;
    }
    Ra.sl[166]=452; /* line # 452 */
    VIEW3D__INP_pattern_info_copy(Ra.s+296,Rv2);
    Ra.sl[166]=455; /* line # 455 */
    if (V_pat_first==NULL) V_pat_first=Rv2;
    else {
      Ra.sl[166]=456; /* line # 456 */
      ((V *)V_pat_last)[1]=Rv2;
    }
    Ra.sl[166]=457; /* line # 457 */
    V_pat_last=Rv2;
    Ra.sl[166]=459; /* line # 459 */
    V_npat=V_npat+1;
  }
  PAS__curr_cntx=Ra.v[163];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " get_d1b_format "  */
void VIEW3D__INP_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 1048 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register SL Rv2;
  V Rv3;
  register V Rv4;
  C Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  SL Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.ub[771]=255;
  Ra.v[257]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1028;
  Ra.v[258]=Rd.s+602;
  Ra.v[259]=Rd.s+14;
  Ra.sl[260]=475; /* line # 475 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+618);
  Ra.sl[260]=476; /* line # 476 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_SL(&Rv0,0);
  PAS__READ_EOLN();
  Ra.sl[260]=477; /* line # 477 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[260]=479; /* line # 479 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=480; /* line # 480 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[260]=481; /* line # 481 */
    PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
    PAS__READ_STR(Ra.s+257,0,1);
    PAS__READ_EOLN();
    Ra.sl[260]=482; /* line # 482 */
    if (PAS__EQ_STR(Ra.s+257,Rd.s+623))  break;
    Ra.sl[260]=483; /* line # 483 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+257,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=484; /* line # 484 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+514,0,0);
    PAS__READ_EOLN();
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+771,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=485; /* line # 485 */
    PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
    PAS__READ_SL(&Rv1,0);
    PAS__READ_EOLN();
    Ra.sl[260]=487; /* line # 487 */
    Rv2=Rv1;
    Rv3=PAS__NEW(Rv2*16+340);
    ((SL *)Rv3)[0]=Rv2;
    ((UB *)Rv3)[24]=62;
    ((UB *)Rv3)[88]=62;
    ((UB *)Rv3)[152]=62;
    Ra.sl[260]=488; /* line # 488 */
    VIEW3D__INP_init_pattern(Rv3);
    Ra.sl[260]=489; /* line # 489 */
    Rv4=Rv3;
    Ra.sl[260]=491; /* line # 491 */
    PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
    PAS__READ_STR(Rv4+24,20,0);
    PAS__READ_CHAR(&Rv5);
    PAS__READ_STR(Rv4+88,10,0);
    PAS__READ_CHAR(&Rv5);
    PAS__READ_STR(Rv4+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=492; /* line # 492 */
    PAS__VREAD_INIT(Ra.s+259,(SL)Ra.ub[258],NULL);
    PAS__READ_SL(((SL *)Rv4)+4,0);
    PAS__READ_SL(((SL *)Rv4)+5,0);
    PAS__READ_EOLN();
    Ra.sl[260]=493; /* line # 493 */
    if (Ra.c[PAS__RANGE(11,1,(UL)Ra.ub[771])+772]==46) {
      Ra.sl[260]=495; /* line # 495 */
      PAS__VREAD_INIT(Ra.s+516,(SL)Ra.ub[515],NULL);
      PAS__READ_SNGL(((F *)Rv4)+54,0);
      PAS__READ_SNGL(((F *)Rv4)+55,0);
      PAS__READ_SNGL(((F *)Rv4)+56,0);
      PAS__READ_SNGL(((F *)Rv4)+57,0);
      PAS__READ_SNGL(((F *)Rv4)+58,0);
      PAS__READ_SNGL(((F *)Rv4)+59,0);
      PAS__READ_SNGL(((F *)Rv4)+60,0);
      PAS__READ_SNGL(((F *)Rv4)+61,0);
      PAS__READ_SNGL(((F *)Rv4)+62,0);
      PAS__READ_SNGL(((F *)Rv4)+63,0);
      PAS__READ_SNGL(((F *)Rv4)+64,0);
      PAS__READ_SNGL(((F *)Rv4)+65,0);
      PAS__READ_EOLN();
      Ra.sl[260]=499; /* line # 499 */
      PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
      PAS__READ_SL(&Rv1,0);
      PAS__READ_SNGL(((F *)Rv4)+66,0);
      PAS__READ_SNGL(((F *)Rv4)+69,0);
      PAS__READ_SNGL(((F *)Rv4)+70,0);
      PAS__READ_SNGL(((F *)Rv4)+71,0);
      PAS__READ_SNGL(((F *)Rv4)+72,0);
      PAS__READ_SNGL(((F *)Rv4)+73,0);
      PAS__READ_SNGL(((F *)Rv4)+74,0);
      PAS__READ_SNGL(((F *)Rv4)+75,0);
      PAS__READ_SNGL(((F *)Rv4)+76,0);
      PAS__READ_SL(((SL *)Rv4)+79,0);
      PAS__READ_SL(((SL *)Rv4)+80,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[260]=506; /* line # 506 */
      PAS__VREAD_INIT(Ra.s+516,(SL)Ra.ub[515],NULL);
      PAS__READ_SNGL(((F *)Rv4)+54,0);
      PAS__READ_SNGL(((F *)Rv4)+55,0);
      PAS__READ_SNGL(((F *)Rv4)+56,0);
      PAS__READ_SNGL(((F *)Rv4)+57,0);
      PAS__READ_SNGL(((F *)Rv4)+58,0);
      PAS__READ_SNGL(((F *)Rv4)+59,0);
      PAS__READ_SNGL(&Rv6,0);
      PAS__READ_SNGL(((F *)Rv4)+66,0);
      PAS__READ_SNGL(((F *)Rv4)+62,0);
      PAS__READ_SNGL(((F *)Rv4)+63,0);
      PAS__READ_SNGL(((F *)Rv4)+64,0);
      PAS__READ_SNGL(((F *)Rv4)+65,0);
      PAS__READ_EOLN();
      Ra.sl[260]=510; /* line # 510 */
      PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
      PAS__READ_SL(&Rv1,0);
      PAS__READ_SNGL(((F *)Rv4)+69,0);
      PAS__READ_SNGL(((F *)Rv4)+70,0);
      PAS__READ_SNGL(((F *)Rv4)+71,0);
      PAS__READ_SNGL(((F *)Rv4)+72,0);
      PAS__READ_SNGL(((F *)Rv4)+73,0);
      PAS__READ_EOLN();
    }
    Ra.sl[260]=513; /* line # 513 */
    if (V_dat_celsius||((F *)Rv4)[65]<=(F)0.000000E-01) {
      Ra.sl[260]=515; /* line # 515 */
      ((F *)Rv4)[63]=((F *)Rv4)[63]+(F)2.731600E+02;
      Ra.sl[260]=516; /* line # 516 */
      ((F *)Rv4)[64]=((F *)Rv4)[64]+(F)2.731600E+02;
      Ra.sl[260]=517; /* line # 517 */
      ((F *)Rv4)[65]=((F *)Rv4)[65]+(F)2.731600E+02;
    }
    Ra.sl[260]=519; /* line # 519 */
    ((F *)Rv4)[67]=(F)0.000000E-01;
    Ra.sl[260]=520; /* line # 520 */
    ((F *)Rv4)[81]=((F *)Rv4)[56];
    Ra.sl[260]=521; /* line # 521 */
    ((F *)Rv4)[82]=((F *)Rv4)[56]+(float)(((SL *)Rv4)[0]-1)*((F *)Rv4)[62];
    Ra.sl[260]=522; /* line # 522 */
    Rv7=(F)1.000000E+010;
    Rv8= -Rv7;
    Ra.sl[260]=524; /* line # 524 */
    Rv9=0;
    Ra.sl[260]=525; /* line # 525 */
    ((SL *)Rv4)[77]=1;
    ((SL *)Rv4)[78]=((SL *)Rv4)[0];
    Ra.sl[260]=526; /* line # 526 */
    while (Rv9<((SL *)Rv4)[0]){
      Ra.sl[260]=528; /* line # 528 */
      Rv10=(((S *)Rv4)+PAS__RANGE(Rv9+1,1,((SL *)Rv4)[0])*16+324);
      Ra.sl[260]=530; /* line # 530 */
      ((F *)Rv10)[0]=((F *)Rv4)[56]+(float)Rv9*((F *)Rv4)[62];
      Ra.sl[260]=531; /* line # 531 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_SW(((SW *)Rv10)+6,0);
      PAS__READ_SNGL(((F *)Rv10)+1,0);
      Ra.sl[260]=532; /* line # 532 */
      ((F *)Rv10)[2]=sqrt(fabs(((F *)Rv10)[1]));
      Ra.sl[260]=533; /* line # 533 */
      ((UB *)Rv10)[14]=0;
      Ra.sl[260]=534; /* line # 534 */
      if (((SW *)Rv10)[6]<=0) ((UB *)Rv10)[14]=128;
      Ra.sl[260]=536; /* line # 536 */
      if (Rv7>((F *)Rv10)[1]) Rv7=((F *)Rv10)[1];
      Ra.sl[260]=537; /* line # 537 */
      if (Rv8<((F *)Rv10)[1]) Rv8=((F *)Rv10)[1];
      Ra.sl[260]=539; /* line # 539 */
      Rv9=Rv9+1;
    }
    Ra.sl[260]=542; /* line # 542 */
    ((F *)Rv4)[83]=Rv7;
    ((F *)Rv4)[84]=Rv8;
    Ra.sl[260]=544; /* line # 544 */
    if (((F *)Rv4)[63]!=(F)0.000000E-01) {
      Ra.sl[260]=546; /* line # 546 */
      if (V_tmin>((F *)Rv4)[63]) V_tmin=((F *)Rv4)[63];
      Ra.sl[260]=547; /* line # 547 */
      if (V_tmax<((F *)Rv4)[63]) V_tmax=((F *)Rv4)[63];
    }
    Ra.sl[260]=549; /* line # 549 */
    if (V_thmin>((F *)Rv4)[81]) V_thmin=((F *)Rv4)[81];
    Ra.sl[260]=550; /* line # 550 */
    if (V_thmax<((F *)Rv4)[82]) V_thmax=((F *)Rv4)[82];
    Ra.sl[260]=551; /* line # 551 */
    if (V_gmin>Rv7) V_gmin=Rv7;
    Ra.sl[260]=552; /* line # 552 */
    if (V_gmax<Rv8) V_gmax=Rv8;
    Ra.sl[260]=555; /* line # 555 */
    if (V_pat_first==NULL) V_pat_first=Rv3;
    else {
      Ra.sl[260]=556; /* line # 556 */
      ((V *)V_pat_last)[1]=Rv3;
    }
    Ra.sl[260]=557; /* line # 557 */
    V_pat_last=Rv3;
    Ra.sl[260]=559; /* line # 559 */
    V_npat=V_npat+1;
    Ra.sl[260]=560; /* line # 560 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    Ra.sl[260]=561; /* line # 561 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SL(&Rv0,0);
    PAS__READ_EOLN();
  }
  PAS__curr_cntx=Ra.v[257];
}


/* Procedure/Function : " get_xyd_format "  */
void VIEW3D__INP_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register SL Rv3;
  V Rv4;
  register V Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  SL Rv9;
  C Rv10;
  UB Rv11;
  SL Rv12;
  register V Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  F Rv19;
  F Rv20;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+631;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=583; /* line # 583 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+647);
  Ra.sl[3]=585; /* line # 585 */
  Rv0=-6;
  Ra.sl[3]=586; /* line # 586 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[3]=588; /* line # 588 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=589; /* line # 589 */
    if (Ri.ub[1]>0) {
      Ra.sl[3]=590; /* line # 590 */
      if (Rv0<0||(Rv0>=0&&Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[0])+1]!=33)&&Ri.c[PAS__RANGE(1,
1,(UL)Ri.ub[0])+1]!=35) {
        Ra.sl[3]=593; /* line # 593 */
        Rv0=Rv0+1;
      }
    }
  }
  Ra.sl[3]=595; /* line # 595 */
  PAS__CLOSE(&V_inp,0);
  Ra.sl[3]=596; /* line # 596 */
  PAS__OPEN(&V_inp,0, V_inp_name.s,1,0,-1);
  Ra.sl[3]=598; /* line # 598 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_STR(Ri.s,0,0);
  PAS__READ_EOLN();
  Ra.sl[3]=599; /* line # 599 */
  while (Ri.ub[1]>0&&Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32)
  Ri.ub[1]=Ri.ub[1]-1;
  Ra.sl[3]=600; /* line # 600 */
  Rv1=1;
  Ra.sl[3]=601; /* line # 601 */
  Ri.ub[258]=0;
  Ra.sl[3]=602; /* line # 602 */
  while (Rv1<Ri.ub[1]&&Ri.ub[258]==0){
    Ra.sl[3]=604; /* line # 604 */
    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
    PAS__READ_STR(Ri.s+257,16,1);
    PAS__READ_EOLN();
    Ra.sl[3]=605; /* line # 605 */
    if (PAS__EQ_STR(Ri.s+257,Rd.s+655)) Ri.ub[258]=0;
  }
  Ra.sl[3]=607; /* line # 607 */
  PAS__SET_CASE(Ri.s+257,1);
  Ra.sl[3]=608; /* line # 608 */
  Rv2=PAS__EQ_STR(Ri.s+257,Rd.s+658);
  Ra.sl[3]=609; /* line # 609 */
  Rv3=Rv0;
  Rv4=PAS__NEW(Rv3*16+340);
  ((SL *)Rv4)[0]=Rv3;
  ((UB *)Rv4)[24]=62;
  ((UB *)Rv4)[88]=62;
  ((UB *)Rv4)[152]=62;
  Ra.sl[3]=610; /* line # 610 */
  VIEW3D__INP_init_pattern(Rv4);
  Ra.sl[3]=611; /* line # 611 */
  Rv5=Rv4;
  Ra.sl[3]=613; /* line # 613 */
  Rv6=(F)1.000000E+00;
  Rv7=(F)1.000000E+00;
  Ra.sl[3]=614; /* line # 614 */
  Rv8=(F)1.000000E-04;
  Rv9=0;
  Ra.sl[3]=615; /* line # 615 */
  ((F *)Rv5)[62]=(F)1.000000E-03;
  Ra.sl[3]=616; /* line # 616 */
  if (Rv2) {
    Ra.sl[3]=618; /* line # 618 */
    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
    PAS__READ_CHAR(&Rv10);
    PAS__READ_STR(Rv5+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=619; /* line # 619 */
    for( Rf0=5;Rf0>0;Rf0-- ) {
      Ra.sl[3]=621; /* line # 621 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ri.s,0,0);
      PAS__READ_EOLN();
      Ra.sl[3]=622; /* line # 622 */
      while (Ri.ub[1]>0&&Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32)
      Ri.ub[1]=Ri.ub[1]-1;
      Ra.sl[3]=623; /* line # 623 */
      Rv1=1;
      Ra.sl[3]=624; /* line # 624 */
      Ri.ub[258]=0;
      Ra.sl[3]=625; /* line # 625 */
      while (Rv1<Ri.ub[1]&&Ri.ub[258]==0){
        Ra.sl[3]=627; /* line # 627 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_STR(Ri.s+257,16,1);
        PAS__READ_EOLN();
        Ra.sl[3]=628; /* line # 628 */
        if (PAS__EQ_STR(Ri.s+257,Rd.s+666)) Ri.ub[258]=0;
      }
      Ra.sl[3]=630; /* line # 630 */
      PAS__SET_CASE(Ri.s+257,1);
      Ra.sl[3]=631; /* line # 631 */
      if (PAS__EQ_STR(Ri.s+257,Rd.s+669)) {
        Ra.sl[3]=632; /* line # 632 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_SNGL(&Rv6,0);
        PAS__READ_SNGL(&Rv7,0);
        PAS__READ_SL(&Rv9,0);
        PAS__READ_SNGL(&Rv8,0);
        PAS__READ_EOLN();
      }
      else {
        Ra.sl[3]=634; /* line # 634 */
        if (PAS__EQ_STR(Ri.s+257,Rd.s+676)||PAS__EQ_STR(Ri.s+257,Rd.s+682)) {
          Ra.sl[3]=636; /* line # 636 */
          PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
          PAS__READ_SNGL(((F *)Rv5)+65,0);
          PAS__READ_EOLN();
          Ra.sl[3]=637; /* line # 637 */
          if (V_dat_celsius||((F *)Rv5)[65]<=(F)0.000000E-01) {
            Ra.sl[3]=638; /* line # 638 */
            ((F *)Rv5)[65]=((F *)Rv5)[65]+(F)2.731600E+02;
          }
          Ra.sl[3]=639; /* line # 639 */
          ((F *)Rv5)[64]=((F *)Rv5)[65];
          ((F *)Rv5)[63]=((F *)Rv5)[64];
        }
        else {
          Ra.sl[3]=642; /* line # 642 */
          if (PAS__EQ_STR(PAS__SUBSTR_STR(Ra.s+16,Ri.s+257,1,7), Rd.s+695)) {
            Ra.sl[3]=644; /* line # 644 */
            Rv11=0;
            Ra.sl[3]=645; /* line # 645 */
            while (Rv1<Ri.ub[1]&&Ri.c[PAS__RANGE(Rv1,1,(UL)Ri.ub[0])+1]!=58)
            Rv1=Rv1+1;
            Ra.sl[3]=646; /* line # 646 */
            Rv1=Rv1+1;
            Ra.sl[3]=647; /* line # 647 */
            Ri.ub[258]=0;
            Ra.sl[3]=648; /* line # 648 */
            if (Rv1<Ri.ub[1]) {
              Ra.sl[3]=649; /* line # 649 */
              PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
              PAS__READ_SNGL(((F *)Rv5)+54,0);
              PAS__READ_STR(Ri.s+257,0,1);
              PAS__READ_EOLN();
            }
            Ra.sl[3]=650; /* line # 650 */
            if (Ri.ub[258]>0) {
              PAS__VREAD_INIT(Ri.s+259,(SL)Ri.ub[258],NULL);
              PAS__READ_SNGL(((F *)Rv5)+55,0);
              PAS__READ_EOLN();
            }
          }
          else {
            Ra.sl[3]=653; /* line # 653 */
            if (PAS__EQ_STR(Ri.s+257,Rd.s+704)) {
              PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
              PAS__READ_SNGL(((F *)Rv5)+66,0);
              PAS__READ_EOLN();
            }
            else {
              Ra.sl[3]=655; /* line # 655 */
              if (PAS__EQ_STR(Ri.s+257,Rd.s+712)) {
                PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                PAS__READ_SNGL(((F *)Rv5)+67,0);
                PAS__READ_EOLN();
              }
              else {
                Ra.sl[3]=657; /* line # 657 */
                if (PAS__EQ_STR(Ri.s+257,Rd.s+721)) {
                  PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                  PAS__READ_SNGL(((F *)Rv5)+68,0);
                  PAS__READ_EOLN();
                }
                else {
                  Ra.sl[3]=659; /* line # 659 */
                  if (PAS__EQ_STR(Ri.s+257,Rd.s+730)) {
                    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                    PAS__READ_CHAR(&Rv10);
                    PAS__READ_STR(Rv5+88,0,0);
                    PAS__READ_EOLN();
                  }
                  else {
                    Ra.sl[3]=661; /* line # 661 */
                    if (PAS__EQ_STR(Ri.s+257,Rd.s+738)) {
                      PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                      PAS__READ_CHAR(&Rv10);
                      PAS__READ_STR(Rv5+24,0,0);
                      PAS__READ_EOLN();
                    }
                    else {
                      Ra.sl[3]=663; /* line # 663 */
                      if (PAS__EQ_STR(Ri.s+257,Rd.s+745)) {
                        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                        PAS__READ_CHAR(&Rv10);
                        PAS__READ_SNGL(((F *)Rv5)+57,0);
                        PAS__READ_SNGL(((F *)Rv5)+58,0);
                        PAS__READ_SNGL(((F *)Rv5)+59,0);
                        PAS__READ_EOLN();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else {
    Ra.sl[3]=668; /* line # 668 */
    PAS__STR_TO_STR(Rv5+152,Ri.s);
    Ra.sl[3]=669; /* line # 669 */
    for( Rf0=5;Rf0>0;Rf0-- ) {
      PAS__SELECT_INP(V_inp);
      PAS__READ_EOLN();
    }
  }
  Ra.sl[3]=672; /* line # 672 */
  Rv12=1;
  Ra.sl[3]=673; /* line # 673 */
  while (Rv12<=Rv0){
    Ra.sl[3]=674; /* line # 674 */
    Rv13=(((S *)Rv5)+PAS__RANGE(Rv12,1,((SL *)Rv5)[0])*16+324);
    Ra.sl[3]=676; /* line # 676 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=677; /* line # 677 */
    if (Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32) Ri.ub[1]=Ri.ub[1]-1;
    Ra.sl[3]=678; /* line # 678 */
    if (Ri.ub[1]>0) {
      Ra.sl[3]=679; /* line # 679 */
      if (Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[0])+1]!=35&&Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[
0])+1]!=33) {
        Ra.sl[3]=681; /* line # 681 */
        Rv1=1;
        Ra.sl[3]=682; /* line # 682 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_SNGL(&Rv14,0);
        PAS__READ_SNGL(&Rv15,0);
        PAS__READ_STR(Ri.s+257,0,1);
        PAS__READ_EOLN();
        Ra.sl[3]=683; /* line # 683 */
        if (Ri.ub[258]>0) {
          PAS__VREAD_INIT(Ri.s+259,(SL)Ri.ub[258],NULL);
          PAS__READ_SNGL(&Rv16,0);
          PAS__READ_EOLN();
        }
        else {
          Ra.sl[3]=684; /* line # 684 */
          Rv16=sqrt(fabs(Rv15));
        }
        Ra.sl[3]=685; /* line # 685 */
        Rv14=Rv14*Rv6;
        Rv15=Rv15*Rv7;
        Rv16=Rv7*Rv16;
        Ra.sl[3]=686; /* line # 686 */
        if (Rv12==1) {
          Ra.sl[3]=688; /* line # 688 */
          Rv17=Rv14;
          Rv18=Rv14;
          Ra.sl[3]=689; /* line # 689 */
          Rv19=Rv15;
          Rv20=Rv15;
          Ra.sl[3]=690; /* line # 690 */
          ((F *)Rv5)[56]=Rv14*Rv6;
        }
        else {
          Ra.sl[3]=694; /* line # 694 */
          if (Rv17>Rv14) Rv17=Rv14;
          else {
            Ra.sl[3]=695; /* line # 695 */
            if (Rv18<Rv14) Rv18=Rv14;
          }
          Ra.sl[3]=696; /* line # 696 */
          if (Rv19>Rv15) Rv19=Rv15;
          else {
            Ra.sl[3]=697; /* line # 697 */
            if (Rv20<Rv15) Rv20=Rv15;
          }
        }
        Ra.sl[3]=699; /* line # 699 */
        ((SW *)Rv13)[6]=1;
        ((F *)Rv13)[0]=Rv14;
        ((F *)Rv13)[1]=Rv15;
        ((F *)Rv13)[2]=Rv16;
        Ra.sl[3]=700; /* line # 700 */
        ((UB *)Rv13)[14]=0;
        Ra.sl[3]=701; /* line # 701 */
        Rv12=Rv12+1;
      }
    }
  }
  Ra.sl[3]=704; /* line # 704 */
  ((F *)Rv5)[81]=Rv17;
  ((F *)Rv5)[82]=Rv18;
  Ra.sl[3]=705; /* line # 705 */
  ((F *)Rv5)[83]=Rv19;
  ((F *)Rv5)[84]=Rv20;
  Ra.sl[3]=707; /* line # 707 */
  V_smin=Rv19;
  V_smax=Rv20;
  Ra.sl[3]=708; /* line # 708 */
  V_tmin=((F *)Rv5)[65];
  V_tmax=((F *)Rv5)[65];
  Ra.sl[3]=709; /* line # 709 */
  V_thmin=Rv17;
  V_thmax=Rv18;
  Ra.sl[3]=710; /* line # 710 */
  V_gmin=Rv19;
  V_gmax=Rv20;
  Ra.sl[3]=713; /* line # 713 */
  V_npat=V_npat+1;
  Ra.sl[3]=714; /* line # 714 */
  Lx[1].sl[69]=1;
  V_tbpat.v[0]=Rv4;
  Ra.sl[3]=715; /* line # 715 */
  if (V_pat_first==NULL) V_pat_first=Rv4;
  else {
    Ra.sl[3]=716; /* line # 716 */
    ((V *)V_pat_last)[1]=Rv4;
  }
  Ra.sl[3]=717; /* line # 717 */
  V_pat_sel=Rv4;
  Ra.sl[3]=718; /* line # 718 */
  V_pat_last=Rv4;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_inlrx_format "  */
void VIEW3D__INP_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Rv1;
  V Rv2;
  register V Rv3;
  C Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  register V Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+753;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=733; /* line # 733 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+771);
  while (1){
    Ra.sl[68]=735; /* line # 735 */
    Rv0=0;
    while (1){
      Ra.sl[68]=738; /* line # 738 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ra.s,0,0);
      PAS__READ_EOLN();
      Ra.sl[68]=739; /* line # 739 */
      if (PAS__EOF(V_inp)) Rv0=-1;
      if (Rv0<0||(Ra.c[PAS__RANGE(1,1,(UL)Ra.ub[0])+1]==82&&Ra.c[PAS__RANGE(2,1,
      (UL)Ra.ub[0])+1]==65)&&Ra.c[PAS__RANGE(3,1,(UL)Ra.ub[0])+1]==87)  break;
    }
    Ra.sl[68]=741; /* line # 741 */
    if (Rv0<0)  break;
    Ra.sl[68]=742; /* line # 742 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SL(&Rv0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=743; /* line # 743 */
    Rv1=Rv0;
    Rv2=PAS__NEW(Rv1*16+340);
    ((SL *)Rv2)[0]=Rv1;
    ((UB *)Rv2)[24]=62;
    ((UB *)Rv2)[88]=62;
    ((UB *)Rv2)[152]=62;
    Ra.sl[68]=744; /* line # 744 */
    VIEW3D__INP_init_pattern(Rv2);
    Ra.sl[68]=745; /* line # 745 */
    Rv3=Rv2;
    Ra.sl[68]=747; /* line # 747 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+55,0);
    PAS__READ_EOLN();
    Ra.sl[68]=748; /* line # 748 */
    for( Rf0=7;Rf0>0;Rf0-- ) {
      PAS__SELECT_INP(V_inp);
      PAS__READ_EOLN();
    }
    Ra.sl[68]=749; /* line # 749 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Rv3+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=750; /* line # 750 */
    VIEW3D__INP_PRC_00000002(Rv3+152);
    Ra.sl[68]=751; /* line # 751 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+66,0);
    PAS__READ_EOLN();
    Ra.sl[68]=752; /* line # 752 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+67,0);
    PAS__READ_EOLN();
    Ra.sl[68]=759; /* line # 759 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_CHAR(&Rv4);
    PAS__READ_STR(Rv3+24,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=760; /* line # 760 */
    VIEW3D__INP_PRC_00000002(Rv3+24);
    Ra.sl[68]=761; /* line # 761 */
    ((SL *)Rv3)[5]=V_npat+1;
    Ra.sl[68]=762; /* line # 762 */
    VIEW3D__INP_PRC_00000001(12);
    Ra.sl[68]=763; /* line # 763 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Rv3+88,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=764; /* line # 764 */
    VIEW3D__INP_PRC_00000002(Rv3+88);
    Ra.sl[68]=765; /* line # 765 */
    VIEW3D__INP_PRC_00000001(15);
    Ra.sl[68]=766; /* line # 766 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+65,0);
    PAS__READ_EOLN();
    Ra.sl[68]=767; /* line # 767 */
    ((F *)Rv3)[65]=((F *)Rv3)[65]+(F)2.731600E+02;
    Ra.sl[68]=768; /* line # 768 */
    ((F *)Rv3)[63]=((F *)Rv3)[65];
    Ra.sl[68]=769; /* line # 769 */
    ((F *)Rv3)[64]=((F *)Rv3)[65];
    Ra.sl[68]=770; /* line # 770 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    Ra.sl[68]=771; /* line # 771 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    while (1){
      Ra.sl[68]=773; /* line # 773 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ra.s,0,0);
      PAS__READ_EOLN();
      if (Ra.c[PAS__RANGE(1,1,(UL)Ra.ub[0])+1]==48)  break;
    }
    Ra.sl[68]=775; /* line # 775 */
    Rv5=0;
    Ra.sl[68]=776; /* line # 776 */
    ((F *)Rv3)[81]=((F *)Rv3)[56];
    Ra.sl[68]=777; /* line # 777 */
    ((F *)Rv3)[82]=((F *)Rv3)[56]+(float)Rv0*((F *)Rv3)[62];
    Ra.sl[68]=778; /* line # 778 */
    Rv6=(F)1.000000E+010;
    Rv7= -Rv6;
    Ra.sl[68]=779; /* line # 779 */
    ((SL *)Rv3)[77]=1;
    ((SL *)Rv3)[78]=Rv0;
    Ra.sl[68]=780; /* line # 780 */
    while (Rv5<Rv0){
      Ra.sl[68]=782; /* line # 782 */
      Rv8=(((S *)Rv3)+PAS__RANGE(Rv5+1,1,((SL *)Rv3)[0])*16+324);
      Ra.sl[68]=784; /* line # 784 */
      ((SW *)Rv8)[6]=1;
      Ra.sl[68]=785; /* line # 785 */
      ((F *)Rv8)[0]=((F *)Rv3)[56]+(float)Rv5*((F *)Rv3)[62];
      Ra.sl[68]=786; /* line # 786 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_SNGL(((F *)Rv8)+1,0);
      PAS__READ_EOLN();
      Ra.sl[68]=787; /* line # 787 */
      ((F *)Rv8)[2]=sqrt(fabs(((F *)Rv8)[1]));
      Ra.sl[68]=788; /* line # 788 */
      ((UB *)Rv8)[14]=0;
      Ra.sl[68]=790; /* line # 790 */
      if (Rv6>((F *)Rv8)[1]) Rv6=((F *)Rv8)[1];
      Ra.sl[68]=791; /* line # 791 */
      if (Rv7<((F *)Rv8)[1]) Rv7=((F *)Rv8)[1];
      Ra.sl[68]=793; /* line # 793 */
      Rv5=Rv5+1;
    }
    Ra.sl[68]=796; /* line # 796 */
    ((F *)Rv3)[83]=Rv6;
    ((F *)Rv3)[84]=Rv7;
    Ra.sl[68]=798; /* line # 798 */
    if (V_tmin>((F *)Rv3)[63]) V_tmin=((F *)Rv3)[63];
    Ra.sl[68]=799; /* line # 799 */
    if (V_tmax<((F *)Rv3)[63]) V_tmax=((F *)Rv3)[63];
    Ra.sl[68]=800; /* line # 800 */
    if (V_thmin>((F *)Rv3)[81]) V_thmin=((F *)Rv3)[81];
    Ra.sl[68]=801; /* line # 801 */
    if (V_thmax<((F *)Rv3)[82]) V_thmax=((F *)Rv3)[82];
    Ra.sl[68]=802; /* line # 802 */
    if (V_gmin>Rv6) V_gmin=Rv6;
    Ra.sl[68]=803; /* line # 803 */
    if (V_gmax<Rv7) V_gmax=Rv7;
    Ra.sl[68]=806; /* line # 806 */
    if (V_pat_first==NULL) V_pat_first=Rv2;
    else {
      Ra.sl[68]=807; /* line # 807 */
      ((V *)V_pat_last)[1]=Rv2;
    }
    Ra.sl[68]=808; /* line # 808 */
    V_pat_last=Rv2;
    Ra.sl[68]=810; /* line # 810 */
    V_npat=V_npat+1;
    if (PAS__EOF(V_inp))  break;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " get_sraw_format "  */
void VIEW3D__INP_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  G Rv2;
  G Rv3;
  SL Rv4;
  register SL Rv5;
  V Rv6;
  register V Rv7;
  G Rv8;
  G Rv9;
  SL Rv10;
  register V Rv11;
  register G Rgg;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+779;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=824; /* line # 824 */
  Rv0=0;
  Ra.sl[3]=825; /* line # 825 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[3]=827; /* line # 827 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv1,0);
    Ra.sl[3]=828; /* line # 828 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=829; /* line # 829 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv2,0);
    Ra.sl[3]=830; /* line # 830 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=831; /* line # 831 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv3,0);
    PAS__READ_EOLN();
    Ra.sl[3]=832; /* line # 832 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=833; /* line # 833 */
    Rv0=Rv0+1;
    Ra.sl[3]=834; /* line # 834 */
    Rv4=PAS__G_ROUND((Rv3-Rv1)/Rv2)+1;
    Ra.sl[3]=835; /* line # 835 */
    Rv3=(double)((float)Rv4+(F)5.000000E-01)*Rv2+Rv1;
    Ra.sl[3]=836; /* line # 836 */
    Rv5=Rv4;
    Rv6=PAS__NEW(Rv5*16+340);
    ((SL *)Rv6)[0]=Rv5;
    ((UB *)Rv6)[24]=62;
    ((UB *)Rv6)[88]=62;
    ((UB *)Rv6)[152]=62;
    Ra.sl[3]=837; /* line # 837 */
    VIEW3D__INP_init_pattern(Rv6);
    Ra.sl[3]=838; /* line # 838 */
    Rv7=Rv6;
    Ra.sl[3]=840; /* line # 840 */
    ((SL *)Rv7)[4]=Rv0;
    Ra.sl[3]=841; /* line # 841 */
    if (fabs(Rv1)<1.800000000000000E+002) {
      Ra.sl[3]=842; /* line # 842 */
      ((F *)Rv7)[56]=(float)Rv1;
      ((F *)Rv7)[62]=(float)Rv2;
    }
    Ra.sl[3]=843; /* line # 843 */
    ((F *)Rv7)[81]=((F *)Rv7)[56];
    Ra.sl[3]=844; /* line # 844 */
    ((F *)Rv7)[82]=((F *)Rv7)[56]+(float)(Rv4-1)*((F *)Rv7)[62];
    Ra.sl[3]=845; /* line # 845 */
    Rv8=(double)((F *)Rv7)[83];
    Rv9=(double)((F *)Rv7)[84];
    Ra.sl[3]=846; /* line # 846 */
    Rv10=1;
    for( Rf0=Rv4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=847; /* line # 847 */
      Rv11=(((S *)Rv7)+PAS__RANGE(Rv10,1,((SL *)Rv7)[0])*16+324);
      Ra.sl[3]=849; /* line # 849 */
      ((F *)Rv11)[0]=(float)((double)(Rv10-1)*Rv2+Rv1);
      Ra.sl[3]=850; /* line # 850 */
      ((F *)Rv11)[1]=(F)0.000000E-01;
      Ra.sl[3]=851; /* line # 851 */
      if (!PAS__EOF(V_inp)) {
        PAS__SELECT_INP(V_inp);
        PAS__READ_SNGL(((F *)Rv11)+1,0);
      }
      Ra.sl[3]=852; /* line # 852 */
      ((F *)Rv11)[2]=sqrt(fabs(((F *)Rv11)[1]));
      Ra.sl[3]=853; /* line # 853 */
      ((UB *)Rv11)[14]=0;
      Ra.sl[3]=854; /* line # 854 */
      if (Rv8>(double)((F *)Rv11)[1]) Rv8=(double)((F *)Rv11)[1];
      Ra.sl[3]=855; /* line # 855 */
      if (Rv9<(double)((F *)Rv11)[1]) Rv9=(double)((F *)Rv11)[1];
      Rv10++;
    }
    Ra.sl[3]=858; /* line # 858 */
    ((F *)Rv7)[83]=(float)Rv8;
    ((F *)Rv7)[84]=(float)Rv9;
    Ra.sl[3]=860; /* line # 860 */
    if (V_tmin>((F *)Rv7)[63]) V_tmin=((F *)Rv7)[63];
    Ra.sl[3]=861; /* line # 861 */
    if (V_tmax<((F *)Rv7)[63]) V_tmax=((F *)Rv7)[63];
    Ra.sl[3]=862; /* line # 862 */
    if (V_thmin>((F *)Rv7)[81]) V_thmin=((F *)Rv7)[81];
    Ra.sl[3]=863; /* line # 863 */
    if (V_thmax<((F *)Rv7)[82]) V_thmax=((F *)Rv7)[82];
    Ra.sl[3]=864; /* line # 864 */
    if ((double)V_gmin>Rv8) V_gmin=(float)Rv8;
    Ra.sl[3]=865; /* line # 865 */
    if ((double)V_gmax<Rv9) V_gmax=(float)Rv9;
    Ra.sl[3]=868; /* line # 868 */
    if (V_pat_first==NULL) V_pat_first=Rv6;
    else {
      Ra.sl[3]=869; /* line # 869 */
      ((V *)V_pat_last)[1]=Rv6;
    }
    Ra.sl[3]=870; /* line # 870 */
    V_pat_last=Rv6;
    Ra.sl[3]=872; /* line # 872 */
    V_npat=V_npat+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_patterns "  */
void P_get_patterns(){
  jmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 300 );

  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[74]=(V)L_lb_env;
  if (setjmp(L_lb_env )) goto L_l_0;

  Ra.ub[0]=255;
  Ra.ub[257]=14;
  Ra.v[70]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+280;
  Ra.v[71]=Rd.s+796;
  Ra.v[72]=Rd.s+14;
  Ra.sl[73]=879; /* line # 879 */
  Ra.sl[69]=0;
  Ra.sl[73]=880; /* line # 880 */
  PAS__OPEN(&V_inp,0, V_inp_name.s,4097,0,-1);
  Ra.sl[73]=881; /* line # 881 */
  if (PAS__iostatus!=0) {
    Ra.sl[73]=883; /* line # 883 */
    PAS__VWRITE_INIT(V_str_msg.s,1);
    PAS__WRITE_STR(Rd.s+810,-1,-1,32);
    PAS__WRITE_STR(V_inp_name.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+859,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[73]=884; /* line # 884 */
    goto Ret_Label;
  }
  Ra.sl[73]=887; /* line # 887 */
  switch (V_inp_frm) {
    case 0:Ra.sl[73]=889; /* line # 889 */
    VIEW3D__INP_PRC_00000003();
    break;
    case 1:Ra.sl[73]=891; /* line # 891 */
    VIEW3D__INP_PRC_00000007();
    break;
    case 4:Ra.sl[73]=893; /* line # 893 */
    VIEW3D__INP_PRC_00000008();
    break;
    case 5:Ra.sl[73]=895; /* line # 895 */
    VIEW3D__INP_PRC_00000009();
    break;
    case 8:Ra.sl[73]=897; /* line # 897 */
    VIEW3D__INP_PRC_00000010();
    break;
    default:Ra.sl[73]=900; /* line # 900 */
    PAS__STR_TO_STR(V_str_msg.s,Rd.s+867);
    Ra.sl[73]=901; /* line # 901 */
    goto Ret_Label;
    break;
  }
  Ra.sl[73]=904; /* line # 904 */
  P_set_pattern_selection();
  PAS__curr_cntx=Ra.s+280;
L_l_0:
  Ra.sl[73]=908; /* line # 908 */
  PAS__CLOSE(&V_inp,0);
  Ra.sl[73]=910; /* line # 910 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+940,-1,-1,32);
  PAS__WRITE_INT(V_npat,0,0);
  PAS__WRITE_STR(Rd.s+962,-1,-1,32);
  PAS__WRITE_STR(V_inp_name.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+987,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[73]=911; /* line # 911 */
  if (V_npat==0) {
    Ra.sl[73]=913; /* line # 913 */
    PAS__STR_TO_STR(V_str_msg.s,Rd.s+991);
    Ra.sl[73]=914; /* line # 914 */
    goto Ret_Label;
  }
  else {
    Ra.sl[73]=918; /* line # 918 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,24,-1,1,32);
    PAS__WRITE_STR(Rd.s+1055,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[73]=919; /* line # 919 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1074,-1,-1,32);
    PAS__WRITE_SNGL(V_thmin,8,3,0);
    PAS__WRITE_STR(Rd.s+1114,-1,-1,32);
    PAS__WRITE_SNGL(V_thmax,8,3,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_EOLN();
    Ra.sl[73]=920; /* line # 920 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1118,-1,-1,32);
    PAS__WRITE_SNGL(V_tmin,8,2,0);
    PAS__WRITE_STR(Rd.s+1158,-1,-1,32);
    PAS__WRITE_SNGL(V_tmax,8,2,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_EOLN();
    Ra.sl[73]=921; /* line # 921 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1162,-1,-1,32);
    PAS__WRITE_SNGL(V_gmin,8,3,0);
    PAS__WRITE_STR(Rd.s+1202,-1,-1,32);
    PAS__WRITE_SNGL(V_gmax,8,3,0);
    PAS__WRITE_CHAR(46);
    PAS__WRITE_EOLN();
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[70];
  Lx[1]=Lx_Sv;
}
