{
*************************************************************************
*                                                                       *
*                                                                       *
*        V I E W - 3 D  (View Powder Diffraction Data in 3D)            *
*                                                                       *
*               ( ILL Data Base Manager Source File )                   *
*                                                                       *
*                  Version  1.0-A  - - 30-Nov-2009                      *
*                                                                       *
*                                by                                     *
*                                                                       *
*                   Pierre Wolfers, Institut Neel                       *
*                                                                       *
*            CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166            *
*                                                                       *
*                       F 38042 GRENOBLE CEDEX 9                        *
*                                                                       *
*                             F R A N C E                               *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%include 'PASENV:draw_defs.pas' {, list_on};


  {**********************************************************************************
  *                                                                                 *
  *                        Global  Constants  Declarations                          *
  *                                                                                 *
  **********************************************************************************}


const
  Max_Phase     =                    4;                 { Maximum number of phase in a sample }

  flt_max       =              1.0e+30;                 { Define the largest floatting number constant }

  npat_max      =                   32;                 { Maximum number of pattern to select }
  pi            =        4*ARCTAN( 1 );                 { The pi number }
  inrd          =             pi/180.0;                 { Cte to change from decimal degrees to radians }

  Ice_Temp      =               273.16;                 { Ice fusion temperature in Kelvin }

  MAI_IDX       =                    0;                 { Main Setup Index }
  DRW_IDX       =                    1;                 { Common Draw setup Index }

  Max_Setup     =              DRW_IDX;                 { Maximum number of Setup sections }

  unix_setup_path = './;HOME:/etc/;/usr/local/etc/';
  win_setup_path  = './;HOME:/etc/;LOCAL:/etc/;/usr/local/etc';

type
  real          =               Dfloat;                 { Force compatibility with DRAW Library }

  integer       =                 Dint;                 { Force all integers to be DRAW System integer }

  linetype      =        string( 255 );                 { Output line type definition }

  labeltype     =        string(  62 );                 { String type for Setup/Pannel labels }

  functy = (                                            { * Program function definitions }
                        fc_light,                       { Function to do a 3D plot }
                        fc_plot,                        { Function to do a plot }
                        fc_ndia,                        { Function to specify a diagram number }
                        fc_celsius,                     { Function to set celsius degrees for temperature }
                        fc_label,                       { Function for label on pattern plots }
                        fc_verbose                      { Flag for verbose run mode }
           );

  functsety     =        set of functy;

  file_format = (                                       { * Pattern File format kind definitions }
                        pf_standard,                    { Our Standard format }
                        pf_d1b,                         { D1b/D20 file format }
                        pf_d1ba,                        { Alternate form of d1b file }
                        pf_column,                      { Column format }
                        pf_xydata,                      { XY-DATA format }
                        pf_macinelrx,                   { X-Ray Inel on Macintosh format }
                        pf_njafrm,                      { X-Ray small angles }
                        pf_d5000,                       { X-Ray D5000 }
                        pf_singleraw,                   { Single raw description }
                        pf_null                         { Null format for unspecified format }
                );


  mrk_kindty =  (                                       { * Marker types definitions }
                        mk_rfleft,                      { Dot is a left integration limit }
                        mk_rfright,                     { Dot is a right integration limit }
                        mk_rflcen,                      { Dot is the center of reflection line  }
                        mk_rflpos,                      { Dot is at reflexion line 2*theta angle }
                        mk_rflhkl,                      { Dot is at an indexed reflexion line }
                        mk_bckbeg,                      { Dot is background representative region begin }
                        mk_bckend,                      { Dot is background representative region end }

                        mk_invalid                      { Invalid/Canceled Dot to ignore }
                );


  mrk_flgtyp = set of mrk_kindty;                       { * Define the pattern dor flag set type }

  label_ptr = ^label_rec;                               { * Define the label record pointer }

  label_rec( size: byte ) = record                      { * Define the label record }
    nxt: label_ptr;                                     { Link to next the record (or nil) }
    txt: packed array[1..size] of char                  { The related text }
  end;

  data_point = record                                   { * Record definition for a pattern point }
    theta,                                              { Theta angle }
    int,                                                { Intensity count }
    sig:                                  real;         { Intensity sigma }
    flag:                         word_integer;         { Integer Flag for dot validity }
    mflg:                           mrk_flgtyp          { Pattern Marker specifications }
  end;

  pat_ptr  =  ^pat_rec;                                 { Define a pointer of pattern }

  pat_rec( dim: integer ) = record                      { * Definition of Pattern record }
    next,                                               { Pointer to next pattern }
    prev:                              pat_ptr;         { Pointer to previous pattern }
    lab_lst:                         label_ptr;         { Pointer to the label records (or nil) }
    idcnt,                                              { Pattern index }
    numor:                             integer;         { Integer Identifier NUMOR }
    dateh,                                              { Pattern date and hour }
    sample,                                             { Sample on the measure }
    comment:                         labeltype;         { Pattern comment of 64 character max. }
    monitor,                                            { Monitor count }
    cnttime,                                            { Counting time }
    dtheta, omega, chi, phi,                            { Initial characteristic angles }
    tr1, tr2, step,                                     { Sample position X, Y values, theta step }
    t_set, t_reg, t_sample,                             { Pattern temperature: Setting, on regulator, on sample }
    lambda1, lambda2, rwave2,                           { Wave length(s) (old rvp1 free parameter) and intensities ratio }
    rvp2, rvp3, rvp4, rvp5,                             { Free real parameters rvp1..rvp9 }
    rvp6, rvp7, rvp8, rvp9:               real;
    ista, iend,                                         { Scan index limit number for internal use }
    ivp0, ivp1:                        integer;         { Free integer parameters ivp1 and ivp2 }
    amin, amax,                                         { Deduced Minimaxi on 2*theta }
    min,  max:                            real;         { Deduced Minimum and maximum of intensity }
    dat:           array[1..dim] of data_point          { The pattern dim points }
  end;


  crv_ptr  =  ^crv_rec;                                 { Define a pointer of suplementary curve to plot }

  crv_rec( crv_sz: integer ) = record                   { * Define the Curve record }
    crv_nxt:                           crv_ptr;         { Link to the next curve }
    crv_lsz, crv_msz:                     real;         { Size to use for line and/or marker }
    crv_lco, crv_mco,                                   { Color to use for lines and markers }
    crv_lkn, crv_mkn, crv_ide: integer;                 { Kind of line, kind of marker, curve id. }
    crv_tab:        array[1..2*crv_sz] of real          { The curve crv_sz dots }
  end;

  prm_knd =  ( prm_wild,                                { * Define the kind of parameters wild => No action }
               prm_attr,                                { Attribute setting }
               prm_frm,                                 { Frame Value - Only for Graphic Display }
               prm_bool,                                { Boolean Value }
               prm_enm,                                 { Ennumerated Value }
               prm_int,                                 { Integer Value }
               prm_flt,                                 { Floating Value }
               prm_str,                                 { String Value }
               prm_txt );                               { Text Value - Only to output (comment) }

  text_ty( sz: Dint ) = array[1..sz] of char;           { * Define a text to display }

  pdsc_acc = record                                     { * Define the Pannel/Chapter Item type }
               nm:   labeltype;                         { Name of parameter }
               x, y, w, h: byte;                        { Lower Left Coordinates, Width and height in mm (for Pannel Display) }
               case kn: prm_knd of
                 prm_wild:( rw: $wild_pointer );        { Pointer to the variable }
                 prm_attr:( ft: ^string );              { Attributes setting }
                 prm_bool:( rb: ^boolean );             { Boolean Value }
                 prm_enm: ( ei: ^integer;               { Ennumerated value with list of value el }
                            el: ^Choice_List );
                 prm_int: ( ri: ^integer;               { Integer Value in the range li..ui }
                            li, ui: integer );
                 prm_flt: ( rf: ^real;                  { Floating Value in the range lr..ur with the minimum increment of st }
                            lr, ur, ac: real );
                 prm_str: ( rs: ^string );              { String Value }

                 prm_txt: ( tx: ^text_ty );             { Output comment text (for help) }
                 prm_frm: ( fw, st, ls, lk: byte );     { Frame to display: fw, st, ls, lk : Font Size (in mm), Font style, Line size, Line kind }
            end;

  pdsc_tab( ni: integer ) = record                      { * Define the Pannel/Chapter list record descriptor type }
              id:                         Dint;         { Draw Pannel Identifier }
              ti:                    labeltype;         { Table title }
              w, h:              word_unsigned;         { Width and Height (in mm) of Draw Pannel Window }
              tb:     array[1..ni] of pdsc_acc;         { Descriptor table }
            end;

  pdsc_ptr      =                    ^pdsc_tab;         { Define the parameter descriptor pointer type }

  pdsc_env( sz: integer ) = array[0..sz] of pdsc_ptr;   { Define an environment table }


  mai_prmty = record                                    { * Define the Label parameters environment }
              tit_s,                                    { Title of setup }
              lb1_s,  lb2_s,                            { Four lines of label/comment }
              lb3_s,  lb4_s:      linetype;
              th0_r,  ths_r,                            { Externaly user specified 2theta origine and step }
              tmi_r,  tma_r:          real;             { Externaly user specified 2theta Range }
              tmd_f:                 Dbool              { Flag For the Theta mode }
            end;

  drw_prmty = record                                    { * Define the Drawing parameters environment }
              hls_r, vls_r,                             { Horizontal and Vertical Label Shift }
              xsz_r, ysz_r, zsz_r,                      { Sizes of each axis for 2d and 3D Plot }
              pcs_r,                                    { Count Shift to apply for the different diffraction pattern }
              ome_r, chi_r, phi_r,                      { Eulerian angles Omega, chi and phi }
              dis_r:                  real;             { 3D Wiew Distance }
            end;


  boo_tab( dim: integer ) = array[1..dim] of boolean;   { Define the type model arrays }
  int_tab( dim: integer ) = array[1..dim] of integer;
  flt_tab( dim: integer ) = array[1..dim] of    real;
  pat_tab( dim: integer ) = array[1..dim] of pat_ptr;

  pattab1_int   =      array[1..npat_max] of integer;
  pattab1_flt   =      array[1..npat_max] of    real;
  pattab2_ptr   =    array[1..2*npat_max] of pat_ptr;
  pattab2_int   =    array[1..2*npat_max] of integer;
  pattab2_flt   =    array[1..2*npat_max] of    real;
  pattab2_boo   =    array[1..2*npat_max] of boolean;

  setup_tbtype  =        pdsc_env( Max_Setup );         { Setup type definition }



[external]
var
  default_setup,                                        { File Setup Default }
  setupf,                                               { Setup file Specification string }

  str_msg,                                              { String to build messages }

  inp_name:                           linetype;         { Input file specification }

  pat_sel,                                              { Pointer to the selected pattern }
  pat_first,                                            { Pointer to first and last pattern }
  pat_last:                            pat_ptr;

  inp_frm:                         file_format;         { Input file format }

  inpl_frm:                           linetype;         { Line format string for input }

  funcs:                             functsety;         { Set of function to execute }

  ndiat,                                                { Number of pattern to select by temperature }
  npat:                                integer;         { Total number of pattern in memory }

  tbtem:                           pattab1_flt;         { Table of Pattern temperature to select }
  tbnp:                            pattab1_int;         { Table of Pattern number to select }

  tbpat:                           pattab2_ptr;         { Table of Pattern pointer to select }
  tbknd:                           pattab2_boo;         { Table of Line/Marker mode flags }
  tbcol,                                                { Table of Line/Marker colors }
  tbtyp:                           pattab2_int;         { Table of Line/Marker kinds }
  tbsiz:                           pattab2_flt;         { Table of Line/Marker sizes }

  dstatus,                                              { Return status for DRAW Graphic Library }
  irep:                                   Dint;         { Return value for DRAW$DIALOG Procedure }

  e_thmin, e_thmax,                                     { Effective external current theta limits }
  smin,    smax,                                        { Minimum and Maximum of Selected Pattern }
  tmin,    tmax,                                        { Minimum and Maximum of temperature }
  thmin,   thmax,                                       { Minimum and Maximum of angle 2*theta }
  spthmin, spthmax,                                     { 2*theta mini-maxi of selected pattern }
  szthmin, szthmax,                                     { 2*theta mini-maxi of selected zone in the selected pattern }
  gmin,    gmax,                                        { General minimum and maximum }
  xs,      ys:                          Dfloat;         { Paper size for draw }

  sel_ileft, sel_iright:                  Dint;         { Left and Right limits of Angular domain (Zone). }

  sel_pat:                             pat_ptr;         { Current Selected Pattern pointer }

  nerr_flg,                                             { Flag for computing error during a fit }
  dat_celsius,                                          { Flag for default Celcius Temperature in input }
  fil_nbr,                                              { Flag for append pattern number to file name }
  out_app,                                              { Flag for append to previous result file }
  drw_ok:                                Dbool;         { Flag for Initialize graphic }

  inp:                                    text;         { Input File }

  mai_parm:                          mai_prmty;         { Main Setup }
  drw_parm:                          drw_prmty;         { Graphic Setup }

  setup_tab:                      setup_tbtype;         { Environment table for setup }




{ *** Setup Init procedures *** }

procedure MAIN$SETUP_INIT; external;




{ *** Global procedures/functions *** }


procedure SET_REF( var p: $wild_pointer; var t: $wild_thing ); external 'RPW_Set_Ref';


function  WRITE_SETUP_FILE( in_var file_spc: string; var envtb: pdsc_env ): ^string;
external;

function  READ_SETUP_FILE( in_var file_spc: string; var envtb: pdsc_env ): ^string;
external;



{ *** Graphic Pannel procedures/functions *** }

procedure BUILD_PANNEL( var pan_descr: pdsc_tab ); external;



{ *** Input/Output Pattern Data procedures/functions *** }

procedure INIT_LOAD; external;

procedure GET_PATTERNS; external;

procedure WRITE_NORMALIZED_FILE; external;



{ *** Graphic procedures/functions *** }

procedure MAKE_3D; external;


function  GET_NEW_PARAMS( var parm_tab: pdsc_tab ): integer; external;


{ *** End of environment file *** }
