export PAS_BIN#
#       Makefile for VIEW-3D on UNIX Like systems
#
#

CC	=	gcc
PAS	=	pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIB	=	-L/usr/local/lib -lcpas -lm
LIBS	=	-ldraw

C_FLAGS = -O -c

P_FLAGS = -t1 -r

L_FLAGS =

SRCP =\
	$(Src)/view3d.pas \
	$(Src)/view3d_env.pas \
	$(Src)/view3d_inp.pas \
	$(Src)/view3d_draw.pas

SRCS =\
	$(Src)/view3d.c \
	$(Src)/view3d_inp_out.c \
	$(Src)/view3d_draw.c

Obj =\
	$(oDir)/view3d.o \
	$(oDir)/view3d_inp.o \
	$(oDir)/view3d_draw.o

#
all:    $(Bin)/view3d
#

$(Bin)/view3d: $(Obj)
	$(CC) $(L_FLAGS) $(Obj) $(LIB) $(LIBS) -o $(Bin)/view3d
#
$(oDir)/view3d.o: $(Src)/view3d.pas $(Src)/view3d_env.pas
	$(PAS) $(P_FLAGS) $(Src)/view3d
	$(CC) $(C_FLAGS) $(INC) $(Src)/view3d.c -o $(oDir)/view3d.o
#
$(oDir)/view3d_inp.o: $(Src)/view3d_inp.pas $(Src)/view3d_env.pas
	$(PAS) $(P_FLAGS) $(Src)/view3d_inp
	$(CC) $(C_FLAGS) $(INC) $(Src)/view3d_inp.c -o $(oDir)/view3d_inp.o
#
$(oDir)/view3d_draw.o: $(Src)/view3d_draw.pas $(Src)/view3d_env.pas
	$(PAS) $(P_FLAGS) $(Src)/view3d_draw
	$(CC) $(C_FLAGS) $(INC) $(Src)/view3d_draw.c -o $(oDir)/view3d_draw.o
#
#
#
clean:
	-rm $(Src)/view3d*.c $(Obj) $(Bin)/view3d
#
end:
