/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 376 ) = {
 10,  10, 111, 117, 116,  95, 109,  97, 116, 114, 105, 120,  56,  56,  47, 104,
111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 114, 112, 119, 100,  97,
116,  97,  95, 115, 114,  99,  47, 114, 112, 119, 100,  97, 116,  97,  95, 108,
115, 113,  46, 112,  97, 115,  13,  13,  32,  32,  42,  42,  42,  32,  77,  97,
116, 114, 105, 120,  40,  24,  24,  41,  32,  32,  97, 110, 100,  32, 114, 101,
108,  97, 116, 101, 100,  32,  32, 118, 101,  99, 116, 111, 114,  32,  58,   5,
  5,  32,  32,  42,  32,  32,   6,   6, 109,  97, 116, 105, 110, 118,  50,  50,
 32,  42,  42,  42,  32,  76,  83,  81,  36,  77,  97, 116, 105, 110, 118,  32,
 70, 105, 110, 100,  32,  97,  32, 115, 105, 110, 103, 117, 108,  97, 114, 105,
116, 121,  32, 102, 111, 114,  32, 118,  97, 114, 105,  97,  98, 108, 101,  32,
 35,  32,   5,   5, 115, 111, 108, 118, 101,  11,  11, 102, 114, 101, 101,  95,
112, 100, 101, 115,  99, 114,   8,   8, 108, 115, 113,  36, 105, 110, 105, 116,
 13,  13, 108, 115, 113,  36, 110, 101, 119,  95, 118, 112,  97, 114, 109,  13,
 13, 108, 115, 113,  36, 110, 101, 119,  95,  98, 108, 111,  99, 107,  15,  15,
108, 115, 113,  36, 115, 101, 116,  95, 100, 109, 112,  95, 109, 114, 113,  14,
 14, 108, 115, 113,  36, 105, 110, 105, 116,  95,  99, 121,  99, 108, 101,  12,
 12, 108, 115, 113,  36, 115, 101, 116,  95, 101, 108, 101, 109,  13,  13, 108,
115, 113,  36, 105, 110, 105, 116,  95, 100, 101, 114, 118,  12,  12, 108, 115,
113,  36, 115, 101, 116,  95, 100, 101, 114, 118,  13,  13, 108, 115, 113,  36,
115, 101, 116,  95,  99, 111, 110, 116, 114,  11,  11, 108, 115, 113,  36, 112,
114, 111,  99, 101, 115, 115,  16,  16, 108, 115, 113,  36, 114, 101, 115, 116,
111, 114, 101,  95, 112,  97, 114, 109,  10,  10, 108, 115, 113,  36,  99, 111,
114, 114, 101, 108,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 24 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 16 );

/* Declaration of external variables. */
extern V PAS__f_output;

/* Declaration of global variables. */
SL V_ndat;
SL V_np;
SL V_nsing;
F V_min_diag = 1.000000E-06;
F V_chi2eps;
F V_chi2;
F V_lchi2;
F V_nchi2;



/* Procedure/Function : " out_matrix "  */
void RPWDATA_LSQ_out_matrix(SL F_n, V F_mat, V F_bv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=146; /* line # 146 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[3]=147; /* line # 147 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+70,-1,-1,32);
  PAS__WRITE_INT(F_n,0,0);
  PAS__WRITE_CHAR(44);
  PAS__WRITE_INT(F_n,0,0);
  PAS__WRITE_STR(Rd.s+85,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=148; /* line # 148 */
  Rv0=1;
  Ra.sl[3]=149; /* line # 149 */
  Rv1=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=151; /* line # 151 */
    Rv2=1;
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=152; /* line # 152 */
      if (Rv2<Rv1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_FCHAR(32,12,-1,1,32);
      }
      else {
        Ra.sl[3]=153; /* line # 153 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])],11,4,0);
        Rv0=Rv0+1;
      }
      Rv2++;
    }
    Ra.sl[3]=154; /* line # 154 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+111,-1,-1,32);
    PAS__WRITE_SNGL(((F *)F_bv)[PAS__RANGE(Rv1,1,((SL *)F_bv)[0])],11,4,0);
    PAS__WRITE_EOLN();
    Rv1++;
  }
  Ra.sl[3]=156; /* line # 156 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " matinv "  */
void RPWDATA_LSQ_matinv(SL F_n, V F_mat, V F_bvc, V F_vsg, SL *F_scn){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  F Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  F Rv9;
  F Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  register int Rf2, Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+118;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=178; /* line # 178 */
  (*F_scn)=0;
  Ra.sl[3]=180; /* line # 180 */
  Rv0=1;
  Ra.sl[3]=181; /* line # 181 */
  Rv1=1;
  while (1){
    Ra.sl[3]=183; /* line # 183 */
    Rv2=Rv1-1;
    Rv3=Rv1;
    while (1){
      Ra.sl[3]=185; /* line # 185 */
      Rv4=(F)0.000000E-01;
      Rv5=Rv3;
      Rv6=Rv1;
      Ra.sl[3]=186; /* line # 186 */
      if (Rv2>0) {
        Ra.sl[3]=187; /* line # 187 */
        Rv7=1;
        for( Rf2=Rv2;Rf2>0;Rf2-- ) {
          Ra.sl[3]=189; /* line # 189 */
          Rv4=Rv4+((F *)F_mat)[PAS__RANGE(Rv5,1,((SL *)F_mat)[0])]*((F *)F_mat)[
          PAS__RANGE(Rv6,1,((SL *)F_mat)[0])];
          Ra.sl[3]=190; /* line # 190 */
          Rv8=F_n-Rv7;
          Rv5=Rv5+Rv8;
          Rv6=Rv6+Rv8;
          Rv7++;
        }
      }
      Ra.sl[3]=192; /* line # 192 */
      Rv9=((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]-Rv4;
      Ra.sl[3]=193; /* line # 193 */
      if (Rv3<=Rv1) {
        Ra.sl[3]=195; /* line # 195 */
        if (Rv9>V_min_diag) {
          Ra.sl[3]=197; /* line # 197 */
          Rv10=sqrt(Rv9);
          Ra.sl[3]=198; /* line # 198 */
          ((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]=Rv10;
          Ra.sl[3]=199; /* line # 199 */
          ((F *)((V *)F_vsg)[PAS__RANGE(Rv1,1,((SL *)F_vsg)[0])])[0]=(F)0.000000E-01;
        }
        else {
          Ra.sl[3]=203; /* line # 203 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+126,-1,-1,32);
          PAS__WRITE_INT(Rv1,4,0);
          PAS__WRITE_EOLN();
          Ra.sl[3]=204; /* line # 204 */
          (*F_scn)=(*F_scn)+1;
          Ra.sl[3]=205; /* line # 205 */
          Rv10=(F)1.000000E+00;
          ((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]=Rv10;
          Ra.sl[3]=207; /* line # 207 */
          Rv11=Rv0+1;
          for( Rf2=(((Rv0+F_n)-Rv1)+1)-(Rv0+1);Rf2>0;Rf2-- ) {
            ((F *)F_mat)[PAS__RANGE(Rv11,1,((SL *)F_mat)[0])]=(F)0.000000E-01;
            Rv11++;
          }
          Ra.sl[3]=208; /* line # 208 */
          Rv6=Rv1;
          Ra.sl[3]=209; /* line # 209 */
          Rv12=1;
          for( Rf2=Rv2;Rf2>0;Rf2-- ) {
            Ra.sl[3]=210; /* line # 210 */
            ((F *)F_mat)[PAS__RANGE(Rv6,1,((SL *)F_mat)[0])]=(F)0.000000E-01;
            Rv6=(Rv6+F_n)-Rv12;
            Rv12++;
          }
          Ra.sl[3]=211; /* line # 211 */
          ((F *)F_bvc)[PAS__RANGE(Rv1,1,((SL *)F_bvc)[0])]=(F)0.000000E-01;
          Ra.sl[3]=212; /* line # 212 */
          ((F *)((V *)F_vsg)[PAS__RANGE(Rv1,1,((SL *)F_vsg)[0])])[0]=(F)-1.000000E+00;
        }
      }
      else {
        Ra.sl[3]=215; /* line # 215 */
        ((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]=Rv9/Rv10;
      }
      Ra.sl[3]=216; /* line # 216 */
      Rv0=Rv0+1;
      Ra.sl[3]=217; /* line # 217 */
      Rv3=Rv3+1;
      if (Rv3>F_n)  break;
    }
    Ra.sl[3]=219; /* line # 219 */
    Rv1=Rv1+1;
    if (Rv1>F_n)  break;
  }
  Ra.sl[3]=223; /* line # 223 */
  ((F *)F_mat)[PAS__RANGE(1,1,((SL *)F_mat)[0])]=(F)1.000000E+00/((F *)F_mat)[PAS__RANGE(1,
1,((SL *)F_mat)[0])];
  Ra.sl[3]=224; /* line # 224 */
  Rv13=1;
  Ra.sl[3]=225; /* line # 225 */
  Rv14=2;
  for( Rf2=F_n-1;Rf2>0;Rf2-- ) {
    Ra.sl[3]=227; /* line # 227 */
    Rv13=((Rv13+F_n)-Rv14)+2;
    Ra.sl[3]=228; /* line # 228 */
    Rv9=(F)1.000000E+00/((F *)F_mat)[PAS__RANGE(Rv13,1,((SL *)F_mat)[0])];
    Ra.sl[3]=229; /* line # 229 */
    ((F *)F_mat)[PAS__RANGE(Rv13,1,((SL *)F_mat)[0])]=Rv9;
    Ra.sl[3]=230; /* line # 230 */
    Rv6=0;
    Rv5=Rv14;
    Rv2=Rv14-1;
    Ra.sl[3]=232; /* line # 232 */
    Rv15=1;
    for( Rf1=Rv2;Rf1>0;Rf1-- ) {
      Ra.sl[3]=234; /* line # 234 */
      Rv0=Rv5;
      Rv4=(F)0.000000E-01;
      Ra.sl[3]=235; /* line # 235 */
      Rv16=Rv15;
      for( Rf0=(Rv2+1)-Rv15;Rf0>0;Rf0-- ) {
        Ra.sl[3]=237; /* line # 237 */
        Rv17=Rv6+Rv16;
        Ra.sl[3]=238; /* line # 238 */
        Rv4=Rv4-((F *)F_mat)[PAS__RANGE(Rv5,1,((SL *)F_mat)[0])]*((F *)F_mat)[PAS__RANGE(
        Rv17,1,((SL *)F_mat)[0])];
        Ra.sl[3]=239; /* line # 239 */
        Rv5=(Rv5+F_n)-Rv16;
        Rv16++;
      }
      Ra.sl[3]=241; /* line # 241 */
      ((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]=Rv4*Rv9;
      Ra.sl[3]=242; /* line # 242 */
      Rv8=F_n-Rv15;
      Ra.sl[3]=243; /* line # 243 */
      Rv5=Rv0+Rv8;
      Ra.sl[3]=244; /* line # 244 */
      Rv6=Rv6+Rv8;
      Rv15++;
    }
    Rv14++;
  }
  Ra.sl[3]=248; /* line # 248 */
  Rv0=1;
  Ra.sl[3]=249; /* line # 249 */
  Rv18=1;
  for( Rf2=F_n;Rf2>0;Rf2-- ) {
    Ra.sl[3]=251; /* line # 251 */
    Rv5=Rv0;
    Ra.sl[3]=252; /* line # 252 */
    Rv19=Rv18;
    for( Rf1=(F_n+1)-Rv18;Rf1>0;Rf1-- ) {
      Ra.sl[3]=254; /* line # 254 */
      Rv6=Rv0;
      Rv2=(F_n-Rv19)+1;
      Rv4=(F)0.000000E-01;
      Ra.sl[3]=255; /* line # 255 */
      for( Rf0=Rv2;Rf0>0;Rf0-- ) {
        Ra.sl[3]=257; /* line # 257 */
        Rv4=Rv4+((F *)F_mat)[PAS__RANGE(Rv5,1,((SL *)F_mat)[0])]*((F *)F_mat)[PAS__RANGE(
        Rv6,1,((SL *)F_mat)[0])];
        Ra.sl[3]=258; /* line # 258 */
        Rv5=Rv5+1;
        Rv6=Rv6+1;
      }
      Ra.sl[3]=260; /* line # 260 */
      ((F *)F_mat)[PAS__RANGE(Rv0,1,((SL *)F_mat)[0])]=Rv4;
      Ra.sl[3]=261; /* line # 261 */
      Rv0=Rv0+1;
      Rv19++;
    }
    Rv18++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " solve "  */
void RPWDATA_LSQ_solve(SL F_n, V F_mat, V F_bvc, V F_bsh, V F_vsg, F F_chi2){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+178;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=285; /* line # 285 */
  Rv0=1;
  for( Rf1=F_n;Rf1>0;Rf1-- ) {
    Ra.sl[3]=287; /* line # 287 */
    Rv1=(F)0.000000E-01;
    Ra.sl[3]=288; /* line # 288 */
    Rv2=Rv0;
    Ra.sl[3]=289; /* line # 289 */
    Rv3=F_n-1;
    Ra.sl[3]=290; /* line # 290 */
    Rv4=1;
    for( Rf0=F_n;Rf0>0;Rf0-- ) {
      Ra.sl[3]=292; /* line # 292 */
      Rv1=Rv1+((F *)F_mat)[PAS__RANGE(Rv2,1,((SL *)F_mat)[0])]*((F *)F_bvc)[PAS__RANGE(
      Rv4,1,((SL *)F_bvc)[0])];
      Ra.sl[3]=293; /* line # 293 */
      if (Rv4<Rv0) {
        Ra.sl[3]=295; /* line # 295 */
        Rv2=Rv2+Rv3;
        Rv3=Rv3-1;
      }
      else {
        Ra.sl[3]=300; /* line # 300 */
        if (Rv0==Rv4&&((F *)((V *)F_vsg)[PAS__RANGE(Rv0,1,((SL *)F_vsg)[0])])[0]
        >=(F)0.000000E-01) {
          Ra.sl[3]=301; /* line # 301 */
          ((F *)((V *)F_vsg)[PAS__RANGE(Rv0,1,((SL *)F_vsg)[0])])[0]=sqrt(((F *)
          F_mat)[PAS__RANGE(Rv2,1,((SL *)F_mat)[0])]*F_chi2);
        }
        Ra.sl[3]=302; /* line # 302 */
        Rv2=Rv2+1;
      }
      Rv4++;
    }
    Ra.sl[3]=305; /* line # 305 */
    ((F *)F_bsh)[PAS__RANGE(Rv0,1,((SL *)F_bsh)[0])]=Rv1;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_pdescr "  */
void RPWDATA_LSQ_free_pdescr(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=316; /* line # 316 */
  if (Ri.v[0]!=NULL) {
    Ra.sl[3]=318; /* line # 318 */
    Rv0=Ri.v[0];
    Ra.sl[3]=319; /* line # 319 */
    while (Rv0!=NULL){
      Ra.sl[3]=321; /* line # 321 */
      Rv1=Rv0;
      Ra.sl[3]=322; /* line # 322 */
      Rv0=((V *)Rv0)[0];
      Ra.sl[3]=323; /* line # 323 */
      PAS__DISPOSE(&Rv1);
    }
  }
  Ra.sl[3]=326; /* line # 326 */
  Ri.v[0]=NULL;
  Ra.sl[3]=327; /* line # 327 */
  Ri.v[1]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init "  */
void P_lsq_Init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+198;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=337; /* line # 337 */
  if (Ri.v[2]!=NULL) {
    Ra.sl[3]=339; /* line # 339 */
    Rv0=Ri.v[2];
    Ra.sl[3]=340; /* line # 340 */
    while (Rv0!=NULL){
      Ra.sl[3]=342; /* line # 342 */
      Rv1=Rv0;
      Ra.sl[3]=343; /* line # 343 */
      Rv2=Rv1;
      Ra.sl[3]=345; /* line # 345 */
      PAS__DISPOSE(((V *)Rv2)+14);
      Ra.sl[3]=346; /* line # 346 */
      PAS__DISPOSE(((V *)Rv2)+13);
      Ra.sl[3]=347; /* line # 347 */
      PAS__DISPOSE(((V *)Rv2)+12);
      Ra.sl[3]=348; /* line # 348 */
      PAS__DISPOSE(((V *)Rv2)+11);
      Ra.sl[3]=349; /* line # 349 */
      PAS__DISPOSE(((V *)Rv2)+10);
      Ra.sl[3]=350; /* line # 350 */
      PAS__DISPOSE(((V *)Rv2)+9);
      Ra.sl[3]=351; /* line # 351 */
      PAS__DISPOSE(((V *)Rv2)+8);
      Ra.sl[3]=352; /* line # 352 */
      PAS__DISPOSE(((V *)Rv2)+7);
      Ra.sl[3]=353; /* line # 353 */
      Rv0=((V *)Rv2)[0];
      Ra.sl[3]=355; /* line # 355 */
      PAS__DISPOSE(&Rv1);
    }
  }
  Ra.sl[3]=358; /* line # 358 */
  if (Ri.v[0]!=NULL) RPWDATA_LSQ_free_pdescr();
  Ra.sl[3]=359; /* line # 359 */
  if (Ri.v[3]!=NULL) PAS__DISPOSE(Ri.v+3);
  Ra.sl[3]=360; /* line # 360 */
  Ri.v[3]=NULL;
  Ra.sl[3]=362; /* line # 362 */
  V_chi2=(F)1.000000E+010;
  Ra.sl[3]=363; /* line # 363 */
  V_lchi2=V_chi2;
  Ra.sl[3]=364; /* line # 364 */
  V_chi2eps=(F)1.000000E-04;
  Ra.sl[3]=365; /* line # 365 */
  Rs.ub[0]=0;
  Ra.sl[3]=367; /* line # 367 */
  Ri.v[2]=NULL;
  Ra.sl[3]=368; /* line # 368 */
  Ri.v[4]=NULL;
  Ra.sl[3]=369; /* line # 369 */
  Rs.sl[1]=0;
  Ra.sl[3]=370; /* line # 370 */
  V_np=0;
  Ra.sl[3]=371; /* line # 371 */
  Rs.sl[2]=0;
  Ra.sl[3]=372; /* line # 372 */
  V_nsing=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_New_vparm "  */
SL P_lsq_New_vparm(F *F_prm, F *F_sig, F F_min, F F_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+208;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=384; /* line # 384 */
  Rv0=PAS__NEW(20);
  Ra.sl[3]=385; /* line # 385 */
  Rv1=Rv0;
  Ra.sl[3]=387; /* line # 387 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[3]=388; /* line # 388 */
  if (F_min==(F)1.000000E+030&&F_max==(F)1.000000E+030) F_min= -F_min;
  Ra.sl[3]=389; /* line # 389 */
  ((F *)Rv1)[1]=F_min;
  ((F *)Rv1)[2]=F_max;
  Ra.sl[3]=390; /* line # 390 */
  ((V *)Rv1)[3]=((V) F_prm);
  Ra.sl[3]=391; /* line # 391 */
  ((V *)Rv1)[4]=((V) F_sig);
  Ra.sl[3]=393; /* line # 393 */
  if (Ri.v[0]==NULL) Ri.v[0]=Rv0;
  else {
    Ra.sl[3]=394; /* line # 394 */
    ((V *)Ri.v[1])[0]=Rv0;
  }
  Ra.sl[3]=395; /* line # 395 */
  Ri.v[1]=Rv0;
  Ra.sl[3]=396; /* line # 396 */
  V_np=V_np+1;
  Ra.sl[3]=397; /* line # 397 */
  Rs.sl[2]=Rs.sl[2]+1;
  Ra.sl[3]=398; /* line # 398 */
  Ret=V_np;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_New_block "  */
SL P_lsq_New_block(F F_dmp, F F_mrq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Rv2;
  register SL Rv3;
  register SL Rv4;
  register SL Rv5;
  register SL Rv6;
  register SL Rv7;
  register SL Rv8;
  register SL Rv9;
  register SL Rv10;
  register SL Rv11;
  register SL Rv12;
  register SL Rv13;
  register SL Rv14;
  register SL Rv15;
  register SL Rv16;
  register SL Rv17;
  V Rv18;
  SL Rv19;
  register V Rv20;
  register int Rf0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+223;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=412; /* line # 412 */
  if (Rs.sl[2]>0) {
    Ra.sl[3]=414; /* line # 414 */
    Rv0=PAS__NEW(60);
    Ra.sl[3]=415; /* line # 415 */
    Rs.sl[1]=Rs.sl[1]+1;
    Ra.sl[3]=416; /* line # 416 */
    Rv1=Rv0;
    Ra.sl[3]=418; /* line # 418 */
    ((V *)Rv1)[0]=NULL;
    Ra.sl[3]=419; /* line # 419 */
    ((SL *)Rv1)[1]=Rs.sl[1];
    Ra.sl[3]=420; /* line # 420 */
    ((SL *)Rv1)[2]=0;
    Ra.sl[3]=421; /* line # 421 */
    ((SL *)Rv1)[3]=V_np-Rs.sl[2];
    Ra.sl[3]=422; /* line # 422 */
    ((SL *)Rv1)[4]=Rs.sl[2];
    Ra.sl[3]=423; /* line # 423 */
    ((F *)Rv1)[5]=F_dmp;
    Ra.sl[3]=424; /* line # 424 */
    ((F *)Rv1)[6]=F_mrq;
    Ra.sl[3]=425; /* line # 425 */
    Rv2=Rs.sl[2];
    ((V *)Rv1)[7]=PAS__NEW(Rv2*4+4);
    ((SL *)((V *)Rv1)[7])[0]=Rv2;
    Rv3=0;
    for( Rf0=Rv2;Rf0>0;Rf0-- )
    Rv3++;
    Ra.sl[3]=426; /* line # 426 */
    Rv4=Rs.sl[2];
    ((V *)Rv1)[8]=PAS__NEW(Rv4*4+4);
    ((SL *)((V *)Rv1)[8])[0]=Rv4;
    Rv5=0;
    for( Rf0=Rv4;Rf0>0;Rf0-- )
    Rv5++;
    Ra.sl[3]=427; /* line # 427 */
    Rv6=Rs.sl[2];
    ((V *)Rv1)[9]=PAS__NEW(Rv6*4+4);
    ((SL *)((V *)Rv1)[9])[0]=Rv6;
    Rv7=0;
    for( Rf0=Rv6;Rf0>0;Rf0-- )
    Rv7++;
    Ra.sl[3]=428; /* line # 428 */
    Rv8=Rs.sl[2];
    ((V *)Rv1)[10]=PAS__NEW(Rv8*4+4);
    ((SL *)((V *)Rv1)[10])[0]=Rv8;
    Rv9=0;
    for( Rf0=Rv8;Rf0>0;Rf0-- )
    Rv9++;
    Ra.sl[3]=429; /* line # 429 */
    Rv10=Rs.sl[2];
    ((V *)Rv1)[11]=PAS__NEW(Rv10*4+4);
    ((SL *)((V *)Rv1)[11])[0]=Rv10;
    Rv11=0;
    for( Rf0=Rv10;Rf0>0;Rf0-- )
    Rv11++;
    Ra.sl[3]=430; /* line # 430 */
    Rv12=(Rs.sl[2]*(Rs.sl[2]+1))/2;
    ((V *)Rv1)[12]=PAS__NEW(Rv12*4+4);
    ((SL *)((V *)Rv1)[12])[0]=Rv12;
    Rv13=0;
    for( Rf0=Rv12;Rf0>0;Rf0-- )
    Rv13++;
    Ra.sl[3]=431; /* line # 431 */
    Rv14=Rs.sl[2];
    ((V *)Rv1)[13]=PAS__NEW(Rv14*4+4);
    ((SL *)((V *)Rv1)[13])[0]=Rv14;
    Rv15=0;
    for( Rf0=Rv14;Rf0>0;Rf0-- )
    Rv15++;
    Ra.sl[3]=432; /* line # 432 */
    Rv16=Rs.sl[2];
    ((V *)Rv1)[14]=PAS__NEW(Rv16*4+4);
    ((SL *)((V *)Rv1)[14])[0]=Rv16;
    Rv17=0;
    for( Rf0=Rv16;Rf0>0;Rf0-- )
    Rv17++;
    Ra.sl[3]=433; /* line # 433 */
    Rv18=Ri.v[0];
    Ra.sl[3]=434; /* line # 434 */
    Rv19=1;
    for( Rf0=Rs.sl[2];Rf0>0;Rf0-- ) {
      Ra.sl[3]=435; /* line # 435 */
      Rv20=Rv18;
      Ra.sl[3]=437; /* line # 437 */
      ((V *)((V *)Rv1)[13])[PAS__RANGE(Rv19,1,((SL *)((V *)Rv1)[13])[0])]=((V *)
      Rv20)[3];
      Ra.sl[3]=438; /* line # 438 */
      ((V *)((V *)Rv1)[14])[PAS__RANGE(Rv19,1,((SL *)((V *)Rv1)[14])[0])]=((V *)
      Rv20)[4];
      Ra.sl[3]=439; /* line # 439 */
      ((F *)((V *)Rv1)[10])[PAS__RANGE(Rv19,1,((SL *)((V *)Rv1)[10])[0])]=((F *)
      Rv20)[1];
      Ra.sl[3]=440; /* line # 440 */
      ((F *)((V *)Rv1)[11])[PAS__RANGE(Rv19,1,((SL *)((V *)Rv1)[11])[0])]=((F *)
      Rv20)[2];
      Ra.sl[3]=441; /* line # 441 */
      Rv18=((V *)Rv20)[0];
      Rv19++;
    }
    Ra.sl[3]=444; /* line # 444 */
    if (Ri.v[2]==NULL) Ri.v[2]=Rv0;
    else {
      Ra.sl[3]=445; /* line # 445 */
      ((V *)Ri.v[4])[0]=Rv0;
    }
    Ra.sl[3]=446; /* line # 446 */
    Ri.v[4]=Rv0;
    Ra.sl[3]=447; /* line # 447 */
    RPWDATA_LSQ_free_pdescr();
    Ra.sl[3]=448; /* line # 448 */
    Rs.sl[2]=0;
  }
  Ra.sl[3]=450; /* line # 450 */
  Ret=Rs.sl[1];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_Set_dmp_mrq "  */
void P_lsq_Set_dmp_mrq(SL F_id, F F_dmp, F F_mrq){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+238;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=462; /* line # 462 */
  if (F_id<=0) F_id=1;
  Ra.sl[3]=463; /* line # 463 */
  if (F_dmp<=(F)0.000000E-01||F_dmp>(F)1.000000E+00) F_dmp=(F)1.000000E+00;
  Ra.sl[3]=464; /* line # 464 */
  if (F_mrq<(F)0.000000E-01||F_mrq>(F)1.000000E+00) F_mrq=(F)1.000000E+00;
  Ra.sl[3]=465; /* line # 465 */
  Rv0=Ri.v[2];
  Ra.sl[3]=466; /* line # 466 */
  while (Rv0!=NULL){
    Ra.sl[3]=467; /* line # 467 */
    Rv1=Rv0;
    Ra.sl[3]=469; /* line # 469 */
    if (F_id==((SL *)Rv1)[1])  break;
    Ra.sl[3]=470; /* line # 470 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=472; /* line # 472 */
  if (Rv0!=NULL) {
    Ra.sl[3]=473; /* line # 473 */
    Rv2=Rv0;
    Ra.sl[3]=475; /* line # 475 */
    ((F *)Rv2)[5]=F_dmp;
    Ra.sl[3]=476; /* line # 476 */
    ((F *)Rv2)[6]=F_mrq;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init_cycle "  */
void P_lsq_Init_cycle(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+255;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=491; /* line # 491 */
  V_ndat=0;
  Ra.sl[3]=492; /* line # 492 */
  V_nchi2=(F)0.000000E-01;
  Ra.sl[3]=493; /* line # 493 */
  Rv0=Ri.v[2];
  Ra.sl[3]=494; /* line # 494 */
  while (Rv0!=NULL){
    Ra.sl[3]=495; /* line # 495 */
    Rv1=Rv0;
    Ra.sl[3]=497; /* line # 497 */
    Rv2=((V *)Rv1)[7];
    Ra.sl[3]=498; /* line # 498 */
    Rv3=((V *)Rv1)[12];
    Ra.sl[3]=499; /* line # 499 */
    Rv4=((SL *)Rv1)[4];
    Ra.sl[3]=500; /* line # 500 */
    Rv5=1;
    for( Rf0=Rv4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=502; /* line # 502 */
      ((F *)Rv2)[PAS__RANGE(Rv5,1,((SL *)Rv2)[0])]=(F)0.000000E-01;
      Rv5++;
    }
    Ra.sl[3]=504; /* line # 504 */
    Rv6=1;
    for( Rf0=(Rv4*(Rv4+1))/2;Rf0>0;Rf0-- ) {
      ((F *)Rv3)[PAS__RANGE(Rv6,1,((SL *)Rv3)[0])]=(F)0.000000E-01;
      Rv6++;
    }
    Ra.sl[3]=505; /* line # 505 */
    Rv0=((V *)Rv1)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_elem "  */
void P_lsq_Set_elem(F F_delta, F F_weight, V F_drvtab, SL F_size){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  SL Rv5;
  SL Rv6;
  F Rv7;
  F Rv8;
  SL Rv9;
  register F Rgf;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+271;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=521; /* line # 521 */
  Rv0=F_delta*F_weight;
  Ra.sl[3]=522; /* line # 522 */
  Rv1=Ri.v[2];
  Ra.sl[3]=523; /* line # 523 */
  while (Rv1!=NULL){
    Ra.sl[3]=524; /* line # 524 */
    Rv2=Rv1;
    Ra.sl[3]=526; /* line # 526 */
    Rv3=((V *)Rv2)[7];
    Ra.sl[3]=527; /* line # 527 */
    Rv4=((V *)Rv2)[12];
    Ra.sl[3]=528; /* line # 528 */
    Rv5=0;
    Ra.sl[3]=529; /* line # 529 */
    Rv6=1;
    for( Rf1=((SL *)Rv2)[4];Rf1>0;Rf1-- ) {
      Ra.sl[3]=531; /* line # 531 */
      Rv7=((F *)F_drvtab)[PAS__RANGE(Rv6,1,F_size)-1]*F_weight;
      Ra.sl[3]=532; /* line # 532 */
      Rv8=(Rv7*F_weight)*((F *)Rv2)[6];
      Ra.sl[3]=533; /* line # 533 */
      ((F *)Rv3)[PAS__RANGE(Rv6,1,((SL *)Rv3)[0])]=((F *)Rv3)[PAS__RANGE(Rv6,1,(
      (SL *)Rv3)[0])]+Rv0*Rv7;
      Ra.sl[3]=534; /* line # 534 */
      Rv5=Rv5+1;
      Ra.sl[3]=535; /* line # 535 */
      ((F *)Rv4)[PAS__RANGE(Rv5,1,((SL *)Rv4)[0])]=((F *)Rv4)[PAS__RANGE(Rv5,1,(
      (SL *)Rv4)[0])]+Rv7*Rv7;
      Ra.sl[3]=536; /* line # 536 */
      Rv9=Rv6+1;
      for( Rf0=(((SL *)Rv2)[4]+1)-(Rv6+1);Rf0>0;Rf0-- ) {
        Ra.sl[3]=538; /* line # 538 */
        Rv5=Rv5+1;
        Ra.sl[3]=539; /* line # 539 */
        ((F *)Rv4)[PAS__RANGE(Rv5,1,((SL *)Rv4)[0])]=((F *)Rv4)[PAS__RANGE(Rv5,1,
        ((SL *)Rv4)[0])]+Rv8*((F *)F_drvtab)[PAS__RANGE(Rv9,1,F_size)-1];
        Rv9++;
      }
      Rv6++;
    }
    Ra.sl[3]=542; /* line # 542 */
    Rv1=((V *)Rv2)[0];
  }
  Ra.sl[3]=544; /* line # 544 */
  V_ndat=V_ndat+1;
  Ra.sl[3]=545; /* line # 545 */
  V_nchi2=V_nchi2+Rv0*Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Init_derv "  */
void P_lsq_Init_derv(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  register SL Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+285;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=553; /* line # 553 */
  if (Ri.v[3]==NULL) {
    Rv0=V_np;
    Ri.v[3]=PAS__NEW(Rv0*4+4);
    ((SL *)Ri.v[3])[0]=Rv0;
    Rv1=0;
    for( Rf0=Rv0;Rf0>0;Rf0-- )
    Rv1++;
  }
  Ra.sl[3]=554; /* line # 554 */
  Rv2=1;
  for( Rf0=V_np;Rf0>0;Rf0-- ) {
    ((F *)Ri.v[3])[PAS__RANGE(Rv2,1,((SL *)Ri.v[3])[0])]=(F)0.000000E-01;
    Rv2++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_derv "  */
void P_lsq_Set_derv(SL F_id, F F_drv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+300;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=562; /* line # 562 */
  if (Ri.v[3]==NULL) P_lsq_Init_derv();
  Ra.sl[3]=563; /* line # 563 */
  if (F_id>=1&&F_id<=((SL *)Ri.v[3])[0]) {
    Ra.sl[3]=564; /* line # 564 */
    ((F *)Ri.v[3])[PAS__RANGE(F_id,1,((SL *)Ri.v[3])[0])]=((F *)Ri.v[3])[PAS__RANGE(
    F_id,1,((SL *)Ri.v[3])[0])]+F_drv;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Set_contr "  */
void P_lsq_Set_contr(F F_delta, F F_weight){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+314;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=572; /* line # 572 */
  if (Ri.v[3]!=NULL) {
    Ra.sl[3]=573; /* line # 573 */
    P_lsq_Set_elem(F_delta, F_weight, Ri.v[3]+4,((SL *)Ri.v[3])[0]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Process "  */
UB P_lsq_Process(UB F_bend, UB F_bchg, UB F_bmrq, F F_ch_parm(SL F_i, F F_v_o, F
F_v_n, F F_v_c, F F_v_s, F F_min, F F_max)){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  F Rv8;
  register V Rv9;
  SL Rv10;
  F Rv11;
  F Rv12;
  register int Rf0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+329;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=588; /* line # 588 */
  V_nsing=0;
  Ra.sl[3]=589; /* line # 589 */
  V_lchi2=V_chi2;
  Ra.sl[3]=590; /* line # 590 */
  if (V_ndat>V_np) V_chi2=V_nchi2/(float)(V_ndat-V_np);
  else {
    Ra.sl[3]=591; /* line # 591 */
    V_chi2=V_nchi2;
  }
  Ra.sl[3]=592; /* line # 592 */
  Rv0=Ri.v[2];
  Ra.sl[3]=593; /* line # 593 */
  while (Rv0!=NULL){
    Ra.sl[3]=594; /* line # 594 */
    Rv1=Rv0;
    Ra.sl[3]=599; /* line # 599 */
    RPWDATA_LSQ_matinv(((SL *)Rv1)[4],((V *)Rv1)[12],((V *)Rv1)[7],((V *)Rv1)[14]
    ,((SL *)Rv1)+2);
    Ra.sl[3]=600; /* line # 600 */
    RPWDATA_LSQ_solve(((SL *)Rv1)[4],((V *)Rv1)[12],((V *)Rv1)[7],((V *)Rv1)[8],(
    (V *)Rv1)[14],V_chi2);
    Ra.sl[3]=601; /* line # 601 */
    V_nsing=V_nsing+((SL *)Rv1)[2];
    Ra.sl[3]=606; /* line # 606 */
    if (F_bend) {
      Ra.sl[3]=608; /* line # 608 */
      Rv2=1;
      Ra.sl[3]=609; /* line # 609 */
      Rv3=2;
      Ra.sl[3]=610; /* line # 610 */
      Rv4=((SL *)Rv1)[4];
      Ra.sl[3]=611; /* line # 611 */
      Rv5=((V *)Rv1)[12];
      Ra.sl[3]=612; /* line # 612 */
      while (Rv4>1){
        Ra.sl[3]=614; /* line # 614 */
        Rv6=Rv2+Rv4;
        Ra.sl[3]=615; /* line # 615 */
        Rv7=Rv4-1;
        Ra.sl[3]=616; /* line # 616 */
        while (Rv7>0){
          Ra.sl[3]=618; /* line # 618 */
          Rv8=fabs(((F *)Rv5)[PAS__RANGE(Rv2,1,((SL *)Rv5)[0])]*((F *)Rv5)[PAS__RANGE(
          Rv6,1,((SL *)Rv5)[0])]);
          Ra.sl[3]=619; /* line # 619 */
          if (Rv8>=(F)1.000000E-04) ((F *)Rv5)[PAS__RANGE(Rv3,1,((SL *)Rv5)[0])]
          =((F *)Rv5)[PAS__RANGE(Rv3,1,((SL *)Rv5)[0])]/sqrt(Rv8);
          else {
            Ra.sl[3]=620; /* line # 620 */
            ((F *)Rv5)[PAS__RANGE(Rv3,1,((SL *)Rv5)[0])]=(F)0.000000E-01;
          }
          Ra.sl[3]=621; /* line # 621 */
          Rv3=Rv3+1;
          Ra.sl[3]=622; /* line # 622 */
          Rv6=Rv6+Rv7;
          Ra.sl[3]=623; /* line # 623 */
          Rv7=Rv7-1;
        }
        Ra.sl[3]=625; /* line # 625 */
        Rv3=Rv3+1;
        Ra.sl[3]=626; /* line # 626 */
        Rv2=Rv2+Rv4;
        Ra.sl[3]=627; /* line # 627 */
        Rv4=Rv4-1;
      }
    }
    Ra.sl[3]=630; /* line # 630 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=634; /* line # 634 */
  if ((F_bchg&&F_bmrq)&&Rs.ub[0]) {
    Ra.sl[3]=635; /* line # 635 */
    if (V_chi2-V_lchi2>V_chi2eps) F_bchg=0;
  }
  Ra.sl[3]=637; /* line # 637 */
  if (F_bchg) {
    Ra.sl[3]=639; /* line # 639 */
    Rv0=Ri.v[2];
    Ra.sl[3]=640; /* line # 640 */
    while (Rv0!=NULL){
      Ra.sl[3]=641; /* line # 641 */
      Rv9=Rv0;
      Ra.sl[3]=643; /* line # 643 */
      Rv10=1;
      for( Rf0=((SL *)Rv9)[4];Rf0>0;Rf0-- ) {
        Ra.sl[3]=645; /* line # 645 */
        Rv8=((F *)((V *)((V *)Rv9)[13])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[13])
        [0])])[0];
        Ra.sl[3]=646; /* line # 646 */
        ((F *)((V *)Rv9)[9])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[9])[0])]=Rv8;
        Ra.sl[3]=647; /* line # 647 */
        Rv11=((F *)Rv9)[5]*((F *)((V *)Rv9)[8])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)
        [8])[0])];
        Ra.sl[3]=648; /* line # 648 */
        Rv12=Rv8+Rv11;
        Ra.sl[3]=649; /* line # 649 */
        ((F *)((V *)((V *)Rv9)[13])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[13])[0])
        ])[0]=(*F_ch_parm)(Rv10+((SL *)Rv9)[3],Rv8, Rv12, Rv11,((F *)((V *)((V *)
        Rv9)[14])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[14])[0])])[0],((F *)((V *)
        Rv9)[10])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[10])[0])],((F *)((V *)Rv9)
        [11])[PAS__RANGE(Rv10,1,((SL *)((V *)Rv9)[11])[0])]);
        Rv10++;
      }
      Ra.sl[3]=651; /* line # 651 */
      Rv0=((V *)Rv9)[0];
    }
    Ra.sl[3]=653; /* line # 653 */
    Rs.ub[0]=1;
  }
  Ra.sl[3]=655; /* line # 655 */
  Ret=F_bchg;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lsq_Restore_parm "  */
void P_lsq_Restore_parm(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+342;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=666; /* line # 666 */
  Rv0=Ri.v[2];
  Ra.sl[3]=667; /* line # 667 */
  while (Rv0!=NULL){
    Ra.sl[3]=668; /* line # 668 */
    Rv1=Rv0;
    Ra.sl[3]=670; /* line # 670 */
    Rv2=1;
    for( Rf0=((SL *)Rv1)[4];Rf0>0;Rf0-- ) {
      Ra.sl[3]=671; /* line # 671 */
      ((F *)((V *)((V *)Rv1)[13])[PAS__RANGE(Rv2,1,((SL *)((V *)Rv1)[13])[0])])[
0]=((F *)((V *)Rv1)[9])[PAS__RANGE(Rv2,1,((SL *)((V *)Rv1)[9])[0])];
      Rv2++;
    }
    Ra.sl[3]=672; /* line # 672 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=674; /* line # 674 */
  V_chi2=V_lchi2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_Correl "  */
F P_lsq_Correl(SL F_ii, SL F_jj){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+360;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=687; /* line # 687 */
  if (F_ii==F_jj) Rv0=(F)1.000000E+00;
  else {
    Ra.sl[3]=691; /* line # 691 */
    Rv0=(F)0.000000E-01;
    Ra.sl[3]=692; /* line # 692 */
    Rv1=Ri.v[2];
    Ra.sl[3]=693; /* line # 693 */
    Rv2=F_ii;
    Ra.sl[3]=694; /* line # 694 */
    while (Rv1!=NULL){
      Ra.sl[3]=695; /* line # 695 */
      Rv3=Rv1;
      Ra.sl[3]=697; /* line # 697 */
      if (F_ii<=((SL *)Rv3)[4])  break;
      Ra.sl[3]=698; /* line # 698 */
      F_ii=F_ii-((SL *)Rv3)[4];
      Ra.sl[3]=699; /* line # 699 */
      F_jj=F_jj-((SL *)Rv3)[4];
      Ra.sl[3]=700; /* line # 700 */
      Rv1=((V *)Rv3)[0];
    }
    Ra.sl[3]=702; /* line # 702 */
    if (Rv1!=NULL) {
      Ra.sl[3]=703; /* line # 703 */
      Rv4=Rv1;
      Ra.sl[3]=704; /* line # 704 */
      if (F_jj>0&&F_jj<=((SL *)Rv4)[4]) {
        Ra.sl[3]=706; /* line # 706 */
        if (F_jj<F_ii) {
          Ra.sl[3]=707; /* line # 707 */
          Rv2=F_ii;
          F_ii=F_jj;
          F_jj=Rv2;
        }
        Ra.sl[3]=708; /* line # 708 */
        Rv2=(((SL *)Rv4)[4]*(F_ii-1)+F_jj)-(F_ii*(F_ii-1))/2;
        Ra.sl[3]=709; /* line # 709 */
        Rv0=((F *)((V *)Rv4)[12])[PAS__RANGE(Rv2,1,((SL *)((V *)Rv4)[12])[0])];
      }
    }
  }
  Ra.sl[3]=712; /* line # 712 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
