/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 960 ) = {
 17,  17, 114, 101, 102,  36, 100, 101, 102,  97, 117, 108, 116,  95, 115, 101,
116, 117, 112,  60,  60,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101,
114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116,
115,  47, 114, 112, 119, 100,  97, 116,  97,  95, 115, 114,  99,  47, 114, 112,
119, 100,  97, 116,  97,  95, 105, 110, 116,  95, 114, 101, 102,  46, 112,  97,
115,   0,   0,   0,   0,   0, 128,  64,   0,   0,  32,  64,   0,   0,   0,  63,
  0,   0,   0,   0, 205, 204,  76,  62,   0,   0,   0,   0,   3,   0,   0,   0,
  5,   0,   0,   0,   5,   0,   0,   0,   0,  11,  11, 112, 101,  97, 107,  95,
105, 110, 115, 101, 114, 116,  11,  11,  99, 114, 101,  97, 116, 101,  95, 112,
101,  97, 107,   9,   9, 115, 111, 114, 116,  95, 112, 101,  97, 107,  67,  67,
 42,  42,  42,  32,  82,  80,  87,  32,  87,  97, 114, 110, 105, 110, 103,  58,
 32,  82,  80,  87,  45,  98, 117, 103,  58,  32,  84, 104, 101,  32,  82, 101,
102, 108, 101,  99, 116, 105, 111, 110,  32,  76, 105, 110, 101, 115,  32,  99,
111, 117, 110, 116,  32, 105, 115,  32, 110, 111, 116,  32,  99, 111, 114, 114,
101,  99, 116,   9,   9, 102, 114, 101, 101,  95, 112, 101,  97, 107,  13,  13,
102, 114, 101, 101,  95,  97, 108, 108,  95, 112, 101,  97, 107,  11,  11,  99,
114, 101,  97, 116, 101,  95, 122, 111, 110, 101,   6,   6,  53,  32, 116, 114,
117, 101,   9,   9, 102, 114, 101, 101,  95, 122, 111, 110, 101,  13,  13, 102,
114, 101, 101,  95,  97, 108, 108,  95, 122, 111, 110, 101,  17,  17,  97, 100,
106, 117, 115, 116,  95, 112, 101,  97, 107,  95, 119, 105, 100, 116, 104,  10,
 10, 109,  97, 120,  95, 115, 101,  97, 114,  99, 104,  26,  26,  32, 105, 108,
 44,  32, 108, 105, 112,  44,  32, 105, 112,  44,  32, 114, 105, 112,  44,  32,
105, 114,  44,  32, 116, 104,  32,  19,  19, 115, 101, 116,  95, 114, 101, 102,
108, 101,  99, 116, 105, 111, 110,  95, 109,  97, 114, 107,  21,  21,  32,  67,
114, 101,  97, 116, 101,  32,  97,  32, 116, 104, 101,  32,  90, 111, 110, 101,
 32,  35,  32,   6,   6,  32, 102, 114, 111, 109,  32,   4,   4,  32, 116, 111,
 32,  24,  24,  32, 119, 105, 116, 104,  32, 105, 110, 100, 105,  99, 101, 115,
 32, 105, 110,  32, 114,  97, 110, 103, 101,  32,  91,   2,   2,  46,  46,  17,
 17, 108, 111,  99,  97, 116, 101,  95, 114, 101, 102, 108, 101,  99, 116, 105,
111, 110,  17,  17, 105, 110, 116, 101, 103, 114,  36, 114, 101, 102,  95, 108,
111,  99,  97, 116, 101,  13,  13, 109, 111, 118, 101,  95, 112, 101,  97, 107,
 95, 112, 111, 115,  15,  15,  97, 100, 106, 117, 115, 116,  95, 112, 101,  97,
107,  95, 112, 111, 115,  12,  12, 115, 101, 116,  95, 116, 111,  95, 118,  97,
108, 105, 100,  15,  15, 105, 110, 116, 101, 103, 114,  36, 114, 101, 102,  95,
 99, 111, 112, 121,  11,  11, 114, 101, 108, 111,  97, 100,  95, 122, 112,  99,
107,  19,  19, 105, 110, 116, 101, 103, 114,  36, 114, 101, 108, 111,  97, 100,
 95,  97,  95, 112,  99, 107,  19,  19, 105, 110, 116, 101, 103, 114,  36, 114,
101, 108, 111,  97, 100,  95, 122,  95, 112,  99, 107,   9,   9, 115,  97, 118,
101,  95, 122, 112,  99, 107,  17,  17, 105, 110, 116, 101, 103, 114,  36, 115,
 97, 118, 101,  95,  97,  95, 112,  99, 107,  17,  17, 105, 110, 116, 101, 103,
114,  36, 115,  97, 118, 101,  95, 122,  95, 112,  99, 107,  18,  18, 105, 110,
116, 101, 103, 114,  36, 115, 101, 116,  95, 114, 101, 102, 122, 111, 110, 101,
 76,  76,  42,  42,  42,  32,  82,  80,  87,  32,  69, 114, 114, 111, 114,  58,
 32,  82,  80,  87,  45,  98, 117, 103,  58,  32,  67,  97, 110, 110, 111, 116,
 32, 102, 105, 110, 100,  32, 116, 104, 101,  32, 108, 105, 110, 101,  32, 114,
101, 102, 108, 101,  99, 116, 105, 111, 110,  32, 112,  97, 116, 116, 101, 114,
110,  32,  97, 114, 114,  97, 121,  32, 105, 110, 100, 101, 120,  46,  18,  18,
105, 110, 116, 101, 103, 114,  36, 115, 101, 116,  95, 114, 101, 102, 108, 105,
110, 101,  15,  15, 105, 110, 116, 101, 103, 114,  36, 122, 111, 110, 101,  95,
100, 101, 108,  60,  60,  42,  42,  42,  32,  82,  80,  87,  32,  69, 114, 114,
111, 114,  58,  32,  67,  97, 110, 110, 111, 116,  32, 102, 105, 110, 100,  32,
116, 104, 101,  32, 105, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  32,
122, 111, 110, 101,  32, 116, 111,  32, 115, 117, 112, 112, 114, 101, 115, 115,
 46,  16,  16, 105, 110, 116, 101, 103, 114,  36, 102, 114, 101, 101,  95,  97,
108, 108, 122,  15,  15, 105, 110, 116, 101, 103, 114,  36, 108, 105, 110, 101,
 95, 100, 101, 108,  74,  74,  42,  42,  42,  32,  82,  80,  87,  32,  69, 114,
114, 111, 114,  58,  32,  78, 111,  32,  82, 101, 102, 108, 101,  99, 116, 105,
111, 110,  32,  76, 105, 110, 101, 115,  32, 102, 105, 110, 100,  32, 105, 110,
 32, 116, 104, 101,  32,  50,  42, 116, 104, 101, 116,  97,  32, 116, 111, 108,
101, 114,  97, 110,  99, 101,  32,  40,  48,  46,  50,  53, 239, 191, 189,  41
};

/* Define the local static Initialized section. */
static Blk( Ri, 960 ) = {
  1,   0,   0,   0,  10,   0,   0,   0,   0,   0,   0,   0,  62,  21,  82, 101,
102, 108, 101,  99, 116, 105, 111, 110,  32,  80,  97, 114,  97, 109, 101, 116,
101, 114, 115,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  75,   0, 100,   0,
 62,  30,  82, 102, 101,  95, 114,  32,  58,  32,  77, 105, 110,  46,  32, 115,
105, 103, 109,  97,  32, 100, 101, 116, 101,  99, 116,  32, 102,  97,  99,  46,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 45,  84,  25,   5,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 160,  65,  10, 215,  35,  60,  62,  30,  82, 102, 116,  95, 114,  32,
 58,  32,  84, 111, 112,  46,  32, 115, 105, 103, 109,  97,  32, 100, 101, 116,
101,  99, 116,  32, 102,  97,  99,  46,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  45,  76,  25,   5,   6,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 160,  65,  10, 215,  35,  60,
 62,  33,  82, 119,  48,  95, 116,  32,  58,  32,  77, 105, 110,  46,  32, 114,
101, 102,  46,  32, 119, 105, 100, 116, 104,  32,  99, 116, 101,  46,  32, 112,
 97, 114, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 45,  68,  25,   5,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,  32,  65,  10, 215,  35,  60,  62,  27,  82, 119,  49,  95, 116,  32,
 58,  32,  77, 105, 110,  46,  32, 114, 101, 102,  46,  32,  84,  97, 110,  32,
 99, 111, 101, 102,  46,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  45,  60,  25,   5,   6,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  32,  65,  10, 215,  35,  60,
 62,  28,  83, 112,  48,  95, 114,  32,  58,  32,  80, 114, 111, 102, 105, 108,
 32, 115, 112,  99,  46,  32, 112,  97, 114, 109,  46,  32,  35,  48,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 45,  52,  25,   5,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 128,  63,  10, 215,  35,  60,  62,  28,  83, 112,  49,  95, 114,  32,
 58,  32,  80, 114, 111, 102, 105, 108,  32, 115, 112,  99,  46,  32, 112,  97,
114, 109,  46,  32,  35,  49,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  45,  44,  25,   5,   6,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,  10, 215,  35,  60,
 62,  29,  82, 109, 114,  95, 110,  32,  58,  32,  82, 101, 102, 108,  46,  32,
109,  97, 114, 103, 105, 110,  32, 105, 110,  32, 100, 111, 116, 115,  46,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 45,  36,  25,   5,   5,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
 20,   0,   0,   0,   0,   0,   0,   0,  62,  30,  82, 109, 100,  95, 110,  32,
 58,  32,  77, 105, 110,  46,  32, 110, 117, 109,  98, 101, 114,  32, 105, 110,
 32,  97,  32, 114, 101, 102, 108,  46,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  45,  28,  25,   5,   5,   0,   0,   0,
  0,   0,   0,   0,   2,   0,   0,   0, 100,   0,   0,   0,   0,   0,   0,   0,
 62,  28,  82, 115, 112,  95, 110,  32,  58,  32,  77, 105, 110,  46,  32, 110,
117, 109,  98, 101, 114,  32,  98, 101, 116, 119, 101, 101, 110,  46,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 45,  20,  25,   5,   5,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
100,   0,   0,   0,   0,   0,   0,   0,  62,  33,  68, 101,  98, 117, 103,  32,
 58,  32,  68, 101,  98, 117, 103,  32, 116, 111,  32, 104, 101, 108, 112,  32,
102, 111, 114,  32, 115, 101, 116, 116, 105, 110, 103,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  65,  12,   5,   5,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_setup_tab, 48 );
extern V V_peak_free;
extern Blk(V_hkl_parm, 112 );
extern V V_peak_first;
extern V V_peak_last;
extern SL V_ntotpck;
extern V V_peak_curr;
extern Blk(V_str_msg, 264 );
extern SL V_nenapck;
extern V V_hkl_first;
extern V V_zone_first;
extern V V_zone_free;
extern V V_sel_pat;
extern V PAS__f_output;
extern SL V_nzone;
extern V V_zone_last;
extern V V_bckgrd_crv;
extern F V_cshift;
extern UB V_nerr_flg;
extern UB V_bfitini;
extern SL V_sel_iright;
extern SL V_sel_ileft;
extern V V_fitcmp_crv;

/* Declaration of global variables. */
Blk(V_ref_parm, 40 ) = {
  0,   0, 128,  64,   0,   0,  32,  64,
  0,   0,   0,  63,   0,   0,   0,   0,
205, 204,  76,  62,   0,   0,   0,   0,
  3,   0,   0,   0,   5,   0,   0,   0,
  5,   0,   0,   0,   0,   0,   0,   0 };

/* Function/procedure prototypes. */
void RPW_Set_Ref(V *F_p, V F_t);
void P_del_curve(V F_pc);
SL P_locate_angle(F F_ang, F F_tol, SL F_isc, UB F_brg, UB F_bif);


/* Procedure/Function : " ref_Default_setup "  */
void P_ref_Default_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=99; /* line # 99 */
  if (Ri.ub[0]) {
    Ra.sl[3]=101; /* line # 101 */
    Ra.sl[3]=103; /* line # 103 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(1,1,Ri.sl[1])*22+16),V_ref_parm.s);
    Ra.sl[3]=104; /* line # 104 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(2,1,Ri.sl[1])*22+16),V_ref_parm.s+4);
    Ra.sl[3]=105; /* line # 105 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(3,1,Ri.sl[1])*22+16),V_ref_parm.s+8);
    Ra.sl[3]=106; /* line # 106 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(4,1,Ri.sl[1])*22+16),V_ref_parm.s+12);
    Ra.sl[3]=107; /* line # 107 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(5,1,Ri.sl[1])*22+16),V_ref_parm.s+16);
    Ra.sl[3]=108; /* line # 108 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(6,1,Ri.sl[1])*22+16),V_ref_parm.s+20);
    Ra.sl[3]=109; /* line # 109 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(7,1,Ri.sl[1])*22+16),V_ref_parm.s+24);
    Ra.sl[3]=110; /* line # 110 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(8,1,Ri.sl[1])*22+16),V_ref_parm.s+28);
    Ra.sl[3]=111; /* line # 111 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(9,1,Ri.sl[1])*22+16),V_ref_parm.s+32);
    Ra.sl[3]=112; /* line # 112 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(10,1,Ri.sl[1])*22+16),V_ref_parm.s+36);
    Ra.sl[3]=114; /* line # 114 */
    V_setup_tab.v[PAS__RANGE(4,0,V_setup_tab.sl[0])+1]=Ri.s+4;
    Ra.sl[3]=115; /* line # 115 */
    Ri.ub[0]=0;
  }
  Ra.sl[3]=117; /* line # 117 */
  memcpy(V_ref_parm.s,Rd.s+84,37);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " peak_insert "  */
void RPW_INTARCH_PRC_00000000(V F_pk, V *F_pf, V *F_pl, UB F_bz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+121;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=134; /* line # 134 */
  Rv0=NULL;
  Ra.sl[3]=135; /* line # 135 */
  Rv1=(*F_pf);
  Ra.sl[3]=136; /* line # 136 */
  while (Rv1!=NULL){
    Ra.sl[3]=138; /* line # 138 */
    if (((F *)F_pk)[11]<((F *)Rv1)[11])  break;
    Ra.sl[3]=139; /* line # 139 */
    Rv0=Rv1;
    Ra.sl[3]=140; /* line # 140 */
    if (F_bz) Rv1=((V *)Rv1)[0];
    else {
      Ra.sl[3]=141; /* line # 141 */
      Rv1=((V *)Rv1)[1];
    }
  }
  Ra.sl[3]=144; /* line # 144 */
  if (Rv0==NULL) {
    Ra.sl[3]=146; /* line # 146 */
    if (F_bz) ((V *)F_pk)[0]=(*F_pf);
    else {
      Ra.sl[3]=147; /* line # 147 */
      ((V *)F_pk)[1]=(*F_pf);
    }
    Ra.sl[3]=148; /* line # 148 */
    (*F_pf)=F_pk;
  }
  else {
    Ra.sl[3]=151; /* line # 151 */
    if (F_bz) {
      ((V *)F_pk)[0]=Rv1;
      ((V *)Rv0)[0]=F_pk;
    }
    else {
      Ra.sl[3]=152; /* line # 152 */
      ((V *)F_pk)[1]=Rv1;
      ((V *)Rv0)[1]=F_pk;
    }
  }
  Ra.sl[3]=154; /* line # 154 */
  if (F_bz) {
    if (((V *)F_pk)[0]==NULL) (*F_pl)=F_pk;
  }
  else {
    Ra.sl[3]=155; /* line # 155 */
    if (((V *)F_pk)[1]==NULL) (*F_pl)=F_pk;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_peak "  */
V RPW_INTARCH_create_peak(V F_pz, F F_th, F F_wd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+134;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=160; /* line # 160 */
  if (V_peak_free!=NULL) {
    Ra.sl[3]=161; /* line # 161 */
    Rv0=V_peak_free;
    V_peak_free=((V *)Rv0)[1];
  }
  else {
    Ra.sl[3]=162; /* line # 162 */
    Rv0=PAS__NEW(86);
  }
  Ra.sl[3]=163; /* line # 163 */
  Rv1=Rv0;
  Ra.sl[3]=165; /* line # 165 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[3]=166; /* line # 166 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[3]=167; /* line # 167 */
  ((V *)Rv1)[2]=F_pz;
  Ra.sl[3]=168; /* line # 168 */
  ((F *)Rv1)[11]=F_th;
  ((F *)Rv1)[12]=(F)0.000000E-01;
  ((F *)Rv1)[8]=F_th;
  Ra.sl[3]=169; /* line # 169 */
  ((F *)Rv1)[13]=(F)0.000000E-01;
  ((F *)Rv1)[14]=(F)0.000000E-01;
  ((F *)Rv1)[9]=(F)0.000000E-01;
  Ra.sl[3]=170; /* line # 170 */
  ((F *)Rv1)[15]=F_wd;
  ((F *)Rv1)[16]=(F)0.000000E-01;
  ((F *)Rv1)[10]=F_wd;
  Ra.sl[3]=171; /* line # 171 */
  ((F *)Rv1)[17]=(F)0.000000E-01;
  ((F *)Rv1)[18]=(F)0.000000E-01;
  Ra.sl[3]=172; /* line # 172 */
  ((F *)Rv1)[19]=(F)0.000000E-01;
  Ra.sl[3]=173; /* line # 173 */
  ((F *)Rv1)[20]=(F)0.000000E-01;
  Ra.sl[3]=174; /* line # 174 */
  ((SL *)Rv1)[3]=0;
  Ra.sl[3]=175; /* line # 175 */
  ((SL *)Rv1)[4]=0;
  Ra.sl[3]=176; /* line # 176 */
  ((SL *)Rv1)[5]=0;
  Ra.sl[3]=177; /* line # 177 */
  ((SL *)Rv1)[6]=0;
  Ra.sl[3]=178; /* line # 178 */
  ((SL *)Rv1)[7]=0;
  Ra.sl[3]=179; /* line # 179 */
  Ra.sl[3]=180; /* line # 180 */
  if (V_hkl_parm.sl[23]>=0&&V_hkl_parm.sl[23]<=2) {
    Ra.sl[3]=181; /* line # 181 */
    ((UB *)Rv1)[84]=(UB)V_hkl_parm.sl[23];
  }
  else {
    Ra.sl[3]=182; /* line # 182 */
    ((UB *)Rv1)[84]=0;
  }
  Ra.sl[3]=183; /* line # 183 */
  ((UB *)Rv1)[85]=1;
  Ra.sl[3]=186; /* line # 186 */
  Rv2=F_pz;
  Ra.sl[3]=188; /* line # 188 */
  ((SL *)Rv2)[5]=((SL *)Rv2)[5]+1;
  Ra.sl[3]=189; /* line # 189 */
  RPW_INTARCH_PRC_00000000(Rv0,((V *)Rv2)+1,((V *)Rv2)+2,1);
  Ra.sl[3]=191; /* line # 191 */
  RPW_INTARCH_PRC_00000000(Rv0, &V_peak_first, &V_peak_last,0);
  Ra.sl[3]=193; /* line # 193 */
  V_ntotpck=V_ntotpck+1;
  Ra.sl[3]=194; /* line # 194 */
  V_peak_curr=Rv0;
  Ra.sl[3]=195; /* line # 195 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " sort_peak "  */
void P_sort_peak(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  SL Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+147;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=211; /* line # 211 */
  V_str_msg.ub[1]=0;
  Ra.sl[3]=212; /* line # 212 */
  if (V_ntotpck>1) {
    Ra.sl[3]=214; /* line # 214 */
    Rv0=V_ntotpck;
    Rv1=PAS__NEW(Rv0*4+4);
    ((SL *)Rv1)[0]=Rv0;
    Ra.sl[3]=216; /* line # 216 */
    Rv2=0;
    Ra.sl[3]=217; /* line # 217 */
    Rv3=V_peak_first;
    Ra.sl[3]=218; /* line # 218 */
    while (Rv3!=NULL&&Rv2<V_ntotpck){
      Ra.sl[3]=220; /* line # 220 */
      Rv2=Rv2+1;
      ((V *)Rv1)[PAS__RANGE(Rv2,1,((SL *)Rv1)[0])]=Rv3;
      Ra.sl[3]=221; /* line # 221 */
      Rv3=((V *)Rv3)[1];
    }
    Ra.sl[3]=224; /* line # 224 */
    if (Rv3!=NULL||Rv2!=V_ntotpck) {
      Ra.sl[3]=226; /* line # 226 */
      PAS__STR_TO_STR(V_str_msg.s,Rd.s+158);
      Ra.sl[3]=227; /* line # 227 */
      V_ntotpck=Rv2;
    }
    Ra.sl[3]=230; /* line # 230 */
    Rv4=1;
    for( Rf1=V_ntotpck-1;Rf1>0;Rf1-- ) {
      Ra.sl[3]=231; /* line # 231 */
      Rv5=Rv4+1;
      for( Rf0=(V_ntotpck+1)-(Rv4+1);Rf0>0;Rf0-- ) {
        Ra.sl[3]=232; /* line # 232 */
        if (((F *)((V *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])])[11]<((F *)((V *)
        Rv1)[PAS__RANGE(Rv4,1,((SL *)Rv1)[0])])[11]) {
          Ra.sl[3]=234; /* line # 234 */
          Rv6=((V *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])];
          Ra.sl[3]=235; /* line # 235 */
          ((V *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])]=((V *)Rv1)[PAS__RANGE(Rv4,
1,((SL *)Rv1)[0])];
          Ra.sl[3]=236; /* line # 236 */
          ((V *)Rv1)[PAS__RANGE(Rv4,1,((SL *)Rv1)[0])]=Rv6;
        }
        Rv5++;
      }
      Rv4++;
    }
    Ra.sl[3]=239; /* line # 239 */
    Rv7=((V *)Rv1)[PAS__RANGE(1,1,((SL *)Rv1)[0])];
    Ra.sl[3]=240; /* line # 240 */
    V_peak_first=Rv7;
    Ra.sl[3]=241; /* line # 241 */
    Rv8=2;
    for( Rf1=Rv2-1;Rf1>0;Rf1-- ) {
      Ra.sl[3]=243; /* line # 243 */
      Rv3=((V *)Rv1)[PAS__RANGE(Rv8,1,((SL *)Rv1)[0])];
      Ra.sl[3]=244; /* line # 244 */
      ((V *)Rv7)[1]=Rv3;
      Ra.sl[3]=245; /* line # 245 */
      Rv7=Rv3;
      Rv8++;
    }
    Ra.sl[3]=247; /* line # 247 */
    ((V *)Rv7)[1]=NULL;
    Ra.sl[3]=248; /* line # 248 */
    V_peak_last=Rv7;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_peak "  */
void RPW_INTARCH_free_peak(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=271; /* line # 271 */
  if (F_p!=NULL) {
    Ra.sl[3]=274; /* line # 274 */
    Rv0=((V *)F_p)[2];
    Ra.sl[3]=276; /* line # 276 */
    Rv1=((V *)Rv0)[3];
    Ra.sl[3]=277; /* line # 277 */
    while (Rv1!=NULL){
      Ra.sl[3]=279; /* line # 279 */
      if (((V *)Rv1)[3]==F_p) ((V *)Rv1)[3]=NULL;
      Ra.sl[3]=280; /* line # 280 */
      Rv1=((V *)Rv1)[0];
    }
    Ra.sl[3]=282; /* line # 282 */
    Rv2=((V *)Rv0)[1];
    Rv3=NULL;
    Ra.sl[3]=283; /* line # 283 */
    while (Rv2!=NULL&&Rv2!=F_p){
      Ra.sl[3]=284; /* line # 284 */
      Rv3=Rv2;
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[3]=285; /* line # 285 */
    if (Rv2!=NULL&&Rv2==F_p) {
      Ra.sl[3]=287; /* line # 287 */
      if (Rv3==NULL) ((V *)Rv0)[1]=((V *)F_p)[0];
      else {
        Ra.sl[3]=288; /* line # 288 */
        ((V *)Rv3)[0]=((V *)F_p)[0];
      }
      Ra.sl[3]=289; /* line # 289 */
      if (F_p==((V *)Rv0)[2]) ((V *)Rv0)[2]=Rv3;
    }
    Ra.sl[3]=291; /* line # 291 */
    if (((UB *)F_p)[85]) V_nenapck=V_nenapck-1;
    Ra.sl[3]=292; /* line # 292 */
    ((SL *)Rv0)[5]=((SL *)Rv0)[5]-1;
    Ra.sl[3]=296; /* line # 296 */
    Rv2=V_peak_first;
    Rv3=NULL;
    Ra.sl[3]=297; /* line # 297 */
    while (Rv2!=NULL&&Rv2!=F_p){
      Ra.sl[3]=298; /* line # 298 */
      Rv3=Rv2;
      Rv2=((V *)Rv2)[1];
    }
    Ra.sl[3]=299; /* line # 299 */
    if (Rv2!=NULL&&Rv2==F_p) {
      Ra.sl[3]=301; /* line # 301 */
      if (Rv3==NULL) V_peak_first=((V *)F_p)[1];
      else {
        Ra.sl[3]=302; /* line # 302 */
        ((V *)Rv3)[1]=((V *)F_p)[1];
      }
      Ra.sl[3]=303; /* line # 303 */
      if (F_p==V_peak_last) V_peak_last=Rv3;
    }
    Ra.sl[3]=306; /* line # 306 */
    V_ntotpck=V_ntotpck-1;
    Ra.sl[3]=308; /* line # 308 */
    ((V *)F_p)[1]=V_peak_free;
    Ra.sl[3]=309; /* line # 309 */
    V_peak_free=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_all_peak "  */
void RPW_INTARCH_free_all_peak(UB F_dethkl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+238;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=322; /* line # 322 */
  if (V_peak_first!=NULL&&V_peak_last!=NULL) {
    Ra.sl[3]=324; /* line # 324 */
    if (F_dethkl) {
      Ra.sl[3]=326; /* line # 326 */
      Rv0=V_hkl_first;
      Ra.sl[3]=327; /* line # 327 */
      while (Rv0!=NULL){
        ((V *)Rv0)[3]=NULL;
        Rv0=((V *)Rv0)[0];
      }
    }
    Ra.sl[3]=329; /* line # 329 */
    Rv1=V_zone_first;
    Ra.sl[3]=330; /* line # 330 */
    while (Rv1!=NULL){
      Ra.sl[3]=331; /* line # 331 */
      Rv2=Rv1;
      Ra.sl[3]=333; /* line # 333 */
      ((V *)Rv2)[1]=NULL;
      ((V *)Rv2)[2]=NULL;
      ((SL *)Rv2)[5]=0;
      Ra.sl[3]=334; /* line # 334 */
      Rv1=((V *)Rv2)[0];
    }
    Ra.sl[3]=336; /* line # 336 */
    ((V *)V_peak_last)[1]=V_peak_free;
    Ra.sl[3]=337; /* line # 337 */
    V_peak_free=V_peak_first;
    Ra.sl[3]=338; /* line # 338 */
    V_peak_last=NULL;
    Ra.sl[3]=339; /* line # 339 */
    V_peak_first=NULL;
  }
  Ra.sl[3]=341; /* line # 341 */
  V_nenapck=0;
  Ra.sl[3]=342; /* line # 342 */
  V_ntotpck=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_zone "  */
V RPW_INTARCH_create_zone(SL F_lfl, SL F_ril, V F_pz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  V Rv4;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+253;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=355; /* line # 355 */
  if (V_zone_free!=NULL) {
    Ra.sl[3]=356; /* line # 356 */
    Rv0=V_zone_free;
    V_zone_free=((V *)Rv0)[0];
  }
  else {
    Ra.sl[3]=357; /* line # 357 */
    Rv0=PAS__NEW(232);
  }
  Ra.sl[3]=358; /* line # 358 */
  Rv1=Rv0;
  Ra.sl[3]=360; /* line # 360 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[3]=361; /* line # 361 */
  ((V *)Rv1)[1]=NULL;
  ((V *)Rv1)[2]=NULL;
  Ra.sl[3]=362; /* line # 362 */
  ((V *)Rv1)[3]=NULL;
  ((V *)Rv1)[4]=NULL;
  Ra.sl[3]=363; /* line # 363 */
  ((SL *)Rv1)[5]=0;
  Ra.sl[3]=364; /* line # 364 */
  ((SL *)Rv1)[6]=1;
  ((SL *)Rv1)[7]=1;
  Ra.sl[3]=365; /* line # 365 */
  ((SL *)Rv1)[8]=F_lfl;
  ((SL *)Rv1)[9]=F_ril;
  Ra.sl[3]=366; /* line # 366 */
  ((SL *)Rv1)[10]=0;
  ((SL *)Rv1)[11]=0;
  Ra.sl[3]=367; /* line # 367 */
  ((SL *)Rv1)[12]=0;
  ((SL *)Rv1)[13]=0;
  Ra.sl[3]=368; /* line # 368 */
  ((F *)Rv1)[14]=((F *)V_sel_pat)[PAS__RANGE(F_lfl,1,((SL *)V_sel_pat)[0])*4+81]
  ;
  Ra.sl[3]=369; /* line # 369 */
  ((F *)Rv1)[15]=((F *)V_sel_pat)[PAS__RANGE(F_ril,1,((SL *)V_sel_pat)[0])*4+81]
  ;
  Ra.sl[3]=370; /* line # 370 */
  ((F *)Rv1)[16]=(F)-1.000000E+00;
  ((F *)Rv1)[17]=(F)-1.000000E+00;
  Ra.sl[3]=371; /* line # 371 */
  ((F *)Rv1)[18]=(F)0.000000E-01;
  Ra.sl[3]=372; /* line # 372 */
  ((F *)Rv1)[19]=(F)0.000000E-01;
  ((F *)Rv1)[20]=(F)0.000000E-01;
  Ra.sl[3]=373; /* line # 373 */
  ((F *)Rv1)[21]=(F)0.000000E-01;
  ((F *)Rv1)[22]=(F)0.000000E-01;
  Ra.sl[3]=374; /* line # 374 */
  ((F *)Rv1)[23]=V_ref_parm.f[4];
  ((F *)Rv1)[24]=V_ref_parm.f[5];
  Ra.sl[3]=375; /* line # 375 */
  ((F *)Rv1)[25]=(F)0.000000E-01;
  ((F *)Rv1)[26]=(F)0.000000E-01;
  Ra.sl[3]=376; /* line # 376 */
  ((F *)Rv1)[27]=(F)5.000000E-01*V_ref_parm.f[2];
  ((F *)Rv1)[28]=(F)5.000000E-01*V_ref_parm.f[3];
  Ra.sl[3]=377; /* line # 377 */
  ((F *)Rv1)[29]=(F)0.000000E-01;
  ((F *)Rv1)[30]=(F)0.000000E-01;
  Ra.sl[3]=378; /* line # 378 */
  Rv2=1;
  for( Rf0=9;Rf0>0;Rf0-- ) {
    Ra.sl[3]=379; /* line # 379 */
    ((F *)Rv1)[PAS__RANGE(Rv2,1,9)+30]=(F)0.000000E-01;
    ((F *)Rv1)[PAS__RANGE(Rv2,1,9)+39]=(F)-1.000000E+00;
    ((F *)Rv1)[PAS__RANGE(Rv2,1,9)+48]=(F)0.000000E-01;
    Rv2++;
  }
  Ra.sl[3]=381; /* line # 381 */
  if (((V *)Rv0)[0]!=NULL) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+266,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=382; /* line # 382 */
  V_nzone=V_nzone+1;
  Ra.sl[3]=383; /* line # 383 */
  if (F_pz==NULL) {
    Ra.sl[3]=385; /* line # 385 */
    if (V_zone_last==NULL) V_zone_first=Rv0;
    else {
      Ra.sl[3]=386; /* line # 386 */
      ((V *)V_zone_last)[0]=Rv0;
    }
    Ra.sl[3]=387; /* line # 387 */
    V_zone_last=Rv0;
  }
  else {
    Ra.sl[3]=391; /* line # 391 */
    Rv3=V_zone_first;
    Ra.sl[3]=392; /* line # 392 */
    Rv4=NULL;
    Ra.sl[3]=393; /* line # 393 */
    while (Rv3!=NULL&&Rv3!=F_pz){
      Ra.sl[3]=394; /* line # 394 */
      Rv4=Rv3;
      Rv3=((V *)Rv3)[0];
    }
    Ra.sl[3]=395; /* line # 395 */
    if (Rv3==F_pz) {
      Ra.sl[3]=397; /* line # 397 */
      ((V *)Rv0)[0]=Rv3;
      Ra.sl[3]=398; /* line # 398 */
      if (Rv4==NULL) V_zone_first=Rv0;
      else {
        Ra.sl[3]=399; /* line # 399 */
        ((V *)Rv4)[0]=Rv0;
      }
    }
  }
  Ra.sl[3]=402; /* line # 402 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " free_zone "  */
void RPW_INTARCH_free_zone(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+274;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=414; /* line # 414 */
  if (F_p!=NULL) {
    Ra.sl[3]=416; /* line # 416 */
    Rv0=V_zone_first;
    Rv1=NULL;
    Ra.sl[3]=417; /* line # 417 */
    while (Rv0!=NULL&&Rv0!=F_p){
      Ra.sl[3]=418; /* line # 418 */
      Rv1=Rv0;
      Rv0=((V *)Rv0)[0];
    }
    Ra.sl[3]=420; /* line # 420 */
    if (Rv0!=NULL&&Rv0==F_p) {
      Ra.sl[3]=422; /* line # 422 */
      Rv2=((V *)F_p)[1];
      Ra.sl[3]=423; /* line # 423 */
      while (Rv2!=NULL){
        Ra.sl[3]=425; /* line # 425 */
        Rv3=Rv2;
        Ra.sl[3]=426; /* line # 426 */
        Rv2=((V *)Rv2)[0];
        Ra.sl[3]=427; /* line # 427 */
        RPW_INTARCH_free_peak(Rv3);
      }
      Ra.sl[3]=429; /* line # 429 */
      Rv4=((V *)F_p)[3];
      Ra.sl[3]=430; /* line # 430 */
      while (Rv4!=NULL){
        Ra.sl[3]=432; /* line # 432 */
        ((V *)Rv4)[3]=NULL;
        ((V *)Rv4)[4]=NULL;
        Ra.sl[3]=433; /* line # 433 */
        Rv4=((V *)Rv4)[0];
      }
      Ra.sl[3]=435; /* line # 435 */
      ((V *)F_p)[3]=NULL;
      ((V *)F_p)[4]=NULL;
      Ra.sl[3]=436; /* line # 436 */
      V_nzone=V_nzone-1;
      Ra.sl[3]=437; /* line # 437 */
      if (Rv1==NULL) V_zone_first=((V *)F_p)[0];
      else {
        Ra.sl[3]=438; /* line # 438 */
        ((V *)Rv1)[0]=((V *)F_p)[0];
      }
      Ra.sl[3]=439; /* line # 439 */
      ((V *)F_p)[0]=V_zone_free;
      Ra.sl[3]=440; /* line # 440 */
      V_zone_free=F_p;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_all_zone "  */
void RPW_INTARCH_free_all_zone(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+285;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=452; /* line # 452 */
  Rv0=V_hkl_first;
  Ra.sl[3]=453; /* line # 453 */
  while (Rv0!=NULL){
    Ra.sl[3]=455; /* line # 455 */
    ((V *)Rv0)[3]=NULL;
    ((V *)Rv0)[4]=NULL;
    Ra.sl[3]=456; /* line # 456 */
    Rv0=((V *)Rv0)[0];
  }
  Ra.sl[3]=458; /* line # 458 */
  if (V_peak_first!=NULL) RPW_INTARCH_free_all_peak(0);
  Ra.sl[3]=459; /* line # 459 */
  ((V *)V_zone_last)[0]=V_zone_free;
  Ra.sl[3]=460; /* line # 460 */
  V_zone_free=V_zone_first;
  Ra.sl[3]=461; /* line # 461 */
  V_zone_last=NULL;
  Ra.sl[3]=462; /* line # 462 */
  V_zone_first=NULL;
  Ra.sl[3]=463; /* line # 463 */
  V_nzone=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " adjust_peak_width "  */
void RPW_INTARCH_adjust_peak_width(F F_lth, F F_rth, V F_pkh){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  F Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+300;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=474; /* line # 474 */
  Rv0=NULL;
  Ra.sl[3]=475; /* line # 475 */
  Rv1=F_pkh;
  Ra.sl[3]=476; /* line # 476 */
  while (Rv1!=NULL){
    Ra.sl[3]=477; /* line # 477 */
    Rv2=Rv1;
    Ra.sl[3]=479; /* line # 479 */
    if (Rv0==NULL) {
      Ra.sl[3]=481; /* line # 481 */
      Rv3=(((F *)Rv2)[11]-F_lth)/(F)2.500000E+00;
      Ra.sl[3]=482; /* line # 482 */
      if (((F *)Rv2)[15]>Rv3) ((F *)Rv2)[15]=Rv3;
    }
    else {
      Ra.sl[3]=486; /* line # 486 */
      Rv3=(((F *)Rv2)[11]-((F *)Rv0)[11])/(F)3.000000E+00;
      Ra.sl[3]=487; /* line # 487 */
      if (Rv3<((F *)Rv0)[15]) ((F *)Rv0)[15]=Rv3;
      Ra.sl[3]=488; /* line # 488 */
      if (Rv3<((F *)Rv2)[15]) ((F *)Rv2)[15]=Rv3;
    }
    Ra.sl[3]=490; /* line # 490 */
    Rv0=Rv1;
    Ra.sl[3]=491; /* line # 491 */
    Rv1=((V *)Rv2)[0];
  }
  Ra.sl[3]=493; /* line # 493 */
  if (Rv0!=NULL) {
    Ra.sl[3]=494; /* line # 494 */
    Rv4=Rv0;
    Ra.sl[3]=496; /* line # 496 */
    Rv3=(F_rth-((F *)Rv4)[11])/(F)2.500000E+00;
    Ra.sl[3]=497; /* line # 497 */
    if (Rv3<((F *)Rv4)[15]) ((F *)Rv4)[15]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " max_search "  */
void RPW_INTARCH_PRC_00000001(SL F_il, SL F_ir){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  SL Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  F Rv6;
  F Rv7;
  SL Rv8;
  F Rv9;
  SL Rv10;
  register V Rv11;
  register V Rv12;
  register V Rv13;
  F Rv14;
  F Rv15;
  SL Rv16;
  SL Rv17;
  register V Rv18;
  register V Rv19;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+319;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=516; /* line # 516 */
  Rv0=V_sel_pat;
  Ra.sl[3]=517; /* line # 517 */
  if (F_ir-F_il>=V_ref_parm.sl[7]) {
    Ra.sl[3]=520; /* line # 520 */
    Rv1=(F)0.000000E-01;
    Ra.sl[3]=521; /* line # 521 */
    Rv2=F_il+Lx[0].sl[0];
    for( Rf0=((F_ir-Lx[0].sl[0])+1)-(F_il+Lx[0].sl[0]);Rf0>0;Rf0-- ) {
      Ra.sl[3]=522; /* line # 522 */
      Rv3=(((S *)Rv0)+PAS__RANGE(Rv2,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=523; /* line # 523 */
      if (!(128&((UB *)Rv3)[14])) {
        Ra.sl[3]=524; /* line # 524 */
        if (Rv1<((F *)Rv3)[1]) {
          Ra.sl[3]=525; /* line # 525 */
          Rv1=((F *)Rv3)[1];
          Rv4=Rv2;
        }
      }
      Rv2++;
    }
    Ra.sl[3]=527; /* line # 527 */
    if (Rv4>((SL *)Rv0)[0]) Rv4=((SL *)Rv0)[0];
    else {
      Ra.sl[3]=528; /* line # 528 */
      if (Rv4<0) Rv4=1;
    }
    Ra.sl[3]=530; /* line # 530 */
    Rv5=(((S *)Rv0)+PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*16+324);
    Ra.sl[3]=532; /* line # 532 */
    Rv6=((F *)Rv5)[0];
    Ra.sl[3]=533; /* line # 533 */
    Rv7=V_ref_parm.f[2]+V_ref_parm.f[3]*tan((F)8.726646E-03*Rv6);
    Ra.sl[3]=535; /* line # 535 */
    Lx[0].sl[1]=Rv4-1;
    Lx[0].sl[2]=Rv4+1;
    Rv8=1;
    Rv9=(float)Rv4;
    Ra.sl[3]=536; /* line # 536 */
    Rv10=Rv4-1;
    Ra.sl[3]=537; /* line # 537 */
    while (Rv10>=F_il){
      Ra.sl[3]=538; /* line # 538 */
      Rv11=(((S *)Rv0)+PAS__RANGE(Rv10,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=540; /* line # 540 */
      if (((F *)Rv11)[1]+V_ref_parm.f[1]*((F *)Rv11)[2]>=Rv1) {
        Ra.sl[3]=542; /* line # 542 */
        Rv9=Rv9+(float)Rv10;
        Rv8=Rv8+1;
        Lx[0].sl[1]=Rv10;
      }
      Ra.sl[3]=544; /* line # 544 */
      if (((F *)Rv11)[0]<Rv6-Rv7)  break;
      Ra.sl[3]=545; /* line # 545 */
      Rv10=Rv10-1;
    }
    Ra.sl[3]=547; /* line # 547 */
    Rv10=Rv4+1;
    Ra.sl[3]=548; /* line # 548 */
    while (Rv10<=F_ir){
      Ra.sl[3]=549; /* line # 549 */
      Rv12=(((S *)Rv0)+PAS__RANGE(Rv10,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=551; /* line # 551 */
      if (((F *)Rv12)[1]+V_ref_parm.f[1]*((F *)Rv12)[2]>=Rv1) {
        Ra.sl[3]=553; /* line # 553 */
        Rv9=Rv9+(float)Rv10;
        Rv8=Rv8+1;
        Lx[0].sl[2]=Rv10;
      }
      Ra.sl[3]=555; /* line # 555 */
      if (((F *)Rv12)[0]>Rv6+Rv7)  break;
      Ra.sl[3]=556; /* line # 556 */
      Rv10=Rv10+1;
    }
    Ra.sl[3]=561; /* line # 561 */
    if (Rv8>0) {
      Ra.sl[3]=563; /* line # 563 */
      Rv4=PAS__F_ROUND(Rv9/(float)Rv8);
      Ra.sl[3]=564; /* line # 564 */
      if (Lx[0].sl[2]-F_il>Lx[0].sl[0]&&F_ir-Lx[0].sl[1]>Lx[0].sl[0]) {
        Ra.sl[3]=566; /* line # 566 */
        Rv13=(((S *)Rv0)+PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*16+324);
        Ra.sl[3]=568; /* line # 568 */
        ((UB *)Rv13)[14]=((UB *)Rv13)[14]|4;
        Ra.sl[3]=569; /* line # 569 */
        if (V_ref_parm.ub[36]) {
          Ra.sl[3]=570; /* line # 570 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+331,-1,-1,32);
          PAS__WRITE_INT(F_il,5,0);
          PAS__WRITE_INT(Lx[0].sl[1],5,0);
          PAS__WRITE_INT(Rv4,5,0);
          PAS__WRITE_INT(Lx[0].sl[2],5,0);
          PAS__WRITE_INT(F_ir,6,0);
          PAS__WRITE_SNGL(((F *)Rv13)[0],8,3,0);
          PAS__WRITE_EOLN();
        }
        Ra.sl[3]=571; /* line # 571 */
        RPW_INTARCH_create_peak(Lx[0].v[3],((F *)Rv13)[0],V_ref_parm.f[2]+V_ref_parm
        .f[3]*tan((F)8.726646E-03*((F *)Rv13)[0]));
        Ra.sl[3]=573; /* line # 573 */
        Lx[0].sl[4]=Lx[0].sl[4]+1;
      }
      Ra.sl[3]=577; /* line # 577 */
      if (((F *)Rv0)[PAS__RANGE(Lx[0].sl[1],1,((SL *)Rv0)[0])*4+81]-((F *)Rv0)[PAS__RANGE(
      F_il,1,((SL *)Rv0)[0])*4+81]>Rv7) {
        Ra.sl[3]=580; /* line # 580 */
        Rv14=Rv1;
        Rv15=Rv1;
        Ra.sl[3]=581; /* line # 581 */
        Rv16=0;
        Rv10=(Rv4-Lx[0].sl[0])-1;
        Rv17=0;
        Ra.sl[3]=582; /* line # 582 */
        while (Rv10>F_il){
          Ra.sl[3]=583; /* line # 583 */
          Rv18=(((S *)Rv0)+PAS__RANGE(Rv10,1,((SL *)Rv0)[0])*16+324);
          Ra.sl[3]=585; /* line # 585 */
          if (!(128&((UB *)Rv18)[14])) {
            Ra.sl[3]=587; /* line # 587 */
            if (((F *)Rv18)[1]<Rv15) {
              Ra.sl[3]=589; /* line # 589 */
              Rv15=((F *)Rv18)[1];
              Rv14=Rv15;
              Rv16=Rv10;
              Rv17=0;
            }
            else {
              Ra.sl[3]=592; /* line # 592 */
              if (((F *)Rv18)[1]>Rv14) {
                Ra.sl[3]=594; /* line # 594 */
                Rv14=((F *)Rv18)[1];
                Rv17=Rv10;
                Ra.sl[3]=595; /* line # 595 */
                if (Rv17>0&&Rv16-Rv17>=Lx[0].sl[0])  break;
              }
            }
          }
          Ra.sl[3]=598; /* line # 598 */
          Rv10=Rv10-1;
        }
        Ra.sl[3]=600; /* line # 600 */
        if ((Rv16>0&&Rv16-Rv17>=Lx[0].sl[0])&&Rv17>0) {
          Ra.sl[3]=605; /* line # 605 */
          RPW_INTARCH_PRC_00000001(F_il, Rv16);
        }
      }
      Ra.sl[3]=611; /* line # 611 */
      if (((F *)Rv0)[PAS__RANGE(F_ir,1,((SL *)Rv0)[0])*4+81]-((F *)Rv0)[PAS__RANGE(
      Lx[0].sl[2],1,((SL *)Rv0)[0])*4+81]>Rv7) {
        Ra.sl[3]=614; /* line # 614 */
        Rv14=Rv1;
        Rv15=Rv1;
        Ra.sl[3]=615; /* line # 615 */
        Rv16=0;
        Rv10=(Rv4+Lx[0].sl[0])+1;
        Rv17=0;
        Ra.sl[3]=616; /* line # 616 */
        while (Rv10<F_ir){
          Ra.sl[3]=617; /* line # 617 */
          Rv19=(((S *)Rv0)+PAS__RANGE(Rv10,1,((SL *)Rv0)[0])*16+324);
          Ra.sl[3]=619; /* line # 619 */
          if (!(128&((UB *)Rv19)[14])) {
            Ra.sl[3]=621; /* line # 621 */
            if (((F *)Rv19)[1]<Rv15) {
              Ra.sl[3]=623; /* line # 623 */
              Rv15=((F *)Rv19)[1];
              Rv14=Rv15;
              Rv16=Rv10;
              Rv17=0;
            }
            else {
              Ra.sl[3]=626; /* line # 626 */
              if (((F *)Rv19)[1]>Rv14) {
                Ra.sl[3]=628; /* line # 628 */
                Rv14=((F *)Rv19)[1];
                Rv17=Rv10;
                Ra.sl[3]=629; /* line # 629 */
                if (Rv17>0&&Rv17-Rv16>=Lx[0].sl[0])  break;
              }
            }
          }
          Ra.sl[3]=632; /* line # 632 */
          Rv10=Rv10+1;
        }
        Ra.sl[3]=634; /* line # 634 */
        if ((Rv16>0&&Rv17-Rv16>=Lx[0].sl[0])&&Rv17>0) {
          Ra.sl[3]=639; /* line # 639 */
          RPW_INTARCH_PRC_00000001(Rv16, F_ir);
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_reflection_mark "  */
V RPW_INTARCH_set_reflection_mark(SL F_il, SL F_ir){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+20;
  Ra.v[6]=Rd.s+359;
  Ra.v[7]=Rd.s+19;
  Ra.sl[8]=650; /* line # 650 */
  if (V_sel_pat!=NULL) {
    Ra.sl[8]=651; /* line # 651 */
    Rv0=V_sel_pat;
    Ra.sl[8]=654; /* line # 654 */
    Rv1=(F)0.000000E-01;
    Ra.sl[8]=655; /* line # 655 */
    Rv2=F_il;
    Ra.sl[8]=656; /* line # 656 */
    Ra.sl[0]=V_ref_parm.sl[8]/2;
    Ra.sl[8]=657; /* line # 657 */
    if (Ra.sl[0]<2) Ra.sl[0]=2;
    Ra.sl[8]=659; /* line # 659 */
    Rv3=(((S *)Rv0)+PAS__RANGE(F_il,1,((SL *)Rv0)[0])*16+324);
    ((UB *)Rv3)[14]=((UB *)Rv3)[14]|1;
    Ra.sl[8]=660; /* line # 660 */
    Rv4=(((S *)Rv0)+PAS__RANGE(F_ir,1,((SL *)Rv0)[0])*16+324);
    ((UB *)Rv4)[14]=((UB *)Rv4)[14]|2;
    Ra.sl[8]=661; /* line # 661 */
    Ra.v[3]=RPW_INTARCH_create_zone(F_il, F_ir,NULL);
    Ra.sl[8]=662; /* line # 662 */
    if (V_ref_parm.ub[36]) {
      Ra.sl[8]=663; /* line # 663 */
      Rv5=Ra.v[3];
      Ra.sl[8]=664; /* line # 664 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+380,-1,-1,32);
      PAS__WRITE_INT(V_nzone,4,0);
      PAS__WRITE_STR(Rd.s+403,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv5)[14],8,2,0);
      PAS__WRITE_STR(Rd.s+411,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv5)[15],8,2,0);
      PAS__WRITE_STR(Rd.s+417,-1,-1,32);
      PAS__WRITE_INT(F_il,0,0);
      PAS__WRITE_STR(Rd.s+443,-1,-1,32);
      PAS__WRITE_INT(F_ir,0,0);
      PAS__WRITE_CHAR(93);
      PAS__WRITE_EOLN();
    }
    Ra.sl[8]=666; /* line # 666 */
    Ra.sl[4]=0;
    Ra.sl[8]=667; /* line # 667 */
    RPW_INTARCH_PRC_00000001(F_il, F_ir);
    Ra.sl[8]=670; /* line # 670 */
    if (Ra.v[3]!=NULL) {
      Ra.sl[8]=671; /* line # 671 */
      Rv6=Ra.v[3];
      Ra.sl[8]=672; /* line # 672 */
      RPW_INTARCH_adjust_peak_width(((F *)Rv0)[PAS__RANGE(F_il,1,((SL *)Rv0)[0])
      *4+81],((F *)Rv0)[PAS__RANGE(F_ir,1,((SL *)Rv0)[0])*4+81],((V *)Rv6)[1]);
    }
  }
  Ra.sl[8]=674; /* line # 674 */
  Ret=Ra.v[3];
  PAS__curr_cntx=Ra.v[5];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " locate_reflection "  */
void RPW_INTARCH_locate_reflection(SL F_ifrs, SL F_ilst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  SL Rv8;
  register V Rv9;
  F Rv10;
  SL Rv11;
  SL Rv12;
  V Rv13;
  SL Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+447;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=689; /* line # 689 */
  if (V_zone_first!=NULL) RPW_INTARCH_free_all_zone();
  Ra.sl[3]=690; /* line # 690 */
  V_nzone=0;
  Ra.sl[3]=691; /* line # 691 */
  Rv0=0;
  Ra.sl[3]=692; /* line # 692 */
  if (V_sel_pat!=NULL&&V_bckgrd_crv!=NULL) {
    Ra.sl[3]=693; /* line # 693 */
    Rv1=V_sel_pat;
    Rv2=V_bckgrd_crv;
    Ra.sl[3]=695; /* line # 695 */
    if (V_ref_parm.sl[7]<V_ref_parm.sl[8]) V_ref_parm.sl[8]=V_ref_parm.sl[7];
    Ra.sl[3]=696; /* line # 696 */
    Rv3=0;
    Ra.sl[3]=697; /* line # 697 */
    Rv4=2*((SL *)Rv2)[0];
    Ra.sl[3]=698; /* line # 698 */
    Ra.f[4]=((F *)Rv2)[PAS__RANGE(1,1,2*((SL *)Rv2)[0])+8];
    Ra.f[6]=((F *)Rv2)[PAS__RANGE(2,1,2*((SL *)Rv2)[0])+8]-V_cshift;
    Ra.sl[3]=699; /* line # 699 */
    Ra.f[5]=((F *)Rv2)[PAS__RANGE(3,1,2*((SL *)Rv2)[0])+8];
    Ra.f[7]=((F *)Rv2)[PAS__RANGE(4,1,2*((SL *)Rv2)[0])+8]-V_cshift;
    Rv5=4;
    Ra.sl[3]=700; /* line # 700 */
    Rv6=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
    Ra.sl[3]=701; /* line # 701 */
    Rv7=Ra.f[7]-Rv6*Ra.f[5];
    Ra.sl[3]=702; /* line # 702 */
    Rv8=F_ifrs;
    for( Rf0=(F_ilst+1)-F_ifrs;Rf0>0;Rf0-- ) {
      Ra.sl[3]=703; /* line # 703 */
      Rv9=(((S *)Rv1)+PAS__RANGE(Rv8,1,((SL *)Rv1)[0])*16+324);
      Ra.sl[3]=704; /* line # 704 */
      if (!(128&((UB *)Rv9)[14])) {
        Ra.sl[3]=706; /* line # 706 */
        ((UB *)Rv9)[14]=((UB *)Rv9)[14]&~31;
        Ra.sl[3]=707; /* line # 707 */
        if (((F *)Rv9)[0]>Ra.f[5]&&Rv5<Rv4) {
          Ra.sl[3]=709; /* line # 709 */
          Ra.f[4]=Ra.f[5];
          Ra.f[6]=Ra.f[7];
          Ra.sl[3]=710; /* line # 710 */
          Rv5=Rv5+1;
          Ra.f[5]=((F *)Rv2)[PAS__RANGE(Rv5,1,2*((SL *)Rv2)[0])+8];
          Ra.sl[3]=711; /* line # 711 */
          Rv5=Rv5+1;
          Ra.f[7]=((F *)Rv2)[PAS__RANGE(Rv5,1,2*((SL *)Rv2)[0])+8]-V_cshift;
          Ra.sl[3]=712; /* line # 712 */
          Rv6=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
          Ra.sl[3]=713; /* line # 713 */
          Rv7=Ra.f[7]-Rv6*Ra.f[5];
        }
        Ra.sl[3]=715; /* line # 715 */
        Rv10=Rv6*((F *)Rv9)[0]+Rv7;
        Ra.sl[3]=716; /* line # 716 */
        if (((F *)Rv9)[1]-Rv10>V_ref_parm.f[0]*((F *)Rv9)[2]) {
          Ra.sl[3]=718; /* line # 718 */
          Rv11=0;
          Ra.sl[3]=719; /* line # 719 */
          if (Rv0&&!Rv3) {
            Ra.sl[3]=720; /* line # 720 */
            Rv12=Rv8-1;
            Rv3=1;
          }
        }
        else {
          Ra.sl[3]=724; /* line # 724 */
          if (Rv3) {
            Ra.sl[3]=726; /* line # 726 */
            if (Rv8-Rv12>=V_ref_parm.sl[7]) {
              Ra.sl[3]=728; /* line # 728 */
              if (Rv11==0) Rv11=Rv8;
              Ra.sl[3]=729; /* line # 729 */
              if (Rv8-Rv11>=2) {
                Ra.sl[3]=731; /* line # 731 */
                Rv13=RPW_INTARCH_set_reflection_mark(Rv12, Rv11);
                Ra.sl[3]=733; /* line # 733 */
                Rv3=0;
              }
            }
            else {
              Ra.sl[3]=735; /* line # 735 */
              Rv3=0;
            }
          }
          Ra.sl[3]=737; /* line # 737 */
          Rv0=1;
        }
      }
      Rv8++;
    }
    Ra.sl[3]=742; /* line # 742 */
    if (V_zone_first!=NULL) {
      Ra.sl[3]=744; /* line # 744 */
      Rv14=F_ifrs;
      Ra.sl[3]=745; /* line # 745 */
      Rv5=F_ifrs;
      Ra.sl[3]=746; /* line # 746 */
      Rv13=V_zone_first;
      while (1){
        Ra.sl[3]=749; /* line # 749 */
        while (Rv14<F_ilst&&!(1&((UB *)Rv1)[PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+
338]))
        Rv14=Rv14+1;
        Ra.sl[3]=750; /* line # 750 */
        if (Rv14>=F_ilst)  break;
        Ra.sl[3]=752; /* line # 752 */
        if (!(2&((UB *)Rv1)[PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+338])) {
          Ra.sl[3]=754; /* line # 754 */
          Rv12=Rv14-V_ref_parm.sl[6];
          Ra.sl[3]=755; /* line # 755 */
          if (Rv12<Rv5) Rv12=Rv5;
          Ra.sl[3]=756; /* line # 756 */
          while (Rv12<Rv14&&128&((UB *)Rv1)[PAS__RANGE(Rv12,1,((SL *)Rv1)[0])*16+
338])
          Rv12=Rv12+1;
          Ra.sl[3]=757; /* line # 757 */
          if (Rv12<Rv14) {
            Ra.sl[3]=759; /* line # 759 */
            Rv15=(((S *)Rv1)+PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+324);
            ((UB *)Rv15)[14]=((UB *)Rv15)[14]&~1;
            Ra.sl[3]=760; /* line # 760 */
            Rv16=(((S *)Rv1)+PAS__RANGE(Rv12,1,((SL *)Rv1)[0])*16+324);
            ((UB *)Rv16)[14]=((UB *)Rv16)[14]|1;
            Ra.sl[3]=761; /* line # 761 */
            Rv17=Rv13;
            Ra.sl[3]=762; /* line # 762 */
            ((SL *)Rv17)[6]=(Rv14-Rv12)+1;
            ((SL *)Rv17)[8]=Rv12;
          }
        }
        Ra.sl[3]=765; /* line # 765 */
        Rv14=Rv14+1;
        Ra.sl[3]=767; /* line # 767 */
        while (Rv14<F_ilst&&!(2&((UB *)Rv1)[PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+
338]))
        Rv14=Rv14+1;
        Ra.sl[3]=768; /* line # 768 */
        if (Rv14>=F_ilst)  break;
        Ra.sl[3]=769; /* line # 769 */
        Rv5=Rv14;
        Ra.sl[3]=770; /* line # 770 */
        if (!(1&((UB *)Rv1)[PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+338])) {
          Ra.sl[3]=772; /* line # 772 */
          Rv12=Rv14+2*V_ref_parm.sl[6];
          if (Rv12>F_ilst) Rv12=F_ilst;
          Ra.sl[3]=773; /* line # 773 */
          Rv5=Rv14+1;
          Ra.sl[3]=774; /* line # 774 */
          while (Rv5<Rv12&&!(1&((UB *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])*16+338]
          ))
          Rv5=Rv5+1;
          Ra.sl[3]=775; /* line # 775 */
          if (Rv5-Rv14<2*V_ref_parm.sl[6]) Rv5=Rv14+(Rv5-Rv14)/2;
          else {
            Ra.sl[3]=776; /* line # 776 */
            Rv5=Rv14+V_ref_parm.sl[6];
          }
          Ra.sl[3]=777; /* line # 777 */
          while (Rv5>Rv14&&128&((UB *)Rv1)[PAS__RANGE(Rv12,1,((SL *)Rv1)[0])*16+
338])
          Rv5=Rv5-1;
          Ra.sl[3]=778; /* line # 778 */
          if (Rv5>Rv14) {
            Ra.sl[3]=780; /* line # 780 */
            Rv18=(((S *)Rv1)+PAS__RANGE(Rv14,1,((SL *)Rv1)[0])*16+324);
            ((UB *)Rv18)[14]=((UB *)Rv18)[14]&~2;
            Ra.sl[3]=781; /* line # 781 */
            Rv19=(((S *)Rv1)+PAS__RANGE(Rv5,1,((SL *)Rv1)[0])*16+324);
            ((UB *)Rv19)[14]=((UB *)Rv19)[14]|2;
            Ra.sl[3]=782; /* line # 782 */
            Rv20=Rv13;
            Ra.sl[3]=783; /* line # 783 */
            ((SL *)Rv20)[7]=(Rv5-Rv14)+1;
            ((SL *)Rv20)[9]=Rv5;
          }
          Ra.sl[3]=785; /* line # 785 */
          Rv14=Rv5;
        }
        Ra.sl[3]=787; /* line # 787 */
        Rv13=((V *)Rv13)[0];
        if (Rv14>=F_ilst)  break;
      }
    }
  }
  Ra.sl[3]=791; /* line # 791 */
  V_nenapck=V_ntotpck;
  Ra.sl[3]=792; /* line # 792 */
  V_nerr_flg=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Ref_locate "  */
V P_integr_Ref_locate(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+466;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=801; /* line # 801 */
  V_bfitini=1;
  Ra.sl[3]=802; /* line # 802 */
  V_str_msg.ub[1]=0;
  Ra.sl[3]=803; /* line # 803 */
  if ((V_sel_pat!=NULL&&V_sel_iright>V_sel_ileft)&&V_bckgrd_crv!=NULL) {
    Ra.sl[3]=804; /* line # 804 */
    RPW_INTARCH_locate_reflection(V_sel_ileft, V_sel_iright);
  }
  Ra.sl[3]=805; /* line # 805 */
  if (V_fitcmp_crv!=NULL) {
    Ra.sl[3]=807; /* line # 807 */
    P_del_curve(V_fitcmp_crv);
    Ra.sl[3]=808; /* line # 808 */
    V_fitcmp_crv=NULL;
  }
  Ra.sl[3]=810; /* line # 810 */
  if (V_str_msg.ub[1]>0) Ret=V_str_msg.s;
  else {
    Ra.sl[3]=811; /* line # 811 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " move_peak_pos "  */
void P_move_peak_pos(V F_pk, UB F_fhkl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  F Rv4;
  F Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+485;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=823; /* line # 823 */
  if (F_fhkl==0) F_fhkl=12;
  else {
    Ra.sl[3]=824; /* line # 824 */
    F_fhkl=F_fhkl&28;
  }
  Ra.sl[3]=825; /* line # 825 */
  if (F_pk!=NULL) {
    Ra.sl[3]=826; /* line # 826 */
    Rv0=F_pk;
    Rv1=((V *)Rv0)[2];
    Rv2=V_sel_pat;
    Ra.sl[3]=828; /* line # 828 */
    Rv3=((SL *)Rv1)[8];
    Ra.sl[3]=829; /* line # 829 */
    Rv4=((F *)Rv2)[PAS__RANGE(Rv3,1,((SL *)Rv2)[0])*4+81];
    Rv5=Rv4;
    while (1){
      Ra.sl[3]=831; /* line # 831 */
      Rv3=Rv3+1;
      Ra.sl[3]=832; /* line # 832 */
      Rv4=Rv5;
      Rv5=((F *)Rv2)[PAS__RANGE(Rv3,1,((SL *)Rv2)[0])*4+81];
      if (Rv3>=((SL *)Rv1)[9]||Rv5>((F *)Rv0)[11])  break;
    }
    Ra.sl[3]=834; /* line # 834 */
    if (fabs(((F *)Rv0)[11]-Rv4)<fabs(((F *)Rv0)[11]-Rv5)) Rv3=Rv3-1;
    Ra.sl[3]=835; /* line # 835 */
    ((UB *)Rv2)[PAS__RANGE(Rv3,1,((SL *)Rv2)[0])*16+338]=((UB *)Rv2)[PAS__RANGE(
    Rv3,1,((SL *)Rv2)[0])*16+338]|F_fhkl;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " adjust_peak_pos "  */
void P_adjust_peak_pos(V F_pz, UB F_fhkl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+500;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=850; /* line # 850 */
  if (F_fhkl==0) F_fhkl=12;
  else {
    Ra.sl[3]=851; /* line # 851 */
    F_fhkl=F_fhkl&28;
  }
  Ra.sl[3]=852; /* line # 852 */
  Rv0=F_pz;
  Rv1=V_sel_pat;
  Ra.sl[3]=854; /* line # 854 */
  Rv2=((SL *)Rv0)[8];
  for( Rf0=(((SL *)Rv0)[9]+1)-((SL *)Rv0)[8];Rf0>0;Rf0-- ) {
    Ra.sl[3]=855; /* line # 855 */
    ((UB *)Rv1)[PAS__RANGE(Rv2,1,((SL *)Rv1)[0])*16+338]=((UB *)Rv1)[PAS__RANGE(
    Rv2,1,((SL *)Rv1)[0])*16+338]&~28;
    Rv2++;
  }
  Ra.sl[3]=857; /* line # 857 */
  Rv3=((V *)Rv0)[1];
  Ra.sl[3]=858; /* line # 858 */
  while (Rv3!=NULL){
    Ra.sl[3]=859; /* line # 859 */
    Rv4=Rv3;
    Ra.sl[3]=861; /* line # 861 */
    Rv5=((SL *)Rv0)[8];
    Ra.sl[3]=862; /* line # 862 */
    Rv6=((F *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])*4+81];
    Rv7=Rv6;
    while (1){
      Ra.sl[3]=864; /* line # 864 */
      Rv5=Rv5+1;
      Ra.sl[3]=865; /* line # 865 */
      Rv6=Rv7;
      Rv7=((F *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])*4+81];
      if (Rv5>=((SL *)Rv0)[9]||Rv7>((F *)Rv4)[11])  break;
    }
    Ra.sl[3]=867; /* line # 867 */
    if (fabs(((F *)Rv4)[11]-Rv6)<fabs(((F *)Rv4)[11]-Rv7)) Rv5=Rv5-1;
    Ra.sl[3]=868; /* line # 868 */
    ((UB *)Rv1)[PAS__RANGE(Rv5,1,((SL *)Rv1)[0])*16+338]=((UB *)Rv1)[PAS__RANGE(
    Rv5,1,((SL *)Rv1)[0])*16+338]|F_fhkl;
    Ra.sl[3]=869; /* line # 869 */
    Rv3=((V *)Rv4)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_to_valid "  */
void RPW_INTARCH_PRC_00000002(SL F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+517;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=897; /* line # 897 */
  Rv0=V_sel_pat;
  Rv1=(((S *)Rv0)+PAS__RANGE(F_ip,1,((SL *)Rv0)[0])*16+324);
  Ra.sl[3]=899; /* line # 899 */
  Rv2=F_ip-1;
  Ra.sl[3]=900; /* line # 900 */
  Rv3=F_ip-5;
  if (Rv3<V_sel_ileft) Rv3=V_sel_ileft;
  Ra.sl[3]=901; /* line # 901 */
  while (Rv2>=Rv3){
    Ra.sl[3]=903; /* line # 903 */
    if (!(128&((UB *)Rv0)[PAS__RANGE(Rv2,1,((SL *)Rv0)[0])*16+338]))  break;
    Ra.sl[3]=904; /* line # 904 */
    Rv2=Rv2-1;
  }
  Ra.sl[3]=906; /* line # 906 */
  if (Rv2<Rv3) Rv2=F_ip;
  Ra.sl[3]=907; /* line # 907 */
  Rv4=F_ip+1;
  Ra.sl[3]=908; /* line # 908 */
  Rv3=F_ip+5;
  if (Rv3>V_sel_iright) Rv3=V_sel_iright;
  Ra.sl[3]=909; /* line # 909 */
  while (Rv4<=Rv3){
    Ra.sl[3]=911; /* line # 911 */
    if (!(128&((UB *)Rv0)[PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*16+338]))  break;
    Ra.sl[3]=912; /* line # 912 */
    Rv4=Rv4+1;
  }
  Ra.sl[3]=914; /* line # 914 */
  if (Rv4>Rv3) Rv4=F_ip;
  Ra.sl[3]=915; /* line # 915 */
  if (Rv2!=Rv4) {
    Ra.sl[3]=917; /* line # 917 */
    ((UB *)Rv1)[14]=((UB *)Rv1)[14]&~128;
    Ra.sl[3]=918; /* line # 918 */
    if (Rv2==F_ip) {
      ((F *)Rv1)[1]=((F *)Rv0)[PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*4+82];
      ((F *)Rv1)[2]=((F *)Rv0)[PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*4+83];
    }
    else {
      Ra.sl[3]=920; /* line # 920 */
      if (Rv4==F_ip) {
        ((F *)Rv1)[1]=((F *)Rv0)[PAS__RANGE(Rv2,1,((SL *)Rv0)[0])*4+82];
        ((F *)Rv1)[2]=((F *)Rv0)[PAS__RANGE(Rv2,1,((SL *)Rv0)[0])*4+83];
      }
      else {
        Ra.sl[3]=923; /* line # 923 */
        ((F *)Rv1)[1]=(F)5.000000E-01*(((F *)Rv0)[PAS__RANGE(Rv2,1,((SL *)Rv0)[0]
        )*4+82]+((F *)Rv0)[PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*4+82]);
        Ra.sl[3]=924; /* line # 924 */
        ((F *)Rv1)[2]=(F)5.000000E-01*(((F *)Rv0)[PAS__RANGE(Rv2,1,((SL *)Rv0)[0]
        )*4+83]+((F *)Rv0)[PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*4+83]);
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Ref_copy "  */
V P_integr_Ref_copy(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+531;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=932; /* line # 932 */
  if (V_zone_first!=NULL&&V_sel_pat!=NULL) {
    Ra.sl[3]=933; /* line # 933 */
    Rv0=V_sel_pat;
    Ra.sl[3]=935; /* line # 935 */
    Rv1=0;
    Ra.sl[3]=936; /* line # 936 */
    Rv2=V_zone_first;
    Ra.sl[3]=937; /* line # 937 */
    Rv3=0;
    Ra.sl[3]=938; /* line # 938 */
    while (Rv2!=NULL){
      Ra.sl[3]=939; /* line # 939 */
      Rv4=Rv2;
      Ra.sl[3]=941; /* line # 941 */
      Rv5=(((S *)Rv0)+PAS__RANGE(((SL *)Rv4)[8],1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=943; /* line # 943 */
      if (128&((UB *)Rv5)[14]) RPW_INTARCH_PRC_00000002(((SL *)Rv4)[8]);
      Ra.sl[3]=944; /* line # 944 */
      ((UB *)Rv5)[14]=((UB *)Rv5)[14]|1;
      Ra.sl[3]=946; /* line # 946 */
      Rv6=(((S *)Rv0)+PAS__RANGE(((SL *)Rv4)[9],1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=948; /* line # 948 */
      if (128&((UB *)Rv6)[14]) RPW_INTARCH_PRC_00000002(((SL *)Rv4)[9]);
      Ra.sl[3]=949; /* line # 949 */
      ((UB *)Rv6)[14]=((UB *)Rv6)[14]|2;
      Ra.sl[3]=951; /* line # 951 */
      Rv7=((V *)Rv4)[1];
      Ra.sl[3]=952; /* line # 952 */
      while (Rv7!=NULL){
        Ra.sl[3]=953; /* line # 953 */
        Rv8=Rv7;
        Ra.sl[3]=955; /* line # 955 */
        Rv9=P_locate_angle(((F *)Rv8)[11],(F)2.500000E-01,((SL *)Rv4)[8],1,1);
        Ra.sl[3]=956; /* line # 956 */
        if (Rv9<0||Rv9>((SL *)Rv4)[9]) ((UB *)Rv8)[85]=0;
        else {
          Ra.sl[3]=958; /* line # 958 */
          Rv10=(((S *)Rv0)+PAS__RANGE(Rv9,1,((SL *)Rv0)[0])*16+324);
          Ra.sl[3]=960; /* line # 960 */
          ((UB *)Rv10)[14]=((UB *)Rv10)[14]|8;
          Ra.sl[3]=961; /* line # 961 */
          Rv3=Rv3+1;
          ((UB *)Rv8)[85]=1;
        }
        Ra.sl[3]=963; /* line # 963 */
        Rv7=((V *)Rv8)[0];
      }
      Ra.sl[3]=965; /* line # 965 */
      Rv2=((V *)Rv4)[0];
    }
  }
  Ra.sl[3]=968; /* line # 968 */
  V_nenapck=Rv3;
  Ra.sl[3]=969; /* line # 969 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " reload_zpck "  */
void RPW_INTARCH_reload_zpck(V F_pz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+548;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=979; /* line # 979 */
  Rv0=F_pz;
  Ra.sl[3]=981; /* line # 981 */
  Rv1=((V *)F_pz)[1];
  Ra.sl[3]=982; /* line # 982 */
  while (Rv1!=NULL){
    Ra.sl[3]=983; /* line # 983 */
    Rv2=Rv1;
    Ra.sl[3]=985; /* line # 985 */
    if (((UB *)Rv2)[85]) {
      Ra.sl[3]=987; /* line # 987 */
      ((F *)Rv2)[11]=((F *)Rv2)[8];
      Ra.sl[3]=988; /* line # 988 */
      ((F *)Rv2)[13]=((F *)Rv2)[9];
      Ra.sl[3]=989; /* line # 989 */
      ((F *)Rv2)[15]=((F *)Rv2)[10];
    }
    Ra.sl[3]=991; /* line # 991 */
    Rv1=((V *)Rv2)[1];
  }
  Ra.sl[3]=993; /* line # 993 */
  Rv3=1;
  for( Rf0=9;Rf0>0;Rf0-- ) {
    Ra.sl[3]=994; /* line # 994 */
    ((F *)Rv0)[PAS__RANGE(Rv3,1,9)+30]=((F *)Rv0)[PAS__RANGE(Rv3,1,9)+48];
    ((F *)Rv0)[PAS__RANGE(Rv3,1,9)+39]=(F)-1.000000E+00;
    Rv3++;
  }
  Ra.sl[3]=995; /* line # 995 */
  P_adjust_peak_pos(F_pz,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Reload_a_pck "  */
void P_integr_Reload_a_pck(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+561;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1007; /* line # 1007 */
  Rv0=V_zone_first;
  Ra.sl[3]=1008; /* line # 1008 */
  while (Rv0!=NULL){
    Ra.sl[3]=1009; /* line # 1009 */
    RPW_INTARCH_reload_zpck(Rv0);
    Rv0=((V *)Rv0)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Reload_z_pck "  */
void P_integr_Reload_z_pck(F F_th){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+582;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1020; /* line # 1020 */
  Rv0=V_zone_first;
  Ra.sl[3]=1021; /* line # 1021 */
  while (Rv0!=NULL){
    Ra.sl[3]=1022; /* line # 1022 */
    Rv1=Rv0;
    Ra.sl[3]=1024; /* line # 1024 */
    if (F_th>=((F *)Rv1)[14]&&F_th<=((F *)Rv1)[15])  break;
    Ra.sl[3]=1025; /* line # 1025 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=1027; /* line # 1027 */
  if (Rv0!=NULL) {
    Ra.sl[3]=1028; /* line # 1028 */
    RPW_INTARCH_reload_zpck(Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " save_zpck "  */
void RPW_INTARCH_save_zpck(V F_pz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+603;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1038; /* line # 1038 */
  Rv0=F_pz;
  Ra.sl[3]=1040; /* line # 1040 */
  Rv1=((V *)Rv0)[1];
  Ra.sl[3]=1041; /* line # 1041 */
  while (Rv1!=NULL){
    Ra.sl[3]=1042; /* line # 1042 */
    Rv2=Rv1;
    Ra.sl[3]=1044; /* line # 1044 */
    if (((UB *)Rv2)[85]) {
      Ra.sl[3]=1046; /* line # 1046 */
      ((F *)Rv2)[8]=((F *)Rv2)[11];
      Ra.sl[3]=1047; /* line # 1047 */
      ((F *)Rv2)[9]=((F *)Rv2)[13];
      Ra.sl[3]=1048; /* line # 1048 */
      ((F *)Rv2)[10]=((F *)Rv2)[15];
    }
    Ra.sl[3]=1050; /* line # 1050 */
    Rv1=((V *)Rv2)[1];
  }
  Ra.sl[3]=1052; /* line # 1052 */
  Rv3=1;
  for( Rf0=9;Rf0>0;Rf0-- ) {
    ((F *)Rv0)[PAS__RANGE(Rv3,1,9)+48]=((F *)Rv0)[PAS__RANGE(Rv3,1,9)+30];
    Rv3++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Save_a_pck "  */
void P_integr_Save_a_pck(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+614;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1064; /* line # 1064 */
  Rv0=V_zone_first;
  Ra.sl[3]=1065; /* line # 1065 */
  while (Rv0!=NULL){
    Ra.sl[3]=1066; /* line # 1066 */
    RPW_INTARCH_save_zpck(Rv0);
    Rv0=((V *)Rv0)[0];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Save_z_pck "  */
void P_integr_Save_z_pck(F F_th){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+633;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1077; /* line # 1077 */
  Rv0=V_zone_first;
  Ra.sl[3]=1078; /* line # 1078 */
  while (Rv0!=NULL){
    Ra.sl[3]=1079; /* line # 1079 */
    Rv1=Rv0;
    Ra.sl[3]=1081; /* line # 1081 */
    if (F_th>=((F *)Rv1)[14]&&F_th<=((F *)Rv1)[15])  break;
    Ra.sl[3]=1082; /* line # 1082 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[3]=1084; /* line # 1084 */
  if (Rv0!=NULL) RPW_INTARCH_save_zpck(Rv0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Set_refzone "  */
V P_integr_Set_refzone(F F_lt, F F_rt){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  SL Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  register V Rv17;
  V Rv18;
  SL Rv19;
  register V Rv20;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+652;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1104; /* line # 1104 */
  Rv0=P_locate_angle(F_lt, (F)2.500000E-01, V_sel_ileft,1,0);
  Ra.sl[3]=1105; /* line # 1105 */
  Rv1=P_locate_angle(F_rt, (F)2.500000E-01, Rv0,1,0);
  Ra.sl[3]=1106; /* line # 1106 */
  Rv2=0;
  Ra.sl[3]=1107; /* line # 1107 */
  Rv3=0;
  Ra.sl[3]=1108; /* line # 1108 */
  Rv4=0;
  Ra.sl[3]=1109; /* line # 1109 */
  Rv5=0;
  Ra.sl[3]=1110; /* line # 1110 */
  Rv6=V_sel_pat;
  Ra.sl[3]=1112; /* line # 1112 */
  Rv7=V_zone_first;
  Ra.sl[3]=1113; /* line # 1113 */
  while (Rv7!=NULL){
    Ra.sl[3]=1114; /* line # 1114 */
    Rv8=Rv7;
    Ra.sl[3]=1116; /* line # 1116 */
    Rv9=((SL *)Rv8)[8];
    Rv10=((SL *)Rv8)[9];
    Ra.sl[3]=1117; /* line # 1117 */
    if (Rv1<Rv9)  break;
    Ra.sl[3]=1118; /* line # 1118 */
    if (Rv0<=Rv10) {
      Ra.sl[3]=1120; /* line # 1120 */
      Rv5=1;
      Ra.sl[3]=1121; /* line # 1121 */
      if (Rv0!=Rv9) {
        Ra.sl[3]=1123; /* line # 1123 */
        ((UB *)Rv6)[PAS__RANGE(Rv0,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
        Rv0,1,((SL *)Rv6)[0])*16+338]|1;
        Ra.sl[3]=1124; /* line # 1124 */
        ((UB *)Rv6)[PAS__RANGE(Rv9,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
        Rv9,1,((SL *)Rv6)[0])*16+338]&~1;
        Ra.sl[3]=1125; /* line # 1125 */
        ((F *)Rv8)[14]=((F *)Rv6)[PAS__RANGE(Rv0+1,1,((SL *)Rv6)[0])*4+81];
        Ra.sl[3]=1126; /* line # 1126 */
        ((SL *)Rv8)[8]=Rv0;
        ((SL *)Rv8)[6]=1;
      }
      Ra.sl[3]=1128; /* line # 1128 */
      Rv3=Rv1<=Rv10;
      Ra.sl[3]=1129; /* line # 1129 */
      if (Rv1!=Rv10) {
        Ra.sl[3]=1131; /* line # 1131 */
        if (Rv1>Rv10) Rv4=1;
        Ra.sl[3]=1132; /* line # 1132 */
        ((UB *)Rv6)[PAS__RANGE(Rv10,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
        Rv10,1,((SL *)Rv6)[0])*16+338]&~2;
        Ra.sl[3]=1133; /* line # 1133 */
        ((UB *)Rv6)[PAS__RANGE(Rv1,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
        Rv1,1,((SL *)Rv6)[0])*16+338]|2;
        Ra.sl[3]=1134; /* line # 1134 */
        ((F *)Rv8)[15]=((F *)Rv6)[PAS__RANGE(Rv1-1,1,((SL *)Rv6)[0])*4+81];
        Ra.sl[3]=1135; /* line # 1135 */
        ((SL *)Rv8)[9]=Rv1;
        ((SL *)Rv8)[7]=1;
      }
    }
    Ra.sl[3]=1138; /* line # 1138 */
    if (Rv3||Rv4)  break;
    Ra.sl[3]=1139; /* line # 1139 */
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[3]=1142; /* line # 1142 */
  if (Rv5) {
    Ra.sl[3]=1144; /* line # 1144 */
    if (Rv4) {
      Ra.sl[3]=1146; /* line # 1146 */
      Rv11=((V *)Rv7)[0];
      Ra.sl[3]=1147; /* line # 1147 */
      while (Rv11!=NULL){
        Ra.sl[3]=1148; /* line # 1148 */
        Rv12=Rv11;
        Ra.sl[3]=1150; /* line # 1150 */
        if (((SL *)Rv12)[8]>Rv1)  break;
        Ra.sl[3]=1151; /* line # 1151 */
        Rv13=((V *)Rv11)[1];
        Ra.sl[3]=1152; /* line # 1152 */
        if (Rv13!=NULL) {
          Ra.sl[3]=1154; /* line # 1154 */
          if (((V *)Rv7)[1]==NULL) ((V *)Rv7)[1]=Rv13;
          else {
            Ra.sl[3]=1155; /* line # 1155 */
            ((V *)((V *)Rv7)[2])[0]=Rv13;
          }
          Ra.sl[3]=1156; /* line # 1156 */
          ((V *)Rv7)[2]=((V *)Rv11)[2];
          Ra.sl[3]=1157; /* line # 1157 */
          while (Rv13!=NULL){
            Ra.sl[3]=1158; /* line # 1158 */
            Rv14=Rv13;
            Ra.sl[3]=1159; /* line # 1159 */
            ((V *)Rv14)[2]=Rv7;
            Rv13=((V *)Rv14)[0];
          }
          Ra.sl[3]=1160; /* line # 1160 */
          ((V *)Rv11)[1]=NULL;
          ((V *)Rv11)[2]=NULL;
        }
        Ra.sl[3]=1163; /* line # 1163 */
        if (Rv1!=((SL *)Rv12)[8]) ((UB *)Rv6)[PAS__RANGE(((SL *)Rv12)[8],1,((SL *)
        Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(((SL *)Rv12)[8],1,((SL *)Rv6)[0]
        )*16+338]&~1;
        Ra.sl[3]=1164; /* line # 1164 */
        if (Rv1!=((SL *)Rv12)[9]) ((UB *)Rv6)[PAS__RANGE(((SL *)Rv12)[9],1,((SL *)
        Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(((SL *)Rv12)[9],1,((SL *)Rv6)[0]
        )*16+338]&~2;
        Ra.sl[3]=1165; /* line # 1165 */
        Rv15=Rv11;
        Ra.sl[3]=1166; /* line # 1166 */
        Rv11=((V *)Rv12)[0];
        Ra.sl[3]=1167; /* line # 1167 */
        RPW_INTARCH_free_zone(Rv15);
      }
    }
    Ra.sl[3]=1172; /* line # 1172 */
    Rv16=Rv7;
    Ra.sl[3]=1174; /* line # 1174 */
    Rv13=((V *)Rv16)[1];
    Ra.sl[3]=1175; /* line # 1175 */
    ((SL *)Rv16)[5]=0;
    Ra.sl[3]=1176; /* line # 1176 */
    while (Rv13!=NULL){
      Ra.sl[3]=1177; /* line # 1177 */
      Rv17=Rv13;
      Ra.sl[3]=1179; /* line # 1179 */
      Rv18=Rv13;
      Ra.sl[3]=1180; /* line # 1180 */
      Rv13=((V *)Rv17)[0];
      Ra.sl[3]=1181; /* line # 1181 */
      if (((F *)Rv17)[11]<((F *)Rv16)[14]||((F *)Rv17)[11]>((F *)Rv16)[15]) {
        Ra.sl[3]=1186; /* line # 1186 */
        Rv19=P_locate_angle(((F *)Rv17)[11],(F)2.500000E-01, Rv9,1,1);
        Ra.sl[3]=1187; /* line # 1187 */
        if (Rv19<=0||Rv19>V_sel_iright) {
          Ra.sl[3]=1188; /* line # 1188 */
          Rv2=1;
        }
        else {
          Ra.sl[3]=1190; /* line # 1190 */
          Rv20=(((S *)Rv6)+PAS__RANGE(Rv19,1,((SL *)Rv6)[0])*16+324);
          Ra.sl[3]=1191; /* line # 1191 */
          ((UB *)Rv20)[14]=((UB *)Rv20)[14]&~28;
        }
        Ra.sl[3]=1192; /* line # 1192 */
        RPW_INTARCH_free_peak(Rv18);
      }
    }
  }
  else {
    Ra.sl[3]=1199; /* line # 1199 */
    RPW_INTARCH_create_zone(Rv0, Rv1, Rv7);
    Ra.sl[3]=1200; /* line # 1200 */
    ((UB *)Rv6)[PAS__RANGE(Rv0,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
    Rv0,1,((SL *)Rv6)[0])*16+338]|1;
    Ra.sl[3]=1201; /* line # 1201 */
    ((UB *)Rv6)[PAS__RANGE(Rv1,1,((SL *)Rv6)[0])*16+338]=((UB *)Rv6)[PAS__RANGE(
    Rv1,1,((SL *)Rv6)[0])*16+338]|2;
  }
  Ra.sl[3]=1208; /* line # 1208 */
  V_bfitini=1;
  Ra.sl[3]=1210; /* line # 1210 */
  if (Rv2) Ret=Rd.s+672;
  else {
    Ra.sl[3]=1211; /* line # 1211 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Set_refline "  */
V P_integr_Set_refline(F F_th, F F_hg, F F_wd, UB F_fhkl){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  SL Rv8;
  SL Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  F Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+750;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1233; /* line # 1233 */
  Rv0=NULL;
  Ra.sl[3]=1234; /* line # 1234 */
  if (V_sel_pat!=NULL&&V_bckgrd_crv!=NULL) {
    Ra.sl[3]=1235; /* line # 1235 */
    Rv1=V_sel_pat;
    Ra.sl[3]=1237; /* line # 1237 */
    Rv2=V_zone_first;
    Ra.sl[3]=1238; /* line # 1238 */
    while (Rv2!=NULL){
      Ra.sl[3]=1240; /* line # 1240 */
      if (F_th>=((F *)Rv1)[PAS__RANGE(((SL *)Rv2)[8],1,((SL *)Rv1)[0])*4+81]&&F_th<=
      ((F *)Rv1)[PAS__RANGE(((SL *)Rv2)[9],1,((SL *)Rv1)[0])*4+81])  break;
      Ra.sl[3]=1241; /* line # 1241 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[3]=1243; /* line # 1243 */
    if (Rv2==NULL) goto L_l_0;
    Ra.sl[3]=1245; /* line # 1245 */
    Rv3=Rv2;
    Ra.sl[3]=1247; /* line # 1247 */
    Rv4=P_locate_angle(F_th, (F)2.500000E-01,((SL *)Rv3)[8],1,1);
    Ra.sl[3]=1248; /* line # 1248 */
    if (Rv4<=0||Rv4>((SL *)Rv3)[9]) {
      Ra.sl[3]=1249; /* line # 1249 */
      Rv0=Rd.s+672;
      goto L_l_0;
    }
    Ra.sl[3]=1252; /* line # 1252 */
    Rv5=(((S *)Rv1)+PAS__RANGE(Rv4,1,((SL *)Rv1)[0])*16+324);
    Rv6=V_bckgrd_crv;
    Ra.sl[3]=1254; /* line # 1254 */
    Rv7=RPW_INTARCH_create_peak(Rv2, F_th, F_wd);
    Ra.sl[3]=1255; /* line # 1255 */
    Rv8=((SL *)Rv6)[0]*2;
    Rv9=2;
    Ra.sl[3]=1256; /* line # 1256 */
    Rv10=((F *)Rv6)[PAS__RANGE(1,1,2*((SL *)Rv6)[0])+8];
    Rv11=((F *)Rv6)[PAS__RANGE(2,1,2*((SL *)Rv6)[0])+8];
    Ra.sl[3]=1257; /* line # 1257 */
    Rv12=Rv10-(F)1.000000E+00;
    Rv11=Rv13;
    Ra.sl[3]=1258; /* line # 1258 */
    while (Rv9<=Rv8&&Rv10<F_th){
      Ra.sl[3]=1260; /* line # 1260 */
      Rv12=Rv10;
      Rv13=Rv11;
      Ra.sl[3]=1261; /* line # 1261 */
      Rv9=Rv9+1;
      Rv10=((F *)Rv6)[PAS__RANGE(Rv9,1,2*((SL *)Rv6)[0])+8];
      Ra.sl[3]=1262; /* line # 1262 */
      Rv9=Rv9+1;
      Rv11=((F *)Rv6)[PAS__RANGE(Rv9,1,2*((SL *)Rv6)[0])+8];
    }
    Ra.sl[3]=1264; /* line # 1264 */
    if (F_hg<=(F)0.000000E-01) F_hg=((F *)Rv5)[1];
    Ra.sl[3]=1266; /* line # 1266 */
    Rv14=((Rv11-Rv13)*(F_th-Rv10))/(Rv10-Rv12)+Rv11;
    Ra.sl[3]=1267; /* line # 1267 */
    ((F *)Rv7)[13]=F_hg-Rv14;
    Ra.sl[3]=1268; /* line # 1268 */
    ((F *)Rv7)[9]=((F *)Rv7)[13];
    Ra.sl[3]=1269; /* line # 1269 */
    if (F_fhkl!=0) ((UB *)Rv5)[14]=((UB *)Rv5)[14]|F_fhkl&28;
    else {
      Ra.sl[3]=1270; /* line # 1270 */
      ((UB *)Rv5)[14]=((UB *)Rv5)[14]|4;
    }
    Ra.sl[3]=1271; /* line # 1271 */
    V_bfitini=1;
  }
L_l_0:
  Ra.sl[3]=1275; /* line # 1275 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Zone_del "  */
V P_integr_Zone_del(F F_th){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+770;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1296; /* line # 1296 */
  if (V_sel_pat!=NULL&&V_zone_first!=NULL) {
    Ra.sl[3]=1297; /* line # 1297 */
    Rv0=V_sel_pat;
    Ra.sl[3]=1299; /* line # 1299 */
    Rv1=V_zone_first;
    Ra.sl[3]=1300; /* line # 1300 */
    while (Rv1!=NULL){
      Ra.sl[3]=1301; /* line # 1301 */
      Rv2=Rv1;
      Ra.sl[3]=1303; /* line # 1303 */
      if (F_th>=((F *)Rv2)[14]&&F_th<=((F *)Rv2)[15])  break;
      Ra.sl[3]=1304; /* line # 1304 */
      Rv1=((V *)Rv2)[0];
    }
    Ra.sl[3]=1306; /* line # 1306 */
    Rv3=Rd.s+787;
    Ra.sl[3]=1307; /* line # 1307 */
    if (Rv1==NULL) goto L_l_0;
    Ra.sl[3]=1308; /* line # 1308 */
    Rv4=((V *)Rv1)[1];
    Ra.sl[3]=1309; /* line # 1309 */
    while (Rv4!=NULL){
      Ra.sl[3]=1310; /* line # 1310 */
      Rv5=Rv4;
      Ra.sl[3]=1312; /* line # 1312 */
      Rv6=P_locate_angle(((F *)Rv5)[11],(F)2.500000E-01, V_sel_ileft,1,1);
      Ra.sl[3]=1313; /* line # 1313 */
      Rv3=Rd.s+672;
      Ra.sl[3]=1314; /* line # 1314 */
      if (Rv6==0) goto L_l_0;
      Ra.sl[3]=1315; /* line # 1315 */
      Rv7=(((S *)Rv0)+PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*16+324);
      ((UB *)Rv7)[14]=((UB *)Rv7)[14]&~28;
      Ra.sl[3]=1316; /* line # 1316 */
      Rv4=((V *)Rv5)[0];
    }
    Ra.sl[3]=1318; /* line # 1318 */
    Rv8=(((S *)Rv0)+PAS__RANGE(((SL *)Rv1)[8],1,((SL *)Rv0)[0])*16+324);
    ((UB *)Rv8)[14]=((UB *)Rv8)[14]&~1;
    Ra.sl[3]=1319; /* line # 1319 */
    Rv9=(((S *)Rv0)+PAS__RANGE(((SL *)Rv1)[9],1,((SL *)Rv0)[0])*16+324);
    ((UB *)Rv9)[14]=((UB *)Rv9)[14]&~2;
    Ra.sl[3]=1320; /* line # 1320 */
    RPW_INTARCH_free_zone(Rv1);
    Ra.sl[3]=1321; /* line # 1321 */
    Rv3=NULL;
  }
L_l_0:
  Ra.sl[3]=1324; /* line # 1324 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Free_allz "  */
V P_integr_Free_allz(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+849;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1332; /* line # 1332 */
  if (V_zone_first!=NULL) {
    Ra.sl[3]=1334; /* line # 1334 */
    if (V_sel_pat!=NULL) {
      Ra.sl[3]=1335; /* line # 1335 */
      Rv0=V_sel_pat;
      Ra.sl[3]=1336; /* line # 1336 */
      Rv1=V_sel_ileft;
      for( Rf0=(V_sel_iright+1)-V_sel_ileft;Rf0>0;Rf0-- ) {
        Ra.sl[3]=1337; /* line # 1337 */
        Rv2=(((S *)Rv0)+PAS__RANGE(Rv1,1,((SL *)Rv0)[0])*16+324);
        Ra.sl[3]=1338; /* line # 1338 */
        ((UB *)Rv2)[14]=((UB *)Rv2)[14]&~31;
        Rv1++;
      }
    }
    Ra.sl[3]=1339; /* line # 1339 */
    RPW_INTARCH_free_all_zone();
  }
  Ra.sl[3]=1341; /* line # 1341 */
  Ret=NULL;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Line_del "  */
V P_integr_Line_del(F F_th){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  F Rv4;
  register V Rv5;
  F Rv6;
  register V Rv7;
  SL Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+867;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=1363; /* line # 1363 */
  Rv0=NULL;
  Ra.sl[3]=1364; /* line # 1364 */
  if (V_sel_pat!=NULL&&V_peak_first!=NULL) {
    Ra.sl[3]=1365; /* line # 1365 */
    Rv1=V_sel_pat;
    Ra.sl[3]=1367; /* line # 1367 */
    Rv0=Rd.s+884;
    Ra.sl[3]=1368; /* line # 1368 */
    Rv2=V_peak_first;
    Ra.sl[3]=1369; /* line # 1369 */
    Rv3=NULL;
    Ra.sl[3]=1370; /* line # 1370 */
    Rv4=(F)3.600000E+02;
    Ra.sl[3]=1371; /* line # 1371 */
    while (Rv2!=NULL){
      Ra.sl[3]=1372; /* line # 1372 */
      Rv5=Rv2;
      Ra.sl[3]=1374; /* line # 1374 */
      Rv6=fabs(((F *)Rv5)[11]-F_th);
      Ra.sl[3]=1378; /* line # 1378 */
      if (Rv6>Rv4)  break;
      Ra.sl[3]=1379; /* line # 1379 */
      Rv4=Rv6;
      Rv3=Rv2;
      Ra.sl[3]=1380; /* line # 1380 */
      Rv2=((V *)Rv5)[1];
    }
    Ra.sl[3]=1382; /* line # 1382 */
    if (Rv3==NULL||Rv4>(F)5.000000E-01) goto L_l_0;
    Ra.sl[3]=1383; /* line # 1383 */
    Rv7=Rv3;
    Ra.sl[3]=1385; /* line # 1385 */
    Rv8=P_locate_angle(((F *)Rv7)[11],(F)2.500000E-01, V_sel_ileft,1,1);
    Ra.sl[3]=1386; /* line # 1386 */
    Rv0=Rd.s+672;
    Ra.sl[3]=1388; /* line # 1388 */
    if (Rv8==0) goto L_l_0;
    Ra.sl[3]=1389; /* line # 1389 */
    Rv0=NULL;
    Ra.sl[3]=1390; /* line # 1390 */
    Rv9=(((S *)Rv1)+PAS__RANGE(Rv8,1,((SL *)Rv1)[0])*16+324);
    Ra.sl[3]=1391; /* line # 1391 */
    ((UB *)Rv9)[14]=((UB *)Rv9)[14]&~28;
    Ra.sl[3]=1393; /* line # 1393 */
    RPW_INTARCH_free_peak(Rv3);
  }
L_l_0:
  Ra.sl[3]=1396; /* line # 1396 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
