{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module RPW_INT_PROCESS;

%include 'RPWSRC:rpwdata_int_env.pas' {, list_on};

const
  int_defname = 'rpwdata_result.dat';



[global]
var
  phase_curr:                  integer;         { Current working phase }

  zone_free,                                    { Peak Zone free list }
  zone_first,                                   { Peak Zone List header }
  zone_last:            zon_ptr := nil;

  peak_curr,                                    { Current peak pointer }
  peak_free,                                    { Peak/packet free list }
  peak_first,                                   { Peak/packet List header }
  peak_last:            pck_ptr := nil;

  fitcmp_cnp,

  filnbr,                                       { Current Output file number }
  idgw,                                         { Identifier base for global width parameter fit }
  idsp,                                         { Identifier base for global profile specific parameter fit }
  curr_ind:                    integer;         { Current pattern dot index }

  bfitini,                                      { Flag for first fit cycles }
  bprocess:                    boolean;         { Flag the auto process mode }

  pro_parm:                  pro_prmty;         { Data Reflection Process Environment Setup/Pannel Record }

  pro_prmdef:   pro_prmty := [   1.0, 1.0e-4,   { dmp_r, mid_r : Damping factor and Minimum diagonal value }
                                 100,      0,   {  }
                                true,  false,   { ddy_f, mxd_f: The dynamic display and mxd output mode flags }
                                true,  false,   { sea_f, smo_f: The auto search reflection and smooth backgroun flags }
                                true,  false    { ful_f, idb_f: Full Data parameters output and debug flags }
                             ];



[global]
procedure PRO$DEFAULT_SETUP;
[static]
var
  { String Values for Automatic Fit Mode (Afm_n values) }
  afm_enmval: Choice_List( 3, 18 ) := [ 'Automatic',
                                        '*undefined 1*',
                                        '*undefined 2*'
                                      ];

  pro_desc: pdsc_tab( 12 ) := [ 0, 'Least-Squares and integration Process Setting', 200,  70, [
                                [ 'Least-Squares Fit',                            3,  12,  94,  54,   prm_frm, 20,  3,  2,  0            ],
                                [ 'Automatic Integration Process',              103,  12,  94,  54,   prm_frm, 20,  3,  2,  0            ],

                                [ 'Dmp_r : Global Damping factor',               68,  48,  25,   5,   prm_flt, nil, 0.0,  1.0,   0.01    ],
                                [ 'Mid_r : Minimum of matrix diagonal terme',    68,  40,  25,   5,   prm_flt, nil, 0.0, 0.05, 1.0e-4    ],
                                [ 'Cym_n : Maximum number of LSQ Cycles',        81,  32,  12,   5,   prm_int, nil,   1,  200            ],
                                [ 'Afm_n : Automatic fit mode',                  53,  24,  40,   5,   prm_enm, nil, nil                  ],
                                [ 'Ddy_f : Dynamic Fit Dislay flag',             88,  16,   5,   5,  prm_bool, nil                       ],
                                [ 'Mxd_f : Mxd output mode',                    188,  48,   5,   5,  prm_bool, nil                       ],
                                [ 'Sea_f : Automatic search reflection',        188,  40,   5,   5,  prm_bool, nil                       ],
                                [ 'Smo_f : Background Smoothing',               188,  32,   5,   5,  prm_bool, nil                       ],
                                [ 'Ful_f : Full Parm. pattern Output',          188,  24,   5,   5,  prm_bool, nil                       ],
                                [ 'Debug : Debug to help for setting',          188,  16,   5,   5,  prm_bool, nil                       ]
                              ] ];

  binit: boolean := true;

begin
  if binit then
  begin
    with pro_desc, pro_parm do
    begin
      SET_REF( tb[ 3].rf, dmp_r );
      SET_REF( tb[ 4].rf, mid_r );
      SET_REF( tb[ 5].rf, cym_n );
      SET_REF( tb[ 6].rf, fmd_i ); SET_REF( tb[ 6].el, afm_enmval );
      SET_REF( tb[ 7].rf, ddy_f );
      SET_REF( tb[ 8].rf, mxd_f );
      SET_REF( tb[ 9].rf, sea_f );
      SET_REF( tb[10].rf, smo_f );
      SET_REF( tb[11].rf, ful_f );
      SET_REF( tb[12].rf, idb_f )
    end;
    setup_tab[PRO_IDX] := pro_desc"address;
    binit := false
  end;
  pro_parm := pro_prmdef
end PRO$DEFAULT_SETUP;



[global]
procedure DELETE_CURVES;
begin
  if bckgrd_crv <> nil then
  begin
    DEL_CURVE( bckgrd_crv );
    bckgrd_crv :=   nil;
    bckspl_flg := false
  end;
  if fitcmp_crv <> nil then
  begin
    DEL_CURVE( fitcmp_crv );
    fitcmp_crv := nil
  end;
end DELETE_CURVES;



[global]
function LOCATE_ANGLE( ang, tol: real; isc: Dint := 1; brg, bif: boolean := false ): integer;
var
  tp, tc, de, dc:         real;
  ib, ie, ii, ir:      integer;

begin
  (* Work only for increasing angle *)
  with sel_pat^ do
  begin
    if brg then begin  ib := sel_ileft; ie := sel_iright  end
           else begin  ib := 1; ie := dim  end;
    if (isc < ib) or (isc > ie) then isc := ib;
    if not bif then
      while (isc <= ie) and (mk_invalid in dat[isc].mflg) do isc := isc + 1;
    if isc <= ie then
    begin
      de := ABS( ang - dat[isc].theta );
      ir := isc; ii := isc;
      while ii < dim do
      begin
        ii := ii + 1;
        if bif or (not (mk_invalid in dat[ii].mflg)) then
        begin
          tc := dat[ii].theta; dc := ABS( ang - tc );
      exit if dc > de;
          de := dc; ir := ii
        end
      end;
      if de <= tol then LOCATE_ANGLE := ir
                   else LOCATE_ANGLE :=  0
    end else LOCATE_ANGLE :=  0
  end
end LOCATE_ANGLE;



[global]
procedure INTEGR$UPDATE_PAT_INFO;
begin
  if sel_pat <> nil then
  with hkl_parm, sel_pat^ do
  begin
    if gw1_r = 0.0 then gw1_r := lambda1
    else
      if (gw1_r <> lambda1) and (lambda1 <> 0.0) then lambda1 := gw1_r;
    if gw2_r = 0.0 then gw2_r := lambda2
    else
      if (gw2_r <> lambda2) and (lambda2 <> 0.0) then lambda2 := gw2_r;
    if fwr_r = 0.0 then fwr_r := rwave2
    else
      if (fwr_r <> rwave2) and (rwave2 <> 0.0) then rwave2 := fwr_r;
  end
end INTEGR$UPDATE_PAT_INFO;



[global]
procedure INTEGR$SELECT_PATTERN( p: pat_ptr );
const
  tol = 0.5;

begin
  sel_pat := p;                                         { Keep the pointer of selected pattern }
  with mai_parm, hkl_parm, sel_pat^ do
  begin
    { *** Force Waves Lengths in main menu *** }
    gw1_r := lambda1;
    gw2_r := lambda2;
    fwr_r := rwave2;

    { *** Set the mini maxi of 2*theta for the whole of pattern. *** }
    if (tmi_r > 0.0) and (amin < tma_r) then
    begin                                               { Set the 2*theta minimum of the selected pattern }
      spthmin := tmi_r;
      sel_ileft  := LOCATE_ANGLE( spthmin, tol, 1 )
    end
    else
    begin
      spthmin := amin; sel_ileft := 1
    end;
    if (tma_r > 0.0) and (amax > tma_r) then
    begin
      spthmax := tma_r;
      sel_iright := LOCATE_ANGLE( spthmax, tol, sel_ileft )
    end
    else
    begin
      spthmax := amax; sel_iright := dim
    end;
    szthmin    := spthmin;
    szthmax    := spthmax
  end;
  DELETE_CURVES
end INTEGR$SELECT_PATTERN;



[global]
procedure INTEGR$SET_LIMIT( theta_min, theta_max: real );
const
  tol = 0.5;

var
  rg: real;

begin
  if sel_pat <> nil then
  with sel_pat^ do
  begin
    rg := theta_max - theta_min;
    if theta_min < spthmin then begin  szthmin := spthmin; szthmax := szthmin + rg  end
    else
    if theta_max > spthmax then begin  szthmax := spthmax; szthmin := szthmax - rg  end
    else
    begin  szthmin := theta_min; szthmax := theta_max  end;
    sel_ileft  := LOCATE_ANGLE( szthmin, tol );
    if sel_ileft <= 0 then sel_ileft := 1;
    sel_iright := LOCATE_ANGLE( szthmax, tol, sel_ileft );
    if sel_iright <= 0 then sel_iright := dim;
    DELETE_CURVES
  end
end INTEGR$SET_LIMIT;



[global]
function  INTEGR$WRITE_RESULTS: ^string;
const
  noopenerr = '';

var
  pz:          zon_ptr;
  pk:          pck_ptr;
  lp:        label_ptr;
  fn, st:       string;
  ip, ii:      integer;
  fc, f2, sf2:    real;
  outint:         text;         { File for Integration result output }

begin
  filnbr := filnbr + 1;
  if fil_nbr then
  begin
    ii := INDEX( int_name, '/', -1 );
    ip := INDEX( int_name, '.', -1 );
    if ii > ip then begin  st := int_name; ip := 0  end
               else st := SUBSTR( int_name, 1, ip-1 );
    if ip > 0 then WRITEV( fn, st, filnbr:-4, SUBSTR( int_name, ip ) )
              else WRITEV( fn, st, filnbr:-4 );
    OPEN( outint, fn, [write_file,error_file] )
  end
  else
  begin
    fn := int_name;
    if out_app then OPEN( outint, fn, [append_file,error_file] )
               else OPEN( outint, fn, [write_file,error_file] );
    out_app := true                                     { Force the append mode for all next open of the file }
  end;

  if iostatus = 0 then
  with hkl_parm, pro_parm, sel_pat^ do
  begin
    ii := 0;
    WRITELN( outint, '{ RPWDATA Integration modes :' );
    if fbk_n < 0 then
      WRITELN( outint, ' Use the initial background.' )
    else
      case bkm_i of
        0: WRITELN( outint, ' Use the initial background.' );
        1: WRITELN( outint, ' Use a previously fitted polynome of order ', fbk_n:0, ' as fixed background.' );
        2: WRITELN( outint, ' Fit a polynome of order ', fbk_n:0, ' with the reflections.' );
      otherwise
      end;

    if mai_parm.tmd_f then WRITELN( outint, ' The pattern abscisse is interpreted as the Theta (Bragg Angle).' )
                      else WRITELN( outint, ' The pattern abscisse is interpreted as the beam deviation = 2*Theta = 2*(Bragg Angle).' );

    WRITE( outint, ' Use ' );
    case fnc_n of
      1: WRITE( outint, 'Lorentzian' );
      2: WRITE( outint, 'Pseudo-Voigt' );
    otherwise
      WRITE( outint, 'Gaussian' )
    end;
    WRITELN( outint, ' reflection profile.' );
    if (rps_i > 0) and (fnc_n = 2) then
      WRITELN( outint, ' The profil specific parameters are common inside each integration zone.' );
    WRITE( outint, ' Use ' );
    if rwm_i > 0 then
    begin
      if rwm_i = 1 then
        WRITELN( outint, 'a common fitted reflection half width W0.' )
      else
        WRITELN( outint, 'fitted reflection half widths W = W0 + W1* TAN( Theta ), (W0 and W1 are fitted).' );
    end
    else
      WRITELN( outint, 'individual fitted reflection half widths.' );
    if lrz_i > 0 then
    begin
      WRITE( outint, ' The pf2 value are the reflection intensities corrected by the ' );
      case lrz_i of
        1: WRITELN( outint, 'neutron Debye-Scherrer  Lorentz factor "1.0/(sin(theta)*sin(2*theta))".' );
        2: WRITELN( outint, 'X-ray Debye-Scherrer Lorentz factor "(1.0 + cos(theta)^2)/(sin(theta)*sin(2*theta))".' );
      otherwise
        WRITELN( outint )
      end
    end else WRITELN( outint, ' The pf2 value are copies of intensities (No Lorentz correction).' );
    WRITELN( outint, '}' );
    WRITELN( outint );
    WRITELN( outint, '{ Pattern # ', filnbr:4, ' characteristics :'  );
    WRITELN( outint, '    Identifier = ', idcnt:10, ', Numor = ', numor:10, ', Date = ', dateh, '", Sample = "', sample, '",' );
    WRITELN( outint, '    Comment = "', comment, '",' );
    if lab_lst <> nil then
    begin
      lp := lab_lst;
      WRITELN( outint, '    Label text list :' );
      while lp <> nil do
      with lp^ do
      begin
        WRITELN( outint, ' ':8, txt:size );
        lp := nxt
      end
    end;
    WRITELN( outint );
    WRITELN( outint, '    Pattern parameters :' );
    WRITELN( outint, ' ':8, 'Temperature (on Sample, on regulation, setup) = ', t_sample:8:3, ' ', t_reg:8:3, ' ', t_set:8:3, ',' );
    if ful_f then
    begin
      WRITE( outint, ' ':8, 'Monitor = ', monitor:12:0, ', Time = ', cnttime:10:0, ', Lambda = ', lambda1:10:5 );
      if lambda2 > 0.0 then WRITELN( outint, ', Lambda2 = ', lambda2:10:5 )
                       else WRITELN( outint );
      WRITELN( outint, ' ':8, 'Ome =', omega:8:3, ', Chi = ', chi:8:3, ', Phi = ', phi:8:3, ', Tr1 = ', tr1:8:3, ', Tr2 = ', tr2:8:3,
                              ', Ivp1 = ', ivp0:8, ', Ivp2 = ', ivp1:8 );
      WRITELN( outint, ' ':8, 'Rvp[2..9] = ( ', rvp2:10:4, ', ', rvp3:10:4, ', ', rvp4:10:4, ', ', rvp5:10:4,
                              ', ', rvp6:10:4, ', ', rvp7:10:4, ', ', rvp8:10:4, ', ', rvp9:10:4, ' ).' )
    end;
    WRITELN( outint, '}' );
    WRITELN( outint );

    pz := zone_first;
    while pz <> nil do                                  { Loop on all zone }
    with pz^ do
    begin                                               { For this 2*theta zone }
      ii := ii + 1;
      if mai_parm.tmd_f then WRITE( outint, '{ 2*' )
                        else WRITE( outint, '{ ' );
      WRITELN( outint, 'Theta Zone # ', ii:3, ' is ', dat[lflim].theta:8:3, ' to ', dat[rilim].theta:8:3,
                       ' Background  Chi2 = ', bchi2:8:3, ' Reflection Fit Chi2 = ', rchi2:8:3, ' }' );
      if rwm_i = 2 then WRITELN( outint, '{ The common width parameter are W0 = ',
                                         zwid0:8:3, ' (', zswi0:7:3, ' ) and W1 = ',
                                         ' ) and W1 = ', zwid1:8:3,  ' (', zswi1:7:3, ' ) }' );
      if rps_i > 0 then
      case fnc_n of
        2: { Pseudo-Voigt Profil }
          WRITELN( '{ The common pseudo-voigt profil parameter is = ', zprf0:8:4, ' ( ', zspr0:7:4, ' ) }' );
      otherwise
      end;

      WRITELN( outint, '{ Total packet reflection intensity  = ', ztint:10:1, ' (', ztsint:8:1,
                       ') with a related background of ', zbkv:10:1, ' (', zbks:9:2, ' ) }' );
      ip := 0;
      pk := pckf;
      WRITELN( outint,
      '{ Peak #   2*theta (s.err)       high    (s.err)     width (s.err)     intens    (s.err)       pf2     (s.err)' );
       { 341234--12345678-1234567--1234567890-123456789--12345678-1234567--1234567890-123456789--1234567890-123456789 }
      while pk <> nil do
      with pk^ do
      begin
        ip := ip + 1;
        fc := thpos*inrd;
        if mai_parm.tmd_f then fc := 2.0*fc;
        case lrz_i of
          1: { Debye-Sherrer Neutron }  fc := SIN( 0.5*fc )*SIN( fc );

          2: { Debye-Sherrer X-ray }    fc := SIN( 0.5*fc )*SIN( fc )/(1.0 + SQR( COS( fc ) ))

        otherwise
          fc := 1.0
        end;
        f2 := fc*intens; if sigma >= 0.0 then sf2 := fc*sigma;
        WRITELN( outint, ' ':4, ip:4, ' ':2, thpos:8:3, ' ', sthpo:7:3, ' ':2, heigh: 10:1, ' ', shigh:9:1,
                         ' ':2, width:8:3, ' ', swidt:7:3,
                         ' ':2, intens:10:2, ' ', sigma:9:2, ' ':2, f2:10:2, ' ', sf2:9:2 );
        pk := znxt
      end;
      WRITELN( outint );
      pz := next
    end;
    WRITELN( outint );
    CLOSE( outint );
    INTEGR$WRITE_RESULTS := nil
  end
  else
  begin
    WRITEV( st, '*** RPW Error: Cannot open the Setup file "', fn,
                '" for output with err # ', iostatus:0, '. ***' );
    INTEGR$WRITE_RESULTS := st"address
  end
end INTEGR$WRITE_RESULTS;




[global]
procedure INTEGR$PROCEED( var pmsg: ^string );
var
  id, cp:  integer;

begin
  { Find the first pattern to integrate }
  pmsg := nil;
  id := 1;
  sel_pat := pat_first;
  while (sel_pat <> nil) and (id < frspint) do
  begin  id := id + 1; sel_pat := sel_pat^.next  end;
  if sel_pat <> nil then
  with pro_parm do
  begin
    bprocess := true;
    { For each pattern perform a complete integration cycle }
    cp := nbrpint;
    while sel_pat <> nil do
    begin
      INTEGR$SET_LIMIT( szthmin, szthmax );
      pmsg := INTEGR$BUILD_BACKGROUND;
    exit if pmsg <> nil;
      if smo_f then INTEGR$SMOOTH_BACKGROUND;
      if sea_f then pmsg := INTEGR$REF_LOCATE
               else pmsg := INTEGR$REF_COPY;
    exit if (ntotpck <= 0) or (pmsg <> nil);
      pmsg := INTEGR$REF_INTEGR;
    exit if pmsg <> nil;
      pmsg := INTEGR$WRITE_RESULTS;
    exit if pmsg <> nil;
      cp := cp - 1;
    exit if cp = 0;
      sel_pat := sel_pat^.next
    end;
    bprocess := false
  end
end INTEGR$PROCEED;






(*  * * * Old routine to set the various parameters * * * *)

[global]
function  INTEGR$MAI_SETUP: integer;
begin
  INTEGR$MAI_SETUP := GET_NEW_PARAMS( setup_tab[1]^ )
end INTEGR$MAI_SETUP;



[global]
function  INTEGR$BCK_SETUP: integer;
begin
  INTEGR$BCK_SETUP := GET_NEW_PARAMS( setup_tab[2]^ )
end INTEGR$BCK_SETUP;



[global]
function  INTEGR$REF_SETUP: integer;
begin
  INTEGR$REF_SETUP := GET_NEW_PARAMS( setup_tab[3]^ )
end INTEGR$REF_SETUP;



[global]
function  INTEGR$INT_SETUP: integer;
begin
  INTEGR$INT_SETUP := GET_NEW_PARAMS( setup_tab[4]^ )
end INTEGR$INT_SETUP;



[global]
function  INTEGR$PRO_SETUP: integer;
begin
  INTEGR$PRO_SETUP := GET_NEW_PARAMS( setup_tab[5]^ )
end INTEGR$PRO_SETUP;



end RPW_INT_PROCESS.
