/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 2168 ) = {
 17,  17, 112, 114, 111,  36, 100, 101, 102,  97, 117, 108, 116,  95, 115, 101,
116, 117, 112,  60,  60,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101,
114, 115,  47,  83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116,
115,  47, 114, 112, 119, 100,  97, 116,  97,  95, 115, 114,  99,  47, 114, 112,
119, 100,  97, 116,  97,  95, 105, 110, 116,  95, 112, 114, 111,  46, 112,  97,
115,  13,  13, 100, 101, 108, 101, 116, 101,  95,  99, 117, 114, 118, 101, 115,
 12,  12, 108, 111,  99,  97, 116, 101,  95,  97, 110, 103, 108, 101,  22,  22,
105, 110, 116, 101, 103, 114,  36, 117, 112, 100,  97, 116, 101,  95, 112,  97,
116,  95, 105, 110, 102, 111,  21,  21, 105, 110, 116, 101, 103, 114,  36, 115,
101, 108, 101,  99, 116,  95, 112,  97, 116, 116, 101, 114, 110,  16,  16, 105,
110, 116, 101, 103, 114,  36, 115, 101, 116,  95, 108, 105, 109, 105, 116,  20,
 20, 105, 110, 116, 101, 103, 114,  36, 119, 114, 105, 116, 101,  95, 114, 101,
115, 117, 108, 116, 115,  29,  29, 123,  32,  82,  80,  87,  68,  65,  84,  65,
 32,  73, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  32, 109, 111, 100,
101, 115,  32,  58,  28,  28,  32,  85, 115, 101,  32, 116, 104, 101,  32, 105,
110, 105, 116, 105,  97, 108,  32,  98,  97,  99, 107, 103, 114, 111, 117, 110,
100,  46,  28,  28,  32,  85, 115, 101,  32, 116, 104, 101,  32, 105, 110, 105,
116, 105,  97, 108,  32,  98,  97,  99, 107, 103, 114, 111, 117, 110, 100,  46,
 43,  43,  32,  85, 115, 101,  32,  97,  32, 112, 114, 101, 118, 105, 111, 117,
115, 108, 121,  32, 102, 105, 116, 116, 101, 100,  32, 112, 111, 108, 121, 110,
111, 109, 101,  32, 111, 102,  32, 111, 114, 100, 101, 114,  32,  21,  21,  32,
 97, 115,  32, 102, 105, 120, 101, 100,  32,  98,  97,  99, 107, 103, 114, 111,
117, 110, 100,  46,  25,  25,  32,  70, 105, 116,  32,  97,  32, 112, 111, 108,
121, 110, 111, 109, 101,  32, 111, 102,  32, 111, 114, 100, 101, 114,  32,  22,
 22,  32, 119, 105, 116, 104,  32, 116, 104, 101,  32, 114, 101, 102, 108, 101,
 99, 116, 105, 111, 110, 115,  46,  64,  64,  32,  84, 104, 101,  32, 112,  97,
116, 116, 101, 114, 110,  32,  97,  98, 115,  99, 105, 115, 115, 101,  32, 105,
115,  32, 105, 110, 116, 101, 114, 112, 114, 101, 116, 101, 100,  32,  97, 115,
 32, 116, 104, 101,  32,  84, 104, 101, 116,  97,  32,  40,  66, 114,  97, 103,
103,  32,  65, 110, 103, 108, 101,  41,  46,  87,  87,  32,  84, 104, 101,  32,
112,  97, 116, 116, 101, 114, 110,  32,  97,  98, 115,  99, 105, 115, 115, 101,
 32, 105, 115,  32, 105, 110, 116, 101, 114, 112, 114, 101, 116, 101, 100,  32,
 97, 115,  32, 116, 104, 101,  32,  98, 101,  97, 109,  32, 100, 101, 118, 105,
 97, 116, 105, 111, 110,  32,  61,  32,  50,  42,  84, 104, 101, 116,  97,  32,
 61,  32,  50,  42,  40,  66, 114,  97, 103, 103,  32,  65, 110, 103, 108, 101,
 41,  46,   5,   5,  32,  85, 115, 101,  32,   8,   8,  71,  97, 117, 115, 115,
105,  97, 110,  10,  10,  76, 111, 114, 101, 110, 116, 122, 105,  97, 110,  12,
 12,  80, 115, 101, 117, 100, 111,  45,  86, 111, 105, 103, 116,  20,  20,  32,
114, 101, 102, 108, 101,  99, 116, 105, 111, 110,  32, 112, 114, 111, 102, 105,
108, 101,  46,  72,  72,  32,  84, 104, 101,  32, 112, 114, 111, 102, 105, 108,
 32, 115, 112, 101,  99, 105, 102, 105,  99,  32, 112,  97, 114,  97, 109, 101,
116, 101, 114, 115,  32,  97, 114, 101,  32,  99, 111, 109, 109, 111, 110,  32,
105, 110, 115, 105, 100, 101,  32, 101,  97,  99, 104,  32, 105, 110, 116, 101,
103, 114,  97, 116, 105, 111, 110,  32, 122, 111, 110, 101,  46,   5,   5,  32,
 85, 115, 101,  32,  41,  41,  97,  32,  99, 111, 109, 109, 111, 110,  32, 102,
105, 116, 116, 101, 100,  32, 114, 101, 102, 108, 101,  99, 116, 105, 111, 110,
 32, 104,  97, 108, 102,  32, 119, 105, 100, 116, 104,  32,  87,  48,  46,  80,
 80, 102, 105, 116, 116, 101, 100,  32, 114, 101, 102, 108, 101,  99, 116, 105,
111, 110,  32, 104,  97, 108, 102,  32, 119, 105, 100, 116, 104, 115,  32,  87,
 32,  61,  32,  87,  48,  32,  43,  32,  87,  49,  42,  32,  84,  65,  78,  40,
 32,  84, 104, 101, 116,  97,  32,  41,  44,  32,  40,  87,  48,  32,  97, 110,
100,  32,  87,  49,  32,  97, 114, 101,  32, 102, 105, 116, 116, 101, 100,  41,
 46,  41,  41, 105, 110, 100, 105, 118, 105, 100, 117,  97, 108,  32, 102, 105,
116, 116, 101, 100,  32, 114, 101, 102, 108, 101,  99, 116, 105, 111, 110,  32,
104,  97, 108, 102,  32, 119, 105, 100, 116, 104, 115,  46,  63,  63,  32,  84,
104, 101,  32, 112, 102,  50,  32, 118,  97, 108, 117, 101,  32,  97, 114, 101,
 32, 116, 104, 101,  32, 114, 101, 102, 108, 101,  99, 116, 105, 111, 110,  32,
105, 110, 116, 101, 110, 115, 105, 116, 105, 101, 115,  32,  99, 111, 114, 114,
101,  99, 116, 101, 100,  32,  98, 121,  32, 116, 104, 101,  32,  71,  71, 110,
101, 117, 116, 114, 111, 110,  32,  68, 101,  98, 121, 101,  45,  83,  99, 104,
101, 114, 114, 101, 114,  32,  32,  76, 111, 114, 101, 110, 116, 122,  32, 102,
 97,  99, 116, 111, 114,  32,  34,  49,  46,  48,  47,  40, 115, 105, 110,  40,
116, 104, 101, 116,  97,  41,  42, 115, 105, 110,  40,  50,  42, 116, 104, 101,
116,  97,  41,  41,  34,  46,  85,  85,  88,  45, 114,  97, 121,  32,  68, 101,
 98, 121, 101,  45,  83,  99, 104, 101, 114, 114, 101, 114,  32,  76, 111, 114,
101, 110, 116, 122,  32, 102,  97,  99, 116, 111, 114,  32,  34,  40,  49,  46,
 48,  32,  43,  32,  99, 111, 115,  40, 116, 104, 101, 116,  97,  41,  94,  50,
 41,  47,  40, 115, 105, 110,  40, 116, 104, 101, 116,  97,  41,  42, 115, 105,
110,  40,  50,  42, 116, 104, 101, 116,  97,  41,  41,  34,  46,  65,  65,  32,
 84, 104, 101,  32, 112, 102,  50,  32, 118,  97, 108, 117, 101,  32,  97, 114,
101,  32,  99, 111, 112, 105, 101, 115,  32, 111, 102,  32, 105, 110, 116, 101,
110, 115, 105, 116, 105, 101, 115,  32,  40,  78, 111,  32,  76, 111, 114, 101,
110, 116, 122,  32,  99, 111, 114, 114, 101,  99, 116, 105, 111, 110,  41,  46,
 12,  12, 123,  32,  80,  97, 116, 116, 101, 114, 110,  32,  35,  32,  18,  18,
 32,  99, 104,  97, 114,  97,  99, 116, 101, 114, 105, 115, 116, 105,  99, 115,
 32,  58,  17,  17,  32,  32,  32,  32,  73, 100, 101, 110, 116, 105, 102, 105,
101, 114,  32,  61,  32,  10,  10,  44,  32,  78, 117, 109, 111, 114,  32,  61,
 32,   9,   9,  44,  32,  68,  97, 116, 101,  32,  61,  32,  13,  13,  34,  44,
 32,  83,  97, 109, 112, 108, 101,  32,  61,  32,  34,   2,   2,  34,  44,  15,
 15,  32,  32,  32,  32,  67, 111, 109, 109, 101, 110, 116,  32,  61,  32,  34,
  2,   2,  34,  44,  21,  21,  32,  32,  32,  32,  76,  97,  98, 101, 108,  32,
116, 101, 120, 116,  32, 108, 105, 115, 116,  32,  58,  24,  24,  32,  32,  32,
 32,  80,  97, 116, 116, 101, 114, 110,  32, 112,  97, 114,  97, 109, 101, 116,
101, 114, 115,  32,  58,  48,  48,  84, 101, 109, 112, 101, 114,  97, 116, 117,
114, 101,  32,  40, 111, 110,  32,  83,  97, 109, 112, 108, 101,  44,  32, 111,
110,  32, 114, 101, 103, 117, 108,  97, 116, 105, 111, 110,  44,  32, 115, 101,
116, 117, 112,  41,  32,  61,  32,  10,  10,  77, 111, 110, 105, 116, 111, 114,
 32,  61,  32,   9,   9,  44,  32,  84, 105, 109, 101,  32,  61,  32,  11,  11,
 44,  32,  76,  97, 109,  98, 100,  97,  32,  61,  32,  12,  12,  44,  32,  76,
 97, 109,  98, 100,  97,  50,  32,  61,  32,   5,   5,  79, 109, 101,  32,  61,
  8,   8,  44,  32,  67, 104, 105,  32,  61,  32,   8,   8,  44,  32,  80, 104,
105,  32,  61,  32,   8,   8,  44,  32,  84, 114,  49,  32,  61,  32,   8,   8,
 44,  32,  84, 114,  50,  32,  61,  32,   9,   9,  44,  32,  73, 118, 112,  49,
 32,  61,  32,   9,   9,  44,  32,  73, 118, 112,  50,  32,  61,  32,  14,  14,
 82, 118, 112,  91,  50,  46,  46,  57,  93,  32,  61,  32,  40,  32,   2,   2,
 44,  32,   2,   2,  44,  32,   2,   2,  44,  32,   2,   2,  44,  32,   2,   2,
 44,  32,   2,   2,  44,  32,   2,   2,  44,  32,   3,   3,  32,  41,  46,   4,
  4, 123,  32,  50,  42,   2,   2, 123,  32,  13,  13,  84, 104, 101, 116,  97,
 32,  90, 111, 110, 101,  32,  35,  32,   4,   4,  32, 105, 115,  32,   4,   4,
 32, 116, 111,  32,  20,  20,  32,  66,  97,  99, 107, 103, 114, 111, 117, 110,
100,  32,  32,  67, 104, 105,  50,  32,  61,  32,  23,  23,  32,  82, 101, 102,
108, 101,  99, 116, 105, 111, 110,  32,  70, 105, 116,  32,  67, 104, 105,  50,
 32,  61,  32,   2,   2,  32, 125,  38,  38, 123,  32,  84, 104, 101,  32,  99,
111, 109, 109, 111, 110,  32, 119, 105, 100, 116, 104,  32, 112,  97, 114,  97,
109, 101, 116, 101, 114,  32,  97, 114, 101,  32,  87,  48,  32,  61,  32,   2,
  2,  32,  40,  12,  12,  32,  41,  32,  97, 110, 100,  32,  87,  49,  32,  61,
 32,  12,  12,  32,  41,  32,  97, 110, 100,  32,  87,  49,  32,  61,  32,   2,
  2,  32,  40,   4,   4,  32,  41,  32, 125,  48,  48, 123,  32,  84, 104, 101,
 32,  99, 111, 109, 109, 111, 110,  32, 112, 115, 101, 117, 100, 111,  45, 118,
111, 105, 103, 116,  32, 112, 114, 111, 102, 105, 108,  32, 112,  97, 114,  97,
109, 101, 116, 101, 114,  32, 105, 115,  32,  61,  32,   3,   3,  32,  40,  32,
  4,   4,  32,  41,  32, 125,  39,  39, 123,  32,  84, 111, 116,  97, 108,  32,
112,  97,  99, 107, 101, 116,  32, 114, 101, 102, 108, 101,  99, 116, 105, 111,
110,  32, 105, 110, 116, 101, 110, 115, 105, 116, 121,  32,  32,  61,  32,   2,
  2,  32,  40,  31,  31,  41,  32, 119, 105, 116, 104,  32,  97,  32, 114, 101,
108,  97, 116, 101, 100,  32,  98,  97,  99, 107, 103, 114, 111, 117, 110, 100,
 32, 111, 102,  32,   2,   2,  32,  40,   4,   4,  32,  41,  32, 125, 110, 110,
123,  32,  80, 101,  97, 107,  32,  35,  32,  32,  32,  50,  42, 116, 104, 101,
116,  97,  32,  40, 115,  46, 101, 114, 114,  41,  32,  32,  32,  32,  32,  32,
 32, 104, 105, 103, 104,  32,  32,  32,  32,  40, 115,  46, 101, 114, 114,  41,
 32,  32,  32,  32,  32, 119, 105, 100, 116, 104,  32,  40, 115,  46, 101, 114,
114,  41,  32,  32,  32,  32,  32, 105, 110, 116, 101, 110, 115,  32,  32,  32,
 32,  40, 115,  46, 101, 114, 114,  41,  32,  32,  32,  32,  32,  32,  32, 112,
102,  50,  32,  32,  32,  32,  32,  40, 115,  46, 101, 114, 114,  41,  43,  43,
 42,  42,  42,  32,  82,  80,  87,  32,  69, 114, 114, 111, 114,  58,  32,  67,
 97, 110, 110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,  32,  83,
101, 116, 117, 112,  32, 102, 105, 108, 101,  32,  34,  24,  24,  34,  32, 102,
111, 114,  32, 111, 117, 116, 112, 117, 116,  32, 119, 105, 116, 104,  32, 101,
114, 114,  32,  35,  32,   5,   5,  46,  32,  42,  42,  42,  14,  14, 105, 110,
116, 101, 103, 114,  36, 112, 114, 111,  99, 101, 101, 100,  16,  16, 105, 110,
116, 101, 103, 114,  36, 109,  97, 105,  95, 115, 101, 116, 117, 112,  16,  16,
105, 110, 116, 101, 103, 114,  36,  98,  99, 107,  95, 115, 101, 116, 117, 112,
 16,  16, 105, 110, 116, 101, 103, 114,  36, 114, 101, 102,  95, 115, 101, 116,
117, 112,  16,  16, 105, 110, 116, 101, 103, 114,  36, 105, 110, 116,  95, 115,
101, 116, 117, 112,  16,  16, 105, 110, 116, 101, 103, 114,  36, 112, 114, 111,
 95, 115, 101, 116, 117, 112,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 1200 ) = {
  1,   0,   0,   0,  12,   0,   0,   0,   0,   0,   0,   0,  62,  45,  76, 101,
 97, 115, 116,  45,  83, 113, 117,  97, 114, 101, 115,  32,  97, 110, 100,  32,
105, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  32,  80, 114, 111,  99,
101, 115, 115,  32,  83, 101, 116, 116, 105, 110, 103,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 200,   0,  70,   0,
 62,  17,  76, 101,  97, 115, 116,  45,  83, 113, 117,  97, 114, 101, 115,  32,
 70, 105, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  3,  12,  94,  54,   2,  20,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  62,  29,  65, 117, 116, 111, 109,  97,
116, 105,  99,  32,  73, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  32,
 80, 114, 111,  99, 101, 115, 115,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 103,  12,  94,  54,   2,  20,   3,   2,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 62,  29,  68, 109, 112,  95, 114,  32,  58,  32,  71, 108, 111,  98,  97, 108,
 32,  68,  97, 109, 112, 105, 110, 103,  32, 102,  97,  99, 116, 111, 114,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 68,  48,  25,   5,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 128,  63,  10, 215,  35,  60,  62,  40,  77, 105, 100,  95, 114,  32,
 58,  32,  77, 105, 110, 105, 109, 117, 109,  32, 111, 102,  32, 109,  97, 116,
114, 105, 120,  32, 100, 105,  97, 103, 111, 110,  97, 108,  32, 116, 101, 114,
109, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  68,  40,  25,   5,   6,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 205, 204,  76,  61,  23, 183, 209,  56,
 62,  36,  67, 121, 109,  95, 110,  32,  58,  32,  77,  97, 120, 105, 109, 117,
109,  32, 110, 117, 109,  98, 101, 114,  32, 111, 102,  32,  76,  83,  81,  32,
 67, 121,  99, 108, 101, 115,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 81,  32,  12,   5,   5,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
200,   0,   0,   0,   0,   0,   0,   0,  62,  26,  65, 102, 109,  95, 110,  32,
 58,  32,  65, 117, 116, 111, 109,  97, 116, 105,  99,  32, 102, 105, 116,  32,
109, 111, 100, 101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  53,  24,  40,   5,   4,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 62,  31,  68, 100, 121,  95, 102,  32,  58,  32,  68, 121, 110,  97, 109, 105,
 99,  32,  70, 105, 116,  32,  68, 105, 115, 108,  97, 121,  32, 102, 108,  97,
103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 88,  16,   5,   5,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  62,  23,  77, 120, 100,  95, 102,  32,
 58,  32,  77, 120, 100,  32, 111, 117, 116, 112, 117, 116,  32, 109, 111, 100,
101,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 188,  48,   5,   5,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 62,  35,  83, 101,  97,  95, 102,  32,  58,  32,  65, 117, 116, 111, 109,  97,
116, 105,  99,  32, 115, 101,  97, 114,  99, 104,  32, 114, 101, 102, 108, 101,
 99, 116, 105, 111, 110,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
188,  40,   5,   5,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  62,  28,  83, 109, 111,  95, 102,  32,
 58,  32,  66,  97,  99, 107, 103, 114, 111, 117, 110, 100,  32,  83, 109, 111,
111, 116, 104, 105, 110, 103,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 188,  32,   5,   5,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 62,  33,  70, 117, 108,  95, 102,  32,  58,  32,  70, 117, 108, 108,  32,  80,
 97, 114, 109,  46,  32, 112,  97, 116, 116, 101, 114, 110,  32,  79, 117, 116,
112, 117, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
188,  24,   5,   5,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,  62,  33,  68, 101,  98, 117, 103,  32,
 58,  32,  68, 101,  98, 117, 103,  32, 116, 111,  32, 104, 101, 108, 112,  32,
102, 111, 114,  32, 115, 101, 116, 116, 105, 110, 103,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0, 188,  16,   5,   5,   3,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  3,  18,  18,   9,  65, 117, 116, 111, 109,  97, 116, 105,  99,   0,   0,   0,
  0,   0,   0,   0,   0,   0,  18,  13,  42, 117, 110, 100, 101, 102, 105, 110,
101, 100,  32,  49,  42,   0,   0,   0,   0,   0,  18,  13,  42, 117, 110, 100,
101, 102, 105, 110, 101, 100,  32,  50,  42,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern Blk(V_setup_tab, 48 );
extern V V_bckgrd_crv;
extern UB V_bckspl_flg;
extern V V_fitcmp_crv;
extern V V_sel_pat;
extern SL V_sel_ileft;
extern SL V_sel_iright;
extern Blk(V_hkl_parm, 112 );
extern Blk(V_mai_parm, 1312 );
extern F V_spthmin;
extern F V_spthmax;
extern F V_szthmin;
extern F V_szthmax;
extern UB V_fil_nbr;
extern Blk(V_int_name, 264 );
extern UB V_out_app;
extern SL PAS__iostatus;
extern V PAS__f_output;
extern V V_pat_first;
extern SL V_frspint;
extern SL V_nbrpint;
extern SL V_ntotpck;

/* Declaration of global variables. */
SL V_phase_curr;
V V_zone_free = NULL;
V V_zone_first = NULL;
V V_zone_last = NULL;
V V_peak_curr = NULL;
V V_peak_free = NULL;
V V_peak_first = NULL;
V V_peak_last = NULL;
SL V_fitcmp_cnp;
SL V_filnbr;
SL V_idgw;
SL V_idsp;
SL V_curr_ind;
UB V_bfitini;
UB V_bprocess;
Blk(V_pro_parm, 24 );
Blk(V_pro_prmdef, 24 ) = {
  0,   0, 128,  63,  23, 183, 209,  56,
100,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   1,   0,   1,   0,   0,   0 };

/* Function/procedure prototypes. */
void RPW_Set_Ref(V *F_p, V F_t);
void P_del_curve(V F_pc);
SL P_get_new_params(V F_parm_tab);
V P_integr_Build_background();
void P_integr_Smooth_background();
V P_integr_Ref_locate();
V P_integr_Ref_copy();
V P_integr_Ref_integr();


/* Procedure/Function : " pro_Default_setup "  */
void P_pro_Default_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=126; /* line # 126 */
  if (Ri.ub[0]) {
    Ra.sl[3]=128; /* line # 128 */
    Ra.sl[3]=130; /* line # 130 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(3,1,Ri.sl[1])*22+16),V_pro_parm.s);
    Ra.sl[3]=131; /* line # 131 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(4,1,Ri.sl[1])*22+16),V_pro_parm.s+4);
    Ra.sl[3]=132; /* line # 132 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(5,1,Ri.sl[1])*22+16),V_pro_parm.s+8);
    Ra.sl[3]=133; /* line # 133 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(6,1,Ri.sl[1])*22+16),V_pro_parm.s+12);
    RPW_Set_Ref((Ri.v+PAS__RANGE(6,1,Ri.sl[1])*22+17),Ri.s+1136);
    Ra.sl[3]=134; /* line # 134 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(7,1,Ri.sl[1])*22+16),V_pro_parm.s+16);
    Ra.sl[3]=135; /* line # 135 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(8,1,Ri.sl[1])*22+16),V_pro_parm.s+17);
    Ra.sl[3]=136; /* line # 136 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(9,1,Ri.sl[1])*22+16),V_pro_parm.s+18);
    Ra.sl[3]=137; /* line # 137 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(10,1,Ri.sl[1])*22+16),V_pro_parm.s+19);
    Ra.sl[3]=138; /* line # 138 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(11,1,Ri.sl[1])*22+16),V_pro_parm.s+20);
    Ra.sl[3]=139; /* line # 139 */
    RPW_Set_Ref((Ri.v+PAS__RANGE(12,1,Ri.sl[1])*22+16),V_pro_parm.s+21);
    Ra.sl[3]=141; /* line # 141 */
    V_setup_tab.v[PAS__RANGE(2,0,V_setup_tab.sl[0])+1]=Ri.s+4;
    Ra.sl[3]=142; /* line # 142 */
    Ri.ub[0]=0;
  }
  Ra.sl[3]=144; /* line # 144 */
  memcpy(V_pro_parm.s,V_pro_prmdef.s,22);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " delete_curves "  */
void P_delete_curves(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+81;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=152; /* line # 152 */
  if (V_bckgrd_crv!=NULL) {
    Ra.sl[3]=154; /* line # 154 */
    P_del_curve(V_bckgrd_crv);
    Ra.sl[3]=155; /* line # 155 */
    V_bckgrd_crv=NULL;
    Ra.sl[3]=156; /* line # 156 */
    V_bckspl_flg=0;
  }
  Ra.sl[3]=158; /* line # 158 */
  if (V_fitcmp_crv!=NULL) {
    Ra.sl[3]=160; /* line # 160 */
    P_del_curve(V_fitcmp_crv);
    Ra.sl[3]=161; /* line # 161 */
    V_fitcmp_crv=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " locate_angle "  */
SL P_locate_angle(F F_ang, F F_tol, SL F_isc, UB F_brg, UB F_bif){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  F Rv3;
  SL Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=175; /* line # 175 */
  Rv0=V_sel_pat;
  Ra.sl[3]=177; /* line # 177 */
  if (F_brg) {
    Rv1=V_sel_ileft;
    Rv2=V_sel_iright;
  }
  else {
    Ra.sl[3]=178; /* line # 178 */
    Rv1=1;
    Rv2=((SL *)Rv0)[0];
  }
  Ra.sl[3]=179; /* line # 179 */
  if (F_isc<Rv1||F_isc>Rv2) F_isc=Rv1;
  Ra.sl[3]=180; /* line # 180 */
  if (!F_bif) {
    Ra.sl[3]=181; /* line # 181 */
    while (F_isc<=Rv2&&128&((UB *)Rv0)[PAS__RANGE(F_isc,1,((SL *)Rv0)[0])*16+338]
    )
    F_isc=F_isc+1;
  }
  Ra.sl[3]=182; /* line # 182 */
  if (F_isc<=Rv2) {
    Ra.sl[3]=184; /* line # 184 */
    Rv3=fabs(F_ang-((F *)Rv0)[PAS__RANGE(F_isc,1,((SL *)Rv0)[0])*4+81]);
    Ra.sl[3]=185; /* line # 185 */
    Rv4=F_isc;
    Rv5=F_isc;
    Ra.sl[3]=186; /* line # 186 */
    while (Rv5<((SL *)Rv0)[0]){
      Ra.sl[3]=188; /* line # 188 */
      Rv5=Rv5+1;
      Ra.sl[3]=189; /* line # 189 */
      if (F_bif||!(128&((UB *)Rv0)[PAS__RANGE(Rv5,1,((SL *)Rv0)[0])*16+338])) {
        Ra.sl[3]=191; /* line # 191 */
        Rv6=((F *)Rv0)[PAS__RANGE(Rv5,1,((SL *)Rv0)[0])*4+81];
        Rv7=fabs(F_ang-Rv6);
        Ra.sl[3]=192; /* line # 192 */
        if (Rv7>Rv3)  break;
        Ra.sl[3]=193; /* line # 193 */
        Rv3=Rv7;
        Rv4=Rv5;
      }
    }
    Ra.sl[3]=196; /* line # 196 */
    if (Rv3<=F_tol) Ret=Rv4;
    else {
      Ra.sl[3]=197; /* line # 197 */
      Ret=0;
    }
  }
  else {
    Ra.sl[3]=198; /* line # 198 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Update_pat_info "  */
void P_integr_Update_pat_info(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+110;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=207; /* line # 207 */
  if (V_sel_pat!=NULL) {
    Ra.sl[3]=208; /* line # 208 */
    Rv0=V_sel_pat;
    Ra.sl[3]=210; /* line # 210 */
    if (V_hkl_parm.f[0]==(F)0.000000E-01) V_hkl_parm.f[0]=((F *)Rv0)[66];
    else {
      Ra.sl[3]=212; /* line # 212 */
      if (V_hkl_parm.f[0]!=((F *)Rv0)[66]&&((F *)Rv0)[66]!=(F)0.000000E-01) ((F *)
      Rv0)[66]=V_hkl_parm.f[0];
    }
    Ra.sl[3]=213; /* line # 213 */
    if (V_hkl_parm.f[1]==(F)0.000000E-01) V_hkl_parm.f[1]=((F *)Rv0)[67];
    else {
      Ra.sl[3]=215; /* line # 215 */
      if (V_hkl_parm.f[1]!=((F *)Rv0)[67]&&((F *)Rv0)[67]!=(F)0.000000E-01) ((F *)
      Rv0)[67]=V_hkl_parm.f[1];
    }
    Ra.sl[3]=216; /* line # 216 */
    if (V_hkl_parm.f[2]==(F)0.000000E-01) V_hkl_parm.f[2]=((F *)Rv0)[68];
    else {
      Ra.sl[3]=218; /* line # 218 */
      if (V_hkl_parm.f[2]!=((F *)Rv0)[68]&&((F *)Rv0)[68]!=(F)0.000000E-01) ((F *)
      Rv0)[68]=V_hkl_parm.f[2];
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Select_pattern "  */
void P_integr_Select_pattern(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+134;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=230; /* line # 230 */
  V_sel_pat=F_p;
  Ra.sl[3]=231; /* line # 231 */
  Rv0=V_sel_pat;
  Ra.sl[3]=234; /* line # 234 */
  V_hkl_parm.f[0]=((F *)Rv0)[66];
  Ra.sl[3]=235; /* line # 235 */
  V_hkl_parm.f[1]=((F *)Rv0)[67];
  Ra.sl[3]=236; /* line # 236 */
  V_hkl_parm.f[2]=((F *)Rv0)[68];
  Ra.sl[3]=239; /* line # 239 */
  if (V_mai_parm.f[324]>(F)0.000000E-01&&((F *)Rv0)[81]<V_mai_parm.f[325]) {
    Ra.sl[3]=241; /* line # 241 */
    V_spthmin=V_mai_parm.f[324];
    Ra.sl[3]=242; /* line # 242 */
    V_sel_ileft=P_locate_angle(V_spthmin, (F)5.000000E-01,1,0,0);
  }
  else {
    Ra.sl[3]=246; /* line # 246 */
    V_spthmin=((F *)Rv0)[81];
    V_sel_ileft=1;
  }
  Ra.sl[3]=248; /* line # 248 */
  if (V_mai_parm.f[325]>(F)0.000000E-01&&((F *)Rv0)[82]>V_mai_parm.f[325]) {
    Ra.sl[3]=250; /* line # 250 */
    V_spthmax=V_mai_parm.f[325];
    Ra.sl[3]=251; /* line # 251 */
    V_sel_iright=P_locate_angle(V_spthmax, (F)5.000000E-01, V_sel_ileft,0,0);
  }
  else {
    Ra.sl[3]=255; /* line # 255 */
    V_spthmax=((F *)Rv0)[82];
    V_sel_iright=((SL *)Rv0)[0];
  }
  Ra.sl[3]=257; /* line # 257 */
  V_szthmin=V_spthmin;
  Ra.sl[3]=258; /* line # 258 */
  V_szthmax=V_spthmax;
  Ra.sl[3]=260; /* line # 260 */
  P_delete_curves();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Set_limit "  */
void P_integr_Set_limit(F F_theta_min, F F_theta_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+157;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=274; /* line # 274 */
  if (V_sel_pat!=NULL) {
    Ra.sl[3]=275; /* line # 275 */
    Rv0=V_sel_pat;
    Ra.sl[3]=277; /* line # 277 */
    Rv1=F_theta_max-F_theta_min;
    Ra.sl[3]=278; /* line # 278 */
    if (F_theta_min<V_spthmin) {
      V_szthmin=V_spthmin;
      V_szthmax=V_szthmin+Rv1;
    }
    else {
      Ra.sl[3]=280; /* line # 280 */
      if (F_theta_max>V_spthmax) {
        V_szthmax=V_spthmax;
        V_szthmin=V_szthmax-Rv1;
      }
      else {
        Ra.sl[3]=282; /* line # 282 */
        V_szthmin=F_theta_min;
        V_szthmax=F_theta_max;
      }
    }
    Ra.sl[3]=283; /* line # 283 */
    V_sel_ileft=P_locate_angle(V_szthmin, (F)5.000000E-01,1,0,0);
    Ra.sl[3]=284; /* line # 284 */
    if (V_sel_ileft<=0) V_sel_ileft=1;
    Ra.sl[3]=285; /* line # 285 */
    V_sel_iright=P_locate_angle(V_szthmax, (F)5.000000E-01, V_sel_ileft,0,0);
    Ra.sl[3]=286; /* line # 286 */
    if (V_sel_iright<=0) V_sel_iright=((SL *)Rv0)[0];
    Ra.sl[3]=287; /* line # 287 */
    P_delete_curves();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Write_results "  */
V P_integr_Write_results(){
  /* Define the automatic variable space. */
  Blk( Ra, 792 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  SL Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  register F Rgf;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Rv0=NULL;
  Ra.v[129]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+516;
  Ra.v[130]=Rd.s+175;
  Ra.v[131]=Rd.s+19;
  Ra.sl[132]=308; /* line # 308 */
  V_filnbr=V_filnbr+1;
  Ra.sl[132]=309; /* line # 309 */
  if (V_fil_nbr) {
    Ra.sl[132]=311; /* line # 311 */
    Rv1=PAS__NINDEX_CHA(V_int_name.s+2,(SL)V_int_name.ub[1],47,-1,-1,1);
    Ra.sl[132]=312; /* line # 312 */
    Rv2=PAS__NINDEX_CHA(V_int_name.s+2,(SL)V_int_name.ub[1],46,-1,-1,1);
    Ra.sl[132]=313; /* line # 313 */
    if (Rv1>Rv2) {
      PAS__STR_TO_STR(Ra.s,V_int_name.s);
      Rv2=0;
    }
    else {
      Ra.sl[132]=314; /* line # 314 */
      PAS__STR_TO_STR(Ra.s,PAS__SUBSTR_STR(Ra.s+532,V_int_name.s,1, Rv2-1));
    }
    Ra.sl[132]=315; /* line # 315 */
    if (Rv2>0) {
      PAS__VWRITE_INIT(Ra.s+257,1);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_INT(V_filnbr,-4,0);
      PAS__WRITE_STR(PAS__SUBSTR_STR(Ra.s+532,V_int_name.s,Rv2,0),-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[132]=316; /* line # 316 */
      PAS__VWRITE_INIT(Ra.s+257,1);
      PAS__WRITE_STR(Ra.s,-1,-1,32);
      PAS__WRITE_INT(V_filnbr,-4,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=317; /* line # 317 */
    PAS__OPEN(&Rv0,0, Ra.s+257,4098,0,-1);
  }
  else {
    Ra.sl[132]=321; /* line # 321 */
    PAS__STR_TO_STR(Ra.s+257,V_int_name.s);
    Ra.sl[132]=322; /* line # 322 */
    if (V_out_app) PAS__OPEN(&Rv0,0, Ra.s+257,4100,0,-1);
    else {
      Ra.sl[132]=323; /* line # 323 */
      PAS__OPEN(&Rv0,0, Ra.s+257,4098,0,-1);
    }
    Ra.sl[132]=324; /* line # 324 */
    V_out_app=1;
  }
  Ra.sl[132]=327; /* line # 327 */
  if (PAS__iostatus==0) {
    Ra.sl[132]=328; /* line # 328 */
    Rv3=V_sel_pat;
    Ra.sl[132]=330; /* line # 330 */
    Rv1=0;
    Ra.sl[132]=331; /* line # 331 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+197,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=332; /* line # 332 */
    if (V_hkl_parm.sl[18]<0) {
      Ra.sl[132]=333; /* line # 333 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+228,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[132]=335; /* line # 335 */
      switch (V_hkl_parm.sl[19]) {
        case 0:Ra.sl[132]=336; /* line # 336 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+258,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 1:Ra.sl[132]=337; /* line # 337 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+288,-1,-1,32);
        PAS__WRITE_INT(V_hkl_parm.sl[18],0,0);
        PAS__WRITE_STR(Rd.s+333,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 2:Ra.sl[132]=338; /* line # 338 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+356,-1,-1,32);
        PAS__WRITE_INT(V_hkl_parm.sl[18],0,0);
        PAS__WRITE_STR(Rd.s+383,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        default:break;
      }
    }
    Ra.sl[132]=342; /* line # 342 */
    if (V_mai_parm.ub[1304]) {
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+407,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[132]=343; /* line # 343 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+473,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=345; /* line # 345 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+562,-1,-1,32);
    Ra.sl[132]=346; /* line # 346 */
    switch (V_hkl_parm.sl[23]) {
      case 1:Ra.sl[132]=347; /* line # 347 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+579,-1,-1,32);
      break;
      case 2:Ra.sl[132]=348; /* line # 348 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+591,-1,-1,32);
      break;
      default:Ra.sl[132]=350; /* line # 350 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+569,-1,-1,32);
      break;
    }
    Ra.sl[132]=352; /* line # 352 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+605,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=353; /* line # 353 */
    if (V_hkl_parm.sl[21]>0&&V_hkl_parm.sl[23]==2) {
      Ra.sl[132]=354; /* line # 354 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+627,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=355; /* line # 355 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+701,-1,-1,32);
    Ra.sl[132]=356; /* line # 356 */
    if (V_hkl_parm.sl[20]>0) {
      Ra.sl[132]=358; /* line # 358 */
      if (V_hkl_parm.sl[20]==1) {
        Ra.sl[132]=359; /* line # 359 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+708,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[132]=361; /* line # 361 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+751,-1,-1,32);
        PAS__WRITE_EOLN();
      }
    }
    else {
      Ra.sl[132]=364; /* line # 364 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+833,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=365; /* line # 365 */
    if (V_hkl_parm.sl[22]>0) {
      Ra.sl[132]=367; /* line # 367 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+876,-1,-1,32);
      Ra.sl[132]=368; /* line # 368 */
      switch (V_hkl_parm.sl[22]) {
        case 1:Ra.sl[132]=369; /* line # 369 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+941,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        case 2:Ra.sl[132]=370; /* line # 370 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+1014,-1,-1,32);
        PAS__WRITE_EOLN();
        break;
        default:Ra.sl[132]=372; /* line # 372 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_EOLN();
        break;
      }
    }
    else {
      Ra.sl[132]=374; /* line # 374 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+1101,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=375; /* line # 375 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_CHAR(125);
    PAS__WRITE_EOLN();
    Ra.sl[132]=376; /* line # 376 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_EOLN();
    Ra.sl[132]=377; /* line # 377 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+1168,-1,-1,32);
    PAS__WRITE_INT(V_filnbr,4,0);
    PAS__WRITE_STR(Rd.s+1182,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=378; /* line # 378 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+1202,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv3)[4],10,0);
    PAS__WRITE_STR(Rd.s+1221,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv3)[5],10,0);
    PAS__WRITE_STR(Rd.s+1233,-1,-1,32);
    PAS__WRITE_STR(Rv3+24,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1244,-1,-1,32);
    PAS__WRITE_STR(Rv3+88,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1259,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=379; /* line # 379 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+1263,-1,-1,32);
    PAS__WRITE_STR(Rv3+152,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1280,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=380; /* line # 380 */
    if (((V *)Rv3)[3]!=NULL) {
      Ra.sl[132]=382; /* line # 382 */
      Rv4=((V *)Rv3)[3];
      Ra.sl[132]=383; /* line # 383 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+1284,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[132]=384; /* line # 384 */
      while (Rv4!=NULL){
        Ra.sl[132]=385; /* line # 385 */
        Rv5=Rv4;
        Ra.sl[132]=387; /* line # 387 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_FCHAR(32,8,-1,1,32);
        PAS__WRITE_CHT(Rv5+8,(SL)((UB *)Rv5)[0],((UB *)Rv5)[0],-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[132]=388; /* line # 388 */
        Rv4=((V *)Rv5)[1];
      }
    }
    Ra.sl[132]=391; /* line # 391 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_EOLN();
    Ra.sl[132]=392; /* line # 392 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_STR(Rd.s+1307,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=393; /* line # 393 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    PAS__WRITE_STR(Rd.s+1333,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv3)[65],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv3)[64],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv3)[63],8,3,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_EOLN();
    Ra.sl[132]=394; /* line # 394 */
    if (V_pro_parm.ub[20]) {
      Ra.sl[132]=396; /* line # 396 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+1383,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[54],12,0,0);
      PAS__WRITE_STR(Rd.s+1395,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[55],10,0,0);
      PAS__WRITE_STR(Rd.s+1406,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[66],10,5,0);
      Ra.sl[132]=397; /* line # 397 */
      if (((F *)Rv3)[67]>(F)0.000000E-01) {
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+1419,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv3)[67],10,5,0);
        PAS__WRITE_EOLN();
      }
      else {
        Ra.sl[132]=398; /* line # 398 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_EOLN();
      }
      Ra.sl[132]=399; /* line # 399 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+1433,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[57],8,3,0);
      PAS__WRITE_STR(Rd.s+1440,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[58],8,3,0);
      PAS__WRITE_STR(Rd.s+1450,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[59],8,3,0);
      PAS__WRITE_STR(Rd.s+1460,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[60],8,3,0);
      PAS__WRITE_STR(Rd.s+1470,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[61],8,3,0);
      PAS__WRITE_STR(Rd.s+1480,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv3)[79],8,0);
      PAS__WRITE_STR(Rd.s+1491,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv3)[80],8,0);
      PAS__WRITE_EOLN();
      Ra.sl[132]=401; /* line # 401 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      PAS__WRITE_STR(Rd.s+1502,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[69],10,4,0);
      PAS__WRITE_STR(Rd.s+1518,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[70],10,4,0);
      PAS__WRITE_STR(Rd.s+1522,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[71],10,4,0);
      PAS__WRITE_STR(Rd.s+1526,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[72],10,4,0);
      PAS__WRITE_STR(Rd.s+1530,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[73],10,4,0);
      PAS__WRITE_STR(Rd.s+1534,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[74],10,4,0);
      PAS__WRITE_STR(Rd.s+1538,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[75],10,4,0);
      PAS__WRITE_STR(Rd.s+1542,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[76],10,4,0);
      PAS__WRITE_STR(Rd.s+1546,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    Ra.sl[132]=404; /* line # 404 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_CHAR(125);
    PAS__WRITE_EOLN();
    Ra.sl[132]=405; /* line # 405 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_EOLN();
    Ra.sl[132]=407; /* line # 407 */
    Rv6=V_zone_first;
    Ra.sl[132]=408; /* line # 408 */
    while (Rv6!=NULL){
      Ra.sl[132]=409; /* line # 409 */
      Rv7=Rv6;
      Ra.sl[132]=411; /* line # 411 */
      Rv1=Rv1+1;
      Ra.sl[132]=412; /* line # 412 */
      if (V_mai_parm.ub[1304]) {
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+1551,-1,-1,32);
      }
      else {
        Ra.sl[132]=413; /* line # 413 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+1557,-1,-1,32);
      }
      Ra.sl[132]=414; /* line # 414 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+1561,-1,-1,32);
      PAS__WRITE_INT(Rv1,3,0);
      PAS__WRITE_STR(Rd.s+1576,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[PAS__RANGE(((SL *)Rv7)[8],1,((SL *)Rv3)[0])*4+81]
      ,8,3,0);
      PAS__WRITE_STR(Rd.s+1582,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[PAS__RANGE(((SL *)Rv7)[9],1,((SL *)Rv3)[0])*4+81]
      ,8,3,0);
      PAS__WRITE_STR(Rd.s+1588,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[16],8,3,0);
      PAS__WRITE_STR(Rd.s+1610,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[17],8,3,0);
      PAS__WRITE_STR(Rd.s+1635,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[132]=416; /* line # 416 */
      if (V_hkl_parm.sl[20]==2) {
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_STR(Rd.s+1639,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv7)[27],8,3,0);
        PAS__WRITE_STR(Rd.s+1679,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv7)[29],7,3,0);
        PAS__WRITE_STR(Rd.s+1683,-1,-1,32);
        PAS__WRITE_STR(Rd.s+1697,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv7)[28],8,3,0);
        PAS__WRITE_STR(Rd.s+1711,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv7)[30],7,3,0);
        PAS__WRITE_STR(Rd.s+1715,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Ra.sl[132]=419; /* line # 419 */
      if (V_hkl_parm.sl[21]>0) {
        Ra.sl[132]=420; /* line # 420 */
        switch (V_hkl_parm.sl[23]) {
          case 2:Ra.sl[132]=422; /* line # 422 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+1721,-1,-1,32);
          PAS__WRITE_SNGL(((F *)Rv7)[23],8,4,0);
          PAS__WRITE_STR(Rd.s+1771,-1,-1,32);
          PAS__WRITE_SNGL(((F *)Rv7)[25],7,4,0);
          PAS__WRITE_STR(Rd.s+1776,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          default:break;
        }
      }
      Ra.sl[132]=426; /* line # 426 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+1782,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[21],10,1,0);
      PAS__WRITE_STR(Rd.s+1823,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[22],8,1,0);
      PAS__WRITE_STR(Rd.s+1827,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[19],10,1,0);
      PAS__WRITE_STR(Rd.s+1860,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv7)[20],9,2,0);
      PAS__WRITE_STR(Rd.s+1864,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[132]=428; /* line # 428 */
      Rv2=0;
      Ra.sl[132]=429; /* line # 429 */
      Rv8=((V *)Rv7)[1];
      Ra.sl[132]=430; /* line # 430 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_STR(Rd.s+1870,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[132]=433; /* line # 433 */
      while (Rv8!=NULL){
        Ra.sl[132]=434; /* line # 434 */
        Rv9=Rv8;
        Ra.sl[132]=436; /* line # 436 */
        Rv2=Rv2+1;
        Ra.sl[132]=437; /* line # 437 */
        Rv10=((F *)Rv9)[11]*(F)1.745329E-02;
        Ra.sl[132]=438; /* line # 438 */
        if (V_mai_parm.ub[1304]) Rv10=(F)2.000000E+00*Rv10;
        Ra.sl[132]=439; /* line # 439 */
        switch (V_hkl_parm.sl[22]) {
          case 1:Ra.sl[132]=440; /* line # 440 */
          Rv10=sin((F)5.000000E-01*Rv10)*sin(Rv10);
          break;
          case 2:Ra.sl[132]=442; /* line # 442 */
          Rv10=(sin((F)5.000000E-01*Rv10)*sin(Rv10))/((F)1.000000E+00+PAS__F_SQR
          (cos(Rv10)));
          break;
          default:Ra.sl[132]=445; /* line # 445 */
          Rv10=(F)1.000000E+00;
          break;
        }
        Ra.sl[132]=447; /* line # 447 */
        Rv11=Rv10*((F *)Rv9)[19];
        if (((F *)Rv9)[20]>=(F)0.000000E-01) Rv12=Rv10*((F *)Rv9)[20];
        Ra.sl[132]=448; /* line # 448 */
        PAS__SELECT_OUT(Rv0);
        PAS__WRITE_FCHAR(32,4,-1,1,32);
        PAS__WRITE_INT(Rv2,4,0);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_SNGL(((F *)Rv9)[11],8,3,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)Rv9)[12],7,3,0);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_SNGL(((F *)Rv9)[13],10,1,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)Rv9)[14],9,1,0);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_SNGL(((F *)Rv9)[15],8,3,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)Rv9)[16],7,3,0);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_SNGL(((F *)Rv9)[19],10,2,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)Rv9)[20],9,2,0);
        PAS__WRITE_FCHAR(32,2,-1,1,32);
        PAS__WRITE_SNGL(Rv11,10,2,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(Rv12,9,2,0);
        PAS__WRITE_EOLN();
        Ra.sl[132]=451; /* line # 451 */
        Rv8=((V *)Rv9)[0];
      }
      Ra.sl[132]=453; /* line # 453 */
      PAS__SELECT_OUT(Rv0);
      PAS__WRITE_EOLN();
      Ra.sl[132]=454; /* line # 454 */
      Rv6=((V *)Rv7)[0];
    }
    Ra.sl[132]=456; /* line # 456 */
    PAS__SELECT_OUT(Rv0);
    PAS__WRITE_EOLN();
    Ra.sl[132]=457; /* line # 457 */
    PAS__CLOSE(&Rv0,0);
    Ra.sl[132]=458; /* line # 458 */
    Ret=NULL;
  }
  else {
    Ra.sl[132]=462; /* line # 462 */
    PAS__VWRITE_INIT(Ra.s,1);
    PAS__WRITE_STR(Rd.s+1982,-1,-1,32);
    PAS__WRITE_STR(Ra.s+257,-1,-1,32);
    PAS__WRITE_STR(Rd.s+2027,-1,-1,32);
    PAS__WRITE_INT(PAS__iostatus,0,0);
    PAS__WRITE_STR(Rd.s+2053,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[132]=464; /* line # 464 */
    Ret=Ra.s;
  }
  PAS__curr_cntx=Ra.v[129];
  return(Ret);
}


/* Procedure/Function : " integr_Proceed "  */
void P_integr_Proceed(V *F_pmsg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2060;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=478; /* line # 478 */
  (*F_pmsg)=NULL;
  Ra.sl[3]=479; /* line # 479 */
  Rv0=1;
  Ra.sl[3]=480; /* line # 480 */
  V_sel_pat=V_pat_first;
  Ra.sl[3]=481; /* line # 481 */
  while (V_sel_pat!=NULL&&Rv0<V_frspint){
    Ra.sl[3]=482; /* line # 482 */
    Rv0=Rv0+1;
    V_sel_pat=((V *)V_sel_pat)[1];
  }
  Ra.sl[3]=483; /* line # 483 */
  if (V_sel_pat!=NULL) {
    Ra.sl[3]=484; /* line # 484 */
    Ra.sl[3]=486; /* line # 486 */
    V_bprocess=1;
    Ra.sl[3]=488; /* line # 488 */
    Rv1=V_nbrpint;
    Ra.sl[3]=489; /* line # 489 */
    while (V_sel_pat!=NULL){
      Ra.sl[3]=491; /* line # 491 */
      P_integr_Set_limit(V_szthmin, V_szthmax);
      Ra.sl[3]=492; /* line # 492 */
      (*F_pmsg)=P_integr_Build_background();
      Ra.sl[3]=493; /* line # 493 */
      if ((*F_pmsg)!=NULL)  break;
      Ra.sl[3]=494; /* line # 494 */
      if (V_pro_parm.ub[19]) P_integr_Smooth_background();
      Ra.sl[3]=495; /* line # 495 */
      if (V_pro_parm.ub[18]) (*F_pmsg)=P_integr_Ref_locate();
      else {
        Ra.sl[3]=496; /* line # 496 */
        (*F_pmsg)=P_integr_Ref_copy();
      }
      Ra.sl[3]=497; /* line # 497 */
      if (V_ntotpck<=0||(*F_pmsg)!=NULL)  break;
      Ra.sl[3]=498; /* line # 498 */
      (*F_pmsg)=P_integr_Ref_integr();
      Ra.sl[3]=499; /* line # 499 */
      if ((*F_pmsg)!=NULL)  break;
      Ra.sl[3]=500; /* line # 500 */
      (*F_pmsg)=P_integr_Write_results();
      Ra.sl[3]=501; /* line # 501 */
      if ((*F_pmsg)!=NULL)  break;
      Ra.sl[3]=502; /* line # 502 */
      Rv1=Rv1-1;
      Ra.sl[3]=503; /* line # 503 */
      if (Rv1==0)  break;
      Ra.sl[3]=504; /* line # 504 */
      V_sel_pat=((V *)V_sel_pat)[1];
    }
    Ra.sl[3]=506; /* line # 506 */
    V_bprocess=0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Mai_setup "  */
SL P_integr_Mai_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2076;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=520; /* line # 520 */
  Ret=P_get_new_params(V_setup_tab.v[PAS__RANGE(1,0,V_setup_tab.sl[0])+1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Bck_setup "  */
SL P_integr_Bck_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2094;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=528; /* line # 528 */
  Ret=P_get_new_params(V_setup_tab.v[PAS__RANGE(2,0,V_setup_tab.sl[0])+1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Ref_setup "  */
SL P_integr_Ref_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2112;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=536; /* line # 536 */
  Ret=P_get_new_params(V_setup_tab.v[PAS__RANGE(3,0,V_setup_tab.sl[0])+1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Int_setup "  */
SL P_integr_Int_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2130;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=544; /* line # 544 */
  Ret=P_get_new_params(V_setup_tab.v[PAS__RANGE(4,0,V_setup_tab.sl[0])+1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " integr_Pro_setup "  */
SL P_integr_Pro_setup(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+2148;
  Ra.v[2]=Rd.s+19;
  Ra.sl[3]=552; /* line # 552 */
  Ret=P_get_new_params(V_setup_tab.v[PAS__RANGE(5,0,V_setup_tab.sl[0])+1]);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
