/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 744 ) = {
 14,  14, 100, 105, 115, 112, 108,  97, 121,  95, 102, 105, 116, 100, 111, 116,
 60,  60,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,
 83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 114,
112, 119, 100,  97, 116,  97,  95, 115, 114,  99,  47, 114, 112, 119, 100,  97,
116,  97,  95, 105, 110, 116,  95, 105, 110, 116,  46, 112,  97, 115,  11,  11,
102, 112,  99, 107,  95, 100, 101, 102, 105, 110, 101,  10,  10,  99, 104, 112,
 99, 107,  95,  99, 111, 101, 102,   5,   5,  32,  80,  32,  35,  32,   9,   9,
 32,  58,  32, 110, 101, 119,  32,  61,  32,   7,   7,  44,  32, 115, 103,  32,
 61,  32,   8,   8,  44,  32, 111, 108, 100,  32,  61,  32,  11,  11,  44,  32,
 99, 104,  97, 110, 103, 101,  32,  61,  32,   3,   3,  32,  76, 109,  12,  12,
114, 101, 102,  95, 100,  99, 111, 109, 112, 117, 116, 101,  10,  10, 102, 112,
 99, 107,  95,  99, 121,  99, 108, 101,  11,  11, 102, 112,  99, 107,  95, 109,
114, 113, 102, 105, 116,  15,  15,  32,  83, 116,  97, 114, 116,  32,  67, 121,
 99, 108, 101,  32,  35,  32,  12,  12,  32, 119, 105, 116, 104,  32, 109, 114,
113,  32,  61,  32,   9,   9,  32,  67, 121,  99, 108, 101,  32,  35,  32,  38,
 38,  32,  67,  97, 110,  99, 101, 108, 101, 100,  32,  40,  84, 111, 111,  32,
108,  97, 114, 103, 101,  32, 114, 101, 115, 117, 108, 116, 105, 110, 103,  32,
 99, 104, 105,  50,  32,  58,  32,   2,   2,  32,  41,   9,   9,  32,  67, 121,
 99, 108, 101,  32,  35,  32,  12,  12,  32, 119, 105, 116, 104,  32, 109, 114,
113,  32,  61,  32,  10,  10,  32,  58,  32,  67, 104, 105,  50,  32,  61,  32,
 13,  13, 110, 117, 109,  95, 101, 114, 114, 111, 114,  95, 104, 100, 108,  61,
 61,  32,  42,  42,  42,  32,  78, 117, 109, 101, 114, 105,  99,  32, 101, 114,
114, 111, 114,  32, 100, 117, 114, 105, 110, 103,  32, 116, 104, 101,  32,  82,
 80,  87,  32,  73, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  47,  70,
105, 116,  32, 112, 114, 111,  99, 101, 115, 115,  32,  42,  42,  42,  12,  12,
114, 101, 102,  95, 105,  99, 111, 109, 112, 117, 116, 101,  10,  10, 102, 105,
116,  95, 112,  97,  99, 107, 101, 116,  26,  26,  32,  71, 111, 111, 100, 110,
101, 115, 115,  32, 111, 102,  32,  70, 105, 116,  32,  40,  67, 104, 105,  50,
 41,  32,  61,  32,  26,  26,  32,  70, 114,  97,  99, 116, 105, 111, 110,  32,
111, 102,  32,  98,  97,  99, 107, 103, 114, 111, 117, 110, 100,  32,  61,  32,
  3,   3,  32,  47,  32,  13,  13,  32,  42,  42,  42,  32,  80, 101,  97, 107,
 32,  97, 116,  32,   6,   6,  44,  32,  73,  32,  61,  32,   6,   6,  44,  32,
 72,  32,  61,  32,   6,   6,  44,  32,  87,  32,  61,  32,  13,  13, 105, 110,
116, 101, 103, 114,  95, 112,  97,  99, 107, 101, 116,  19,  19,  32,  66,  97,
 99, 107, 103, 114, 111, 117, 110, 100,  32,  67, 104, 105,  50,  32,  61,  32,
 16,  16,  32,  66,  97,  99, 107, 103, 114, 111, 117, 110, 100,  32,  67, 111,
101, 102,   3,   3,  32,  61,  32,  32,  32,  32,  84, 111, 116,  97, 108,  32,
 73, 110, 116, 101, 110, 115, 105, 116, 121,  32, 102, 111, 114,  32, 116, 104,
101,  32, 122, 111, 110, 101,  32,  35,  32,   6,   6,  32, 102, 114, 111, 109,
 32,   4,   4,  32, 116, 111,  32,   5,   5,  32,  73,  32,  61,  32,   3,   3,
 32,  58,  32,  18,  18,  32, 111,  98, 116,  97, 105, 110,  32, 119, 105, 116,
104,  32, 111,  98,  32,  61,  32,   7,   7,  44,  32,  98, 107,  32,  61,  32,
  5,   5,  32,  97, 110, 100,  32,  10,  10,  32,  66,  67,  75,  32, 100, 111,
116, 115,  46,   9,   9,  32,  80, 101,  97, 107,  32,  97, 116,  32,  10,  10,
 32, 119, 105, 116, 104,  32, 104,  32,  61,  32,   6,   6,  44,  32, 119,  32,
 61,  32,  17,  17, 105, 110, 116, 101, 103, 114,  36, 114, 101, 102,  95, 105,
110, 116, 101, 103, 114,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_fitcmp_crv;
extern SL V_fitcmp_cnp;
extern F V_cshift;
extern SL V_idgw;
extern SL V_idsp;
extern Blk(V_hkl_parm, 112 );
extern Blk(V_pro_parm, 24 );
extern V PAS__f_output;
extern V V_sel_pat;
extern V V_bckgrd_crv;
extern F V_chi2;
extern F V_lchi2;
extern F V_chi2eps;
extern UB V_nerr_flg;
extern UB V_bfitini;
extern UB V_bprocess;
extern V V_zone_first;
extern SL V_nzone;
extern SL V_np;
extern Blk(V_str_msg, 264 );
extern V V_peak_first;
extern SL V_sel_iright;
extern SL V_sel_ileft;
extern SL V_ntotpck;

/* Declaration of global variables. */
UB V_width_free;

/* Function/procedure prototypes. */
V P_new_curve(SL F_nsz, SL F_id, SL F_lco, SL F_mco, SL F_lkn, SL F_mkn, F F_lsz
, F F_msz);
void P_update_curve(V *F_pc, SL F_nsz);
void P_integr_Save_a_pck();
void P_lsq_Init();
SL P_lsq_New_vparm(F *F_prm, F *F_sig, F F_min, F F_max);
SL P_lsq_New_block(F F_dmp, F F_mrq);
void P_lsq_Set_dmp_mrq(SL F_id, F F_dmp, F F_mrq);
void P_lsq_Init_cycle();
void P_lsq_Init_derv();
void P_lsq_Set_derv(SL F_id, F F_drv);
void P_lsq_Set_contr(F F_delta, F F_weight);
UB P_lsq_Process(UB F_bend, UB F_bchg, UB F_bmrq, F F_ch_parm(SL F_i, F F_v_o, F
F_v_n, F F_v_c, F F_v_s, F F_min, F F_max));
void P_lsq_Restore_parm();
F P_lsq_Correl(SL F_ii, SL F_jj);
void P_adjust_peak_pos(V F_pz, UB F_fhkl);
void P_sort_peak();
void PAS__GEN_ERROR_MSG(SL F_ierr);


/* Procedure/Function : " display_fitdot "  */
void RPW_INTPUTE_display_fitdot(F F_x, F F_y){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=71; /* line # 71 */
  if (V_fitcmp_crv==NULL) {
    Ra.sl[3]=73; /* line # 73 */
    V_fitcmp_crv=P_new_curve(240,2,3,0,1,0, (F)2.000000E+00, (F)0.000000E-01);
  }
  Ra.sl[3]=75; /* line # 75 */
  if (V_fitcmp_cnp>=((SL *)V_fitcmp_crv)[0]) P_update_curve(&V_fitcmp_crv, -(((SL
   *)V_fitcmp_crv)[0]+240));
  Ra.sl[3]=77; /* line # 77 */
  Rv0=V_fitcmp_crv;
  Ra.sl[3]=79; /* line # 79 */
  ((F *)Rv0)[PAS__RANGE(2*V_fitcmp_cnp+1,1,2*((SL *)Rv0)[0])+8]=F_x;
  Ra.sl[3]=80; /* line # 80 */
  ((F *)Rv0)[PAS__RANGE(2*V_fitcmp_cnp+2,1,2*((SL *)Rv0)[0])+8]=F_y+V_cshift;
  Ra.sl[3]=81; /* line # 81 */
  V_fitcmp_cnp=V_fitcmp_cnp+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fpck_define "  */
void RPW_INTPUTE_fpck_define(V F_pz, UB F_bpck, F F_dmp, F F_mrq, UB F_bth){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+78;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=122; /* line # 122 */
  Rv0=F_pz;
  Ra.sl[3]=124; /* line # 124 */
  P_lsq_Init();
  Ra.sl[3]=125; /* line # 125 */
  V_idgw=0;
  Ra.sl[3]=126; /* line # 126 */
  V_idsp=0;
  Ra.sl[3]=127; /* line # 127 */
  Rv1=0;
  Ra.sl[3]=129; /* line # 129 */
  if (!F_bpck||V_hkl_parm.sl[19]==2) {
    Ra.sl[3]=130; /* line # 130 */
    Rv2=1;
    for( Rf0=V_hkl_parm.sl[18]+1;Rf0>0;Rf0-- ) {
      Ra.sl[3]=131; /* line # 131 */
      Rv1=P_lsq_New_vparm((((F *)Rv0)+PAS__RANGE(Rv2,1,9)+30),(((F *)Rv0)+PAS__RANGE(
      Rv2,1,9)+39),(F)1.000000E+030, (F)1.000000E+030);
      Rv2++;
    }
  }
  Ra.sl[3]=133; /* line # 133 */
  if (F_bpck) {
    Ra.sl[3]=135; /* line # 135 */
    if (V_hkl_parm.sl[20]>0&&V_hkl_parm.ub[105]) {
      Ra.sl[3]=137; /* line # 137 */
      Rv1=P_lsq_New_vparm(((F *)Rv0)+27,((F *)Rv0)+29,(F)1.000000E+030, (F)1.000000E+030);
      Ra.sl[3]=138; /* line # 138 */
      V_idgw=Rv1;
      Ra.sl[3]=139; /* line # 139 */
      if (V_hkl_parm.sl[20]>1) {
        Ra.sl[3]=140; /* line # 140 */
        Rv1=P_lsq_New_vparm(((F *)Rv0)+28,((F *)Rv0)+30,(F)1.000000E+030, (F)1.000000E+030);
      }
    }
    Ra.sl[3]=143; /* line # 143 */
    if (V_hkl_parm.sl[21]==1&&V_hkl_parm.ub[107]) {
      Ra.sl[3]=145; /* line # 145 */
      Rv1=P_lsq_New_vparm(((F *)Rv0)+23,((F *)Rv0)+25,(F)0.000000E-01, (F)1.000000E+00);
      Ra.sl[3]=146; /* line # 146 */
      V_idsp=Rv1;
    }
    Ra.sl[3]=150; /* line # 150 */
    Rv3=((V *)Rv0)[1];
    Ra.sl[3]=151; /* line # 151 */
    while (Rv3!=NULL){
      Ra.sl[3]=152; /* line # 152 */
      Rv4=Rv3;
      Ra.sl[3]=154; /* line # 154 */
      ((SL *)Rv4)[3]=0;
      Ra.sl[3]=155; /* line # 155 */
      ((SL *)Rv4)[4]=0;
      Ra.sl[3]=156; /* line # 156 */
      ((SL *)Rv4)[6]=0;
      Ra.sl[3]=157; /* line # 157 */
      ((SL *)Rv4)[7]=0;
      Ra.sl[3]=158; /* line # 158 */
      ((SL *)Rv4)[5]=0;
      Ra.sl[3]=160; /* line # 160 */
      if (F_bth&&V_hkl_parm.ub[104]) {
        Ra.sl[3]=161; /* line # 161 */
        ((SL *)Rv4)[3]=P_lsq_New_vparm(((F *)Rv4)+11,((F *)Rv4)+12,((F *)Rv0)[14]
        ,((F *)Rv0)[15]);
      }
      Ra.sl[3]=163; /* line # 163 */
      if (V_hkl_parm.ub[106]) {
        Ra.sl[3]=164; /* line # 164 */
        ((SL *)Rv4)[4]=P_lsq_New_vparm(((F *)Rv4)+13,((F *)Rv4)+14,(F)0.000000E-01,
        (F)1.000000E+030);
      }
      Ra.sl[3]=166; /* line # 166 */
      if (V_hkl_parm.ub[105]) {
        Ra.sl[3]=167; /* line # 167 */
        if (V_hkl_parm.sl[20]<=0) ((SL *)Rv4)[5]=P_lsq_New_vparm(((F *)Rv4)+15,(
        (F *)Rv4)+16,(F)1.000000E+030, (F)1.000000E+030);
        else {
          Ra.sl[3]=168; /* line # 168 */
          ((SL *)Rv4)[5]=V_idgw+1;
        }
      }
      Ra.sl[3]=169; /* line # 169 */
      if (V_hkl_parm.ub[107]) {
        Ra.sl[3]=170; /* line # 170 */
        switch (((UB *)Rv4)[84]) {
          case 2:Ra.sl[3]=172; /* line # 172 */
          if (V_hkl_parm.sl[21]<=0) ((SL *)Rv4)[6]=P_lsq_New_vparm(((F *)Rv4)+17,(
          (F *)Rv4)+18,(F)0.000000E-01, (F)1.000000E+00);
          else {
            Ra.sl[3]=173; /* line # 173 */
            ((SL *)Rv4)[6]=V_idsp;
          }
          break;
          default:break;
        }
      }
      Ra.sl[3]=177; /* line # 177 */
      Rv3=((V *)Rv4)[0];
    }
  }
  Ra.sl[3]=180; /* line # 180 */
  P_lsq_New_block(F_dmp, F_mrq);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " chpck_coef "  */
F RPW_INTPUTE_PRC_00000000(SL F_i, F F_v_o, F F_v_n, F F_v_c, F F_v_s, F F_min, 
F F_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register F Ret;

  /* Code of procedure/function */
  Rv0=1;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+91;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=209; /* line # 209 */
  if (F_v_n<F_min) F_v_n=F_min;
  else {
    Ra.sl[3]=210; /* line # 210 */
    if (F_v_n>F_max) F_v_n=F_max;
    else {
      Ra.sl[3]=211; /* line # 211 */
      Rv0=0;
    }
  }
  Ra.sl[3]=214; /* line # 214 */
  if (V_pro_parm.ub[21]) {
    Ra.sl[3]=216; /* line # 216 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+103,-1,-1,32);
    PAS__WRITE_INT(F_i,3,0);
    PAS__WRITE_STR(Rd.s+110,-1,-1,32);
    PAS__WRITE_SNGL(F_v_n,16,-6,0);
    PAS__WRITE_STR(Rd.s+121,-1,-1,32);
    PAS__WRITE_SNGL(F_v_s,16,-6,0);
    PAS__WRITE_STR(Rd.s+130,-1,-1,32);
    PAS__WRITE_SNGL(F_v_o,16,-6,0);
    PAS__WRITE_STR(Rd.s+140,-1,-1,32);
    PAS__WRITE_SNGL(F_v_c,16,-6,0);
    Ra.sl[3]=217; /* line # 217 */
    if (Rv0) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+153,-1,-1,32);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[3]=218; /* line # 218 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
  }
  Ra.sl[3]=220; /* line # 220 */
  Ret=F_v_n;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ref_dcompute "  */
F RPW_INTPUTE_PRC_00000001(V F_pk, F F_th){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  register F Rgf;
  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+158;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=231; /* line # 231 */
  Rv0=F_pk;
  Ra.sl[3]=233; /* line # 233 */
  Rv1=F_th-((F *)Rv0)[11];
  Ra.sl[3]=234; /* line # 234 */
  if (((F *)Rv0)[15]<(F)1.000000E-05) ((F *)Rv0)[15]=(F)1.000000E-05;
  Ra.sl[3]=235; /* line # 235 */
  switch (((UB *)Rv0)[84]) {
    case 0:Ra.sl[3]=238; /* line # 238 */
    Rv2=((F *)Rv0)[15]*(F)1.201122E+00;
    Ra.sl[3]=239; /* line # 239 */
    Rv3=PAS__F_SQR(Rv1/Rv2);
    Ra.sl[3]=240; /* line # 240 */
    ((F *)Rv0)[14]=exp( -Rv3);
    Ra.sl[3]=241; /* line # 241 */
    Rv4=((F *)Rv0)[13]*((F *)Rv0)[14];
    Ra.sl[3]=242; /* line # 242 */
    ((F *)Rv0)[12]=((F)2.000000E+00*(Rv1/(Rv2*Rv2)))*Rv4;
    Ra.sl[3]=243; /* line # 243 */
    ((F *)Rv0)[16]=((F)2.000000E+00*(Rv3/((F *)Rv0)[15]))*Rv4;
    break;
    case 1:Ra.sl[3]=248; /* line # 248 */
    ((F *)Rv0)[14]=(F)1.000000E+00/((F)1.000000E+00+PAS__F_SQR(Rv1/((F *)Rv0)[15]
    ));
    Ra.sl[3]=249; /* line # 249 */
    Rv4=((F *)Rv0)[13]*((F *)Rv0)[14];
    Ra.sl[3]=250; /* line # 250 */
    ((F *)Rv0)[12]=(((F)2.000000E+00*Rv1)*((F *)Rv0)[13])*PAS__F_SQR(((F *)Rv0)[
14]/((F *)Rv0)[15]);
    Ra.sl[3]=251; /* line # 251 */
    ((F *)Rv0)[16]=((F *)Rv0)[12]/((F *)Rv0)[15];
    break;
    case 2:Ra.sl[3]=256; /* line # 256 */
    Rv2=((F *)Rv0)[15]*(F)1.201122E+00;
    Ra.sl[3]=257; /* line # 257 */
    Rv3=exp( -PAS__F_SQR(Rv1/Rv2));
    Ra.sl[3]=258; /* line # 258 */
    Rv5=(F)1.000000E+00/((F)1.000000E+00+PAS__F_SQR(Rv1/((F *)Rv0)[15]));
    Ra.sl[3]=259; /* line # 259 */
    ((F *)Rv0)[14]=((F)1.000000E+00-((F *)Rv0)[17])*Rv3+((F *)Rv0)[17]*Rv5;
    Ra.sl[3]=260; /* line # 260 */
    Rv4=((F *)Rv0)[13]*((F *)Rv0)[14];
    Ra.sl[3]=261; /* line # 261 */
    ((F *)Rv0)[18]=((F *)Rv0)[13]*(Rv5-Rv3);
    Ra.sl[3]=262; /* line # 262 */
    ((F *)Rv0)[12]=((F)2.000000E+00*((F *)Rv0)[13])*(((Rv1/(Rv2*Rv2))*((F)1.000000E+00-
    ((F *)Rv0)[17]))*Rv3+((F *)Rv0)[17]*PAS__F_SQR(Rv5/((F *)Rv0)[15]));
    Ra.sl[3]=263; /* line # 263 */
    ((F *)Rv0)[16]=((F *)Rv0)[12]/((F *)Rv0)[15];
    break;
    default:break;
  }
  Ra.sl[3]=269; /* line # 269 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fpck_cycle "  */
void RPW_INTPUTE_fpck_cycle(V F_pz, UB F_bnd, UB F_bpck, SL *F_nobs, UB *F_bchg)
{
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  F Rv5;
  SL Rv6;
  SL Rv7;
  register V Rv8;
  SL Rv9;
  F Rv10;
  F Rv11;
  F Rv12;
  F Rv13;
  SL Rv14;
  SL Rv15;
  F Rv16;
  V Rv17;
  register V Rv18;
  F Rv19;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+172;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=275; /* line # 275 */
  if (F_bnd) P_lsq_Set_dmp_mrq(1, (F)1.000000E+00, (F)1.000000E+00);
  Ra.sl[3]=276; /* line # 276 */
  P_lsq_Init_cycle();
  Ra.sl[3]=277; /* line # 277 */
  Rv0=F_pz;
  Rv1=V_sel_pat;
  Rv2=V_bckgrd_crv;
  Ra.sl[3]=279; /* line # 279 */
  if (V_hkl_parm.sl[19]==0&&F_bpck) {
    Ra.sl[3]=281; /* line # 281 */
    Rv3=2*((SL *)Rv2)[0];
    Ra.sl[3]=282; /* line # 282 */
    Rv4=4;
    Ra.sl[3]=283; /* line # 283 */
    Ra.f[4]=((F *)Rv2)[PAS__RANGE(Rv4-3,1,2*((SL *)Rv2)[0])+8];
    Ra.f[6]=((F *)Rv2)[PAS__RANGE(Rv4-2,1,2*((SL *)Rv2)[0])+8]-V_cshift;
    Ra.sl[3]=284; /* line # 284 */
    Ra.f[5]=((F *)Rv2)[PAS__RANGE(Rv4-1,1,2*((SL *)Rv2)[0])+8];
    Ra.f[7]=((F *)Rv2)[PAS__RANGE(Rv4,1,2*((SL *)Rv2)[0])+8]-V_cshift;
    Ra.sl[3]=285; /* line # 285 */
    ((F *)Rv0)[32]=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
    Ra.sl[3]=286; /* line # 286 */
    ((F *)Rv0)[31]=Ra.f[7]-((F *)Rv0)[32]*Ra.f[5];
  }
  Ra.sl[3]=288; /* line # 288 */
  Rv5=(((F *)Rv1)[PAS__RANGE(((SL *)Rv0)[8],1,((SL *)Rv1)[0])*4+81]+((F *)Rv1)[PAS__RANGE((
  (SL *)Rv0)[9],1,((SL *)Rv1)[0])*4+81])*(F)5.000000E-01;
  Ra.sl[3]=290; /* line # 290 */
  Rv6=0;
  Ra.sl[3]=291; /* line # 291 */
  Rv7=((SL *)Rv0)[8];
  while (1){
    Ra.sl[3]=293; /* line # 293 */
    Rv8=(((S *)Rv1)+PAS__RANGE(Rv7,1,((SL *)Rv1)[0])*16+324);
    Ra.sl[3]=294; /* line # 294 */
    if (!(128&((UB *)Rv8)[14])) {
      Ra.sl[3]=296; /* line # 296 */
      P_lsq_Init_derv();
      Ra.sl[3]=298; /* line # 298 */
      if (F_bpck) Rv9=V_hkl_parm.sl[19];
      else {
        Ra.sl[3]=299; /* line # 299 */
        Rv9=2;
      }
      Ra.sl[3]=300; /* line # 300 */
      switch (Rv9) {
        case 1:Ra.sl[3]=302; /* line # 302 */
        Rv12=((F *)Rv8)[0]-Rv5;
        Rv13=Rv12;
        Ra.sl[3]=303; /* line # 303 */
        Rv11=((F *)Rv0)[31];
        Rv10=PAS__F_SQR(((F *)Rv0)[40]);
        Ra.sl[3]=304; /* line # 304 */
        Rv14=2;
        for( Rf0=(V_hkl_parm.sl[18]+1)-1;Rf0>0;Rf0-- ) {
          Ra.sl[3]=306; /* line # 306 */
          Rv11=Rv11+((F *)Rv0)[PAS__RANGE(Rv14,1,9)+30]*Rv13;
          Rv13=Rv13*Rv12;
          Ra.sl[3]=307; /* line # 307 */
          Rv10=Rv10+PAS__F_SQR(((F *)Rv0)[PAS__RANGE(Rv14,1,9)+39]*Rv13);
          Rv14++;
        }
        break;
        case 2:Ra.sl[3]=312; /* line # 312 */
        Rv12=((F *)Rv8)[0]-Rv5;
        Ra.sl[3]=313; /* line # 313 */
        Rv11=(F)0.000000E-01;
        Rv13=(F)1.000000E+00;
        Ra.sl[3]=314; /* line # 314 */
        Rv15=1;
        for( Rf0=V_hkl_parm.sl[18]+1;Rf0>0;Rf0-- ) {
          Ra.sl[3]=316; /* line # 316 */
          Rv11=Rv11+((F *)Rv0)[PAS__RANGE(Rv15,1,9)+30]*Rv13;
          Ra.sl[3]=317; /* line # 317 */
          P_lsq_Set_derv(Rv15, Rv13);
          Ra.sl[3]=318; /* line # 318 */
          Rv13=Rv13*Rv12;
          Rv15++;
        }
        Ra.sl[3]=320; /* line # 320 */
        Rv10=(F)0.000000E-01;
        break;
        default:Ra.sl[3]=324; /* line # 324 */
        if (Rv4<Rv3-2) {
          Ra.sl[3]=326; /* line # 326 */
          while ((Rv4<Rv3-2&&Rv4>2)&&((F *)Rv2)[PAS__RANGE(Rv4-1,1,2*((SL *)Rv2)
          [0])+8]<=((F *)Rv8)[0])
          Rv4=Rv4+2;
          Ra.sl[3]=327; /* line # 327 */
          Ra.f[4]=((F *)Rv2)[PAS__RANGE(Rv4-3,1,2*((SL *)Rv2)[0])+8];
          Ra.f[6]=((F *)Rv2)[PAS__RANGE(Rv4-2,1,2*((SL *)Rv2)[0])+8]-V_cshift;
          Ra.sl[3]=328; /* line # 328 */
          Ra.f[5]=((F *)Rv2)[PAS__RANGE(Rv4-1,1,2*((SL *)Rv2)[0])+8];
          Ra.f[7]=((F *)Rv2)[PAS__RANGE(Rv4,1,2*((SL *)Rv2)[0])+8]-V_cshift;
          Ra.sl[3]=329; /* line # 329 */
          ((F *)Rv0)[32]=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
          Ra.sl[3]=330; /* line # 330 */
          ((F *)Rv0)[31]=Ra.f[7]-((F *)Rv0)[32]*Ra.f[5];
          Ra.sl[3]=331; /* line # 331 */
          Rv10=(PAS__F_SQR(((F *)Rv1)[PAS__RANGE(((SL *)Rv0)[8],1,((SL *)Rv1)[0]
          )*4+83])+PAS__F_SQR(((F *)Rv1)[PAS__RANGE(((SL *)Rv0)[9],1,((SL *)Rv1)
          [0])*4+83]))*(F)5.000000E-01;
          Ra.sl[3]=332; /* line # 332 */
          Rv11=((F *)Rv0)[31]+((F *)Rv0)[32]*((F *)Rv8)[0];
        }
        break;
      }
      Ra.sl[3]=336; /* line # 336 */
      Rv16=Rv11;
      Ra.sl[3]=338; /* line # 338 */
      if (F_bpck) {
        Ra.sl[3]=340; /* line # 340 */
        Rv17=((V *)Rv0)[1];
        Ra.sl[3]=341; /* line # 341 */
        while (Rv17!=NULL){
          Ra.sl[3]=342; /* line # 342 */
          Rv18=Rv17;
          Ra.sl[3]=344; /* line # 344 */
          if (V_hkl_parm.sl[20]>0) {
            Ra.sl[3]=346; /* line # 346 */
            Rv19=tan((F)8.726646E-03*((F *)Rv18)[11]);
            Ra.sl[3]=347; /* line # 347 */
            ((F *)Rv18)[15]=((F *)Rv0)[27]+((F *)Rv0)[28]*Rv19;
          }
          Ra.sl[3]=349; /* line # 349 */
          if (V_hkl_parm.sl[21]>0) ((F *)Rv18)[17]=((F *)Rv0)[23];
          Ra.sl[3]=351; /* line # 351 */
          Rv16=Rv16+RPW_INTPUTE_PRC_00000001(Rv17,((F *)Rv8)[0]);
          Ra.sl[3]=357; /* line # 357 */
          if (((SL *)Rv18)[3]>0) P_lsq_Set_derv(((SL *)Rv18)[3],((F *)Rv18)[12]);
          Ra.sl[3]=358; /* line # 358 */
          if (((SL *)Rv18)[4]>0) P_lsq_Set_derv(((SL *)Rv18)[4],((F *)Rv18)[14]);
          Ra.sl[3]=360; /* line # 360 */
          if (V_hkl_parm.sl[20]<=0) {
            Ra.sl[3]=362; /* line # 362 */
            if (((SL *)Rv18)[5]>0) P_lsq_Set_derv(((SL *)Rv18)[5],((F *)Rv18)[16]
            );
          }
          else {
            Ra.sl[3]=366; /* line # 366 */
            P_lsq_Set_derv(V_idgw,((F *)Rv18)[16]);
            Ra.sl[3]=367; /* line # 367 */
            if (V_hkl_parm.sl[20]>1) P_lsq_Set_derv(V_idgw+1,((F *)Rv18)[16]*Rv19);
          }
          Ra.sl[3]=371; /* line # 371 */
          if (((SL *)Rv18)[6]>0) P_lsq_Set_derv(((SL *)Rv18)[6],((F *)Rv18)[18]);
          Ra.sl[3]=373; /* line # 373 */
          Rv17=((V *)Rv18)[0];
        }
      }
      Ra.sl[3]=378; /* line # 378 */
      if (((F *)Rv8)[2]<(F)1.000000E-04) Rv10=sqrt(fabs(((F *)Rv8)[1]));
      else {
        Ra.sl[3]=379; /* line # 379 */
        Rv10=((F *)Rv8)[2];
      }
      Ra.sl[3]=380; /* line # 380 */
      if (Rv10<(F)1.000000E-04) Rv10=(F)1.000000E-04;
      Ra.sl[3]=381; /* line # 381 */
      P_lsq_Set_contr(((F *)Rv8)[1]-Rv16, (F)1.000000E+00/Rv10);
      Ra.sl[3]=386; /* line # 386 */
      if ((F_bnd&&F_bpck)&&V_pro_parm.ub[16]) RPW_INTPUTE_display_fitdot(((F *)Rv8)
      [0],Rv16);
      Ra.sl[3]=388; /* line # 388 */
      Rv6=Rv6+1;
    }
    Ra.sl[3]=391; /* line # 391 */
    Rv7=Rv7+1;
    Ra.sl[3]=392; /* line # 392 */
    if (!F_bpck) {
      Ra.sl[3]=393; /* line # 393 */
      if (Rv7==((SL *)Rv0)[8]+((SL *)Rv0)[6]) Rv7=(((SL *)Rv0)[9]-((SL *)Rv0)[7]
      )+1;
    }
    if (Rv7>((SL *)Rv0)[9])  break;
  }
  Ra.sl[3]=396; /* line # 396 */
  (*F_bchg)=P_lsq_Process(F_bnd,!F_bnd, F_bpck, RPW_INTPUTE_PRC_00000000);
  Ra.sl[3]=397; /* line # 397 */
  (*F_nobs)=Rv6;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fpck_mrqfit "  */
void RPW_INTPUTE_fpck_mrqfit(V F_pz, UB F_bend){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  F Rv1;
  F Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  F Rv6;
  SL Rv7;
  UB Rv8;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+184;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=417; /* line # 417 */
  Ra.sl[3]=419; /* line # 419 */
  Rv0=1;
  Ra.sl[3]=420; /* line # 420 */
  Rv1=(F)1.000000E+00;
  Ra.sl[3]=421; /* line # 421 */
  Rv2=(F)5.000000E-01;
  Ra.sl[3]=422; /* line # 422 */
  Rv3=0;
  Rv4=0;
  Rv5=0;
  while (1){
    Ra.sl[3]=424; /* line # 424 */
    Rv3=Rv3+1;
    Ra.sl[3]=425; /* line # 425 */
    Rv6=Rv2;
    Ra.sl[3]=426; /* line # 426 */
    Rv2=(F)1.000000E+00/((F)1.000000E+00+Rv1);
    Ra.sl[3]=427; /* line # 427 */
    P_lsq_Set_dmp_mrq(1, Rv2, Rv2);
    Ra.sl[3]=428; /* line # 428 */
    if (V_pro_parm.ub[21]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+197,-1,-1,32);
      PAS__WRITE_INT(Rv3,3,0);
      PAS__WRITE_STR(Rd.s+214,-1,-1,32);
      PAS__WRITE_SNGL(Rv2,8,4,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=429; /* line # 429 */
    RPW_INTPUTE_fpck_cycle(F_pz,0,1, &Rv7, &Rv8);
    Ra.sl[3]=430; /* line # 430 */
    if (!Rv8) {
      Ra.sl[3]=432; /* line # 432 */
      Rv5=Rv5+1;
      Ra.sl[3]=433; /* line # 433 */
      Rv1=Rv1*(F)1.000000E+01;
      Ra.sl[3]=437; /* line # 437 */
      if (V_pro_parm.ub[21]) {
        Ra.sl[3]=438; /* line # 438 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+228,-1,-1,32);
        PAS__WRITE_INT(Rv3,3,0);
        PAS__WRITE_STR(Rd.s+239,-1,-1,32);
        PAS__WRITE_SNGL(V_chi2,10,2,0);
        PAS__WRITE_STR(Rd.s+279,-1,-1,32);
        PAS__WRITE_EOLN();
      }
      Ra.sl[3]=439; /* line # 439 */
      P_lsq_Restore_parm();
      Ra.sl[3]=440; /* line # 440 */
      RPW_INTPUTE_fpck_cycle(F_pz,0,1, &Rv7, &Rv8);
      Ra.sl[3]=441; /* line # 441 */
      Rv4=0;
      Rv0=0;
    }
    else {
      Ra.sl[3]=445; /* line # 445 */
      if (fabs(V_lchi2-V_chi2)<=V_chi2eps) Rv4=Rv4+1;
      else {
        Ra.sl[3]=446; /* line # 446 */
        Rv4=0;
      }
      Ra.sl[3]=447; /* line # 447 */
      if (Rv0) Rv1=Rv1/(F)1.000000E+01;
      Ra.sl[3]=451; /* line # 451 */
      Rv5=0;
      Ra.sl[3]=452; /* line # 452 */
      if (V_pro_parm.ub[21]) {
        Ra.sl[3]=453; /* line # 453 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+283,-1,-1,32);
        PAS__WRITE_INT(Rv3,3,0);
        PAS__WRITE_STR(Rd.s+294,-1,-1,32);
        PAS__WRITE_SNGL(Rv2,8,4,0);
        PAS__WRITE_STR(Rd.s+308,-1,-1,32);
        PAS__WRITE_SNGL(V_chi2,10,2,0);
        PAS__WRITE_EOLN();
      }
      Ra.sl[3]=454; /* line # 454 */
      Rv0=1;
    }
    if (Rv3>=V_pro_parm.sl[2]||Rv4>1)  break;
  }
  Ra.sl[3]=461; /* line # 461 */
  P_lsq_Set_dmp_mrq(1, (F)1.000000E+00, (F)1.000000E+00);
  Ra.sl[3]=462; /* line # 462 */
  if (F_bend) RPW_INTPUTE_fpck_cycle(F_pz,1,1, &Rv7, &Rv8);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " num_error_hdl "  */
SL RPW_INTPUTE_PRC_00000002(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+320;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=488; /* line # 488 */
  if (F_ierr>=20&&F_ierr<=29) {
    Ra.sl[3]=490; /* line # 490 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=491; /* line # 491 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+335,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=492; /* line # 492 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=493; /* line # 493 */
    PAS__GEN_ERROR_MSG(F_ierr);
    Ra.sl[3]=494; /* line # 494 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=495; /* line # 495 */
    V_nerr_flg=1;
    Ra.sl[3]=497; /* line # 497 */
    longjmp((void *)Lx[0].v[4],1);
  }
  Ra.sl[3]=499; /* line # 499 */
  Ret=-1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ref_icompute "  */
void RPW_INTPUTE_PRC_00000003(V F_pk){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  F Rv1;
  F Rv2;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+398;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=517; /* line # 517 */
  Rv0=F_pk;
  Ra.sl[3]=519; /* line # 519 */
  switch (((UB *)Rv0)[84]) {
    case 0:Ra.sl[3]=522; /* line # 522 */
    ((F *)Rv0)[19]=((F)2.128934E+00*((F *)Rv0)[13])*((F *)Rv0)[15];
    Ra.sl[3]=523; /* line # 523 */
    if (((F *)Rv0)[14]>=(F)0.000000E-01&&((F *)Rv0)[16]>=(F)0.000000E-01) {
      Ra.sl[3]=524; /* line # 524 */
      ((F *)Rv0)[20]=(F)2.128934E+00*sqrt((PAS__F_SQR(((F *)Rv0)[14]*((F *)Rv0)[
15])+PAS__F_SQR(((F *)Rv0)[16]*((F *)Rv0)[13]))+(((((F *)Rv0)[14]*((F *)Rv0)[16]
      )*((F *)Rv0)[13])*((F *)Rv0)[15])*P_lsq_Correl(((SL *)Rv0)[4],((SL *)Rv0)[
5]));
    }
    else {
      Ra.sl[3]=526; /* line # 526 */
      ((F *)Rv0)[20]=(F)-1.000000E+00;
    }
    break;
    case 1:Ra.sl[3]=531; /* line # 531 */
    ((F *)Rv0)[19]=((F)3.141593E+00*((F *)Rv0)[13])*((F *)Rv0)[15];
    Ra.sl[3]=532; /* line # 532 */
    if (((F *)Rv0)[14]>=(F)0.000000E-01&&((F *)Rv0)[16]>=(F)0.000000E-01) {
      Ra.sl[3]=533; /* line # 533 */
      ((F *)Rv0)[20]=(F)3.141593E+00*sqrt((PAS__F_SQR(((F *)Rv0)[14]*((F *)Rv0)[
15])+PAS__F_SQR(((F *)Rv0)[16]*((F *)Rv0)[13]))+(((((F *)Rv0)[14]*((F *)Rv0)[16]
      )*((F *)Rv0)[13])*((F *)Rv0)[15])*P_lsq_Correl(((SL *)Rv0)[4],((SL *)Rv0)[
5]));
    }
    else {
      Ra.sl[3]=535; /* line # 535 */
      ((F *)Rv0)[20]=(F)-1.000000E+00;
    }
    break;
    case 2:Ra.sl[3]=540; /* line # 540 */
    ((F *)Rv0)[19]=((((F *)Rv0)[17]*(F)2.128934E+00+(F)3.141593E+00*((F)1.000000E+00-
    ((F *)Rv0)[17]))*((F *)Rv0)[13])*((F *)Rv0)[15];
    Ra.sl[3]=541; /* line # 541 */
    if ((((F *)Rv0)[14]>=(F)0.000000E-01&&((F *)Rv0)[16]>=(F)0.000000E-01)&&((F *)
    Rv0)[18]>=(F)0.000000E-01) {
      Ra.sl[3]=543; /* line # 543 */
      Rv1=((F)1.000000E+00-((F *)Rv0)[17])*(F)2.128934E+00+((F *)Rv0)[17]*(F)3.141593E+00;
      Ra.sl[3]=544; /* line # 544 */
      Rv2=Rv1*(F)-1.012659E+00;
      Ra.sl[3]=545; /* line # 545 */
      ((F *)Rv0)[20]=sqrt(((((PAS__F_SQR(((((F *)Rv0)[18]*(F)-1.012659E+00)*((F *)
      Rv0)[13])*((F *)Rv0)[15])+PAS__F_SQR((((F *)Rv0)[14]*Rv1)*((F *)Rv0)[15]))
      +PAS__F_SQR((((F *)Rv0)[16]*Rv1)*((F *)Rv0)[13]))+(((((Rv1*Rv1)*((F *)Rv0)
      [13])*((F *)Rv0)[15])*((F *)Rv0)[14])*((F *)Rv0)[16])*P_lsq_Correl(((SL *)
      Rv0)[4],((SL *)Rv0)[5]))+((((Rv2*((F *)Rv0)[13])*PAS__F_SQR(((F *)Rv0)[15]
      ))*((F *)Rv0)[18])*((F *)Rv0)[14])*P_lsq_Correl(((SL *)Rv0)[4],((SL *)Rv0)
      [6]))+((((Rv2*PAS__F_SQR(((F *)Rv0)[13]))*((F *)Rv0)[15])*((F *)Rv0)[18])*
      ((F *)Rv0)[16])*P_lsq_Correl(((SL *)Rv0)[5],((SL *)Rv0)[6]));
    }
    else {
      Ra.sl[3]=551; /* line # 551 */
      ((F *)Rv0)[20]=(F)-1.000000E+00;
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fit_packet "  */
void RPW_INTPUTE_fit_packet(V F_pz){
  jmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 20 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register F Rgf;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[4]=(V)L_lb_env;
  if (setjmp(L_lb_env )) goto L_l_0;

  Rv0=(F)1.000000E+00;
  Rv1=(F)1.000000E+00;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+412;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=562; /* line # 562 */
  PAS__ESTABLISH(RPW_INTPUTE_PRC_00000002);
  Ra.sl[3]=563; /* line # 563 */
  if (F_pz!=NULL) {
    Ra.sl[3]=564; /* line # 564 */
    Rv2=F_pz;
    Ra.sl[3]=567; /* line # 567 */
    if (V_bfitini) {
      Ra.sl[3]=569; /* line # 569 */
      RPW_INTPUTE_fpck_define(F_pz,1, Rv0, Rv1,0);
      Ra.sl[3]=570; /* line # 570 */
      RPW_INTPUTE_fpck_mrqfit(F_pz,0);
      Ra.sl[3]=571; /* line # 571 */
      P_integr_Save_a_pck();
    }
    Ra.sl[3]=574; /* line # 574 */
    RPW_INTPUTE_fpck_define(F_pz,1, Rv0, Rv1,1);
    Ra.sl[3]=575; /* line # 575 */
    RPW_INTPUTE_fpck_mrqfit(F_pz,1);
    Ra.sl[3]=577; /* line # 577 */
    if (!V_bprocess) P_adjust_peak_pos(F_pz,0);
    Ra.sl[3]=579; /* line # 579 */
    ((F *)Rv2)[17]=V_chi2;
    Ra.sl[3]=580; /* line # 580 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+424,-1,-1,32);
    PAS__WRITE_SNGL(V_chi2,10,4,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=581; /* line # 581 */
    Rv3=((V *)Rv2)[1];
    Ra.sl[3]=582; /* line # 582 */
    while (Rv3!=NULL){
      Ra.sl[3]=583; /* line # 583 */
      Rv4=Rv3;
      Ra.sl[3]=585; /* line # 585 */
      RPW_INTPUTE_PRC_00000003(Rv3);
      Ra.sl[3]=586; /* line # 586 */
      if (V_pro_parm.ub[21]) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+452,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv4)[15],8,3,0);
        PAS__WRITE_STR(Rd.s+480,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv2)[18],8,3,0);
        PAS__WRITE_EOLN();
      }
      Ra.sl[3]=587; /* line # 587 */
      if (V_hkl_parm.sl[19]<2&&((F *)Rv4)[20]>=(F)0.000000E-01) ((F *)Rv4)[20]=sqrt
      (PAS__F_SQR(((F *)Rv4)[20])+PAS__F_SQR((((F *)Rv2)[20]*((F *)Rv4)[15])/((F
       *)Rv2)[18]));
      Ra.sl[3]=589; /* line # 589 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+485,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv4)[11],8,3,0);
      PAS__WRITE_CHAR(58);
      PAS__WRITE_SNGL(((F *)Rv4)[12],8,3,0);
      PAS__WRITE_STR(Rd.s+500,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv4)[19],10,2,0);
      PAS__WRITE_CHAR(58);
      PAS__WRITE_SNGL(((F *)Rv4)[20],10,2,0);
      PAS__WRITE_STR(Rd.s+508,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv4)[13],10,1,0);
      PAS__WRITE_CHAR(58);
      PAS__WRITE_SNGL(((F *)Rv4)[14],9,1,0);
      PAS__WRITE_STR(Rd.s+516,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv4)[15],8,3,0);
      PAS__WRITE_CHAR(58);
      PAS__WRITE_SNGL(((F *)Rv4)[16],8,3,0);
      PAS__WRITE_EOLN();
      Ra.sl[3]=592; /* line # 592 */
      Rv3=((V *)Rv4)[0];
    }
    Ra.sl[3]=594; /* line # 594 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=595; /* line # 595 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
  }
  PAS__curr_cntx=Ra.s;
L_l_0:
  Ra.sl[3]=599; /* line # 599 */
  PAS__REVERT();
  PAS__curr_cntx=Ra.v[0];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " integr_packet "  */
void RPW_INTPUTE_integr_packet(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  F Rv8;
  F Rv9;
  F Rv10;
  F Rv11;
  SL Rv12;
  SL Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  SL Rv17;
  SL Rv18;
  UB Rv19;
  F Rv20;
  F Rv21;
  F Rv22;
  SL Rv23;
  F Rv24;
  F Rv25;
  SL Rv26;
  F Rv27;
  SL Rv28;
  F Rv29;
  F Rv30;
  F Rv31;
  F Rv32;
  SL Rv33;
  register V Rv34;
  F Rv35;
  SL Rv36;
  register V Rv37;
  register V Rv38;
  register F Rgf;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+524;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=625; /* line # 625 */
  Rv0=V_sel_pat;
  Rv1=V_bckgrd_crv;
  Ra.sl[3]=627; /* line # 627 */
  V_width_free=(V_hkl_parm.ub[99]||V_hkl_parm.ub[100])||V_hkl_parm.ub[101];
  Ra.sl[3]=628; /* line # 628 */
  Rv2=0;
  Ra.sl[3]=629; /* line # 629 */
  Rv3=V_zone_first;
  Ra.sl[3]=630; /* line # 630 */
  while (Rv3!=NULL&&Rv2<V_nzone){
    Ra.sl[3]=631; /* line # 631 */
    Rv4=Rv3;
    Ra.sl[3]=633; /* line # 633 */
    Rv2=Rv2+1;
    Ra.sl[3]=634; /* line # 634 */
    Rv5=((V *)Rv4)[1];
    Ra.sl[3]=635; /* line # 635 */
    Rv6=((SL *)Rv4)[8]+((SL *)Rv4)[6];
    Rv7=((SL *)Rv4)[9]-((SL *)Rv4)[7];
    Ra.sl[3]=636; /* line # 636 */
    Rv8=((F *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*4+81];
    Rv9=((F *)Rv0)[PAS__RANGE(Rv7,1,((SL *)Rv0)[0])*4+81];
    Ra.sl[3]=637; /* line # 637 */
    Rv10=(Rv9+Rv8)/(F)2.000000E+00;
    Ra.sl[3]=638; /* line # 638 */
    Rv8=Rv8-Rv10;
    Rv9=Rv9-Rv10;
    Ra.sl[3]=639; /* line # 639 */
    Rv11=Rv9-Rv8;
    Ra.sl[3]=640; /* line # 640 */
    ((F *)Rv4)[18]=Rv11;
    Ra.sl[3]=641; /* line # 641 */
    if (V_hkl_parm.sl[19]==0||V_hkl_parm.sl[18]<0) {
      Ra.sl[3]=643; /* line # 643 */
      Rv12=2*((SL *)Rv1)[0];
      Ra.sl[3]=644; /* line # 644 */
      Rv13=4;
      Ra.sl[3]=646; /* line # 646 */
      while (Rv13<Rv12&&((F *)Rv1)[PAS__RANGE(Rv13-1,1,2*((SL *)Rv1)[0])+8]<=((F
       *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*4+81])
      Rv13=Rv13+2;
      Ra.sl[3]=647; /* line # 647 */
      Ra.f[4]=((F *)Rv1)[PAS__RANGE(Rv13-3,1,2*((SL *)Rv1)[0])+8];
      Ra.f[6]=((F *)Rv1)[PAS__RANGE(Rv13-2,1,2*((SL *)Rv1)[0])+8]-V_cshift;
      Ra.sl[3]=648; /* line # 648 */
      Ra.f[5]=((F *)Rv1)[PAS__RANGE(Rv13-1,1,2*((SL *)Rv1)[0])+8];
      Ra.f[7]=((F *)Rv1)[PAS__RANGE(Rv13,1,2*((SL *)Rv1)[0])+8]-V_cshift;
      Ra.sl[3]=649; /* line # 649 */
      ((F *)Rv4)[32]=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
      Ra.sl[3]=650; /* line # 650 */
      ((F *)Rv4)[31]=Ra.f[7]-((F *)Rv4)[32]*Ra.f[5];
      Ra.sl[3]=651; /* line # 651 */
      Rv14=(PAS__F_SQR(((F *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*4+83])+PAS__F_SQR
      (((F *)Rv0)[PAS__RANGE(Rv7,1,((SL *)Rv0)[0])*4+83]))*(F)5.000000E-01;
      Ra.sl[3]=652; /* line # 652 */
      Rv15=((F *)Rv4)[31]+((F *)Rv4)[32]*((F *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)
      [0])*4+81];
      Ra.sl[3]=653; /* line # 653 */
      Rv16=(F)0.000000E-01;
    }
    else {
      Ra.sl[3]=657; /* line # 657 */
      Rv17=1;
      for( Rf1=V_hkl_parm.sl[18]+1;Rf1>0;Rf1-- ) {
        Ra.sl[3]=658; /* line # 658 */
        ((F *)Rv4)[PAS__RANGE(Rv17,1,9)+30]=(F)0.000000E-01;
        ((F *)Rv4)[PAS__RANGE(Rv17,1,9)+39]=(F)0.000000E-01;
        Rv17++;
      }
      Ra.sl[3]=659; /* line # 659 */
      RPW_INTPUTE_fpck_define(Rv3,0, (F)1.000000E+00, (F)1.000000E+00,1);
      Ra.sl[3]=660; /* line # 660 */
      RPW_INTPUTE_fpck_cycle(Rv3,0,0, &Rv18, &Rv19);
      Ra.sl[3]=661; /* line # 661 */
      RPW_INTPUTE_fpck_cycle(Rv3,1,0, &Rv18, &Rv19);
      Ra.sl[3]=662; /* line # 662 */
      ((F *)Rv4)[16]=V_chi2;
      Ra.sl[3]=664; /* line # 664 */
      Rv14=(F)0.000000E-01;
      Ra.sl[3]=665; /* line # 665 */
      Rv20=(F)1.000000E+00;
      Ra.sl[3]=666; /* line # 666 */
      Rv16=(F)0.000000E-01;
      Ra.sl[3]=667; /* line # 667 */
      Rv21=(F)1.000000E+00;
      Ra.sl[3]=668; /* line # 668 */
      Rv22=(F)1.000000E+00;
      Ra.sl[3]=669; /* line # 669 */
      Rv23=1;
      for( Rf1=V_np;Rf1>0;Rf1-- ) {
        Ra.sl[3]=671; /* line # 671 */
        Rv21=Rv21*Rv8;
        Rv22=Rv22*Rv9;
        Ra.sl[3]=672; /* line # 672 */
        Rv20=(Rv22-Rv21)/(float)Rv23;
        Ra.sl[3]=673; /* line # 673 */
        Rv16=Rv16+Rv20*((F *)Rv4)[PAS__RANGE(Rv23,1,9)+30];
        Ra.sl[3]=674; /* line # 674 */
        Rv24=(F)1.000000E+00;
        Rv25=(F)1.000000E+00;
        Ra.sl[3]=675; /* line # 675 */
        Rv26=1;
        for( Rf0=V_np;Rf0>0;Rf0-- ) {
          Ra.sl[3]=677; /* line # 677 */
          Rv24=Rv24*Rv8;
          Rv25=Rv25*Rv9;
          Ra.sl[3]=678; /* line # 678 */
          Rv27=(Rv25-Rv24)/(float)Rv26;
          Ra.sl[3]=680; /* line # 680 */
          Rv14=Rv14+(((P_lsq_Correl(Rv23, Rv26)*Rv20)*Rv27)*((F *)Rv4)[PAS__RANGE(
          Rv23,1,9)+39])*((F *)Rv4)[PAS__RANGE(Rv26,1,9)+39];
          Rv26++;
        }
        Rv23++;
      }
      Ra.sl[3]=683; /* line # 683 */
      if (V_pro_parm.ub[21]) {
        Ra.sl[3]=685; /* line # 685 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+539,-1,-1,32);
        PAS__WRITE_SNGL(sqrt(V_chi2),10,3,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=686; /* line # 686 */
        Rv28=1;
        for( Rf1=V_hkl_parm.sl[18]+1;Rf1>0;Rf1-- ) {
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+560,-1,-1,32);
          PAS__WRITE_INT(Rv28,0,0);
          PAS__WRITE_STR(Rd.s+578,-1,-1,32);
          PAS__WRITE_SNGL(((F *)Rv4)[PAS__RANGE(Rv28,1,9)+30],10,4,0);
          PAS__WRITE_CHAR(58);
          PAS__WRITE_SNGL(((F *)Rv4)[PAS__RANGE(Rv28,1,9)+39],8,4,0);
          PAS__WRITE_EOLN();
          Rv28++;
        }
      }
    }
    Ra.sl[3]=691; /* line # 691 */
    Rv29=(F)0.000000E-01;
    Rv30=(F)0.000000E-01;
    Ra.sl[3]=692; /* line # 692 */
    Rv31=((F *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*4+81];
    Ra.sl[3]=693; /* line # 693 */
    Rv32=((F *)Rv0)[PAS__RANGE(Rv6,1,((SL *)Rv0)[0])*4+82];
    Ra.sl[3]=694; /* line # 694 */
    Rv33=Rv6;
    for( Rf1=(Rv7+1)-Rv6;Rf1>0;Rf1-- ) {
      Ra.sl[3]=695; /* line # 695 */
      Rv34=(((S *)Rv0)+PAS__RANGE(Rv33,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=696; /* line # 696 */
      if (!(128&((UB *)Rv34)[14])) {
        Ra.sl[3]=698; /* line # 698 */
        Rv35=((F *)Rv34)[0]-Rv10;
        Ra.sl[3]=699; /* line # 699 */
        Rv11=((F *)Rv34)[0]-Rv31;
        Ra.sl[3]=700; /* line # 700 */
        Rv31=((F *)Rv34)[0];
        Ra.sl[3]=701; /* line # 701 */
        if (V_hkl_parm.sl[18]<0) {
          Ra.sl[3]=703; /* line # 703 */
          if (((F *)Rv34)[0]>Ra.f[5]&&Rv13<Rv12) {
            Ra.sl[3]=705; /* line # 705 */
            Ra.f[4]=Ra.f[5];
            Ra.f[6]=Ra.f[7];
            Ra.sl[3]=706; /* line # 706 */
            Rv13=Rv13+1;
            Ra.f[5]=((F *)Rv1)[PAS__RANGE(Rv13,1,2*((SL *)Rv1)[0])+8];
            Ra.sl[3]=707; /* line # 707 */
            Rv13=Rv13+1;
            Ra.f[7]=((F *)Rv1)[PAS__RANGE(Rv13,1,2*((SL *)Rv1)[0])+8]-V_cshift;
            Ra.sl[3]=708; /* line # 708 */
            ((F *)Rv4)[32]=(Ra.f[7]-Ra.f[6])/(Ra.f[5]-Ra.f[4]);
            Ra.sl[3]=709; /* line # 709 */
            ((F *)Rv4)[31]=Ra.f[7]-((F *)Rv4)[32]*Ra.f[5];
          }
          Ra.sl[3]=711; /* line # 711 */
          Rv16=Rv16+((F)5.000000E-01*Rv15)*Rv11;
          Ra.sl[3]=712; /* line # 712 */
          Rv15=((F *)Rv4)[31]+((F *)Rv4)[32]*((F *)Rv34)[0];
          Ra.sl[3]=713; /* line # 713 */
          Rv16=Rv16+((F)5.000000E-01*Rv15)*Rv11;
        }
        else {
          Ra.sl[3]=717; /* line # 717 */
          Rv22=Rv35;
          Ra.sl[3]=718; /* line # 718 */
          Rv15=((F *)Rv4)[31];
          Ra.sl[3]=719; /* line # 719 */
          Rv36=2;
          for( Rf0=(V_hkl_parm.sl[18]+1)-1;Rf0>0;Rf0-- ) {
            Ra.sl[3]=720; /* line # 720 */
            Rv15=Rv15+((F *)Rv4)[PAS__RANGE(Rv36,1,9)+30]*Rv22;
            Rv22=Rv22*Rv35;
            Rv36++;
          }
        }
        Ra.sl[3]=724; /* line # 724 */
        Rv29=Rv29+((F)5.000000E-01*Rv32)*Rv11;
        Ra.sl[3]=725; /* line # 725 */
        Rv32=((F *)Rv34)[1];
        Ra.sl[3]=726; /* line # 726 */
        Rv29=Rv29+((F)5.000000E-01*Rv32)*Rv11;
        Ra.sl[3]=727; /* line # 727 */
        Rv30=Rv30+PAS__F_SQR(((F *)Rv34)[2]);
        Ra.sl[3]=729; /* line # 729 */
        if ((((UB *)Rv34)[14]&30)!=0&&Rv5!=NULL) {
          Ra.sl[3]=730; /* line # 730 */
          Rv37=Rv5;
          Ra.sl[3]=732; /* line # 732 */
          ((F *)Rv37)[13]=((F *)Rv34)[1]-Rv15;
          ((F *)Rv37)[9]=((F *)Rv37)[13];
          Ra.sl[3]=733; /* line # 733 */
          Rv5=((V *)Rv37)[0];
        }
      }
      Rv33++;
    }
    Ra.sl[3]=737; /* line # 737 */
    ((F *)Rv4)[19]=Rv16;
    ((F *)Rv4)[20]=sqrt(fabs(Rv14));
    Ra.sl[3]=739; /* line # 739 */
    Rv29=Rv29-Rv16;
    Ra.sl[3]=740; /* line # 740 */
    Rv30=sqrt(fabs(Rv30+Rv14));
    Ra.sl[3]=742; /* line # 742 */
    ((F *)Rv4)[21]=Rv29;
    ((F *)Rv4)[22]=Rv30;
    Ra.sl[3]=744; /* line # 744 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=745; /* line # 745 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+583,-1,-1,32);
    PAS__WRITE_INT(Rv2,3,0);
    PAS__WRITE_STR(Rd.s+617,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[PAS__RANGE(((SL *)Rv4)[8],1,((SL *)Rv0)[0])*4+81]
    ,8,3,0);
    PAS__WRITE_STR(Rd.s+625,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[PAS__RANGE(((SL *)Rv4)[9],1,((SL *)Rv0)[0])*4+81]
    ,8,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=746; /* line # 746 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+631,-1,-1,32);
    PAS__WRITE_SNGL(Rv29,10,1,0);
    PAS__WRITE_STR(Rd.s+638,-1,-1,32);
    PAS__WRITE_SNGL(Rv30,8,1,0);
    PAS__WRITE_STR(Rd.s+643,-1,-1,32);
    PAS__WRITE_SNGL(Rv29+Rv16,10,1,0);
    PAS__WRITE_STR(Rd.s+663,-1,-1,32);
    PAS__WRITE_SNGL(Rv16,10,1,0);
    PAS__WRITE_STR(Rd.s+672,-1,-1,32);
    PAS__WRITE_INT(Rv18,6,0);
    PAS__WRITE_STR(Rd.s+679,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=749; /* line # 749 */
    if (V_pro_parm.ub[21]) {
      Ra.sl[3]=751; /* line # 751 */
      Rv5=((V *)Rv4)[1];
      Ra.sl[3]=752; /* line # 752 */
      while (Rv5!=NULL){
        Ra.sl[3]=753; /* line # 753 */
        Rv38=Rv5;
        Ra.sl[3]=755; /* line # 755 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+691,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv38)[11],8,3,0);
        PAS__WRITE_STR(Rd.s+702,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv38)[13],10,1,0);
        PAS__WRITE_STR(Rd.s+714,-1,-1,32);
        PAS__WRITE_SNGL(((F *)Rv38)[15],8,3,0);
        PAS__WRITE_EOLN();
        Ra.sl[3]=756; /* line # 756 */
        Rv5=((V *)Rv38)[0];
      }
      Ra.sl[3]=758; /* line # 758 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=761; /* line # 761 */
    RPW_INTPUTE_fit_packet(Rv3);
    Ra.sl[3]=763; /* line # 763 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=764; /* line # 764 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Ra.sl[3]=766; /* line # 766 */
    Rv3=((V *)Rv4)[0];
  }
  Ra.sl[3]=769; /* line # 769 */
  if (V_pro_parm.ub[16]) {
    Ra.sl[3]=771; /* line # 771 */
    P_update_curve(&V_fitcmp_crv, -V_fitcmp_cnp);
    Ra.sl[3]=772; /* line # 772 */
    V_fitcmp_cnp=0;
  }
  Ra.sl[3]=776; /* line # 776 */
  V_bfitini=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " integr_Ref_integr "  */
V P_integr_Ref_integr(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+722;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=789; /* line # 789 */
  V_str_msg.ub[1]=0;
  Ra.sl[3]=794; /* line # 794 */
  if (((((V_sel_pat!=NULL&&V_zone_first!=NULL)&&V_bckgrd_crv!=NULL)&&V_peak_first!=
  NULL)&&V_sel_iright>V_sel_ileft)&&V_ntotpck>0) {
    Ra.sl[3]=804; /* line # 804 */
    RPW_INTPUTE_integr_packet();
  }
  Ra.sl[3]=807; /* line # 807 */
  P_sort_peak();
  Ra.sl[3]=808; /* line # 808 */
  if (V_str_msg.ub[1]>0) Ret=V_str_msg.s;
  else {
    Ra.sl[3]=809; /* line # 809 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
