{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module RPWDATA_INDEX;

%include 'RPWSRC:rpwdata_int_env.pas' {, list_on};




const

  hkl_prmdef = hkl_prmty[ 2.54, 0.0,            { gw1_r, gw2_r : Wave lengths (1 for neutron and 2 for X-ray }
                           1.0, 0.0,            { fwr_r, fwr_s : Wave lengths intensity ratio and sigma }
                           0.0, 0.0,            { the_r, the_s : Theta origine shift }
                           0.5, 0.0, 0.0,       { wd0_r, wd1_r, wd2_r : Fitted Width parameters and ... }
                           0.0, 0.0, 0.0,       { wd0_s, wd1_s, wd2_s : ... related sigmas }
                           0.0, 0.0,            { asy_r, asy_s : Profile asymetry coefficient and sigma }
                           0.1, 0.0,            { mix_r, mix_s : Profil function parameter for complex profile and sigma }
                           0.0,                 { mta_a : Monochromator angle or 0.0 (for X-ray polarization correction) }
                          0.25,                 { err_r : Indexation theta error tolerance }
                             1,   1,            { fbk_n, bkm_i : Polynom order for background and Background fit mode }
                             0,   0,            { rwm_i, rps_i : Reflection half width mode and Profile specific parameter mode }
                             1,                 { lzf_n : Lorentz Factor mode : 0=no, 1-Debye-Sherrer n, ... }
                             0,                 { prf_t : type of profil function (default gaussien) }
                           false,               { the_f : Theta origine shift Fit flag }
                            true, false,        { fbk_f, fwr_f : => UnFixed fbk_f, Fixed fwr_r; }
                            true, false, false, { wd0_f, wd1_f, wd2_f : => UnFixed wd0_r; Fixed wd1_r, wd2_r; }
                           false, false,        { asy_f, mix_f : => Fixed asy_r, mix_f; }
                            true,  true,  true, { pth_f, pwd_f, phg_f : Flags to Fix/UnFix the peak profil position, width and height variables }
                           false                { pmx_f : Flag to Fix/UnFix the profil mixed variable(s) }
                        ];

  idx_prmdef = idx_prmty[  '*undefined*',       { phn_s : Phase Name/Formulae }
                           'Fm-3m',             { grp_s : Space Group Name }
                           4.0, 4.0, 4.0,       { daa_r, dbb_r, dcc_r : The unit cell parameters a (A), }
                           0.0, 0.0, 0.0,       { dal_r, dbe_r, dga_r : alpha (° or cosinus). }
                           true,  false, false, { Fixed/unFixed Flags for cell parameters }
                           false, false, false,
                           false                { Flag for enable or disable the phase }
                        ];


[global]
var
  hkl_parm:                  hkl_prmty;         { Setup for HKL reflection integration }

  phase_tbl:                 pha_tblty;         { Table of all phase record }

  vth0, sth0:           lsq_flt := 0.0;         { Theta origine and related sigma }


[static]
var
  fcl_hkl, lcl_hkl,                             { First and last HKL record for the current phase (Cell) }
  curr_hkl:             hkl_ptr := nil;         { Last HKL pointer to start HKL insert search }

  phase_start:         boolean := true;         { Flag for Phase init mode }

  phase_status: array[1..Max_Phase] of boolean; { Table to keep each old phase status }

  phase_npk:    array[1..Max_Phase] of integer; { Table to keep the number of indexed peak }






[global]
procedure INDEX$DEFAULT_SETUP;
type
  dsc_etbty = array[1..16] of pdsc_acc;

const
  dsc_etb = dsc_etbty[ [ 'Unit cell Parameters (in Angstroem and ° or cosinus)',   5,  12, 190,  32, prm_frm,  20, 3, 2, 0 ],

                       [ 'Nam_s : Phase Name.',                30,  60, 165,  5, prm_str,   nil                       ],
                       [ 'Grp_s : Phase Space Group.',        155,  50,  40,  5, prm_str,   nil                       ],
                       [ 'Caa_r : A = ',                       25,  26,  25,  5, prm_flt,   nil,  0.0, 1000.0, 0.0001 ],
                       [ 'Caa_f : (v)',                        57,  26,   5,  5, prm_bool,  nil                       ],
                       [ 'Cbb_r : B = ',                       85,  26,  25,  5, prm_flt,   nil,  0.0, 1000.0, 0.0001 ],
                       [ 'Cbb_f : (v)',                       117,  26,   5,  5, prm_bool,  nil                       ],
                       [ 'Ccc_r : C = ',                      145,  26,  25,  5, prm_flt,   nil,  0.0, 1000.0, 0.0001 ],
                       [ 'Ccc_f : (v)',                       177,  26,   5,  5, prm_bool,  nil                       ],
                       [ 'Cal_r : Alpha =',                    25,  16,  25,  5, prm_flt,   nil, -1.0,  180.0, 0.0001 ],
                       [ 'Ccc_f : (v)',                        57,  16,   5,  5, prm_bool,  nil                       ],
                       [ 'Cbe_r : Beta  =',                    85,  16,  25,  5, prm_flt,   nil, -1.0,  180.0, 0.0001 ],
                       [ 'Cbe_f : (v)',                       117,  16,   5,  5, prm_bool,  nil                       ],
                       [ 'Cga_r : Gamma =',                   145,  16,  25,  5, prm_flt,   nil, -1.0,  180.0, 0.0001 ],
                       [ 'Cga_f : (v)',                       177,  16,   5,  5, prm_bool,  nil                       ],
                       [ 'Ena_f : To enable this phase definition',               110,   4,   5,   5, prm_bool, nil ]
                     ];

[static]
var
  hkl_desc: pdsc_tab( 32 ) := [ 0, 'Pattern Fit Control Board', 200, 160, [
                [ 'Wave Lengths setting and parameters',              3, 116, 194, 40, prm_frm, 20,  3,  2,  0           ],

                [ 'Gw1_r : Main Wave length',                        68, 140,  20,  5, prm_flt,  nil, 0.0, 10.0, 0.00001 ],
                [ 'Gw2_r : Additional Wave Length',                  68, 132,  20,  5, prm_flt,  nil, 0.0, 10.0, 0.00001 ],
                [ 'Fwr_r : Fitted Lambda2/Lambda1 int. ratio Iwl',  160, 136,  20,  5, prm_flt,  nil, 0.0,  1.0, 0.0001  ],
                [ 'Fwr_f : (v)',                                    188, 136,   5,  5, prm_bool, nil                     ],
                [ 'The_r : Shift (or error) of the Theta Origine',  160, 120,  20,  5, prm_flt,  nil, 0.0,  1.0, 0.0001  ],
                [ 'The_f : (v)',                                    188, 120,   5,  5, prm_bool, nil                     ],

                [ 'Reflection Profil Parameters',                     3,  62, 194, 50, prm_frm, 20,  3,  2,  0           ],

                [ 'Wd0_r : Reflection half width parameter W0',      68,  96,  20,  5, prm_flt,  nil,  0.0, 10.0,  0.001 ],
                [ 'Wd0_f : (v)',                                     96,  96,   5,  5, prm_bool, nil                     ],
                [ 'Wd1_r : W1',                                     114,  96,  20,  5, prm_flt,  nil,  0.0, 10.0,  0.001 ],
                [ 'Wd1_f : (v)',                                    142,  96,   5,  5, prm_bool, nil                     ],
                [ 'Wd2_r : W2',                                     160,  96,  20,  5, prm_flt,  nil,  0.0, 10.0,  0.001 ],
                [ 'Wd2_f : (v)',                                    188,  96,   5,  5, prm_bool, nil                     ],
                [ 'Fnc_n : Reflection Profile Function',             58,  80,  30,  5, prm_enm,  nil, nil                ],
                [ 'Mix_r : Pseudo-Voigt Mixing factor Mix',         160,  84,  20,  5, prm_flt,  nil,  0.0,  1.0,  0.001 ],
                [ 'Mix_f : (v)',                                    188,  84,   5,  5, prm_bool, nil                     ],
                [ 'Asy_r : Asymetry coefficient Asy',               160,  76,  20,  5, prm_flt,  nil, -1.0,  1.0,  0.001 ],
                [ 'Asy_f : (v)',                                    188,  76,   5,  5, prm_bool, nil                     ],
                [ 'Pth_f : Keys to UnFix Theta of line (v)',         62,  66,   5,  5, prm_bool, nil                     ],
                [ 'Pwd_f : ,   half-width (v)',                      97,  66,   5,  5, prm_bool, nil                     ],
                [ 'Phg_f : ,   height (v)',                         125,  66,   5,  5, prm_bool, nil                     ],
                [ 'Pmx_f : ,   Pseudo Voigt mixing factor (v)',     188,  66,   5,  5, prm_bool, nil                     ],

                [ 'Other Reflection integration specific Parameters', 3,  12, 194, 45, prm_frm, 20,  3,  2,  0           ],

                [ 'Rwm_i : Refl. Width mode.',                      135,  40,  58,  5, prm_enm,  nil,  nil               ],
                [ 'Rps_i : Refl. Profil Mixing mode.',              135,  32,  58,  5, prm_enm,  nil,  nil               ],
                [ 'Lzf_i : Lorentz Factor Mode',                     46,  40,  42,  5, prm_enm,  nil,  nil               ],
                [ 'Bkm_i : Background Fit mode.',                    46,  32,  42,  5, prm_enm,  nil,  nil               ],
                [ 'Fbk_n : Background Polynome order.',              60,  20,  15,  5, prm_int,  nil,  -1, max_bckparm-1 ],
                [ 'Fbk_f : (v)',                                     83,  20,   5,  5, prm_bool, nil                     ],
                [ 'Mta_a : Monochromator Bragg Angle (°)',          173,  24,  20,  5, prm_flt,  nil,  0.0, 50.0, 0.0001 ],
                [ 'err_r : Indexation max. theta error',            173,  16,  20,  5, prm_flt,  nil, 0.01, 5.0, 0.01    ]
              ] ];


  { String Values for Background Fit Mode (Bkm_i values) }
  bkm_enmval: Choice_List( 3, 32 ) := [ 'Initial Background Use',
                                        'First Fitted Background Use',
                                        'Fit Background with reflections'
                                      ];

  { String Values for Reflection Profile spc Mode (Rwm_i values) }
  rwm_enmval: Choice_List( 3, 32 ) := [ 'Individual Half Width',
                                        'Common Half Width = W0',
                                        'Half Width = W0 + W1*Tan(theta)'
                                      ];

  { String Values for Reflection Profile spc Mode (Rps_i values) }
  rps_enmval: Choice_List( 2, 34 ) := [ 'Individual profil parameter(s)',
                                        'Zone Common profil parameter(s)'
                                      ];

  { String Values for Reflection profile functions (Fnc_n values) }
  fnc_enmval: Choice_List( 3, 18 ) := [ 'Gaussian',
                                        'Lorentzian',
                                        'Pseudo-Voigt'
                                      ];

  { String Values for Automatic Fit Mode (Afm_n values) }
  afm_enmval: Choice_List( 3, 18 ) := [ '',
                                        '',
                                        ''
                                      ];

  { String Values for the Automatic Fit Mode (Lzf_n values) }
  lzf_enmval: Choice_List( 6, 22 ) := [ 'no Lorentz Correction',{ 1.0 }
                                        'Neutron Powder',       { 1.0/(sin(theta)*sin(2*theta)) }
                                        'R-Ray Powder',         { (1.0 + cos(theta)^2)/(sin(theta)*sin(2*theta)) }
                                        'Undef 3',              { 1.0 --- Reserved for future. }
                                        'Undef 4',
                                        'Undef 5'
                                      ];



  idx_dtab:       array[1..Max_Phase] of pdsc_tab( 16 );
  binit:                               boolean := true;

begin
  if binit then
  begin
    with hkl_desc, hkl_parm do
    begin
      SET_REF( tb[ 2].rf, gw1_r );
      SET_REF( tb[ 3].rf, gw2_r );
      SET_REF( tb[ 4].rf, fwr_r );
      SET_REF( tb[ 5].rf, fwr_f );
      SET_REF( tb[ 6].rf, the_r );
      SET_REF( tb[ 7].rf, the_f );

      SET_REF( tb[ 9].rf, wd0_r );
      SET_REF( tb[10].rf, wd0_f );
      SET_REF( tb[11].rf, wd1_r );
      SET_REF( tb[12].rf, wd1_f );
      SET_REF( tb[13].rf, wd2_r );
      SET_REF( tb[14].rf, wd2_f );
      SET_REF( tb[15].rf, fnc_n );  SET_REF( tb[15].el, fnc_enmval );
      SET_REF( tb[16].rf, mix_r );
      SET_REF( tb[17].rf, mix_f );
      SET_REF( tb[18].rf, asy_r );
      SET_REF( tb[19].rf, asy_f );
      SET_REF( tb[20].rf, pth_f );
      SET_REF( tb[21].rf, pwd_f );
      SET_REF( tb[22].rf, phg_f );
      SET_REF( tb[23].rf, pmx_f );

      SET_REF( tb[25].rf, rwm_i );  SET_REF( tb[25].el, rwm_enmval );
      SET_REF( tb[26].rf, rps_i );  SET_REF( tb[26].el, rps_enmval );
      SET_REF( tb[27].rf, lrz_i );  SET_REF( tb[27].el, lzf_enmval );
      SET_REF( tb[28].rf, bkm_i );  SET_REF( tb[28].el, bkm_enmval );
      SET_REF( tb[29].rf, fbk_n );
      SET_REF( tb[30].rf, fbk_f );
      SET_REF( tb[31].rf, mta_a );
      SET_REF( tb[32].rf, err_r )
    end;
    setup_tab[HKL_IDX] := hkl_desc"address;
    hkl_parm := hkl_prmdef;

    for ii := 1 to Max_Phase do
    begin
      phase_status[ii] := false;
      phase_npk[ii]    :=     0;
      with idx_dtab[ii], phase_tbl[ii].cel_info do
      begin
        id := 0;
        WRITEV( ti, 'Phase_', ii:0, '  Definition Pannel' );
        w := 200; h :=  70;
        for jj := 1 to ni do  tb[jj] := dsc_etb[jj];
        SET_REF( tb[ 2].rf, name );
        SET_REF( tb[ 3].rf, group );
        SET_REF( tb[ 4].rf, daa_v );
        SET_REF( tb[ 5].rf, daa_f );
        SET_REF( tb[ 6].rf, dbb_v );
        SET_REF( tb[ 7].rf, dbb_f );
        SET_REF( tb[ 8].rf, dcc_v );
        SET_REF( tb[ 9].rf, dcc_f );
        SET_REF( tb[10].rf, dal_v );
        SET_REF( tb[11].rf, dal_f );
        SET_REF( tb[12].rf, dbe_v );
        SET_REF( tb[13].rf, dbe_f );
        SET_REF( tb[14].rf, dga_v );
        SET_REF( tb[15].rf, dga_f );
        SET_REF( tb[16].rf, ena_f )
      end;
      with phase_tbl[ii] do
      begin
        cel_group.length :=  0;
        cel_ngrp       :=    0;
        cel_nsys       :=    0;
        cel_orient     :=    0;
        for ii := 1 to 6 do
        begin
          cel_dcell[ii] := 0.0; cel_dcesg[ii] := 0.0;
          cel_rmt[ii]   := 0.0; cel_rsg[ii]   := 0.0
        end;
        for ii := 1 to 3 do
          for jj := 1 to 3 do
          begin    end;
        cel_sym := nil;
        cel_ref := nil
      end;
      setup_tab[ii + (PH1_IDX - 1)] := idx_dtab[ii]"address;
      phase_tbl[ii].cel_info := idx_prmdef
    end
  end;

  binit := false
end INDEX$DEFAULT_SETUP;



procedure NO_SPACE( var str: string );
var
  n: integer;

begin
  if str.length > 0 then
  begin
    n := 0;
    for i := 1 to str.length do
      if str[i] > ' ' then begin  n := n + 1; str[n] := str[i]  end;
    str.length := n
  end
end NO_SPACE;



function  HKL_SEARCH( th: real ): hkl_ptr;
{ Search the nearest of the specified angle HKL }
var
  pk, pl:      hkl_ptr;

begin
  if not mai_parm.tmd_f then th := 2.0*th;              { Get the data angle (theta or 2*theta) }
  if curr_hkl = nil then curr_hkl := hkl_first;
  if curr_hkl = nil then
    pk := nil
  else
  if th < curr_hkl^.theta then
  begin { Backward search }
    pk := curr_hkl^.prev;
    while (pk <> nil) and (th <= pk^.theta) do  pk := pk^.prev
  end
  else
  begin { Forward search }
    pk := curr_hkl;
    pl := pk^.next;
    while (pl <> nil) and (th > pl^.theta) do
    begin  pk := pl; pl := pl^.next  end
  end;
  curr_hkl := pk;
  HKL_SEARCH := pk
end HKL_SEARCH;



function  NEW_HKL( iph: integer; angle: real; phkl: ihk_ptr ): hkl_ptr;
var
  pn, pp: hkl_ptr;

begin
  { Create the HKL record anf fill it }
  if hkl_free <> nil then begin  pn := hkl_free; hkl_free := pn^.next  end
                     else NEW( pn );
  with pn^ do
  begin
    next    :=     nil;
    prev    :=     nil;
    hnxt    :=     nil;
    zonp    :=     nil;
    pckp    :=     nil;
    rcell   :=     iph;
    hkltb   :=    phkl;
    heigh   :=     0.0;
    shigh   :=     0.0;
    width   := hkl_parm.wd0_r;
    swidt   :=     0.0;
    mixfc   :=     0.0;
    smixf   :=     0.0;
    if mai_parm.tmd_f then theta := angle               { Get the data angle (theta or 2*theta) }
                      else theta := 2.0*angle
  end;
  { Locate the previous HKL record when it is existing }
  pp := HKL_SEARCH( angle );

  if pp = nil then
  begin { Must be insert at the head of HKL List }
    pn^.next := hkl_first; hkl_first := pn;
    if hkl_last = nil then hkl_last  := pn              { For the first HKL to put in the HKL List }
  end
  else
  begin { Must insert the new HKL any where in the HKL List (to get a increasing angle sorted HKL list) }
    pn^.prev := pp; pn^.next := pp^.next;               { Set the previous and next link pointer of the new HKL }
    pp^.next := pn;                                     { Set the previous hkl to link to the new one }
    if hkl_last = pp then hkl_last := pn                { When the new HKL is a new last HKL update the HKL List Header last pointer, ... }
                     else pn^.next^.prev := pn;         { ... else update the previous link of the next HKL to the new one. }
  end;

  if lcl_hkl = nil then fcl_hkl := pn                   { Build the Phase/Cell specific HKL List }
                   else lcl_hkl^.hnxt := pn;
  lcl_hkl := pn;

  NEW_HKL := pn
end NEW_HKL;



procedure DISPLAY_HKL_LIST( ph: hkl_ptr; battach: boolean := false );
var
  ii: integer;
  ba: boolean;

begin
  if ph = nil then begin  ph := hkl_first; ba := true  end
              else ba := false;
  ii := 0;
  while ph <> nil do
  with ph^ do
  begin
    if (battach and (zonp <> nil)) or not battach then
    begin
      ii := ii + 1;
      WRITE( ' ', ii:5, ' / P ', rcell:2, ' ', theta:8:4 );
      if hkltb <> nil then with hkltb^[hkltb^.sz] do WRITE( ' [', ih:4, ik:4, il:4, ' ],  P = ', iq:2, ', M = ', ml:2 );
      if zonp <> nil then
      with zonp^ do
      begin
        WRITE( ' Zone th ', tmin:8:3, '..', thmax:8:3 );
        if pckp <> nil then WRITE( ' Peak at ', pckp^.thpos:8:3 )
      end;
      WRITELN;
    end;
    if ba then ph := next
          else ph := hnxt
  end;
end DISPLAY_HKL_LIST;



procedure FREE_PHASE_HKL( iph: integer );
{ Free all HKL of a specified Phase <iph>. }
var
  pc, ph, pl, pp:      hkl_ptr;
  pz:                  zon_ptr;

begin
  with phase_tbl[iph] do
  begin
    pl := nil;
    pc := cel_ref;
    if pc <> nil then
    begin
      repeat                                            { Loop on all hkl of the phase }
        with pc^ do
        begin
          pz := zonp;
          if pz <> nil then                             { When the HKL is attached to a zone we suppress it from the zone HKL list }
          with pz^ do
          begin
            ph := hklf; pp := nil;
            while (ph <> nil) and (ph <> pc) do         { Loop to search the current HKL in the zone list }
            begin  pp := ph; ph := ph^.hnxt  end;
            if ph = pc then                             { When the HKL position is found ... }
              if pp = nil then hklf := ph^.next         { ... we suppress it from the common HKL list }
                          else pp^.next := ph^.next
          end;
          DISPOSE( hkltb );                             { Free the HKL index table }
          hkltb := nil;
          if prev <> nil then prev^.next := next        { Take off the HKL record from the bidirectional linked List }
                         else hkl_first := next;
          if next <> nil then next^.prev := prev
                         else hkl_last := prev;
          next := hnxt;                                 { Prepare the next link for the free HKL record list }
          pl   :=   pc;
          pc   := hnxt
        end
      until pc = nil;
      pl^.next := hkl_free;                             { Put all HKL record in the free list }
      hkl_free := cel_ref;
      cel_ref := nil
    end
  end
end FREE_PHASE_HKL;



procedure FREE_HKL( p: hkl_ptr );
var
  p1, p2: hkl_ptr;

begin
  if p <> nil then
  begin
    with p^ do
    begin
      DISPOSE( hkltb );         { Free the HKL index table }
      { We must also extract the hkl of the HKL zone list if this hkl is attached to a ref. packet }
      if zonp <> nil then
      with zonp^ do
        if hklf = p then
          if hkll = p then begin  hklf := nil; hkll := nil  end
                      else hklf := p^.next
        else
          if hkll = p then hkll := p^.prev;

      { Extract the HKL record from the common HKL list }
      if prev = nil then hkl_first := next
                    else prev^.next := next;
      if next = nil then hkl_last := prev
                    else next^.prev := prev
    end;
    { Free the hkl record }
    p^.next := hkl_free;
    hkl_free := p
  end
end FREE_HKL;



procedure CREATE_HKL_LIST( iph: integer );

begin
  if (iph >= 1) and (iph <= Max_Phase) then
  with phase_tbl[iph], cel_info do
  if ena_f then
  begin { Work only on an enabled phase }

  end
end CREATE_HKL_LIST;



procedure DEFINE_HKL_FIT_PARMS( pz: zon_ptr; ph: hkl_ptr; iph: integer );
var
  wd, tg: real;
  pk:  pck_ptr;

begin
  with pz^, ph^, hkl_parm do
  begin
    tg := TAN( theta*inrd );
    wd := SQRT( wd0_r + wd1_r*tg + wd2_r*SQR( tg ) );
    INTEGR$SET_REFLINE( theta, 0.0, wd, [mk_rflcen,mk_rflhkl] );
    phase_npk[iph] := phase_npk[iph] + 1;       { Update the peak count }
    ph^.pckp := peak_curr                       { Attach the newq peak to the HKL }
  end
end DEFINE_HKL_FIT_PARMS;



procedure INTEGR$HKL_LINK( fit_flg: boolean );
{ Procedure to link the HKL list of all enabled phases to the
  existing peaks of the current pattern.
}
var
  pz:          zon_ptr;
  ph:          hkl_ptr;
  pk:          pck_ptr;
  nz, nr, np:  integer;

begin
  str_msg.length := 0;

  { Test for Indexation conditions }
  if (sel_pat = nil) or (zone_first = nil) or (bckgrd_crv = nil) or
     (peak_first = nil) or (sel_iright <= sel_ileft) or (ntotpck <= 0) then
  begin
WRITELN( ' No condit.' );
    return
  end;

  for iph := 1 to Max_Phase do
  with phase_tbl[iph] do
  if cel_info.ena_f then
  begin
    ph :=  hkl_first;                                   { Set the HKL loop pointer to the first phase reflection }
    pz := zone_first;                                   { Set the Zone loop pointer to the first integration zone }
    nz :=          0;                                   { Init the zone count }
    nr :=          0;
    np :=          0;

    phase_npk[iph] := 0;                                { Init the peak found count }

    while (pz <> nil) and (ph <> nil) do                { Loop on all zone }
    with pz^ do
    begin
      nz := nz + 1;                                     { Set the zone number }
      { Loop to search a Diffraction line in the current zone }
      while (ph <> nil) and (ph^.theta <= thmin) do ph := ph^.next;
(*
if ph = nil then
WRITELN( ' No HKL in the zone # ', nz:3, ' in range ', thmin:8:3, '..', thmax:8:3 );
*)
    exit if ph = nil;                                   { No other diffraction line for this phase }

      while (ph <> nil) and (ph^.theta < thmax) do      { Loop on all HKL with theta in the zone angle range }
      begin
        ph^.zonp := ph; ph^.pckp := nil;                { Set the Zone pointer in the HKL record and ... }
        if hkll = nil then hklf := ph                   { ... append this HKL to the HKL Zone list. }
                      else hkll^.hnxt := ph;
        hkll := ph;
        nr := nr + 1;
        pk  := pckf;
        while pk <> nil do                              { Loop to search when a peak that can be attached to the current HKL }
        begin
          if ABS(pk^.thpos - ph^.theta) < hkl_parm.err_r then
          begin
            ph^.pckp := pk;
            phase_npk[iph] := phase_npk[iph] + 1;       { Update the peak count }
            MOVE_PEAK_POS( pk, [mk_rflpos,mk_rflcen,mk_rflhkl] );
            ph^.heigh :=  pk^.heigh;
            ph^.width :=  pk^.width;
            ph^.mixfc :=  pk^.mixfc;
          end;
(*
          else 
            if fit_flg then DEFINE_HKL_FIT_PARMS( pz, ph, iph );
*)
          np := np + 1;
          pk := pk^.next
        end;

        ph := ph^.next                                  { Skip to next HKL }
      end;
      pz := next                                        { Skip to the next zone }
    end
  end;
(*
WRITELN( ' ', nr:5, ' Reflection are selected and ', np:5, ' was attached with peaks.' );
*)
end INTEGR$HKL_LINK;



procedure INTEGR$HKL_DEF_FIT( bhkl: boolean );
const
  nep_msg = 'Not enough indexed peak to start a fit';

var
  ph:                          hkl_ptr;
  pz:                          zon_ptr;
  idgw, idsp, ior, ncf:        integer;

begin
  LSQ$INIT;                                             { Init Least square System }

  with hkl_parm do
  begin

    

    ph := hkl_first;                                    { Init the pointers to scan the list of HKl ... }
    pz := zone_first;                                   { ... the list of zone. }
    while pz <> nil do
    with pz^ do
    begin
      idgw :=  0;
      idsp :=  0;
      ior  :=  0;

      if fbk_f and ((not bhkl) or (bkm_i = 2)) then     { When the backgrounds are fitted ... }
        for i := 1 to fbk_n + 1 do                      { ... we start from the previous fitted values }
          ior := LSQ$NEW_VPARM( bcf[i], bcs[i] );       { We define the background parameters to fit }

      if bhkl then
      begin
        if (rwm_i > 0) {and width_free} then
        begin
          ior  := LSQ$NEW_VPARM( zwid0, zswi0 );        { We define the global main width to fit }
          idgw := ior;                                  { Keep the width index }
          if rwm_i > 1 then
            ior := LSQ$NEW_VPARM( zwid1, zswi1 )        { Set the fit of TAN term }
         end;

        if (rps_i = 1) and pmx_f then
        begin
          ior  := LSQ$NEW_VPARM( zprf0, zspr0, 0.0,1.0 ); { We define the global first profil special parm }
          idsp := ior                                   { Can have second profil parm. (in future) depending of profil type }
        end;



      end;

      pz := next
    end;

  end;



(*

      { Scan all peak of zone }
      pk := pckf;
      while pk <> nil do
        with pk^ do                                     { Loop for each peak in the zone (packet) }
        begin
          idthe := 0;
          idhig := 0;
          idpr0 := 0;
          idpr1 := 0;
          idwid := 0;
(*
  fit_flgid = ( fflg_it_lock,                           { Initial 2*theta lock }
                fflg_ih_lock,                           { Initial high lock }
                fflg_iw_lock,                           { Initial width lock }
                fflg_is_lock,                           { Initial profile specific lock }
                fflg_th_lock,                           { Theta locked }
                fflg_hg_lock,                           { High locked }
                fflg_wd_lock,                           { Width locked }
                fflg_sp_lock,                           { Profil specific variable lock }
                fflg_automd                             { Auto mode }
              );
*)(*
          if bth and not (fflg_th_lock in fitflg.sv) then
            idthe := LSQ$NEW_VPARM( thpos, sgthp, thmin, thmax );       { Fit the reflection position }

          if not (fflg_hg_lock in fitflg.sv) then
            idhig := LSQ$NEW_VPARM(  high, sghig, 0.0, flt_max );       { Fit packet high }

          if not (fflg_wd_lock in fitflg.sv) then
            if rwm_i <= 0 then idwid := LSQ$NEW_VPARM( width, sgwid )
                          else idwid := idgw + 1;
          if (* (rps_i <= 0) and *)(* not (fflg_sp_lock in fitflg.sv) then
          case ftyp of
            fnc_pvoigt:                                  { For Pseudo-Voigt we add the mixing parameter }
              if rps_i <= 0 then idpr0 := LSQ$NEW_VPARM( prf0, sgpr0, 0.0, 1.0 )
                            else idpr0 := idsp;

          otherwise
          end;
          pk := znxt
        end
    end;


*)



  for iph := 1 to Max_Phase do                  { Loop one each defined phase }
  with phase_tbl[iph], cel_info do
  if cel_info.ena_f then
  begin
    ncf := np;                                  { Keep the count of LSQ Variable }
    case cel_nsys of
      1: { Triclinic }
        for ii := 1 to 6 do
          LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );

      2: { Monoclinic }
        begin
          for ii := 1 to 3 do
            LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );
          case cel_orient of
            0, 4: { Unique Z Axis } LSQ$NEW_VPARM( cel_rmt[6], cel_rsg[6] );
            1, 3: { Unique Y Axis } LSQ$NEW_VPARM( cel_rmt[5], cel_rsg[5] );
            2, 5: { Unique X Axis } LSQ$NEW_VPARM( cel_rmt[4], cel_rsg[4] );
          otherwise
          end
        end;

      3: { Orthorhombic }
        for ii := 1 to 3 do
          LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );

      4, 5, 6, 7: { Tetragonal, Trigonal, Hexagonal,Rhombohedral  }
        begin
          LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );
          LSQ$NEW_VPARM( cel_rmt[3], cel_rsg[3] )
        end;

      8: { Cubic }
        LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );

    otherwise
    end;
    ncf := np - ncf;                            { Get the number of created variables }
    if phase_npk[iph] < 2*ncf then WRITEV( str_msg, ' Not enough indexed reflection to FIT the Unit cell of the phase "', cel_info.name, '".' )
  end;

  LSQ$NEW_VPARM( vth0, sth0 );                  { Select the theta shift fit }

end INTEGR$HKL_DEF_FIT;



procedure BRAGG_THETA( ph: hkl_ptr; var th: lsq_flt );
var
  bth1, bth2, usd, us2d, hh, kk, ll, vth_1, vth_2, stsl_1, stsl_2,
  h2, k2, l2, hk, kl, lh, nv, nw,
  stl, zer_vth, zer_sth:       lsq_flt;
  drv1, drv2:   array[1..6] of lsq_flt;

begin
  with  ph^, phase_tbl[rcell], cel_info do
  if ena_f then
  begin

    with hkltb^[hkltb^.sz] do
    begin
      hh := ih; kk := ik; ll := il;
      if nq <> 0 then
      begin { Not actually implemented }
      end
    end;

    { Compute 1/d**2 }
    h2  := SQR( hh ); k2 := SQR( kk ); l2 := SQR( ll );
    hk  := 2.0*hh*kk; kl := 2.0*kk*ll; lh := 2.0*ll*hh;
    stl := 0.5*SQRT( cel_rmt[1]*h2 + cel_rmt[2]*k2 + cel_rmt[3]*l2 +
                     cel_rmt[4]*kl + cel_rmt[5]*lh + cel_rmt[6]*hk );
    nv  := 8.0*stl;
(**)
    drv2[1] := h2/nv; drv2[2] := k2/nv; drv2[3] := l2/nv;
    drv2[4] := kl/nv; drv2[5] := lh/nv; drv2[6] := hk/nv;

    nv := us2d*hkl_parm.gw1_r;
    nw := hkl_parm.gw1_r/inrd;
    bth1 := ARCSIN( nv )/inrd + zer_vth;
    for ii := 1 to 6 do  drv1[ii] := drv2[ii]*nw/SQRT( 1.0 - SQR( nv ) );

    if hkl_parm.gw2_r > 0.0 then
    begin
      nv := us2d*hkl_parm.gw2_r;
      bth2 := ARCSIN( nv )/inrd + zer_vth;
      for ii := 1 to 6 do  drv2[ii] := drv2[ii]*nw/SQRT( 1.0 - SQR( nv ) );

    end;


(*

   case cel_nsys of
      1: { Triclinic }
        begin
          usd2 := cel_rmt[1]*SQR( hh ) + cel_rmt[2]*SQR( kk ) + cel_rmt[3]*SQR( ll )
        end;
        for ii := 1 to 6 do  LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );

      2: { Monoclinic }
        begin
          for ii := 1 to 3 do  LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );
          case cel_orient of
            0, 4: { Unique Z Axis } LSQ$NEW_VPARM( cel_rmt[6], cel_rsg[6] );
            1, 3: { Unique Y Axis } LSQ$NEW_VPARM( cel_rmt[5], cel_rsg[5] );
            2, 5: { Unique X Axis } LSQ$NEW_VPARM( cel_rmt[4], cel_rsg[4] );
          otherwise
          end
        end;

      3: { Orthorhombic }
        for ii := 1 to 3 do  LSQ$NEW_VPARM( cel_rmt[ii], cel_rsg[ii] );

      4, 5, 6: { Tetragonal, Trigonal, Hexagonal }
        begin
          LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );
          LSQ$NEW_VPARM( cel_rmt[3], cel_rsg[3] )
        end
      7: { Rhombohedral }
        begin
          LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );
          LSQ$NEW_VPARM( cel_rmt[4], cel_rsg[4] )
        end;

      8: { Cubic }
        LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );

    otherwise
    end;
*)
  end
end BRAGG_THETA;



[global]
function  INTEGR$HKL_DO_FIT: ^string;
var


begin


  INTEGR$HKL_DEF_FIT( true );


  INTEGR$HKL_DO_FIT := nil
end INTEGR$HKL_DO_FIT;



[global]
procedure INTEGR$HKL_SET_HKL( var flg: boolean; var emsg: ^string );
{ Function to create the HKL list for all active phases.
  Must be called for each Phase Setup Change.
}
const
  nrgsperr = 'Cannot run the program "mxd_gen_space" (alias: gen_space)';
  nkspgerr = 'mxd_gen_space program return "Unknown Space Group"';
  nopeferr = 'Cannot open the temporary space group file';
  hklfname = 'hkl_list_tmp.dat';

var
  phk, ptm:                    hkl_ptr;
  pht:                         ihk_ptr;
  pck:                         pck_ptr;
  gml, ie, iflg,
  ih, ik, il, ip, iq,
  iu, mul, nq, nrefl, hklsz:   integer;
  bch, bok:                    boolean;
  cmd, str:                     string;
  us2dmax, us2d, vl, ang:         real;
  tf:                             text;

begin
  if sel_pat = nil then return;
  bch := false;
  for iph := 1 to Max_Phase do                  { Loop on all active phases }
  with phase_tbl[iph], cel_info do
  begin
    if ena_f then
    begin                                       { Work only on enabled phase }
      if phase_start or
         (phase_status[iph] = false) or
         (cel_info.group <> cel_group) or       { Check for unit space group or unit cell user change }
         (ABS( cel_dcell[1] - cel_info.daa_v ) > 1e-5) or
         (ABS( cel_dcell[2] - cel_info.dbb_v ) > 1e-5) or
         (ABS( cel_dcell[3] - cel_info.dcc_v ) > 1e-5) or
         (ABS( cel_dcell[4] - cel_info.dal_v ) > 1e-3) or
         (ABS( cel_dcell[5] - cel_info.dbe_v ) > 1e-3) or
         (ABS( cel_dcell[6] - cel_info.dga_v ) > 1e-3) then
      begin                                     { Update information when a user phase change is detected }

        { Destroye any old HKL record of this phase }
        if not phase_start then FREE_PHASE_HKL( iph );
(*
if not phase_start then
begin
  WRITELN( ' DISPLAY Free' );
  DISPLAY_HKL_LIST( hkl_free );
  WRITELN( ' END DISPLAY Free' );
end;
*)
        cel_group    := cel_info.group;         { Update the internal phase status }
        cel_dcell[1] :=   cel_info.daa_v;
        cel_dcell[2] :=   cel_info.dbb_v;
        cel_dcell[3] :=   cel_info.dcc_v;
        cel_dcell[4] :=   cel_info.dal_v;
        cel_dcell[5] :=   cel_info.dbe_v;
        cel_dcell[6] :=   cel_info.dga_v;
        cel_nsys   :=    0;                     { Init at Not-Defined value }
        cel_ngrp   :=    0;
        cel_orient :=    0;
        cel_sym    :=  nil;
        cel_ref    :=  nil;
        bch := true;                            { Flags the phase computing init }

(*
WRITELN( ' End DEL' );
*)
        { Generate a call of mxd_gen_space program to get the HKL List and the metric tensor }
        bok := false;
        if mai_parm.tma_r > 0.0 then vl := mai_parm.tma_r       { Get the maximum used angle of the selected pattern }
                                else vl := thmax;
        if not mai_parm.tmd_f then vl := 0.5*vl;
        us2dmax := SIN( inrd*vl )/sel_pat^.lambda1;
        WRITEV( str, '-cell=', daa_v:8:3, ',', dbb_v:8:3, ',', dcc_v:8:3, ',', dal_v:8:3, ',', dbe_v:8:3, ',', dga_v:8:3 );
        NO_SPACE( str );
        WRITEV( cmd, 'gen_space ', cel_group, ' ', str, ' ' );
        WRITEV( str, '-ghkl=', us2dmax:6:2, ',2:0' );   { We build the packet here => flag word = 0 }
        NO_SPACE( str );
        WRITEV( cmd:false, str, ' -data ', hklfname );
(*
WRITELN( ' Gen_Space Commande = ', cmd );
*)
        ip := CREATE_PROCESS( 'MXDLIB:mxd_gen_space', cmd );
        if ip > 0 then
        begin
          iu := WAIT_PROCESS( ie, ip );
          if ie <> 0 then emsg := nkspgerr"address
                     else bok := true
        end
        else emsg := nrgsperr"address;

(*
        WRITELN( ' GEN_SPACE has created the following data file :' );
        SYS_SPAWN( 'cat '||hklfname );
*)

        if bok then
        begin
          OPEN( tf, hklfname, [read_file,error_file{,del_file}] );
          if iostatus <> 0 then
          begin
            emsg := nopeferr"address;
            bok := false
          end
        end;

        if bok then
        begin
          READLN( tf, str:0:true, str:0:true, cel_ngrp, cel_nsys, cel_orient ); { Read the Space Group #, Crist_System # and Orientation # }
          READLN( tf ); READLN( tf ); READLN( tf );             { Ignore five lines (for unit-cells parameters, transformation ... }
          READLN( tf ); READLN( tf );                           { ... matrix and direct metrci tensor) }
          for ii := 1 to 6 do  READ( tf, cel_rmt[ii] );         { Read the reciprocal metric tensor (3x3 triangular matrix) }
          for ii := 4 to 6 do  cel_rmt[ii] := 2.0*cel_rmt[ii];  { Set as (1/d)**2 coefficients }
          READLN( tf );
          READLN( tf, nrefl );                                  { Read the total number of independant reflections }
          READLN( tf );                                         { Ignore the Column labels line }

          fcl_hkl := nil; lcl_hkl := nil;                       { Init the Cell HKL List }

          for ir := 1 to nrefl do                               { Loop on all independant reflections }
          begin
            READLN( tf, hklsz );                                { Read the number of equivalent (with Fridel partner) HKL }
            NEW( pht, hklsz );                                  { Allocate the HKL Index Table of the reflection }

            for ii := 1 to hklsz do                             { Loop to read each HKL index }
              with pht^[ii] do
              begin
                READ( tf, ih, ik, il, nq, iq, ml, iflg );
                if iflg <= 0 then READLN( tf )
              end;

            READLN( tf, gml, us2d );                            { Read the Global multiplicity and the 1/2d value }
            ang := ARCSIN( us2d*sel_pat^.lambda1 )/inrd;        { Compute the Bragg angle }
            phk := NEW_HKL( iph, ang, pht );

          end;
          cel_ref := fcl_hkl;                                   { Set the new phase related HKL List }

          CLOSE( tf )                                           { Close the HKL dat file (implicite DEL can be performed when set in OPEN flags) }
        end
        else ena_f := false
(*
;WRITELN( ' DISPLAY CELL' );
;DISPLAY_HKL_LIST( cel_ref );
WRITELN( ' END DISPLAY CELL' );
*)
      end
    end;
    phase_npk[iph] := 0;                                        { Clear the number of found peak of each phase }
    if phase_status[iph] <> ena_f then
    begin  phase_status[iph] := ena_f; bch := true  end
  end;
  phase_start := false;                                         { Clear the Start HKL Init Flag }
  flg := true { Set the refresh of HKL markers }
end INTEGR$HKL_SET_HKL;



[global]
function  INTEGR$HKL_INDEX: ^string;
var
  ph:  hkl_ptr;

begin
  INTEGR$HKL_LINK( true );                      { Do the attachement of the HKL to the zone and to the detected peaks when it is possible  }

  INTEGR$HKL_DO_FIT;                            { Perform the Cell/intensities refinment }

  DISPLAY_HKL_LIST( nil, true );                { Output results }

  INTEGR$HKL_INDEX := nil
end INTEGR$HKL_INDEX;



end RPWDATA_INDEX.
