{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module RPWDATA_FIT;

%include 'RPWSRC:rpwdata_int_env.pas' {, list_on};

type
  fit_format = (       fit_bck,
                      fit_cell,
                      fit_full
               );

  fit_flags = set of fir_format;



procedure CELL_DEF_FIT;
{ Define the cell variable to fit.
}
begin
  with hkl_parm do
  begin
    LSQ$INIT;                                   { Init the Least Squares system }
    for iph := 1 to Max_Phase do                { Loop on all possible phases }
      with phase_tbl[iph], cel_info do
        if ena_f do                             { Skip any not enabled phase }
        begin
          ncf := np;                            { Keep the count of LSQ Variables }
          case cel_nsys of
            1: { Triclinic }
              for i := 1 to 6 do
                LSQ_NEW_VPARM( cel_rmt[i], cel_rsg[i] );

            2: { Monoclinic }
              begin
                for i := 1 to 3 do
                  LSQ$NEW_VPARM( cel_rmt[i], cel_rsg[i] );
                  case cel_orient of
                    0, 4: { Unique Z Axis } LSQ$NEW_VPARM( cel_rmt[6], cel_rsg[6] );
                    1, 3: { Unique Y Axis } LSQ$NEW_VPARM( cel_rmt[5], cel_rsg[5] );
                    2, 5: { Unique X Axis } LSQ$NEW_VPARM( cel_rmt[4], cel_rsg[4] );
                  otherwise
                  end
              end;

            3: { Orthorhombic }
              for i := 1 to 3 do
                LSQ$NEW_VPARM( cel_rmt[i], cel_rsg[i] );

            4, 5, 6, 7: { Tetragonal, Trigonal, Hexagonal, Rhombohedral  }
              begin
                LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );
                LSQ$NEW_VPARM( cel_rmt[3], cel_rsg[3] )
              end;

            8: { Cubic }
              LSQ$NEW_VPARM( cel_rmt[1], cel_rsg[1] );

          otherwise
          end;
          ncf := np - ncf;
          if phase_npk[iph] < 2*ncf then
            WRITEV( str_msg, ' Not enough indexed reflection to FIT the Unit cell of the phase "', cel_info.name, '".' )
        end;
    LSQ$NEW_VPARM( vth0, sth0 );                { Select the theta shift fit }
  end
end CELL_DEF_FIT;



procedure ZONE_DEF_FIT( pz: zon_ptr; var ph: hkl_ptr; dmp, mrq: lsq_flt; bpck, bth: boolean := true );
{ Define all LSQ Variables for the zone pz to fit the following parameters :
   if bpck then
                the peaks of the pz^ zone will be fitted with background parameters,
           else
                only the bacground parameters will be fitted.
   if bth then (used with bpck = true)
                the peaks positions  will be locked (used for first cycles.
           else
                the peaks positions  will be fitted with the other parameters.

      fbk_n is the polynome order to fit the background.

      bkm_i is 0,1 or 2 to do respectively :   Use initial background (GBK), used first fitted background (FBK),
                                               fit background with the peaks (FFBK).
                => The background is fitted when bkm_i = 2 or bpck = false (no peak fit).
           else the initial background is the (Hystogram or entered background).

      rwm_i is 0, 1 or 2 to do respectively :  Fit of individual half width (one parameter for each peak),
                                               Fit a common half width for all peaks of the zone,
                                               The half width for all peaks are given by the formulae w0 + w1*Tang( 2*theta )
                                               where w0 and w1 are two fitted parameters.

      rps_i is 0 or 1 to fit individual or zone common profil mixing parameter for pseudo-voigt profile.

   Note dmp and mrq are respectively the damping and Marqward Levenberg factors.
}
var
  ior: integer;
  pk:  pck_ptr;

begin
  with hkl_parm, pz^ do
  begin
    if (not bpck) or (bkm_i = 2) then                   { When the background must be fitted ... }
      for i := 1 to fbk_n + 1 do                        { ... we start from the previous fitted values }
        ior := LSQ$NEW_VPARM( bcf[i], bcs[i] );         { We define the background parameters to fit }

    if bpck then
    begin
      if (rwm_i > 0) and pwd_f then
      begin
        ior  := LSQ$NEW_VPARM( zwid0, zswi0 );          { We define the global main width to fit }
        idgw := ior;                                    { Keep the width index }
        if rwm_i > 1 then
          ior := LSQ$NEW_VPARM( zwid1, zswi1 )          { Set the fit of TAN term }
      end;

      if (rps_i = 1) and pmx_f then
      begin
        ior  := LSQ$NEW_VPARM( zprf0, zspr0, 0.0,1.0 ); { We define the global first profil special parm }
        idsp := ior                                     { Can have second profil parm. (in future) depending of profil type }
      end;

      { Scan all peak of zone }
      pk := pckf;
      while pk <> nil do
        with pk^ do                                     { Loop for each peak in the zone (packet) }
        begin
          idthe := 0;
          idhig := 0;
          idpr0 := 0;
          idpr1 := 0;
          idwid := 0;

          if bth and pth_f then
            idthe := LSQ$NEW_VPARM( thpos, sthpo, thmin, thmax );       { Fit the reflection position }

          if phg_f then
            idhig := LSQ$NEW_VPARM(  heigh, shigh, 0.0, flt_max );      { Fit packet high }

          if pwd_f then
            if rwm_i <= 0 then idwid := LSQ$NEW_VPARM( width, swidt )
                          else idwid := idgw + 1;
          if (* (rps_i <= 0) and *) pmx_f then
          case ftyp of
            fnc_pvoigt:                                  { For Pseudo-Voigt we add the mixing parameter }
              if rps_i <= 0 then idpr0 := LSQ$NEW_VPARM( mixfc, smixf, 0.0, 1.0 )
                            else idpr0 := idsp;

          otherwise
          end;
          pk := znxt
        end
    end
  end;
end ZONE_DEF_FIT;


end RPWDATA_FIT.
