{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}


%include 'RPWSRC:rpwdata_env.pas' {, list_on};



const
  max_bck      =           512;                 { Maximum size for the background points table }

  debug        =          true;                 { Debug flag }

  gsc1         = 1.0/SQRT( LN( 2.0 ) );         { Constantes for Gaussian profile width }

  gsin         =  SQRT( pi/LN( 2.0 ) );         { Constantes for Gaussian profile integral }

  th2brr       =      0.5*inrd;                 { To convert 2*theta to Bragg angle in radian }

  ndt_msg = '*** RPW Error: RPW-bug: Cannot find the line reflection pattern array index.';




type
  drv_tab       =           flt_tab( max_bck ); { Table of bi-quadratic spline function derivates }


  { *** Define all integration local Setup/Pannel record types *** }

  bck_prmty = record                            { * Define the Background parameters context }
                vmx_r,                          { Rate of max. count range to decrease the hystogram count range up limit }
                vnx_r,                          { Maximum rate of total dots number to cancel from hystogram }
                stb_r,                          { Stability coefficient in sigma fraction }
                dr2_r,                          { Maximum magnitude of negative 2th derivate of background }
                lfl_t,                          { Low regular/flat limit of background in 2*theta unit }
                ufl_t,                          { Up regular/flat limit of background in 2*theta unit }
                tw0_t,                          { Maximum of dot width to suppress a background it }
                tw1_t,                          { Modificator Tangent factor for thw_t }
                den_r,                          { Minimum rate of pattern dot density for a bck dot }
                dbd_t,                          { Distance between two consecutive background dots }
                cto_t,                          { Continuity tolerance (in 2theta degrees)) for successive hystogram }
                wdm_t:            real;         { Minimum size of hystogram domain (2*theta degrees unit) }
                hys_n,                          { Size of hystogram to use }
                bmi_n:         integer;         { Minimal number of background dots to shift change hystogram det }
                bdb_f:         boolean          { The debug Flag to help to set the setup }
              end;

  ref_prmty = record                            { * Define the Reflection searching parameters context }
                rfe_r,                          { Reflection Edge detection rate (of sigma background) }
                rft_r,                          { Reflection top detection rate (of sigma background) }
                rw0_t,                          { Minimum width of reflection (cte. in 2*theta �) }
                rw1_t,                          { Tan( theta ) factor for : rw = rw0_t + rw1*tan( theta ) }
                sp0_r,                          { Profil specific parameter #0 for auto. profile }
                sp1_r:            real;         { Profil specific parameter #1 for auto. profile }
                rmr_n,                          { Reflection Margin to add at the domain when it is possible }
                rmd_n,                          { Minimum number of dot to define a reflection }
                rsp_n:         integer;         { Minimum number of dot between two maximum }
                rdb_f:         boolean          { The debug Flag to help to set the setup }
              end;


  pro_prmty = record                            { * Define the Process Integration parameters context }
                dmp_r,                          { Damping factor }
                mid_r:            real;         { Minimum diagonal value }
                cym_n,                          { Maximum number of cycles of Least-Squares }
                fmd_i:         integer;         { Fit mode }
                ddy_f,                          { Flag for dynamic fitted curve display }
                mxd_f,                          { The mxd output mode flag }
                sea_f,                          { The auto search reflection flag }
                smo_f,                          { The smooth background flag }
                ful_f,                          { Full Data parameters output flag }
                idb_f:         boolean          { The debug Flag to help to set the setup }
              end;


[external]
var
  phase_curr:                  integer;         { Current working phase }

  zone_free,                                    { Peak Zone free list }
  zone_first,                                   { Peak Zone List header }
  zone_last:                   zon_ptr;

  peak_curr,                                    { Current peak/packet }
  peak_free,                                    { Peak/packet free list }
  peak_first,                                   { Peak/packet List header }
  peak_last:                   pck_ptr;

  fitcmp_crv,                                   { Current fitted curve pattern curve }
  bckgrd_crv:                  crv_ptr;         { Current background pattern curve }

  bckspl_dr2:                  drv_tab;         { 2th derivate for spline smoothing }
  bckspl_flg:                  boolean;         { To flag the performed smooth }

  bck_parm:                  bck_prmty;         { Setup for background }
  ref_parm:                  ref_prmty;         { Setup for reflection search }
  pro_parm:                  pro_prmty;         { Setup for automatic integration process }
  hkl_parm:                  hkl_prmty;         { Setup for reflection integration }
  idx_parms: array[1..Max_Phase] of idx_prmty;  { Setups for each possible crystallographic phases data parameters }

  fitcmp_cnp,

  filnbr,                                       { Current Output file number }
  idgw,                                         { Identifier base for global width parameter fit }
  idsp,                                         { Identifier base for global profile specific parameter fit }
  curr_ind:                    integer;         { Current pattern dot index }
(*
  fitflg:                   fit_flagty;         { Fit mode flag (as a equivalent set) }
*)

  bfitini,                                      { Flag for first fit cycles }
  bprocess:                    boolean;         { Flag the auto process mode }



  outint:                         text;         { Output for integration results }



procedure BACKGRND$DEFAULT_SETUP; external;

procedure SEARCH$DEFAULT_SETUP; external;
(*
procedure COMPUTE$DEFAULT_SETUP; external;
*)
procedure DELETE_CURVES; external;

function  LOCATE_ANGLE( ang, tol: real; isc: Dint := 1; brg, bif: boolean := false ): integer;
external;

procedure MOVE_PEAK_POS( pk: pck_ptr; fhkl: mrk_flgtyp := [] ); external;

procedure ADJUST_PEAK_POS( pz: zon_ptr; fhkl: mrk_flgtyp := [] ); external;

procedure SORT_PEAK; external;

