{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module RPW_BACKGROUND;

%include 'RPWSRC:rpwdata_int_env' {, list_on};

const
  { Default paparemeter values for Background analyse (by hystogram algorythme) }
  bck_prmdef = bck_prmty[          0.8,         { vmx_r: Rate of max. count range to decrease the hyst. count range up limit }
                                   0.1,         { vnx_r: Maximum rate of total dots number to cancel from hystogram }
                                   2.5,         { stb_r: Stability coefficient in sigma fraction }
                                   0.0,         { dr2_r: Maximum magnitude of negative 2th derivate of background }
                                   5.0,         { lfl_t: Low Regular or flat limit of background in 2*theta unit }
                                   0.0,         { ufl_t: Up Regular or flat limit of background in 2*theta unit }
                                   5.0,         { tw0_t: Maximum of dot width to suppress a background dot }
                                   0.0,         { tw1_t: Tan factor for : tw = tw0_t + tw1*tan( theta ) }
                                   0.7,         { den_r: Minimum rate of pattern dot density for a bck dot }
                                   2.5,         { dbd_t: Minimum Distance between two succesive background dots }
                                   0.5,         { cto_t: Size of overlay (in 2theta �) for successive hystogram }
                                   5.0,         { wdm_t: Minimum size of hystogram domain (2*theta degrees unit) }
                                   128,         { hys_s: Size of hystogram to use }
                                     5,         { bmi_n: Min. number of background dots to shift change hystogram det. }
                                 false          { bdb_f: The debug flag }
                        ]; 


[global]
var
  fitcmp_crv,                                   { Current fitted curve pattern curve }
  bckgrd_crv:           crv_ptr := nil;         { Current background pattern curve }

  bckspl_dr2:                  drv_tab;         { 2th derivate for spline smoothing }
  bckspl_flg:       boolean :=   false;         { To flag the performed smooth }

  bcf,                                          { Array to keep fitted polynome factor values and ... }
  bcs:                         fpa_tab;         { ... related sigma }

  bck_parm: bck_prmty  :=   bck_prmdef;         { Setup for background }






[global]
procedure BCK$DEFAULT_SETUP;
var
  bck_desc: [static] pdsc_tab( 15 ) := [ 0, 'Background Generation Parameters',  90, 140, [
                               [ 'Vmx_r : Max. count rate of count-step',   60, 124, 25,  5, prm_flt, nil, 0.0,  1.0, 0.01 ], {  1 }
                               [ 'Vnx_r : Min. of dots by bck def.',        60, 116, 25,  5, prm_flt, nil, 0.0,  1.0, 0.01 ], {  2 }
                               [ 'Stb_r : sigma fc to keep point',          60, 108, 25,  5, prm_flt, nil, 0.0, 20.0, 0.01 ], {  3 }
                               [ 'Dr2_r : Rt. of Max |d2-bck/d-th2|',       60, 100, 25,  5, prm_flt, nil, 0.0, 10.0, 0.01 ], {  4 }
                               [ 'Lfl_t : Low 2th. lim. for d2 test',       60,  92, 25,  5, prm_flt, nil, 0.0, 60.0, 0.01 ], {  5 }
                               [ 'Ufl_t : Upper 2th. lim. for d2 test',     60,  84, 25,  5, prm_flt, nil, 0.0,180.0, 0.01 ], {  6 }
                               [ 'Tw0_t : Thw width cte. part lim.',        60,  76, 25,  5, prm_flt, nil, 0.0, 50.0, 0.01 ], {  7 }
                               [ 'Tw1_t : Fac. of tan(th) for Thw',         60,  68, 25,  5, prm_flt, nil, 0.0,  1.0, 0.01 ], {  8 }
                               [ 'Den_r : Min. pattern dot density',        60,  60, 25,  5, prm_flt, nil, 0.0,  1.0, 0.01 ], {  9 }
                               [ 'Dbd_t : Min. 2th. dist between 2 dot',    60,  52, 25,  5, prm_flt, nil, 0.0, 20.0, 0.01 ], { 10 }
                               [ 'Cto_t : Hyst. Cont. tol. (2th)',          60,  44, 25,  5, prm_flt, nil, 0.0,  1.0, 0.01 ], { 11 }
                               [ 'Wdm_t : Hyst. Width region (2th)',        60,  36, 25,  5, prm_flt, nil, 0.5, 25.0, 0.01 ], { 12 }
                               [ 'Hys_s : hystogram size',                  60,  28, 25,  5, prm_int, nil,  32, 4096 ], { 13 }
                               [ 'Min_d : Min of dots/bck. point.',         60,  20, 25,  5, prm_int, nil,   3,   50 ], { 14 }
                               [ 'Debug : Debug to help for setting',       80,  12,  5,  5, prm_bool, nil           ]  { 15 }
                           ] ];

  binit:     [static] boolean := true;

begin
  if binit then
  begin
    with bck_desc, bck_parm do
    begin
      SET_REF( tb[ 1].rf, vmx_r );
      SET_REF( tb[ 2].rf, vnx_r );
      SET_REF( tb[ 3].rf, stb_r );
      SET_REF( tb[ 4].rf, dr2_r );
      SET_REF( tb[ 5].rf, lfl_t );
      SET_REF( tb[ 6].rf, ufl_t );
      SET_REF( tb[ 7].rf, tw0_t );
      SET_REF( tb[ 8].rf, tw1_t );
      SET_REF( tb[ 9].rf, den_r );
      SET_REF( tb[10].rf, dbd_t );
      SET_REF( tb[11].rf, cto_t );
      SET_REF( tb[12].rf, wdm_t );
      SET_REF( tb[13].rf, hys_n );
      SET_REF( tb[14].rf, bmi_n );
      SET_REF( tb[15].rf, bdb_f )
    end;
    setup_tab[BCK_IDX] := bck_desc"address;
    binit := false
  end;
  bck_parm := bck_prmdef;
  bckgrd_crv := nil;
end BCK$DEFAULT_SETUP;



procedure BLT_BCKSPLINE;
var
  j, n:                  integer;
  lg, pv, sg:               real;
  vec: array[1..max_bck] of real;

begin
  if bckgrd_crv <> nil then
  with bckgrd_crv^ do
  begin
    n := crv_sz;
    bckspl_dr2[1]  :=      0.0;
    vec[1]         :=      0.0;
    j := 3;
    for i := 2 to n - 1 do
    begin
      lg := crv_tab[j+2] - crv_tab[j-2];
      sg := (crv_tab[j] - crv_tab[j-2])/lg;
      pv := sg*bckspl_dr2[i-1] + 2.0;
      bckspl_dr2[i] := (sg - 1.0)/pv;
      vec[i] := (crv_tab[j+3] - crv_tab[j+1])/(crv_tab[j+2] - crv_tab[j]) -
                (crv_tab[j+1] - crv_tab[j-1])/(crv_tab[j] - crv_tab[j-2]);
      vec[i] := (6.0*vec[i]/lg - sg*vec[i-1])/pv;
      j := j + 2
    end;

    bckspl_dr2[n] := 0.0;
    for i :=  n - 1 downto 1 do
      bckspl_dr2[i] := bckspl_dr2[i]*bckspl_dr2[i+1] + vec[i];
  end
end BLT_BCKSPLINE;



function BCK_SPLINE( xx: real ): real;
var
  re, de, va, vb: real;
  ii, ij, il, ir: integer;

begin
  with bckgrd_crv^ do
  begin
    il := 1;
    ir := crv_sz;
    while ir - il > 1 do
    begin
      ii := (il + ir) div 2;
      if crv_tab[2*ii-1] > xx then ir := ii
                              else il := ii
    end;
    ij := 2*il;
    de := crv_tab[ij+1] - crv_tab[ij-1];
    va := (crv_tab[ij+1] - xx)/de;
    vb := (xx - crv_tab[ij-1])/de;
    re := va*crv_tab[ij] + vb*crv_tab[ij+2] +
          (va*(SQR( va ) - 1.0)*bckspl_dr2[il] +
           vb*(SQR( vb ) - 1.0)*bckspl_dr2[ir])*SQR( de )/6.0
  end;
  BCK_SPLINE := re
end BCK_SPLINE;



procedure SET_BACKGROUND_CURVE( len: integer );
var
  ii: integer;

begin
  if bckspl_flg then DELETE_CURVES;                     { When A spline smoothing was done ... }
                                                        { ... we delete any previuosly existing background curve }
  if bckgrd_crv = nil then
    { NEW_CURVE( size, ide, line_color, marker_color, line_kind, marker_kind, line color, marker_color ) }
    bckgrd_crv := NEW_CURVE( len, 1, 2, 3, 1, 1, 2.0, 7.0 )     { Create the Background curve record }
  else UPDATE_CURVE( bckgrd_crv, len )                          { Update Background curve record }
end SET_BACKGROUND_CURVE;



procedure BCK_BY_HYSTOGRAM( pp:                    pat_ptr;     { Pattern to evaluate }
                            ifrs, ilst:       integer := 0;     { Pattern left and right limit indexes }
                            vmin, vmax, vwid: real := -1.0 );   { Count limits and backgr dot width }

{
   Build a background line for an area of diffraction pattern.
   The pattern dots must be sorted in increasing 2*theta odering.
}

type
  h_entry = record                                      { * Define an hystogram entry record type }
              nn,                                       { Dots count }
              lk:     integer                           { Link to first dot list element }
            end;

  h_tab( len: integer ) = array[0..len] of h_entry;     { * Define the entry table type }

  h_ltb( ll, lu: integer ) = array[ll..lu] of integer;  { * Define dot the link table type }

  bdt_ptr = ^ bdt_rec;                                  { * Define a background dot record pointer }

  bdt_rec = record                                      { * Define a background dot record }
              next,                                     { Link to next and to previous background dot record }
              prev:                    bdt_ptr;
              flnb:                    integer;         { Validity flag and dot count }
              th2v,                                     { Background theta }
              th2w,                                     { Background dot dispersion width }
              thmx,                                     { The hight value of theta }
              bckv,                                     { Background sigma }
              bcks:                       real          { Background sigma }
            end;

  bhe_rec = record                                      { * Define background hystogram evaluation record }
              bhe_the,                                  { Center evaluation position }
              bhe_cfa, bhe_bck,                         { Background Line coeficients, and background value }
              bhe_max, bhe_sig,                         { Background peak count and related sigma }
              bhe_lfw, bhe_rfw,                         { Left and right back. peak half width }
              bhe_rem, bhe_eff:           real          { Hystogram remainder at low counts }
            end;



var
  hys_lim, hys_tsz,                                     { Hystogram size and 2*theta elements number }
  hys_frs, hys_lst:     [static] integer := -1;
  hys_bck, hys_bsg,                                     { First_approximation/minimum background value and sigma }
  hys_tmi, hys_tma, hys_tst,                            { Hystogram Minimum, maximum and step on 2*theta }
  hys_cmi, hys_cma, hys_cst,                            { Hystogram Minimum, maximum and step on counts }
  hys_wid, hys_den:            [static]   real;         { Domain 2*theta width, Hyst 2*theta step, Angular density }

  ib, id, ii, il, im, it, iu, nc, nd:  integer;
  bv, bs, tv, te, th, tm, tn, va, vl:     real;
  evl:                                 bhe_rec;         { Hystogram context record }
  hs:                                   ^h_tab;         { Pointer to the hystogram sum table }
  hl:                                   ^h_ltb;         { Pointer to the table of hystogram do link }

  bb, be, bp, b0, b1, b2, b3,                           { Background current dot pointers }
  bfrs,                                                 { Background dots list header }
  blst:                                bdt_ptr;         { The BCK-Dot list must be initialized on each call }

  xx, yy:                  array[1..3] of real;         { To keep the memory of three background dots }

  ch:                                     char;



  function  BDT_NEW( bfirst: boolean := false ): bdt_ptr;
  var
    p: bdt_ptr;

  begin
    NEW( p );
    with p^ do
    begin
      if bfirst then
      begin
        next := bfrs; prev := nil;
        if blst = nil then blst := p
                      else bfrs^.prev := p;
        bfrs := p
      end
      else
      begin
        next :=  nil; prev := blst;
        if bfrs = nil then bfrs := p
                      else blst^.next := p;
        blst := p
      end
    end;
    BDT_NEW := p
  end BDT_NEW;



  procedure BDT_FREE( p: bdt_ptr );
  { Procedure to supress a bck dot }
  begin
    if p <> nil then
    with p^ do
    begin
      if bfrs = p then bfrs := next;
      if blst = p then blst := prev;
      if prev <> nil then prev^.next := next;
      if next <> nil then next^.prev := prev
    end;
    DISPOSE( p )
  end BDT_FREE;



begin { BCK_BY_HYSTOGRAM }
  if ifrs   >  0 then hys_frs := ifrs; 
  if ilst   >  0 then hys_lst := ilst; 
  if vmin >= 0.0 then hys_cmi := vmin;
  if vmax >= 0.0 then hys_cma := vmax;
  if bck_parm.hys_n < 32 then bck_parm.hys_n := 32;

  hys_lim := bck_parm.hys_n - 1;                        { Set the Hystogram size to use }
  hys_cst := (hys_cma - hys_cmi)/bck_parm.hys_n;        { Set the hystogram count step increment }
  hys_tmi := pp^.dat[hys_frs].theta;
  hys_tma := pp^.dat[hys_lst].theta;
  hys_wid := hys_tma - hys_tmi;
  hys_tsz := TRUNC( hys_wid/bck_parm.wdm_t );
  if hys_tsz < 2 then hys_tsz := 2;                     { The minimum for background is two Dots }
  hys_tst := hys_wid/hys_tsz;
  hys_den := (hys_lst - hys_frs + 1)/hys_wid;
  bfrs := nil; blst := nil;                             { Init the BCK dot list header }

  NEW( hl, hys_frs, hys_lst );                          { Allocate the hystogram Link table }
  NEW( hs, hys_lim );                                   { Allocate the sum hystogram table }

  with evl, bck_parm, pp^ do
  begin
    cto_t   := ABS( cto_t );

    if bmi_n < 4 then bmi_n := 4;                       { Force a minimum value for bmi_n parameter }
    for ij := 0 to hys_lim do                           { Init the hystogram sum table }
      with hs^[ij] do begin  nn := 0; lk := 0  end;

    { *** First Step: Size the Pattern Background and sigma *** }

    { Build the total hystogram }
    ii := 0;                                            { Init the valid total pattern dot count }
    for ip := hys_frs to hys_lst do                     { Loop on all pattern dots }
    with dat[ip] do
      if not (mk_invalid in mflg) and
         (int >= hys_cmi) and (int < hys_cma) then      { We exclude all invalid dots }
      begin
        ii := ii + 1;                                   { Make the total count pattern dot count }
        id := TRUNC( (int - hys_cmi)/hys_cst );         { Compute the hystogram count index }
        if (id >=0) and (id <= hys_lim) then            { Check for limits }
          with hs^[id] do
          begin
            hl^[ip] := lk;                              { Save the index of the previous pattern dot and ... }
            lk := ip;                                   { ... keep here the last point index }
            nn := nn + 1                                { Update the dot count }
          end
      end;

    if (ii > 0) and (hys_wid > 1.0) then
      hys_den := ii/hys_wid                             { Set the density of valid dots }
    else
    begin
      WRITELN( str_msg, '*** RPW Error: Cannot find some valid pattern dot. ***' );
      goto E_STOP
    end;

    { Search for a first approximation background value }
    ib := 0;
    for ij := 0 to hys_lim do
      if (ib = 0) and (hs^[ij].nn >= bmi_n) then ib := ij;

    bv := 0.0;
    bs := 0.0;
    if ib < hys_lim then
    begin
      nd := 0;
      if ib > 0 then                                    { When some significant number of dots are located in the ... }
        if hs^[ib-1].nn > bmi_n div 2 then              { ... previous hystogram block, we add these dots. }
        begin
          with hs^[ib-1] do begin  nd := nn; iu := lk  end;
          repeat                                        { Loop on all dot of this Hystogram index }
            with dat[iu] do
            begin
              bv := bv + int; bs := bs + SQR( int )
            end;
            iu := hl^[iu]
          until iu = 0
        end;

      with hs^[ib] do begin  nd := nd + nn; iu := lk  end;
      repeat                                            { Loop on all dot of this Hystogram index }
        with dat[iu] do
        begin  bv := bv + int; bs := bs + SQR( int )  end;
        iu := hl^[iu]
      until iu = 0;
      hys_bck := bv/nd;                                 { Compute the basic global background value ... }
      hys_bsg := SQRT( ABS( bs/nd - SQR( hys_bck ) ) )  { ... and its standard error }
    end
    else
    begin
      WRITEV( str_msg, '*** RPW Error: Cannot find the global background. ***' );
      goto E_STOP
    end;

    { Search the best count limits for the hystogram }
    va := hys_cmi + (hys_lim + 1)*hys_bsg;              { Find the ideal related maximum count }
    if va - hys_bck < vmx_r*(hys_cma - hys_bck) then va := vmx_r*(hys_cma - hys_bck) + hys_bck;
    il := TRUNC( (va - hys_cmi)/hys_cst );              { Compute the maximum reduction of pattern point in count value }
    im := hys_lst - hys_frs + 1;                        { Get the total number of pattern dots }
    iu := hys_lim;
    nd :=       0;
    while (iu > il) and (nd < TRUNC( vnx_r*im )) do     { Loop to search optimal reduction of dots }
    begin  nd := nd + hs^[iu].nn;  iu := iu - 1  end;   { Sum the number of dots }
    if iu > il then va := (iu + 1)*hys_cst + hys_cmi;   { If too many dots are out of range, retake some of them }
    hys_cma := va;
  { hys_cst := TRUNC( (hys_cma - hys_cmi)/(hys_lim + 1) ); }
    hys_cst := (hys_cma - hys_cmi)/(hys_lim + 1);

    if bdb_f then
    begin
      WRITELN( ' *** Look for the best Background ***' );
      WRITELN( ' We work with :' );
      WRITELN( '   PARAM: P bmi_n = ', bmi_n:0, ', vmx_r = ', vmx_r:6:3, ', vnx_r = ', vnx_r:6:3 );
      WRITELN( '   H-Area = ', hys_frs:0, '..', hys_lst:0, ' Region density = ', hys_den:8:4 );
      WRITELN( '   H-CMAX = ', hys_cma:10:1, ', H-CMIN = ', hys_cmi:10:1, ', H-SIZE = ', hys_n:5 );
      WRITELN( '   H-TMIN = ', hys_tmi:8:3, ', H-TMAX = ', hys_tma:8:3, ', H-CTO = ', cto_t:6:3 );
      WRITELN( '   H-WID  = ', hys_wid:8:2, ', H-CSTP = ', hys_cst:10:1, ', H-LIM = ', hys_lim:6 );
      WRITELN( '   H1-BCK = ', hys_bck:8:1, 'R(', hys_bsg, ') evalued with ', nd:0, ' dots.' );
      WRITELN
    end;


    { *** Second Step: Build the complete Hystogram *** }

    { Create and init the hystogram and result table }
    nc :=       0;                                      { Init the Background dot count }
    th := hys_tmi;                                      { Set the 2*theta angle of first area begining }
    it := hys_frs;                                      { Set the Start hystogram area pattern index }
    ii :=       0;

    repeat
      th := hys_tmi + ii*hys_tst;                       { Set the end 2*theta of current hystogram area }
      if th + 0.5*hys_tst > hys_tma then th := hys_tma; { Extend the final area to do not make a too small area }

      for ij := 0 to hys_lim do                         { Loop to clear the hystogram table }
        with hs^[ij] do begin  nn := 0; lk := 0  end;

      while it <= hys_lst do                            { Loop on all dots of hystogram area }
      with dat[it] do
      begin
      exit if theta > th;                               { Stop area loop when current_2*theta > end_2*theta }
        if not (mk_invalid in mflg) and
           (int >= hys_cmi) and (int < hys_cma) then    { We exclude all invalid dots }
        begin
          id := TRUNC( (int - hys_cmi)/hys_cst );       { Compute the hystogram count index }
          if id <= hys_lim then
          with hs^[id] do
          begin
            hl^[it] := lk;                              { Save the index of the previous pattern dot and ... }
            lk := it;                                   { ... keep here the last point index }
            nn := nn + 1                                { Update the dot count }
          end
        end;
        it := it + 1                                    { Update index of pattern dot }
      end;

      { Look for possible significant background dot }
      ib := 0;
      while (ib <= hys_lim) and (hs^[ib].nn < bmi_n) do ib := ib + 1;

      if ib <= hys_lim then
      begin
        nd :=   0; bv := 0.0; bs := 0.0;                { Init summation to compute background value and 2*theta ... }
        tv := 0.0; tm := 0.0; tn := 0.0;                { ... with related standard error/2*theta repartition }

        if ib > 0 then                                  { When some significant number of dots are located in the ... }
          if hs^[ib-1].nn > bmi_n div 2 then            { ... previous hystogram block, we add these dots. }
          begin
            iu := hs^[ib-1].lk;
            repeat                                      { Loop on all dot of this Hystogram index }
              with dat[iu] do
              begin                                     { Sum for Count and 2*theta of background dots with std. errors }
                bv := bv + int;   bs := bs + SQR( int );
                tv := tv + theta;
                if nd = 0 then begin  tm := theta; tn := tm  end
                               else if tm > theta then tm := theta
                                                  else if tn < theta then tn := theta
              end;
              nd := nd + 1;
              iu := hl^[iu]
            until iu = 0
          end;

        iu := hs^[ib].lk;                               { Get the number and the head index list of pattern dot }
        repeat                                          { Loop on all dot of this Hystogram index }
          with dat[iu] do
          begin                                         { Sum for Count and 2*theta of background dots with std. errors }
            bv := bv + int;   bs := bs + SQR( int );
                tv := tv + theta;
                if nd = 0 then begin  tm := theta; tn := tm  end
                               else if tm > theta then tm := theta
                                                  else if tn < theta then tn := theta
          end;
          nd := nd + 1;
          iu := hl^[iu]
        until iu = 0;

        if nd/(tn - tm) >= den_r*hys_den then           { Density test }
        begin
          bp := nil;                                    { Assume dot to create }
          if blst <> nil then
          with blst^ do
            if (ABS( bckv - bv/nd ) <= stb_r*bcks) and  { Compatible background count and ... }
               (tm - thmx <= cto_t) then                { ... compatible angle continuity }
            begin                                       { We Update the previous BCK dot }
              ch := 'U';
              nd := nd + flnb;                          { Update the total number of pattern dots }
              th2w := tn - (thmx - th2w);               { Set new width and new 2*theta max }
              thmx := tn;
              th2v := (th2v*flnb + tv)/nd;              { Set the new 2*theta }
              bs := bs +flnb*(SQR( bcks )+SQR( bckv )); { For summ of int**2 }
              bckv := (bv + bckv*flnb)/nd;
              bcks := SQRT( ABS( bs/nd - SQR( bckv ) ) );
              flnb := nd;
              bp := blst                                { Flag as OK }
            end;

          if bp = nil then
          begin
            bp := BDT_NEW;                              { Allocate a new dot pointer }
            with bp^ do
            begin
              ch := 'N';
              flnb := nd;                               { Save the used number of pattern dots }
              bckv := bv/nd;                            { Get the Minimum/background dots coordinates with std. errors }
              bcks := SQRT( ABS( bs/nd - SQR( bckv ) ) );
              th2v := tv/nd; th2w := tn - tm; thmx := tn;
              if (bp = bfrs) or (hys_bck > bckv) then
              begin  hys_bck := bckv; hys_bsg := bcks  end
            end;
            nc := nc + 1
          end;

          if bdb_f then
            with bp^ do
              WRITELN( ' ', ch, ' - ', nc:3, ' : ', ii:3, ' / ', th2v:8:3, '[', th2w:7:3, '], ', bckv:10:1, '(', bcks:8:1,
                       ') with ', flnb:0, ' dots and rdens = ', flnb/th2w/hys_den:8:4 )
        end
        else
          if bdb_f then
            WRITELN( ' Rejected : ', ii:3, ' in  [', tm:8:3, '..', tn:8:3, '], ', bv/nd:10:1,
                       ' with ', nd:0, ' dots and rdens = ', nd/(tn - tm)/hys_den:8:4 )

      end;
      ii := ii + 1
    until (th > hys_tma) or (it > hys_lst);             { End of loop to create the background dots }


    { *** Third Step: Elliminate the bad background dots *** }

    { In first we must locate the process limits specified by the parameters lfl_t and ufl_t }
    bb := nil; be := nil;
    if bfrs <> nil then
    begin
      bb := bfrs;
      if lfl_t > 0.0 then                               { Locate the first dot to analyse - all dots are valid }
      begin
        bp := bfrs;
        while (bp <> nil) and (bp^.th2v < lfl_t) do
        begin  bb := bp; bp := bp^.next  end
      end;
      if blst <> nil then
      begin
        be := blst;
        if ufl_t > 0.0 then                             { Locate the last dot to analyse - all dots are valid }
        begin
          bp := blst;
          while (bp <> nil) and (bp^.th2v > ufl_t) do
          begin  be := bp; bp := bp^.prev  end
        end
      end
    end;



    { We must suppress all not large (in 2*theta) increasing dot from BCK list }

    if (bb <> nil) and (be <> bb) then
    begin { * For a list with a minimum of two dots }
      with bb^ do
      begin
        bv := bckv; bs := bcks; bp := next              { Get the first dot coordinates }
      end;

      while bp <> nil do
      with bp^ do                                       { Loop on each following dot }
      begin
        tm := tw0_t + tw1_t*TAN( th2v*th2brr );
        b0 := nil;
        if (bckv > bv) and (th2w < tm) then             { When the new dot as an upper background that ... }
                                                        { ... the previous one and it is not a large width dot. }
          if bckv - stb_r*bcks > bv then                { The dot must be set as invalid when it is (above) ... }
          begin                                         { ... out of stb_s*sigma tolerance }
            b0 := bp;
            if bdb_f then
              WRITELN( ' Inval. >  ', th2v:8:3, '(', th2w:8:3, '), ', bv:10:1, ' >> ', bckv:10:1,
                       ' with sg = ', bcks:8:1, '*', stb_r:7:2 )
          end;

        bp := next;
        if b0 = nil then
          begin  bv := bckv; bs := bcks  end            { Test passed, the dot becomes the new reference. }
        else
          begin                                         { Dot to supress }
            if b0 = be then                             { When this dot is the last to analyse, we leave ... }
            begin  be := prev; bp := nil  end;          { ... bl to be the previous one and stop the loop }
            BDT_FREE( b0 )                              { Supress the dot }
          end
      end;

      { Loop to keep only background dot with a second derivation >= constant }

      if (be <> bb) and (be <> bb^.next) then           { When we have a minimum of three dots }
      begin
        b0 := bb;                                       { Start Main loop from the first dot <bf^> ... }
        while (b0 <> be^.prev) and (b0 <> nil) do
        begin                                           { ... Where <b0^> is the begin of line segment }
          with b0^ do
          begin                                         { Get the start of line segment coordinates }
            th := th2v;
            hys_bck := bckv; hys_bsg := bcks;
            bp := next                                  { Start examination with dot just after the line segment begin }
          end;
        exit if bp = nil;
          b1 := bp^.next;                               { Start with the end of segment as the third dot }
          while b1 <> nil do
          begin                                         { Loop on the end of line segment dot (b1^) }
            with b1^ do
            begin
              tv := th2v - th;                          { Keep the 2*theta interval }
              va := (bckv - hys_bck)/tv;                { Get the line equation y = va*x + vl }
              vl := bckv - va*th2v
            end;
            repeat                                      { Loop on the examination dot }
              b2 := nil;                                { Assume that the dot must be kept until shown otherwise }
              with bp^ do
              begin
                tm := tw0_t + tw1_t*TAN( th2v*th2brr ); { Get the effective value of thw_t }
                bv := va*th2v + vl;                     { Compute the high of right line for this 2*theta }
                { For a not large 2*theta dot upper the background line, We mark it for suppression }
                if (bckv > bv) and (th2w < tm) then
                  if (bckv - bv) > bv*tv*dr2_r then b2 := bp;
                bp := next
              end;

              if bdb_f and (b2 <> nil) then
              with b2^ do
                WRITELN( ' Inval. d2 ', th2v:8:3, '(', th2w:8:3, '), ',
                         (bckv - bv)/bv/tv:10:4, ' >> ', dr2_r:10:4 );

              if b2 <> nil then BDT_FREE( b2 )          { Suppress the dot }
            until (bp = b1) or (bp = nil);              { Loop stop when all the dot between b0^ and b1^ are scanned }
          exit if b1 = be;
            b1 := b1^.next                              { Skip to next dot as the extremity of line }
          end;                                          { The end of loop muste be after the use of last dot }
          b0 := b0^.next                                { Skip to next <b0^> dot as the begin of the segment line }
        end;
      end
    end;

    { Invalidate any too close (in 2*theta) dots }
    if (bfrs <> nil) and (bfrs^.next <> nil) then
    begin
      bp := bfrs;
      b0 := bfrs;
      with bfrs^ do
      begin  th := th2v; bv := bckv; bp := next  end;
      while bp <> nil do
      with bp^ do
      begin
        if ABS( th2v - th ) <= dbd_t then
        begin
          if bckv > bv then b1 := bp
                       else begin  th := th2v; b1 := b0; b0 := bp  end;
        end
        else begin  th := th2v; b0 := bp; b1 := nil  end;
        bp := next;
        if b1 <> nil then BDT_FREE( b1 )
      end
    end;

    { Get the three first dots to create (insert) the first point on the same quadratic }
    if bfrs <> nil then
    begin                                                { Get the first three point }
      bp := bfrs;
      ii := 0;
      while (bp <> nil) and (ii < 3) do
        with bp^ do
        begin
          ii := ii + 1; xx[ii] := th2v; yy[ii] := bckv; bp := next
        end;
      { Check for too similar conxecutive dots }
      tv := xx[3] - xx[2];
      if (ii = 3) and ABS( tv ) < 1.0e-2 then
      begin  ii := 2; xx[2] := xx[3]; yy[2] := yy[3]  end;
      tn := xx[2] - xx[1];
      if (ii = 2) and (ABS( tn ) < 1.0e-2) then ii := 1
    end
    else ii := 0;

    { Perform the extrapolation }
    case ii of
      0: bv := hys_bck;
      1: bv := yy[1];
      2: bv := (yy[2] - yy[1])*(hys_tmi - xx[1])/(xx[2] - xx[1]) + yy[1];
    otherwise { or 3 }
      va := ((yy[3] - yy[2])/(xx[3] - xx[2]) - (yy[2] - yy[1])/(xx[2] - xx[1]))/(xx[3] - xx[1]);
      vl := (yy[2] - yy[1])/(xx[2] - xx[1]) - va*(xx[2] + xx[1]);
      bv := yy[1] + (hys_tmi - xx[1])*(vl + va*(hys_tmi + xx[1]))
    end;

    bp := BDT_NEW( true );                              { Insert the first dot }
    with bp^ do
    begin
      flnb  :=       1;
      bckv  :=      bv; bcks :=  hys_bsg;
      th2v  := hys_tmi; th2w :=      0.0;
    end;

    bp := BDT_NEW;                                      { Allocate the backgound dot to the list }
    with bp^ do
    begin
      flnb  :=       1;                                 { Set as a valid dot }
      bckv  := prev^.bckv;                              { Set with the same value that for the previous dot }
      bcks  := prev^.bcks;
      th2v  := hys_tma; th2w :=      0.0
    end;



    { *** Forth and Last Step: Put as the background curve *** }

    { Size the Background curve }
    bp := bfrs;
    nc := 0;
    with bckgrd_crv^ do
      while bp <> nil do                                { Loop on all background dots }
      with bp^ do
      begin  nc := nc + 1; bp := next  end;

    { Now Create the Background curve }
    SET_BACKGROUND_CURVE( nc );
    bp := bfrs;
    ii := 0;
    with bckgrd_crv^ do
      while bp <> nil do                                { Loop on all background dots }
      begin
        b0 := bp;
        with b0^ do
        if flnb > 0 then
        begin                                           { For each hystogram elements }
          ii := ii + 1; crv_tab[ii] := th2v;            { Copy all dots to background curve }
          ii := ii + 1; crv_tab[ii] := bckv + cshift;
          if bdb_f then
            WRITELN( ' BCK dot # ', ii div 2, ' / ', th2v:8:3, ' ', bckv:10:1, ' (', bcks:8:1, ')' )
        end;
        bp := bp^.next;                                 { Follows the list of curve dots }
        BDT_FREE( b0 )                                  { Free the dot allocation }
      end
  end;

E_STOP:
  DISPOSE( hs );                                        { Free allocation for hystogram table }
  DISPOSE( hl )                                         { Free the pattern dot link table }
end BCK_BY_HYSTOGRAM;



[global]
procedure INTEGR$SUPPRESS_BACKGROUND;                   { To supress a previously defined Background curve }
begin
  DELETE_CURVES
end INTEGR$SUPPRESS_BACKGROUND;



[global]
procedure INTEGR$SET_BACKGROUND( in_var bcktb: array[sz:integer] of Dfloat; len: Dint );
var
  ii: integer;

begin
  SET_BACKGROUND_CURVE( len );
  ii := 0;
  with bckgrd_crv^ do
    for ij := 1 to len do                               { Copy all dots to background curve }
    begin
      ii := ii + 1; crv_tab[ii] := bcktb[ii];
      ii := ii + 1; crv_tab[ii] := bcktb[ii]
    end;

  if fitcmp_crv <> nil then
  begin  DEL_CURVE( fitcmp_crv ); fitcmp_crv := nil  end
end INTEGR$SET_BACKGROUND;



[global]
function  INTEGR$BUILD_BACKGROUND: ^string;
begin
  str_msg.length := 0;
  if (sel_pat <> nil) and (sel_iright > sel_ileft) then
  with sel_pat^ do
    BCK_BY_HYSTOGRAM( sel_pat, sel_ileft, sel_iright, min, max );

  if fitcmp_crv <> nil then
  begin  DEL_CURVE( fitcmp_crv ); fitcmp_crv := nil  end;
  if str_msg.length > 0 then INTEGR$BUILD_BACKGROUND := str_msg"address
                        else INTEGR$BUILD_BACKGROUND := nil
end INTEGR$BUILD_BACKGROUND;



[global]
procedure INTEGR$SMOOTH_BACKGROUND;
var
  pc:          crv_ptr;
  st, x0, xc:     real;
  nsz, ii:     integer;
  pk:          pck_ptr;

begin
  if (bckgrd_crv <> nil) and (sel_pat <> nil) then
  with sel_pat^ do
  begin
    BLT_BCKSPLINE; { Build the Spline parameters }
    { Extend the curve size }
    nsz := 25*bckgrd_crv^.crv_sz;
    pc := NEW_CURVE( nsz, 1, 2, 3, 1, 0, 2.0, 1.0 );
    ii := 0;
    x0 := dat[sel_ileft].theta;
    st := (dat[sel_iright].theta - x0)/nsz;
    with pc^ do
      for ij := 0 to nsz - 1 do
      begin
        xc := x0 + ij*st;
        ii := ii + 1; crv_tab[ii] := xc;
        ii := ii + 1; crv_tab[ii] := BCK_SPLINE( xc )
      end;

    DEL_CURVE( bckgrd_crv );
    bckgrd_crv := pc
  end;
  bckspl_flg := true
end INTEGR$SMOOTH_BACKGROUND;




end RPW_BACKGROUND.
