/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[2];

/* Define the local data section. */
static Blk( Rd, 1784 ) = {
 12,  12, 105, 110, 105, 116,  95, 112,  97, 116, 116, 101, 114, 110,  60,  60,
 47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111,
102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 114, 112, 119,
100,  97, 116,  97,  95, 115, 114,  99,  47, 114, 112, 119, 100,  97, 116,  97,
 95, 105, 110, 112,  95, 111, 117, 116,  46, 112,  97, 115,  17,  17, 112,  97,
116, 116, 101, 114, 110,  95, 105, 110, 102, 111,  95,  99, 111, 112, 121,   9,
  9, 105, 110, 105, 116,  95, 108, 111,  97, 100,  21,  21, 115, 101, 116,  95,
112,  97, 116, 116, 101, 114, 110,  95, 115, 101, 108, 101,  99, 116, 105, 111,
110,  10,  10, 114, 112, 119, 102,  95, 101, 114, 114, 111, 114,  20,  20,  82,
101,  97, 100,  32,  80,  97, 116, 116, 101, 114, 110,  32, 102, 111, 114, 109,
 97, 116,  34,   9,   9,  34,  32, 101, 114, 114, 111, 114,  58,  32,   9,   9,
 82,  80,  87,  68,  65,  84,  65,  58,  32,  13,  13, 115, 107, 105, 112,  95,
105, 110, 112,  95,  99, 104,  97, 114,  13,  13, 101, 108, 108, 105, 109, 105,
110,  97, 116, 101,  95,  99, 114,  10,  10, 115, 107, 105, 112,  95, 115, 112,
 97,  99, 101,  12,  12, 103, 101, 116,  95, 110, 101, 119,  95, 108, 105, 110,
101,  12,  12, 103, 101, 116,  95, 111, 110, 101,  95, 119, 111, 114, 100,  17,
 17, 103, 101, 116,  95, 114, 112, 119, 115, 116, 100,  95, 102, 111, 114, 109,
 97, 116,   8,   8,  70,  80,  68,  95,  68,  65,  84,  65,  20,  20,  66,  97,
100,  32, 100,  97, 116,  97,  32, 102, 105, 108, 101,  32, 102, 111, 114, 109,
 97, 116,   3,   3,  69,  79,  70,   7,   7,  80,  65,  84,  84,  69,  82,  78,
 60,  60,  70, 111, 114, 109,  97, 116,  32, 101, 114, 114, 111, 114,  32,  58,
 32, 101,  97,  99, 104,  32, 112,  97, 116, 116, 101, 114, 110,  32, 109, 117,
115, 116,  32,  98, 101, 103, 105, 110,  32,  98, 121,  32, 116, 104, 101,  32,
 34,  80,  65,  84,  84,  69,  82,  78,  34,  32, 119, 111, 114, 100,  31,  31,
 73, 110,  99, 111, 109, 112, 108, 101, 116, 101,  32,  80,  97, 116, 116, 101,
114, 110,  44,  32,  69,  79,  70,  32, 114, 101,  97,  99, 104, 101, 100,   5,
  5,  76,  65,  66,  69,  76,   8,   8,  73,  68,  78,  85,  77,  66,  69,  82,
  5,   5,  78,  85,  77,  79,  82,   5,   5,  68,  65,  84,  69,  72,   6,   6,
 83,  65,  77,  80,  76,  69,   6,   6,  76,  65,  77,  66,  68,  65,   4,   4,
 84,  69,  77,  80,   7,   7,  77,  79,  78,  84,  73,  77,  69,  11,  11,  84,
 82,  65,  78,  83,  76,  65,  84,  73,  79,  78,   9,   9,  80,  65,  82,  65,
 77,  69,  84,  69,  82,  11,  11,  79,  82,  73,  69,  78,  84,  65,  84,  73,
 79,  78,   4,   4,  68,  65,  84,  65,  61,  61,  70, 111, 114, 109,  97, 116,
 32, 101, 114, 114, 111, 114,  32,  58,  32,  84, 119, 111,  32,  68,  65,  84,
 65,  32,  66,  76,  79,  67,  75,  32, 100, 105, 114, 101,  99, 116, 105, 118,
101, 115,  32, 102, 111, 114,  32, 116, 104, 101,  32, 115,  97, 109, 101,  32,
112,  97, 116, 116, 101, 114, 110,   3,   3,  69,  79,  68,   7,   7,  80,  65,
 84,  84,  69,  82,  78,   3,   3,  69,  79,  70,  14,  14, 103, 101, 116,  95,
100,  49,  98,  95, 102, 111, 114, 109,  97, 116,   3,   3,  68,  49,  66,   6,
  6,  45,  49,  48,  48,  48,  48,  14,  14, 103, 101, 116,  95, 120, 121, 100,
 95, 102, 111, 114, 109,  97, 116,   6,   6,  88,  89,  68,  65,  84,  65,   1,
  1,  35,   6,   6,  88,  89,  68,  65,  84,  65,   1,   1,  35,   5,   5,  73,
 78,  84,  69,  82,   4,   4,  84,  69,  77,  80,  11,  11,  84,  69,  77,  80,
 69,  82,  65,  84,  85,  82,  69,   7,   7,  77,  79,  78,  73,  84,  79,  82,
  6,   6,  76,  65,  77,  66,  68,  65,   7,   7,  76,  65,  77,  66,  68,  65,
 50,   7,   7,  76,  65,  77,  66,  68,  65,  82,   6,   6,  83,  65,  77,  80,
 76,  69,   5,   5,  68,  65,  84,  69,  72,   6,   6,  79,  82,  73,  69,  78,
 84,  16,  16, 103, 101, 116,  95, 105, 110, 108, 114, 120,  95, 102, 111, 114,
109,  97, 116,   6,   6,  73,  78,  69,  76,  82,  88,  15,  15, 103, 101, 116,
 95, 115, 114,  97, 119,  95, 102, 111, 114, 109,  97, 116,  12,  12, 103, 101,
116,  95, 112,  97, 116, 116, 101, 114, 110, 115,  38,  38,  32,  42,  42,  42,
 32,  82,  80,  87,  32,  69, 114, 114, 111, 114,  58,  32,  67,  97, 110, 110,
111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,
 32,  34,   6,   6,  34,  46,  32,  42,  42,  42,  62,  62,  32,  42,  42,  42,
 32,  82,  80,  87,  32,  69, 114, 114, 111, 114,  58,  32,  85, 110, 115, 117,
112, 112, 111, 114, 116, 101, 100,  32, 111, 114,  32, 117, 110, 105, 109, 112,
108, 101, 109, 101, 110, 116, 101, 100,  32, 105, 110, 112, 117, 116,  32, 102,
111, 114, 109,  97, 116,  46,  32,  42,  42,  42,  11,  11,  32,  82,  80,  87,
 32,  70, 111, 117, 110, 100,  32,  23,  23,  32, 112,  97, 116, 116, 101, 114,
110, 115,  32, 105, 110,  32, 116, 104, 101,  32, 102, 105, 108, 101,  32,  34,
  2,   2,  34,  46,  53,  53,  32,  42,  42,  42,  32,  82,  80,  87,  32,  69,
114, 114, 111, 114,  58,  32,  67,  97, 110, 110, 111, 116,  32, 119, 111, 114,
107,  32, 119, 105, 116, 104, 111, 117, 116,  32,  80,  97, 116, 116, 101, 114,
110,  32,  97, 110, 100,  32, 101, 120, 105, 116,  46,  17,  17,  71, 108, 111,
 98,  97, 108,  32,  83, 116,  97, 116, 105, 115, 116, 105,  99, 115,  38,  38,
 77, 105, 110, 105, 109, 117, 109,  32,  97, 110, 100,  32, 109,  97, 120, 105,
109, 117, 109,  32, 111, 102,  32,  50,  42,  84, 104, 101, 116,  97,  32,  65,
110, 103, 108, 101,  58,  32,   2,   2,  44,  32,  38,  38,  77, 105, 110, 105,
109, 117, 109,  32,  97, 110, 100,  32, 109,  97, 120, 105, 109, 117, 109,  32,
111, 102,  32,  84, 101, 109, 112, 101, 114,  97, 116, 117, 114, 101,  58,  32,
 32,  32,   2,   2,  44,  32,  38,  38,  77, 105, 110, 105, 109, 117, 109,  32,
 97, 110, 100,  32, 109,  97, 120, 105, 109, 117, 109,  32, 111, 102,  32, 105,
110, 116, 101, 110, 115, 105, 116, 105, 101, 115,  58,  32,  32,  32,   2,   2,
 44,  32,  11,  11, 111, 117, 116,  95, 112,  97, 116, 116, 101, 114, 110,  91,
 91,  32,  42,  42,  42,  32,  82,  80,  87,  32,  67, 111, 109, 109,  97, 110,
100,  32, 101, 114, 114, 111, 114,  32,  58,  32,  84, 104, 101,  32, 115, 112,
101,  99, 105, 102, 105, 101, 100,  32, 111, 117, 116, 112, 117, 116,  32, 102,
105, 108, 101,  32, 102, 111, 114, 109,  97, 116,  32, 105, 115,  32, 110, 111,
116,  32,  99, 117, 114, 114, 101, 110, 116, 108, 121,  32, 105, 109, 112, 108,
101, 109, 101, 110, 116, 101, 100,  46,  32,  42,  42,  42,   8,   8,  80,  65,
 84,  84,  69,  82,  78,  32,   6,   6,  76,  65,  66,  69,  76,  32,   5,   5,
 68,  65,  84,  69,  72,   7,   7,  83,  65,  77,  80,  76,  69,  32,   9,   9,
 73,  68,  78,  85,  77,  66,  69,  82,  32,   6,   6,  78,  85,  77,  79,  82,
 32,   7,   7,  76,  65,  77,  66,  68,  65,  32,   5,   5,  84,  69,  77,  80,
 32,   8,   8,  77,  79,  78,  84,  73,  77,  69,  32,  11,  11,  84,  82,  65,
 78,  83,  76,  65,  84,  73,  79,  78,  13,  13,  80,  65,  82,  65,  77,  69,
 84,  69,  82,  32,  32,  48,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,
 69,  82,  32,  32,  49,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,
 82,  32,  32,  50,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,
 32,  32,  51,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,
 32,  52,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,  32,
 53,  32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,  32,  54,
 32,  13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,  32,  55,  32,
 13,  13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,  32,  56,  32,  13,
 13,  80,  65,  82,  65,  77,  69,  84,  69,  82,  32,  32,  57,  32,  12,  12,
 79,  82,  73,  69,  78,  84,  65,  84,  73,  79,  78,  32,   5,   5,  68,  65,
 84,  65,  32,   3,   3,  69,  79,  68,   3,   3,  32,  32,  32,   2,   2,  32,
 48,   9,   9,  35,  32,  88,  89,  68,  65,  84,  65,  32,  39,  39,  35,  32,
 73,  78,  84,  69,  82,  32,  32,  49,  46,  48,  32,  32,  49,  46,  48,  32,
 32,  48,  32,  32,  48,  46,  48,  49,  48,  48,  48,  32,  32,  32,  76,  65,
 77,  66,  68,  65,  32,   9,   9,  32,  76,  65,  77,  66,  68,  65,  50,  32,
  9,   9,  32,  76,  65,  77,  66,  68,  65,  82,  32,   7,   7,  35,  32,  84,
 69,  77,  80,  32,  47,  47,  35,  32,  77, 111, 110, 105, 116, 111, 114,  47,
 99, 111, 117, 110, 116, 115,  44,  32,  67, 111, 117, 110, 116, 105, 110, 103,
 32, 116, 105, 109, 101,  47, 115, 101,  99,  58, 123,  32,  77, 111, 110, 105,
116, 111, 114,  32, 125,   8,   8,  35,  32,  68,  65,  84,  69,  72,  32,   8,
  8,  32,  83,  65,  77,  80,  76,  69,  32,   9,   9,  35,  32,  79,  82,  73,
 69,  78,  84,  32,  10,  10, 111, 117, 116,  95, 104, 101,  97, 100, 101, 114,
  8,   8,  70,  80,  68,  95,  68,  65,  84,  65,  11,  11, 111, 117, 116,  95,
116, 114,  97, 105, 108, 101, 114,   3,   3,  69,  79,  70,  21,  21, 119, 114,
105, 116, 101,  95, 110, 111, 114, 109,  97, 108, 105, 122, 101, 100,  95, 102,
105, 108, 101,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 552 ) = {
255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,  32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V V_pat_last;
extern Blk(V_mai_parm, 1312 );
extern Blk(V_hkl_parm, 112 );
extern Blk(V_tbpat, 256 );
extern SL V_npat;
extern F V_tmin;
extern F V_tmax;
extern F V_thmin;
extern F V_thmax;
extern F V_gmin;
extern F V_gmax;
extern F V_smin;
extern F V_smax;
extern V V_pat_first;
extern V V_sel_pat;
extern SL V_ndia;
extern Blk(V_tbnp, 128 );
extern SL V_ndiat;
extern UW V_funcs;
extern Blk(V_tbtem, 128 );
extern V PAS__f_output;
extern V V_inp;
extern UB V_dat_celsius;
extern Blk(V_inp_name, 264 );
extern V V_pat_sel;
extern SL PAS__iostatus;
extern Blk(V_str_msg, 264 );
extern UB V_inp_frm;
extern UB V_out_frm;
extern V V_out;
extern Blk(V_out_name, 264 );




/* Procedure/Function : " init_pattern "  */
void RPWDATA_OUT_init_pattern(V F_r){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=67; /* line # 67 */
  Ra.sl[3]=69; /* line # 69 */
  ((V *)F_r)[1]=NULL;
  Ra.sl[3]=70; /* line # 70 */
  ((V *)F_r)[2]=V_pat_last;
  Ra.sl[3]=71; /* line # 71 */
  ((V *)F_r)[3]=NULL;
  Ra.sl[3]=72; /* line # 72 */
  ((SL *)F_r)[4]=0;
  Ra.sl[3]=73; /* line # 73 */
  ((SL *)F_r)[5]=-1;
  Ra.sl[3]=74; /* line # 74 */
  ((UB *)F_r)[25]=0;
  Ra.sl[3]=75; /* line # 75 */
  ((UB *)F_r)[89]=0;
  Ra.sl[3]=76; /* line # 76 */
  ((UB *)F_r)[153]=0;
  Ra.sl[3]=77; /* line # 77 */
  ((F *)F_r)[54]=(F)0.000000E-01;
  Ra.sl[3]=78; /* line # 78 */
  ((F *)F_r)[55]=(F)0.000000E-01;
  Ra.sl[3]=80; /* line # 80 */
  ((F *)F_r)[56]=V_mai_parm.f[322];
  Ra.sl[3]=81; /* line # 81 */
  ((F *)F_r)[57]=(F)0.000000E-01;
  Ra.sl[3]=82; /* line # 82 */
  ((F *)F_r)[58]=(F)0.000000E-01;
  Ra.sl[3]=83; /* line # 83 */
  ((F *)F_r)[59]=(F)0.000000E-01;
  Ra.sl[3]=84; /* line # 84 */
  ((F *)F_r)[60]=(F)0.000000E-01;
  Ra.sl[3]=85; /* line # 85 */
  ((F *)F_r)[61]=(F)0.000000E-01;
  Ra.sl[3]=86; /* line # 86 */
  ((F *)F_r)[62]=V_mai_parm.f[323];
  Ra.sl[3]=87; /* line # 87 */
  ((F *)F_r)[63]=(F)0.000000E-01;
  Ra.sl[3]=88; /* line # 88 */
  ((F *)F_r)[64]=(F)0.000000E-01;
  Ra.sl[3]=89; /* line # 89 */
  ((F *)F_r)[65]=(F)0.000000E-01;
  Ra.sl[3]=90; /* line # 90 */
  ((F *)F_r)[66]=V_hkl_parm.f[0];
  Ra.sl[3]=91; /* line # 91 */
  ((F *)F_r)[67]=V_hkl_parm.f[1];
  Ra.sl[3]=92; /* line # 92 */
  ((F *)F_r)[68]=V_hkl_parm.f[2];
  Ra.sl[3]=93; /* line # 93 */
  ((F *)F_r)[69]=(F)0.000000E-01;
  Ra.sl[3]=94; /* line # 94 */
  ((F *)F_r)[70]=(F)0.000000E-01;
  Ra.sl[3]=95; /* line # 95 */
  ((F *)F_r)[71]=(F)0.000000E-01;
  Ra.sl[3]=96; /* line # 96 */
  ((F *)F_r)[72]=(F)0.000000E-01;
  Ra.sl[3]=97; /* line # 97 */
  ((F *)F_r)[73]=(F)0.000000E-01;
  Ra.sl[3]=98; /* line # 98 */
  ((F *)F_r)[74]=(F)0.000000E-01;
  Ra.sl[3]=99; /* line # 99 */
  ((F *)F_r)[75]=(F)0.000000E-01;
  Ra.sl[3]=100; /* line # 100 */
  ((F *)F_r)[76]=(F)0.000000E-01;
  Ra.sl[3]=101; /* line # 101 */
  ((SL *)F_r)[77]=0;
  Ra.sl[3]=102; /* line # 102 */
  ((SL *)F_r)[78]=0;
  Ra.sl[3]=103; /* line # 103 */
  ((SL *)F_r)[79]=0;
  Ra.sl[3]=104; /* line # 104 */
  ((SL *)F_r)[80]=0;
  Ra.sl[3]=105; /* line # 105 */
  ((F *)F_r)[81]=(F)1.000000E+010;
  Ra.sl[3]=106; /* line # 106 */
  ((F *)F_r)[82]= -((F *)F_r)[81];
  Ra.sl[3]=107; /* line # 107 */
  ((F *)F_r)[83]=(F)1.000000E+010;
  Ra.sl[3]=108; /* line # 108 */
  ((F *)F_r)[84]= -((F *)F_r)[83];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pattern_info_copy "  */
void RPWDATA_OUT_pattern_info_copy(V F_src, V F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=116; /* line # 116 */
  Ra.sl[3]=118; /* line # 118 */
  ((V *)F_dst)[1]=NULL;
  Ra.sl[3]=119; /* line # 119 */
  ((V *)F_dst)[2]=V_pat_last;
  Ra.sl[3]=120; /* line # 120 */
  ((V *)F_dst)[3]=((V *)F_src)[3];
  Ra.sl[3]=121; /* line # 121 */
  ((SL *)F_dst)[4]=((SL *)F_src)[4];
  Ra.sl[3]=122; /* line # 122 */
  ((SL *)F_dst)[5]=((SL *)F_src)[5];
  Ra.sl[3]=123; /* line # 123 */
  PAS__STR_TO_STR(F_dst+24,F_src+24);
  Ra.sl[3]=124; /* line # 124 */
  PAS__STR_TO_STR(F_dst+88,F_src+88);
  Ra.sl[3]=125; /* line # 125 */
  PAS__STR_TO_STR(F_dst+152,F_src+152);
  Ra.sl[3]=126; /* line # 126 */
  ((F *)F_dst)[54]=((F *)F_src)[54];
  Ra.sl[3]=127; /* line # 127 */
  ((F *)F_dst)[55]=((F *)F_src)[55];
  Ra.sl[3]=129; /* line # 129 */
  ((F *)F_dst)[56]=((F *)F_src)[56];
  Ra.sl[3]=130; /* line # 130 */
  ((F *)F_dst)[57]=((F *)F_src)[57];
  Ra.sl[3]=131; /* line # 131 */
  ((F *)F_dst)[58]=((F *)F_src)[58];
  Ra.sl[3]=132; /* line # 132 */
  ((F *)F_dst)[59]=((F *)F_src)[59];
  Ra.sl[3]=133; /* line # 133 */
  ((F *)F_dst)[60]=((F *)F_src)[60];
  Ra.sl[3]=134; /* line # 134 */
  ((F *)F_dst)[61]=((F *)F_src)[61];
  Ra.sl[3]=135; /* line # 135 */
  ((F *)F_dst)[62]=((F *)F_src)[62];
  Ra.sl[3]=136; /* line # 136 */
  ((F *)F_dst)[63]=((F *)F_src)[63];
  Ra.sl[3]=137; /* line # 137 */
  ((F *)F_dst)[64]=((F *)F_src)[64];
  Ra.sl[3]=138; /* line # 138 */
  ((F *)F_dst)[65]=((F *)F_src)[65];
  Ra.sl[3]=139; /* line # 139 */
  ((F *)F_dst)[66]=((F *)F_src)[66];
  Ra.sl[3]=140; /* line # 140 */
  ((F *)F_dst)[67]=((F *)F_src)[67];
  Ra.sl[3]=141; /* line # 141 */
  ((F *)F_dst)[68]=((F *)F_src)[68];
  Ra.sl[3]=142; /* line # 142 */
  ((F *)F_dst)[69]=((F *)F_src)[69];
  Ra.sl[3]=143; /* line # 143 */
  ((F *)F_dst)[70]=((F *)F_src)[70];
  Ra.sl[3]=144; /* line # 144 */
  ((F *)F_dst)[71]=((F *)F_src)[71];
  Ra.sl[3]=145; /* line # 145 */
  ((F *)F_dst)[72]=((F *)F_src)[72];
  Ra.sl[3]=146; /* line # 146 */
  ((F *)F_dst)[73]=((F *)F_src)[73];
  Ra.sl[3]=147; /* line # 147 */
  ((F *)F_dst)[74]=((F *)F_src)[74];
  Ra.sl[3]=148; /* line # 148 */
  ((F *)F_dst)[75]=((F *)F_src)[75];
  Ra.sl[3]=149; /* line # 149 */
  ((F *)F_dst)[76]=((F *)F_src)[76];
  Ra.sl[3]=150; /* line # 150 */
  ((SL *)F_dst)[77]=((SL *)F_src)[77];
  Ra.sl[3]=151; /* line # 151 */
  ((SL *)F_dst)[78]=((SL *)F_src)[78];
  Ra.sl[3]=152; /* line # 152 */
  ((SL *)F_dst)[79]=((SL *)F_src)[79];
  Ra.sl[3]=153; /* line # 153 */
  ((SL *)F_dst)[80]=((SL *)F_src)[80];
  Ra.sl[3]=154; /* line # 154 */
  ((F *)F_dst)[81]=((F *)F_src)[81];
  Ra.sl[3]=155; /* line # 155 */
  ((F *)F_dst)[82]=((F *)F_src)[82];
  Ra.sl[3]=156; /* line # 156 */
  ((F *)F_dst)[83]=((F *)F_src)[83];
  Ra.sl[3]=157; /* line # 157 */
  ((F *)F_dst)[84]=((F *)F_src)[84];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " init_load "  */
void P_init_load(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=170; /* line # 170 */
  Rv0=1;
  for( Rf0=32;Rf0>0;Rf0-- ) {
    V_tbpat.v[PAS__RANGE(Rv0,1,64)-1]=NULL;
    Rv0++;
  }
  Ra.sl[3]=171; /* line # 171 */
  V_npat=0;
  Ra.sl[3]=173; /* line # 173 */
  V_tmin=(F)1.000000E+010;
  V_tmax= -V_tmin;
  Ra.sl[3]=174; /* line # 174 */
  V_thmin=(F)1.000000E+010;
  V_thmax= -V_thmin;
  Ra.sl[3]=175; /* line # 175 */
  V_gmin=(F)1.000000E+010;
  V_gmax= -V_gmin;
  Ra.sl[3]=176; /* line # 176 */
  V_smin=(F)1.000000E+010;
  V_smax= -V_smin;
  Ra.sl[3]=179; /* line # 179 */
  while (V_pat_first!=NULL){
    Ra.sl[3]=181; /* line # 181 */
    Rv1=V_pat_first;
    Ra.sl[3]=182; /* line # 182 */
    V_pat_first=((V *)Rv1)[1];
    Ra.sl[3]=183; /* line # 183 */
    PAS__DISPOSE(&Rv1);
  }
  Ra.sl[3]=185; /* line # 185 */
  V_pat_last=NULL;
  Ra.sl[3]=186; /* line # 186 */
  V_sel_pat=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_pattern_selection "  */
void P_set_pattern_selection(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  SL Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+106;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=200; /* line # 200 */
  V_smin=(F)1.000000E+010;
  V_smax= -V_smin;
  Ra.sl[3]=201; /* line # 201 */
  Rv0=0;
  Ra.sl[3]=202; /* line # 202 */
  Rv1=V_pat_first;
  Ra.sl[3]=203; /* line # 203 */
  Rv2=1;
  Ra.sl[3]=204; /* line # 204 */
  while (Rv1!=NULL){
    Ra.sl[3]=206; /* line # 206 */
    Rv3=0;
    Ra.sl[3]=207; /* line # 207 */
    Rv4=1;
    for( Rf0=V_ndia;Rf0>0;Rf0-- ) {
      Ra.sl[3]=208; /* line # 208 */
      if (Rv2==V_tbnp.sl[PAS__RANGE(Rv4,1,32)-1]) Rv3=1;
      Rv4++;
    }
    Ra.sl[3]=209; /* line # 209 */
    if (!Rv3) {
      Ra.sl[3]=210; /* line # 210 */
      Rv5=1;
      for( Rf0=V_ndiat;Rf0>0;Rf0-- ) {
        Ra.sl[3]=211; /* line # 211 */
        if (32&V_funcs) {
          Ra.sl[3]=213; /* line # 213 */
          if (fabs((((F *)Rv1)[63]-V_tbtem.f[PAS__RANGE(Rv5,1,32)-1])-(F)2.731600E+02)
          <(F)1.000000E-03) Rv3=1;
        }
        else {
          Ra.sl[3]=215; /* line # 215 */
          if (fabs(((F *)Rv1)[63]-V_tbtem.f[PAS__RANGE(Rv5,1,32)-1])<(F)1.000000E-03)
           Rv3=1;
        }
        Rv5++;
      }
    }
    Ra.sl[3]=216; /* line # 216 */
    if (Rv3) {
      Ra.sl[3]=218; /* line # 218 */
      if (V_smin>((F *)Rv1)[83]) V_smin=((F *)Rv1)[83];
      Ra.sl[3]=219; /* line # 219 */
      if (V_smax<((F *)Rv1)[84]) V_smax=((F *)Rv1)[84];
      Ra.sl[3]=220; /* line # 220 */
      Rv0=Rv0+1;
      Ra.sl[3]=221; /* line # 221 */
      V_tbpat.v[PAS__RANGE(Rv0,1,64)-1]=Rv1;
    }
    Ra.sl[3]=223; /* line # 223 */
    Rv2=Rv2+1;
    Ra.sl[3]=224; /* line # 224 */
    Rv1=((V *)Rv1)[1];
  }
  Ra.sl[3]=226; /* line # 226 */
  Rv6=Rv0+1;
  for( Rf0=65-(Rv0+1);Rf0>0;Rf0-- ) {
    V_tbpat.v[PAS__RANGE(Rv6,1,64)-1]=NULL;
    Rv6++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rpwf_error "  */
void RPWDATA_OUT_PRC_00000000(V F_msg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+129;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=246; /* line # 246 */
  PAS__VWRITE_INIT(Lx[1].s,1);
  PAS__WRITE_STR(Rd.s+141,-1,-1,32);
  PAS__WRITE_STR(Lx[1].s+257,-1,-1,32);
  PAS__WRITE_STR(Rd.s+163,-1,-1,32);
  PAS__WRITE_STR(F_msg,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=247; /* line # 247 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+174,-1,-1,32);
  PAS__WRITE_STR(Lx[1].s,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=248; /* line # 248 */
  longjmp((void *)Lx[1].v[74],1);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_inp_char "  */
void RPWDATA_OUT_PRC_00000001(SL F_nn){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  C Rv0;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+185;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=258; /* line # 258 */
  for( Rf0=F_nn;Rf0>0;Rf0-- ) {
    PAS__SELECT_INP(V_inp);
    PAS__READ_CHAR(&Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " elliminate_cr "  */
void RPWDATA_OUT_PRC_00000002(V F_st){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+200;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=268; /* line # 268 */
  Ra.sl[3]=269; /* line # 269 */
  if (((UB *)F_st)[1]>0) {
    Ra.sl[3]=270; /* line # 270 */
    if (((C *)F_st)[PAS__RANGE(((UB *)F_st)[1],1,(UL)((UB *)F_st)[0])+1]==13) ((
    UB *)F_st)[1]=((UB *)F_st)[1]-1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " skip_space "  */
void RPWDATA_OUT_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+215;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=289; /* line # 289 */
  while (Lx[0].sl[0]>0&&Lx[0].c[PAS__RANGE(Lx[0].sl[0],1,(UL)Lx[0].ub[4])+5]<=32)

  Lx[0].sl[0]=Lx[0].sl[0]+1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_new_line "  */
void RPWDATA_OUT_PRC_00000005(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+227;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=295; /* line # 295 */
  Lx[0].ub[5]=0;
  Ra.sl[3]=296; /* line # 296 */
  while (!PAS__EOF(V_inp)&&Lx[0].ub[5]==0){
    Ra.sl[3]=298; /* line # 298 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Lx[0].s+4,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=299; /* line # 299 */
    if (Lx[0].ub[5]>0) {
      Ra.sl[3]=300; /* line # 300 */
      if (Lx[0].c[PAS__RANGE(1,1,(UL)Lx[0].ub[4])+5]!=35&&Lx[0].c[PAS__RANGE(1,1,
      (UL)Lx[0].ub[4])+5]!=33) {
        Ra.sl[3]=302; /* line # 302 */
        while (Lx[0].ub[5]>0&&Lx[0].c[PAS__RANGE(Lx[0].ub[5],1,(UL)Lx[0].ub[4])+
5]<=32)
        Lx[0].ub[5]=Lx[0].ub[5]-1;
        Ra.sl[3]=303; /* line # 303 */
        Lx[0].sl[0]=1;
      }
      else {
        Ra.sl[3]=305; /* line # 305 */
        Lx[0].ub[5]=0;
      }
    }
    else {
      Ra.sl[3]=307; /* line # 307 */
      if (PAS__EOF(V_inp)) Lx[0].ub[261]=1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_one_word "  */
void RPWDATA_OUT_PRC_00000006(V F_word, UB F_bwf){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+241;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=315; /* line # 315 */
  ((UB *)F_word)[1]=0;
  Ra.sl[3]=316; /* line # 316 */
  while (Lx[0].sl[0]>=0&&((UB *)F_word)[1]==0){
    Ra.sl[3]=317; /* line # 317 */
    PAS__VREAD_INIT(Lx[0].s+6,(SL)Lx[0].ub[5],Lx[0].sl);
    PAS__READ_STR(F_word,((UB *)F_word)[0],1);
    PAS__READ_EOLN();
  }
  Ra.sl[3]=318; /* line # 318 */
  if (((UB *)F_word)[1]>0&&F_bwf) {
    Ra.sl[3]=320; /* line # 320 */
    PAS__SET_CASE(F_word,1);
    Ra.sl[3]=321; /* line # 321 */
    if (((UB *)F_word)[1]>16) ((UB *)F_word)[1]=16;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_rpwstd_format "  */
void RPWDATA_OUT_PRC_00000003(){
  /* Define the automatic variable space. */
  Blk( Ra, 672 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  V Rv2;
  register UB Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  register SL Rv8;
  F Rv9;
  F Rv10;
  SL Rv11;
  register V Rv12;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[4]=255;
  Ra.ub[262]=32;
  Ra.sl[74]=1;
  Ra.ub[320]=62;
  Ra.ub[384]=62;
  Ra.ub[448]=62;
  Ra.v[163]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+652;
  Ra.v[164]=Rd.s+255;
  Ra.v[165]=Rd.s+14;
  Ra.sl[166]=328; /* line # 328 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+274);
  Ra.sl[166]=329; /* line # 329 */
  Ra.ub[261]=0;
  Ra.sl[166]=330; /* line # 330 */
  Rv0=0;
  Ra.sl[166]=331; /* line # 331 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_STR(Ra.s+262,Ra.ub[262],1);
  PAS__READ_EOLN();
  Ra.sl[166]=332; /* line # 332 */
  PAS__SET_CASE(Ra.s+262,1);
  Ra.sl[166]=333; /* line # 333 */
  if (PAS__NE_STR(Ra.s+262,Lx[1].s+257)) RPWDATA_OUT_PRC_00000000(Rd.s+284);
  Ra.sl[166]=335; /* line # 335 */
  RPWDATA_OUT_PRC_00000005();
  Ra.sl[166]=336; /* line # 336 */
  RPWDATA_OUT_PRC_00000006(Ra.s+262,1);
  Ra.sl[166]=337; /* line # 337 */
  while (!PAS__EOF(V_inp)&&PAS__NE_STR(Ra.s+262,Rd.s+306)){
    Ra.sl[166]=339; /* line # 339 */
    if (PAS__NE_STR(Ra.s+262,Rd.s+311)) RPWDATA_OUT_PRC_00000000(Rd.s+320);
    Ra.sl[166]=341; /* line # 341 */
    RPWDATA_OUT_init_pattern(Ra.s+296);
    Ra.sl[166]=343; /* line # 343 */
    Rv0=Rv0+1;
    Ra.sl[166]=345; /* line # 345 */
    Rv1=0;
    Ra.sl[166]=347; /* line # 347 */
    Ra.sl[166]=349; /* line # 349 */
    Rv2=NULL;
    Ra.sl[166]=350; /* line # 350 */
    RPWDATA_OUT_PRC_00000004();
    PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
    PAS__READ_STR(Ra.s+448,0,0);
    PAS__READ_EOLN();
    while (1){
      Ra.sl[166]=352; /* line # 352 */
      if (Rv1) Rv1=0;
      else while (1){
        Ra.sl[166]=355; /* line # 355 */
        RPWDATA_OUT_PRC_00000005();
        Ra.sl[166]=356; /* line # 356 */
        if (Ra.ub[261]) RPWDATA_OUT_PRC_00000000(Rd.s+382);
        Ra.sl[166]=357; /* line # 357 */
        RPWDATA_OUT_PRC_00000006(Ra.s+262,1);
        if (Ra.ub[263]>0)  break;
      }
      Ra.sl[166]=360; /* line # 360 */
      if (PAS__EQ_STR(Ra.s+262,Rd.s+415)) {
        Ra.sl[166]=361; /* line # 361 */
        RPWDATA_OUT_PRC_00000004();
        Ra.sl[166]=362; /* line # 362 */
        Rv3=PAS__RANGE((Ra.ub[5]-Ra.sl[0])+1,0,255);
        Rv4=PAS__NEW((SL)Rv3+8);
        ((UB *)Rv4)[0]=Rv3;
        Ra.sl[166]=363; /* line # 363 */
        PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
        PAS__READ_CHT(Rv4+8,(UL)((UB *)Rv4)[0],0,0);
        PAS__READ_EOLN();
        Ra.sl[166]=364; /* line # 364 */
        ((V *)Rv4)[1]=NULL;
        Ra.sl[166]=365; /* line # 365 */
        if (Ra.v[77]==NULL) Ra.v[77]=Rv4;
        else {
          Ra.sl[166]=366; /* line # 366 */
          ((V *)Rv5)[1]=Rv4;
        }
        Ra.sl[166]=367; /* line # 367 */
        Rv5=Rv4;
      }
      else {
        Ra.sl[166]=370; /* line # 370 */
        if (PAS__EQ_STR(Ra.s+262,Rd.s+422)) {
          PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
          PAS__READ_SL(Ra.sl+78,0);
          PAS__READ_EOLN();
        }
        else {
          Ra.sl[166]=372; /* line # 372 */
          if (PAS__EQ_STR(Ra.s+262,Rd.s+432)) {
            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
            PAS__READ_SL(Ra.sl+79,0);
            PAS__READ_EOLN();
          }
          else {
            Ra.sl[166]=374; /* line # 374 */
            if (PAS__EQ_STR(Ra.s+262,Rd.s+439)) RPWDATA_OUT_PRC_00000006(Ra.s+320,1);
            else {
              Ra.sl[166]=376; /* line # 376 */
              if (PAS__EQ_STR(Ra.s+262,Rd.s+446)) {
                RPWDATA_OUT_PRC_00000004();
                PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                PAS__READ_STR(Ra.s+384,0,0);
                PAS__READ_EOLN();
              }
              else {
                Ra.sl[166]=378; /* line # 378 */
                if (PAS__EQ_STR(Ra.s+262,Rd.s+454)) {
                  PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                  PAS__READ_SNGL(Ra.f+140,0);
                  PAS__READ_SNGL(Ra.f+141,0);
                  PAS__READ_SNGL(Ra.f+142,0);
                  PAS__READ_EOLN();
                }
                else {
                  Ra.sl[166]=380; /* line # 380 */
                  if (PAS__EQ_STR(Ra.s+262,Rd.s+462)) {
                    PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                    PAS__READ_SNGL(Ra.f+137,0);
                    PAS__READ_SNGL(Ra.f+138,0);
                    PAS__READ_SNGL(Ra.f+139,0);
                    PAS__READ_EOLN();
                  }
                  else {
                    Ra.sl[166]=382; /* line # 382 */
                    if (PAS__EQ_STR(Ra.s+262,Rd.s+468)) {
                      PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                      PAS__READ_SNGL(Ra.f+128,0);
                      PAS__READ_SNGL(Ra.f+129,0);
                      PAS__READ_EOLN();
                    }
                    else {
                      Ra.sl[166]=384; /* line # 384 */
                      if (PAS__EQ_STR(Ra.s+262,Rd.s+477)) {
                        PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                        PAS__READ_SNGL(Ra.f+134,0);
                        PAS__READ_SNGL(Ra.f+135,0);
                        PAS__READ_EOLN();
                      }
                      else {
                        Ra.sl[166]=386; /* line # 386 */
                        if (PAS__EQ_STR(Ra.s+262,Rd.s+490)) {
                          Ra.sl[166]=387; /* line # 387 */
                          PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                          PAS__READ_SL(&Rv6,0);
                          PAS__READ_EOLN();
                          Ra.sl[166]=388; /* line # 388 */
                          switch (Rv6) {
                            case 0:Ra.sl[166]=389; /* line # 389 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SL(Ra.sl+153,0);
                            PAS__READ_EOLN();
                            break;
                            case 1:Ra.sl[166]=390; /* line # 390 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SL(Ra.sl+154,0);
                            PAS__READ_EOLN();
                            break;
                            case 2:Ra.sl[166]=391; /* line # 391 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+143,0);
                            PAS__READ_EOLN();
                            break;
                            case 3:Ra.sl[166]=392; /* line # 392 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+144,0);
                            PAS__READ_EOLN();
                            break;
                            case 4:Ra.sl[166]=393; /* line # 393 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+145,0);
                            PAS__READ_EOLN();
                            break;
                            case 5:Ra.sl[166]=394; /* line # 394 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+146,0);
                            PAS__READ_EOLN();
                            break;
                            case 6:Ra.sl[166]=395; /* line # 395 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+147,0);
                            PAS__READ_EOLN();
                            break;
                            case 7:Ra.sl[166]=396; /* line # 396 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+148,0);
                            PAS__READ_EOLN();
                            break;
                            case 8:Ra.sl[166]=397; /* line # 397 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+149,0);
                            PAS__READ_EOLN();
                            break;
                            case 9:Ra.sl[166]=398; /* line # 398 */
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+150,0);
                            PAS__READ_EOLN();
                            break;
                            default:break;
                          }
                        }
                        else {
                          Ra.sl[166]=403; /* line # 403 */
                          if (PAS__EQ_STR(Ra.s+262,Rd.s+501)) {
                            PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                            PAS__READ_SNGL(Ra.f+131,0);
                            PAS__READ_SNGL(Ra.f+132,0);
                            PAS__READ_SNGL(Ra.f+133,0);
                            PAS__READ_EOLN();
                          }
                          else {
                            Ra.sl[166]=405; /* line # 405 */
                            if (PAS__EQ_STR(Ra.s+262,Rd.s+514)) {
                              Ra.sl[166]=407; /* line # 407 */
                              if (Rv2!=NULL) RPWDATA_OUT_PRC_00000000(Rd.s+520);
                              Ra.sl[166]=408; /* line # 408 */
                              PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                              PAS__READ_SL(&Rv7,0);
                              PAS__READ_EOLN();
                              Ra.sl[166]=409; /* line # 409 */
                              Rv8=Rv7;
                              Rv2=PAS__NEW(Rv8*16+340);
                              ((SL *)Rv2)[0]=Rv8;
                              ((UB *)Rv2)[24]=62;
                              ((UB *)Rv2)[88]=62;
                              ((UB *)Rv2)[152]=62;
                              Ra.sl[166]=410; /* line # 410 */
                              Ra.f[155]=(F)1.000000E+010;
                              Ra.f[156]= -Ra.f[155];
                              Ra.sl[166]=411; /* line # 411 */
                              Rv9=(F)1.000000E+010;
                              Rv10= -Rv9;
                              Ra.sl[166]=413; /* line # 413 */
                              Rv11=1;
                              for( Rf0=Rv7;Rf0>0;Rf0-- ) {
                                Ra.sl[166]=414; /* line # 414 */
                                Rv12=(((S *)Rv2)+PAS__RANGE(Rv11,1,((SL *)Rv2)[0]
                                )*16+324);
                                Ra.sl[166]=416; /* line # 416 */
                                RPWDATA_OUT_PRC_00000005();
                                Ra.sl[166]=417; /* line # 417 */
                                PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                                PAS__READ_SW(((SW *)Rv12)+6,0);
                                PAS__READ_SNGL(((F *)Rv12),0);
                                PAS__READ_SNGL(((F *)Rv12)+1,0);
                                PAS__READ_EOLN();
                                Ra.sl[166]=418; /* line # 418 */
                                if (Ra.sl[0]>0) {
                                  PAS__VREAD_INIT(Ra.s+6,(SL)Ra.ub[5],Ra.sl);
                                  PAS__READ_SNGL(((F *)Rv12)+2,0);
                                  PAS__READ_EOLN();
                                }
                                else {
                                  Ra.sl[166]=419; /* line # 419 */
                                  ((F *)Rv12)[2]=sqrt(((F *)Rv12)[1]);
                                }
                                Ra.sl[166]=420; /* line # 420 */
                                if (Rv9>((F *)Rv12)[1]) Rv9=((F *)Rv12)[1];
                                Ra.sl[166]=421; /* line # 421 */
                                if (Rv10<((F *)Rv12)[1]) Rv10=((F *)Rv12)[1];
                                Ra.sl[166]=422; /* line # 422 */
                                if (Ra.f[156]<((F *)Rv12)[0]) Ra.f[156]=((F *)Rv12)
                                [0];
                                Ra.sl[166]=423; /* line # 423 */
                                if (Ra.f[155]>((F *)Rv12)[0]) Ra.f[155]=((F *)Rv12)
                                [0];
                                Ra.sl[166]=424; /* line # 424 */
                                ((UB *)Rv12)[14]=0;
                                Rv11++;
                              }
                              Ra.sl[166]=427; /* line # 427 */
                              RPWDATA_OUT_PRC_00000005();
                              Ra.sl[166]=428; /* line # 428 */
                              RPWDATA_OUT_PRC_00000006(Ra.s+262,1);
                              Ra.sl[166]=429; /* line # 429 */
                              if (PAS__NE_STR(Ra.s+262,Rd.s+583)) Rv1=1;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if ((Ra.ub[261]||PAS__EQ_STR(Ra.s+262,Rd.s+588))||PAS__EQ_STR(Ra.s+262,Rd.
      s+597))  break;
    }
    Ra.sl[166]=436; /* line # 436 */
    Ra.f[130]=Ra.f[155];
    Ra.sl[166]=437; /* line # 437 */
    Ra.f[157]=Rv9;
    Ra.f[158]=Rv10;
    Ra.sl[166]=438; /* line # 438 */
    if (Ra.f[137]!=(F)0.000000E-01) {
      Ra.sl[166]=440; /* line # 440 */
      if (V_tmin>Ra.f[137]) V_tmin=Ra.f[137];
      Ra.sl[166]=441; /* line # 441 */
      if (V_tmax<Ra.f[137]) V_tmax=Ra.f[137];
    }
    Ra.sl[166]=443; /* line # 443 */
    if (V_thmin>Ra.f[155]) V_thmin=Ra.f[155];
    Ra.sl[166]=444; /* line # 444 */
    if (V_thmax<Ra.f[156]) V_thmax=Ra.f[156];
    Ra.sl[166]=445; /* line # 445 */
    if (V_gmin>Rv9) V_gmin=Rv9;
    Ra.sl[166]=446; /* line # 446 */
    if (V_gmax<Rv10) V_gmax=Rv10;
    Ra.sl[166]=448; /* line # 448 */
    if (V_dat_celsius||Ra.f[139]<=(F)0.000000E-01) {
      Ra.sl[166]=450; /* line # 450 */
      Ra.f[137]=Ra.f[137]+(F)2.731600E+02;
      Ra.sl[166]=451; /* line # 451 */
      Ra.f[138]=Ra.f[138]+(F)2.731600E+02;
      Ra.sl[166]=452; /* line # 452 */
      Ra.f[139]=Ra.f[139]+(F)2.731600E+02;
    }
    Ra.sl[166]=456; /* line # 456 */
    RPWDATA_OUT_pattern_info_copy(Ra.s+296,Rv2);
    Ra.sl[166]=459; /* line # 459 */
    if (V_pat_first==NULL) V_pat_first=Rv2;
    else {
      Ra.sl[166]=460; /* line # 460 */
      ((V *)V_pat_last)[1]=Rv2;
    }
    Ra.sl[166]=461; /* line # 461 */
    V_pat_last=Rv2;
    Ra.sl[166]=463; /* line # 463 */
    V_npat=V_npat+1;
  }
  PAS__curr_cntx=Ra.v[163];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " get_d1b_format "  */
void RPWDATA_OUT_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 1048 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register SL Rv2;
  V Rv3;
  register V Rv4;
  C Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  SL Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.ub[257]=255;
  Ra.ub[514]=255;
  Ra.ub[771]=255;
  Ra.v[257]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1028;
  Ra.v[258]=Rd.s+602;
  Ra.v[259]=Rd.s+14;
  Ra.sl[260]=479; /* line # 479 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+618);
  Ra.sl[260]=480; /* line # 480 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_SL(&Rv0,0);
  PAS__READ_EOLN();
  Ra.sl[260]=481; /* line # 481 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[260]=483; /* line # 483 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=484; /* line # 484 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[260]=485; /* line # 485 */
    PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
    PAS__READ_STR(Ra.s+257,0,1);
    PAS__READ_EOLN();
    Ra.sl[260]=486; /* line # 486 */
    if (PAS__EQ_STR(Ra.s+257,Rd.s+623))  break;
    Ra.sl[260]=487; /* line # 487 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+257,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=488; /* line # 488 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+514,0,0);
    PAS__READ_EOLN();
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ra.s+771,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=489; /* line # 489 */
    PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
    PAS__READ_SL(&Rv1,0);
    PAS__READ_EOLN();
    Ra.sl[260]=491; /* line # 491 */
    Rv2=Rv1;
    Rv3=PAS__NEW(Rv2*16+340);
    ((SL *)Rv3)[0]=Rv2;
    ((UB *)Rv3)[24]=62;
    ((UB *)Rv3)[88]=62;
    ((UB *)Rv3)[152]=62;
    Ra.sl[260]=492; /* line # 492 */
    RPWDATA_OUT_init_pattern(Rv3);
    Ra.sl[260]=493; /* line # 493 */
    Rv4=Rv3;
    Ra.sl[260]=495; /* line # 495 */
    PAS__VREAD_INIT(Ra.s+2,(SL)Ra.ub[1],NULL);
    PAS__READ_STR(Rv4+24,20,0);
    PAS__READ_CHAR(&Rv5);
    PAS__READ_STR(Rv4+88,10,0);
    PAS__READ_CHAR(&Rv5);
    PAS__READ_STR(Rv4+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[260]=496; /* line # 496 */
    PAS__VREAD_INIT(Ra.s+259,(SL)Ra.ub[258],NULL);
    PAS__READ_SL(((SL *)Rv4)+4,0);
    PAS__READ_SL(((SL *)Rv4)+5,0);
    PAS__READ_EOLN();
    Ra.sl[260]=497; /* line # 497 */
    if (Ra.c[PAS__RANGE(11,1,(UL)Ra.ub[771])+772]==46) {
      Ra.sl[260]=499; /* line # 499 */
      PAS__VREAD_INIT(Ra.s+516,(SL)Ra.ub[515],NULL);
      PAS__READ_SNGL(((F *)Rv4)+54,0);
      PAS__READ_SNGL(((F *)Rv4)+55,0);
      PAS__READ_SNGL(((F *)Rv4)+56,0);
      PAS__READ_SNGL(((F *)Rv4)+57,0);
      PAS__READ_SNGL(((F *)Rv4)+58,0);
      PAS__READ_SNGL(((F *)Rv4)+59,0);
      PAS__READ_SNGL(((F *)Rv4)+60,0);
      PAS__READ_SNGL(((F *)Rv4)+61,0);
      PAS__READ_SNGL(((F *)Rv4)+62,0);
      PAS__READ_SNGL(((F *)Rv4)+63,0);
      PAS__READ_SNGL(((F *)Rv4)+64,0);
      PAS__READ_SNGL(((F *)Rv4)+65,0);
      PAS__READ_EOLN();
      Ra.sl[260]=503; /* line # 503 */
      PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
      PAS__READ_SL(&Rv1,0);
      PAS__READ_SNGL(((F *)Rv4)+66,0);
      PAS__READ_SNGL(((F *)Rv4)+69,0);
      PAS__READ_SNGL(((F *)Rv4)+70,0);
      PAS__READ_SNGL(((F *)Rv4)+71,0);
      PAS__READ_SNGL(((F *)Rv4)+72,0);
      PAS__READ_SNGL(((F *)Rv4)+73,0);
      PAS__READ_SNGL(((F *)Rv4)+74,0);
      PAS__READ_SNGL(((F *)Rv4)+75,0);
      PAS__READ_SNGL(((F *)Rv4)+76,0);
      PAS__READ_SL(((SL *)Rv4)+79,0);
      PAS__READ_SL(((SL *)Rv4)+80,0);
      PAS__READ_EOLN();
    }
    else {
      Ra.sl[260]=510; /* line # 510 */
      PAS__VREAD_INIT(Ra.s+516,(SL)Ra.ub[515],NULL);
      PAS__READ_SNGL(((F *)Rv4)+54,0);
      PAS__READ_SNGL(((F *)Rv4)+55,0);
      PAS__READ_SNGL(((F *)Rv4)+56,0);
      PAS__READ_SNGL(((F *)Rv4)+57,0);
      PAS__READ_SNGL(((F *)Rv4)+58,0);
      PAS__READ_SNGL(((F *)Rv4)+59,0);
      PAS__READ_SNGL(&Rv6,0);
      PAS__READ_SNGL(((F *)Rv4)+66,0);
      PAS__READ_SNGL(((F *)Rv4)+62,0);
      PAS__READ_SNGL(((F *)Rv4)+63,0);
      PAS__READ_SNGL(((F *)Rv4)+64,0);
      PAS__READ_SNGL(((F *)Rv4)+65,0);
      PAS__READ_EOLN();
      Ra.sl[260]=514; /* line # 514 */
      PAS__VREAD_INIT(Ra.s+773,(SL)Ra.ub[772],NULL);
      PAS__READ_SL(&Rv1,0);
      PAS__READ_SNGL(((F *)Rv4)+69,0);
      PAS__READ_SNGL(((F *)Rv4)+70,0);
      PAS__READ_SNGL(((F *)Rv4)+71,0);
      PAS__READ_SNGL(((F *)Rv4)+72,0);
      PAS__READ_SNGL(((F *)Rv4)+73,0);
      PAS__READ_EOLN();
    }
    Ra.sl[260]=517; /* line # 517 */
    if (V_dat_celsius||((F *)Rv4)[65]<=(F)0.000000E-01) {
      Ra.sl[260]=519; /* line # 519 */
      ((F *)Rv4)[63]=((F *)Rv4)[63]+(F)2.731600E+02;
      Ra.sl[260]=520; /* line # 520 */
      ((F *)Rv4)[64]=((F *)Rv4)[64]+(F)2.731600E+02;
      Ra.sl[260]=521; /* line # 521 */
      ((F *)Rv4)[65]=((F *)Rv4)[65]+(F)2.731600E+02;
    }
    Ra.sl[260]=523; /* line # 523 */
    ((F *)Rv4)[67]=(F)0.000000E-01;
    Ra.sl[260]=524; /* line # 524 */
    ((F *)Rv4)[81]=((F *)Rv4)[56];
    Ra.sl[260]=525; /* line # 525 */
    ((F *)Rv4)[82]=((F *)Rv4)[56]+(float)(((SL *)Rv4)[0]-1)*((F *)Rv4)[62];
    Ra.sl[260]=526; /* line # 526 */
    Rv7=(F)1.000000E+010;
    Rv8= -Rv7;
    Ra.sl[260]=528; /* line # 528 */
    Rv9=0;
    Ra.sl[260]=529; /* line # 529 */
    ((SL *)Rv4)[77]=1;
    ((SL *)Rv4)[78]=((SL *)Rv4)[0];
    Ra.sl[260]=530; /* line # 530 */
    while (Rv9<((SL *)Rv4)[0]){
      Ra.sl[260]=532; /* line # 532 */
      Rv10=(((S *)Rv4)+PAS__RANGE(Rv9+1,1,((SL *)Rv4)[0])*16+324);
      Ra.sl[260]=534; /* line # 534 */
      ((F *)Rv10)[0]=((F *)Rv4)[56]+(float)Rv9*((F *)Rv4)[62];
      Ra.sl[260]=535; /* line # 535 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_SW(((SW *)Rv10)+6,0);
      PAS__READ_SNGL(((F *)Rv10)+1,0);
      Ra.sl[260]=536; /* line # 536 */
      ((F *)Rv10)[2]=sqrt(fabs(((F *)Rv10)[1]));
      Ra.sl[260]=537; /* line # 537 */
      ((UB *)Rv10)[14]=0;
      Ra.sl[260]=538; /* line # 538 */
      if (((SW *)Rv10)[6]<=0) ((UB *)Rv10)[14]=128;
      Ra.sl[260]=540; /* line # 540 */
      if (Rv7>((F *)Rv10)[1]) Rv7=((F *)Rv10)[1];
      Ra.sl[260]=541; /* line # 541 */
      if (Rv8<((F *)Rv10)[1]) Rv8=((F *)Rv10)[1];
      Ra.sl[260]=543; /* line # 543 */
      Rv9=Rv9+1;
    }
    Ra.sl[260]=546; /* line # 546 */
    ((F *)Rv4)[83]=Rv7;
    ((F *)Rv4)[84]=Rv8;
    Ra.sl[260]=548; /* line # 548 */
    if (((F *)Rv4)[63]!=(F)0.000000E-01) {
      Ra.sl[260]=550; /* line # 550 */
      if (V_tmin>((F *)Rv4)[63]) V_tmin=((F *)Rv4)[63];
      Ra.sl[260]=551; /* line # 551 */
      if (V_tmax<((F *)Rv4)[63]) V_tmax=((F *)Rv4)[63];
    }
    Ra.sl[260]=553; /* line # 553 */
    if (V_thmin>((F *)Rv4)[81]) V_thmin=((F *)Rv4)[81];
    Ra.sl[260]=554; /* line # 554 */
    if (V_thmax<((F *)Rv4)[82]) V_thmax=((F *)Rv4)[82];
    Ra.sl[260]=555; /* line # 555 */
    if (V_gmin>Rv7) V_gmin=Rv7;
    Ra.sl[260]=556; /* line # 556 */
    if (V_gmax<Rv8) V_gmax=Rv8;
    Ra.sl[260]=559; /* line # 559 */
    if (V_pat_first==NULL) V_pat_first=Rv3;
    else {
      Ra.sl[260]=560; /* line # 560 */
      ((V *)V_pat_last)[1]=Rv3;
    }
    Ra.sl[260]=561; /* line # 561 */
    V_pat_last=Rv3;
    Ra.sl[260]=563; /* line # 563 */
    V_npat=V_npat+1;
    Ra.sl[260]=564; /* line # 564 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    Ra.sl[260]=565; /* line # 565 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SL(&Rv0,0);
    PAS__READ_EOLN();
  }
  PAS__curr_cntx=Ra.v[257];
}


/* Procedure/Function : " get_xyd_format "  */
void RPWDATA_OUT_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register SL Rv3;
  V Rv4;
  register V Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  SL Rv9;
  C Rv10;
  UB Rv11;
  SL Rv12;
  register V Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  F Rv17;
  F Rv18;
  F Rv19;
  F Rv20;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+631;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=587; /* line # 587 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+647);
  Ra.sl[3]=589; /* line # 589 */
  Rv0=-6;
  Ra.sl[3]=590; /* line # 590 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[3]=592; /* line # 592 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=593; /* line # 593 */
    if (Ri.ub[1]>0) {
      Ra.sl[3]=594; /* line # 594 */
      if (Rv0<0||(Rv0>=0&&Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[0])+1]!=33)&&Ri.c[PAS__RANGE(1,
1,(UL)Ri.ub[0])+1]!=35) {
        Ra.sl[3]=597; /* line # 597 */
        Rv0=Rv0+1;
      }
    }
  }
  Ra.sl[3]=599; /* line # 599 */
  PAS__CLOSE(&V_inp,0);
  Ra.sl[3]=600; /* line # 600 */
  PAS__OPEN(&V_inp,0, V_inp_name.s,1,0,-1);
  Ra.sl[3]=602; /* line # 602 */
  PAS__SELECT_INP(V_inp);
  PAS__READ_STR(Ri.s,0,0);
  PAS__READ_EOLN();
  Ra.sl[3]=603; /* line # 603 */
  while (Ri.ub[1]>0&&Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32)
  Ri.ub[1]=Ri.ub[1]-1;
  Ra.sl[3]=604; /* line # 604 */
  Rv1=1;
  Ra.sl[3]=605; /* line # 605 */
  Ri.ub[258]=0;
  Ra.sl[3]=606; /* line # 606 */
  while (Rv1<Ri.ub[1]&&Ri.ub[258]==0){
    Ra.sl[3]=608; /* line # 608 */
    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
    PAS__READ_STR(Ri.s+257,16,1);
    PAS__READ_EOLN();
    Ra.sl[3]=609; /* line # 609 */
    if (PAS__EQ_STR(Ri.s+257,Rd.s+655)) Ri.ub[258]=0;
  }
  Ra.sl[3]=611; /* line # 611 */
  PAS__SET_CASE(Ri.s+257,1);
  Ra.sl[3]=612; /* line # 612 */
  Rv2=PAS__EQ_STR(Ri.s+257,Rd.s+658);
  Ra.sl[3]=613; /* line # 613 */
  Rv3=Rv0;
  Rv4=PAS__NEW(Rv3*16+340);
  ((SL *)Rv4)[0]=Rv3;
  ((UB *)Rv4)[24]=62;
  ((UB *)Rv4)[88]=62;
  ((UB *)Rv4)[152]=62;
  Ra.sl[3]=614; /* line # 614 */
  RPWDATA_OUT_init_pattern(Rv4);
  Ra.sl[3]=615; /* line # 615 */
  Rv5=Rv4;
  Ra.sl[3]=617; /* line # 617 */
  Rv6=(F)1.000000E+00;
  Rv7=(F)1.000000E+00;
  Ra.sl[3]=618; /* line # 618 */
  Rv8=(F)1.000000E-04;
  Rv9=0;
  Ra.sl[3]=619; /* line # 619 */
  ((F *)Rv5)[62]=(F)1.000000E-03;
  Ra.sl[3]=620; /* line # 620 */
  if (Rv2) {
    Ra.sl[3]=622; /* line # 622 */
    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
    PAS__READ_CHAR(&Rv10);
    PAS__READ_STR(Rv5+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=623; /* line # 623 */
    for( Rf0=5;Rf0>0;Rf0-- ) {
      Ra.sl[3]=625; /* line # 625 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ri.s,0,0);
      PAS__READ_EOLN();
      Ra.sl[3]=626; /* line # 626 */
      while (Ri.ub[1]>0&&Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32)
      Ri.ub[1]=Ri.ub[1]-1;
      Ra.sl[3]=627; /* line # 627 */
      Rv1=1;
      Ra.sl[3]=628; /* line # 628 */
      Ri.ub[258]=0;
      Ra.sl[3]=629; /* line # 629 */
      while (Rv1<Ri.ub[1]&&Ri.ub[258]==0){
        Ra.sl[3]=631; /* line # 631 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_STR(Ri.s+257,16,1);
        PAS__READ_EOLN();
        Ra.sl[3]=632; /* line # 632 */
        if (PAS__EQ_STR(Ri.s+257,Rd.s+666)) Ri.ub[258]=0;
      }
      Ra.sl[3]=634; /* line # 634 */
      PAS__SET_CASE(Ri.s+257,1);
      Ra.sl[3]=635; /* line # 635 */
      if (PAS__EQ_STR(Ri.s+257,Rd.s+669)) {
        Ra.sl[3]=636; /* line # 636 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_SNGL(&Rv6,0);
        PAS__READ_SNGL(&Rv7,0);
        PAS__READ_SL(&Rv9,0);
        PAS__READ_SNGL(&Rv8,0);
        PAS__READ_EOLN();
      }
      else {
        Ra.sl[3]=638; /* line # 638 */
        if (PAS__EQ_STR(Ri.s+257,Rd.s+676)||PAS__EQ_STR(Ri.s+257,Rd.s+682)) {
          Ra.sl[3]=640; /* line # 640 */
          PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
          PAS__READ_SNGL(((F *)Rv5)+65,0);
          PAS__READ_EOLN();
          Ra.sl[3]=641; /* line # 641 */
          if (V_dat_celsius||((F *)Rv5)[65]<=(F)0.000000E-01) {
            Ra.sl[3]=642; /* line # 642 */
            ((F *)Rv5)[65]=((F *)Rv5)[65]+(F)2.731600E+02;
          }
          Ra.sl[3]=643; /* line # 643 */
          ((F *)Rv5)[64]=((F *)Rv5)[65];
          ((F *)Rv5)[63]=((F *)Rv5)[64];
        }
        else {
          Ra.sl[3]=646; /* line # 646 */
          if (PAS__EQ_STR(PAS__SUBSTR_STR(Ra.s+16,Ri.s+257,1,7), Rd.s+695)) {
            Ra.sl[3]=648; /* line # 648 */
            Rv11=0;
            Ra.sl[3]=649; /* line # 649 */
            while (Rv1<Ri.ub[1]&&Ri.c[PAS__RANGE(Rv1,1,(UL)Ri.ub[0])+1]!=58)
            Rv1=Rv1+1;
            Ra.sl[3]=650; /* line # 650 */
            Rv1=Rv1+1;
            Ra.sl[3]=651; /* line # 651 */
            Ri.ub[258]=0;
            Ra.sl[3]=652; /* line # 652 */
            if (Rv1<Ri.ub[1]) {
              Ra.sl[3]=653; /* line # 653 */
              PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
              PAS__READ_SNGL(((F *)Rv5)+54,0);
              PAS__READ_STR(Ri.s+257,0,1);
              PAS__READ_EOLN();
            }
            Ra.sl[3]=654; /* line # 654 */
            if (Ri.ub[258]>0) {
              PAS__VREAD_INIT(Ri.s+259,(SL)Ri.ub[258],NULL);
              PAS__READ_SNGL(((F *)Rv5)+55,0);
              PAS__READ_EOLN();
            }
          }
          else {
            Ra.sl[3]=657; /* line # 657 */
            if (PAS__EQ_STR(Ri.s+257,Rd.s+704)) {
              PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
              PAS__READ_SNGL(((F *)Rv5)+66,0);
              PAS__READ_EOLN();
            }
            else {
              Ra.sl[3]=659; /* line # 659 */
              if (PAS__EQ_STR(Ri.s+257,Rd.s+712)) {
                PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                PAS__READ_SNGL(((F *)Rv5)+67,0);
                PAS__READ_EOLN();
              }
              else {
                Ra.sl[3]=661; /* line # 661 */
                if (PAS__EQ_STR(Ri.s+257,Rd.s+721)) {
                  PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                  PAS__READ_SNGL(((F *)Rv5)+68,0);
                  PAS__READ_EOLN();
                }
                else {
                  Ra.sl[3]=663; /* line # 663 */
                  if (PAS__EQ_STR(Ri.s+257,Rd.s+730)) {
                    PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                    PAS__READ_CHAR(&Rv10);
                    PAS__READ_STR(Rv5+88,0,0);
                    PAS__READ_EOLN();
                  }
                  else {
                    Ra.sl[3]=665; /* line # 665 */
                    if (PAS__EQ_STR(Ri.s+257,Rd.s+738)) {
                      PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                      PAS__READ_CHAR(&Rv10);
                      PAS__READ_STR(Rv5+24,0,0);
                      PAS__READ_EOLN();
                    }
                    else {
                      Ra.sl[3]=667; /* line # 667 */
                      if (PAS__EQ_STR(Ri.s+257,Rd.s+745)) {
                        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
                        PAS__READ_CHAR(&Rv10);
                        PAS__READ_SNGL(((F *)Rv5)+57,0);
                        PAS__READ_SNGL(((F *)Rv5)+58,0);
                        PAS__READ_SNGL(((F *)Rv5)+59,0);
                        PAS__READ_EOLN();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else {
    Ra.sl[3]=672; /* line # 672 */
    PAS__STR_TO_STR(Rv5+152,Ri.s);
    Ra.sl[3]=673; /* line # 673 */
    for( Rf0=5;Rf0>0;Rf0-- ) {
      PAS__SELECT_INP(V_inp);
      PAS__READ_EOLN();
    }
  }
  Ra.sl[3]=676; /* line # 676 */
  Rv12=1;
  Ra.sl[3]=677; /* line # 677 */
  while (Rv12<=Rv0){
    Ra.sl[3]=678; /* line # 678 */
    Rv13=(((S *)Rv5)+PAS__RANGE(Rv12,1,((SL *)Rv5)[0])*16+324);
    Ra.sl[3]=680; /* line # 680 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Ri.s,0,0);
    PAS__READ_EOLN();
    Ra.sl[3]=681; /* line # 681 */
    if (Ri.c[PAS__RANGE(Ri.ub[1],1,(UL)Ri.ub[0])+1]<32) Ri.ub[1]=Ri.ub[1]-1;
    Ra.sl[3]=682; /* line # 682 */
    if (Ri.ub[1]>0) {
      Ra.sl[3]=683; /* line # 683 */
      if (Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[0])+1]!=35&&Ri.c[PAS__RANGE(1,1,(UL)Ri.ub[
0])+1]!=33) {
        Ra.sl[3]=685; /* line # 685 */
        Rv1=1;
        Ra.sl[3]=686; /* line # 686 */
        PAS__VREAD_INIT(Ri.s+2,(SL)Ri.ub[1],&Rv1);
        PAS__READ_SNGL(&Rv14,0);
        PAS__READ_SNGL(&Rv15,0);
        PAS__READ_STR(Ri.s+257,0,1);
        PAS__READ_EOLN();
        Ra.sl[3]=687; /* line # 687 */
        if (Ri.ub[258]>0) {
          PAS__VREAD_INIT(Ri.s+259,(SL)Ri.ub[258],NULL);
          PAS__READ_SNGL(&Rv16,0);
          PAS__READ_EOLN();
        }
        else {
          Ra.sl[3]=688; /* line # 688 */
          Rv16=sqrt(fabs(Rv15));
        }
        Ra.sl[3]=689; /* line # 689 */
        Rv14=Rv14*Rv6;
        Rv15=Rv15*Rv7;
        Rv16=Rv7*Rv16;
        Ra.sl[3]=690; /* line # 690 */
        if (Rv12==1) {
          Ra.sl[3]=692; /* line # 692 */
          Rv17=Rv14;
          Rv18=Rv14;
          Ra.sl[3]=693; /* line # 693 */
          Rv19=Rv15;
          Rv20=Rv15;
          Ra.sl[3]=694; /* line # 694 */
          ((F *)Rv5)[56]=Rv14*Rv6;
        }
        else {
          Ra.sl[3]=698; /* line # 698 */
          if (Rv17>Rv14) Rv17=Rv14;
          else {
            Ra.sl[3]=699; /* line # 699 */
            if (Rv18<Rv14) Rv18=Rv14;
          }
          Ra.sl[3]=700; /* line # 700 */
          if (Rv19>Rv15) Rv19=Rv15;
          else {
            Ra.sl[3]=701; /* line # 701 */
            if (Rv20<Rv15) Rv20=Rv15;
          }
        }
        Ra.sl[3]=703; /* line # 703 */
        ((SW *)Rv13)[6]=1;
        ((F *)Rv13)[0]=Rv14;
        ((F *)Rv13)[1]=Rv15;
        ((F *)Rv13)[2]=Rv16;
        Ra.sl[3]=704; /* line # 704 */
        ((UB *)Rv13)[14]=0;
        Ra.sl[3]=705; /* line # 705 */
        Rv12=Rv12+1;
      }
    }
  }
  Ra.sl[3]=708; /* line # 708 */
  ((F *)Rv5)[81]=Rv17;
  ((F *)Rv5)[82]=Rv18;
  Ra.sl[3]=709; /* line # 709 */
  ((F *)Rv5)[83]=Rv19;
  ((F *)Rv5)[84]=Rv20;
  Ra.sl[3]=711; /* line # 711 */
  V_smin=Rv19;
  V_smax=Rv20;
  Ra.sl[3]=712; /* line # 712 */
  V_tmin=((F *)Rv5)[65];
  V_tmax=((F *)Rv5)[65];
  Ra.sl[3]=713; /* line # 713 */
  V_thmin=Rv17;
  V_thmax=Rv18;
  Ra.sl[3]=714; /* line # 714 */
  V_gmin=Rv19;
  V_gmax=Rv20;
  Ra.sl[3]=717; /* line # 717 */
  V_npat=V_npat+1;
  Ra.sl[3]=718; /* line # 718 */
  Lx[1].sl[69]=1;
  V_tbpat.v[0]=Rv4;
  Ra.sl[3]=719; /* line # 719 */
  if (V_pat_first==NULL) V_pat_first=Rv4;
  else {
    Ra.sl[3]=720; /* line # 720 */
    ((V *)V_pat_last)[1]=Rv4;
  }
  Ra.sl[3]=721; /* line # 721 */
  V_pat_sel=Rv4;
  Ra.sl[3]=722; /* line # 722 */
  V_pat_last=Rv4;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_inlrx_format "  */
void RPWDATA_OUT_PRC_00000009(){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Rv1;
  V Rv2;
  register V Rv3;
  C Rv4;
  SL Rv5;
  F Rv6;
  F Rv7;
  register V Rv8;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+753;
  Ra.v[67]=Rd.s+14;
  Ra.sl[68]=737; /* line # 737 */
  PAS__STR_TO_STR(Lx[1].s+257,Rd.s+771);
  while (1){
    Ra.sl[68]=739; /* line # 739 */
    Rv0=0;
    while (1){
      Ra.sl[68]=742; /* line # 742 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ra.s,0,0);
      PAS__READ_EOLN();
      Ra.sl[68]=743; /* line # 743 */
      if (PAS__EOF(V_inp)) Rv0=-1;
      if (Rv0<0||(Ra.c[PAS__RANGE(1,1,(UL)Ra.ub[0])+1]==82&&Ra.c[PAS__RANGE(2,1,
      (UL)Ra.ub[0])+1]==65)&&Ra.c[PAS__RANGE(3,1,(UL)Ra.ub[0])+1]==87)  break;
    }
    Ra.sl[68]=745; /* line # 745 */
    if (Rv0<0)  break;
    Ra.sl[68]=746; /* line # 746 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SL(&Rv0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=747; /* line # 747 */
    Rv1=Rv0;
    Rv2=PAS__NEW(Rv1*16+340);
    ((SL *)Rv2)[0]=Rv1;
    ((UB *)Rv2)[24]=62;
    ((UB *)Rv2)[88]=62;
    ((UB *)Rv2)[152]=62;
    Ra.sl[68]=748; /* line # 748 */
    RPWDATA_OUT_init_pattern(Rv2);
    Ra.sl[68]=749; /* line # 749 */
    Rv3=Rv2;
    Ra.sl[68]=751; /* line # 751 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+55,0);
    PAS__READ_EOLN();
    Ra.sl[68]=752; /* line # 752 */
    for( Rf0=7;Rf0>0;Rf0-- ) {
      PAS__SELECT_INP(V_inp);
      PAS__READ_EOLN();
    }
    Ra.sl[68]=753; /* line # 753 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Rv3+152,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=754; /* line # 754 */
    RPWDATA_OUT_PRC_00000002(Rv3+152);
    Ra.sl[68]=755; /* line # 755 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+66,0);
    PAS__READ_EOLN();
    Ra.sl[68]=756; /* line # 756 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+67,0);
    PAS__READ_EOLN();
    Ra.sl[68]=763; /* line # 763 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_CHAR(&Rv4);
    PAS__READ_STR(Rv3+24,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=764; /* line # 764 */
    RPWDATA_OUT_PRC_00000002(Rv3+24);
    Ra.sl[68]=765; /* line # 765 */
    ((SL *)Rv3)[5]=V_npat+1;
    Ra.sl[68]=766; /* line # 766 */
    RPWDATA_OUT_PRC_00000001(12);
    Ra.sl[68]=767; /* line # 767 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_STR(Rv3+88,0,0);
    PAS__READ_EOLN();
    Ra.sl[68]=768; /* line # 768 */
    RPWDATA_OUT_PRC_00000002(Rv3+88);
    Ra.sl[68]=769; /* line # 769 */
    RPWDATA_OUT_PRC_00000001(15);
    Ra.sl[68]=770; /* line # 770 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_SNGL(((F *)Rv3)+65,0);
    PAS__READ_EOLN();
    Ra.sl[68]=771; /* line # 771 */
    ((F *)Rv3)[65]=((F *)Rv3)[65]+(F)2.731600E+02;
    Ra.sl[68]=772; /* line # 772 */
    ((F *)Rv3)[63]=((F *)Rv3)[65];
    Ra.sl[68]=773; /* line # 773 */
    ((F *)Rv3)[64]=((F *)Rv3)[65];
    Ra.sl[68]=774; /* line # 774 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    Ra.sl[68]=775; /* line # 775 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_EOLN();
    while (1){
      Ra.sl[68]=777; /* line # 777 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_STR(Ra.s,0,0);
      PAS__READ_EOLN();
      if (Ra.c[PAS__RANGE(1,1,(UL)Ra.ub[0])+1]==48)  break;
    }
    Ra.sl[68]=779; /* line # 779 */
    Rv5=0;
    Ra.sl[68]=780; /* line # 780 */
    ((F *)Rv3)[81]=((F *)Rv3)[56];
    Ra.sl[68]=781; /* line # 781 */
    ((F *)Rv3)[82]=((F *)Rv3)[56]+(float)Rv0*((F *)Rv3)[62];
    Ra.sl[68]=782; /* line # 782 */
    Rv6=(F)1.000000E+010;
    Rv7= -Rv6;
    Ra.sl[68]=783; /* line # 783 */
    ((SL *)Rv3)[77]=1;
    ((SL *)Rv3)[78]=Rv0;
    Ra.sl[68]=784; /* line # 784 */
    while (Rv5<Rv0){
      Ra.sl[68]=786; /* line # 786 */
      Rv8=(((S *)Rv3)+PAS__RANGE(Rv5+1,1,((SL *)Rv3)[0])*16+324);
      Ra.sl[68]=788; /* line # 788 */
      ((SW *)Rv8)[6]=1;
      Ra.sl[68]=789; /* line # 789 */
      ((F *)Rv8)[0]=((F *)Rv3)[56]+(float)Rv5*((F *)Rv3)[62];
      Ra.sl[68]=790; /* line # 790 */
      PAS__SELECT_INP(V_inp);
      PAS__READ_SNGL(((F *)Rv8)+1,0);
      PAS__READ_EOLN();
      Ra.sl[68]=791; /* line # 791 */
      ((F *)Rv8)[2]=sqrt(fabs(((F *)Rv8)[1]));
      Ra.sl[68]=792; /* line # 792 */
      ((UB *)Rv8)[14]=0;
      Ra.sl[68]=794; /* line # 794 */
      if (Rv6>((F *)Rv8)[1]) Rv6=((F *)Rv8)[1];
      Ra.sl[68]=795; /* line # 795 */
      if (Rv7<((F *)Rv8)[1]) Rv7=((F *)Rv8)[1];
      Ra.sl[68]=797; /* line # 797 */
      Rv5=Rv5+1;
    }
    Ra.sl[68]=800; /* line # 800 */
    ((F *)Rv3)[83]=Rv6;
    ((F *)Rv3)[84]=Rv7;
    Ra.sl[68]=802; /* line # 802 */
    if (V_tmin>((F *)Rv3)[63]) V_tmin=((F *)Rv3)[63];
    Ra.sl[68]=803; /* line # 803 */
    if (V_tmax<((F *)Rv3)[63]) V_tmax=((F *)Rv3)[63];
    Ra.sl[68]=804; /* line # 804 */
    if (V_thmin>((F *)Rv3)[81]) V_thmin=((F *)Rv3)[81];
    Ra.sl[68]=805; /* line # 805 */
    if (V_thmax<((F *)Rv3)[82]) V_thmax=((F *)Rv3)[82];
    Ra.sl[68]=806; /* line # 806 */
    if (V_gmin>Rv6) V_gmin=Rv6;
    Ra.sl[68]=807; /* line # 807 */
    if (V_gmax<Rv7) V_gmax=Rv7;
    Ra.sl[68]=810; /* line # 810 */
    if (V_pat_first==NULL) V_pat_first=Rv2;
    else {
      Ra.sl[68]=811; /* line # 811 */
      ((V *)V_pat_last)[1]=Rv2;
    }
    Ra.sl[68]=812; /* line # 812 */
    V_pat_last=Rv2;
    Ra.sl[68]=814; /* line # 814 */
    V_npat=V_npat+1;
    if (PAS__EOF(V_inp))  break;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " get_sraw_format "  */
void RPWDATA_OUT_PRC_00000010(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  G Rv2;
  G Rv3;
  SL Rv4;
  register SL Rv5;
  V Rv6;
  register V Rv7;
  G Rv8;
  G Rv9;
  SL Rv10;
  register V Rv11;
  register G Rgg;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+779;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=828; /* line # 828 */
  Rv0=0;
  Ra.sl[3]=829; /* line # 829 */
  while (!PAS__EOF(V_inp)){
    Ra.sl[3]=831; /* line # 831 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv1,0);
    Ra.sl[3]=832; /* line # 832 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=833; /* line # 833 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv2,0);
    Ra.sl[3]=834; /* line # 834 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=835; /* line # 835 */
    PAS__SELECT_INP(V_inp);
    PAS__READ_DBLE(&Rv3,0);
    PAS__READ_EOLN();
    Ra.sl[3]=836; /* line # 836 */
    if (PAS__EOF(V_inp))  break;
    Ra.sl[3]=837; /* line # 837 */
    Rv0=Rv0+1;
    Ra.sl[3]=838; /* line # 838 */
    Rv4=PAS__G_ROUND((Rv3-Rv1)/Rv2)+1;
    Ra.sl[3]=839; /* line # 839 */
    Rv3=(double)((float)Rv4+(F)5.000000E-01)*Rv2+Rv1;
    Ra.sl[3]=840; /* line # 840 */
    Rv5=Rv4;
    Rv6=PAS__NEW(Rv5*16+340);
    ((SL *)Rv6)[0]=Rv5;
    ((UB *)Rv6)[24]=62;
    ((UB *)Rv6)[88]=62;
    ((UB *)Rv6)[152]=62;
    Ra.sl[3]=841; /* line # 841 */
    RPWDATA_OUT_init_pattern(Rv6);
    Ra.sl[3]=842; /* line # 842 */
    Rv7=Rv6;
    Ra.sl[3]=844; /* line # 844 */
    ((SL *)Rv7)[4]=Rv0;
    Ra.sl[3]=845; /* line # 845 */
    if (fabs(Rv1)<1.800000000000000E+002) {
      Ra.sl[3]=846; /* line # 846 */
      ((F *)Rv7)[56]=(float)Rv1;
      ((F *)Rv7)[62]=(float)Rv2;
    }
    Ra.sl[3]=847; /* line # 847 */
    ((F *)Rv7)[81]=((F *)Rv7)[56];
    Ra.sl[3]=848; /* line # 848 */
    ((F *)Rv7)[82]=((F *)Rv7)[56]+(float)(Rv4-1)*((F *)Rv7)[62];
    Ra.sl[3]=849; /* line # 849 */
    Rv8=(double)((F *)Rv7)[83];
    Rv9=(double)((F *)Rv7)[84];
    Ra.sl[3]=850; /* line # 850 */
    ((F *)Rv7)[66]=V_hkl_parm.f[0];
    ((F *)Rv7)[67]=V_hkl_parm.f[1];
    Ra.sl[3]=851; /* line # 851 */
    ((F *)Rv7)[68]=V_hkl_parm.f[2];
    Ra.sl[3]=852; /* line # 852 */
    Rv10=1;
    for( Rf0=Rv4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=853; /* line # 853 */
      Rv11=(((S *)Rv7)+PAS__RANGE(Rv10,1,((SL *)Rv7)[0])*16+324);
      Ra.sl[3]=855; /* line # 855 */
      ((F *)Rv11)[0]=(float)((double)(Rv10-1)*Rv2+Rv1);
      Ra.sl[3]=856; /* line # 856 */
      ((F *)Rv11)[1]=(F)0.000000E-01;
      Ra.sl[3]=857; /* line # 857 */
      if (!PAS__EOF(V_inp)) {
        PAS__SELECT_INP(V_inp);
        PAS__READ_SNGL(((F *)Rv11)+1,0);
      }
      Ra.sl[3]=858; /* line # 858 */
      ((F *)Rv11)[2]=sqrt(fabs(((F *)Rv11)[1]));
      Ra.sl[3]=859; /* line # 859 */
      ((UB *)Rv11)[14]=0;
      Ra.sl[3]=860; /* line # 860 */
      if (Rv8>(double)((F *)Rv11)[1]) Rv8=(double)((F *)Rv11)[1];
      Ra.sl[3]=861; /* line # 861 */
      if (Rv9<(double)((F *)Rv11)[1]) Rv9=(double)((F *)Rv11)[1];
      Rv10++;
    }
    Ra.sl[3]=864; /* line # 864 */
    ((F *)Rv7)[83]=(float)Rv8;
    ((F *)Rv7)[84]=(float)Rv9;
    Ra.sl[3]=866; /* line # 866 */
    if (V_tmin>((F *)Rv7)[63]) V_tmin=((F *)Rv7)[63];
    Ra.sl[3]=867; /* line # 867 */
    if (V_tmax<((F *)Rv7)[63]) V_tmax=((F *)Rv7)[63];
    Ra.sl[3]=868; /* line # 868 */
    if (V_thmin>((F *)Rv7)[81]) V_thmin=((F *)Rv7)[81];
    Ra.sl[3]=869; /* line # 869 */
    if (V_thmax<((F *)Rv7)[82]) V_thmax=((F *)Rv7)[82];
    Ra.sl[3]=870; /* line # 870 */
    if ((double)V_gmin>Rv8) V_gmin=(float)Rv8;
    Ra.sl[3]=871; /* line # 871 */
    if ((double)V_gmax<Rv9) V_gmax=(float)Rv9;
    Ra.sl[3]=874; /* line # 874 */
    if (V_pat_first==NULL) V_pat_first=Rv6;
    else {
      Ra.sl[3]=875; /* line # 875 */
      ((V *)V_pat_last)[1]=Rv6;
    }
    Ra.sl[3]=876; /* line # 876 */
    V_pat_last=Rv6;
    Ra.sl[3]=878; /* line # 878 */
    V_npat=V_npat+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_patterns "  */
void P_get_patterns(){
  jmp_buf L_lb_env;
  /* Define the automatic variable space. */
  Blk( Ra, 300 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  register V Rv2;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[74]=(V)L_lb_env;
  if (setjmp(L_lb_env )) goto L_l_0;

  Ra.ub[0]=255;
  Ra.ub[257]=14;
  Ra.v[70]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+280;
  Ra.v[71]=Rd.s+796;
  Ra.v[72]=Rd.s+14;
  Ra.sl[73]=885; /* line # 885 */
  Ra.sl[69]=0;
  Ra.sl[73]=886; /* line # 886 */
  PAS__OPEN(&V_inp,0, V_inp_name.s,4097,0,-1);
  Ra.sl[73]=887; /* line # 887 */
  if (PAS__iostatus!=0) {
    Ra.sl[73]=889; /* line # 889 */
    PAS__VWRITE_INIT(V_str_msg.s,1);
    PAS__WRITE_STR(Rd.s+810,-1,-1,32);
    PAS__WRITE_STR(V_inp_name.s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+850,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[73]=890; /* line # 890 */
    goto Ret_Label;
  }
  Ra.sl[73]=893; /* line # 893 */
  switch (V_inp_frm) {
    case 0:Ra.sl[73]=895; /* line # 895 */
    RPWDATA_OUT_PRC_00000003();
    break;
    case 1:Ra.sl[73]=897; /* line # 897 */
    RPWDATA_OUT_PRC_00000007();
    break;
    case 4:Ra.sl[73]=899; /* line # 899 */
    RPWDATA_OUT_PRC_00000008();
    break;
    case 5:Ra.sl[73]=901; /* line # 901 */
    RPWDATA_OUT_PRC_00000009();
    break;
    case 8:Ra.sl[73]=903; /* line # 903 */
    RPWDATA_OUT_PRC_00000010();
    break;
    default:Ra.sl[73]=906; /* line # 906 */
    PAS__STR_TO_STR(V_str_msg.s,Rd.s+858);
    Ra.sl[73]=907; /* line # 907 */
    goto Ret_Label;
    break;
  }
  Ra.sl[73]=910; /* line # 910 */
  P_set_pattern_selection();
  PAS__curr_cntx=Ra.s+280;
L_l_0:
  Ra.sl[73]=914; /* line # 914 */
  PAS__CLOSE(&V_inp,0);
  Ra.sl[73]=916; /* line # 916 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+922,-1,-1,32);
  PAS__WRITE_INT(V_npat,0,0);
  PAS__WRITE_STR(Rd.s+935,-1,-1,32);
  PAS__WRITE_STR(V_inp_name.s,-1,-1,32);
  PAS__WRITE_STR(Rd.s+960,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[73]=917; /* line # 917 */
  if (V_npat==0) {
    Ra.sl[73]=919; /* line # 919 */
    PAS__STR_TO_STR(V_str_msg.s,Rd.s+964);
    Ra.sl[73]=920; /* line # 920 */
    goto Ret_Label;
  }
  else {
    Ra.sl[73]=924; /* line # 924 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,24,-1,1,32);
    PAS__WRITE_STR(Rd.s+1019,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[73]=925; /* line # 925 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1038,-1,-1,32);
    PAS__WRITE_SNGL(V_thmin,8,3,0);
    PAS__WRITE_STR(Rd.s+1078,-1,-1,32);
    PAS__WRITE_SNGL(V_thmax,8,3,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_EOLN();
    Ra.sl[73]=926; /* line # 926 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1082,-1,-1,32);
    PAS__WRITE_SNGL(V_tmin,8,2,0);
    PAS__WRITE_STR(Rd.s+1122,-1,-1,32);
    PAS__WRITE_SNGL(V_tmax,8,2,0);
    PAS__WRITE_CHAR(44);
    PAS__WRITE_EOLN();
    Ra.sl[73]=927; /* line # 927 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,6,-1,1,32);
    PAS__WRITE_STR(Rd.s+1126,-1,-1,32);
    PAS__WRITE_SNGL(V_gmin,8,3,0);
    PAS__WRITE_STR(Rd.s+1166,-1,-1,32);
    PAS__WRITE_SNGL(V_gmax,8,3,0);
    PAS__WRITE_CHAR(46);
    PAS__WRITE_EOLN();
    Ra.sl[73]=928; /* line # 928 */
    if (V_ndia==0) {
      Ra.sl[73]=930; /* line # 930 */
      V_ndia=1;
      Ra.sl[73]=931; /* line # 931 */
      V_tbnp.sl[0]=1;
      Ra.sl[73]=932; /* line # 932 */
      V_tbpat.v[0]=V_pat_first;
      Ra.sl[73]=933; /* line # 933 */
      Rv0=V_pat_first;
      Ra.sl[73]=935; /* line # 935 */
      Rv1=1;
      for( Rf0=((SL *)Rv0)[0];Rf0>0;Rf0-- ) {
        Ra.sl[73]=936; /* line # 936 */
        Rv2=(((S *)Rv0)+PAS__RANGE(Rv1,1,((SL *)Rv0)[0])*16+324);
        Ra.sl[73]=937; /* line # 937 */
        if (V_gmin>((F *)Rv2)[1]) V_gmin=((F *)Rv2)[1];
        else {
          Ra.sl[73]=938; /* line # 938 */
          if (V_gmax<((F *)Rv2)[1]) V_gmax=((F *)Rv2)[1];
        }
        Rv1++;
      }
      Ra.sl[73]=940; /* line # 940 */
      V_smin=V_gmin;
      V_smax=V_gmax;
    }
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[70];
  Lx[1]=Lx_Sv;
}


/* Procedure/Function : " out_pattern "  */
void RPWDATA_OUT_PRC_00000011(V F_p, SL F_nb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  SL Rv6;
  SL Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  register int Rgi;
  register int Rgj;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1170;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=971; /* line # 971 */
  Rv0=F_p;
  Ra.sl[3]=972; /* line # 972 */
  switch (V_out_frm) {
    case 0:Ra.sl[3]=975; /* line # 975 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1276,-1,-1,32);
    PAS__WRITE_STR(Rv0+152,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=976; /* line # 976 */
    if (((V *)Rv0)[3]!=NULL) {
      Ra.sl[3]=978; /* line # 978 */
      Rv1=((V *)Rv0)[3];
      Ra.sl[3]=979; /* line # 979 */
      while (Rv1!=NULL){
        Ra.sl[3]=981; /* line # 981 */
        PAS__SELECT_OUT(V_out);
        PAS__WRITE_STR(Rd.s+1286,-1,-1,32);
        PAS__WRITE_CHT(Rv1+8,(UL)((UB *)Rv1)[0],-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[3]=982; /* line # 982 */
        Rv1=((V *)Rv1)[1];
      }
    }
    Ra.sl[3]=985; /* line # 985 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1294,-1,-1,32);
    PAS__WRITE_STR(Rv0+24,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=986; /* line # 986 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1301,-1,-1,32);
    PAS__WRITE_STR(Rv0+88,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=987; /* line # 987 */
    if (((SL *)Rv0)[4]!=0) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1310,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[4],10,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=988; /* line # 988 */
    if (((SL *)Rv0)[5]!=0) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1321,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[5],10,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=989; /* line # 989 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1329,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[66],10,6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[67],10,6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[68],10,6,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=990; /* line # 990 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1338,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[63],8,2,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[64],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[65],8,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=991; /* line # 991 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1345,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[54],12,0,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[55],9,0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=992; /* line # 992 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1355,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[60],10,5,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[61],10,5,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=993; /* line # 993 */
    if (((SL *)Rv0)[79]!=0) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1368,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[79],10,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=994; /* line # 994 */
    if (((SL *)Rv0)[80]!=0) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1383,-1,-1,32);
      PAS__WRITE_INT(((SL *)Rv0)[80],10,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=995; /* line # 995 */
    if (((F *)Rv0)[69]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1398,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[69],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=996; /* line # 996 */
    if (((F *)Rv0)[70]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1413,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[70],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=997; /* line # 997 */
    if (((F *)Rv0)[71]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1428,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[71],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=998; /* line # 998 */
    if (((F *)Rv0)[72]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1443,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[72],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=999; /* line # 999 */
    if (((F *)Rv0)[73]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1458,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[73],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1000; /* line # 1000 */
    if (((F *)Rv0)[74]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1473,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[74],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1001; /* line # 1001 */
    if (((F *)Rv0)[75]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1488,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[75],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1002; /* line # 1002 */
    if (((F *)Rv0)[76]!=(F)0.000000E-01) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_STR(Rd.s+1503,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv0)[76],16,-8,0);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1003; /* line # 1003 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1518,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[57],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[58],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[59],8,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1004; /* line # 1004 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1532,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv0)[0],8,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1005; /* line # 1005 */
    Rv2=1;
    for( Rf0=((SL *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=1006; /* line # 1006 */
      Rv3=(((S *)Rv0)+PAS__RANGE(Rv2,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=1008; /* line # 1008 */
      if (!(128&((UB *)Rv3)[14])) ((SW *)Rv3)[6]=-1;
      Ra.sl[3]=1009; /* line # 1009 */
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_INT(((SW *)Rv3)[6],3,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(((F *)Rv3)[0],8,3,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_SNGL(((F *)Rv3)[1],10,0,0);
      PAS__WRITE_SNGL(((F *)Rv3)[2],6,0,0);
      PAS__WRITE_EOLN();
      Rv2++;
    }
    Ra.sl[3]=1011; /* line # 1011 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1539,-1,-1,32);
    PAS__WRITE_EOLN();
    break;
    case 3:Ra.sl[3]=1016; /* line # 1016 */
    Rv4=1;
    for( Rf0=((SL *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=1017; /* line # 1017 */
      Rv5=(((S *)Rv0)+PAS__RANGE(Rv4,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=1019; /* line # 1019 */
      if (128&((UB *)Rv5)[14]) Rv6=0;
      else {
        Ra.sl[3]=1020; /* line # 1020 */
        Rv6=((SW *)Rv5)[6];
      }
      Ra.sl[3]=1021; /* line # 1021 */
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_INT(Rv4,6,0);
      PAS__WRITE_CHAR(32);
      PAS__WRITE_INT(Rv6,12,0);
      PAS__WRITE_SNGL(((F *)Rv5)[0],10,3,0);
      PAS__WRITE_SNGL(((F *)Rv5)[1],10,0,0);
      PAS__WRITE_SNGL(((F *)Rv5)[2],10,0,0);
      PAS__WRITE_EOLN();
      Rv4++;
    }
    break;
    case 1:Ra.sl[3]=1026; /* line # 1026 */
    ((F *)Rv0)[62]=(float)PAS__F_ROUND((((F *)Rv0)[82]-((F *)Rv0)[81])/(float)((
    (SL *)Rv0)[0]-1));
    Ra.sl[3]=1027; /* line # 1027 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rv0+24,20,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Rv0+88,10,-1,32);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_STR(Rv0+152,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1028; /* line # 1028 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_INT(F_nb,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[5],6,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[66],8,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[67],8,4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[68],8,5,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1029; /* line # 1029 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_SNGL(((F *)Rv0)[54],12,0,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[55],9,0,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[56],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[57],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[58],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[59],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[60],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[61],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[62],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[63],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[64],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[65],8,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1034; /* line # 1034 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_INT(((SL *)Rv0)[0],4,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[66],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[69],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[70],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[71],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[72],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[73],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[74],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[75],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[76],9,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_INT(((SL *)Rv0)[79],6,0);
    PAS__WRITE_STR(Rd.s+1544,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv0)[80],6,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1038; /* line # 1038 */
    Rv7=1;
    for( Rf0=((SL *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=1039; /* line # 1039 */
      Rv8=(((S *)Rv0)+PAS__RANGE(Rv7,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=1041; /* line # 1041 */
      if (128&((UB *)Rv8)[14]) {
        PAS__SELECT_OUT(V_out);
        PAS__WRITE_STR(Rd.s+1549,-1,-1,32);
      }
      else {
        Ra.sl[3]=1042; /* line # 1042 */
        PAS__SELECT_OUT(V_out);
        PAS__WRITE_INT(((SW *)Rv8)[6],2,0);
      }
      Ra.sl[3]=1043; /* line # 1043 */
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_SNGL(((F *)Rv8)[1],8,0,0);
      Ra.sl[3]=1044; /* line # 1044 */
      if (PAS__I_MOD(Rv7,10)==0) {
        PAS__SELECT_OUT(V_out);
        PAS__WRITE_EOLN();
      }
      Rv7++;
    }
    Ra.sl[3]=1046; /* line # 1046 */
    if (PAS__I_MOD(((SL *)Rv0)[0],10)!=0) {
      PAS__SELECT_OUT(V_out);
      PAS__WRITE_EOLN();
    }
    Ra.sl[3]=1047; /* line # 1047 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_INT(-1000,10,0);
    PAS__WRITE_EOLN();
    break;
    case 4:Ra.sl[3]=1052; /* line # 1052 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1553,-1,-1,32);
    PAS__WRITE_STR(Rv0+152,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1053; /* line # 1053 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1564,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[66],10,6,0);
    PAS__WRITE_STR(Rd.s+1605,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[67],10,6,0);
    PAS__WRITE_STR(Rd.s+1616,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[68],10,6,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1054; /* line # 1054 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1627,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[65],8,2,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[64],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[63],8,3,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1055; /* line # 1055 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1636,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[54],12,0,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[55],9,0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1056; /* line # 1056 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1685,-1,-1,32);
    PAS__WRITE_STR(Rv0+24,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1695,-1,-1,32);
    PAS__WRITE_STR(Rv0+88,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1057; /* line # 1057 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1705,-1,-1,32);
    PAS__WRITE_SNGL(((F *)Rv0)[57],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[58],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_SNGL(((F *)Rv0)[59],8,3,0);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1058; /* line # 1058 */
    Rv9=1;
    for( Rf0=((SL *)Rv0)[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=1059; /* line # 1059 */
      Rv10=(((S *)Rv0)+PAS__RANGE(Rv9,1,((SL *)Rv0)[0])*16+324);
      Ra.sl[3]=1060; /* line # 1060 */
      if (!(128&((UB *)Rv10)[14])) {
        PAS__SELECT_OUT(V_out);
        PAS__WRITE_SNGL(((F *)Rv10)[0],8,3,0);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_SNGL(((F *)Rv10)[1],10,0,0);
        PAS__WRITE_SNGL(((F *)Rv10)[2],6,0,0);
        PAS__WRITE_EOLN();
      }
      Rv9++;
    }
    break;
    case 8:break;
    default:Ra.sl[3]=1068; /* line # 1068 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1183,-1,-1,32);
    PAS__WRITE_EOLN();
    Ra.sl[3]=1069; /* line # 1069 */
    PAS__EXIT(2);
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " out_header "  */
UB RPWDATA_OUT_PRC_00000012(V F_fname, SL F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1716;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1080; /* line # 1080 */
  PAS__OPEN(&V_out,0, F_fname,2,0,-1);
  Ra.sl[3]=1081; /* line # 1081 */
  switch (V_out_frm) {
    case 0:Ra.sl[3]=1084; /* line # 1084 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1728,-1,-1,32);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=1089; /* line # 1089 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_INT(F_nd,5,0);
    PAS__WRITE_EOLN();
    break;
    default:Ra.sl[3]=1093; /* line # 1093 */
    Rv0=1;
    break;
  }
  Ra.sl[3]=1095; /* line # 1095 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " out_trailer "  */
void RPWDATA_OUT_PRC_00000013(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1738;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1102; /* line # 1102 */
  switch (V_out_frm) {
    case 0:Ra.sl[3]=1105; /* line # 1105 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_STR(Rd.s+1751,-1,-1,32);
    PAS__WRITE_EOLN();
    break;
    case 1:Ra.sl[3]=1110; /* line # 1110 */
    PAS__SELECT_OUT(V_out);
    PAS__WRITE_INT(-10000,10,0);
    PAS__WRITE_EOLN();
    break;
    default:break;
  }
  Ra.sl[3]=1115; /* line # 1115 */
  PAS__CLOSE(&V_out,0);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " write_normalized_file "  */
void P_write_normalized_file(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1756;
  Ra.v[2]=Rd.s+14;
  Ra.sl[3]=1121; /* line # 1121 */
  if (V_ndia>0) {
    Ra.sl[3]=1122; /* line # 1122 */
    if (V_ndia>1) {
      Ra.sl[3]=1124; /* line # 1124 */
      Rv0=RPWDATA_OUT_PRC_00000012(V_out_name.s,V_ndia);
      Ra.sl[3]=1125; /* line # 1125 */
      Rv1=V_pat_first;
      Ra.sl[3]=1126; /* line # 1126 */
      Rv2=0;
      while (1){
        Ra.sl[3]=1128; /* line # 1128 */
        Rv2=Rv2+1;
        Ra.sl[3]=1129; /* line # 1129 */
        Rv3=Rv1;
        Ra.sl[3]=1131; /* line # 1131 */
        if (Rv0) {
          Ra.sl[3]=1133; /* line # 1133 */
          PAS__VWRITE_INIT(Ri.s+291,1);
          PAS__WRITE_STR(V_out_name.s,-1,-1,32);
          PAS__WRITE_CHAR(95);
          PAS__WRITE_INT(Rv2,-4,0);
          PAS__WRITE_EOLN();
          Ra.sl[3]=1134; /* line # 1134 */
          Rv4=RPWDATA_OUT_PRC_00000012(Ri.s+291,Rv2);
        }
        Ra.sl[3]=1136; /* line # 1136 */
        if (V_tbpat.v[PAS__RANGE(Rv2,1,64)-1]!=NULL) {
          Ra.sl[3]=1137; /* line # 1137 */
          RPWDATA_OUT_PRC_00000011(V_tbpat.v[PAS__RANGE(Rv2,1,64)-1],Rv2);
        }
        Ra.sl[3]=1138; /* line # 1138 */
        if (Rv0) RPWDATA_OUT_PRC_00000013();
        Ra.sl[3]=1139; /* line # 1139 */
        Rv1=((V *)Rv3)[1];
        if (Rv2>=V_ndia)  break;
      }
      Ra.sl[3]=1142; /* line # 1142 */
      if (!Rv0) RPWDATA_OUT_PRC_00000013();
    }
    else {
      Ra.sl[3]=1146; /* line # 1146 */
      Rv4=RPWDATA_OUT_PRC_00000012(V_out_name.s,1);
      Ra.sl[3]=1147; /* line # 1147 */
      RPWDATA_OUT_PRC_00000011(V_tbpat.v[0],1);
      Ra.sl[3]=1148; /* line # 1148 */
      RPWDATA_OUT_PRC_00000013();
    }
  }
  else {
    Ra.sl[3]=1151; /* line # 1151 */
    if (V_npat>1) {
      Ra.sl[3]=1153; /* line # 1153 */
      Rv0=RPWDATA_OUT_PRC_00000012(V_out_name.s,V_ndia);
      Ra.sl[3]=1154; /* line # 1154 */
      Rv1=V_pat_first;
      Ra.sl[3]=1155; /* line # 1155 */
      Rv2=0;
      while (1){
        Ra.sl[3]=1157; /* line # 1157 */
        Rv2=Rv2+1;
        Ra.sl[3]=1158; /* line # 1158 */
        Rv5=Rv1;
        Ra.sl[3]=1160; /* line # 1160 */
        if (Rv0) {
          Ra.sl[3]=1162; /* line # 1162 */
          PAS__VWRITE_INIT(Ri.s+291,1);
          PAS__WRITE_STR(V_out_name.s,-1,-1,32);
          PAS__WRITE_CHAR(95);
          PAS__WRITE_INT(Rv2,-4,0);
          PAS__WRITE_EOLN();
          Ra.sl[3]=1163; /* line # 1163 */
          Rv4=RPWDATA_OUT_PRC_00000012(Ri.s+291,Rv2);
        }
        Ra.sl[3]=1165; /* line # 1165 */
        RPWDATA_OUT_PRC_00000011(Rv1, Rv2);
        Ra.sl[3]=1166; /* line # 1166 */
        if (Rv0) RPWDATA_OUT_PRC_00000013();
        Ra.sl[3]=1167; /* line # 1167 */
        Rv1=((V *)Rv5)[1];
        if (Rv1==NULL)  break;
      }
      Ra.sl[3]=1170; /* line # 1170 */
      if (!Rv0) RPWDATA_OUT_PRC_00000013();
    }
    else {
      Ra.sl[3]=1174; /* line # 1174 */
      Rv4=RPWDATA_OUT_PRC_00000012(V_out_name.s,1);
      Ra.sl[3]=1175; /* line # 1175 */
      RPWDATA_OUT_PRC_00000011(V_pat_first,1);
      Ra.sl[3]=1176; /* line # 1176 */
      RPWDATA_OUT_PRC_00000013();
    }
  }
  PAS__curr_cntx=Ra.v[0];
}
