{
        *****  CPAS Portable Shell External Environment  *******

*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}

%include 'PASENV:draw_defs.pas' {, list_on};


  {**********************************************************************************
  *                                                                                 *
  *                        Global  Constants  Declarations                          *
  *                                                                                 *
  **********************************************************************************}


const
  Max_Phase     =                    4;                 { Maximum number of phase in a sample }

  flt_max       =              1.0e+30;                 { Define the largest floatting number constant }

  npat_max      =                   32;                 { Maximum number of pattern to select }
  pi            =        4*ARCTAN( 1 );                 { The pi number }
  inrd          =             pi/180.0;                 { Cte to change from decimal degrees to radians }

  max_bckparm   =                    9;                 { Maximum number of parameter for a background polynome }

  Ice_Temp      =               273.16;                 { Ice fusion temperature in Kelvin }

  MAI_IDX       =                    0;                 { Main Setup Index }
  DRW_IDX       =                    1;                 { Common Draw setup Index }
  PRO_IDX       =                    2;                 { Process Setup Index }
  BCK_IDX       =                    3;                 { Background Setup Index }
  SEA_IDX       =                    4;                 { Search Reflections Setup Index }
  HKL_IDX       =                    5;                 { Fit Pattern with HKL Control Board }
  PH1_IDX       =                    6;                 { Phase_1 informations }
  PHL_IDX       =      PH1_IDX + Max_Phase - 1;         { Last Phase informations }

  Max_Setup     =              PHL_IDX;                 { Maximum number of Setup sections }

  unix_setup_path = './;HOME:/etc/;/usr/local/etc/';
  win_setup_path  = './;HOME:/etc/;LOCAL:/etc/;/usr/local/etc';

type
  real          =               Dfloat;                 { Force compatibility with DRAW Library }

  lsq_flt       =               Dfloat;                 { For Least-Squares process }

  integer       =                 Dint;                 { Force all integers to be DRAW System integer }

  linetype      =        string( 255 );                 { Output line type definition }

  labeltype     =        string(  62 );                 { String type for Setup/Pannel labels }

  fpa_tab       =    array[1..max_bckparm] of real;     { Table of fitted background parameters }

  functy = (                                            { * Program function definitions }
                        fc_write,                       { Function to write an output file }
                        fc_3dplot,                      { Function to do a 3D plot }
                        fc_plot,                        { Function to do a plot }
                        fc_ndia,                        { Function to specify a diagram number }
                        fc_light,                       { Function to set the Light mode }
                        fc_celsius,                     { Function to set celsius degrees for temperature }
                        fc_label,                       { Function for label on pattern plots }
                        fc_dir,                         { Function Ctalogue/Directory }
                        fc_verbose                      { Flag for verbose run mode }
           );

  functsety     =        set of functy;

  file_format = (                                       { * Pattern File format kind definitions }
                        pf_standard,                    { Our Standard format }
                        pf_d1b,                         { D1b/D20 file format }
                        pf_d1ba,                        { Alternate form of d1b file }
                        pf_column,                      { Column format }
                        pf_xydata,                      { XY-DATA format }
                        pf_macinelrx,                   { X-Ray Inel on Macintosh format }
                        pf_njafrm,                      { X-Ray small angles }
                        pf_d5000,                       { X-Ray D5000 }
                        pf_singleraw,                   { Single raw description }
                        pf_null                         { Null format for unspecified format }
                );

  mrk_kindty =  (                                       { * Marker types definitions }
                        mk_rfleft,                      { Dot is a left integration limit }
                        mk_rfright,                     { Dot is a right integration limit }
                        mk_rflcen,                      { Dot is the center of reflection line  }
                        mk_rflpos,                      { Dot is at reflexion line 2*theta angle }
                        mk_rflhkl,                      { Dot is at an indexed reflexion line }
                        mk_bckbeg,                      { Dot is background representative region begin }
                        mk_bckend,                      { Dot is background representative region end }

                        mk_invalid                      { Invalid/Canceled Dot to ignore }
                );

  fnc_type = ( fnc_gauss,                               { * Define the various type of peak function - Gaussian, ... }
               fnc_lorentz,                             { ... Lorentzian, ... }
               fnc_pvoigt                               { ... Pseudo Voigt. }
             );

  mrk_flgtyp = set of mrk_kindty;                       { * Define the pattern dor flag set type }

  label_ptr = ^label_rec;                               { * Define the label record pointer }

  label_rec( size: byte ) = record                      { * Define the label record }
    nxt: label_ptr;                                     { Link to next the record (or nil) }
    txt: packed array[1..size] of char                  { The related text }
  end;

  data_point = record                                   { * Record definition for a pattern point }
    theta,                                              { Theta angle }
    int,                                                { Intensity count }
    sig:                                  real;         { Intensity sigma }
    flag:                         word_integer;         { Integer Flag for dot validity }
    mflg:                           mrk_flgtyp          { Pattern Marker specifications }
  end;

  pat_ptr  =  ^pat_rec;                                 { Define a pointer of pattern }

  pat_rec( dim: integer ) = record                      { * Definition of Pattern record }
    next,                                               { Pointer to next pattern }
    prev:                              pat_ptr;         { Pointer to previous pattern }
    lab_lst:                         label_ptr;         { Pointer to the label records (or nil) }
    idcnt,                                              { Pattern index }
    numor:                             integer;         { Integer Identifier NUMOR }
    dateh,                                              { Pattern date and hour }
    sample,                                             { Sample on the measure }
    comment:                         labeltype;         { Pattern comment of 64 character max. }
    monitor,                                            { Monitor count }
    cnttime,                                            { Counting time }
    dtheta, omega, chi, phi,                            { Initial characteristic angles }
    tr1, tr2, step,                                     { Sample position X, Y values, theta step }
    t_set, t_reg, t_sample,                             { Pattern temperature: Setting, on regulator, on sample }
    lambda1, lambda2, rwave2,                           { Wave length(s) (old rvp1 free parameter) and intensities ratio }
    rvp2, rvp3, rvp4, rvp5,                             { Free real parameters rvp1..rvp9 }
    rvp6, rvp7, rvp8, rvp9:               real;
    ista, iend,                                         { Scan index limit number for internal use }
    ivp0, ivp1:                        integer;         { Free integer parameters ivp1 and ivp2 }
    amin, amax,                                         { Deduced Minimaxi on 2*theta }
    min,  max:                            real;         { Deduced Minimum and maximum of intensity }
    dat:           array[1..dim] of data_point          { The pattern dim points }
  end;


  crv_ptr  =  ^crv_rec;                                 { define a pointer of suplementary curve to plot }

  crv_rec( crv_sz: integer ) = record                   { * Define the Curve record }
    crv_nxt:                           crv_ptr;         { Link to the next curve }
    crv_lsz, crv_msz:                     real;         { Size to use for line and/or marker }
    crv_lco, crv_mco,                                   { Color to use for lines and markers }
    crv_lkn, crv_mkn, crv_ide: integer;                 { Kind of line, kind of marker, curve id. }
    crv_tab:        array[1..2*crv_sz] of real          { The curve crv_sz dots }
  end;

  prm_knd =  ( prm_wild,                                { * Define the kind of parameters wild => No action }
               prm_attr,                                { Attribute setting }
               prm_frm,                                 { Frame Value - Only for Graphic Display }
               prm_bool,                                { Boolean Value }
               prm_enm,                                 { Ennumerated Value }
               prm_int,                                 { Integer Value }
               prm_flt,                                 { Floating Value }
               prm_str,                                 { String Value }
               prm_txt );                               { Text Value - Only to output (comment) }

  text_ty( sz: Dint ) = array[1..sz] of char;           { * Define a text to display }

  pdsc_acc = record                                     { * Define the Pannel/Chapter Item type }
               nm:   labeltype;                         { Name of parameter }
               x, y, w, h: byte;                        { Lower Left Coordinates, Width and height in mm (for Pannel Display) }
               case kn: prm_knd of
                 prm_wild:( rw: $wild_pointer );        { Pointer to the variable }
                 prm_attr:( ft: ^string );              { Attributes setting }
                 prm_bool:( rb: ^boolean );             { Boolean Value }
                 prm_enm: ( ei: ^integer;               { Ennumerated value with list of value el }
                            el: ^Choice_List );
                 prm_int: ( ri: ^integer;               { Integer Value in the range li..ui }
                            li, ui: integer );
                 prm_flt: ( rf: ^real;                  { Floating Value in the range lr..ur with the minimum increment of st }
                            lr, ur, ac: real );
                 prm_str: ( rs: ^string );              { String Value }

                 prm_txt: ( tx: ^text_ty );             { Output comment text (for help) }
                 prm_frm: ( fw, st, ls, lk: byte );     { Frame to display: fw, st, ls, lk : Font Size (in mm), Font style, Line size, Line kind }
            end;

  pdsc_tab( ni: integer ) = record                      { * Define the Pannel/Chapter list record descriptor type }
              id:                         Dint;         { Draw Pannel Identifier }
              ti:                    labeltype;         { Table title }
              w, h:              word_unsigned;         { Width and Height (in mm) of Draw Pannel Window }
              tb:     array[1..ni] of pdsc_acc;         { Descriptor table }
            end;

  pdsc_ptr      =                    ^pdsc_tab;         { Define the parameter descriptor pointer type }

  pdsc_env( sz: integer ) = array[0..sz] of pdsc_ptr;   { Define an environment table }


  mai_prmty = record                                    { * Define the Label parameters environment }
              tit_s,                                    { Title of setup }
              lb1_s,  lb2_s,                            { Four lines of label/comment }
              lb3_s,  lb4_s:      linetype;
              th0_r,  ths_r,                            { Externaly user specified 2theta origine and step }
              tmi_r,  tma_r:          real;             { Externaly user specified 2theta Range }
              tmd_f:                 Dbool              { Flag For the Theta mode }
            end;

  drw_prmty = record                                    { * Define the Drawing parameters environment }
              hls_r, vls_r,                             { Horizontal and Vertical Label Shift }
              xsz_r, ysz_r, zsz_r,                      { Sizes of each axis for 2d and 3D Plot }
              pcs_r,                                    { Count Shift to apply for the different diffraction pattern }
              ome_r, chi_r, phi_r,                      { Eulerian angles Omega, chi and phi }
              dis_r:                  real;             { 3D Wiew Distance }
            end;


  hkl_prmty = record                                    { * Define the Integration/Phase/Indexation parameters context }
              gw1_r,  gw2_r,                            { Wave lengths (1 for neutron and 2 for X-ray }
              fwr_r,  fwr_s,                            { Effective Wave lengths intensity ratio with std. error }
              the_r,  the_s,                            { Theta origine error with std. error }
              wd0_r,  wd1_r,  wd2_r,                    { Fitted Width parameters for all pattern fit with unit cell ... }
              wd0_s,  wd1_s,  wd2_s,                    { ... and related std. errors }
              asy_r,  asy_s,                            { Reflection profile asymetry coefficient and std. error }
              mix_r,  mix_s,                            { Mixing factor for special profil function(s) 2 }
              mta_a,                                    { Monochromator angle or 0.0 (for X-ray polarization correction) }
              err_r:                  real;             { Indexation theta error tolerance }
              fbk_n,                                    { Background Polynome order to fit }
              bkm_i,  rwm_i,                            { Background fit mode, Reflection half width mode }
              rps_i,  lrz_i,                            { Profile specific parameter mode, Lorentz Factor mode }
              fnc_n:                  Dint;             { Type of profil }
              the_f,                                    { flag for Theta origine shift Fit }
              fbk_f,  fwr_f,                            { Flag to Fix/Unfix Background coefficient(s) and for asymetry coefficient }
              wd0_f,  wd1_f,  wd2_f,                    { Flags for Width parameters (For HKL FIT) }
              asy_f,  mix_f,                            { Flag for profil asymetric coefficient }
              pth_f,  pwd_f,  phg_f,                    { Global flags for direct (by zone without HKL) integration }
              pmx_f:                 Dbool
            end;


  idx_prmty = record                                    { * Define the Phase/Indexation parameters context }
              name,                                     { Name of the phase }
              group:             labeltype;             { Related Space Group Name }
              daa_v, dbb_v, dcc_v,                      { Unit Cell Parameters }
              dal_v, dbe_v, dga_v:    real;
              daa_f, dbb_f, dcc_f,                      { Flag for Fix/UnFix unit cell parameters }
              dal_f, dbe_f, dga_f,
              ena_f:                 Dbool;             { Flag to enable this phase indexing alpha (° or cosinus) }
            end;


  hkl_ptr  =  ^hkl_rec;                                 { * Define all global Object Pointer types }
  zon_ptr  =  ^zon_rec;
  pck_ptr  =  ^pck_rec;

  boo_tab( dim: integer ) = array[1..dim] of boolean;   { Define the type model arrays }
  int_tab( dim: integer ) = array[1..dim] of integer;
  flt_tab( dim: integer ) = array[1..dim] of    real;
  pat_tab( dim: integer ) = array[1..dim] of pat_ptr;
  pck_tab( dim: integer ) = array[1..dim] of pck_ptr;

  pattab1_int   =      array[1..npat_max] of integer;
  pattab1_flt   =      array[1..npat_max] of    real;
  pattab2_ptr   =    array[1..2*npat_max] of pat_ptr;
  pattab2_int   =    array[1..2*npat_max] of integer;
  pattab2_flt   =    array[1..2*npat_max] of    real;
  pattab2_boo   =    array[1..2*npat_max] of boolean;


  met_tens      =             array[1..6] of lsq_flt;   { * Define the metric tensor type }

  ope_mat       =  array[1..3,1..4] of short_integer;   { * Define a symetry operator matrix }

  ope_tblty( ng: byte ) =    array[1..ng] of ope_mat;   { * Define the operator table type }

  pha_rec = record                                      { * Phase record definition }
              cel_info:              idx_prmty;         { Phase Information }
              cel_group:             labeltype;         { Used group name }
              cel_ngrp,   cel_nsys,                     { Group number and crystal system as given by gen_space }
              cel_orient:              integer;         { Orientation number for monoclinic and orthorhombic systems }
              cel_dcell, cel_dcesg,                     { Direct Parameters and related sigmas }
              cel_rmt,     cel_rsg:   met_tens;         { Reciprocal Metric tensor and its sigma }
              cel_act:  array[1..6] of integer;         { Index table to optimize the Bragg angle computing }
              cel_sym:              ^ope_tblty;         { Space groupe matrix table array pointer }
              cel_ref:                 hkl_ptr          { Reflection list header (for the pattern theta range) }
            end;

  pha_tblty =   array[1..Max_Phase] of pha_rec;         { Define the array oh phases type }


  ihk_tab( sz: byte ) = array[1..sz] of record          { * Define the hkl index table type }
              ih, ik, il, nq, iq, ml: short_integer;
            end;

  ihk_ptr = ^ihk_tab;                                   {  * Define the hkl index table pointer type }

  hkl_rec = record                                      { * HKL record definition }
              next,                                     { Link to the next HKL in the hkl list }
              prev,                                     { Link to the previous HKL in the hkl list }
              hnxt:                    hkl_ptr;         { Link to the next HKL of the same peak/zone }
              pckp:                    pck_ptr;         { Link to the related peak or nil }
              zonp:                    zon_ptr;         { Link to the related zone or nil }
              rcell:                   integer;         { Related cell link index }
              theta:                   lsq_flt;         { 2 Theta (or theta) Computed Bragg angle }
              hkltb:                   ihk_ptr;         { Table of the equivalent hkl }
              heigh,  shigh,                            { Height of the reflection and std. error, ... }
              width,  swidt,                            { ... its Half-Width and std. error and ... }
              mixfc,  smixf:              real          { ... the profil mixing factor }
            end;

  zon_rec = record                                      { * Integration zone definition }
              next:                    zon_ptr;         { Link to next integration zone }
              pckf,                                     { Peak list header }
              pckl:                    pck_ptr;
              hklf,                                     { Peak Index Header }
              hkll:                    hkl_ptr;
              npeak,                                    { Number of detected peak in the zone }
              lfmar, rimar,                             { Left and right number of dots in margins }
              lflim, rilim,                             { Left and right data point index limits }
              izpr0, izpr1,                             { Index numbers for zone global spc. profile LSQ parm. }
              izwi0, izwi1:            integer;         { Index numbers for zone global width LSQ parm. }
              thmin, thmax,                             { Range of (2)Theta for the Zone }
              bchi2, rchi2,                             { Resulting  goodness of fit background and reflections }
              zwidth, zbkv, zbks,                       { Background value integral and related sigma }
              ztint, ztsint,                            { Total zone intensity and related std. error }
              zprf0, zprf1,                             { Global Zone profil specific parm. and sigma }
              zspr0, zspr1,
              zwid0, zwid1,                             { Global Zone reflection width parm. and sigma }
              zswi0, zswi1:            lsq_flt;
              bcf, bcs, bsav:          fpa_tab          { Array to keep fitted background polynom factor values and sigma, and saved values }
            end;

  pck_rec = record                                      { * Peak Definition Record }
              znxt,                                     { Link to next peak in the same integration zone }
              next:                    pck_ptr;         { Link to the next peak }
              zone:                    zon_ptr;         { Link to the related integration zone }
              idthe,  idhig,  idwid,                    { LSQ Identifier for each parameter to fit }
              idpr0,  idpr1:            integer;
              savth,  savhg,  savwd,                    { Saved value of initial (or last saved) peak parameter }
              thpos,  sthpo,                            { Top theta angle and sigma }
              heigh,  shigh,                            { Height of the reflection and std. error, ... }
              width,  swidt,                            { ... its Half-Width and std. error and ... }
              mixfc,  smixf,                            { ... the profil mixing factor. }
              intens, sigma:           lsq_flt;         { Total intensity and related sigma }
              ftyp:                   fnc_type;         { Kind of reflection line profil function }
              enaflg:                  boolean          { Flag to enable/disable the peak use }
            end;

  setup_tbtype  =        pdsc_env( Max_Setup );         { Setup type definition }



[external]
var
  default_setup,                                        { File Setup Default }
  setupf,                                               { Setup file Specification string }

  str_msg,                                              { String to build messages }

  int_name,                                             { Integration result file specification }
  out_name,                                             { Output file specification }
  inp_name:                           linetype;         { Input file specification }

  pat_sel,                                              { Pointer to the selected pattern }
  pat_first,                                            { Pointer to first and last pattern }
  pat_last:                            pat_ptr;

  crv_frs,                                              { Pointer to first and last additional curev to display }
  crv_lst:                             crv_ptr;

  inp_frm,                                              { input file format }
  out_frm:                         file_format;         { Output file format }

  inpl_frm,                                             { Line format string for input }
  outl_frm:                           linetype;         { Line format string for output }

  funcs:                             functsety;         { Set of function to execute }

  ndiat,                                                { Number of pattern to select by temperature }
  ndia,                                                 { Number of Pattern to Select by number }
  npat:                                integer;         { Total number of pattern in memory }

  tbtem:                           pattab1_flt;         { Table of Pattern temperature to select }
  tbnp:                            pattab1_int;         { Table of Pattern number to select }

  tbpat:                           pattab2_ptr;         { Table of Pattern pointer to select }
  tbknd:                           pattab2_boo;         { Table of Line/Marker mode flags }
  tbcol,                                                { Table of Line/Marker colors }
  tbtyp:                           pattab2_int;         { Table of Line/Marker kinds }
  tbsiz:                           pattab2_flt;         { Table of Line/Marker sizes }

  dstatus,                                              { Return status for DRAW Graphic Library }
  irep:                                   Dint;         { Return value for DRAW$DIALOG Procedure }

  cshift,                                               { Shift to apply at curve related to current pattern }
  e_thmin, e_thmax,                                     { Effective external current theta limits }
  smin,    smax,                                        { Minimum and Maximum of Selected Pattern }
  tmin,    tmax,                                        { Minimum and Maximum of temperature }
  thmin,   thmax,                                       { Minimum and Maximum of angle 2*theta }
  spthmin, spthmax,                                     { 2*theta mini-maxi of selected pattern }
  szthmin, szthmax,                                     { 2*theta mini-maxi of selected zone in the selected pattern }
  gmin,    gmax,                                        { General minimum and maximum }
  xs,      ys:                          Dfloat;         { Paper size for draw }

  sel_ileft, sel_iright:                  Dint;         { Left and Right limits of Angular domain (Zone). }

  sel_pat:                             pat_ptr;         { Current Selected Pattern pointer }

  hkl_free,                                             { Free Hkl list }
  hkl_first,                                            { HKL list header }
  hkl_last:                            hkl_ptr;

  nerr_flg,                                             { Flag for computing error during a fit }
  dat_celsius,                                          { Flag for default Celcius Temperature in input }
  fil_nbr,                                              { Flag for append pattern number to file name }
  out_app,                                              { Flag for append to previous result file }
  drw_ok:                                Dbool;         { Flag for Initialize graphic }

  nzone,                                                { Total number of defined integration zones }
  ntotpck,                                              { Total number of defined diffraction peaks }
  nenapck,                                              { Current number of Enabled peaks }

  frspint,                                              { First pattern to integrate }
  nbrpint,                                              { Number of pattern to integrate }
  ndat,                                                 { Number of data }
  np,                                                   { Total number of parameters }
  max_diag,                                             { Maximum of allowed singularities (by LSQ cycle) }
  nsing:                               integer;         { Number of detected singularity }

  phase_tbl:                         pha_tblty;         { Table of all phase record }

  vth0, sth0,                                           { Theta origine and related sigma }
  chi2eps,                                              { Increasing tolerance for chi2 in Marquardt mode }
  chi2,                                                 { Chi_squared = Goodness of fit }
  lchi2,                                                { Previous Chi_squared }
  nchi2:                               lsq_flt;         { Chi_squared*(n-v) = Goodness of fit numerator }


  out,                                                  { Output for pattern }
  inp:                                    text;         { Input File }

  mai_parm:                          mai_prmty;         { Main Setup }
  drw_parm:                          drw_prmty;         { Graphic Setup }
  hkl_parm:                          hkl_prmty;         { Fit Control board setup }

  setup_tab:                      setup_tbtype;         { Environment table for setup }




{ *** Setup Init procedures *** }

procedure MAIN$SETUP_INIT; external;

procedure BCK$DEFAULT_SETUP; external;

procedure REF$DEFAULT_SETUP; external;

procedure INT$DEFAULT_SETUP; external;

procedure INDEX$DEFAULT_SETUP; external;

procedure PRO$DEFAULT_SETUP; external;



{ *** Global procedures/functions *** }


procedure SET_REF( var p: $wild_pointer; var t: $wild_thing ); external 'RPW_Set_Ref';


function  WRITE_SETUP_FILE( in_var file_spc: string; var envtb: pdsc_env ): ^string;
external;

function  READ_SETUP_FILE( in_var file_spc: string; var envtb: pdsc_env ): ^string;
external;



{ *** Graphic Pannel procedures/functions *** }

procedure BUILD_PANNEL( var pan_descr: pdsc_tab ); external;



{ *** Input/Output Pattern Data procedures/functions *** }

procedure INIT_LOAD; external;

procedure GET_PATTERNS; external;

procedure WRITE_NORMALIZED_FILE; external;



{ *** Graphic procedures/functions *** }

procedure MAKE_3D; external;

procedure MAKE_2D( nd: integer ); external;

function  NEW_CURVE( nsz, id, lco, mco, lkn, mkn: integer; lsz, msz: real ): crv_ptr; external;

procedure DEL_CURVE( pc: crv_ptr ); external;

procedure PLT_CURVE( pc: crv_ptr ); external;

procedure UPDATE_CURVE( var pc: crv_ptr; nsz: integer ); external;

function  GET_NEW_PARAMS( var parm_tab: pdsc_tab ): integer; external;



{ *** Integration procedures/functions *** }

procedure INTEGR$UPDATE_PAT_INFO; external;

procedure INTEGR$SELECT_PATTERN( p: pat_ptr ); external;

procedure INTEGR$SET_LIMIT( min, max: real );  external;

procedure INTEGR$SUPPRESS_BACKGROUND; external;

procedure INTEGR$SET_BACKGROUND( in_var bcktb: array[sz:integer] of Dfloat; len: Dint ); external;

function  INTEGR$BUILD_BACKGROUND: ^string; external;

procedure INTEGR$SMOOTH_BACKGROUND; external;



function  INTEGR$REF_LOCATE: ^string; external;

function  INTEGR$REF_COPY: ^string; external;

function  INTEGR$SET_REFZONE( lt, rt: real ): ^string; external;

function  INTEGR$SET_REFLINE( th, hg, wd: real; fhkl: mrk_flgtyp := [] ): ^string; external;

function  INTEGR$ZONE_DEL( th: real ): ^string; external;

function  INTEGR$LINE_DEL( th: real ): ^string; external;

function  INTEGR$FREE_ALLZ: ^string; external;

procedure INTEGR$SAVE_A_PCK; external;

procedure INTEGR$RELOAD_A_PCK; external;

procedure INTEGR$SAVE_Z_PCK( th: real ); external;

procedure INTEGR$RELOAD_Z_PCK( th: real ); external;

function  INTEGR$REF_INTEGR: ^string; external;


procedure INTEGR$HKL_SET_HKL( var flg: boolean; var emsg: ^string ); external;

function  INTEGR$HKL_INDEX: ^string; external;



function  INTEGR$WRITE_RESULTS: ^string; external;

function  INTEGR$PROCEED: ^string; external;



{ *** Least Squares procedures/functions *** }


procedure LSQ$INIT; external;

function  LSQ$NEW_VPARM( var prm, sig: lsq_flt; min, max: lsq_flt := flt_max ): integer; external;

function  LSQ$NEW_BLOCK( dmp, mrq: lsq_flt ): integer; external;

procedure LSQ$SET_DMP_MRQ( id: integer; dmp, mrq: lsq_flt ); external;

procedure LSQ$INIT_CYCLE; external;

procedure LSQ$SET_ELEM( delta, weight: lsq_flt; in_var drvtab: array[size: integer] of lsq_flt );
external;

procedure LSQ$INIT_DERV; external;

procedure LSQ$SET_DERV( id: integer; drv: lsq_flt ); external;

procedure LSQ$SET_CONTR( delta, weight: lsq_flt ); external;

function  LSQ$PROCESS( bend, bchg, bmrq: boolean;
          function CH_PARM( i: integer; v_o, v_n, v_c, v_s, min, max: lsq_flt ): lsq_flt ): boolean;
external;

procedure LSQ$RESTORE_PARM; external;

function  LSQ$CORREL( ii, jj: integer ): lsq_flt;
external;

{ *** End of environment file *** }
