{
*************************************************************************
*                                                                       *
*                                                                       *
*        R P W D A T A  (Reduce Powder DATA for Diffraction)            *
*                                                                       *
*                2D DRAW Interface Graphic Module                       *
*                                                                       *
*             ( ILL Data Base Manager Source File )                     *
*                                                                       *
*                Version  1.1-C  - - 30-Nov-2009                        *
*                                                                       *
*                                by                                     *
*                                                                       *
*                  Pierre Wolfers, Institut Neel                        *
*                                                                       *
*          CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166              *
*                                                                       *
*                     F 38042 GRENOBLE CEDEX 9                          *
*                                                                       *
*                           F R A N C E                                 *
*                                                                       *
*                                                                       *
*                                                                       *
*************************************************************************

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}
module RPWDATA_DRAW2D;

%include 'RPWSRC:rpwdata_env' {, list_on};


const
  { 2D Keys Menu definitions }
  Clic_Load                    =     1;         { Open and read a data (with pattern(s)) file }
  Clic_Close                   =     2;         { Close the current file }
  Clic_Save                    =     3;         { Save the current pattern }
  Clic_Save_As                 =     4;         { Save the current pattern on a new file }

  Clic_Next_Pattern            =     6;         { To skip to next pattern }
  Clic_Prev_Pattern            =     7;         { To skip to previuos pattern }

  Clic_Select_Pattern          =    10;         { Pattern Selection }
  Clic_Set_Th_Range            =    11;         { Set Theta Range action }
  Clic_Reset_Th_Range          =    12;         { Reset Theta Range action }
  Clic_Left_Sh_Th_Rng          =    13;         { Left Shift Theta Range }
  Clic_Right_Sh_Th_Rng         =    14;         { Right Shift Theta Range }

  Clic_Output_File             =    15;         { Set MXD Output Data_File Characteristics }

  Clic_Backgrd_Enter           =    20;         { To enter the background by hand }
  Clic_Zone_Enter              =    21;         { To enter a new reflection zone for integration }
  Clic_Line_Enter              =    22;         { To enter a new reflection line in a zone for integration }
  Clic_Zone_Delete             =    23;         { To suppress a zone }
  Clic_Line_delete             =    24;         { To suppress a line - in a zone }

  Clic_Build_Backgrd           =    31;         { To build a background automatically }
  Clic_Smooth_Backgrd          =    32;         { To smooth the Background }
  Clic_Lines_Search            =    33;         { Lines Search action }
  Clic_Lines_Index             =    34;         { Lines Index action }
  Clic_Intensities             =    35;         { Lines Intensities Evaluation action }
  Clic_Output_Results          =    36;         { Output the current integration results }

  Clic_Integr_Proc             =    39;         { Integration procedure set/create/save and execute }

  Clic_Set_Win_Range           =    41;         { Set Theta Range by Window interaction }
  Clic_Set_Num_Range           =    42;         { Set Theta Range by Numeric interaction }
  Clic_Set_Shift_Rate          =    43;         { Set the shift ratio in rage ]0..1] }

  Clic_Fit_Save                =    45;
  Clic_Fit_Z_Save              =    46;
  Clic_Fit_Reload              =    47;
  Clic_Fit_Z_Reload            =    48;

  Clic_Mai_Setup        = 50 + MAI_IDX;         { Show the main Pannel }
  Clic_Drw_Setup        = 50 + DRW_IDX;         { Show the graphic Pannel }
  Clic_Bck_Setup        = 50 + BCK_IDX;         { Show the Background Pannel }
  Clic_Ref_Setup        = 50 + SEA_IDX;         { Show the Line Reflection Pannel }
  Clic_Hkl_Setup        = 50 + HKL_IDX;         { Show the HKL FIT Control Board }
  Clic_Pro_Setup        = 50 + PRO_IDX;         { Show the Process options Pannel }

  Clic_Setup_default           =    60;         { Reset original default for setup }
  Clic_Setup_Sav_as            =    61;         { Save as for Setup }
  Clic_Setup_Save              =    62;         { Save Setup }
  Clic_Setup_restore           =    63;         { Restore Setup }

  Clic_P1_Setup                =    66;         { To open the setup for the varius phases (cell) }
  Clic_P2_Setup                =    67;
  Clic_P3_Setup                =    68;
  Clic_P4_Setup                =    69;


var
  unt: unit_type;                               { Unit type of pixel }
  xs, ys: Dfloat;                               { Paper size in unt units }

  setup_to_save:         boolean :=  false;     { Flag for setup registred }

  dstatus,                                      { Return status for DRAW Graphic Library }
  irep:                               Dint;     { Return value for DRAW$DIALOG Procedure }

  inp_id_fltr,
  out_id_fltr,
  res_id_fltr,
  set_id_fltr:           integer :=      1;     { File filters Index for result and setup }

  pattern_fltr: Draw_Menu( 7, 12 ) := ['*.fpd', '*.d1b', '*.d20', '*.inelrx', '*.xydata', '*.col*', '*'];
  result_fltr: Draw_Menu( 3, 12 ) := ['*.dat', '*.hkl', '*'];       { File filter for result files }
  setupf_fltr: Draw_Menu( 2, 12 ) := ['*.rpw_data', '*'];           { File filter for Setup }
  outint_fltr: Draw_Menu( 3, 12 ) := ['*.dat', '*.hkl', '*'];       { File to write fitted intensities }



{**********************************************************************************
*                                                                                 *
*                   Small Procedures to manage curves to plot                     *
*                                                                                 *
**********************************************************************************}


[global]
function  NEW_CURVE( nsz, id, lco, mco, lkn, mkn: integer; lsz, msz: real ): crv_ptr;
var
  pc: crv_ptr;

begin
  NEW( pc, nsz );
  with pc^ do
  begin
    crv_nxt :=  nil;
    crv_lsz :=  lsz; crv_msz :=  msz;
    crv_lco :=  lco; crv_mco :=  mco;
    crv_lkn :=  lkn; crv_mkn :=  mkn;
    crv_ide :=   id;
    { The dots xx,yy must be put in the array crv_tab by the user. }
  end;
  if crv_lst = nil then crv_frs := pc
                   else crv_lst^.crv_nxt := pc;
  crv_lst := pc;
  NEW_CURVE := pc
end NEW_CURVE;



[global]
procedure DEL_CURVE( pc: crv_ptr  );
var
  p0, p1: crv_ptr;

begin
  if pc <> nil then
  begin
    p0 :=     nil;
    p1 := crv_frs;
    while (p1 <> nil) and (p1 <> pc) do
    begin  p0 := p1; p1 := p1^.crv_nxt  end;
    if p1 = pc then
    begin
      if p0 = nil then crv_frs := p1^.crv_nxt
                  else p0^.crv_nxt := p1^.crv_nxt;
      if crv_lst = pc then crv_lst := p0
    end;
    DISPOSE( pc )
  end
end DEL_CURVE;



[global]
procedure UPDATE_CURVE( var pc: crv_ptr; nsz: integer );
var
  p0: crv_ptr;
  ll: integer;

begin
  if pc <> nil then
  with pc^ do
  begin
    ll := ABS( nsz );
    P0 := NEW_CURVE( ll, crv_ide, crv_lco, crv_mco, crv_lkn, crv_mkn, crv_lsz, crv_msz );
    if nsz < 0 then
    begin { We must copy the data }
      if crv_sz < ll then ll := crv_sz;
      for ii := 1 to 2*ll do
        p0^.crv_tab[ii] := crv_tab[ii]
    end;
    DEL_CURVE( pc )
  end;
  pc := p0
end UPDATE_CURVE;



[global]
procedure PLT_CURVE( pc: crv_ptr );
var ip: integer := 1;
begin
  if pc <> nil then
  with pc^ do
  if (crv_lkn > 0) or (crv_mkn > 0) then
  begin
    if crv_lkn > 0 then
    begin
      DRAW$OUT_MODE( PLOT_LINE );
      DRAW$LINE_ATTR( crv_lkn, crv_lsz );
      DRAW$COLOR( crv_lco )
    end
    else
    begin
      DRAW$OUT_MODE( PLOT_MARKER );
      DRAW$MARKER_ATTR( crv_mkn, crv_msz );
      DRAW$COLOR( crv_mco )
    end;
    DRAW$MPLOT( crv_tab, crv_sz )
  end
end PLT_CURVE;




{**********************************************************************************
*                                                                                 *
*                               Drawing Procedures                                *
*                                                                                 *
**********************************************************************************}


procedure INIT_PLOT; forward;



[global]
procedure BUILD_PANNEL( var pan_descr: pdsc_tab );
const
  dfnt = 'Adobe Helvetica';

[static]
var
  xx, yy, ww, hh:       Dfloat;
  blb, batt:             Dbool;
  lab:               labeltype;

  sfl, sfv:     ^string := nil;
  slp, stl, stv:          Dint;
  ssl, ssv:             Dfloat;

  procedure SET_ATTR( id, lp, tl, tv: Dint; sl, sv: Dfloat; in_var fl, fv: string );
  begin
(*
WRITELN( ' Id= ', id:0, ' Attr (Lp, Lst, Vst, Lsz, Vsz, Lfnt, Vfnt) = ', lp, tl, tv, sl, sv, ' "', fl, '", "', fv, '"' );
*)
    if sl > 0.0 then
    begin
      if lp > 0 then DRAW$PANNEL_ATTR( id, lp );{ Set Label position }
      DRAW$PANNEL_ATTR( id, true, sl );         { Set font size for labels }
      if fl.length > 0 then
        DRAW$PANNEL_ATTR( id, true, fl, tl )    { Set Label Font }
    end;
    if sv > 0.0 then
    begin
      DRAW$PANNEL_ATTR( id, false, sv );        { Set font size for Values }
      if fv.length > 0 then
        DRAW$PANNEL_ATTR( id, false, fv, tv )   { Set Value Font }
    end
  end SET_ATTR;


begin
  if drw_ok then
    with pan_descr do
    begin
      batt := false;
      id := DRAW$PANNEL_CREATE( w*0.1, h*0.1, ti );     { Create the Pannel }
      slp := Drw_Align_Left; stl := 1; stv := 0;
      ssl := 12.0; ssv := 12.0;
      sfl := dfnt"address; sfv := dfnt"address;
      SET_ATTR( id, slp, stl, stv, ssl, ssv, dfnt, dfnt );
      for it := 1 to ni do
      with tb[it] do
      begin
        if kn = prm_attr then
        begin
          batt := true; blb := x > 0;
          if blb then
          begin { For Label attribute specification }
            slp := x;                                           { Get the Label Position choice }
            if y > 0 then                                       { When a Font size is specified }
            begin
              ssl := 1.0*y;                                     { Get the Label Font Size }
              if nm.length > 0 then                             { When a FOnt is specified }
              begin  sfl := nm"address; stl := w mod 4  end     { Get the Label Font Name and Style }
            end
          end
          else
          begin { For Value attribute specification }
            if y > 0 then                                       { When a Font size is specified }
            begin
              ssv := 1.0*y;                                     { Get the Value Font Size }
              if nm.length > 0 then                             { When a FOnt is specified }
              begin  sfv := nm"address; stv := w mod 4  end     { Get the Value Font Name and Style }
            end
          end;
          SET_ATTR( id, slp, stl, stv, ssl, ssv, sfl^, sfv^ )
        end
        else
        begin
          xx := x*0.1; yy := y*0.1;
          ww := w*0.1; hh := h*0.1;
          if kn <> prm_frm then lab := SUBSTR( nm, INDEX( nm, ':' ) + 1 );
          case kn of
            prm_bool: DRAW$PANNEL_ADD( id, xx, yy, ww, hh, lab, rb^ );
            prm_enm:  DRAW$PANNEL_ADD( id, xx, yy, ww, hh, lab, ei^, el^, 0 );
            prm_int:  DRAW$PANNEL_ADD( id, xx, yy, ww, hh, lab, ri^, li, ui );
            prm_flt:  DRAW$PANNEL_ADD( id, xx, yy, ww, hh, lab, rf^, lr, ur, ac );
            prm_str:  DRAW$PANNEL_ADD( id, xx, yy, ww, hh, lab, rs^ );
            prm_txt:  DRAW$PANNEL_ADD_TEXT( id, xx, yy, ww, hh, lab, tx^ );
            prm_frm:
              begin
                if not batt then SET_ATTR( id, Drw_Align_Inside_Top, st mod 4,   0, 1.0*fw, 0.0, sfl^, dfnt );
                DRAW$PANNEL_ADD_FRAME( id, xx, yy, ww, hh, nm, 1.0*ls, lk );
                if not batt then SET_ATTR( id,                  slp,      stl, stv,    ssl, 0.0, sfl^, dfnt );
              end;
            otherwise
          end;
          batt := false
        end
      end
    end
end BUILD_PANNEL;



[global]
procedure MAKE_2D( nd: integer );
const
  max_nbc = 2;

  bck_max = 128;                                { Maximum number of point to enter as background }

  xh_dir = Dpoint3[  1.0,  0.0,  0.0];
  xv_dir = Dpoint3[  0.0,  1.0,  0.0];
  yh_dir = Dpoint3[  0.0,  1.0,  0.0];
  yv_dir = Dpoint3[ -1.0,  0.0,  0.0];

  msg_nonxt = ' *** RPW Error: The next pattern does not exist. ***';
  msg_noprv = ' *** RPW Error: The previous pattern does not exist. ***';

  msg_midbt = ' Press the middle mouse bouton when finished.';

type
  xy2tab = array[1..4] of Dfloat;

var
  flg_mrk,                                      { Flag to select the Marker Plot change }
  flg_crv,                                      { Flag to select the Additional Curve Plot change  }
  flg_hkl,                                      { Flag to plot phase hkl positions  }
  brgnum,                                       { Pattern Range selection mode }
  bstatus:                     boolean;

  inpfspc,
  exe_msg:               string( 128 );         { To generate a synthetic message before to start auto integration }

  ptr_msg:                     ^string;         { Message pointer for PEAK-LOCATE/INTEGRATION alert }

  pcrv:                        crv_ptr;         { Pointer to a add. curve to plot }

  i, j, k, irep, nbck:            Dint;         { Action to execute on DIALOG return, size of entered background }
  cmin,  cmax,                                  { Minimum and Maximum for Intensities axis }
  rxmin, rxmax, rymin, rymax,
  ptmin, ptmax,                                 { Pattern min and max in 2*theta }
  opcs_r,                                       { Memory of the previous pattern relative shift }
  otmi_r, otma_r,                               { Old minimum and maximum for setup theta range }
  shf, rv, r0, r1, dlt, wid:    Dfloat;

  bck_tab: [static] array[1..2*bck_max] of Dfloat;      { Array of enterd point for background }

  istatus,                                      { Input status }
  pbox, mbox,                                   { Boxe identifiers for partterns and markers }
  lseg, ispbox,                                 { Segments # for Pattern Boxe and patterns }
  ismbox, ismrk,                                { Segments # for Marker Boxe and markers }
  isadcv,                                       { Additional curve segment }
  dstatus,                                      { Entry number for DRAW$DIALOG Return }
  npbk, nppk:   [static]     Dint := 0;         { Peak Search min point for background and peak }

  shift_rp:     [static] Dfloat := 0.9;         { Shift values }

  spat_nbr,                                     { Selected Pattern display number }
  th_axis,                                      { 2*theta axis identifier }
  cp_axis,                                      { Count axis identifier }
  rm_axis,                                      { Reflection Lines Marker axis identifier }
  pt_ibox,                                      { Pattern box identifier }
  rm_ibox,                                      { Reflection lines markers box identifier }
  pt_ibsg,                                      { Pattern box segment identifier }
  pt_ipsg:                        Dint;         { Pattern segment identifier }

  pt_bdir:      array[1..2] of    Dint;         { Table of pattern box directives }
  pt_bshf:      array[1..1] of  Dfloat;         { Table of pattern box axis shift value }

  rw1, rw2, rw2w1,                              { Memory to keep old waves length there ratio }
  rm_hg:                        Dfloat;         { Vertical size of the Reflection markers }
  rm_yp: array[1..Max_Phase+2] of  Dfloat;      { Vertical positions of marker in count unit (until Max_Phase phasis) }
(*
  ax_tfre, ay_tfre,
  ax_tknd, ay_tknd: array[1..4] of   Dint;
  ax_tsiz, ay_tsiz: array[1..4] of Dfloat;
*)



  procedure CREATE_AXIS_BOXES;
  { Create the AXis box }
  var
    th_mi, th_ma, cp_sh, rm_ys:         Dfloat;
    th_md, th_st, tmi, tma, nmi, nma:     Dint;

  begin
    with drw_parm do
    begin
      cp_sh := 3.0*(cmax - cmin)/ysz_r;         { Compute the count zero shift }
      rm_ys := 0.2*cp_sh; rm_hg := 0.8*rm_ys;   { Compute the Y of the various markers }
      for ii := 1 to Max_Phase+2 do  rm_yp[ii] := ii*rm_ys - cp_sh;

      th_mi := ROUND( e_thmin - 0.5 );          { Round to integer the theta limits and range size }
      th_ma := ROUND( e_thmax + 0.5 );
      th_st := ROUND( th_ma - th_mi );
      if th_st <  10 then th_md := -1           { Select an appropriate axis ticks model }
                     else if th_st < 100 then th_md := -4
                                         else th_md := -8;

(*  box := Draw$Easy_Box_2D( 2.0, 2.5, gaxxsz, gaxysz, e_thmin, e_thmax, cmin-shy, cmax, ' 2*theta', 'Counts', 2 ); *)


      th_axis := DRAW$NEW_AXIS( xh_dir, xv_dir, xsz_r,  th_mi, th_ma, 10, Axis_Arrow+Axis_ArroF );
      cp_axis := DRAW$NEW_AXIS( yh_dir, yv_dir, ysz_r,   cmin - cp_sh,  cmax, 0, Axis_Arrow+Axis_ArroF );

      Draw$Set_Axis_Ticks( th_axis, th_st, th_md , pt_bdir, pt_bdir, pt_bshf );
(*    Draw$Set_Axis_Ticks( th_axis, th_st, th_md );
(*    Draw$Set_Axis_Ticks( cp_axis, th_st, th_md, pt_bdir, pt_bdir, pt_bshf ); *)

      pt_bdir[1] := Axis_Plot_X + Axis_PFlg_TVl{+ Axis_PFlg_YPos}; { Set boxes directive tables }
      pt_bdir[2] := Axis_Plot_Y + Axis_PFlg_TVl + Axis_PFlg_TPrm;
      pt_bshf[1] := - cp_sh;                    { Set the Y shift of count axis - it is data dependent }

      Draw$Set_Axis_Unit( th_axis, '2*theta' ); { Set the axis unit name strings }
      Draw$Set_Axis_Unit( cp_axis, 'Counts'  );

      pt_ibox := DRAW$NEW_BOX( Dpoint3[2.0, 3.0, 0.0], th_axis, cp_axis, 0, pt_bdir, pt_bshf );

      pt_ibsg := DRAW$NEW_SEG( 10 );            { Create the pattern box Segment }
      DRAW$COLOR( 1 );
      DRAW$LINE_ATTR( 1, 1.0 );
      DRAW$PLOT_BOX( pt_ibox )                  { Plot the Axis Box for pattern }
    end
  end CREATE_AXIS_BOXES;


  procedure DEL_AXIS_BOXES;
  begin
     DRAW$DEL_SEG( pt_ibsg );                   { Delete the pattern box Segment }
     DRAW$DEL_SEG( pt_ipsg );                   { Delete the pattern(s) Segment }
     DRAW$DEL_SEG( isadcv );                    { Delete any Additional curve segment }
     DRAW$FREE_BOX_LIST                         { Delete the pattern box and the markers box }
  end DEL_AXIS_BOXES;



  procedure PLOT_A_RMARKER( th, hg: real; mflg: mrk_flgtyp; var iref: boolean );
  var
    xx, yy:     [static]         Dfloat;
    tbp, tbb:   [static]         xy2tab;
    lnty:                       integer;

  begin
    tbp[1] := th;
    tbp[3] := th;
    if mk_invalid in mflg then
    begin { Marker for Pattern invalid point }
      tbp[2] := rm_yp[Max_Phase+2];
      DRAW$MARKER_ATTR( 4, 2.0 );
      DRAW$OUT_MODE( PLOT_MARKER ); DRAW$COLOR( 1 { black } );
      DRAW$MPLOT( tbp, 1 )
    end
    else
    begin
      if mk_bckend in mflg then
      begin { Marker for a right background limit }
        tbb[3] := th; tbb[4] := tbb[2];
        DRAW$LINE_ATTR( 1, 4.0 );
        DRAW$OUT_MODE( PLOT_LINE ); DRAW$COLOR( 0.0, 0.6, 0.0 { Dark Green } );
        DRAW$MPLOT( tbb, 2 );
      end;

      if mk_bckbeg in mflg then
      begin { Marker for left background limit }
        tbb[1] := th; tbb[2] := rm_yp[Max_Phase+1]
      end;

      if mflg*[mk_rfleft,mk_rfright] <> [] then
      begin { Markers for Left/right integration zone limits }
        tbp[2] := rm_yp[Max_Phase+2];
        tbp[4] := rm_yp[Max_Phase+2] + rm_hg;
        DRAW$LINE_ATTR( 1, 2.0 );
        DRAW$OUT_MODE( PLOT_LINE ); DRAW$COLOR( 1 { Black } ); 
        DRAW$MPLOT( tbp, 2 );

        if iref and (mk_rfright in mflg) then
        begin
          DRAW$OUT_MODE( PLOT_LINE ); DRAW$COLOR( 2 { Red } ); DRAW$LINE_ATTR( 1, 4.0 );
          tbp[1] := xx; tbp[2] := yy + 0.5*rm_hg; tbp[4] := tbp[2];
          DRAW$MPLOT( tbp, 2 );
          iref := false
        end;
        if mk_rfleft in mflg then
        begin  xx := th; yy := rm_yp[Max_Phase+2]; iref := true  end
      end;

      if mflg*[mk_rflcen,mk_rflpos] <> [] then
      begin{ For a Diffraction Line Marker }
        if mk_rflhkl in mflg then if mk_rflpos in mflg then lnty := 1
                                                       else lnty := 4
                             else if mk_rflpos in mflg then lnty := 2
                                                       else lnty := 3;
        DRAW$LINE_ATTR( lnty, 2.0 );
        DRAW$COLOR( 3 { Blue } );
        tbp[1] :=  th; tbp[3] :=  th;
        tbp[2] := 0.0; tbp[4] :=  hg + cshift;
        DRAW$MPLOT( tbp, 2 )
      end
    end
  end PLOT_A_RMARKER;



  procedure PLOT_MARKERS;
  var
    bs: boolean;
    sg:    Dint;

  begin
    sg := DRAW$UPDATE_SEG( 50 );
    bs := false;
    with sel_pat^ do
      for ij := sel_ileft to sel_iright do      { Loop on the area pattern points }
      with dat[ij] do
        if mflg <> [] then PLOT_A_RMARKER( theta, int, mflg, bs );
    DRAW$SEG_END
  end PLOT_MARKERS;



  procedure PLOT_A_PATTERN( p: pat_ptr; shift: real );
  var
    slab:                 string( 32 );
    bs:                        boolean;
    xx, yy, zz, te:               real;
    ir, il:                    integer;

  begin
    il :=     0;                                { No default last point }
    ir :=     0;
    bs := false;                                { Looking for start point }
    if p <> nil then
    with drw_parm, p^ do
    begin
      for ij := 1 to dim do                     { Loop on the pattern points }
        with dat[ij] do
          if (theta >= e_thmin) and (theta <= e_thmax) then
          begin                                 { When the point is in the theta range, ... }
            DRAW$PLOT( theta, int + shift, bs );{ ... we plot it ... }
            if il = 0 then il :=   ij;          { ... and il keep the last valid point (except for the first one). }
            ir := ij;
            bs := true                          { Set the pen down state }
          end;

      DRAW$RPLOT( 0.0, 0.0, false );            { Finish the pattern plot. }

      if sel_pat = p then                       { Plot the markers for selected pattern only }
      begin
        PLOT_MARKERS;                           { Plot any existing marker }
(*      DRAW$PLOT( 0.0, 0.0, false ) *)
      end;

      if (fc_label in funcs) and (il > 0) then  { Add plot pattern label when required }
      with dat[il] do
      begin
        ir := DRAW$CONV_BOX( false, e_thmax, shift, 0.0, xx, yy, zz  );
        te := t_sample;
        if fc_celsius in funcs then te := te - Ice_Temp;
        WRITEV( slab, ' T = ', t_sample:6:2 );
        DRAW$STRING( xx + hls_r, yy + vls_r, 0.0, 0.4, slab )
      end
    end
  end PLOT_A_PATTERN;


  procedure PLOT_ADD_CURVE;
  begin
    if crv_frs <> nil then
    begin
      if isadcv = 0 then isadcv := DRAW$NEW_SEG( 15 )
                    else DRAW$UPDATE_SEG( isadcv );
      pcrv := crv_frs;
      while pcrv <> nil do
      with pcrv^ do
      begin
        PLT_CURVE( pcrv );
        pcrv := crv_nxt
      end;
      DRAW$SEG_END
    end
    else
      if isadcv > 0 then DRAW$DEL_SEG( isadcv )
  end PLOT_ADD_CURVE;



  procedure PLOT_HKL_POSITIONS;
  var
    prf:               hkl_ptr;
    xx, y1, y2:         Dfloat;
    tbp:       [static] xy2tab;
    iph:               integer;
    bsg, ipn:          boolean;

  begin
    bsg := false;
    ipn := false;
    prf := hkl_first;
    while prf <> nil do
      with prf^ do
      begin
        iph := rcell;
        if phase_tbl[iph].cel_info.ena_f then
        begin
          xx := theta; y1 := rm_yp[iph]; y2 := y1 + 0.8*rm_hg;
          if not bsg then
          begin { No opened segment => create or update the segment }
            if ismrk = 0 then ismrk := DRAW$NEW_SEG( 20 )
                         else ismrk := DRAW$UPDATE_SEG( ismrk );
            DRAW$LINE_ATTR( 1, 1.0 );
            DRAW$COLOR( 0.0, 0.0, 0.0 );
            DRAW$OUT_MODE( PLOT_LINES );
            bsg := true
          end;
          if (xx > e_thmin) and (xx < e_thmax) then
          begin
            DRAW$PLOT( xx, y1, ipn ); ipn := true;
            DRAW$PLOT( xx, y2, true )
(*
            DRAW$MPLOT( tbp, 2 )
*)
          end
        end;
        prf := next
      end;

    if bsg then begin  DRAW$PLOT( xx, y2, false ); DRAW$SEG_END  end
           else if ismrk > 0 then begin  DRAW$DEL_SEG( ismrk ); ismrk := 0  end
  end PLOT_HKL_POSITIONS;



  function  GET_PATNBR( p: pat_ptr ): integer;
  var
    pc: pat_ptr;
    id: integer;

  begin
    id :=         0;
    pc := pat_first;
    while (pc <> nil) and (pc <> p) do begin  pc := pc^.next; id := id + 1  end;
    if pc <> nil then GET_PATNBR := id
                 else GET_PATNBR :=  0
  end GET_PATNBR;



  function  KNOWN_PATTERN( inp_type: integer; bout: boolean := false ): integer;
  var
    id, i, j: integer;
    styp: string( 16 );

    ftypo: [static] Draw_Menu( 7, 8 ) := ['FPD', 'RPW', 'D1B', 'D20', 'INELRX', 'XYDATA', 'COLUMN'];
    ftypi: [static] Draw_Menu( 6, 8 ) := ['FPD', 'RPW', 'D1B', 'D20', 'INELRX', 'XYDATA'];

  begin
    { This part of code supply the not update filter index problem of DRAW$GET_FILE }
    id := INDEX( inp_name, '.', -1 );
    if id > 0 then
    begin
      styp := '*'||SUBSTR( inp_name, id );
      SET_CASE( styp, false );
      i := 1;
      while (i<7) and (styp <> pattern_fltr[i]) do i := i + 1;
    end
    else i := 7;
    { This part of code must will be always usefull }
    if bout and (i > 6) then
      i := DRAW$GET_CHOICE( 'Output Format', ftypo )
    else
      if not bout and (i > 5) then KNOWN_PATTERN :=  DRAW$GET_CHOICE( 'Input Format', ftypi );
    if bout then
      case i of
        1, 2: out_frm := pf_standard;
        3, 4: out_frm := pf_d1b;
        5:    out_frm := pf_macinelrx;
        6:    out_frm := pf_xydata;
        7:    out_frm := pf_column;
      otherwise
      end
    else
      case i of
        1, 2: inp_frm := pf_standard;
        3, 4: inp_frm := pf_d1b;
        5:    inp_frm := pf_macinelrx;
        6:    inp_frm := pf_xydata;
      otherwise
      end;
    KNOWN_PATTERN := i
  end KNOWN_PATTERN;



begin { MAKE_2D }
  with mai_parm, drw_parm, hkl_parm do
  begin
    flg_mrk := false;
    flg_crv := false;
    flg_hkl := false;
    spat_nbr :=    1;
(*
    if FILE_ACCESS_CHECK( setupf, 4 { read access } ) then INTEGR$GET_PARM( setupf, ptr_msg );
*)

    INIT_PLOT;
    if not drw_ok then return;                  { The DRAW System cannot start }

    for ii := 0 to Max_Setup do
      if setup_tab[ii] <> nil then BUILD_PANNEL( setup_tab[ii]^ );

ET_START:
    if str_msg.length > 0 then
    begin
      DRAW$MESSAGE( str_msg );
      str_msg.length := 0
    end;

    isadcv := 0;

    if (ndia >= 1) and (tbpat[1] <> nil) then
    begin
      INTEGR$SELECT_PATTERN( tbpat[1] );
      DRAW$PANNEL_PUT( setup_tab[MAI_IDX]^.id );
      frspint := GET_PATNBR( tbpat[1] );
      if (xsz_r < 5.0) or (xsz_r > 300.0) then xsz_r := 24.0;
      if (ysz_r < 5.0) or (ysz_r > 300.0) then ysz_r := 16.0;
      bstatus := DRAW$PICTURE( inp_name, xsz_r + 4.0, ysz_r + 5.0, false, true );

      { Set the default value on incredible shift values }
      if (pcs_r > 2.0) or (pcs_r < 0.0) then pcs_r := 0.20;

      if fc_celsius in funcs then
      begin  cmin := cmin - Ice_Temp; cmax := cmax - Ice_Temp  end;

      INTEGR$HKL_SET_HKL( flg_hkl, ptr_msg )
    end
    else sel_pat := nil;

ET_TH_RANGE:
    if sel_pat <> nil then
    begin
      ptmin := thmin; ptmax := thmax;
      if (tmi_r < 1.0e3) and (tmi_r > ptmin) then ptmin := tmi_r;
      if (tma_r < 1.0e3) and (tma_r < ptmax) then ptmax := tma_r;
      e_thmin := ptmin; e_thmax := ptmax;
      brgnum := false                           { Select the window input mode }
    end;

ET_CP_RANGE:
    if sel_pat <> nil then
    begin
      pcs_r := ABS( pcs_r );
      opcs_r := pcs_r;                          { Get the initiale relative shift }
      dlt := pcs_r*(smax - smin);               { Compute the shift increment between each pattern ... }
      cmin := smin; cmax := smax+dlt*(ndia-1);  { ... and the mini-maxi of the count coordinates }
      CREATE_AXIS_BOXES;                        { Create all boxes and related segments }

      DRAW$OPEN_BOX( pt_ibox );                 { Open the pattern box }

      pt_ipsg := DRAW$NEW_SEG( 11 );
      DRAW$SEG_ATTR( pt_ipsg, 2, 1, 2, 1.0 );   { Set as detectable, not High-Light, Visible, with priority 1.0 }
      for id := 1 to ndia do                    { Loop on all the patterns }
      begin
        shf := (id - 1)*dlt;                    { Get the Pattern shift }
        DRAW$UPDATE_SEG( pt_ipsg, 1 {Append } );{ Force to append to pattern segment }
        DRAW$SET_PICKID( id );                  { Set a pick identifier for each pattern }
        DRAW$COLOR( tbcol[id] );
        if tbknd[id] then
        begin { Marker Mode }
          DRAW$OUT_MODE( PLOT_MARKER );
          DRAW$MARKER_ATTR( tbtyp[id], tbsiz[id] )
        end
        else
        begin
          DRAW$OUT_MODE( PLOT_LINE );
          DRAW$LINE_ATTR( tbtyp[id], tbsiz[id] )
        end;
        if tbpat[id] = sel_pat then cshift := shf;{ Establish the selected pattern shift }
        PLOT_A_PATTERN( tbpat[id], shf )
      end;
      DRAW$SEG_END;

      if flg_mrk then begin  flg_mrk := false; PLOT_MARKERS  end;
      if flg_crv then begin  flg_crv := false; PLOT_ADD_CURVE  end;
      if flg_hkl then begin  flg_hkl := false; PLOT_HKL_POSITIONS  end
    end;

    ptr_msg := nil;
    repeat
      if ptr_msg <> nil then DRAW$MESSAGE( ptr_msg^ );
      ptr_msg := nil;

      rw1 := gw1_r; rw2 := gw2_r; rw2w1 := fwr_r;

      irep := DRAW$DIALOG( 1 );

      if Draw_Pannel_Ident <> 0 then
      begin
        if Draw_Pannel_Ident > 0 then
          DRAW$PANNEL_GET( Draw_Pannel_Ident )
        else
          for ii := 0 to Max_Setup do
            if setup_tab[ii] <> nil then DRAW$PANNEL_GET( setup_tab[ii]^.id );

        if (gw1_r <> rw1) or (gw2_r <> rw2) or (fwr_r <> rw2w1) then INTEGR$UPDATE_PAT_INFO;

        INTEGR$HKL_SET_HKL( flg_hkl, ptr_msg );

        DRAW$CLOSE_BOX;
        DEL_AXIS_BOXES;
        goto ET_TH_RANGE
{       goto ET_CP_RANGE     { Update image when the relative shift was changed }
      end;

      case irep of
        Clic_Load:
          begin
            istatus := DRAW$SELECT_FILE( 'Pattern Data File', { Transaction Title }
                                         pattern_fltr,        { File type Filter }
                                         'rpwdata.spf',       { Default file specification }
                                         inp_name,            { Selected file (Result) }
                                         inp_id_fltr );       { Filter index }
            if istatus > 0 then istatus := KNOWN_PATTERN( inp_id_fltr );
            if istatus > 0 then
            begin
              GET_PATTERNS;
              funcs := funcs + [fc_ndia,fc_plot];
              WRITELN( ' GET_PATTERNS => NDIA, NPAT = ', ndia, npat );
              goto ET_START
            end
          end;

        Clic_Close:
          begin
            (* Do nothing *)
          end;

        Clic_Save,
        Clic_Save_As:
          begin
            (* Do nothing *)
          end;

        Clic_Next_Pattern:        { Skip to next diffraction pattern }
          if sel_pat^.next <> nil then
          begin
            sel_pat := sel_pat^.next;
            tbpat[spat_nbr] := sel_pat;
            frspint := frspint + 1;
            INTEGR$SET_LIMIT( e_thmin, e_thmax );
            INTEGR$REF_COPY;
            DEL_AXIS_BOXES;
            flg_mrk := true; flg_crv := true;
            flg_hkl := true;
            goto ET_CP_RANGE
          end
          else ptr_msg := msg_nonxt"address;

        Clic_Prev_Pattern:        { Skip to next diffraction pattern }
          if sel_pat^.prev <> nil then
          begin
            sel_pat := sel_pat^.prev;
            tbpat[spat_nbr] := sel_pat;
            frspint := frspint - 1;
            INTEGR$SET_LIMIT( e_thmin, e_thmax );
            INTEGR$REF_COPY;
            DEL_AXIS_BOXES;
            flg_mrk := true; flg_crv := true;
            flg_hkl := true;
            goto ET_CP_RANGE
          end
          else ptr_msg := msg_noprv"address;

        Clic_Select_Pattern:      { Select a pattern }
          begin
            i := DRAW$SEG_PICK( j, spat_nbr );
            if (i > 0) and (j = pt_ipsg) then
            begin
              sel_pat := tbpat[spat_nbr];
              cshift := (spat_nbr - 1)*dlt;
              INTEGR$SELECT_PATTERN( sel_pat );
              INTEGR$SET_LIMIT( e_thmin, e_thmax );
              INTEGR$REF_COPY;
              frspint := GET_PATNBR( sel_pat );
              DEL_AXIS_BOXES;
              flg_mrk := true; flg_crv := true;
              flg_hkl := true;
              DRAW$PANNEL_PUT( setup_tab[MAI_IDX]^.id );
              goto ET_CP_RANGE
            end
          end;

        Clic_Set_Th_Range:        { Set a 2*theta Region }
          if sel_pat <> nil then
          begin
            if brgnum then
            begin { Range selection by Numeric input }
              istatus := DRAW$GET_VALUE( 'Th. Min', rxmin, e_thmin, e_thmax );
              if istatus = 1 then
                istatus := DRAW$GET_VALUE( 'Th. Max', rxmax, rxmin, e_thmax )
            end
            else
            begin { Range selection by mouse input }
              istatus := DRAW$GET_WINDOW( rxmin, rymin, rxmax, rymax );
(*            istatus := DRAW$GET_POSITION( rxmin, rymin );
              if istatus = 1 then istatus := DRAW$GET_POSITION( rxmax, rymax ) *)
(*            WRITELN( 'XWNd res = ', istatus:4, rxmin:10:2, rymin:10:2, rxmax:10:2, rymax:10:2 ); *)
              if rxmax < rxmin*1.05 then istatus := 0
            end;
            if istatus = 1 then
            begin
              e_thmin   := rxmin; e_thmax   := rxmax;
              DEL_AXIS_BOXES;
              flg_mrk := true; flg_crv := true;
              INTEGR$SET_LIMIT( e_thmin, e_thmax );
              INTEGR$FREE_ALLZ;
              flg_hkl := true;
              goto ET_CP_RANGE
            end
          end;

        Clic_Reset_Th_Range:      { Reset 2*theta Region to be the whole of pattern }
          begin
            e_thmin := ptmin; e_thmax := ptmax;
            if sel_pat <> nil then INTEGR$SET_LIMIT( e_thmin, e_thmax );
            DEL_AXIS_BOXES;
            flg_mrk := true; flg_crv := true;
            INTEGR$SELECT_PATTERN( sel_pat );
            INTEGR$FREE_ALLZ;
            flg_hkl := true;
            goto ET_TH_RANGE
          end;

        Clic_Left_Sh_Th_Rng,      { Left 2*theta Region Shift }
        Clic_Right_Sh_Th_Rng:     { Right 2*theta Region Shift }
          begin
            wid := e_thmax - e_thmin;
            rv := shift_rp*wid;
            if irep = Clic_Left_Sh_Th_Rng then
            begin
              e_thmin := e_thmin - rv;
              e_thmax := e_thmax - rv;
              if e_thmin < ptmin then begin  e_thmin := ptmin; e_thmax := e_thmin + wid  end
            end
            else
            begin
              e_thmin := e_thmin + rv;
              e_thmax := e_thmax + rv;
              if e_thmax > ptmax then begin  e_thmax := ptmax; e_thmin := e_thmax - wid  end
            end;
            if sel_pat <> nil then INTEGR$SET_LIMIT( e_thmin, e_thmax );
            DEL_AXIS_BOXES;
            flg_mrk := true; flg_crv := true;
            INTEGR$SET_LIMIT( e_thmin, e_thmax );
            INTEGR$FREE_ALLZ;
            flg_hkl := true;
            goto ET_CP_RANGE
          end;

        Clic_Backgrd_Enter:       { Enter background as a Curve }
          if sel_pat <> nil then
          begin
            INTEGR$SUPPRESS_BACKGROUND;
            PLOT_ADD_CURVE;
            DRAW$ECHO_LINE( { red } 2, { Line } 1, { type 1 } 1, { size } 2.0 );
            istatus := DRAW$GET_CURVE( bck_tab, nbck, false, false );
            if istatus = 1 then INTEGR$SET_BACKGROUND( bck_tab, nbck );
            PLOT_ADD_CURVE
          end;

        Clic_Zone_Enter:          { Create or Change an integration zone }
          if sel_pat <> nil then
            if DRAW$GET_WINDOW( rxmin, rymin, rxmax, rymax ) = 1 then
            begin
              ptr_msg := INTEGR$SET_REFZONE( rxmin, rxmax );
              PLOT_MARKERS
            end;

        Clic_Line_Enter:
          if (sel_pat <> nil) and (crv_frs <> nil) then
          begin
            DRAW$STRING_DISPLAY( msg_midbt );
            repeat
              istatus := DRAW$GET_POSITION( rxmax, rymax );
              if istatus = 1 then
              begin
                if DRAW$GET_POSITION( rxmin, rymin ) = 1 then
                begin
                  ptr_msg := INTEGR$SET_REFLINE( rxmax, rymax, ABS( rxmax - rxmin ) );
                  if ptr_msg = nil then PLOT_MARKERS
                                   else begin  DRAW$MESSAGE( ptr_msg^ ); ptr_msg := nil  end
                end
             end
            until istatus <> 1;
            DRAW$STRING_DISPLAY( '' )
          end;

        Clic_Zone_Delete:          { To suppress a zone }
          if DRAW$GET_POSITION( rxmin, rymin ) = 1 then
          begin
            ptr_msg := INTEGR$ZONE_DEL( rxmin );
            PLOT_MARKERS
          end;

        Clic_Line_Delete:          { To suppress a line }
          if (sel_pat <> nil) and (crv_frs <> nil) then
          begin
            DRAW$STRING_DISPLAY( msg_midbt );
            repeat
              istatus := DRAW$GET_POSITION( rxmin, rymin );
              if istatus = 1 then
              begin
                ptr_msg := INTEGR$LINE_DEL( rxmin );
                if ptr_msg <> nil then begin  DRAW$MESSAGE( ptr_msg^ ); ptr_msg := nil  end
                                  else PLOT_MARKERS
              end
            until istatus <> 1;
            DRAW$STRING_DISPLAY( '' )
          end;

        Clic_Build_Backgrd:
          if sel_pat <> nil then
          begin
            ptr_msg := INTEGR$BUILD_BACKGROUND;
            if ntotpck >= 0 then PLOT_MARKERS;
            PLOT_ADD_CURVE
          end;

        Clic_Smooth_Backgrd:      { Smooth Background by spline function }
          begin
            INTEGR$SMOOTH_BACKGROUND;
            PLOT_ADD_CURVE
          end;

        Clic_Lines_Search:        { Search/Locate Diffraction Lines }
          if sel_pat <> nil then
          begin
            ptr_msg := INTEGR$REF_LOCATE;
            PLOT_MARKERS
          end;

        Clic_Lines_Index:         { Index diffraction lines }
          if sel_pat <> nil then
          begin
            ptr_msg := INTEGR$HKL_INDEX;
            if ntotpck >= 0 then PLOT_MARKERS
          end;

        Clic_Intensities:         { Evaluate intensities }
          if sel_pat <> nil then
          begin
            if ntotpck <= 0 then
            begin
              ptr_msg := INTEGR$REF_LOCATE;
              if ntotpck >= 0 then PLOT_MARKERS
            end;
            if ntotpck > 0 then
            begin
              ptr_msg := INTEGR$REF_INTEGR;
              PLOT_ADD_CURVE;
              if ntotpck >= 0 then PLOT_MARKERS
            end
          end;

        Clic_Output_File:              { Set Results Data file Specifications }
          begin
            istatus := DRAW$SELECT_FILE( 'Intensity Output as ...',   { Transaction Title }
                                         outint_fltr,     { File type Filter }
                                         int_name,        { Default file specification }
                                         inpfspc,         { Selected file (Result) }
                                         res_id_fltr,     { Filter index }
                                         1, 0 );          { To create a New file, nszfl }
            if istatus > 0 then
            begin
              int_name := inpfspc;
              fil_nbr := DRAW$GET_ANSWERD( 'Do you want generate one file by pattern ?' ) = 1;
              if not fil_nbr then
                if FILE_ACCESS_CHECK( int_name, 0 { file is existing } ) then
                  if FILE_ACCESS_CHECK( int_name, 6 { read+write access } ) then
                    out_app := DRAW$GET_ANSWERD( 'Do you want append to an existing the file ?' ) = 1
                  else
                  begin { The file exist but cannot be suppershed or append }
                    out_app := false;
                    WRITEV( inpfspc, 'RPWDATA Error : the data file "', int_name, '" cannot be open with write access.' );
                    DRAW$MESSAGE( inpfspc )
                  end
            end
          end;

        Clic_Output_Results:              { Output Result Data file }
          ptr_msg := INTEGR$WRITE_RESULTS;

        Clic_Integr_Proc:
          begin
            rv := frspint;
            r0 :=       1;
            r1 :=    npat;
            istatus := DRAW$GET_VALUE( 'First Pattern number to integrate', rv, r0, r1 );
            if istatus = 1 then
            begin
              frspint := ROUND( rv );
              rv := nbrpint;
              r0 :=       1;
              r1 := npat - frspint + 1;
              istatus := DRAW$GET_VALUE( 'Number of Pattern to integrate', rv, r0, r1 );
              if istatus = 1 then
              begin
                nbrpint := ROUND( rv );
                if nbrpint = 0 then nbrpint := npat - frspint + 1;
                WRITEV( exe_msg, 'O.K. to start integration process (on ', nbrpint:0,
                                 ' patterns starting from the pattern # ', frspint:0, ' ?' );
                istatus := DRAW$GET_ANSWERD( exe_msg );
                if istatus = 1 then ptr_msg := INTEGR$PROCEED
              end
            end;
            INTEGR$SET_LIMIT( szthmin, szthmax );
            DEL_AXIS_BOXES;
            flg_mrk := true; flg_crv := true;
            goto ET_CP_RANGE
          end;

        Clic_Set_Win_Range:       { Theta range by window input }         brgnum := false;
        Clic_Set_Num_Range:       { Theta range by Numeric input mode }   brgnum :=  true;

        Clic_Set_Shift_Rate:      { Quantity for Shift region }
          begin
            istatus := DRAW$GET_VALUE( 'Shift Rate', shift_rp, 0.0, 1.0 );
            if istatus = 1 then
            begin
              if shift_rp < 0.01 then shift_rp := 0.01
                                 else if shift_rp > 1.0 then shift_rp := 1.0
            end
          end;

        Clic_Mai_Setup, Clic_Drw_Setup,                   { Show required Pannels }
        Clic_Bck_Setup, Clic_Ref_Setup,
        Clic_Pro_Setup, Clic_Hkl_Setup: DRAW$PANNEL_OPEN( setup_tab[irep - Clic_Mai_Setup]^.id );

        Clic_P1_Setup, Clic_P2_Setup,
        Clic_P3_Setup, Clic_P4_Setup:   DRAW$PANNEL_OPEN( setup_tab[irep  + (PH1_IDX - Clic_P1_Setup)]^.id );

        Clic_Setup_Sav_as,        { Save as for Setup }
        Clic_Setup_Save:          { Save Setup }
          begin
            if irep = Clic_Setup_Sav_as then
            begin
              istatus := DRAW$SELECT_FILE( 'Setup Save as ...',   { Transaction Title }
                                           setupf_fltr,   { File type Filter }
                                           setupf,        { Default file specification }
                                           inpfspc,       { Selected file (Result) }
                                           set_id_fltr,   { filter index }
                                           1, 0 );        { To create a New file, nszfl }
              if istatus > 0 then setupf := inpfspc
            end
            else istatus := 1;
            if istatus > 0 then
            begin
              ptr_msg := WRITE_SETUP_FILE( setupf, setup_tab );
              if ptr_msg = nil then setup_to_save := false
            end
          end;

        Clic_Setup_restore:       { Restore Setup }
          begin
            istatus := DRAW$SELECT_FILE( 'Setup Restore', { Transaction Title }
                                         setupf_fltr,     { File type Filter }
                                         setupf,          { Default file specification }
                                         inpfspc,         { Selected file (Result) }
                                         set_id_fltr );   { filter index }
            if istatus > 0 then
            begin
              setupf := inpfspc;
              ptr_msg := READ_SETUP_FILE( setupf, setup_tab );
              if ptr_msg = nil then setup_to_save := false
            end
          end;

         Clic_Setup_default:      { Set Default setup }
           if DRAW$GET_ANSWERD( 'Are you Sure (Complete reset to default status)?' ) = 1 then
           begin
             setupf := default_setup;
             set_id_fltr := 1;
             MAIN$SETUP_INIT
           end;

         Clic_Fit_Save:      INTEGR$SAVE_A_PCK; { Save all fit peak values of all zone }

         Clic_Fit_Reload:  { Restore all fit peak values of all zone }
           begin
             INTEGR$RELOAD_A_PCK;
             if ntotpck >= 0 then
             begin  PLOT_MARKERS; PLOT_ADD_CURVE  end
           end;

         Clic_Fit_Z_Save,         { Save fit peak values of a zone }
         Clic_Fit_Z_Reload:       { Restore fit peak values of a zone }
           if DRAW$GET_POSITION( rxmin, rymin ) = 1 then
             if irep = Clic_Fit_Z_Reload then INTEGR$RELOAD_Z_PCK( rxmin )
                                         else begin
                                                INTEGR$SAVE_Z_PCK( rxmin );
                                                if ntotpck >= 0 then
                                                begin  PLOT_MARKERS; PLOT_ADD_CURVE  end
(*                                              begin  PLOT_MARKERS; goto ET_CP_RANGE  end *)
                                              end

      otherwise
      end;

ET_LOOP:

    until irep < 0;

    DRAW$CLOSE_BOX;

    if setup_to_save then
    begin
      ptr_msg := WRITE_SETUP_FILE( setupf, setup_tab );
      if ptr_msg = nil then setup_to_save := false
                       else DRAW$MESSAGE( ptr_msg^ )
    end;

    { End of Graphic Session }
    DRAW$END
  end
end MAKE_2D;



[global]
function  GET_NEW_PARAMS( var pan_descr: pdsc_tab ): integer;
begin
  if drw_ok then GET_NEW_PARAMS := DRAW$PANNEL_GET( pan_descr.id )
            else GET_NEW_PARAMS := -10
end GET_NEW_PARAMS;



procedure INIT_PLOT;
{****************************************************}
{          INITIALYSE THE DRAWING SYSTEM             }
{****************************************************}
{ The external procedure

    DRAW$DEF_MENU( code: Dint; in_var name: [optional] string );

                is a procedure to modify by insertion the DRAW$DIALOG
  standard menu setting.

  The code are :
    Menu_Close             Close the currently opened menu.
    Menu_Open              Open the next Standard Menu.
    Menu_Skip              Skip_the next standard (Menu or Entry).
    Menu_New    <Name>     Create and Open a new user menu of specified name.
    Menu_Entry  <Name>     Create a menu entry of specified name.
    Menu_Separ             Create a Separator menu Entry.

  The directives Menu_Entry and Menu_Separ allocate an integer identifier
  to the new menu elements beginning from 1. This identifier is returned by
  the procedure DRAW$DIALOG when the corresponding entry is selected by
  the mouse.
  The Menu_skip can be used with the form n*16+Menu_Skip where n is a skip number
  with the following specificities:
    If n < 0 the skip go to the end of current standard menu else,
    if n > 0 the result is to skip n entry in the current standard menu.

}
begin
  DRAW$SET_MENU_SPC( Menu_Open );                      { Enter in the "File" Menu }
    DRAW$SET_MENU_SPC( Menu_skip );
    DRAW$SET_MENU_SPC( Menu_Entry, 'Load File',         Clic_Load,    ORD( 'O' )   );        { Open a Pattern data File }
(*
    DRAW$SET_MENU_SPC( Menu_Entry, 'Close',             Clic_Close                 );        { Close a Pattern data File }
(*
    DRAW$SET_MENU_SPC( Menu_Entry, 'Save Pattern',      Clic_Save, Drw_CTRL+ORD( 'S' ) );    { Save Current Pattern Data in the current data File }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Save Pattern As',   Clic_Save_As               );        { Save Current Pattern in a new data File }
*)
  DRAW$SET_MENU_SPC( Menu_Close );                      { Go out of the "File" Menu }
  DRAW$SET_MENU_SPC( Menu_New, '&Pattern/Zone' );       { Create a New menu "Pattern/Zone" }
    if ndia > 1 then
      DRAW$SET_MENU_SPC( Menu_Entry,'Select_Pattern',   Clic_Select_Pattern );  { Select a Pattern }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Theta Range',       Clic_Set_Th_Range   );  { Select a theta range }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Reset Th Range',    Clic_Reset_Th_Range );  { Reset a theta range }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Left Shift',        Clic_Left_Sh_Th_Rng,  ORD( 'L' ) );  { Left Shift theta range }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Right Shift',       Clic_Right_Sh_Th_Rng, ORD( 'R' ) );  { Right Shift theta range }
    DRAW$SET_MENU_SPC( Menu_Entry,'&Shift Rate',        Clic_Set_Shift_Rate );  { Set Shift Rate }
    DRAW$SET_MENU_SPC( Menu_Entry,'Next pattern',     Clic_Next_Pattern,    ORD( 'N' ) );  { Skip to next pattern }
    DRAW$SET_MENU_SPC( Menu_Entry,'Previous pattern', Clic_Prev_Pattern,    ORD( 'P' ) );  { Skip to next pattern }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Output File',  Clic_Output_File    );  { Output of Integrated Reflection Data file }

  DRAW$SET_MENU_SPC( Menu_Close );                      { Close the user menu "Pattern/Zone" }
  DRAW$SET_MENU_SPC( Menu_New, 'Fit Edit' );            { Create a New menu "Fit_Edit" }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Enter Zone',        Clic_Zone_Enter     );  { Enter a new zone by hand }
    DRAW$SET_MENU_SPC( Menu_Entry, '&Enter Line',       Clic_Line_Enter     );  { Enter a new reflection by hand }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Suppress Zone',     Clic_Zone_Delete    );  { To suppress a zone }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Suppress Line',     Clic_Line_Delete    );  { To suppress a line }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Fit Save',          Clic_Fit_Save       );  { To save all line state }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Fit Zone Save',     Clic_Fit_Z_Save     );  { To save all line state of a zone }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Fit Reload',        Clic_Fit_Reload     );  { To Restore all line state }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Fit Zone Reload',   Clic_Fit_Z_Reload   );  { To Restore all line state of a zone }

  DRAW$SET_MENU_SPC( Menu_Close );                      { Close the user menu "Fit_Edit" }
  DRAW$SET_MENU_SPC( Menu_New, 'Integration' );         { Create a New menu "Integration" }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Enter Backgrd.',    Clic_Backgrd_Enter  );  { Enter Background by hand }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Build Back.',       Clic_Build_Backgrd, ORD( '1' ));  { Build Background auto. }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Smooth Back.',      Clic_Smooth_Backgrd );  { Smooth Background by spline func. }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Search',       Clic_Lines_Search,  ORD( '2' ) );  { Search/locate Diffraction Lines }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Index',        Clic_Lines_Index    );  { Index diffraction lines }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Integr.',      Clic_Intensities,   ORD( '3' ) );  { Evaluate intensities }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Output Res.',  Clic_Output_Results );  { Output of Integrated Reflection Results }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Integr. Proc.',     Clic_Integr_Proc    );  { Manage and execute integr. procedure }
  DRAW$SET_MENU_SPC( Menu_Close );                      { Close the user menu "Integration" }
  DRAW$SET_MENU_SPC( Menu_New, 'Setup' );               { Create a New menu "Setup" }
    DRAW$SET_MENU_SPC( Menu_New, '&Phases' );           { Create a New sub-menu "Phases" }
      DRAW$SET_MENU_SPC(Menu_Entry,'Phase_1', Clic_P1_Setup, Drw_F0KEY + 1 );  { Phase 1 Setup (shortcut = F1 key) }
      DRAW$SET_MENU_SPC(Menu_Entry,'Phase_2', Clic_P2_Setup, Drw_F0KEY + 2 );  { Phase 2 Setup (shortcut = F2 key) }
      DRAW$SET_MENU_SPC(Menu_Entry,'Phase_3', Clic_P3_Setup, Drw_F0KEY + 3 );  { Phase 3 Setup (shortcut = F3 key) }
      DRAW$SET_MENU_SPC(Menu_Entry,'Phase_4', Clic_P4_Setup, Drw_F0KEY + 4 );  { Phase 4 Setup (shortcut = F4 key) }
    DRAW$SET_MENU_SPC( Menu_Close );                    { Close the user sub-menu "Phases" }

    DRAW$SET_MENU_SPC( Menu_Entry, 'Main Setup',        Clic_Mai_Setup,    Drw_CTRL+ORD( 'M' ) );  { Main Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Graphic Setup',     Clic_Drw_Setup,    Drw_CTRL+ORD( 'G' ) );  { Graphic Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Background Setup',  Clic_Bck_Setup,    Drw_CTRL+ORD( 'B' ) );  { Background Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Search Setup', Clic_Ref_Setup,    Drw_CTRL+ORD( 'S' ) );  { Reflection Search Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, 'Ref. Process Setup',Clic_Pro_Setup,    Drw_CTRL+ORD( 'P' ) );  { Process Integration Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, 'HKL Fit Control Board',Clic_Hkl_Setup, Drw_CTRL+ORD( 'H' ) );  { Fit Control Board Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, '&Setup Save as',    Clic_Setup_Sav_as   );  { Save as for Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, '&Setup Save',       Clic_Setup_Save     );  { Save Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, '&Setup Restore',    Clic_Setup_restore  );  { Restore a User Setup }
    DRAW$SET_MENU_SPC( Menu_Entry, '&Setup Default',    Clic_Setup_default  );  { Restore Default Setup }

    DRAW$SET_MENU_SPC( Menu_New, '&Input_Mode' );       { Angle/value input mode sub-menu }
      DRAW$SET_MENU_SPC(Menu_Entry,'&Window range',     Clic_Set_Win_Range  );  { Input Range by window mouse }
      DRAW$SET_MENU_SPC(Menu_Entry,'&Numeric Input',    Clic_Set_Num_Range  );  { Input Range by number }
      DRAW$SET_MENU_SPC(Menu_Entry,'&Shift Rate',       Clic_Set_Shift_Rate );  { Set Shift Rate }
    DRAW$SET_MENU_SPC( Menu_Close );                    { Close the user sub-menu "Input_Mode" }

  DRAW$SET_MENU_SPC( Menu_Close );              { Close the user menu "I. Setup" }

  Draw_Server_Mode := DrwSrv_Disable_IniErr;    { Set the Init Error User management DRAW Mode }
  DRAW$INIT( xs, ys, unt, 'Read Pattern' );
  if Draw_Server_Flags <> 0 then                { When the DRAW$INIT is a success ... }
  begin
    DRAW$PIC_VIEW( 1 );                         { ... set to graphic update as soon as mode and ...  }
    drw_ok := true                              { ... set on the DRAW Init flag }
  end
end INIT_PLOT;


end RPWDATA_DRAW2D.
