/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 1824 ) = {
  9,   9, 110, 101, 119,  95,  99, 117, 114, 118, 101,  57,  57,  47, 104, 111,
109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47, 114, 112, 119, 100,  97, 116,
 97,  95, 115, 114,  99,  47, 114, 112, 119, 100,  97, 116,  97,  95, 100, 114,
 97, 119,  46, 112,  97, 115,   9,   9, 100, 101, 108,  95,  99, 117, 114, 118,
101,  12,  12, 117, 112, 100,  97, 116, 101,  95,  99, 117, 114, 118, 101,   9,
  9, 112, 108, 116,  95,  99, 117, 114, 118, 101,   8,   8, 115, 101, 116,  95,
 97, 116, 116, 114,  12,  12,  98, 117, 105, 108, 100,  95, 112,  97, 110, 110,
101, 108,  15,  15,  65, 100, 111,  98, 101,  32,  72, 101, 108, 118, 101, 116,
105,  99,  97,  17,  17,  99, 114, 101,  97, 116, 101,  95,  97, 120, 105, 115,
 95,  98, 111, 120, 101, 115,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,   0,   0, 128, 191,
  0,   0,   0,   0,   0,   0,   0,   0,   7,   7,  50,  42, 116, 104, 101, 116,
 97,   6,   6,  67, 111, 117, 110, 116, 115,   0,   0,   0,   0,   0,   0,  64,
  0,   0,  64,  64,   0,   0,   0,   0,  14,  14, 100, 101, 108,  95,  97, 120,
105, 115,  95,  98, 111, 120, 101, 115,  14,  14, 112, 108, 111, 116,  95,  97,
 95, 114, 109,  97, 114, 107, 101, 114,  12,  12, 112, 108, 111, 116,  95, 109,
 97, 114, 107, 101, 114, 115,  14,  14, 112, 108, 111, 116,  95,  97,  95, 112,
 97, 116, 116, 101, 114, 110,   5,   5,  32,  84,  32,  61,  32,  14,  14, 112,
108, 111, 116,  95,  97, 100, 100,  95,  99, 117, 114, 118, 101,  18,  18, 112,
108, 111, 116,  95, 104, 107, 108,  95, 112, 111, 115, 105, 116, 105, 111, 110,
115,  10,  10, 103, 101, 116,  95, 112,  97, 116, 110,  98, 114,  13,  13, 107,
110, 111, 119, 110,  95, 112,  97, 116, 116, 101, 114, 110,  13,  13,  79, 117,
116, 112, 117, 116,  32,  70, 111, 114, 109,  97, 116,  12,  12,  73, 110, 112,
117, 116,  32,  70, 111, 114, 109,  97, 116,   7,   7, 109,  97, 107, 101,  95,
 50, 100,  17,  17,  80,  97, 116, 116, 101, 114, 110,  32,  68,  97, 116,  97,
 32,  70, 105, 108, 101,  11,  11, 114, 112, 119, 100,  97, 116,  97,  46, 115,
112, 102,  30,  30,  32,  71,  69,  84,  95,  80,  65,  84,  84,  69,  82,  78,
 83,  32,  61,  62,  32,  78,  68,  73,  65,  44,  32,  78,  80,  65,  84,  32,
 61,  32,  52,  52,  32,  42,  42,  42,  32,  82,  80,  87,  32,  69, 114, 114,
111, 114,  58,  32,  84, 104, 101,  32, 110, 101, 120, 116,  32, 112,  97, 116,
116, 101, 114, 110,  32, 100, 111, 101, 115,  32, 110, 111, 116,  32, 101, 120,
105, 115, 116,  46,  32,  42,  42,  42,  56,  56,  32,  42,  42,  42,  32,  82,
 80,  87,  32,  69, 114, 114, 111, 114,  58,  32,  84, 104, 101,  32, 112, 114,
101, 118, 105, 111, 117, 115,  32, 112,  97, 116, 116, 101, 114, 110,  32, 100,
111, 101, 115,  32, 110, 111, 116,  32, 101, 120, 105, 115, 116,  46,  32,  42,
 42,  42,   7,   7,  84, 104,  46,  32,  77, 105, 110,   7,   7,  84, 104,  46,
 32,  77,  97, 120,  45,  45,  32,  80, 114, 101, 115, 115,  32, 116, 104, 101,
 32, 109, 105, 100, 100, 108, 101,  32, 109, 111, 117, 115, 101,  32,  98, 111,
117, 116, 111, 110,  32, 119, 104, 101, 110,  32, 102, 105, 110, 105, 115, 104,
101, 100,  46,   0,   0,   0,   0,  23,  23,  73, 110, 116, 101, 110, 115, 105,
116, 121,  32,  79, 117, 116, 112, 117, 116,  32,  97, 115,  32,  46,  46,  46,
 42,  42,  68, 111,  32, 121, 111, 117,  32, 119,  97, 110, 116,  32, 103, 101,
110, 101, 114,  97, 116, 101,  32, 111, 110, 101,  32, 102, 105, 108, 101,  32,
 98, 121,  32, 112,  97, 116, 116, 101, 114, 110,  32,  63,  44,  44,  68, 111,
 32, 121, 111, 117,  32, 119,  97, 110, 116,  32,  97, 112, 112, 101, 110, 100,
 32, 116, 111,  32,  97, 110,  32, 101, 120, 105, 115, 116, 105, 110, 103,  32,
116, 104, 101,  32, 102, 105, 108, 101,  32,  63,  31,  31,  82,  80,  87,  68,
 65,  84,  65,  32,  69, 114, 114, 111, 114,  32,  58,  32, 116, 104, 101,  32,
100,  97, 116,  97,  32, 102, 105, 108, 101,  32,  34,  35,  35,  34,  32,  99,
 97, 110, 110, 111, 116,  32,  98, 101,  32, 111, 112, 101, 110,  32, 119, 105,
116, 104,  32, 119, 114, 105, 116, 101,  32,  97,  99,  99, 101, 115, 115,  46,
 33,  33,  70, 105, 114, 115, 116,  32,  80,  97, 116, 116, 101, 114, 110,  32,
110, 117, 109,  98, 101, 114,  32, 116, 111,  32, 105, 110, 116, 101, 103, 114,
 97, 116, 101,  30,  30,  78, 117, 109,  98, 101, 114,  32, 111, 102,  32,  80,
 97, 116, 116, 101, 114, 110,  32, 116, 111,  32, 105, 110, 116, 101, 103, 114,
 97, 116, 101,  38,  38,  79,  46,  75,  46,  32, 116, 111,  32, 115, 116,  97,
114, 116,  32, 105, 110, 116, 101, 103, 114,  97, 116, 105, 111, 110,  32, 112,
114, 111,  99, 101, 115, 115,  32,  40, 111, 110,  32,  38,  38,  32, 112,  97,
116, 116, 101, 114, 110, 115,  32, 115, 116,  97, 114, 116, 105, 110, 103,  32,
102, 114, 111, 109,  32, 116, 104, 101,  32, 112,  97, 116, 116, 101, 114, 110,
 32,  35,  32,   2,   2,  32,  63,  10,  10,  83, 104, 105, 102, 116,  32,  82,
 97, 116, 101,  17,  17,  83, 101, 116, 117, 112,  32,  83,  97, 118, 101,  32,
 97, 115,  32,  46,  46,  46,  13,  13,  83, 101, 116, 117, 112,  32,  82, 101,
115, 116, 111, 114, 101,  48,  48,  65, 114, 101,  32, 121, 111, 117,  32,  83,
117, 114, 101,  32,  40,  67, 111, 109, 112, 108, 101, 116, 101,  32, 114, 101,
115, 101, 116,  32, 116, 111,  32, 100, 101, 102,  97, 117, 108, 116,  32, 115,
116,  97, 116, 117, 115,  41,  63,  14,  14, 103, 101, 116,  95, 110, 101, 119,
 95, 112,  97, 114,  97, 109, 115,   9,   9, 105, 110, 105, 116,  95, 112, 108,
111, 116,   9,   9,  76, 111,  97, 100,  32,  70, 105, 108, 101,  13,  13,  38,
 80,  97, 116, 116, 101, 114, 110,  47,  90, 111, 110, 101,  14,  14,  83, 101,
108, 101,  99, 116,  95,  80,  97, 116, 116, 101, 114, 110,  11,  11,  84, 104,
101, 116,  97,  32,  82,  97, 110, 103, 101,  14,  14,  82, 101, 115, 101, 116,
 32,  84, 104,  32,  82,  97, 110, 103, 101,  10,  10,  76, 101, 102, 116,  32,
 83, 104, 105, 102, 116,  11,  11,  82, 105, 103, 104, 116,  32,  83, 104, 105,
102, 116,  11,  11,  38,  83, 104, 105, 102, 116,  32,  82,  97, 116, 101,  12,
 12,  78, 101, 120, 116,  32, 112,  97, 116, 116, 101, 114, 110,  16,  16,  80,
114, 101, 118, 105, 111, 117, 115,  32, 112,  97, 116, 116, 101, 114, 110,  16,
 16,  82, 101, 102,  46,  32,  79, 117, 116, 112, 117, 116,  32,  70, 105, 108,
101,   8,   8,  70, 105, 116,  32,  69, 100, 105, 116,  10,  10,  69, 110, 116,
101, 114,  32,  90, 111, 110, 101,  11,  11,  38,  69, 110, 116, 101, 114,  32,
 76, 105, 110, 101,  13,  13,  83, 117, 112, 112, 114, 101, 115, 115,  32,  90,
111, 110, 101,  13,  13,  83, 117, 112, 112, 114, 101, 115, 115,  32,  76, 105,
110, 101,   8,   8,  70, 105, 116,  32,  83,  97, 118, 101,  13,  13,  70, 105,
116,  32,  90, 111, 110, 101,  32,  83,  97, 118, 101,  10,  10,  70, 105, 116,
 32,  82, 101, 108, 111,  97, 100,  15,  15,  70, 105, 116,  32,  90, 111, 110,
101,  32,  82, 101, 108, 111,  97, 100,  11,  11,  73, 110, 116, 101, 103, 114,
 97, 116, 105, 111, 110,  14,  14,  69, 110, 116, 101, 114,  32,  66,  97,  99,
107, 103, 114, 100,  46,  11,  11,  66, 117, 105, 108, 100,  32,  66,  97,  99,
107,  46,  12,  12,  83, 109, 111, 111, 116, 104,  32,  66,  97,  99, 107,  46,
 11,  11,  82, 101, 102,  46,  32,  83, 101,  97, 114,  99, 104,  10,  10,  82,
101, 102,  46,  32,  73, 110, 100, 101, 120,  12,  12,  82, 101, 102,  46,  32,
 73, 110, 116, 101, 103, 114,  46,  16,  16,  82, 101, 102,  46,  32,  79, 117,
116, 112, 117, 116,  32,  82, 101, 115,  46,  13,  13,  73, 110, 116, 101, 103,
114,  46,  32,  80, 114, 111,  99,  46,   5,   5,  83, 101, 116, 117, 112,   7,
  7,  38,  80, 104,  97, 115, 101, 115,   7,   7,  80, 104,  97, 115, 101,  95,
 49,   7,   7,  80, 104,  97, 115, 101,  95,  50,   7,   7,  80, 104,  97, 115,
101,  95,  51,   7,   7,  80, 104,  97, 115, 101,  95,  52,  10,  10,  77,  97,
105, 110,  32,  83, 101, 116, 117, 112,  13,  13,  71, 114,  97, 112, 104, 105,
 99,  32,  83, 101, 116, 117, 112,  16,  16,  66,  97,  99, 107, 103, 114, 111,
117, 110, 100,  32,  83, 101, 116, 117, 112,  17,  17,  82, 101, 102,  46,  32,
 83, 101,  97, 114,  99, 104,  32,  83, 101, 116, 117, 112,  18,  18,  82, 101,
102,  46,  32,  80, 114, 111,  99, 101, 115, 115,  32,  83, 101, 116, 117, 112,
 21,  21,  72,  75,  76,  32,  70, 105, 116,  32,  67, 111, 110, 116, 114, 111,
108,  32,  66, 111,  97, 114, 100,  14,  14,  38,  83, 101, 116, 117, 112,  32,
 83,  97, 118, 101,  32,  97, 115,  11,  11,  38,  83, 101, 116, 117, 112,  32,
 83,  97, 118, 101,  14,  14,  38,  83, 101, 116, 117, 112,  32,  82, 101, 115,
116, 111, 114, 101,  14,  14,  38,  83, 101, 116, 117, 112,  32,  68, 101, 102,
 97, 117, 108, 116,  11,  11,  38,  73, 110, 112, 117, 116,  95,  77, 111, 100,
101,  13,  13,  38,  87, 105, 110, 100, 111, 119,  32, 114,  97, 110, 103, 101,
 14,  14,  38,  78, 117, 109, 101, 114, 105,  99,  32,  73, 110, 112, 117, 116,
 11,  11,  38,  83, 104, 105, 102, 116,  32,  82,  97, 116, 101,  12,  12,  82,
101,  97, 100,  32,  80,  97, 116, 116, 101, 114, 110,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 416 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  7,  12,  12,   5,  42,  46, 102, 112, 100,   0,   0,   0,   0,   0,   0,   0,
 12,   5,  42,  46, 100,  49,  98,   0,   0,   0,   0,   0,   0,   0,  12,   5,
 42,  46, 100,  50,  48,   0,   0,   0,   0,   0,   0,   0,  12,   8,  42,  46,
105, 110, 101, 108, 114, 120,   0,   0,   0,   0,  12,   8,  42,  46, 120, 121,
100,  97, 116,  97,   0,   0,   0,   0,  12,   6,  42,  46,  99, 111, 108,  42,
  0,   0,   0,   0,   0,   0,  12,   1,  42,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   7,   8,   8,   3,  70,  80,  68,   0,   0,   0,   0,   0,
  8,   3,  82,  80,  87,   0,   0,   0,   0,   0,   8,   3,  68,  49,  66,   0,
  0,   0,   0,   0,   8,   3,  68,  50,  48,   0,   0,   0,   0,   0,   8,   6,
 73,  78,  69,  76,  82,  88,   0,   0,   8,   6,  88,  89,  68,  65,  84,  65,
  0,   0,   8,   6,  67,  79,  76,  85,  77,  78,   0,   0,   6,   8,   8,   3,
 70,  80,  68,   0,   0,   0,   0,   0,   8,   3,  82,  80,  87,   0,   0,   0,
  0,   0,   8,   3,  68,  49,  66,   0,   0,   0,   0,   0,   8,   3,  68,  50,
 48,   0,   0,   0,   0,   0,   8,   6,  73,  78,  69,  76,  82,  88,   0,   0,
  8,   6,  88,  89,  68,  65,  84,  65,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0, 102, 102, 102,  63,   3,  12,  12,   5,  42,  46, 100,  97,
116,   0,   0,   0,   0,   0,   0,   0,  12,   5,  42,  46, 104, 107, 108,   0,
  0,   0,   0,   0,   0,   0,  12,   1,  42,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   1,   0,   0,   0,   2,  12,  12,  10,  42,  46, 114, 112,
119,  95, 100,  97, 116,  97,   0,   0,  12,   1,  42,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 1120 );

/* Declaration of external variables. */
extern V V_crv_lst;
extern V V_crv_frs;
extern UB V_drw_ok;
extern Blk(V_drw_parm, 40 );
extern F V_e_thmin;
extern F V_e_thmax;
extern F V_cshift;
extern V V_sel_pat;
extern SL V_sel_iright;
extern SL V_sel_ileft;
extern UW V_funcs;
extern V V_hkl_first;
extern Blk(V_phase_tbl, 1456 );
extern V V_pat_first;
extern Blk(V_inp_name, 264 );
extern UB V_out_frm;
extern UB V_inp_frm;
extern Blk(V_setup_tab, 48 );
extern Blk(V_str_msg, 264 );
extern SL V_ndia;
extern Blk(V_tbpat, 256 );
extern SL V_frspint;
extern F V_thmin;
extern F V_thmax;
extern Blk(V_mai_parm, 1312 );
extern F V_smax;
extern F V_smin;
extern Blk(V_tbcol, 256 );
extern Blk(V_tbknd, 64 );
extern Blk(V_tbtyp, 256 );
extern Blk(V_tbsiz, 256 );
extern Blk(V_hkl_parm, 112 );
extern SL Draw_PanIde;
extern V PAS__f_output;
extern SL V_npat;
extern SL V_ntotpck;
extern Blk(V_int_name, 264 );
extern UB V_fil_nbr;
extern UB V_out_app;
extern SL V_nbrpint;
extern F V_szthmin;
extern F V_szthmax;
extern Blk(V_setupf, 264 );
extern Blk(V_default_setup, 264 );
extern SL Draw_SrvMod;
extern SL Draw_Srv_Flg;


/* Function/procedure prototypes. */
void Draw_End();
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id, SL F_ky);
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture(V F_title, F F_px, F F_py, UB F_bscale, UB F_blimit);
SL Draw_Dialog(SL F_flags);
void Draw_Out_Mode(SL F_n);
void Draw_Pas_Mplot(V F_pt, SL F_sz, SL F_npt, SL F_flag);
void Draw_Plot(F F_x, F F_y, UB F_ipen);
void Draw_Rplot(F F_dx, F F_dy, UB F_ipen);
void Draw_Pas_String(F F_x, F F_y, F F_theta, F F_high, V F_str, SL F_oflg);
void Draw_Color_Index(SL F_n);
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Line_Attr(SL F_n, F F_r);
void Draw_Marker_Attr(SL F_n, F F_r);
void Draw_Pas_Message(V F_str);
void Draw_Pas_Str_Dspl(V F_str);
SL Draw_Pas_Get_M_Choice(V F_title, V F_menu, SL F_nsz);
SL Draw_Pas_Get_Answerd(V F_title);
SL Draw_Pas_Get_Value(V F_title, F *F_val, F F_lw, F F_up);
SL Draw_Pas_Select_MFile(V F_title, V F_filtr, V F_defst, V F_resul, SL *F_flidx
, SL F_nwflg, SL F_nszfl);
SL Draw_Seg_Pick(SL *F_seg_id, SL *F_pick_id);
SL Draw_Get_Position(F *F_xx, F *F_yy, UB F_in_epure);
SL Draw_Get_Window(F *F_x1, F *F_x2, F *F_y1, F *F_y2);
SL Draw_Get_Curve(V F_pt, SL F_cap, SL *F_rdim, UB F_bplot, UB F_stfl);
void Draw_Echo_Line(SL F_col, SL F_md, SL F_knd, F F_sz);
SL Draw_New_Seg(SL F_n);
void Draw_Seg_End();
void Draw_Del_Seg(SL F_n);
SL Draw_Update_Seg(SL F_n, SL F_fapp);
void Draw_Seg_Attr(SL F_seg_id, SL F_det, SL F_hli, SL F_vis, F F_prior);
void Draw_Set_Pickid(SL F_pic_id);
void Draw_Pic_View(UB F_flags);
SL Draw_New_Axis(V F_u_axis, V F_v_axis, F F_length, F F_vinf, F F_vsup, SL F_ntck
, SL F_flags);
SL Draw_New_Box(V F_org, SL F_ix, SL F_iy, SL F_iz, V F_dtb, SL F_sz, V F_stb, SL
F_nf, SL F_dtbsz, SL F_stbsz);
void Draw_Free_Box_List();
void Draw_Set_Axis_Ticks(SL F_ia, SL F_n, SL F_nt, V F_tfre, SL F__Sf, V F_tknd, 
SL F__Sk, V F_tsiz, SL F__Sl);
void Draw_Set_Axis_Unit(SL F_ia, V F_unit);
void Draw_Plot_Box(SL F_ib);
void Draw_Open_Box(SL F_ib);
void Draw_Close_Box();
SL Draw_CV_Box(UB F_tbox, F F_xd, F F_yd, F F_zd, F *F_xr, F *F_yr, F *F_zr);
void Draw_Pannel_Align(SL F_id, SL F_aln);
void Draw_Pannel_Fsize(SL F_id, UB F_lbf, F F_sz);
void Draw_Pas_Pannel_Font(SL F_id, UB F_lbf, V F_nam, SL F_opt);
SL Draw_Pas_Pannel_Create(F F_w, F F_h, V F_t);
SL Draw_Pas_Pannel_B_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, UB *F_bv)
;
SL Draw_Pas_Pannel_E_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_ev
, V F_choice, SL F_min);
SL Draw_Pas_Pannel_S_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, V F_sv, 
UB F_edi);
SL Draw_Pas_Pannel_I_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, SL *F_iv
, SL F_min, SL F_max);
SL Draw_Pas_Pannel_F_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F *F_fv
, F F_min, F F_max, F F_step);
SL Draw_Pas_Pannel_Text_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, V F_txt
, SL F_sz);
SL Draw_Pas_Pannel_Frame_Item(SL F_ide, F F_x, F F_y, F F_w, F F_h, V F_lab, F F_flw
, SL F_stl);
void Draw_Pannel_Open(SL F_ide);
SL Draw_Pannel_Get(SL F_ide);
SL Draw_Pannel_Put(SL F_ide);
void P_main_Setup_init();
V P_write_setup_file(V F_file_spc, V F_envtb);
V P_read_setup_file(V F_file_spc, V F_envtb);
void P_get_patterns();
void P_integr_Update_pat_info();
void P_integr_Select_pattern(V F_p);
void P_integr_Set_limit(F F_min, F F_max);
void P_integr_Suppress_background();
void P_integr_Set_background(V F_bcktb, SL F_sz, SL F_len);
V P_integr_Build_background();
void P_integr_Smooth_background();
V P_integr_Ref_locate();
V P_integr_Ref_copy();
V P_integr_Set_refzone(F F_lt, F F_rt);
V P_integr_Set_refline(F F_th, F F_hg, F F_wd, UB F_fhkl);
V P_integr_Zone_del(F F_th);
V P_integr_Line_del(F F_th);
V P_integr_Free_allz();
void P_integr_Save_a_pck();
void P_integr_Reload_a_pck();
void P_integr_Save_z_pck(F F_th);
void P_integr_Reload_z_pck(F F_th);
V P_integr_Ref_integr();
void P_integr_Hkl_set_hkl(UB *F_flg, V *F_emsg);
V P_integr_Hkl_index();
V P_integr_Write_results();
V P_integr_Proceed();
void RPWDATAAW2D_init_plot();


/* Procedure/Function : " new_curve "  */
V P_new_curve(SL F_nsz, SL F_id, SL F_lco, SL F_mco, SL F_lkn, SL F_mkn, F F_lsz
, F F_msz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register SL Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=153; /* line # 153 */
  Rv0=F_nsz;
  Rv1=PAS__NEW((2*Rv0)*4+36);
  ((SL *)Rv1)[0]=Rv0;
  Ra.sl[3]=154; /* line # 154 */
  Rv2=Rv1;
  Ra.sl[3]=156; /* line # 156 */
  ((V *)Rv2)[1]=NULL;
  Ra.sl[3]=157; /* line # 157 */
  ((F *)Rv2)[2]=F_lsz;
  ((F *)Rv2)[3]=F_msz;
  Ra.sl[3]=158; /* line # 158 */
  ((SL *)Rv2)[4]=F_lco;
  ((SL *)Rv2)[5]=F_mco;
  Ra.sl[3]=159; /* line # 159 */
  ((SL *)Rv2)[6]=F_lkn;
  ((SL *)Rv2)[7]=F_mkn;
  Ra.sl[3]=160; /* line # 160 */
  ((SL *)Rv2)[8]=F_id;
  Ra.sl[3]=163; /* line # 163 */
  if (V_crv_lst==NULL) V_crv_frs=Rv1;
  else {
    Ra.sl[3]=164; /* line # 164 */
    ((V *)V_crv_lst)[1]=Rv1;
  }
  Ra.sl[3]=165; /* line # 165 */
  V_crv_lst=Rv1;
  Ra.sl[3]=166; /* line # 166 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " del_curve "  */
void P_del_curve(V F_pc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+70;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=177; /* line # 177 */
  if (F_pc!=NULL) {
    Ra.sl[3]=179; /* line # 179 */
    Rv0=NULL;
    Ra.sl[3]=180; /* line # 180 */
    Rv1=V_crv_frs;
    Ra.sl[3]=181; /* line # 181 */
    while (Rv1!=NULL&&Rv1!=F_pc){
      Ra.sl[3]=182; /* line # 182 */
      Rv0=Rv1;
      Rv1=((V *)Rv1)[1];
    }
    Ra.sl[3]=183; /* line # 183 */
    if (Rv1==F_pc) {
      Ra.sl[3]=185; /* line # 185 */
      if (Rv0==NULL) V_crv_frs=((V *)Rv1)[1];
      else {
        Ra.sl[3]=186; /* line # 186 */
        ((V *)Rv0)[1]=((V *)Rv1)[1];
      }
      Ra.sl[3]=187; /* line # 187 */
      if (V_crv_lst==F_pc) V_crv_lst=Rv0;
    }
    Ra.sl[3]=189; /* line # 189 */
    PAS__DISPOSE(&F_pc);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " update_curve "  */
void P_update_curve(V *F_pc, SL F_nsz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+81;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=202; /* line # 202 */
  if ((*F_pc)!=NULL) {
    Ra.sl[3]=203; /* line # 203 */
    Rv0=(*F_pc);
    Ra.sl[3]=205; /* line # 205 */
    Rv1=abs(F_nsz);
    Ra.sl[3]=206; /* line # 206 */
    Rv2=P_new_curve(Rv1,((SL *)Rv0)[8],((SL *)Rv0)[4],((SL *)Rv0)[5],((SL *)Rv0)
    [6],((SL *)Rv0)[7],((F *)Rv0)[2],((F *)Rv0)[3]);
    Ra.sl[3]=207; /* line # 207 */
    if (F_nsz<0) {
      Ra.sl[3]=209; /* line # 209 */
      if (((SL *)Rv0)[0]<Rv1) Rv1=((SL *)Rv0)[0];
      Ra.sl[3]=210; /* line # 210 */
      Rv3=1;
      for( Rf0=2*Rv1;Rf0>0;Rf0-- ) {
        Ra.sl[3]=211; /* line # 211 */
        ((F *)Rv2)[PAS__RANGE(Rv3,1,2*((SL *)Rv2)[0])+8]=((F *)Rv0)[PAS__RANGE(Rv3,
1,2*((SL *)Rv0)[0])+8];
        Rv3++;
      }
    }
    Ra.sl[3]=213; /* line # 213 */
    P_del_curve((*F_pc));
  }
  Ra.sl[3]=215; /* line # 215 */
  (*F_pc)=Rv2;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " plt_curve "  */
void P_plt_curve(V F_pc){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=224; /* line # 224 */
  if (F_pc!=NULL) {
    Ra.sl[3]=225; /* line # 225 */
    Rv0=F_pc;
    Ra.sl[3]=226; /* line # 226 */
    if (((SL *)Rv0)[6]>0||((SL *)Rv0)[7]>0) {
      Ra.sl[3]=228; /* line # 228 */
      if (((SL *)Rv0)[6]>0) {
        Ra.sl[3]=230; /* line # 230 */
        Draw_Out_Mode(1);
        Ra.sl[3]=231; /* line # 231 */
        Draw_Line_Attr(((SL *)Rv0)[6],((F *)Rv0)[2]);
        Ra.sl[3]=232; /* line # 232 */
        Draw_Color_Index(((SL *)Rv0)[4]);
      }
      else {
        Ra.sl[3]=236; /* line # 236 */
        Draw_Out_Mode(2);
        Ra.sl[3]=237; /* line # 237 */
        Draw_Marker_Attr(((SL *)Rv0)[7],((F *)Rv0)[3]);
        Ra.sl[3]=238; /* line # 238 */
        Draw_Color_Index(((SL *)Rv0)[5]);
      }
      Ra.sl[3]=240; /* line # 240 */
      Draw_Pas_Mplot(Rv0+36,2*((SL *)Rv0)[0],((SL *)Rv0)[0],3);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_attr "  */
void RPWDATAAW2D_PRC_00000000(SL F_id, SL F_lp, SL F_tl, SL F_tv, F F_sl, F F_sv
, V F_fl, V F_fv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+106;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=278; /* line # 278 */
  if (F_sl>(F)0.000000E-01) {
    Ra.sl[3]=280; /* line # 280 */
    if (F_lp>0) Draw_Pannel_Align(F_id, F_lp);
    Ra.sl[3]=281; /* line # 281 */
    Draw_Pannel_Fsize(F_id,1, F_sl);
    Ra.sl[3]=282; /* line # 282 */
    if (((UB *)F_fl)[1]>0) {
      Ra.sl[3]=283; /* line # 283 */
      Draw_Pas_Pannel_Font(F_id,1, F_fl,F_tl);
    }
  }
  Ra.sl[3]=285; /* line # 285 */
  if (F_sv>(F)0.000000E-01) {
    Ra.sl[3]=287; /* line # 287 */
    Draw_Pannel_Fsize(F_id,0, F_sv);
    Ra.sl[3]=288; /* line # 288 */
    if (((UB *)F_fv)[1]>0) {
      Ra.sl[3]=289; /* line # 289 */
      Draw_Pas_Pannel_Font(F_id,0, F_fv,F_tv);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " build_pannel "  */
void P_build_pannel(V F_pan_descr){
  /* Define the automatic variable space. */
  Blk( Ra, 280 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+116;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=295; /* line # 295 */
  if (V_drw_ok) {
    Ra.sl[3]=296; /* line # 296 */
    Ra.sl[3]=298; /* line # 298 */
    Rs.ub[0]=0;
    Ra.sl[3]=299; /* line # 299 */
    ((SL *)F_pan_descr)[1]=Draw_Pas_Pannel_Create((float)((UW *)F_pan_descr)[36]
    *(F)1.000000E-01,(float)((UW *)F_pan_descr)[37]*(F)1.000000E-01, F_pan_descr+
8);
    Ra.sl[3]=300; /* line # 300 */
    Rs.sl[1]=4;
    Rs.sl[2]=1;
    Rs.sl[3]=0;
    Ra.sl[3]=301; /* line # 301 */
    Rs.f[4]=(F)1.200000E+01;
    Rs.f[5]=(F)1.200000E+01;
    Ra.sl[3]=302; /* line # 302 */
    Ri.v[0]=Rd.s+130;
    Ri.v[1]=Rd.s+130;
    Ra.sl[3]=303; /* line # 303 */
    RPWDATAAW2D_PRC_00000000(((SL *)F_pan_descr)[1],Rs.sl[1],Rs.sl[2],Rs.sl[3],Rs
    .f[4],Rs.f[5],Rd.s+130,Rd.s+130);
    Ra.sl[3]=304; /* line # 304 */
    Rv0=1;
    for( Rf0=((SL *)F_pan_descr)[0];Rf0>0;Rf0-- ) {
      Ra.sl[3]=305; /* line # 305 */
      Rv1=(((S *)F_pan_descr)+PAS__RANGE(Rv0,1,((SL *)F_pan_descr)[0])*88-12);
      Ra.sl[3]=307; /* line # 307 */
      if (((UB *)Rv1)[68]==1) {
        Ra.sl[3]=309; /* line # 309 */
        Rs.ub[0]=1;
        Rs.ub[24]=((UB *)Rv1)[64]>0;
        Ra.sl[3]=310; /* line # 310 */
        if (Rs.ub[24]) {
          Ra.sl[3]=312; /* line # 312 */
          Rs.sl[1]=((UB *)Rv1)[64];
          Ra.sl[3]=313; /* line # 313 */
          if (((UB *)Rv1)[65]>0) {
            Ra.sl[3]=315; /* line # 315 */
            Rs.f[4]=(F)1.000000E+00*(float)((UB *)Rv1)[65];
            Ra.sl[3]=316; /* line # 316 */
            if (((UB *)Rv1)[1]>0) {
              Ra.sl[3]=317; /* line # 317 */
              Ri.v[0]=Rv1;
              Rs.sl[2]=((UB *)Rv1)[66]&3;
            }
          }
        }
        else {
          Ra.sl[3]=322; /* line # 322 */
          if (((UB *)Rv1)[65]>0) {
            Ra.sl[3]=324; /* line # 324 */
            Rs.f[5]=(F)1.000000E+00*(float)((UB *)Rv1)[65];
            Ra.sl[3]=325; /* line # 325 */
            if (((UB *)Rv1)[1]>0) {
              Ra.sl[3]=326; /* line # 326 */
              Ri.v[1]=Rv1;
              Rs.sl[3]=((UB *)Rv1)[66]&3;
            }
          }
        }
        Ra.sl[3]=329; /* line # 329 */
        RPWDATAAW2D_PRC_00000000(((SL *)F_pan_descr)[1],Rs.sl[1],Rs.sl[2],Rs.sl[
3],Rs.f[4],Rs.f[5],Ri.v[0],Ri.v[1]);
      }
      else {
        Ra.sl[3]=333; /* line # 333 */
        Rs.f[7]=(float)((UB *)Rv1)[64]*(F)1.000000E-01;
        Rs.f[8]=(float)((UB *)Rv1)[65]*(F)1.000000E-01;
        Ra.sl[3]=334; /* line # 334 */
        Rs.f[9]=(float)((UB *)Rv1)[66]*(F)1.000000E-01;
        Rs.f[10]=(float)((UB *)Rv1)[67]*(F)1.000000E-01;
        Ra.sl[3]=335; /* line # 335 */
        if (((UB *)Rv1)[68]!=2) PAS__STR_TO_STR(Ri.s+8,PAS__SUBSTR_STR(Ra.s+16,Rv1,
        PAS__INDEX_CHA(Rv1+2,(SL)((UB *)Rv1)[1],58)+1,0));
        Ra.sl[3]=336; /* line # 336 */
        switch (((UB *)Rv1)[68]) {
          case 3:Ra.sl[3]=337; /* line # 337 */
          Draw_Pas_Pannel_B_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[9],
          Rs.f[10],Ri.s+8,((UB *)((V *)Rv1)[18]));
          break;
          case 4:Ra.sl[3]=338; /* line # 338 */
          Draw_Pas_Pannel_E_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[9],
          Rs.f[10],Ri.s+8,((SL *)((V *)Rv1)[18]),((V *)Rv1)[19],0);
          break;
          case 5:Ra.sl[3]=339; /* line # 339 */
          Draw_Pas_Pannel_I_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[9],
          Rs.f[10],Ri.s+8,((SL *)((V *)Rv1)[18]),((SL *)Rv1)[19],((SL *)Rv1)[20]
          );
          break;
          case 6:Ra.sl[3]=340; /* line # 340 */
          Draw_Pas_Pannel_F_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[9],
          Rs.f[10],Ri.s+8,((F *)((V *)Rv1)[18]),((F *)Rv1)[19],((F *)Rv1)[20],((
          F *)Rv1)[21]);
          break;
          case 7:Ra.sl[3]=341; /* line # 341 */
          Draw_Pas_Pannel_S_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[9],
          Rs.f[10],Ri.s+8,((V *)Rv1)[18],1);
          break;
          case 8:Ra.sl[3]=342; /* line # 342 */
          Draw_Pas_Pannel_Text_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[
9],Rs.f[10],Ri.s+8,((V *)Rv1)[18]+4,((SL *)((V *)Rv1)[18])[0]);
          break;
          case 2:Ra.sl[3]=345; /* line # 345 */
          if (!Rs.ub[0]) RPWDATAAW2D_PRC_00000000(((SL *)F_pan_descr)[1],33,((UB
           *)Rv1)[70]&3,0, (F)1.000000E+00*(float)((UB *)Rv1)[69],(F)0.000000E-01,
          Ri.v[0],Rd.s+130);
          Ra.sl[3]=346; /* line # 346 */
          Draw_Pas_Pannel_Frame_Item(((SL *)F_pan_descr)[1],Rs.f[7],Rs.f[8],Rs.f[
9],Rs.f[10],Rv1,(F)1.000000E+00*(float)((UB *)Rv1)[71],((UB *)Rv1)[72]);
          Ra.sl[3]=347; /* line # 347 */
          if (!Rs.ub[0]) RPWDATAAW2D_PRC_00000000(((SL *)F_pan_descr)[1],Rs.sl[1]
          ,Rs.sl[2],Rs.sl[3],Rs.f[4],(F)0.000000E-01, Ri.v[0],Rd.s+130);
          break;
          default:break;
        }
        Ra.sl[3]=351; /* line # 351 */
        Rs.ub[0]=0;
      }
      Rv0++;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " create_axis_boxes "  */
void RPWDATAAW2D_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  SL Rv2;
  F Rv3;
  F Rv4;
  SL Rv5;
  SL Rv6;
  register F Rgf;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+147;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=443; /* line # 443 */
  Ra.sl[3]=445; /* line # 445 */
  Rv0=((F)3.000000E+00*(Lx[0].f[0]-Lx[0].f[1]))/V_drw_parm.f[3];
  Ra.sl[3]=446; /* line # 446 */
  Rv1=(F)2.000000E-01*Rv0;
  Lx[0].f[2]=(F)8.000000E-01*Rv1;
  Ra.sl[3]=447; /* line # 447 */
  Rv2=1;
  for( Rf0=6;Rf0>0;Rf0-- ) {
    Lx[0].f[PAS__RANGE(Rv2,1,6)+2]=(float)Rv2*Rv1-Rv0;
    Rv2++;
  }
  Ra.sl[3]=449; /* line # 449 */
  Rv3=(float)PAS__F_ROUND(V_e_thmin-(F)5.000000E-01);
  Ra.sl[3]=450; /* line # 450 */
  Rv4=(float)PAS__F_ROUND(V_e_thmax+(F)5.000000E-01);
  Ra.sl[3]=451; /* line # 451 */
  Rv5=PAS__F_ROUND(Rv4-Rv3);
  Ra.sl[3]=452; /* line # 452 */
  if (Rv5<10) Rv6=-1;
  else {
    Ra.sl[3]=453; /* line # 453 */
    if (Rv5<100) Rv6=-4;
    else {
      Ra.sl[3]=454; /* line # 454 */
      Rv6=-8;
    }
  }
  Ra.sl[3]=459; /* line # 459 */
  Lx[0].sl[9]=Draw_New_Axis(Rd.s+168,Rd.s+180,V_drw_parm.f[2],Rv3, Rv4,10,1536);
  Ra.sl[3]=460; /* line # 460 */
  Lx[0].sl[10]=Draw_New_Axis(Rd.s+192,Rd.s+204,V_drw_parm.f[3],Lx[0].f[1]-Rv0, Lx[0]
  .f[0],0,1536);
  Ra.sl[3]=462; /* line # 462 */
  Draw_Set_Axis_Ticks(Lx[0].sl[9],Rv5, Rv6, Lx[0].s+44,2, Lx[0].s+44,2, Lx[0].s+
52,1);
  Ra.sl[3]=466; /* line # 466 */
  Lx[0].sl[11]=5;
  Ra.sl[3]=467; /* line # 467 */
  Lx[0].sl[12]=14;
  Ra.sl[3]=468; /* line # 468 */
  Lx[0].f[13]= -Rv0;
  Ra.sl[3]=470; /* line # 470 */
  Draw_Set_Axis_Unit(Lx[0].sl[9],Rd.s+216);
  Ra.sl[3]=471; /* line # 471 */
  Draw_Set_Axis_Unit(Lx[0].sl[10],Rd.s+225);
  Ra.sl[3]=473; /* line # 473 */
  Lx[0].sl[14]=Draw_New_Box(Rd.s+236,Lx[0].sl[9],Lx[0].sl[10],0, Lx[0].s+44,2, Lx[0]
  .s+52,1,0,0);
  Ra.sl[3]=475; /* line # 475 */
  Lx[0].sl[15]=Draw_New_Seg(10);
  Ra.sl[3]=476; /* line # 476 */
  Draw_Color_Index(1);
  Ra.sl[3]=477; /* line # 477 */
  Draw_Line_Attr(1, (F)1.000000E+00);
  Ra.sl[3]=478; /* line # 478 */
  Draw_Plot_Box(Lx[0].sl[14]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " del_axis_boxes "  */
void RPWDATAAW2D_PRC_00000002(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+248;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=485; /* line # 485 */
  Draw_Del_Seg(Lx[0].sl[15]);
  Ra.sl[3]=486; /* line # 486 */
  Draw_Del_Seg(Lx[0].sl[16]);
  Ra.sl[3]=487; /* line # 487 */
  Draw_Del_Seg(Ri.sl[18]);
  Ra.sl[3]=488; /* line # 488 */
  Draw_Free_Box_List();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " plot_a_rmarker "  */
void RPWDATAAW2D_PRC_00000003(F F_th, F F_hg, UB F_mflg, UB *F_iref){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+264;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=500; /* line # 500 */
  Rs.f[11]=F_th;
  Ra.sl[3]=501; /* line # 501 */
  Rs.f[13]=F_th;
  Ra.sl[3]=502; /* line # 502 */
  if (128&F_mflg) {
    Ra.sl[3]=504; /* line # 504 */
    Rs.f[12]=Lx[0].f[8];
    Ra.sl[3]=505; /* line # 505 */
    Draw_Marker_Attr(4, (F)2.000000E+00);
    Ra.sl[3]=506; /* line # 506 */
    Draw_Out_Mode(2);
    Draw_Color_Index(1);
    Ra.sl[3]=507; /* line # 507 */
    Draw_Pas_Mplot(Rs.s+44,4,1,3);
  }
  else {
    Ra.sl[3]=511; /* line # 511 */
    if (64&F_mflg) {
      Ra.sl[3]=513; /* line # 513 */
      Rs.f[17]=F_th;
      Rs.f[18]=Rs.f[16];
      Ra.sl[3]=514; /* line # 514 */
      Draw_Line_Attr(1, (F)4.000000E+00);
      Ra.sl[3]=515; /* line # 515 */
      Draw_Out_Mode(1);
      Draw_Set_ColorA((F)0.000000E-01, (F)6.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
      Ra.sl[3]=516; /* line # 516 */
      Draw_Pas_Mplot(Rs.s+60,4,2,3);
    }
    Ra.sl[3]=519; /* line # 519 */
    if (32&F_mflg) {
      Ra.sl[3]=521; /* line # 521 */
      Rs.f[15]=F_th;
      Rs.f[16]=Lx[0].f[7];
    }
    Ra.sl[3]=524; /* line # 524 */
    if ((F_mflg&3)!=0) {
      Ra.sl[3]=526; /* line # 526 */
      Rs.f[12]=Lx[0].f[8];
      Ra.sl[3]=527; /* line # 527 */
      Rs.f[14]=Lx[0].f[8]+Lx[0].f[2];
      Ra.sl[3]=528; /* line # 528 */
      Draw_Line_Attr(1, (F)2.000000E+00);
      Ra.sl[3]=529; /* line # 529 */
      Draw_Out_Mode(1);
      Draw_Color_Index(1);
      Ra.sl[3]=530; /* line # 530 */
      Draw_Pas_Mplot(Rs.s+44,4,2,3);
      Ra.sl[3]=532; /* line # 532 */
      if ((*F_iref)&&2&F_mflg) {
        Ra.sl[3]=534; /* line # 534 */
        Draw_Out_Mode(1);
        Draw_Color_Index(2);
        Draw_Line_Attr(1, (F)4.000000E+00);
        Ra.sl[3]=535; /* line # 535 */
        Rs.f[11]=Rs.f[19];
        Rs.f[12]=Rs.f[20]+(F)5.000000E-01*Lx[0].f[2];
        Rs.f[14]=Rs.f[12];
        Ra.sl[3]=536; /* line # 536 */
        Draw_Pas_Mplot(Rs.s+44,4,2,3);
        Ra.sl[3]=537; /* line # 537 */
        (*F_iref)=0;
      }
      Ra.sl[3]=539; /* line # 539 */
      if (1&F_mflg) {
        Ra.sl[3]=540; /* line # 540 */
        Rs.f[19]=F_th;
        Rs.f[20]=Lx[0].f[8];
        (*F_iref)=1;
      }
    }
    Ra.sl[3]=543; /* line # 543 */
    if ((F_mflg&12)!=0) {
      Ra.sl[3]=545; /* line # 545 */
      if (16&F_mflg) {
        if (8&F_mflg) Rv0=1;
        else {
          Ra.sl[3]=546; /* line # 546 */
          Rv0=4;
        }
      }
      else {
        Ra.sl[3]=547; /* line # 547 */
        if (8&F_mflg) Rv0=2;
        else {
          Ra.sl[3]=548; /* line # 548 */
          Rv0=3;
        }
      }
      Ra.sl[3]=549; /* line # 549 */
      Draw_Line_Attr(Rv0, (F)2.000000E+00);
      Ra.sl[3]=550; /* line # 550 */
      Draw_Color_Index(3);
      Ra.sl[3]=551; /* line # 551 */
      Rs.f[11]=F_th;
      Rs.f[13]=F_th;
      Ra.sl[3]=552; /* line # 552 */
      Rs.f[12]=(F)0.000000E-01;
      Rs.f[14]=F_hg+V_cshift;
      Ra.sl[3]=553; /* line # 553 */
      Draw_Pas_Mplot(Rs.s+44,4,2,3);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " plot_markers "  */
void RPWDATAAW2D_PRC_00000004(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+280;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=566; /* line # 566 */
  Rv0=Draw_Update_Seg(50,0);
  Ra.sl[3]=567; /* line # 567 */
  Rv1=0;
  Ra.sl[3]=568; /* line # 568 */
  Rv2=V_sel_pat;
  Ra.sl[3]=569; /* line # 569 */
  Rv3=V_sel_ileft;
  for( Rf0=(V_sel_iright+1)-V_sel_ileft;Rf0>0;Rf0-- ) {
    Ra.sl[3]=570; /* line # 570 */
    Rv4=(((S *)Rv2)+PAS__RANGE(Rv3,1,((SL *)Rv2)[0])*16+324);
    Ra.sl[3]=571; /* line # 571 */
    if (((UB *)Rv4)[14]!=0) RPWDATAAW2D_PRC_00000003(((F *)Rv4)[0],((F *)Rv4)[1]
    ,((UB *)Rv4)[14],&Rv1);
    Rv3++;
  }
  Ra.sl[3]=572; /* line # 572 */
  Draw_Seg_End();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " plot_a_pattern "  */
void RPWDATAAW2D_PRC_00000005(V F_p, F F_shift){
  /* Define the automatic variable space. */
  Blk( Ra, 56 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  UB Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  F Rv6;
  F Rv7;
  F Rv8;
  F Rv9;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=32;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+36;
  Ra.v[10]=Rd.s+294;
  Ra.v[11]=Rd.s+11;
  Ra.sl[12]=585; /* line # 585 */
  Rv0=0;
  Ra.sl[12]=586; /* line # 586 */
  Rv1=0;
  Ra.sl[12]=587; /* line # 587 */
  Rv2=0;
  Ra.sl[12]=588; /* line # 588 */
  if (F_p!=NULL) {
    Ra.sl[12]=589; /* line # 589 */
    Rv3=F_p;
    Ra.sl[12]=591; /* line # 591 */
    Rv4=1;
    for( Rf0=((SL *)Rv3)[0];Rf0>0;Rf0-- ) {
      Ra.sl[12]=592; /* line # 592 */
      Rv5=(((S *)Rv3)+PAS__RANGE(Rv4,1,((SL *)Rv3)[0])*16+324);
      Ra.sl[12]=593; /* line # 593 */
      if (((F *)Rv5)[0]>=V_e_thmin&&((F *)Rv5)[0]<=V_e_thmax) {
        Ra.sl[12]=595; /* line # 595 */
        Draw_Plot(((F *)Rv5)[0],((F *)Rv5)[1]+F_shift, Rv2);
        Ra.sl[12]=596; /* line # 596 */
        if (Rv0==0) Rv0=Rv4;
        Ra.sl[12]=597; /* line # 597 */
        Rv1=Rv4;
        Ra.sl[12]=598; /* line # 598 */
        Rv2=1;
      }
      Rv4++;
    }
    Ra.sl[12]=601; /* line # 601 */
    Draw_Rplot((F)0.000000E-01, (F)0.000000E-01,0);
    Ra.sl[12]=603; /* line # 603 */
    if (V_sel_pat==F_p) {
      Ra.sl[12]=605; /* line # 605 */
      RPWDATAAW2D_PRC_00000004();
    }
    Ra.sl[12]=609; /* line # 609 */
    if (64&V_funcs&&Rv0>0) {
      Ra.sl[12]=610; /* line # 610 */
      Ra.sl[12]=612; /* line # 612 */
      Rv1=Draw_CV_Box(0, V_e_thmax, F_shift, (F)0.000000E-01, &Rv6, &Rv7, &Rv8);
      Ra.sl[12]=613; /* line # 613 */
      Rv9=((F *)Rv3)[65];
      Ra.sl[12]=614; /* line # 614 */
      if (32&V_funcs) Rv9=Rv9-(F)2.731600E+02;
      Ra.sl[12]=615; /* line # 615 */
      PAS__VWRITE_INIT(Ra.s,1);
      PAS__WRITE_STR(Rd.s+310,-1,-1,32);
      PAS__WRITE_SNGL(((F *)Rv3)[65],6,2,0);
      PAS__WRITE_EOLN();
      Ra.sl[12]=616; /* line # 616 */
      Draw_Pas_String(Rv6+V_drw_parm.f[0],Rv7+V_drw_parm.f[1],(F)0.000000E-01, (F)
4.000000E-01, Ra.s,0);
    }
  }
  PAS__curr_cntx=Ra.v[9];
}


/* Procedure/Function : " plot_add_curve "  */
void RPWDATAAW2D_PRC_00000006(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+317;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=624; /* line # 624 */
  if (V_crv_frs!=NULL) {
    Ra.sl[3]=626; /* line # 626 */
    if (Ri.sl[18]==0) Ri.sl[18]=Draw_New_Seg(15);
    else {
      Ra.sl[3]=627; /* line # 627 */
      Draw_Update_Seg(Ri.sl[18],0);
    }
    Ra.sl[3]=628; /* line # 628 */
    Lx[0].v[17]=V_crv_frs;
    Ra.sl[3]=629; /* line # 629 */
    while (Lx[0].v[17]!=NULL){
      Ra.sl[3]=630; /* line # 630 */
      Rv0=Lx[0].v[17];
      Ra.sl[3]=632; /* line # 632 */
      P_plt_curve(Lx[0].v[17]);
      Ra.sl[3]=633; /* line # 633 */
      Lx[0].v[17]=((V *)Rv0)[1];
    }
    Ra.sl[3]=635; /* line # 635 */
    Draw_Seg_End();
  }
  else {
    Ra.sl[3]=638; /* line # 638 */
    if (Ri.sl[18]>0) Draw_Del_Seg(Ri.sl[18]);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " plot_hkl_positions "  */
void RPWDATAAW2D_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  F Rv5;
  F Rv6;
  F Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+333;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=652; /* line # 652 */
  Rv0=0;
  Ra.sl[3]=653; /* line # 653 */
  Rv1=0;
  Ra.sl[3]=654; /* line # 654 */
  Rv2=V_hkl_first;
  Ra.sl[3]=655; /* line # 655 */
  while (Rv2!=NULL){
    Ra.sl[3]=656; /* line # 656 */
    Rv3=Rv2;
    Ra.sl[3]=658; /* line # 658 */
    Rv4=((SL *)Rv3)[5];
    Ra.sl[3]=659; /* line # 659 */
    if (V_phase_tbl.ub[PAS__RANGE(Rv4,1,4)*364-206]) {
      Ra.sl[3]=661; /* line # 661 */
      Rv5=((F *)Rv3)[6];
      Rv6=Lx[0].f[PAS__RANGE(Rv4,1,6)+2];
      Rv7=Rv6+(F)8.000000E-01*Lx[0].f[2];
      Ra.sl[3]=662; /* line # 662 */
      if (!Rv0) {
        Ra.sl[3]=664; /* line # 664 */
        if (Ri.sl[19]==0) Ri.sl[19]=Draw_New_Seg(20);
        else {
          Ra.sl[3]=665; /* line # 665 */
          Ri.sl[19]=Draw_Update_Seg(Ri.sl[19],0);
        }
        Ra.sl[3]=666; /* line # 666 */
        Draw_Line_Attr(1, (F)1.000000E+00);
        Ra.sl[3]=667; /* line # 667 */
        Draw_Set_ColorA((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
        Ra.sl[3]=668; /* line # 668 */
        Draw_Out_Mode(-1);
        Ra.sl[3]=669; /* line # 669 */
        Rv0=1;
      }
      Ra.sl[3]=671; /* line # 671 */
      if (Rv5>V_e_thmin&&Rv5<V_e_thmax) {
        Ra.sl[3]=673; /* line # 673 */
        Draw_Plot(Rv5, Rv6, Rv1);
        Rv1=1;
        Ra.sl[3]=674; /* line # 674 */
        Draw_Plot(Rv5, Rv7,1);
      }
    }
    Ra.sl[3]=680; /* line # 680 */
    Rv2=((V *)Rv3)[0];
  }
  Ra.sl[3]=683; /* line # 683 */
  if (Rv0) {
    Draw_Plot(Rv5, Rv7,0);
    Draw_Seg_End();
  }
  else {
    Ra.sl[3]=684; /* line # 684 */
    if (Ri.sl[19]>0) {
      Draw_Del_Seg(Ri.sl[19]);
      Ri.sl[19]=0;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_patnbr "  */
SL RPWDATAAW2D_PRC_00000008(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+353;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=695; /* line # 695 */
  Rv0=0;
  Ra.sl[3]=696; /* line # 696 */
  Rv1=V_pat_first;
  Ra.sl[3]=697; /* line # 697 */
  while (Rv1!=NULL&&Rv1!=F_p){
    Rv1=((V *)Rv1)[1];
    Rv0=Rv0+1;
  }
  Ra.sl[3]=698; /* line # 698 */
  if (Rv1!=NULL) Ret=Rv0;
  else {
    Ra.sl[3]=699; /* line # 699 */
    Ret=0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " known_pattern "  */
SL RPWDATAAW2D_PRC_00000009(SL F_inp_type, UB F_bout){
  /* Define the automatic variable space. */
  Blk( Ra, 552 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.ub[0]=16;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+20;
  Ra.v[6]=Rd.s+365;
  Ra.v[7]=Rd.s+11;
  Ra.sl[8]=714; /* line # 714 */
  Rv0=PAS__NINDEX_CHA(V_inp_name.s+2,(SL)V_inp_name.ub[1],46,-1,-1,1);
  Ra.sl[8]=715; /* line # 715 */
  if (Rv0>0) {
    Ra.sl[8]=717; /* line # 717 */
    PAS__STR_TO_STR(Ra.s,PAS__CON_CHA_STR(Ra.s+293,42, PAS__SUBSTR_STR(Ra.s+36,V_inp_name
    .s,Rv0,0)));
    Ra.sl[8]=718; /* line # 718 */
    PAS__SET_CASE(Ra.s,0);
    Ra.sl[8]=719; /* line # 719 */
    Rv1=1;
    Ra.sl[8]=720; /* line # 720 */
    while (Rv1<7&&PAS__NE_STR(Ra.s,(Ri.s+PAS__RANGE(Rv1,1,(UL)Ri.ub[80])*14+68)))

    Rv1=Rv1+1;
  }
  else {
    Ra.sl[8]=722; /* line # 722 */
    Rv1=7;
  }
  Ra.sl[8]=724; /* line # 724 */
  if (F_bout&&Rv1>6) {
    Ra.sl[8]=725; /* line # 725 */
    Rv1=Draw_Pas_Get_M_Choice(Rd.s+380,Ri.s+180,0);
  }
  else {
    Ra.sl[8]=727; /* line # 727 */
    if (!F_bout&&Rv1>5) Ret=Draw_Pas_Get_M_Choice(Rd.s+395,Ri.s+252,0);
  }
  Ra.sl[8]=728; /* line # 728 */
  if (F_bout) {
    Ra.sl[8]=729; /* line # 729 */
    switch (Rv1) {
      case 1:
      case 2:Ra.sl[8]=730; /* line # 730 */
      V_out_frm=0;
      break;
      case 3:
      case 4:Ra.sl[8]=731; /* line # 731 */
      V_out_frm=1;
      break;
      case 5:Ra.sl[8]=732; /* line # 732 */
      V_out_frm=5;
      break;
      case 6:Ra.sl[8]=733; /* line # 733 */
      V_out_frm=4;
      break;
      case 7:Ra.sl[8]=734; /* line # 734 */
      V_out_frm=3;
      break;
      default:break;
    }
  }
  else {
    Ra.sl[8]=738; /* line # 738 */
    switch (Rv1) {
      case 1:
      case 2:Ra.sl[8]=739; /* line # 739 */
      V_inp_frm=0;
      break;
      case 3:
      case 4:Ra.sl[8]=740; /* line # 740 */
      V_inp_frm=1;
      break;
      case 5:Ra.sl[8]=741; /* line # 741 */
      V_inp_frm=5;
      break;
      case 6:Ra.sl[8]=742; /* line # 742 */
      V_inp_frm=4;
      break;
      default:break;
    }
  }
  Ra.sl[8]=745; /* line # 745 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " make_2d "  */
void P_make_2d(SL F_nd){
  /* Define the automatic variable space. */
  Blk( Ra, 352 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  F Rv7;
  F Rv8;
  UB Rv9;
  F Rv10;
  F Rv11;
  SL Rv12;
  F Rv13;
  F Rv14;
  F Rv15;
  F Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  F Rv21;
  F Rv22;
  F Rv23;
  F Rv24;
  F Rv25;
  F Rv26;
  SL Rv27;
  F Rv28;
  F Rv29;
  register F Rgf;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.ub[72]=128;
  Ra.ub[202]=128;
  Ra.v[83]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+332;
  Ra.v[84]=Rd.s+409;
  Ra.v[85]=Rd.s+11;
  Ra.sl[86]=751; /* line # 751 */
  Ra.sl[86]=753; /* line # 753 */
  Rv0=0;
  Ra.sl[86]=754; /* line # 754 */
  Rv1=0;
  Ra.sl[86]=755; /* line # 755 */
  Rv2=0;
  Ra.sl[86]=756; /* line # 756 */
  Rv3=1;
  Ra.sl[86]=761; /* line # 761 */
  RPWDATAAW2D_init_plot();
  Ra.sl[86]=762; /* line # 762 */
  if (!V_drw_ok) goto Ret_Label;
  Ra.sl[86]=764; /* line # 764 */
  Rv4=0;
  for( Rf0=10;Rf0>0;Rf0-- ) {
    Ra.sl[86]=765; /* line # 765 */
    if (V_setup_tab.v[PAS__RANGE(Rv4,0,V_setup_tab.sl[0])+1]!=NULL) P_build_pannel(
    V_setup_tab.v[PAS__RANGE(Rv4,0,V_setup_tab.sl[0])+1]);
    Rv4++;
  }
L_l_0:
  Ra.sl[86]=768; /* line # 768 */
  if (V_str_msg.ub[1]>0) {
    Ra.sl[86]=770; /* line # 770 */
    Draw_Pas_Message(V_str_msg.s);
    Ra.sl[86]=771; /* line # 771 */
    V_str_msg.ub[1]=0;
  }
  Ra.sl[86]=774; /* line # 774 */
  Ri.sl[18]=0;
  Ra.sl[86]=776; /* line # 776 */
  if (V_ndia>=1&&V_tbpat.v[0]!=NULL) {
    Ra.sl[86]=778; /* line # 778 */
    P_integr_Select_pattern(V_tbpat.v[0]);
    Ra.sl[86]=779; /* line # 779 */
    Draw_Pannel_Put(((SL *)V_setup_tab.v[PAS__RANGE(0,0,V_setup_tab.sl[0])+1])[1]
    );
    Ra.sl[86]=780; /* line # 780 */
    V_frspint=RPWDATAAW2D_PRC_00000008(V_tbpat.v[0]);
    Ra.sl[86]=781; /* line # 781 */
    if (V_drw_parm.f[2]<(F)5.000000E+00||V_drw_parm.f[2]>(F)3.000000E+02) V_drw_parm
    .f[2]=(F)2.400000E+01;
    Ra.sl[86]=782; /* line # 782 */
    if (V_drw_parm.f[3]<(F)5.000000E+00||V_drw_parm.f[3]>(F)3.000000E+02) V_drw_parm
    .f[3]=(F)1.600000E+01;
    Ra.sl[86]=783; /* line # 783 */
    Rv5=Draw_Pas_Picture(V_inp_name.s,V_drw_parm.f[2]+(F)4.000000E+00, V_drw_parm
    .f[3]+(F)5.000000E+00,0,1);
    Ra.sl[86]=786; /* line # 786 */
    if (V_drw_parm.f[5]>(F)2.000000E+00||V_drw_parm.f[5]<(F)0.000000E-01) V_drw_parm
    .f[5]=(F)2.000000E-01;
    Ra.sl[86]=788; /* line # 788 */
    if (32&V_funcs) {
      Ra.sl[86]=789; /* line # 789 */
      Ra.f[1]=Ra.f[1]-(F)2.731600E+02;
      Ra.f[0]=Ra.f[0]-(F)2.731600E+02;
    }
    Ra.sl[86]=791; /* line # 791 */
    P_integr_Hkl_set_hkl(&Rv2, &Rv6);
  }
  else {
    Ra.sl[86]=793; /* line # 793 */
    V_sel_pat=NULL;
  }
L_l_1:
  Ra.sl[86]=796; /* line # 796 */
  if (V_sel_pat!=NULL) {
    Ra.sl[86]=798; /* line # 798 */
    Rv7=V_thmin;
    Rv8=V_thmax;
    Ra.sl[86]=799; /* line # 799 */
    if (V_mai_parm.f[324]<(F)1.000000E+03&&V_mai_parm.f[324]>Rv7) Rv7=V_mai_parm
    .f[324];
    Ra.sl[86]=800; /* line # 800 */
    if (V_mai_parm.f[325]<(F)1.000000E+03&&V_mai_parm.f[325]<Rv8) Rv8=V_mai_parm
    .f[325];
    Ra.sl[86]=801; /* line # 801 */
    V_e_thmin=Rv7;
    V_e_thmax=Rv8;
    Ra.sl[86]=802; /* line # 802 */
    Rv9=0;
  }
L_l_2:
  Ra.sl[86]=806; /* line # 806 */
  if (V_sel_pat!=NULL) {
    Ra.sl[86]=808; /* line # 808 */
    V_drw_parm.f[5]=fabs(V_drw_parm.f[5]);
    Ra.sl[86]=809; /* line # 809 */
    Rv10=V_drw_parm.f[5];
    Ra.sl[86]=810; /* line # 810 */
    Rv11=V_drw_parm.f[5]*(V_smax-V_smin);
    Ra.sl[86]=811; /* line # 811 */
    Ra.f[1]=V_smin;
    Ra.f[0]=V_smax+Rv11*(float)(V_ndia-1);
    Ra.sl[86]=812; /* line # 812 */
    RPWDATAAW2D_PRC_00000001();
    Ra.sl[86]=814; /* line # 814 */
    Draw_Open_Box(Ra.sl[14]);
    Ra.sl[86]=816; /* line # 816 */
    Ra.sl[16]=Draw_New_Seg(11);
    Ra.sl[86]=817; /* line # 817 */
    Draw_Seg_Attr(Ra.sl[16],2,1,2, (F)1.000000E+00);
    Ra.sl[86]=818; /* line # 818 */
    Rv12=1;
    for( Rf0=V_ndia;Rf0>0;Rf0-- ) {
      Ra.sl[86]=820; /* line # 820 */
      Rv13=(float)(Rv12-1)*Rv11;
      Ra.sl[86]=821; /* line # 821 */
      Draw_Update_Seg(Ra.sl[16],1);
      Ra.sl[86]=822; /* line # 822 */
      Draw_Set_Pickid(Rv12);
      Ra.sl[86]=823; /* line # 823 */
      Draw_Color_Index(V_tbcol.sl[PAS__RANGE(Rv12,1,64)-1]);
      Ra.sl[86]=824; /* line # 824 */
      if (V_tbknd.ub[PAS__RANGE(Rv12,1,64)-1]) {
        Ra.sl[86]=826; /* line # 826 */
        Draw_Out_Mode(2);
        Ra.sl[86]=827; /* line # 827 */
        Draw_Marker_Attr(V_tbtyp.sl[PAS__RANGE(Rv12,1,64)-1],V_tbsiz.f[PAS__RANGE(
        Rv12,1,64)-1]);
      }
      else {
        Ra.sl[86]=831; /* line # 831 */
        Draw_Out_Mode(1);
        Ra.sl[86]=832; /* line # 832 */
        Draw_Line_Attr(V_tbtyp.sl[PAS__RANGE(Rv12,1,64)-1],V_tbsiz.f[PAS__RANGE(
        Rv12,1,64)-1]);
      }
      Ra.sl[86]=834; /* line # 834 */
      if (V_tbpat.v[PAS__RANGE(Rv12,1,64)-1]==V_sel_pat) V_cshift=Rv13;
      Ra.sl[86]=835; /* line # 835 */
      RPWDATAAW2D_PRC_00000005(V_tbpat.v[PAS__RANGE(Rv12,1,64)-1],Rv13);
      Rv12++;
    }
    Ra.sl[86]=837; /* line # 837 */
    Draw_Seg_End();
    Ra.sl[86]=839; /* line # 839 */
    if (Rv0) {
      Rv0=0;
      RPWDATAAW2D_PRC_00000004();
    }
    Ra.sl[86]=840; /* line # 840 */
    if (Rv1) {
      Rv1=0;
      RPWDATAAW2D_PRC_00000006();
    }
    Ra.sl[86]=841; /* line # 841 */
    if (Rv2) {
      Rv2=0;
      RPWDATAAW2D_PRC_00000007();
    }
  }
  Ra.sl[86]=844; /* line # 844 */
  Rv6=NULL;
  while (1){
    Ra.sl[86]=846; /* line # 846 */
    if (Rv6!=NULL) Draw_Pas_Message(Rv6);
    Ra.sl[86]=847; /* line # 847 */
    Rv6=NULL;
    Ra.sl[86]=849; /* line # 849 */
    Rv14=V_hkl_parm.f[0];
    Rv15=V_hkl_parm.f[1];
    Rv16=V_hkl_parm.f[2];
    Ra.sl[86]=851; /* line # 851 */
    Rv17=Draw_Dialog(1);
    Ra.sl[86]=853; /* line # 853 */
    if (Draw_PanIde!=0) {
      Ra.sl[86]=855; /* line # 855 */
      if (Draw_PanIde>0) {
        Ra.sl[86]=856; /* line # 856 */
        Draw_Pannel_Get(Draw_PanIde);
      }
      else {
        Ra.sl[86]=858; /* line # 858 */
        Rv18=0;
        for( Rf0=10;Rf0>0;Rf0-- ) {
          Ra.sl[86]=859; /* line # 859 */
          if (V_setup_tab.v[PAS__RANGE(Rv18,0,V_setup_tab.sl[0])+1]!=NULL) Draw_Pannel_Get((
          (SL *)V_setup_tab.v[PAS__RANGE(Rv18,0,V_setup_tab.sl[0])+1])[1]);
          Rv18++;
        }
      }
      Ra.sl[86]=861; /* line # 861 */
      if ((V_hkl_parm.f[0]!=Rv14||V_hkl_parm.f[1]!=Rv15)||V_hkl_parm.f[2]!=Rv16)
       P_integr_Update_pat_info();
      Ra.sl[86]=863; /* line # 863 */
      P_integr_Hkl_set_hkl(&Rv2, &Rv6);
      Ra.sl[86]=865; /* line # 865 */
      Draw_Close_Box();
      Ra.sl[86]=866; /* line # 866 */
      RPWDATAAW2D_PRC_00000002();
      Ra.sl[86]=867; /* line # 867 */
      goto L_l_1;
    }
    Ra.sl[86]=871; /* line # 871 */
    switch (Rv17) {
      case 1:Ra.sl[86]=874; /* line # 874 */
      Ri.sl[79]=Draw_Pas_Select_MFile(Rd.s+418,Ri.s+80,Rd.s+437,V_inp_name.s,Ri.
      sl+80,0,0);
      Ra.sl[86]=879; /* line # 879 */
      if (Ri.sl[79]>0) Ri.sl[79]=RPWDATAAW2D_PRC_00000009(Ri.sl[80],0);
      Ra.sl[86]=880; /* line # 880 */
      if (Ri.sl[79]>0) {
        Ra.sl[86]=882; /* line # 882 */
        P_get_patterns();
        Ra.sl[86]=883; /* line # 883 */
        V_funcs=V_funcs|12;
        Ra.sl[86]=884; /* line # 884 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+450,-1,-1,32);
        PAS__WRITE_INT(V_ndia,12,0);
        PAS__WRITE_INT(V_npat,12,0);
        PAS__WRITE_EOLN();
        Ra.sl[86]=885; /* line # 885 */
        goto L_l_0;
      }
      break;
      case 2:break;
      case 3:
      case 4:break;
      case 6:Ra.sl[86]=901; /* line # 901 */
      if (((V *)V_sel_pat)[1]!=NULL) {
        Ra.sl[86]=903; /* line # 903 */
        V_sel_pat=((V *)V_sel_pat)[1];
        Ra.sl[86]=904; /* line # 904 */
        V_tbpat.v[PAS__RANGE(Rv3,1,64)-1]=V_sel_pat;
        Ra.sl[86]=905; /* line # 905 */
        V_frspint=V_frspint+1;
        Ra.sl[86]=906; /* line # 906 */
        P_integr_Set_limit(V_e_thmin, V_e_thmax);
        Ra.sl[86]=907; /* line # 907 */
        P_integr_Ref_copy();
        Ra.sl[86]=908; /* line # 908 */
        RPWDATAAW2D_PRC_00000002();
        Ra.sl[86]=909; /* line # 909 */
        Rv0=1;
        Rv1=1;
        Ra.sl[86]=910; /* line # 910 */
        Rv2=1;
        Ra.sl[86]=911; /* line # 911 */
        goto L_l_2;
      }
      else {
        Ra.sl[86]=913; /* line # 913 */
        Rv6=Rd.s+482;
      }
      break;
      case 7:Ra.sl[86]=916; /* line # 916 */
      if (((V *)V_sel_pat)[2]!=NULL) {
        Ra.sl[86]=918; /* line # 918 */
        V_sel_pat=((V *)V_sel_pat)[2];
        Ra.sl[86]=919; /* line # 919 */
        V_tbpat.v[PAS__RANGE(Rv3,1,64)-1]=V_sel_pat;
        Ra.sl[86]=920; /* line # 920 */
        V_frspint=V_frspint-1;
        Ra.sl[86]=921; /* line # 921 */
        P_integr_Set_limit(V_e_thmin, V_e_thmax);
        Ra.sl[86]=922; /* line # 922 */
        P_integr_Ref_copy();
        Ra.sl[86]=923; /* line # 923 */
        RPWDATAAW2D_PRC_00000002();
        Ra.sl[86]=924; /* line # 924 */
        Rv0=1;
        Rv1=1;
        Ra.sl[86]=925; /* line # 925 */
        Rv2=1;
        Ra.sl[86]=926; /* line # 926 */
        goto L_l_2;
      }
      else {
        Ra.sl[86]=928; /* line # 928 */
        Rv6=Rd.s+536;
      }
      break;
      case 10:Ra.sl[86]=932; /* line # 932 */
      Rv19=Draw_Seg_Pick(&Rv20, &Rv3);
      Ra.sl[86]=933; /* line # 933 */
      if (Rv19>0&&Rv20==Ra.sl[16]) {
        Ra.sl[86]=935; /* line # 935 */
        V_sel_pat=V_tbpat.v[PAS__RANGE(Rv3,1,64)-1];
        Ra.sl[86]=936; /* line # 936 */
        V_cshift=(float)(Rv3-1)*Rv11;
        Ra.sl[86]=937; /* line # 937 */
        P_integr_Select_pattern(V_sel_pat);
        Ra.sl[86]=938; /* line # 938 */
        P_integr_Set_limit(V_e_thmin, V_e_thmax);
        Ra.sl[86]=939; /* line # 939 */
        P_integr_Ref_copy();
        Ra.sl[86]=940; /* line # 940 */
        V_frspint=RPWDATAAW2D_PRC_00000008(V_sel_pat);
        Ra.sl[86]=941; /* line # 941 */
        RPWDATAAW2D_PRC_00000002();
        Ra.sl[86]=942; /* line # 942 */
        Rv0=1;
        Rv1=1;
        Ra.sl[86]=943; /* line # 943 */
        Rv2=1;
        Ra.sl[86]=944; /* line # 944 */
        Draw_Pannel_Put(((SL *)V_setup_tab.v[PAS__RANGE(0,0,V_setup_tab.sl[0])+1]
        )[1]);
        Ra.sl[86]=945; /* line # 945 */
        goto L_l_2;
      }
      break;
      case 11:Ra.sl[86]=950; /* line # 950 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=952; /* line # 952 */
        if (Rv9) {
          Ra.sl[86]=954; /* line # 954 */
          Ri.sl[79]=Draw_Pas_Get_Value(Rd.s+594,&Rv21, V_e_thmin, V_e_thmax);
          Ra.sl[86]=955; /* line # 955 */
          if (Ri.sl[79]==1) {
            Ra.sl[86]=956; /* line # 956 */
            Ri.sl[79]=Draw_Pas_Get_Value(Rd.s+603,&Rv22, Rv21, V_e_thmax);
          }
        }
        else {
          Ra.sl[86]=960; /* line # 960 */
          Ri.sl[79]=Draw_Get_Window(&Rv21, &Rv23, &Rv22, &Rv24);
          Ra.sl[86]=964; /* line # 964 */
          if (Rv22<Rv21*(F)1.050000E+00) Ri.sl[79]=0;
        }
        Ra.sl[86]=966; /* line # 966 */
        if (Ri.sl[79]==1) {
          Ra.sl[86]=968; /* line # 968 */
          V_e_thmin=Rv21;
          V_e_thmax=Rv22;
          Ra.sl[86]=969; /* line # 969 */
          RPWDATAAW2D_PRC_00000002();
          Ra.sl[86]=970; /* line # 970 */
          Rv0=1;
          Rv1=1;
          Ra.sl[86]=971; /* line # 971 */
          P_integr_Set_limit(V_e_thmin, V_e_thmax);
          Ra.sl[86]=972; /* line # 972 */
          P_integr_Free_allz();
          Ra.sl[86]=973; /* line # 973 */
          Rv2=1;
          Ra.sl[86]=974; /* line # 974 */
          goto L_l_2;
        }
      }
      break;
      case 12:Ra.sl[86]=980; /* line # 980 */
      V_e_thmin=Rv7;
      V_e_thmax=Rv8;
      Ra.sl[86]=981; /* line # 981 */
      if (V_sel_pat!=NULL) P_integr_Set_limit(V_e_thmin, V_e_thmax);
      Ra.sl[86]=982; /* line # 982 */
      RPWDATAAW2D_PRC_00000002();
      Ra.sl[86]=983; /* line # 983 */
      Rv0=1;
      Rv1=1;
      Ra.sl[86]=984; /* line # 984 */
      P_integr_Select_pattern(V_sel_pat);
      Ra.sl[86]=985; /* line # 985 */
      P_integr_Free_allz();
      Ra.sl[86]=986; /* line # 986 */
      Rv2=1;
      Ra.sl[86]=987; /* line # 987 */
      goto L_l_1;
      break;
      case 13:
      case 14:Ra.sl[86]=993; /* line # 993 */
      Rv25=V_e_thmax-V_e_thmin;
      Ra.sl[86]=994; /* line # 994 */
      Rv26=Ri.f[81]*Rv25;
      Ra.sl[86]=995; /* line # 995 */
      if (Rv17==13) {
        Ra.sl[86]=997; /* line # 997 */
        V_e_thmin=V_e_thmin-Rv26;
        Ra.sl[86]=998; /* line # 998 */
        V_e_thmax=V_e_thmax-Rv26;
        Ra.sl[86]=999; /* line # 999 */
        if (V_e_thmin<Rv7) {
          V_e_thmin=Rv7;
          V_e_thmax=V_e_thmin+Rv25;
        }
      }
      else {
        Ra.sl[86]=1003; /* line # 1003 */
        V_e_thmin=V_e_thmin+Rv26;
        Ra.sl[86]=1004; /* line # 1004 */
        V_e_thmax=V_e_thmax+Rv26;
        Ra.sl[86]=1005; /* line # 1005 */
        if (V_e_thmax>Rv8) {
          V_e_thmax=Rv8;
          V_e_thmin=V_e_thmax-Rv25;
        }
      }
      Ra.sl[86]=1007; /* line # 1007 */
      if (V_sel_pat!=NULL) P_integr_Set_limit(V_e_thmin, V_e_thmax);
      Ra.sl[86]=1008; /* line # 1008 */
      RPWDATAAW2D_PRC_00000002();
      Ra.sl[86]=1009; /* line # 1009 */
      Rv0=1;
      Rv1=1;
      Ra.sl[86]=1010; /* line # 1010 */
      P_integr_Set_limit(V_e_thmin, V_e_thmax);
      Ra.sl[86]=1011; /* line # 1011 */
      P_integr_Free_allz();
      Ra.sl[86]=1012; /* line # 1012 */
      Rv2=1;
      Ra.sl[86]=1013; /* line # 1013 */
      goto L_l_2;
      break;
      case 20:Ra.sl[86]=1017; /* line # 1017 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1019; /* line # 1019 */
        P_integr_Suppress_background();
        Ra.sl[86]=1020; /* line # 1020 */
        RPWDATAAW2D_PRC_00000006();
        Ra.sl[86]=1021; /* line # 1021 */
        Draw_Echo_Line(2,1,1, (F)2.000000E+00);
        Ra.sl[86]=1022; /* line # 1022 */
        Ri.sl[79]=Draw_Get_Curve(Rs.s+84,256, &Rv27,0,0);
        Ra.sl[86]=1023; /* line # 1023 */
        if (Ri.sl[79]==1) P_integr_Set_background(Rs.s+84,256, Rv27);
        Ra.sl[86]=1024; /* line # 1024 */
        RPWDATAAW2D_PRC_00000006();
      }
      break;
      case 21:Ra.sl[86]=1028; /* line # 1028 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1029; /* line # 1029 */
        if (Draw_Get_Window(&Rv21, &Rv23, &Rv22, &Rv24)==1) {
          Ra.sl[86]=1031; /* line # 1031 */
          Rv6=P_integr_Set_refzone(Rv21, Rv22);
          Ra.sl[86]=1032; /* line # 1032 */
          RPWDATAAW2D_PRC_00000004();
        }
      }
      break;
      case 22:Ra.sl[86]=1036; /* line # 1036 */
      if (V_sel_pat!=NULL&&V_crv_frs!=NULL) {
        Ra.sl[86]=1038; /* line # 1038 */
        Draw_Pas_Str_Dspl(Rd.s+612);
        while (1){
          Ra.sl[86]=1040; /* line # 1040 */
          Ri.sl[79]=Draw_Get_Position(&Rv22, &Rv24,1);
          Ra.sl[86]=1041; /* line # 1041 */
          if (Ri.sl[79]==1) {
            Ra.sl[86]=1043; /* line # 1043 */
            if (Draw_Get_Position(&Rv21, &Rv23,1)==1) {
              Ra.sl[86]=1045; /* line # 1045 */
              Rv6=P_integr_Set_refline(Rv22, Rv24, fabs(Rv22-Rv21),0);
              Ra.sl[86]=1046; /* line # 1046 */
              if (Rv6==NULL) RPWDATAAW2D_PRC_00000004();
              else {
                Ra.sl[86]=1047; /* line # 1047 */
                Draw_Pas_Message(Rv6);
                Rv6=NULL;
              }
            }
          }
          if (Ri.sl[79]!=1)  break;
        }
        Ra.sl[86]=1051; /* line # 1051 */
        Draw_Pas_Str_Dspl(Rd.s+659);
      }
      break;
      case 23:Ra.sl[86]=1055; /* line # 1055 */
      if (Draw_Get_Position(&Rv21, &Rv23,1)==1) {
        Ra.sl[86]=1057; /* line # 1057 */
        Rv6=P_integr_Zone_del(Rv21);
        Ra.sl[86]=1058; /* line # 1058 */
        RPWDATAAW2D_PRC_00000004();
      }
      break;
      case 24:Ra.sl[86]=1062; /* line # 1062 */
      if (V_sel_pat!=NULL&&V_crv_frs!=NULL) {
        Ra.sl[86]=1064; /* line # 1064 */
        Draw_Pas_Str_Dspl(Rd.s+612);
        while (1){
          Ra.sl[86]=1066; /* line # 1066 */
          Ri.sl[79]=Draw_Get_Position(&Rv21, &Rv23,1);
          Ra.sl[86]=1067; /* line # 1067 */
          if (Ri.sl[79]==1) {
            Ra.sl[86]=1069; /* line # 1069 */
            Rv6=P_integr_Line_del(Rv21);
            Ra.sl[86]=1070; /* line # 1070 */
            if (Rv6!=NULL) {
              Draw_Pas_Message(Rv6);
              Rv6=NULL;
            }
            else {
              Ra.sl[86]=1071; /* line # 1071 */
              RPWDATAAW2D_PRC_00000004();
            }
          }
          if (Ri.sl[79]!=1)  break;
        }
        Ra.sl[86]=1074; /* line # 1074 */
        Draw_Pas_Str_Dspl(Rd.s+661);
      }
      break;
      case 31:Ra.sl[86]=1078; /* line # 1078 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1080; /* line # 1080 */
        Rv6=P_integr_Build_background();
        Ra.sl[86]=1081; /* line # 1081 */
        if (V_ntotpck>=0) RPWDATAAW2D_PRC_00000004();
        Ra.sl[86]=1082; /* line # 1082 */
        RPWDATAAW2D_PRC_00000006();
      }
      break;
      case 32:Ra.sl[86]=1087; /* line # 1087 */
      P_integr_Smooth_background();
      Ra.sl[86]=1088; /* line # 1088 */
      RPWDATAAW2D_PRC_00000006();
      break;
      case 33:Ra.sl[86]=1092; /* line # 1092 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1094; /* line # 1094 */
        Rv6=P_integr_Ref_locate();
        Ra.sl[86]=1095; /* line # 1095 */
        RPWDATAAW2D_PRC_00000004();
      }
      break;
      case 34:Ra.sl[86]=1099; /* line # 1099 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1101; /* line # 1101 */
        Rv6=P_integr_Hkl_index();
        Ra.sl[86]=1102; /* line # 1102 */
        if (V_ntotpck>=0) RPWDATAAW2D_PRC_00000004();
      }
      break;
      case 35:Ra.sl[86]=1106; /* line # 1106 */
      if (V_sel_pat!=NULL) {
        Ra.sl[86]=1108; /* line # 1108 */
        if (V_ntotpck<=0) {
          Ra.sl[86]=1110; /* line # 1110 */
          Rv6=P_integr_Ref_locate();
          Ra.sl[86]=1111; /* line # 1111 */
          if (V_ntotpck>=0) RPWDATAAW2D_PRC_00000004();
        }
        Ra.sl[86]=1113; /* line # 1113 */
        if (V_ntotpck>0) {
          Ra.sl[86]=1115; /* line # 1115 */
          Rv6=P_integr_Ref_integr();
          Ra.sl[86]=1116; /* line # 1116 */
          RPWDATAAW2D_PRC_00000006();
          Ra.sl[86]=1117; /* line # 1117 */
          if (V_ntotpck>=0) RPWDATAAW2D_PRC_00000004();
        }
      }
      break;
      case 15:Ra.sl[86]=1123; /* line # 1123 */
      Ri.sl[79]=Draw_Pas_Select_MFile(Rd.s+663,Ri.s+328,V_int_name.s,Ra.s+72,Ri.
      sl+93,1,0);
      Ra.sl[86]=1129; /* line # 1129 */
      if (Ri.sl[79]>0) {
        Ra.sl[86]=1131; /* line # 1131 */
        PAS__STR_TO_STR(V_int_name.s,Ra.s+72);
        Ra.sl[86]=1132; /* line # 1132 */
        V_fil_nbr=Draw_Pas_Get_Answerd(Rd.s+688)==1;
        Ra.sl[86]=1133; /* line # 1133 */
        if (!V_fil_nbr) {
          Ra.sl[86]=1134; /* line # 1134 */
          if (PAS__FILE_ACCESS(V_int_name.s,0,0)) {
            Ra.sl[86]=1135; /* line # 1135 */
            if (PAS__FILE_ACCESS(V_int_name.s,6,0)) {
              Ra.sl[86]=1136; /* line # 1136 */
              V_out_app=Draw_Pas_Get_Answerd(Rd.s+732)==1;
            }
            else {
              Ra.sl[86]=1139; /* line # 1139 */
              V_out_app=0;
              Ra.sl[86]=1140; /* line # 1140 */
              PAS__VWRITE_INIT(Ra.s+72,1);
              PAS__WRITE_STR(Rd.s+778,-1,-1,32);
              PAS__WRITE_STR(V_int_name.s,-1,-1,32);
              PAS__WRITE_STR(Rd.s+811,-1,-1,32);
              PAS__WRITE_EOLN();
              Ra.sl[86]=1141; /* line # 1141 */
              Draw_Pas_Message(Ra.s+72);
            }
          }
        }
      }
      break;
      case 36:Ra.sl[86]=1147; /* line # 1147 */
      Rv6=P_integr_Write_results();
      break;
      case 39:Ra.sl[86]=1151; /* line # 1151 */
      Rv26=(float)V_frspint;
      Ra.sl[86]=1152; /* line # 1152 */
      Rv28=(F)1.000000E+00;
      Ra.sl[86]=1153; /* line # 1153 */
      Rv29=(float)V_npat;
      Ra.sl[86]=1154; /* line # 1154 */
      Ri.sl[79]=Draw_Pas_Get_Value(Rd.s+848,&Rv26, Rv28, Rv29);
      Ra.sl[86]=1155; /* line # 1155 */
      if (Ri.sl[79]==1) {
        Ra.sl[86]=1157; /* line # 1157 */
        V_frspint=(Rv26>0.0?(SL)(Rv26+0.5):(SL)(Rv26-0.5));
        Ra.sl[86]=1158; /* line # 1158 */
        Rv26=(float)V_nbrpint;
        Ra.sl[86]=1159; /* line # 1159 */
        Rv28=(F)1.000000E+00;
        Ra.sl[86]=1160; /* line # 1160 */
        Rv29=(float)((V_npat-V_frspint)+1);
        Ra.sl[86]=1161; /* line # 1161 */
        Ri.sl[79]=Draw_Pas_Get_Value(Rd.s+883,&Rv26, Rv28, Rv29);
        Ra.sl[86]=1162; /* line # 1162 */
        if (Ri.sl[79]==1) {
          Ra.sl[86]=1164; /* line # 1164 */
          V_nbrpint=(Rv26>0.0?(SL)(Rv26+0.5):(SL)(Rv26-0.5));
          Ra.sl[86]=1165; /* line # 1165 */
          if (V_nbrpint==0) V_nbrpint=(V_npat-V_frspint)+1;
          Ra.sl[86]=1166; /* line # 1166 */
          PAS__VWRITE_INIT(Ra.s+202,1);
          PAS__WRITE_STR(Rd.s+915,-1,-1,32);
          PAS__WRITE_INT(V_nbrpint,0,0);
          PAS__WRITE_STR(Rd.s+955,-1,-1,32);
          PAS__WRITE_INT(V_frspint,0,0);
          PAS__WRITE_STR(Rd.s+995,-1,-1,32);
          PAS__WRITE_EOLN();
          Ra.sl[86]=1168; /* line # 1168 */
          Ri.sl[79]=Draw_Pas_Get_Answerd(Ra.s+202);
          Ra.sl[86]=1169; /* line # 1169 */
          if (Ri.sl[79]==1) Rv6=P_integr_Proceed();
        }
      }
      Ra.sl[86]=1172; /* line # 1172 */
      P_integr_Set_limit(V_szthmin, V_szthmax);
      Ra.sl[86]=1173; /* line # 1173 */
      RPWDATAAW2D_PRC_00000002();
      Ra.sl[86]=1174; /* line # 1174 */
      Rv0=1;
      Rv1=1;
      Ra.sl[86]=1175; /* line # 1175 */
      goto L_l_2;
      break;
      case 41:Ra.sl[86]=1178; /* line # 1178 */
      Rv9=0;
      break;
      case 42:Ra.sl[86]=1179; /* line # 1179 */
      Rv9=1;
      break;
      case 43:Ra.sl[86]=1183; /* line # 1183 */
      Ri.sl[79]=Draw_Pas_Get_Value(Rd.s+999,Ri.f+81,(F)0.000000E-01, (F)1.000000E+00);
      Ra.sl[86]=1184; /* line # 1184 */
      if (Ri.sl[79]==1) {
        Ra.sl[86]=1186; /* line # 1186 */
        if (Ri.f[81]<(F)1.000000E-02) Ri.f[81]=(F)1.000000E-02;
        else {
          Ra.sl[86]=1187; /* line # 1187 */
          if (Ri.f[81]>(F)1.000000E+00) Ri.f[81]=(F)1.000000E+00;
        }
      }
      break;
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:Ra.sl[86]=1193; /* line # 1193 */
      Draw_Pannel_Open(((SL *)V_setup_tab.v[PAS__RANGE(Rv17-50,0,V_setup_tab.sl[
0])+1])[1]);
      break;
      case 66:
      case 67:
      case 68:
      case 69:Ra.sl[86]=1196; /* line # 1196 */
      Draw_Pannel_Open(((SL *)V_setup_tab.v[PAS__RANGE(Rv17-60,0,V_setup_tab.sl[
0])+1])[1]);
      break;
      case 61:
      case 62:Ra.sl[86]=1201; /* line # 1201 */
      if (Rv17==61) {
        Ra.sl[86]=1203; /* line # 1203 */
        Ri.sl[79]=Draw_Pas_Select_MFile(Rd.s+1011,Ri.s+376,V_setupf.s,Ra.s+72,Ri
        .sl+102,1,0);
        Ra.sl[86]=1209; /* line # 1209 */
        if (Ri.sl[79]>0) PAS__STR_TO_STR(V_setupf.s,Ra.s+72);
      }
      else {
        Ra.sl[86]=1211; /* line # 1211 */
        Ri.sl[79]=1;
      }
      Ra.sl[86]=1212; /* line # 1212 */
      if (Ri.sl[79]>0) {
        Ra.sl[86]=1214; /* line # 1214 */
        Rv6=P_write_setup_file(V_setupf.s,V_setup_tab.s);
        Ra.sl[86]=1215; /* line # 1215 */
        if (Rv6==NULL) Ri.ub[412]=0;
      }
      break;
      case 63:Ra.sl[86]=1221; /* line # 1221 */
      Ri.sl[79]=Draw_Pas_Select_MFile(Rd.s+1030,Ri.s+376,V_setupf.s,Ra.s+72,Ri.sl+
102,0,0);
      Ra.sl[86]=1226; /* line # 1226 */
      if (Ri.sl[79]>0) {
        Ra.sl[86]=1228; /* line # 1228 */
        PAS__STR_TO_STR(V_setupf.s,Ra.s+72);
        Ra.sl[86]=1229; /* line # 1229 */
        Rv6=P_read_setup_file(V_setupf.s,V_setup_tab.s);
        Ra.sl[86]=1230; /* line # 1230 */
        if (Rv6==NULL) Ri.ub[412]=0;
      }
      break;
      case 60:Ra.sl[86]=1235; /* line # 1235 */
      if (Draw_Pas_Get_Answerd(Rd.s+1045)==1) {
        Ra.sl[86]=1237; /* line # 1237 */
        PAS__STR_TO_STR(V_setupf.s,V_default_setup.s);
        Ra.sl[86]=1238; /* line # 1238 */
        Ri.sl[102]=1;
        Ra.sl[86]=1239; /* line # 1239 */
        P_main_Setup_init();
      }
      break;
      case 45:Ra.sl[86]=1242; /* line # 1242 */
      P_integr_Save_a_pck();
      break;
      case 47:Ra.sl[86]=1246; /* line # 1246 */
      P_integr_Reload_a_pck();
      Ra.sl[86]=1247; /* line # 1247 */
      if (V_ntotpck>=0) {
        Ra.sl[86]=1248; /* line # 1248 */
        RPWDATAAW2D_PRC_00000004();
        RPWDATAAW2D_PRC_00000006();
      }
      break;
      case 46:
      case 48:Ra.sl[86]=1253; /* line # 1253 */
      if (Draw_Get_Position(&Rv21, &Rv23,1)==1) {
        Ra.sl[86]=1254; /* line # 1254 */
        if (Rv17==48) P_integr_Reload_z_pck(Rv21);
        else {
          Ra.sl[86]=1256; /* line # 1256 */
          P_integr_Save_z_pck(Rv21);
          Ra.sl[86]=1257; /* line # 1257 */
          if (V_ntotpck>=0) {
            Ra.sl[86]=1258; /* line # 1258 */
            RPWDATAAW2D_PRC_00000004();
            RPWDATAAW2D_PRC_00000006();
          }
        }
      }
      break;
      default:break;
    }
    Ra.sl[86]=1267; /* line # 1267 */
    if (Rv17<0)  break;
  }
  Ra.sl[86]=1269; /* line # 1269 */
  Draw_Close_Box();
  Ra.sl[86]=1271; /* line # 1271 */
  if (Ri.ub[412]) {
    Ra.sl[86]=1273; /* line # 1273 */
    Rv6=P_write_setup_file(V_setupf.s,V_setup_tab.s);
    Ra.sl[86]=1274; /* line # 1274 */
    if (Rv6==NULL) Ri.ub[412]=0;
    else {
      Ra.sl[86]=1275; /* line # 1275 */
      Draw_Pas_Message(Rv6);
    }
  }
  Ra.sl[86]=1279; /* line # 1279 */
  Draw_End();
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[83];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " get_new_params "  */
SL P_get_new_params(V F_pan_descr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1095;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=1288; /* line # 1288 */
  if (V_drw_ok) Ret=Draw_Pannel_Get(((SL *)F_pan_descr)[1]);
  else {
    Ra.sl[3]=1289; /* line # 1289 */
    Ret=-10;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " init_plot "  */
void RPWDATAAW2D_init_plot(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1111;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=1324; /* line # 1324 */
  Draw_Pas_Set_Menu_Spc(1, NULL,-1,0);
  Ra.sl[3]=1325; /* line # 1325 */
  Draw_Pas_Set_Menu_Spc(2, NULL,-1,0);
  Ra.sl[3]=1326; /* line # 1326 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1122,1,79);
  Ra.sl[3]=1333; /* line # 1333 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1334; /* line # 1334 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1133,-1,0);
  Ra.sl[3]=1335; /* line # 1335 */
  if (V_ndia>1) {
    Ra.sl[3]=1336; /* line # 1336 */
    Draw_Pas_Set_Menu_Spc(4, Rd.s+1148,10,0);
  }
  Ra.sl[3]=1337; /* line # 1337 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1164,11,0);
  Ra.sl[3]=1338; /* line # 1338 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1177,12,0);
  Ra.sl[3]=1339; /* line # 1339 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1193,13,76);
  Ra.sl[3]=1340; /* line # 1340 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1205,14,82);
  Ra.sl[3]=1341; /* line # 1341 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1218,43,0);
  Ra.sl[3]=1342; /* line # 1342 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1231,6,78);
  Ra.sl[3]=1343; /* line # 1343 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1245,7,80);
  Ra.sl[3]=1344; /* line # 1344 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1263,15,0);
  Ra.sl[3]=1346; /* line # 1346 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1347; /* line # 1347 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1281,-1,0);
  Ra.sl[3]=1348; /* line # 1348 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1291,21,0);
  Ra.sl[3]=1349; /* line # 1349 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1303,22,0);
  Ra.sl[3]=1350; /* line # 1350 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1316,23,0);
  Ra.sl[3]=1351; /* line # 1351 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1331,24,0);
  Ra.sl[3]=1352; /* line # 1352 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1346,45,0);
  Ra.sl[3]=1353; /* line # 1353 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1356,46,0);
  Ra.sl[3]=1354; /* line # 1354 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1371,47,0);
  Ra.sl[3]=1355; /* line # 1355 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1383,48,0);
  Ra.sl[3]=1357; /* line # 1357 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1358; /* line # 1358 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1400,-1,0);
  Ra.sl[3]=1359; /* line # 1359 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1413,20,0);
  Ra.sl[3]=1360; /* line # 1360 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1429,31,49);
  Ra.sl[3]=1361; /* line # 1361 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1442,32,0);
  Ra.sl[3]=1362; /* line # 1362 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1456,33,50);
  Ra.sl[3]=1363; /* line # 1363 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1469,34,0);
  Ra.sl[3]=1364; /* line # 1364 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1481,35,51);
  Ra.sl[3]=1365; /* line # 1365 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1495,36,0);
  Ra.sl[3]=1366; /* line # 1366 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1513,39,0);
  Ra.sl[3]=1367; /* line # 1367 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1368; /* line # 1368 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1528,-1,0);
  Ra.sl[3]=1369; /* line # 1369 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1535,-1,0);
  Ra.sl[3]=1370; /* line # 1370 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1544,66,65470);
  Ra.sl[3]=1371; /* line # 1371 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1553,67,65471);
  Ra.sl[3]=1372; /* line # 1372 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1562,68,65472);
  Ra.sl[3]=1373; /* line # 1373 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1571,69,65473);
  Ra.sl[3]=1374; /* line # 1374 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1376; /* line # 1376 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1580,50,262221);
  Ra.sl[3]=1377; /* line # 1377 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1592,51,262215);
  Ra.sl[3]=1378; /* line # 1378 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1607,53,262210);
  Ra.sl[3]=1379; /* line # 1379 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1625,54,262227);
  Ra.sl[3]=1380; /* line # 1380 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1644,52,262224);
  Ra.sl[3]=1381; /* line # 1381 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1664,55,262216);
  Ra.sl[3]=1382; /* line # 1382 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1687,61,0);
  Ra.sl[3]=1383; /* line # 1383 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1703,62,0);
  Ra.sl[3]=1384; /* line # 1384 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1716,63,0);
  Ra.sl[3]=1385; /* line # 1385 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1732,60,0);
  Ra.sl[3]=1387; /* line # 1387 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+1748,-1,0);
  Ra.sl[3]=1388; /* line # 1388 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1761,41,0);
  Ra.sl[3]=1389; /* line # 1389 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1776,42,0);
  Ra.sl[3]=1390; /* line # 1390 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+1792,43,0);
  Ra.sl[3]=1391; /* line # 1391 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1393; /* line # 1393 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Ra.sl[3]=1395; /* line # 1395 */
  Draw_SrvMod=1073741824;
  Ra.sl[3]=1396; /* line # 1396 */
  Draw_Pas_Init(Rs.f+277,Rs.f+278,Rs.ub+1116,Rd.s+1805);
  Ra.sl[3]=1397; /* line # 1397 */
  if (Draw_Srv_Flg!=0) {
    Ra.sl[3]=1399; /* line # 1399 */
    Draw_Pic_View(1);
    Ra.sl[3]=1400; /* line # 1400 */
    V_drw_ok=1;
  }
  PAS__curr_cntx=Ra.v[0];
}
