export PAS_BIN#
#       Makefile for RPWDATA on UNIX Like systems
#
#

CC	=	gcc
PAS	=	pcmp

oDir	=	.
Bin	=	.
Src	=	.

LIB	=	-L/usr/local/lib -lcpas -lm
LIBS	=	-ldraw

C_FLAGS = -O -c

P_FLAGS = -t1 -r

L_FLAGS =

SRCP =\
	$(Src)/rpwdata.pas \
	$(Src)/rpwdata_env.pas \
	$(Src)/rpwdata_inp_out.pas \
	$(Src)/rpwdata_draw.pas \
	$(Src)/rpwdata_lsq.pas \
	$(Src)/rpwdata_int_bck.pas \
	$(Src)/rpwdata_int_ref.pas \
	$(Src)/rpwdata_int_int.pas \
	$(Src)/rpwdata_int_hkl.pas \
	$(Src)/rpwdata_int_pro.pas

SRCS =\
	$(Src)/rpwdata.c \
	$(Src)/rpwdata_inp_out.c \
	$(Src)/rpwdata_draw.c \
	$(Src)/rpwdata_lsq.c \
	$(Src)/rpwdata_int_bck.c \
	$(Src)/rpwdata_int_ref.c \
	$(Src)/rpwdata_int_int.c \
	$(Src)/rpwdata_int_hkl.c \
	$(Src)/rpwdata_int_pro.c

Obj =\
	$(oDir)/rpwdata.o \
	$(oDir)/rpwdata_inp_out.o \
	$(oDir)/rpwdata_draw.o \
	$(oDir)/rpwdata_lsq.o \
	$(oDir)/rpwdata_int_bck.o \
	$(oDir)/rpwdata_int_ref.o \
	$(oDir)/rpwdata_int_int.o \
	$(oDir)/rpwdata_int_hkl.o \
	$(oDir)/rpwdata_int_pro.o

#
all:    $(Bin)/rpwdata
#

$(Bin)/rpwdata: $(Obj)
	$(CC) $(L_FLAGS) $(Obj) $(LIB) $(LIBS) -o $(Bin)/rpwdata
#
$(oDir)/rpwdata.o: $(Src)/rpwdata.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata.c -o $(oDir)/rpwdata.o
#
$(oDir)/rpwdata_inp_out.o: $(Src)/rpwdata_inp_out.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_inp_out
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_inp_out.c -o $(oDir)/rpwdata_inp_out.o
#
$(oDir)/rpwdata_draw.o: $(Src)/rpwdata_draw.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_draw
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_draw.c -o $(oDir)/rpwdata_draw.o
#
$(oDir)/rpwdata_lsq.o: $(Src)/rpwdata_lsq.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_lsq
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_lsq.c -o $(oDir)/rpwdata_lsq.o
#
$(oDir)/rpwdata_int_bck.o: $(Src)/rpwdata_int_bck.pas $(Src)/rpwdata_int_env.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_int_bck
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_int_bck.c -o $(oDir)/rpwdata_int_bck.o
#
$(oDir)/rpwdata_int_ref.o: $(Src)/rpwdata_int_ref.pas $(Src)/rpwdata_int_env.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_int_ref
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_int_ref.c -o $(oDir)/rpwdata_int_ref.o
#
$(oDir)/rpwdata_int_int.o: $(Src)/rpwdata_int_int.pas $(Src)/rpwdata_int_env.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_int_int
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_int_int.c -o $(oDir)/rpwdata_int_int.o
#
$(oDir)/rpwdata_int_hkl.o: $(Src)/rpwdata_int_hkl.pas $(Src)/rpwdata_int_env.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_int_hkl
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_int_hkl.c -o $(oDir)/rpwdata_int_hkl.o
#
$(oDir)/rpwdata_int_pro.o: $(Src)/rpwdata_int_pro.pas $(Src)/rpwdata_int_env.pas $(Src)/rpwdata_env.pas
	$(PAS) $(P_FLAGS) $(Src)/rpwdata_int_pro
	$(CC) $(C_FLAGS) $(INC) $(Src)/rpwdata_int_pro.c -o $(oDir)/rpwdata_int_pro.o
#
#
#
clean:
	-rm $(Src)/rpwdata*.c $(Obj) $(Bin)/rpwdata
#
end:
