{

}
program VRF_FILE_TEST;


const
  min_bfsize  =   64;                   { Minimum and default size for buffer in (Double"size unit) }
  def_bfsize  =  512;

  vrf_runit   = double"size;            { Unit for record size }
  vrf_signature = 'VRF-FILE';           { Head of a Vrf file (signature) }


type
  vrf_element  =  record
                    case integer of
                      0:( tch: array[1..8] of char);
                      1:( in0, in1:     integer );
                      2:( fl0, fl1: single );
                      3:( dbl: double )
                  end;

  vrf_filtyp   =  file of vrf_element;

  vrf_file = ^vrf_dsc := nil;

  vrec_ptr = ^vrecord;

  vrf_dsc = record
    vrf_next:         vrf_file;         { Link to next opened variable format file }
    vrf_mode:       flags_file;         { I/O mode of the file }
    vrf_beof:          boolean;         { Flag for End of File }
    vrf_file:       vrf_filtyp;         { Standard pascal file to use }
    vrf_recnb,                          { Current record number }
    vrf_nbrec,                          { Current number of record in the file }
    vrf_recsz,                          { Current record size }
    vrf_maxsz:         integer;         { Maximum record size }
    vrf_buff:         vrec_ptr          { I/O Buffer pointer }
  end;


  vrecord( capacity: integer ) = record
    length: integer;
    buffer: array[1..capacity] of vrf_element
  end;


var
  vrf_first,                            { Open File Queue List header }
  vrf_last:           vrf_file;





procedure VRF_GET( vrf: vrf_file ); external 'PAS__VRF_GET';

procedure VRF_PUT( vrf: vrf_file ); external 'PAS__VRF_PUT';


[global 'PAS__VRF_WRITE']
procedure VRF_WRITE( vrf: vrf_file; var obj: $wild_pointer );
begin
end VRF_WRITE;



[global 'PAS__VRF_READ']
procedure VRF_READ( vrf: vrf_file; var obj: $wild_pointer );
begin
end VRF_READ;



procedure VRF_CLOSE( var vrf: vrf_file; idisp: flags_file := [] );
external 'PAS__VRF_CLOSE';


function  VRF_OPEN(    var vrf:         vrf_file;
                    in_var fname:         string;
                           imod:      flags_file;
                           mxrlen:  integer := 0;
                           iprot:  integer := -1 ): vrec_ptr;
external 'PAS__VRF_OPEN';



begin { main }

end VRF_FILE_TEST.
