{

}
module MXD_VAR_REC_FILE;


const
  min_bfsize  =   64;                   { Minimum and default size for buffer in (Double"size unit) }
  def_bfsize  =  512;

  vrf_runit   = double"size;            { Unit for record size }
  vrf_signature = 'VRF-FILE';           { Head of a Vrf file (signature) }


type
  vrf_element  =  record
                    case integer of
                      0:( tch: array[1..8] of char);
                      1:( in0, in1:     integer );
                      2:( fl0, fl1: single );
                      3:( dbl: double )
                  end;

  vrf_filtyp   =  file of vrf_element;

  vrf_file = ^vrf_dsc := nil;

  vrec_ptr = ^vrecord;

  vrf_dsc = record
    vrf_next:         vrf_file;         { Link to next opened variable format file }
    vrf_mode:       flags_file;         { I/O mode of the file }
    vrf_beof:          boolean;         { Flag for End of File }
    vrf_file:       vrf_filtyp;         { Standard pascal file to use }
    vrf_recnb,                          { Current record number }
    vrf_nbrec,                          { Current number of record in the file }
    vrf_recsz,                          { Current record size }
    vrf_maxsz:         integer;         { Maximum record size }
    vrf_buff:         vrec_ptr          { I/O Buffer pointer }
  end;


  vrecord( capacity: integer ) = record
    length: integer;
    buffer: array[1..capacity] of vrf_element
  end;


var
  vrf_first,                            { Open File Queue List header }
  vrf_last:           vrf_file;



{ Use the standard CPASCAL error procedure end message processing }
procedure PAS__ERROR( nn: cc__int ); external 'PAS__ERROR';




[global 'PAS__VRF_GET']
procedure VRF_GET( vrf: vrf_file );
var
  ii: integer  :=     0;
  el:       vrf_element;

begin
  if vrf <> nil then
  with vrf^ do
    if not (read_file in vrf_mode) then PAS__ERROR( 105 )
    else
    if vrf_beof then PAS__ERROR( 104 )
    else
    if vrf_buff <> nil then
    with vrf_buff^ do
    begin
      READ( vrf_file, el );                     { Get the record descriptor }
      vrf_recnb := vrf_recnb + 1;               { Increment the record count }
      vrf_recsz := el.in1;                      { Set the current record size }
      if vrf_recsz > capacity then PAS__ERROR( 324 );           { Check for too large record }
   {  if vrf_recsz > vrf_maxsz then vrf_maxsz := vrf_recsz;     { Adjust the record maximum size }
      while (ii < vrf_recsz) and not EOF( vrf_file ) do
      begin  ii := ii + 1; READ( vrf_file, buffer[ii] )  end;
      if ii < vrf_recsz then PAS__ERROR( 323 );
      vrf_beof := EOF( vrf_file )
    end
end VRF_GET;



[global 'PAS__VRF_PUT']
procedure VRF_PUT( vrf: vrf_file );
var
  ii: integer  :=     0;
  el:       vrf_element;

begin
  if vrf <> nil then
  with vrf^ do
    if vrf_mode*[write_file,append_file] = [] then PAS__ERROR( 105 )
    else
    if vrf_buff <> nil then
    with vrf_buff^ do
    begin
      el.in0 := 0; el.in1 := buffer[1].in1;
      WRITE( vrf_file, el ); vrf_recsz := el.in1;
      if vrf_recsz > capacity then PAS__ERROR( 325 );
      if vrf_recsz > vrf_maxsz then vrf_maxsz := vrf_recsz;
      while ii < el.in1 do
      begin  ii := ii + 1; READ( vrf_file, buffer[ii] )  end;
      vrf_recnb := vrf_recnb + 1
    end;
end VRF_PUT;



[global 'PAS__VRF_WRITE']
procedure VRF_WRITE( vrf: vrf_file; var obj: $wild_pointer );
begin
end VRF_WRITE;



[global 'PAS__VRF_READ']
procedure VRF_READ( vrf: vrf_file; var obj: $wild_pointer );
begin
end VRF_READ;



[global 'PAS__VRF_CLOSE']
procedure VRF_CLOSE( var vrf: vrf_file; idisp: flags_file := [] );
var
  f1, f2: vrf_file;
  fnm:      string;
  el:  vrf_element;

begin
  f1 := nil; f2 := vrf_first;
  { Search the file in the file list }
  while (f2 <> nil) and (f2 <> vrf) do
  begin  f1 := f2; f2 := f2^.vrf_next  end;

  if f2 <> nil then                     { When the file is found }
  begin
    with f2^ do
    begin
      if write_file in vrf_mode then VRF_PUT( f2 );
      { Take off the file from the active file list }
     if f1 = nil then vrf_first := vrf_next
                  else f1^.vrf_next := vrf_next;
      DISPOSE( vrf_buff );
      fnm := FILE_SPECIFICATION( vrf_file );
      CLOSE( vrf_file, idisp );

      { Update the file Header }
      OPEN( vrf_file, fnm, [write_file,direct_file,error_file] );
      if iostatus <> 0 then PAS__ERROR( 326 );
      el.in0 := vrf_recnb;
      el.in1 := vrf_maxsz;
      SEEK( vrf_file, 2 );
      WRITE( vrf_file, el );
      CLOSE( vrf_file )
    end;
    DISPOSE( f2 );
    vrf := nil
  end
end VRF_CLOSE;



[global 'PAS__VRF_OPEN']
function  VRF_OPEN(    var vrf:         vrf_file;
                    in_var fname:         string;
                           imod:      flags_file;
                           mxrlen:  integer := 0;
                           iprot:  integer := -1 ): vrec_ptr;
var
  nerr: integer     :=       0;
  bapp: boolean     :=   false;
  vrfe0, vrfe1:    vrf_element;

begin { PAS__VRF_OPEN }
  if vrf <> nil then VRF_CLOSE( vrf );

  if (imod*[read_file,write_file] = [read_file,write_file]) or
     (imod*[read_file,append_file] = [read_file,append_file]) or
                                        (direct_file in imod) then
  begin
    if not (error_file in imod) then PAS__ERROR( 321 );
    return
  end;

  if mxrlen <= 0 then mxrlen := def_bfsize
                 else if mxrlen < min_bfsize then mxrlen := min_bfsize;

  vrfe1.in0 := 0;                       { Set the default for any new file where ... }
  vrfe1.in1 := 0;                       { ... in0 = current last record number, in1 = maximum record size }

  NEW( vrf );
  with vrf^ do
  begin
    vrf_next  :=       nil;             { Init the descriptor queue link }
    vrf_mode  :=      imod;             { Set the descriptor field for the mode }
    vrf_beof  :=     false;             { Not EOF until shown otherwise }
    vrf_recnb :=         0;             { Init the current record number ... }
    vrf_nbrec :=         0;             { ... and the current number of record in the file }
    vrf_recsz :=         0;             { Init the current record size }
    vrf_maxsz :=         0;             { Init the maximum record size }

    if imod*[read_file,append_file] <> [] then
    begin
      OPEN( vrf_file, fname, [read_file,error_file], mxrlen, iprot );
      if iostatus = 0 then
      begin
        READ( vrf_file, vrfe0, vrfe1 ); { Get the signature, last record number and maximum record size }
        if vrfe0.tch <> vrf_signature then
          iostatus := 322               (* begin  CLOSE( vrf_file ); GEN_OPEN_ERR( 322 )  end; *)
        else
        begin
          vrf_nbrec := vrfe1.in0;       { Set theactual total number of record }
          vrf_maxsz := vrfe1.in1;       { Set the actual maximum record size }
          if (append_file in imod) or (mxrlen < vrfe1.in1) then
          begin { * The file must re-open * }
            CLOSE( vrf_file );          { Close file to re-open in append mode }
            mxrlen := vrfe1.in1;        { Adjust the object record to the record file size }
            OPEN( vrf_file, fname, imod+[error_file], mxrlen, iprot );
            if read_file in imod then READ( vrf_file, vrfe0, vrfe1 )    { To read re-opened file, skip dthe header ... }
                                 else vrf_recnb := vrf_nbrec            { ... and for append file, set the rec. number }
          end
        end
      end
      else
        if (append_file in imod) and (iostatus = 202) then    { Ignore No-Such File in append mode }
          OPEN( vrf_file, fname, [write_file,error_file], mxrlen, iprot )
    end
    else { open for Write a new file }
      OPEN( vrf_file, fname, [write_file,error_file], mxrlen, iprot );

    if iostatus = 0 then
    begin
      NEW( vrf_buff, mxrlen );          { Allocate the Record buffer ... }
      vrf_buff^.length := 0;            { ... and set it as empty }
      { Put the opened file in the list of active vrf files }
      if vrf_first = nil then vrf_first := vrf
                         else vrf_last^.vrf_next := vrf;
      vrf_last := vrf;
      if read_file in imod then VRF_GET( vrf ); { For read mode, read the first record }
      VRF_OPEN := vrf_buff
    end
    else
    begin
      DISPOSE( vrf );
      if not (error_file in imod) then PAS__ERROR( iostatus );
      VRF_OPEN := nil
    end
  end
end VRF_OPEN;


end MXD_VAR_REC_FILE.
