/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 104 ) = {
  7,   7, 118, 114, 102,  95, 103, 101, 116,  50,  50,  47, 104, 111, 109, 101,
 47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,  99, 112,
115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95, 115, 114,
 99,  47, 109, 120, 100,  95, 118, 114, 102,  46, 112,  97, 115,   7,   7, 118,
114, 102,  95, 112, 117, 116,   9,   9, 118, 114, 102,  95,  99, 108, 111, 115,
101,   8,   8, 118, 114, 102,  95, 111, 112, 101, 110,   8,   8,  86,  82,  70,
 45,  70,  73,  76,  69,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern SL PAS__iostatus;


/* Function/procedure prototypes. */
void PAS__ERROR(SL F_nn);


/* Procedure/Function : " vrf_get "  */
void PAS__VRF_GET(V F_vrf){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=68; /* line # 68 */
  if (F_vrf!=NULL) {
    Rv1=F_vrf;
    if (!(1&((UL *)Rv1)[1])) PAS__ERROR(105);
    else {
      if (((UB *)Rv1)[8]) PAS__ERROR(104);
      else {
        Ra.sl[3]=74; /* line # 74 */
        if (((V *)Rv1)[8]!=NULL) {
          Rv2=((V *)Rv1)[8];
          PAS__SELECT_INP(((V *)Rv1)[3]);
          PAS__READ_BIN(Ra.s+16);
          ((SL *)Rv1)[4]=((SL *)Rv1)[4]+1;
          Ra.sl[3]=79; /* line # 79 */
          ((SL *)Rv1)[6]=Ra.sl[5];
          if (((SL *)Rv1)[6]>((SL *)Rv2)[0]) PAS__ERROR(324);
          while (Rv0<((SL *)Rv1)[6]&&!PAS__EOF(((V *)Rv1)[3])){
            Rv0=Rv0+1;
            PAS__SELECT_INP(((V *)Rv1)[3]);
            PAS__READ_BIN((((S *)Rv2)+Rv0*8));
          }
          Ra.sl[3]=84; /* line # 84 */
          if (Rv0<((SL *)Rv1)[6]) PAS__ERROR(323);
          ((UB *)Rv1)[8]=PAS__EOF(((V *)Rv1)[3]);
        }
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " vrf_put "  */
void PAS__VRF_PUT(V F_vrf){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+61;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=98; /* line # 98 */
  if (F_vrf!=NULL) {
    Rv1=F_vrf;
    if ((((UL *)Rv1)[1]&6)==0) PAS__ERROR(105);
    else {
      if (((V *)Rv1)[8]!=NULL) {
        Ra.sl[3]=103; /* line # 103 */
        Rv2=((V *)Rv1)[8];
        Ra.sl[4]=0;
        Ra.sl[5]=((SL *)Rv2)[3];
        PAS__SELECT_OUT(((V *)Rv1)[3]);
        PAS__WRITE_BIN(Ra.s+16);
        ((SL *)Rv1)[6]=Ra.sl[5];
        if (((SL *)Rv1)[6]>((SL *)Rv2)[0]) PAS__ERROR(325);
        Ra.sl[3]=108; /* line # 108 */
        if (((SL *)Rv1)[6]>((SL *)Rv1)[7]) ((SL *)Rv1)[7]=((SL *)Rv1)[6];
        while (Rv0<Ra.sl[5]){
          Rv0=Rv0+1;
          PAS__SELECT_INP(((V *)Rv1)[3]);
          PAS__READ_BIN((((S *)Rv2)+Rv0*8));
        }
        ((SL *)Rv1)[4]=((SL *)Rv1)[4]+1;
      }
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " vrf_write "  */
void PAS__VRF_WRITE(V F_vrf, V *F_obj){

  /* Code of procedure/function */
}


/* Procedure/Function : " vrf_read "  */
void PAS__VRF_READ(V F_vrf, V *F_obj){

  /* Code of procedure/function */
}


/* Procedure/Function : " vrf_close "  */
void PAS__VRF_CLOSE(V *F_vrf, UL F_idisp){
  /* Define the automatic variable space. */
  Blk( Ra, 544 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s+70;
  Ra.v[67]=Rd.s+9;
  Ra.sl[68]=139; /* line # 139 */
  Rv0=NULL;
  Rv1=Ri.v[0];
  while (Rv1!=NULL&&Rv1!=(*F_vrf)){
    Rv0=Rv1;
    Rv1=((V *)Rv1)[0];
  }
  Ra.sl[68]=144; /* line # 144 */
  if (Rv1!=NULL) {
    Rv2=Rv1;
    if (2&((UL *)Rv2)[1]) PAS__VRF_PUT(Rv1);
    Ra.sl[68]=150; /* line # 150 */
    if (Rv0==NULL) Ri.v[0]=((V *)Rv2)[0];
    else((V *)Rv0)[0]=((V *)Rv2)[0];
    PAS__DISPOSE(((V *)Rv2)+8);
    PAS__STR_TO_STR(Ra.s,PAS__FILE_SPC(Ra.s+276,((V *)Rv2)[3]));
    PAS__CLOSE(((V *)Rv2)+3,F_idisp);
    Ra.sl[68]=157; /* line # 157 */
    PAS__OPEN(((V *)Rv2)+3,8, Ra.s,4106,0,-1);
    if (PAS__iostatus!=0) PAS__ERROR(326);
    Ra.sl[134]=((SL *)Rv2)[4];
    Ra.sl[135]=((SL *)Rv2)[7];
    PAS__SEEK(((V *)Rv2)[3],2);
    Ra.sl[68]=162; /* line # 162 */
    PAS__SELECT_OUT(((V *)Rv2)[3]);
    PAS__WRITE_BIN(Ra.s+536);
    PAS__CLOSE(((V *)Rv2)+3,0);
    PAS__DISPOSE(&Rv1);
    (*F_vrf)=NULL;
  }
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " vrf_open "  */
V PAS__VRF_OPEN(V *F_vrf, V F_fname, UL F_imod, SL F_mxrlen, SL F_iprot){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register SL Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+81;
  Ra.v[2]=Rd.s+9;
  Ra.sl[3]=184; /* line # 184 */
  if ((*F_vrf)!=NULL) PAS__VRF_CLOSE(F_vrf,0);
  if (((F_imod&3)==3||(F_imod&5)==5)||8&F_imod) {
    Ra.sl[3]=190; /* line # 190 */
    if (!(4096&F_imod)) PAS__ERROR(321);
    Ret=;
    goto Ret_Label;
  }
  if (F_mxrlen<=0) F_mxrlen=512;
  else {
    Ra.sl[3]=195; /* line # 195 */
    if (F_mxrlen<64) F_mxrlen=64;
  }
  Ra.sl[4]=0;
  Ra.sl[5]=0;
  Ra.sl[3]=200; /* line # 200 */
  (*F_vrf)=PAS__NEW(36);
  Rv0=(*F_vrf);
  ((V *)Rv0)[0]=NULL;
  ((UL *)Rv0)[1]=F_imod;
  Ra.sl[3]=205; /* line # 205 */
  ((UB *)Rv0)[8]=0;
  ((SL *)Rv0)[4]=0;
  ((SL *)Rv0)[5]=0;
  ((SL *)Rv0)[6]=0;
  ((SL *)Rv0)[7]=0;
  Ra.sl[3]=211; /* line # 211 */
  if ((F_imod&5)!=0) {
    PAS__OPEN(((V *)Rv0)+3,8, F_fname,4097, F_mxrlen, F_iprot);
    if (PAS__iostatus==0) {
      Ra.sl[3]=216; /* line # 216 */
      PAS__SELECT_INP(((V *)Rv0)[3]);
      PAS__READ_BIN(Ra.s+24);
      PAS__READ_BIN(Ra.s+16);
      if (PAS__NE_CHT(Ra.s+24,8, Rd.s+93,8)) PAS__iostatus=322;
      else {
        Ra.sl[3]=221; /* line # 221 */
        ((SL *)Rv0)[5]=Ra.sl[4];
        ((SL *)Rv0)[7]=Ra.sl[5];
        if (4&F_imod||F_mxrlen<Ra.sl[5]) {
          PAS__CLOSE(((V *)Rv0)+3,0);
          Ra.sl[3]=226; /* line # 226 */
          F_mxrlen=Ra.sl[5];
          PAS__OPEN(((V *)Rv0)+3,8, F_fname,F_imod|4096, F_mxrlen, F_iprot);
          if (1&F_imod) {
            PAS__SELECT_INP(((V *)Rv0)[3]);
            PAS__READ_BIN(Ra.s+24);
            PAS__READ_BIN(Ra.s+16);
          }
          else((SL *)Rv0)[4]=((SL *)Rv0)[5];
        }
      }
    }
    else {
      Ra.sl[3]=234; /* line # 234 */
      if (4&F_imod&&PAS__iostatus==202) PAS__OPEN(((V *)Rv0)+3,8, F_fname,4098, F_mxrlen,
      F_iprot);
    }
  }
  else PAS__OPEN(((V *)Rv0)+3,8, F_fname,4098, F_mxrlen, F_iprot);
  Ra.sl[3]=240; /* line # 240 */
  if (PAS__iostatus==0) {
    Rv1=F_mxrlen;
    ((V *)Rv0)[8]=PAS__NEW(Rv1*8+8);
    ((SL *)((V *)Rv0)[8])[0]=Rv1;
    ((SL *)((V *)Rv0)[8])[1]=0;
    Ra.sl[3]=245; /* line # 245 */
    if (Ri.v[0]==NULL) Ri.v[0]=(*F_vrf);
    else((V *)Ri.v[1])[0]=(*F_vrf);
    Ri.v[1]=(*F_vrf);
    if (1&F_imod) PAS__VRF_GET((*F_vrf));
    Ret=((V *)Rv0)[8];
  }
  else {
    Ra.sl[3]=253; /* line # 253 */
    PAS__DISPOSE(F_vrf);
    if (!(4096&F_imod)) PAS__ERROR(PAS__iostatus);
    Ret=NULL;
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
