{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*          MXD   Expression  and  Object Tree  Computing  Module              *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_TREE_WORK;


  %include 'MXDSRC:mxd_tree_env';       { Get all tree definitions }


const
  pi_s2         =               pi/2.0;
  epsilon       =              1.0e-12;

  feval_maxstp  =                 4096; { Size of the FO_VALUE/FO_DERIV LSQ_PARM stack for trap message }


var
  feval_stp:             unsigned := 0; { Stack pointer for FO_VALUE/FO_DERIV trap on ERROR }

  feval_stk: array[1..feval_maxstp] of ptr;     { Stack for FO_VALUE/FO_DERIV trap on ERROR }





[global]
procedure UPDATE_VIRTVAR( var obj: array[sz: integer] of tbty_vder; vcd: virt_codety );
var
  p: ptr;

begin
  for i := 1 to sz do
  begin
    p := virtvtab[virt_pha$dvol];
    if p <> nil then p^.nod_curval := obj[i,0];
    vcd := SUCC( vcd )
  end
end UPDATE_VIRTVAR;




function  FO_INTEGR( tb: ^val_afl; var uu: mxd_flt; expr: ptr ): mxd_flt;
var
  ip, nn:      integer;
  we, re:      mxd_flt;

begin
  if tb <> nil then
  with tb^ do
  begin
    nn := val_all;
    ip :=   0;
    re := 0.0;
    while ip < nn do
    begin
      ip := ip + 1; we := val_ftb[ip];
      ip := ip + 1; uu := val_ftb[ip];
      re := re + we*FO_VALUE( expr )
    end
  end;
  FO_INTEGR := re
end FO_INTEGR;



function  FD_INTEGR( var tb: ^val_afl; var uu: mxd_flt; expr, q: ptr ): mxd_flt;
var
  ip, nn:      integer;
  we, re:      mxd_flt;

begin
  if tb <> nil then
  with tb^ do
  begin
    nn := val_all;
    ip :=   0;
    re := 0.0;
    while ip < nn do
    begin
      ip := ip + 1; we := val_ftb[ip];
      ip := ip + 1; uu := val_ftb[ip];
      re := re + we*FO_DERIV( expr, q )
    end
  end;
  FD_INTEGR := re
end FD_INTEGR;



procedure FO_INTERPOL( var tb: val_afl; xf: mxd_flt; var r, d: mxd_flt );
var
  c1, c2, c3, r1, r2,
  x1, x2, x3, x4, y1, y2, y3, y4, re:  mxd_flt;
  ip, n, ns:                           integer;

begin
  with tb do
  begin
    n  := val_all;
    if n >= 8 then
    begin
      x1 := val_ftb[1]; y1 := val_ftb[2];
      x2 := val_ftb[3]; y2 := val_ftb[4];
      x3 := val_ftb[5]; y3 := val_ftb[6];
      x4 := val_ftb[7]; y4 := val_ftb[8];
      ip := 8;
      while (ip <= n) and (xf > x3) do
      begin
        x1 := x2; y1 := y2; x2 := x3; y2 := y3; x3 := x4; y3 := y4;
        x4 := val_ftb[ip];   ip := ip + 1;
        y4 := val_ftb[ip];   ip := ip + 1
      end;
      { Four points interpolation }
      r1 := (y1 - y2)/(x1 - x2);
      r2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
      c3 := (r2 - (r1 - (y1 - y4)/(x1 - x4))/(x2 - x4))/(x3 - x4);
      c2 := r2 - (x1 + x2 + x3)*c3;
      c1 := r1 - (x1 + x2)*c2 - (x1*x1 + x1*x2 + x2*x2)*c3;
      r := y1 - x1*(c1 + x1*(c2 + x1*c3)) + xf*(c1 + xf*(c2 + xf*c3));
      d := c1 + xf*(2*c2 + 3*xf*c3)
    end
    else
    case n div 2 of
      3: begin { Parabolic Form }
           x1 := val_ftb[1]; y1 := val_ftb[2];
           x2 := val_ftb[3]; y2 := val_ftb[4];
           x3 := val_ftb[5]; y3 := val_ftb[6];
           r1 := (y1 - y2)/(x1 - x2);
           c2 := (r1 - (y1 - y3)/(x1 - x3))/(x2 - x3);
           c1 := r1 - (x1 + x2)*c2;
           r := y1 - x1*(c1 + x1*c2) + xf*(c1 + xf*c2);
           d := c1 + 2*xf*c2
         end;

      2: begin { Linear Form }
           x1 := val_ftb[1]; y1 := val_ftb[2];
           c1 := (y1 - val_ftb[4])/(x1 - val_ftb[3]);
           r := y1 + c1*(xf - x1);
           d := c1
         end;

      1: begin  r := val_ftb[2]; d := 0.0  end;

    otherwise
      r := 0.0; d := 0.0
    end
  end
end FO_INTERPOL;



function  SUM_LOOP( pn, pv: ptr ): mxd_flt;
var
  indl, endl, stpl, inds, vl: mxd_flt;

begin
  with pn^ do
  begin
    indl := FO_VALUE( nod_smlb );
    endl := FO_VALUE( nod_smle );
    stpl := FO_VALUE( nod_smls );
    inds := nod_smidx^.ind_val; { Save index for future recursive mode ? }
    vl := 0.0;
    while ((stpl > 0) and (indl <= endl)) or
          ((stpl < 0) and (indl >= endl)) do
    begin
      nod_smidx^.ind_val := indl;
      if pv = nil then vl := vl + FO_VALUE( nod_exp )
                  else vl := vl + FO_DERIV( nod_exp, pv );
      indl := indl + stpl
    end;
    nod_smidx^.ind_val := inds { Restore for future recursive mode ? }
  end;
  SUM_LOOP := vl
end SUM_LOOP;



function  USER_FNC_CALL( pn, pv: ptr; bf: boolean ): mxd_flt;
var
  i, narg:     integer;
  p1, p2:          ptr;
  svfotab: array[0..frmarg_max] of ptr; { Table to save all formal argument link }

begin
  with pn^ do
  begin
    narg := nod_arglist^.size;          { Get the argument list size }
    p1   := nod_arglist^[narg];         { Get function definition block address }
    if bf then p1 := p1^.for_link;      { When it is a formal function call, we follow the formal link }
    p2 := p1^.frm_list;                 { Get the formal list head pointer }
    i  := 0;                            { Start from first parameter }
    while p2 <> nil do                  { Loop on for all function arguments }
    begin { Each parameter is assigned to the corresponding formal }
      svfotab[i] := p2^.for_link;       { Save any previous link for possible recusivity }
      if i < narg then p2^.for_link := nod_arglist^[i]  { Establish for new formal link when the effective argument ... }
                  else p2^.for_link := nil;             { ... is specified, else assume nul effective argument }
      i := i + 1; p2 := p2^.for_next    { Step to next formal argument }
    end;
    if pv = nil then USER_FNC_CALL := FO_VALUE( p1^.frm_exprv )         { Compute the function value ... }
                else USER_FNC_CALL := FO_DERIV( p1^.frm_exprv, pv );    { ... or its derivate }
    i := 0; p2 := p1^.frm_list;         { Restore the original formal argument list (for possible recusivity) }
    while p2 <> nil do
      p2^.for_link := svfotab[i]; i := i + 1; p2 := p2^.for_next
  end
end USER_FNC_CALL;



[global]
function  FO_VALUE( p: ptr ): mxd_flt;
var
  r:           mxd_flt;
  i, j:        integer;

begin
  feval_stp := SUCC( feval_stp );
  if feval_stp <= feval_maxstp then feval_stk[feval_stp] := p; { Save the Tree level when possible }

  if p = nil then FO_VALUE := 0.0
  else
  with p^ do
  case nod_typ of
    op_eq,     op_ne,     op_lt,
    op_le,     op_ge,     op_gt:
              begin
                r := FO_VALUE( nod_bin1 ) - FO_VALUE( nod_bin2 );
                case nod_typ of
                  op_eq: FO_VALUE := ORD( r =  0.0 );
                  op_ne: FO_VALUE := ORD( r <> 0.0 );
                  op_lt: FO_VALUE := ORD( r <  0.0 );
                  op_le: FO_VALUE := ORD( r <= 0.0 );
                  op_ge: FO_VALUE := ORD( r >= 0.0 );
                  op_gt: FO_VALUE := ORD( r >  0.0 )
                end
              end;
    op_and:   FO_VALUE := ORD( (FO_VALUE( nod_bin1 ) >= 0.5) and (FO_VALUE( nod_bin2 ) >= 0.5) );
    op_xor:   FO_VALUE := ORD( (FO_VALUE( nod_bin1 ) >= 0.5) xor (FO_VALUE( nod_bin2 ) >= 0.5) );
    op_or:    FO_VALUE := ORD( (FO_VALUE( nod_bin1 ) >= 0.5) or  (FO_VALUE( nod_bin2 ) >= 0.5) );
    op_add:   FO_VALUE := FO_VALUE( nod_bin1 ) + FO_VALUE( nod_bin2 );
    op_sub:   FO_VALUE := FO_VALUE( nod_bin1 ) - FO_VALUE( nod_bin2 );
    op_mod:   FO_VALUE := ROUND( FO_VALUE( nod_bin1 ) ) mod ROUND( FO_VALUE( nod_bin2 ) );
    op_rem:   FO_VALUE := ROUND( FO_VALUE( nod_bin1 ) ) rem ROUND( FO_VALUE( nod_bin2 ) );

    op_mul:   begin
                nod_vbin1 := FO_VALUE( nod_bind1 ); nod_vbin2 := FO_VALUE( nod_bind2 );
                FO_VALUE := nod_vbin1*nod_vbin2
              end;
    op_div:   begin
                nod_vbin1 := FO_VALUE( nod_bind1 ); nod_vbin2 := FO_VALUE( nod_bind2 );
                FO_VALUE := nod_vbin1/nod_vbin2
              end;
    op_pow:   begin
                nod_vbin1 := FO_VALUE( nod_bind1 ); nod_vbin2 := FO_VALUE( nod_bind2 );
                FO_VALUE := EXP( nod_vbin2*LN( nod_vbin1 ) )
              end;
    op_phaser:begin
                nod_vbin1 := FO_VALUE( nod_bind1 ); nod_vbin2 := FO_VALUE( nod_bind2 );
                FO_VALUE := ARCTAN( nod_vbin1, nod_vbin2 )
              end;
    op_phased:begin
                nod_vbin1 := FO_VALUE( nod_bind1 ); nod_vbin2 := FO_VALUE( nod_bind2 );
                FO_VALUE := ARCTAN( nod_vbin1, nod_vbin2 )/in_rd
              end;

    op_not:   if FO_VALUE( nod_una ) < 0.5 then FO_VALUE := 1.0
                                           else FO_VALUE := 0.0;
    op_neg:   FO_VALUE := - FO_VALUE( nod_una );

    op_trunc: FO_VALUE := TRUNC( FO_VALUE( nod_unad ) );
    op_round: FO_VALUE := ROUND( FO_VALUE( nod_unad ) );

    op_sinr:  begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := SIN( nod_vuna )  end;
    op_cosr:  begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := COS( nod_vuna )  end;
    op_tanr:  begin
                nod_vuna := FO_VALUE( nod_unad );
                r := SIN( nod_vuna );
                FO_VALUE := r/SQRT( 1.0 - SQR( r ))
              end;
    op_asinr: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := ARCSIN( nod_vuna )  end;
    op_acosr: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := pi_s2 - ARCSIN( nod_vuna )  end;
    op_atanr: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := ARCTAN( nod_vuna )  end;
    op_sind:  begin  nod_vuna := in_rd*FO_VALUE( nod_unad ); FO_VALUE := SIN( nod_vuna )  end;
    op_cosd:  begin  nod_vuna := in_rd*FO_VALUE( nod_unad ); FO_VALUE := COS( nod_vuna )  end;
    op_tand:  begin
                nod_vuna := in_rd*FO_VALUE( nod_unad );
                r := SIN( nod_vuna );
                FO_VALUE := r/SQRT( 1.0 - SQR( r ))
              end;
    op_asind: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := ARCSIN( nod_vuna )/in_rd  end;
    op_acosd: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := 90.0 - ARCSIN( nod_vuna )/in_rd  end;
    op_atand: begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := ARCTAN( nod_vuna )/in_rd  end;
    op_exp:   begin  nod_vuna := EXP( FO_VALUE( nod_unad ) ); FO_VALUE := nod_vuna  end;
    op_ln:    begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := LN( nod_vuna )  end;
    op_tanh:  begin  nod_vuna := TANH( FO_VALUE( nod_unad ) ); FO_VALUE := nod_vuna  end;
    op_abs:   begin  nod_vuna := FO_VALUE( nod_unad ); FO_VALUE := ABS( nod_vuna )  end;
    op_sqrt:  begin  nod_vuna := SQRT( FO_VALUE( nod_unad ) ); FO_VALUE := nod_vuna  end;

    op_ipw:   begin
                nod_ipw := ROUND( FO_VALUE( nod_iwe ) ); nod_vpw := FO_VALUE( nod_iwo );
                FO_VALUE := nod_vpw**nod_ipw
              end;

    op_bessj: begin
                nod_bij_n := ROUND( 2.0*FO_VALUE( nod_bij_ne ) );
                if ODD( nod_bij_n ) then MATH_BESSEL_JHDER( nod_bij_d, r, FO_VALUE( nod_bij_xe ), nod_bij_n div 2 )
                                    else MATH_BESSEL_JDER( nod_bij_d, r, FO_VALUE( nod_bij_xe ), nod_bij_n );
                FO_VALUE := r
              end;

    op_interpol:
              if nod_itpfco > 0 then
              begin { Get the interpolation result in the current data record }

              end
              else
              begin { Perform an interpolation }
                nod_itpval := FO_VALUE( nod_itpexp );
                if nod_itptab <> nil then FO_INTERPOL( nod_itptab^, nod_itpval, r, nod_itpder );
                FO_VALUE := r
              end;

    op_integr:
              FO_VALUE := FO_INTEGR( nod_inttab, nod_intvar^.ind_val, nod_intexpr );

    op_summ:  FO_VALUE := SUM_LOOP( p, nil );

    op_sumobs:
              FO_VALUE := nod_osmv;

    op_ifsel: begin
                nod_icnd := FO_VALUE( nod_cond );
                if nod_icnd > 0 then FO_VALUE := FO_VALUE( nod_wtrue )
                                else FO_VALUE := FO_VALUE( nod_wfalse )
              end;

    op_funcall, op_formcall:
              FO_VALUE := USER_FNC_CALL( p, nil, nod_typ = op_formcall );

    op_formal:
              FO_VALUE := FO_VALUE( for_link );

    op_select:begin
                nod_selast := FO_VALUE( nod_seltab^[0] ) + 1;
                if (nod_selast > 0) and (nod_selast <= nod_seltab^.size) then
                  FO_VALUE := FO_VALUE( nod_seltab^[nod_selast] )
                else
                begin  nod_selast := 0; FO_VALUE := 0.0  end
              end;

    op_konst: FO_VALUE := nod_val;

    op_coeff: with curr_data do
              case nod_coeffid of
                coef_h:         FO_VALUE := ih;
                coef_k:         FO_VALUE := ik;
                coef_l:         FO_VALUE := il;
                coef_rh:        FO_VALUE := he;
                coef_rk:        FO_VALUE := ke;
                coef_rl:        FO_VALUE := le;
                coef_hh:        FO_VALUE := hh;
                coef_kk:        FO_VALUE := kk;
                coef_ll:        FO_VALUE := ll;
                coef_sithsl:    FO_VALUE := sithsl;
                coef_sh:        FO_VALUE := sh;
                coef_sk:        FO_VALUE := sk;
                coef_sl:        FO_VALUE := sl;
(*
                coef_qx:
                coef_qy:
                coef_qz:

                coef_hx:
                coef_hy:
                coef_hz:

                coef_fnr:
                coef_fni:
                coef_fmxr:
                coef_fmyr:
                coef_fmzr:
                coef_fmxi:
                coef_fmyi:
                coef_fmzi:

                coef_npola:
*)
                coef_obs:       FO_VALUE := obs;
                coef_sig:       FO_VALUE := sig;
                coef_weight:    FO_VALUE := wei;
(*
                coef_y_x:
                coef_y_obs:
                coef_y_sg:
                coef_y_weight:

                coef_lchi2:
                coef_cchi2:
                coef_lmaxf:
                coef_cmaxf:

                coef_calc:
                coef_fn2:
                coef_fm2:
*)

              otherwise
                FO_VALUE := 0.0
              end;

    op_adatfl: { Additional data record field reference }
              if nod_datoff < 0 then FO_VALUE := 0.0
                                else FO_VALUE := curr_data.tbv[nod_datoff];

    op_index: FO_VALUE := ind_val;

    op_virtvar:
              FO_VALUE := nod_curval;

    op_varbl: FO_VALUE := var_curval;

    op_parm:  FO_VALUE := par_actval;

  otherwise
    FO_VALUE := 0.0
  end;
  feval_stp := PRED( feval_stp )
end FO_VALUE;



function DER_VAL( p, q: ptr ): mxd_flt;
var
  r: mxd_flt;
  d: der_ptr;

begin
  if p = nil then r := 0.0
  else
  begin
    r := 0.0;
    d := p^.par_lstder;
    while d <> nil do
      if d^.der_var = q then begin  r := d^.der_val; d := nil  end
                        else d := d^.der_next
  end;
  DER_VAL := r
end DER_VAL;



[global]
function  FO_DERIV( p, q: ptr ): mxd_flt;
var
  r: mxd_flt;
  d: der_ptr;

begin
  feval_stp := SUCC( feval_stp );
  if feval_stp <= feval_maxstp then feval_stk[feval_stp] := p; { Save the Tree level when possible }

  if p = nil then FO_DERIV := 0.0
  else
  if p = q then FO_DERIV := 1.0
  else
  with p^ do
  case nod_typ of
    op_add:   FO_DERIV := FO_DERIV( nod_bin1, q ) + FO_DERIV( nod_bin2, q );
    op_sub:   FO_DERIV := FO_DERIV( nod_bin1, q ) - FO_DERIV( nod_bin2, q );

    op_mul:   FO_DERIV := FO_DERIV( nod_bind1, q )*nod_vbin2 + nod_vbin1*FO_DERIV( nod_bind2, q );
    op_div:   FO_DERIV := (FO_DERIV( nod_bind1, q )*nod_vbin2 - nod_vbin1*FO_DERIV( nod_bind2, q ))/SQR( nod_vbin2 );
    op_pow:   begin
                r := LN( nod_vbin1 );
                FO_DERIV := EXP( r*nod_vbin2 )*(FO_DERIV( nod_bind2, q )*r + nod_vbin2*FO_DERIV( nod_bind1, q )/nod_vbin1)
              end;
    op_phaser,
    op_phased:begin
                r := SQR( nod_vbin1 ) + SQR( nod_vbin2 );
                if r <= epsilon then FO_DERIV := 0.0 else
                begin
                  r := (FO_DERIV( nod_bind1, q )*nod_vbin2 - nod_vbin1*FO_DERIV( nod_bind2, q ))/r;
                  if nod_typ = op_phaser then FO_DERIV := r
                                         else FO_DERIV := r/in_rd
                end
              end;

    op_neg:   FO_DERIV := - FO_DERIV( nod_una, q );

    op_sinr:  FO_DERIV :=  FO_DERIV( nod_unad, q )*COS( nod_vuna );
    op_cosr:  FO_DERIV := -FO_DERIV( nod_unad, q )*SIN( nod_vuna );
    op_tanr:  FO_DERIV :=  FO_DERIV( nod_unad, q )/SQR( COS( nod_vuna ) );
    op_asinr: FO_DERIV :=  FO_DERIV( nod_unad, q )/SQRT( 1.0 - SQR( nod_vuna ) );
    op_acosr: FO_DERIV := -FO_DERIV( nod_unad, q )/SQRT( 1.0 - SQR( nod_vuna ) );
    op_atanr: FO_DERIV :=  FO_DERIV( nod_unad, q )/(1.0 + SQR( nod_vuna ));
    op_sind:  FO_DERIV :=  FO_DERIV( nod_unad, q )*COS( nod_vuna )*in_rd;
    op_cosd:  FO_DERIV := -FO_DERIV( nod_unad, q )*SIN( nod_vuna )*in_rd;
    op_tand:  FO_DERIV :=  FO_DERIV( nod_unad, q )*in_rd/SQR( COS( nod_vuna ) );
    op_asind: FO_DERIV :=  FO_DERIV( nod_unad, q )/(SQRT( 1.0 - SQR( nod_vuna ) )*in_rd);
    op_acosd: FO_DERIV := -FO_DERIV( nod_unad, q )/(SQRT( 1.0 - SQR( nod_vuna ) )*in_rd);
    op_atand: FO_DERIV :=  FO_DERIV( nod_unad, q )/((1.0 - SQR( nod_vuna ))*in_rd);
    op_exp:   FO_DERIV :=  FO_DERIV( nod_unad, q )*nod_vuna;
    op_ln:    FO_DERIV :=  FO_DERIV( nod_unad, q )/nod_vuna;
    op_tanh:  FO_DERIV :=  FO_DERIV( nod_unad, q )*(1.0 - SQR( nod_vuna ));
    op_abs:   if nod_vuna = 0.0 then FO_DERIV :=  0.0
                                else if nod_vuna > 0.0 then FO_DERIV :=  FO_DERIV( nod_unad, q )
                                                       else FO_DERIV := -FO_DERIV( nod_unad, q );
    op_sqrt:  FO_DERIV :=  FO_DERIV( nod_una, q )/(2.0*nod_vuna);

    op_ipw:   FO_DERIV :=  nod_ipw*(nod_vpw**(nod_ipw-1))*FO_DERIV( nod_iwo, q );

    op_bessj: FO_DERIV :=  FO_DERIV( nod_bij_xe, q )*nod_bij_d;

    op_interpol:
              FO_DERIV :=  FO_DERIV( nod_itpexp, q )*nod_itpder;

    op_integr:
              FO_DERIV :=  FD_INTEGR( nod_inttab, nod_intvar^.ind_val, nod_intexpr, q );

    op_summ:  FO_DERIV :=  SUM_LOOP( p, q );

    op_ifsel: if nod_icnd > 0 then FO_DERIV := FO_DERIV( nod_wtrue, q )
                              else FO_DERIV := FO_DERIV( nod_wfalse, q );

    op_funcall, op_formcall:
              FO_DERIV := USER_FNC_CALL( p, q, nod_typ = op_formcall );

    op_formal:
              FO_DERIV := FO_DERIV( for_link, q );

    op_select:
              if nod_selast > 0 then FO_DERIV := FO_DERIV( nod_seltab^[nod_selast], q )
                                else FO_DERIV := 0.0;

    op_coeff: case nod_coeffid of

                coef_rh: FO_DERIV := 0.0;

(*
                coef_rh:
                coef_rk:
                coef_rl:
                coef_hh:
                coef_kk:
                coef_ll:
                coef_sithsl:
                coef_sh:
                coef_sk:
                coef_sl:
                coef_qx:
                coef_qy:
                coef_qz:
                coef_fnr:
                coef_fni:
                coef_fmxr:
                coef_fmyr:
                coef_fmzr:
                coef_fmxi:
                coef_fmyi:
                coef_fmzi:

                coef_npola:

                coef_calc:
                coef_fn2:
                coef_fm2:
*)


              otherwise
                FO_DERIV := 0.0
              end;

    op_adatfl:begin
                FO_DERIV := 0.0
              end;

    op_virtvar,
    op_varbl: if p = q then FO_DERIV := 1.0
                       else FO_DERIV := 0.0;

    op_parm:  FO_DERIV := DER_VAL( p, q );


  otherwise
    FO_DERIV := 0.0
  end;
  feval_stp := PRED( feval_stp )
end FO_DERIV;



[global]
procedure PARM_EVAL( ctg: prmc_categ );
{ Evaluate all parameters in a given category id, and all associated
   derivates, if id = -1 then the whole of parameter values is computed }
var
  pp:      ptr;
  p0:  der_ptr;

begin
  if ctg = prmc_allparm then pp := parhde
                        else pp := pardhde[ctg];
  while pp <> nil do
  begin
    cparam    :=  pp;
    with pp^ do
    begin
      par_actval := FO_VALUE( par_expres );
      p0 := par_lstder;
      while p0 <> nil do
      begin
        p0^.der_val := FO_DERIV( par_expres, p0^.der_var );
        p0 := p0^.der_next
      end
    end;
    if ctg = prmc_allparm then pp := pp^.itm_next
                          else pp := pp^.par_catlnk
  end;
  cparam := nil
end PARM_EVAL;



procedure CLRSUMHKL;
var
  pp: ptr;

begin
  pp := sumhhde;
  while pp <> nil do                    { Clear all sumhkl nodes }
  begin
    pp^.nod_osmv := 0.0;
    pp := pp^.nod_osmlnk
  end
end CLRSUMHKL;



procedure MAKESUMHKL;
var
  pp: ptr;

begin
  pp := sumhhde;
  while pp <> nil do
  with pp^ do
  begin
    nod_osmv := nod_osmv + FO_VALUE( nod_osmexp );
    pp := nod_osmlnk
  end
end MAKESUMHKL;



[global]
procedure COMPUTE_EXP_DERV( var exp: array[lw..up: integer] of mxd_flt; { The table of value and derivate for exp }
                            var pat: array[np: integer] of ptr;         { The table of related LSQ_PARM }
                            var vdr: array[sz: integer] of mxd_flt );   { The resulting derivative vector }
var
  pd:  der_ptr;
  vi:  integer;

begin
  for i := 1 to np do                   { Loop on all LSQ_PARM (pa_i parameter) used in the expression }
  begin
    pd := pat[i]^.par_lstder;           { Get the LSQ_PARM derivative list }
    while pd <> nil do                  { Loop one all LSQ_VAR (va_j variable) referenced in the LSQ_PARM }
    begin
      with pd^, der_var^ do
        if nod_typ = op_virtvar then    { For virtual Variable reference }
          case nod_vvsequ of
            virt_dat$calc: ;
            virt_dat$fn2: ;
            virt_dat$fm2: ;
            virt_dat$f2pola: ;

            virt_pha$scale: ;
            virt_pha$daa..virt_pha$dga: ;
            virt_pha$dvol: ;
            virt_pha$raa..virt_pha$rga: ;
            virt_pha$rvol: ;
            virt_pha$dtaa..virt_pha$dtab: ;
            virt_pha$rtaa..virt_pha$rtab: ;
            virt_pha$dm11..virt_pha$dm33: ;
            virt_pha$rm11..virt_pha$rm33: ;
            virt_grp$m11..virt_grp$tz: ;
            virt_gre$m11..virt_gre$tz: ;

          otherwise
          end
        else
        begin                           { For LSQ_VAR reference }
          vi := var_matidx;             { Get the current LSQ_VAR imatrix index }
          vdr[vi] := vdr[vi] + exp[i]*der_val   { Build the summ on j of d(exp)/d(pa_i)*d(pa_i)/d(va_j) }
        end;
      pd := pd^.der_next                { Continue to the LSQ_VAR }
    end
  end
end COMPUTE_EXP_DERV;





end MXD_TREE_WORK.
