/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 216 ) = {
 14,  14, 117, 112, 100,  97, 116, 101,  95, 118, 105, 114, 116, 118,  97, 114,
 55,  55,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,
 83, 111, 102, 116,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,
 88,  68,  86,  52,  95, 115, 114,  99,  47, 109, 120, 100,  95, 116, 114, 101,
101,  95, 119, 114, 107,  46, 112,  97, 115,   9,   9, 102, 111,  95, 105, 110,
116, 101, 103, 114,   9,   9, 102, 100,  95, 105, 110, 116, 101, 103, 114,  11,
 11, 102, 111,  95, 105, 110, 116, 101, 114, 112, 111, 108,   8,   8, 115, 117,
109,  95, 108, 111, 111, 112,  13,  13, 117, 115, 101, 114,  95, 102, 110,  99,
 95,  99,  97, 108, 108,   8,   8, 102, 111,  95, 118,  97, 108, 117, 101,   7,
  7, 100, 101, 114,  95, 118,  97, 108,   8,   8, 102, 111,  95, 100, 101, 114,
105, 118,   9,   9, 112,  97, 114, 109,  95, 101, 118,  97, 108,   9,   9,  99,
108, 114, 115, 117, 109, 104, 107, 108,  10,  10, 109,  97, 107, 101, 115, 117,
109, 104, 107, 108,  16,  16,  99, 111, 109, 112, 117, 116, 101,  95, 101, 120,
112,  95, 100, 101, 114, 118,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 8 ) = {
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 16384 );

/* Declaration of external variables. */
extern Blk(V_virtvtab, 296 );
extern Blk(V_curr_data, 2192 );
extern V V_parhde;
extern Blk(V_pardhde, 56 );
extern V V_cparam;
extern V V_sumhhde;


/* Function/procedure prototypes. */
void P_math_bessel_jder(G *F_dbjn, G *F_bjn, G F_x, SL F_n);
G P_math_bessel_jhder(G *F_dbjn, G *F_bjn, G F_x, SL F_nm2);
G P_fo_value(V F_p);
G P_fo_deriv(V F_p, V F_q);


/* Procedure/Function : " update_virtvar "  */
void P_update_virtvar(V F_obj, SL F_sz, UB F_vcd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=123; /* line # 123 */
  Rv0=1;
  for( Rf0=F_sz;Rf0>0;Rf0-- ) {
    Ra.sl[3]=125; /* line # 125 */
    Rv1=V_virtvtab.v[12];
    Ra.sl[3]=126; /* line # 126 */
    if (Rv1!=NULL) ((G *)Rv1)[1]=((G *)F_obj)[Rv0*7-7];
    Ra.sl[3]=127; /* line # 127 */
    F_vcd=F_vcd+1;
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " fo_integr "  */
G MXD_TREWORK_fo_integr(V F_tb, G *F_uu, V F_expr){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  G Rv3;
  G Rv4;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+73;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=140; /* line # 140 */
  if (F_tb!=NULL) {
    Ra.sl[3]=141; /* line # 141 */
    Rv0=F_tb;
    Ra.sl[3]=143; /* line # 143 */
    Rv1=((SL *)Rv0)[0];
    Ra.sl[3]=144; /* line # 144 */
    Rv2=0;
    Ra.sl[3]=145; /* line # 145 */
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=146; /* line # 146 */
    while (Rv2<Rv1){
      Ra.sl[3]=148; /* line # 148 */
      Rv2=Rv2+1;
      Rv4=((G *)Rv0)[Rv2];
      Ra.sl[3]=149; /* line # 149 */
      Rv2=Rv2+1;
      (*F_uu)=((G *)Rv0)[Rv2];
      Ra.sl[3]=150; /* line # 150 */
      Rv3=Rv3+Rv4*P_fo_value(F_expr);
    }
  }
  Ra.sl[3]=153; /* line # 153 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fd_integr "  */
G MXD_TREWORK_fd_integr(V *F_tb, G *F_uu, V F_expr, V F_q){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  G Rv3;
  G Rv4;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+84;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=164; /* line # 164 */
  if ((*F_tb)!=NULL) {
    Ra.sl[3]=165; /* line # 165 */
    Rv0=(*F_tb);
    Ra.sl[3]=167; /* line # 167 */
    Rv1=((SL *)Rv0)[0];
    Ra.sl[3]=168; /* line # 168 */
    Rv2=0;
    Ra.sl[3]=169; /* line # 169 */
    Rv3=0.000000000000000E-001;
    Ra.sl[3]=170; /* line # 170 */
    while (Rv2<Rv1){
      Ra.sl[3]=172; /* line # 172 */
      Rv2=Rv2+1;
      Rv4=((G *)Rv0)[Rv2];
      Ra.sl[3]=173; /* line # 173 */
      Rv2=Rv2+1;
      (*F_uu)=((G *)Rv0)[Rv2];
      Ra.sl[3]=174; /* line # 174 */
      Rv3=Rv3+Rv4*P_fo_deriv(F_expr, F_q);
    }
  }
  Ra.sl[3]=177; /* line # 177 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fo_interpol "  */
void MXD_TREWORK_fo_interpol(V F_tb, G F_xf, G *F_r, G *F_d){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  G Rv1;
  G Rv2;
  G Rv3;
  G Rv4;
  G Rv5;
  G Rv6;
  G Rv7;
  G Rv8;
  SL Rv9;
  G Rv10;
  G Rv11;
  G Rv12;
  G Rv13;
  G Rv14;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+95;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=189; /* line # 189 */
  Ra.sl[3]=191; /* line # 191 */
  Rv0=((SL *)F_tb)[0];
  Ra.sl[3]=192; /* line # 192 */
  if (Rv0>=8) {
    Ra.sl[3]=194; /* line # 194 */
    Rv1=((G *)F_tb)[1];
    Rv2=((G *)F_tb)[2];
    Ra.sl[3]=195; /* line # 195 */
    Rv3=((G *)F_tb)[3];
    Rv4=((G *)F_tb)[4];
    Ra.sl[3]=196; /* line # 196 */
    Rv5=((G *)F_tb)[5];
    Rv6=((G *)F_tb)[6];
    Ra.sl[3]=197; /* line # 197 */
    Rv7=((G *)F_tb)[7];
    Rv8=((G *)F_tb)[8];
    Ra.sl[3]=198; /* line # 198 */
    Rv9=8;
    Ra.sl[3]=199; /* line # 199 */
    while (Rv9<=Rv0&&F_xf>Rv5){
      Ra.sl[3]=201; /* line # 201 */
      Rv1=Rv3;
      Rv2=Rv4;
      Rv3=Rv5;
      Rv4=Rv6;
      Rv5=Rv7;
      Rv6=Rv8;
      Ra.sl[3]=202; /* line # 202 */
      Rv7=((G *)F_tb)[Rv9];
      Rv9=Rv9+1;
      Ra.sl[3]=203; /* line # 203 */
      Rv8=((G *)F_tb)[Rv9];
      Rv9=Rv9+1;
    }
    Ra.sl[3]=206; /* line # 206 */
    Rv10=(Rv2-Rv4)/(Rv1-Rv3);
    Ra.sl[3]=207; /* line # 207 */
    Rv11=(Rv10-(Rv2-Rv6)/(Rv1-Rv5))/(Rv3-Rv5);
    Ra.sl[3]=208; /* line # 208 */
    Rv12=(Rv11-(Rv10-(Rv2-Rv8)/(Rv1-Rv7))/(Rv3-Rv7))/(Rv5-Rv7);
    Ra.sl[3]=209; /* line # 209 */
    Rv13=Rv11-((Rv1+Rv3)+Rv5)*Rv12;
    Ra.sl[3]=210; /* line # 210 */
    Rv14=(Rv10-(Rv1+Rv3)*Rv13)-((Rv1*Rv1+Rv1*Rv3)+Rv3*Rv3)*Rv12;
    Ra.sl[3]=211; /* line # 211 */
    (*F_r)=(Rv2-Rv1*(Rv14+Rv1*(Rv13+Rv1*Rv12)))+F_xf*(Rv14+F_xf*(Rv13+F_xf*Rv12)
    );
    Ra.sl[3]=212; /* line # 212 */
    (*F_d)=Rv14+F_xf*(2.000000000000000E+000*Rv13+(3.000000000000000E+000*F_xf)*
    Rv12);
  }
  else {
    Ra.sl[3]=215; /* line # 215 */
    switch (Rv0/2) {
      case 3:Ra.sl[3]=217; /* line # 217 */
      Rv1=((G *)F_tb)[1];
      Rv2=((G *)F_tb)[2];
      Ra.sl[3]=218; /* line # 218 */
      Rv3=((G *)F_tb)[3];
      Rv4=((G *)F_tb)[4];
      Ra.sl[3]=219; /* line # 219 */
      Rv5=((G *)F_tb)[5];
      Rv6=((G *)F_tb)[6];
      Ra.sl[3]=220; /* line # 220 */
      Rv10=(Rv2-Rv4)/(Rv1-Rv3);
      Ra.sl[3]=221; /* line # 221 */
      Rv13=(Rv10-(Rv2-Rv6)/(Rv1-Rv5))/(Rv3-Rv5);
      Ra.sl[3]=222; /* line # 222 */
      Rv14=Rv10-(Rv1+Rv3)*Rv13;
      Ra.sl[3]=223; /* line # 223 */
      (*F_r)=(Rv2-Rv1*(Rv14+Rv1*Rv13))+F_xf*(Rv14+F_xf*Rv13);
      Ra.sl[3]=224; /* line # 224 */
      (*F_d)=Rv14+(2.000000000000000E+000*F_xf)*Rv13;
      break;
      case 2:Ra.sl[3]=228; /* line # 228 */
      Rv1=((G *)F_tb)[1];
      Rv2=((G *)F_tb)[2];
      Ra.sl[3]=229; /* line # 229 */
      Rv14=(Rv2-((G *)F_tb)[4])/(Rv1-((G *)F_tb)[3]);
      Ra.sl[3]=230; /* line # 230 */
      (*F_r)=Rv2+Rv14*(F_xf-Rv1);
      Ra.sl[3]=231; /* line # 231 */
      (*F_d)=Rv14;
      break;
      case 1:Ra.sl[3]=234; /* line # 234 */
      (*F_r)=((G *)F_tb)[2];
      (*F_d)=0.000000000000000E-001;
      break;
      default:Ra.sl[3]=237; /* line # 237 */
      (*F_r)=0.000000000000000E-001;
      (*F_d)=0.000000000000000E-001;
      break;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " sum_loop "  */
G MXD_TREWORK_sum_loop(V F_pn, V F_pv){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  G Rv1;
  G Rv2;
  G Rv3;
  G Rv4;
  G Rv5;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+108;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=249; /* line # 249 */
  Rv0=F_pn;
  Ra.sl[3]=251; /* line # 251 */
  Rv1=P_fo_value(((V *)Rv0)[1]);
  Ra.sl[3]=252; /* line # 252 */
  Rv2=P_fo_value(((V *)Rv0)[2]);
  Ra.sl[3]=253; /* line # 253 */
  Rv3=P_fo_value(((V *)Rv0)[3]);
  Ra.sl[3]=254; /* line # 254 */
  Rv4=((G *)((V *)Rv0)[4])[3];
  Ra.sl[3]=255; /* line # 255 */
  Rv5=0.000000000000000E-001;
  Ra.sl[3]=256; /* line # 256 */
  while (Rv3>0.000000000000000E-001&&Rv1<=Rv2||Rv3<0.000000000000000E-001&&Rv1>=
  Rv2){
    Ra.sl[3]=259; /* line # 259 */
    ((G *)((V *)Rv0)[4])[3]=Rv1;
    Ra.sl[3]=260; /* line # 260 */
    if (F_pv==NULL) Rv5=Rv5+P_fo_value(((V *)Rv0)[5]);
    else {
      Ra.sl[3]=261; /* line # 261 */
      Rv5=Rv5+P_fo_deriv(((V *)Rv0)[5],F_pv);
    }
    Ra.sl[3]=262; /* line # 262 */
    Rv1=Rv1+Rv3;
  }
  Ra.sl[3]=264; /* line # 264 */
  ((G *)((V *)Rv0)[4])[3]=Rv4;
  Ra.sl[3]=266; /* line # 266 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_fnc_call "  */
G MXD_TREWORK_user_fnc_call(V F_pn, V F_pv, UB F_bf){
  /* Define the automatic variable space. */
  Blk( Ra, 152 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+118;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=278; /* line # 278 */
  Rv0=F_pn;
  Ra.sl[3]=280; /* line # 280 */
  Rv1=((SL *)((V *)Rv0)[1])[0];
  Ra.sl[3]=281; /* line # 281 */
  Rv2=((V *)((V *)Rv0)[1])[Rv1+1];
  Ra.sl[3]=282; /* line # 282 */
  if (F_bf) Rv2=((V *)Rv2)[7];
  Ra.sl[3]=283; /* line # 283 */
  Rv3=((V *)Rv2)[6];
  Ra.sl[3]=284; /* line # 284 */
  Rv4=0;
  Ra.sl[3]=285; /* line # 285 */
  while (Rv3!=NULL){
    Ra.sl[3]=287; /* line # 287 */
    Ra.v[Rv4+4]=((V *)Rv3)[7];
    Ra.sl[3]=288; /* line # 288 */
    if (Rv4<Rv1) ((V *)Rv3)[7]=((V *)((V *)Rv0)[1])[Rv4+1];
    else {
      Ra.sl[3]=289; /* line # 289 */
      ((V *)Rv3)[7]=NULL;
    }
    Ra.sl[3]=290; /* line # 290 */
    Rv4=Rv4+1;
    Rv3=((V *)Rv3)[6];
  }
  Ra.sl[3]=292; /* line # 292 */
  if (F_pv==NULL) Ret=P_fo_value(((V *)Rv2)[7]);
  else {
    Ra.sl[3]=293; /* line # 293 */
    Ret=P_fo_deriv(((V *)Rv2)[7],F_pv);
  }
  Ra.sl[3]=294; /* line # 294 */
  Rv4=0;
  Rv3=((V *)Rv2)[6];
  Ra.sl[3]=295; /* line # 295 */
  while (Rv3!=NULL){
    Ra.sl[3]=296; /* line # 296 */
    ((V *)Rv3)[7]=Ra.v[Rv4+4];
  }
  Rv4=Rv4+1;
  Rv3=((V *)Rv3)[6];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fo_value "  */
G P_fo_value(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  G Rv1;
  register int Rgi;
  register int Rgj;
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+133;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=309; /* line # 309 */
  Ri.ul[0]=Ri.ul[0]+1;
  Ra.sl[3]=310; /* line # 310 */
  if (Ri.ul[0]<=4096) Rs.v[Ri.ul[0]-1]=F_p;
  Ra.sl[3]=312; /* line # 312 */
  if (F_p==NULL) Ret=0.000000000000000E-001;
  else {
    Ra.sl[3]=314; /* line # 314 */
    Rv0=F_p;
    Ra.sl[3]=315; /* line # 315 */
    switch (((UB *)Rv0)[0]) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:Ra.sl[3]=319; /* line # 319 */
      Rv1=P_fo_value(((V *)Rv0)[1])-P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=320; /* line # 320 */
      switch (((UB *)Rv0)[0]) {
        case 0:Ra.sl[3]=321; /* line # 321 */
        Ret=(double)((SL)(Rv1==0.000000000000000E-001));
        break;
        case 1:Ra.sl[3]=322; /* line # 322 */
        Ret=(double)((SL)(Rv1!=0.000000000000000E-001));
        break;
        case 2:Ra.sl[3]=323; /* line # 323 */
        Ret=(double)((SL)(Rv1<0.000000000000000E-001));
        break;
        case 3:Ra.sl[3]=324; /* line # 324 */
        Ret=(double)((SL)(Rv1<=0.000000000000000E-001));
        break;
        case 4:Ra.sl[3]=325; /* line # 325 */
        Ret=(double)((SL)(Rv1>=0.000000000000000E-001));
        break;
        case 5:Ra.sl[3]=326; /* line # 326 */
        Ret=(double)((SL)(Rv1>0.000000000000000E-001));
        break;
      }
      break;
      case 6:Ra.sl[3]=329; /* line # 329 */
      Ret=(double)((SL)(P_fo_value(((V *)Rv0)[1])>=5.000000000000000E-001&&P_fo_value((
      (V *)Rv0)[2])>=5.000000000000000E-001));
      break;
      case 7:Ra.sl[3]=330; /* line # 330 */
      Ret=(double)((SL)(P_fo_value(((V *)Rv0)[1])>=5.000000000000000E-001^P_fo_value((
      (V *)Rv0)[2])>=5.000000000000000E-001));
      break;
      case 8:Ra.sl[3]=331; /* line # 331 */
      Ret=(double)((SL)(P_fo_value(((V *)Rv0)[1])>=5.000000000000000E-001||P_fo_value((
      (V *)Rv0)[2])>=5.000000000000000E-001));
      break;
      case 9:Ra.sl[3]=332; /* line # 332 */
      Ret=P_fo_value(((V *)Rv0)[1])+P_fo_value(((V *)Rv0)[2]);
      break;
      case 10:Ra.sl[3]=333; /* line # 333 */
      Ret=P_fo_value(((V *)Rv0)[1])-P_fo_value(((V *)Rv0)[2]);
      break;
      case 11:Ra.sl[3]=334; /* line # 334 */
      Ret=(double)PAS__I_MOD(PAS__G_ROUND(P_fo_value(((V *)Rv0)[1])),PAS__G_ROUND
      (P_fo_value(((V *)Rv0)[2])));
      break;
      case 12:Ra.sl[3]=335; /* line # 335 */
      Ret=(double)(PAS__G_ROUND(P_fo_value(((V *)Rv0)[1]))%PAS__G_ROUND(P_fo_value((
      (V *)Rv0)[2])));
      break;
      case 14:Ra.sl[3]=338; /* line # 338 */
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=339; /* line # 339 */
      Ret=((G *)Rv0)[2]*((G *)Rv0)[3];
      break;
      case 15:Ra.sl[3]=342; /* line # 342 */
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=343; /* line # 343 */
      Ret=((G *)Rv0)[2]/((G *)Rv0)[3];
      break;
      case 16:Ra.sl[3]=346; /* line # 346 */
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=347; /* line # 347 */
      Ret=exp(((G *)Rv0)[3]*log(((G *)Rv0)[2]));
      break;
      case 17:Ra.sl[3]=350; /* line # 350 */
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=351; /* line # 351 */
      Ret=atan2(((G *)Rv0)[2],((G *)Rv0)[3]);
      break;
      case 18:Ra.sl[3]=354; /* line # 354 */
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
      Ra.sl[3]=355; /* line # 355 */
      Ret=atan2(((G *)Rv0)[2],((G *)Rv0)[3])/1.745329251994329E-002;
      break;
      case 19:Ra.sl[3]=358; /* line # 358 */
      if (P_fo_value(((V *)Rv0)[1])<5.000000000000000E-001) Ret=1.000000000000000E+000;
      else {
        Ra.sl[3]=359; /* line # 359 */
        Ret=0.000000000000000E-001;
      }
      break;
      case 20:Ra.sl[3]=360; /* line # 360 */
      Ret=-P_fo_value(((V *)Rv0)[1]);
      break;
      case 21:Ra.sl[3]=362; /* line # 362 */
      Ret=(double)(int)(P_fo_value(((V *)Rv0)[1]));
      break;
      case 22:Ra.sl[3]=363; /* line # 363 */
      Ret=(double)PAS__G_ROUND(P_fo_value(((V *)Rv0)[1]));
      break;
      case 23:Ra.sl[3]=365; /* line # 365 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=sin(((G *)Rv0)[1]);
      break;
      case 24:Ra.sl[3]=366; /* line # 366 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=cos(((G *)Rv0)[1]);
      break;
      case 25:Ra.sl[3]=368; /* line # 368 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ra.sl[3]=369; /* line # 369 */
      Rv1=sin(((G *)Rv0)[1]);
      Ra.sl[3]=370; /* line # 370 */
      Ret=Rv1/sqrt(1.000000000000000E+000-Rv1*Rv1);
      break;
      case 26:Ra.sl[3]=372; /* line # 372 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=asin(((G *)Rv0)[1]);
      break;
      case 27:Ra.sl[3]=373; /* line # 373 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=1.570796326794897E+000-asin(((G *)Rv0)[1]);
      break;
      case 28:Ra.sl[3]=374; /* line # 374 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=atan(((G *)Rv0)[1]);
      break;
      case 29:Ra.sl[3]=375; /* line # 375 */
      ((G *)Rv0)[1]=1.745329251994329E-002*P_fo_value(((V *)Rv0)[1]);
      Ret=sin(((G *)Rv0)[1]);
      break;
      case 30:Ra.sl[3]=376; /* line # 376 */
      ((G *)Rv0)[1]=1.745329251994329E-002*P_fo_value(((V *)Rv0)[1]);
      Ret=cos(((G *)Rv0)[1]);
      break;
      case 31:Ra.sl[3]=378; /* line # 378 */
      ((G *)Rv0)[1]=1.745329251994329E-002*P_fo_value(((V *)Rv0)[1]);
      Ra.sl[3]=379; /* line # 379 */
      Rv1=sin(((G *)Rv0)[1]);
      Ra.sl[3]=380; /* line # 380 */
      Ret=Rv1/sqrt(1.000000000000000E+000-Rv1*Rv1);
      break;
      case 32:Ra.sl[3]=382; /* line # 382 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=asin(((G *)Rv0)[1])/1.745329251994329E-002;
      break;
      case 33:Ra.sl[3]=383; /* line # 383 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=9.000000000000000E+001-asin(((G *)Rv0)[1])/1.745329251994329E-002;
      break;
      case 34:Ra.sl[3]=384; /* line # 384 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=atan(((G *)Rv0)[1])/1.745329251994329E-002;
      break;
      case 35:Ra.sl[3]=385; /* line # 385 */
      ((G *)Rv0)[1]=exp(P_fo_value(((V *)Rv0)[1]));
      Ret=((G *)Rv0)[1];
      break;
      case 36:Ra.sl[3]=386; /* line # 386 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=log(((G *)Rv0)[1]);
      break;
      case 37:Ra.sl[3]=387; /* line # 387 */
      ((G *)Rv0)[1]=PAS__THG(P_fo_value(((V *)Rv0)[1]));
      Ret=((G *)Rv0)[1];
      break;
      case 38:Ra.sl[3]=388; /* line # 388 */
      ((G *)Rv0)[1]=P_fo_value(((V *)Rv0)[1]);
      Ret=fabs(((G *)Rv0)[1]);
      break;
      case 39:Ra.sl[3]=389; /* line # 389 */
      ((G *)Rv0)[1]=sqrt(P_fo_value(((V *)Rv0)[1]));
      Ret=((G *)Rv0)[1];
      break;
      case 40:Ra.sl[3]=392; /* line # 392 */
      ((SL *)Rv0)[6]=PAS__G_ROUND(P_fo_value(((V *)Rv0)[2]));
      ((G *)Rv0)[2]=P_fo_value(((V *)Rv0)[1]);
      Ra.sl[3]=393; /* line # 393 */
      Ret=PAS__IGPOWER(((G *)Rv0)[2],((SL *)Rv0)[6]);
      break;
      case 41:Ra.sl[3]=397; /* line # 397 */
      ((SL *)Rv0)[6]=PAS__G_ROUND(2.000000000000000E+000*P_fo_value(((V *)Rv0)[1]
      ));
      Ra.sl[3]=398; /* line # 398 */
      if (((SL *)Rv0)[6]&1) P_math_bessel_jhder(((G *)Rv0)+2,&Rv1, P_fo_value(((
      V *)Rv0)[2]),((SL *)Rv0)[6]/2);
      else {
        Ra.sl[3]=399; /* line # 399 */
        P_math_bessel_jder(((G *)Rv0)+2,&Rv1, P_fo_value(((V *)Rv0)[2]),((SL *)Rv0)
        [6]);
      }
      Ra.sl[3]=400; /* line # 400 */
      Ret=Rv1;
      break;
      case 42:Ra.sl[3]=404; /* line # 404 */
      if (!(((SL *)Rv0)[4]>0)) {
        Ra.sl[3]=410; /* line # 410 */
        ((G *)Rv0)[3]=P_fo_value(((V *)Rv0)[2]);
        Ra.sl[3]=411; /* line # 411 */
        if (((V *)Rv0)[3]!=NULL) MXD_TREWORK_fo_interpol(((V *)Rv0)[3],((G *)Rv0)
        [3],&Rv1,((G *)Rv0)+4);
        Ra.sl[3]=412; /* line # 412 */
        Ret=Rv1;
      }
      break;
      case 43:Ra.sl[3]=416; /* line # 416 */
      Ret=MXD_TREWORK_fo_integr(((V *)Rv0)[1],((G *)((V *)Rv0)[2])+3,((V *)Rv0)[
3]);
      break;
      case 44:Ra.sl[3]=418; /* line # 418 */
      Ret=MXD_TREWORK_sum_loop(F_p,NULL);
      break;
      case 45:Ra.sl[3]=421; /* line # 421 */
      Ret=((G *)Rv0)[1];
      break;
      case 48:Ra.sl[3]=424; /* line # 424 */
      ((SL *)Rv0)[4]=PAS__G_ROUND(P_fo_value(((V *)Rv0)[1]));
      Ra.sl[3]=425; /* line # 425 */
      if (((SL *)Rv0)[4]>0) Ret=P_fo_value(((V *)Rv0)[2]);
      else {
        Ra.sl[3]=426; /* line # 426 */
        Ret=P_fo_value(((V *)Rv0)[3]);
      }
      break;
      case 46:
      case 47:Ra.sl[3]=430; /* line # 430 */
      Ret=MXD_TREWORK_user_fnc_call(F_p,NULL,((UB *)Rv0)[0]==47);
      break;
      case 61:Ra.sl[3]=433; /* line # 433 */
      Ret=P_fo_value(((V *)Rv0)[7]);
      break;
      case 49:Ra.sl[3]=436; /* line # 436 */
      ((SL *)Rv0)[1]=PAS__G_ROUND(P_fo_value(((V *)((V *)Rv0)[2])[1])+1.000000000000000E+000)
      ;
      Ra.sl[3]=437; /* line # 437 */
      if (((SL *)Rv0)[1]>0&&((SL *)Rv0)[1]<=((SL *)((V *)Rv0)[2])[0]) {
        Ra.sl[3]=438; /* line # 438 */
        Ret=P_fo_value(((V *)((V *)Rv0)[2])[((SL *)Rv0)[1]+1]);
      }
      else {
        Ra.sl[3]=440; /* line # 440 */
        ((SL *)Rv0)[1]=0;
        Ret=0.000000000000000E-001;
      }
      break;
      case 52:Ra.sl[3]=443; /* line # 443 */
      Ret=((G *)Rv0)[1];
      break;
      case 54:Ra.sl[3]=445; /* line # 445 */
      Ra.sl[3]=446; /* line # 446 */
      switch (((UB *)Rv0)[1]) {
        case 1:Ra.sl[3]=447; /* line # 447 */
        Ret=(double)V_curr_data.sl[0];
        break;
        case 2:Ra.sl[3]=448; /* line # 448 */
        Ret=(double)V_curr_data.sl[1];
        break;
        case 3:Ra.sl[3]=449; /* line # 449 */
        Ret=(double)V_curr_data.sl[2];
        break;
        case 4:Ra.sl[3]=450; /* line # 450 */
        Ret=V_curr_data.g[6];
        break;
        case 5:Ra.sl[3]=451; /* line # 451 */
        Ret=V_curr_data.g[7];
        break;
        case 6:Ra.sl[3]=452; /* line # 452 */
        Ret=V_curr_data.g[8];
        break;
        case 7:Ra.sl[3]=453; /* line # 453 */
        Ret=V_curr_data.g[9];
        break;
        case 8:Ra.sl[3]=454; /* line # 454 */
        Ret=V_curr_data.g[10];
        break;
        case 9:Ra.sl[3]=455; /* line # 455 */
        Ret=V_curr_data.g[11];
        break;
        case 10:Ra.sl[3]=456; /* line # 456 */
        Ret=V_curr_data.g[15];
        break;
        case 11:Ra.sl[3]=457; /* line # 457 */
        Ret=V_curr_data.g[12];
        break;
        case 12:Ra.sl[3]=458; /* line # 458 */
        Ret=V_curr_data.g[13];
        break;
        case 13:Ra.sl[3]=459; /* line # 459 */
        Ret=V_curr_data.g[14];
        break;
        case 46:Ra.sl[3]=480; /* line # 480 */
        Ret=V_curr_data.g[16];
        break;
        case 47:Ra.sl[3]=481; /* line # 481 */
        Ret=V_curr_data.g[17];
        break;
        case 48:Ra.sl[3]=482; /* line # 482 */
        Ret=V_curr_data.g[18];
        break;
        default:Ra.sl[3]=500; /* line # 500 */
        Ret=0.000000000000000E-001;
        break;
      }
      break;
      case 55:Ra.sl[3]=504; /* line # 504 */
      if (((SL *)Rv0)[3]<0) Ret=0.000000000000000E-001;
      else {
        Ra.sl[3]=505; /* line # 505 */
        Ret=V_curr_data.g[((SL *)Rv0)[3]+18];
      }
      break;
      case 60:Ra.sl[3]=507; /* line # 507 */
      Ret=((G *)Rv0)[3];
      break;
      case 59:Ra.sl[3]=510; /* line # 510 */
      Ret=((G *)Rv0)[1];
      break;
      case 57:Ra.sl[3]=512; /* line # 512 */
      Ret=((G *)Rv0)[5];
      break;
      case 58:Ra.sl[3]=514; /* line # 514 */
      Ret=((G *)Rv0)[5];
      break;
      default:Ra.sl[3]=517; /* line # 517 */
      Ret=0.000000000000000E-001;
      break;
    }
  }
  Ra.sl[3]=519; /* line # 519 */
  Ri.ul[0]=Ri.ul[0] -1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " der_val "  */
G MXD_TREWORK_der_val(V F_p, V F_q){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  G Rv0;
  V Rv1;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+143;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=530; /* line # 530 */
  if (F_p==NULL) Rv0=0.000000000000000E-001;
  else {
    Ra.sl[3]=533; /* line # 533 */
    Rv0=0.000000000000000E-001;
    Ra.sl[3]=534; /* line # 534 */
    Rv1=((V *)F_p)[8];
    Ra.sl[3]=535; /* line # 535 */
    while (Rv1!=NULL){
      Ra.sl[3]=536; /* line # 536 */
      if (((V *)Rv1)[1]==F_q) {
        Rv0=((G *)Rv1)[1];
        Rv1=NULL;
      }
      else {
        Ra.sl[3]=537; /* line # 537 */
        Rv1=((V *)Rv1)[0];
      }
    }
  }
  Ra.sl[3]=539; /* line # 539 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fo_deriv "  */
G P_fo_deriv(V F_p, V F_q){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  G Rv1;
  register G Rgg;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+152;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=551; /* line # 551 */
  Ri.ul[0]=Ri.ul[0]+1;
  Ra.sl[3]=552; /* line # 552 */
  if (Ri.ul[0]<=4096) Rs.v[Ri.ul[0]-1]=F_p;
  Ra.sl[3]=554; /* line # 554 */
  if (F_p==NULL) Ret=0.000000000000000E-001;
  else {
    Ra.sl[3]=556; /* line # 556 */
    if (F_p==F_q) Ret=1.000000000000000E+000;
    else {
      Ra.sl[3]=558; /* line # 558 */
      Rv0=F_p;
      Ra.sl[3]=559; /* line # 559 */
      switch (((UB *)Rv0)[0]) {
        case 9:Ra.sl[3]=560; /* line # 560 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)+P_fo_deriv(((V *)Rv0)[2],F_q);
        break;
        case 10:Ra.sl[3]=561; /* line # 561 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)-P_fo_deriv(((V *)Rv0)[2],F_q);
        break;
        case 14:Ra.sl[3]=563; /* line # 563 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)*((G *)Rv0)[3]+((G *)Rv0)[2]*P_fo_deriv((
        (V *)Rv0)[2],F_q);
        break;
        case 15:Ra.sl[3]=564; /* line # 564 */
        Ret=(P_fo_deriv(((V *)Rv0)[1],F_q)*((G *)Rv0)[3]-((G *)Rv0)[2]*P_fo_deriv((
        (V *)Rv0)[2],F_q))/PAS__G_SQR(((G *)Rv0)[3]);
        break;
        case 16:Ra.sl[3]=566; /* line # 566 */
        Rv1=log(((G *)Rv0)[2]);
        Ra.sl[3]=567; /* line # 567 */
        Ret=exp(Rv1*((G *)Rv0)[3])*(P_fo_deriv(((V *)Rv0)[2],F_q)*Rv1+(((G *)Rv0)
        [3]*P_fo_deriv(((V *)Rv0)[1],F_q))/((G *)Rv0)[2]);
        break;
        case 17:
        case 18:Ra.sl[3]=571; /* line # 571 */
        Rv1=PAS__G_SQR(((G *)Rv0)[2])+PAS__G_SQR(((G *)Rv0)[3]);
        Ra.sl[3]=572; /* line # 572 */
        if (Rv1<=1.000000000000001E-012) Ret=0.000000000000000E-001;
        else {
          Ra.sl[3]=574; /* line # 574 */
          Rv1=(P_fo_deriv(((V *)Rv0)[1],F_q)*((G *)Rv0)[3]-((G *)Rv0)[2]*P_fo_deriv((
          (V *)Rv0)[2],F_q))/Rv1;
          Ra.sl[3]=575; /* line # 575 */
          if (((UB *)Rv0)[0]==17) Ret=Rv1;
          else {
            Ra.sl[3]=576; /* line # 576 */
            Ret=Rv1/1.745329251994329E-002;
          }
        }
        break;
        case 20:Ra.sl[3]=580; /* line # 580 */
        Ret=-P_fo_deriv(((V *)Rv0)[1],F_q);
        break;
        case 23:Ra.sl[3]=582; /* line # 582 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)*cos(((G *)Rv0)[1]);
        break;
        case 24:Ra.sl[3]=583; /* line # 583 */
        Ret=-P_fo_deriv(((V *)Rv0)[1],F_q)*sin(((G *)Rv0)[1]);
        break;
        case 25:Ra.sl[3]=584; /* line # 584 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/PAS__G_SQR(cos(((G *)Rv0)[1]));
        break;
        case 26:Ra.sl[3]=585; /* line # 585 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/sqrt(1.000000000000000E+000-PAS__G_SQR
        (((G *)Rv0)[1]));
        break;
        case 27:Ra.sl[3]=586; /* line # 586 */
        Ret=-P_fo_deriv(((V *)Rv0)[1],F_q)/sqrt(1.000000000000000E+000-PAS__G_SQR
        (((G *)Rv0)[1]));
        break;
        case 28:Ra.sl[3]=587; /* line # 587 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/(1.000000000000000E+000+PAS__G_SQR(((G
         *)Rv0)[1]));
        break;
        case 29:Ra.sl[3]=588; /* line # 588 */
        Ret=(P_fo_deriv(((V *)Rv0)[1],F_q)*cos(((G *)Rv0)[1]))*1.745329251994329E-002;
        break;
        case 30:Ra.sl[3]=589; /* line # 589 */
        Ret=(-P_fo_deriv(((V *)Rv0)[1],F_q)*sin(((G *)Rv0)[1]))*1.745329251994329E-002;
        break;
        case 31:Ra.sl[3]=590; /* line # 590 */
        Ret=(P_fo_deriv(((V *)Rv0)[1],F_q)*1.745329251994329E-002)/PAS__G_SQR(cos
        (((G *)Rv0)[1]));
        break;
        case 32:Ra.sl[3]=591; /* line # 591 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/(sqrt(1.000000000000000E+000-PAS__G_SQR
        (((G *)Rv0)[1]))*1.745329251994329E-002);
        break;
        case 33:Ra.sl[3]=592; /* line # 592 */
        Ret=-P_fo_deriv(((V *)Rv0)[1],F_q)/(sqrt(1.000000000000000E+000-PAS__G_SQR
        (((G *)Rv0)[1]))*1.745329251994329E-002);
        break;
        case 34:Ra.sl[3]=593; /* line # 593 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/((1.000000000000000E+000-PAS__G_SQR(((
        G *)Rv0)[1]))*1.745329251994329E-002);
        break;
        case 35:Ra.sl[3]=594; /* line # 594 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)*((G *)Rv0)[1];
        break;
        case 36:Ra.sl[3]=595; /* line # 595 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/((G *)Rv0)[1];
        break;
        case 37:Ra.sl[3]=596; /* line # 596 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)*(1.000000000000000E+000-PAS__G_SQR(((G
         *)Rv0)[1]));
        break;
        case 38:Ra.sl[3]=597; /* line # 597 */
        if (((G *)Rv0)[1]==0.000000000000000E-001) Ret=0.000000000000000E-001;
        else {
          Ra.sl[3]=598; /* line # 598 */
          if (((G *)Rv0)[1]>0.000000000000000E-001) Ret=P_fo_deriv(((V *)Rv0)[1]
          ,F_q);
          else {
            Ra.sl[3]=599; /* line # 599 */
            Ret=-P_fo_deriv(((V *)Rv0)[1],F_q);
          }
        }
        break;
        case 39:Ra.sl[3]=600; /* line # 600 */
        Ret=P_fo_deriv(((V *)Rv0)[1],F_q)/(2.000000000000000E+000*((G *)Rv0)[1])
        ;
        break;
        case 40:Ra.sl[3]=602; /* line # 602 */
        Ret=((double)((SL *)Rv0)[6]*PAS__IGPOWER(((G *)Rv0)[2],((SL *)Rv0)[6]-1)
        )*P_fo_deriv(((V *)Rv0)[1],F_q);
        break;
        case 41:Ra.sl[3]=604; /* line # 604 */
        Ret=P_fo_deriv(((V *)Rv0)[2],F_q)*((G *)Rv0)[2];
        break;
        case 42:Ra.sl[3]=607; /* line # 607 */
        Ret=P_fo_deriv(((V *)Rv0)[2],F_q)*((G *)Rv0)[4];
        break;
        case 43:Ra.sl[3]=610; /* line # 610 */
        Ret=MXD_TREWORK_fd_integr(((V *)Rv0)+1,((G *)((V *)Rv0)[2])+3,((V *)Rv0)
        [3],F_q);
        break;
        case 44:Ra.sl[3]=612; /* line # 612 */
        Ret=MXD_TREWORK_sum_loop(F_p, F_q);
        break;
        case 48:Ra.sl[3]=614; /* line # 614 */
        if (((SL *)Rv0)[4]>0) Ret=P_fo_deriv(((V *)Rv0)[2],F_q);
        else {
          Ra.sl[3]=615; /* line # 615 */
          Ret=P_fo_deriv(((V *)Rv0)[3],F_q);
        }
        break;
        case 46:
        case 47:Ra.sl[3]=618; /* line # 618 */
        Ret=MXD_TREWORK_user_fnc_call(F_p, F_q,((UB *)Rv0)[0]==47);
        break;
        case 61:Ra.sl[3]=621; /* line # 621 */
        Ret=P_fo_deriv(((V *)Rv0)[7],F_q);
        break;
        case 49:Ra.sl[3]=624; /* line # 624 */
        if (((SL *)Rv0)[1]>0) Ret=P_fo_deriv(((V *)((V *)Rv0)[2])[((SL *)Rv0)[1]
        +1],F_q);
        else {
          Ra.sl[3]=625; /* line # 625 */
          Ret=0.000000000000000E-001;
        }
        break;
        case 54:Ra.sl[3]=627; /* line # 627 */
        switch (((UB *)Rv0)[1]) {
          case 4:Ra.sl[3]=629; /* line # 629 */
          Ret=0.000000000000000E-001;
          break;
          default:Ra.sl[3]=663; /* line # 663 */
          Ret=0.000000000000000E-001;
          break;
        }
        break;
        case 55:Ra.sl[3]=667; /* line # 667 */
        Ret=0.000000000000000E-001;
        break;
        case 57:
        case 59:Ra.sl[3]=671; /* line # 671 */
        if (F_p==F_q) Ret=1.000000000000000E+000;
        else {
          Ra.sl[3]=672; /* line # 672 */
          Ret=0.000000000000000E-001;
        }
        break;
        case 58:Ra.sl[3]=674; /* line # 674 */
        Ret=MXD_TREWORK_der_val(F_p, F_q);
        break;
        default:Ra.sl[3]=678; /* line # 678 */
        Ret=0.000000000000000E-001;
        break;
      }
    }
  }
  Ra.sl[3]=680; /* line # 680 */
  Ri.ul[0]=Ri.ul[0] -1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " parm_eval "  */
void P_parm_eval(UB F_ctg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+162;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=694; /* line # 694 */
  if (F_ctg==0) Rv0=V_parhde;
  else {
    Ra.sl[3]=695; /* line # 695 */
    Rv0=V_pardhde.v[F_ctg-2];
  }
  Ra.sl[3]=696; /* line # 696 */
  while (Rv0!=NULL){
    Ra.sl[3]=698; /* line # 698 */
    V_cparam=Rv0;
    Ra.sl[3]=699; /* line # 699 */
    Rv1=Rv0;
    Ra.sl[3]=701; /* line # 701 */
    ((G *)Rv1)[5]=P_fo_value(((V *)Rv1)[6]);
    Ra.sl[3]=702; /* line # 702 */
    Rv2=((V *)Rv1)[8];
    Ra.sl[3]=703; /* line # 703 */
    while (Rv2!=NULL){
      Ra.sl[3]=705; /* line # 705 */
      ((G *)Rv2)[1]=P_fo_deriv(((V *)Rv1)[6],((V *)Rv2)[1]);
      Ra.sl[3]=706; /* line # 706 */
      Rv2=((V *)Rv2)[0];
    }
    Ra.sl[3]=709; /* line # 709 */
    if (F_ctg==0) Rv0=((V *)Rv0)[1];
    else {
      Ra.sl[3]=710; /* line # 710 */
      Rv0=((V *)Rv0)[7];
    }
  }
  Ra.sl[3]=712; /* line # 712 */
  V_cparam=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " clrsumhkl "  */
void MXD_TREWORK_clrsumhkl(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+173;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=722; /* line # 722 */
  Rv0=V_sumhhde;
  Ra.sl[3]=723; /* line # 723 */
  while (Rv0!=NULL){
    Ra.sl[3]=725; /* line # 725 */
    ((G *)Rv0)[1]=0.000000000000000E-001;
    Ra.sl[3]=726; /* line # 726 */
    Rv0=((V *)Rv0)[4];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " makesumhkl "  */
void MXD_TREWORK_makesumhkl(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+184;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=737; /* line # 737 */
  Rv0=V_sumhhde;
  Ra.sl[3]=738; /* line # 738 */
  while (Rv0!=NULL){
    Ra.sl[3]=739; /* line # 739 */
    Rv1=Rv0;
    Ra.sl[3]=741; /* line # 741 */
    ((G *)Rv1)[1]=((G *)Rv1)[1]+P_fo_value(((V *)Rv1)[5]);
    Ra.sl[3]=742; /* line # 742 */
    Rv0=((V *)Rv1)[4];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " compute_exp_derv "  */
void P_compute_exp_derv(V F_exp, SL F_lw, SL F_up, V F_pat, SL F_np, V F_vdr, SL
F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+196;
  Ra.v[2]=Rd.s+16;
  Ra.sl[3]=757; /* line # 757 */
  Rv0=1;
  for( Rf0=F_np;Rf0>0;Rf0-- ) {
    Ra.sl[3]=759; /* line # 759 */
    Rv1=((V *)((V *)F_pat)[Rv0-1])[8];
    Ra.sl[3]=760; /* line # 760 */
    while (Rv1!=NULL){
      Ra.sl[3]=762; /* line # 762 */
      Rv2=Rv1;
      Rv3=((V *)Rv2)[1];
      Ra.sl[3]=763; /* line # 763 */
      if (((UB *)Rv3)[0]==59) {
        Ra.sl[3]=764; /* line # 764 */
        switch (((UB *)Rv3)[1]) {
          case 1:break;
          case 2:break;
          case 3:break;
          case 4:break;
          case 5:break;
          case 6:
          case 7:
          case 8:
          case 9:
          case 10:
          case 11:break;
          case 12:break;
          case 13:
          case 14:
          case 15:
          case 16:
          case 17:
          case 18:break;
          case 19:break;
          case 20:
          case 21:
          case 22:
          case 23:
          case 24:
          case 25:break;
          case 26:
          case 27:
          case 28:
          case 29:
          case 30:
          case 31:break;
          case 32:
          case 33:
          case 34:
          case 35:
          case 36:
          case 37:
          case 38:
          case 39:
          case 40:break;
          case 41:
          case 42:
          case 43:
          case 44:
          case 45:
          case 46:
          case 47:
          case 48:
          case 49:break;
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:
          case 56:
          case 57:
          case 58:
          case 59:
          case 60:
          case 61:break;
          case 62:
          case 63:
          case 64:
          case 65:
          case 66:
          case 67:
          case 68:
          case 69:
          case 70:
          case 71:
          case 72:
          case 73:break;
          default:break;
        }
      }
      else {
        Ra.sl[3]=786; /* line # 786 */
        Rv4=((SL *)Rv3)[7];
        Ra.sl[3]=787; /* line # 787 */
        ((G *)F_vdr)[Rv4-1]=((G *)F_vdr)[Rv4-1]+((G *)F_exp)[(Rv0-F_lw)]*((G *)Rv2)
        [1];
      }
      Ra.sl[3]=789; /* line # 789 */
      Rv1=((V *)Rv1)[0];
    }
    Rv0++;
  }
  PAS__curr_cntx=Ra.v[0];
}
