{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*     MXD   Expression  and  Crystallographic  Object  Tree   Initializer     *
*                                                                             *
*                                                                             *
*******************************************************************************


}


{****************     CPAS  version    *****************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_TREE_INIT;


  %include        'MXDSRC:mxd_lsq_env'; { Get all tree definitions }




[global]
procedure TREE_SET_DERIV;
{ Procedure to build the derivation list of each LSQ_PARM expression.
}
var
  p:               ptr;                 { Pointer to the current expression node }
  dli:         der_ptr;                 { Header of the derivate block list }
  ctb:      pardep_tab;                 { Temporary derivate table by category }
  ctg:      prmc_categ;                 { Category index }


  procedure INSERT_DER( vp: ptr );
  var
    p0,  p1,  p2:      der_ptr;
    id0, id1:          integer;
    bl:                boolean;

  begin
    id0 := vp^.itm_sequ;                { Get the IID of the current LSQ_VAR }
    id1 :=     -100;                    { Init the current IID at a value less than the minimum possible }
    p0  :=      dli;                    { Init the current derivate list pointer }
    p1  :=      nil;                    { Init the previous derivate block pointer }
    bl  := false;
    while (p0 <> nil) and not bl do     { Loop to search the current LSQ_VAR reference in list }
    begin
      id1 := p0^.der_var^.itm_sequ;     { Get the IID of the LSQ_VAR }
      bl  := (id0 <= id1);              { Stop the Loop when the found IID > the current LSQ_VAR IID }
      if not bl then begin  p1 := p0; p0 := p0^.der_next  end
    end;
    if id1 <> id0 then                  { The current LSQ_VAR was not in the derivation list }
    begin { We must be inserted the current LSQ_VAR in the list (create a new derivate block) }
      NEW( p2 );
      p2^.der_next :=  p0;              { Link the new block with the next one (with greatest IID) }
      p2^.der_var  :=  vp;              { Set the link with the LSQ_VAR }
      p2^.der_val  := 0.0;              { Init the derivate value }
      if p1 = nil then dli := p0        { The new block must be put as the first one ... }
                  else p1^.der_next := p0 { ... else, it must be insert in the list }
    end
  end;



  procedure LOOK_VAR( tp: ptr; bvok: boolean );
  { Recursive routine to parse an expression tree and build
    the derivation block for each referenced  variable.
    This routine assume an strict ordering of the list of
    LSQ_PARM where all derivation list of each LSQ_PARM
    are build before any reference to the same LSQ_PARM.
  }
  var
    pa, pb:                ptr;
    p0, p1, p2:        der_ptr;
    id0, id1, id2, np: integer;
    ctt:            prmc_categ;
    bl:                boolean

  begin
    ctt := prmc_init;
    with tp^ do
    case nod_typ of
      op_eq,     op_ne,     op_lt,      { All binary operator without ... }
      op_le,     op_ge,     op_gt,      { ... derivate specific float }
      op_and,    op_xor,    op_or,
      op_mod,    op_rem:
        begin  LOOK_VAR( nod_bin1, false ); LOOK_VAR( nod_bin2, false )  end;

      op_add,    op_sub:
        begin  LOOK_VAR( nod_bin1, bvok ); LOOK_VAR( nod_bin2, bvok )  end;

      op_mul,    op_div,    op_pow,     { All binary operator with ... }
      op_phaser, op_phased:             { ... derivate specific floats }
        begin  LOOK_VAR( nod_bind1, bvok ); LOOK_VAR( nod_bind2, bvok )  end;

      op_not,    op_neg,    op_trunc,   { All unary operator without ... }
      op_round:                         { ... derivate specific float }
        LOOK_VAR( nod_una, false );

      op_sinr,   op_cosr,   op_tanr,    { All unary operator with ... }
      op_asinr,  op_acosr,  op_atanr,   { ... derivate specific float }
      op_sind,   op_cosd,   op_tand,
      op_asind,  op_acosd,  op_atand,
      op_exp,    op_ln,     op_tanh,
      op_abs,    op_sqrt:
        LOOK_VAR( nod_unad, bvok );

      op_ipw:                           { Integer power }
        begin  LOOK_VAR( nod_iwo, bvok ); LOOK_VAR( nod_iwe, false )  end;

      op_bessj:                         { Bessel function Bj (integer) }
        begin  LOOK_VAR( nod_bij_ne, false ); LOOK_VAR( nod_bij_xe, bvok )  end;

      op_integr:                        { Integration function }
        LOOK_VAR( nod_intexpr, bvok );

      op_interpol:                      { Table interpolation function }
        LOOK_VAR( nod_itpexp, bvok );

      op_summ:                          { Summation function }
        begin
          LOOK_VAR( nod_smlb, false ); LOOK_VAR( nod_smle, false ); LOOK_VAR( nod_smls, false );
          LOOK_VAR( nod_exp, bvok )
        end;

      op_sumobs: LOOK_VAR( nod_osmexp, bvok );

      op_funcall, op_formcall:          { Call LSQ functions -- temporary not operational }
        begin
          np := nod_arglist^.size;      { Get the size of effective argument list }
          id0 := 0;
          while id0 < np do
          begin
            LOOK_VAR( nod_arglist^[id0], bvok );
            id0 := id0 + 1
          end;
          if nod_parseflg then          { The function can be refer some external object as LSQ_VARBL, LSQ_PARM Coeff ... }
          begin
            pa := nod_arglist^[np];     { Get the user function reference }
            nod_parseflg := false;      { Set to false to avoid any recursive parseing }
            if nod_typ = op_formcall then pa := pa^.for_link;   { For formal function, we follow the effective link }
            LOOK_VAR( pa^.frm_exprv, bvok );                    { Perform the parseing of the function code }
            { The node op_formal are ignored to scan just at one time the effective arguments }
            nod_parseflg := true        { Reset the flag because the possible external reference list is not keep
                                          for all other usage of the function }
          end
        end;

      op_select:
        for ii := 0 to nod_seltab^.size do  LOOK_VAR( nod_seltab^[ii], (ii > 0) and bvok );

      op_ifsel:
        begin  LOOK_VAR( nod_cond, false ); LOOK_VAR( nod_wtrue, bvok ); LOOK_VAR( nod_wfalse, bvok )  end;

      op_coeff:                         { Application Value == Internal application reference }
        case nod_coeffid of
          coef_h,  coef_k,  coef_l,
          coef_selnb,
          coef_obs,   coef_sig,   coef_weight,
          coef_y_x,
          coef_y_obs, coef_y_sg,  coef_y_weight:
            ctt := prmc_data;  { Depend of data record (constant) }

          coef_rh, coef_rk, coef_rl,
          coef_sithsl:
            ctt := prmc_datc;  { Depend of data record and current unit cell }

          coef_hh, coef_kk, coef_ll:
            ctt := prmc_datw;  { Depend of data record, current unit cell and Wave vector }

          coef_hx, coef_hy, coef_hz:
            ctt := prmc_datp;  { Depend of data record, current unit cell and polarization direction }

          coef_sh, coef_sk, coef_sl:
            ctt := prmc_dats;  { Depend of data record and symetry operator }

          coef_lchi2, coef_cchi2,
          coef_lmaxf, coef_cmaxf:
            ctt := prmc_stpf;  { Depend of cycle residu/chi2 }

        otherwise
        end;

      op_virtvar:
        begin
          INSERT_DER( tp );             { Insert the virtual variable dependance }
          ctt := nod_vcateg
        end;

      op_varbl:
        begin
          var_matidx := 0;              { Set this variable as referenced }
          if var_orgidx <> 0 then       { Work only for free LSQ_VAR }
          begin
            INSERT_DER( tp );           { Create the LSQ_VAR derivate block when not already existing }
            ctt := prmc_varb            { Evaluate for each cycle begining }
          end
        end;

      op_parm:
        begin                           { Loop to insert all not already existing ... }
          p0 := par_lstder;
          while p0 <> nil do            { ... derivation block of the referenced LSQ_PARM }
          begin  INSERT_DER( p0^.der_var ); p0 := p0^.der_next  end;
          ctt := par_categ
        end;

      op_citmrf:
        begin
          case citm_codety( nod_citmty ) of
            citm_wavevect: ctt := prmc_datw;
            citm_npoladir: ctt := prmc_datp;
            citm_symtry:   ctt := prmc_dats;
            citm_phase:    ctt := prmc_varb;
            citm_atmgroup,
            citm_atom,
            citm_moment,
            citm_mdsdsp:   ctt := prmc_varb;
          otherwise
            pa := nil
          end;

        end;

    otherwise
    end;
    case ctt of
      prmc_datc, prmc_datw, prmc_datp:
        if ctg = prmc_varb then ctg := prmc_stp0
                           else if ctt > ctg then ctg := ctt;
      prmc_varb:
        if (ctg >= prmc_data) and (ctg <= prmc_datp) then ctg := prmc_stp0
                                                     else if ctt > ctg then ctg := ctt;
      prmc_itmblk:
        if ctg <= prmc_init then ctg := prmc_itmblk;
    otherwise
      if ctt > ctg then ctg := ctt
    end
  end LOOK_VAR;


begin { TREE_SET_DERIV }
  { Initialize the last LSQ_PARM pointer for each LSQ_PARM Category }
  for catg := prmc_categ"first to prmc_categ"last do  ctb[catg] := nil;

  { Loop to scan all the defined LSQ_PARM }
  p := parhde;
  while p <> nil do
  begin                                 { For each LSQ_PARM }
    ctg := prmc_init;                   { Default to fix parameter category }
    dli := nil;                         { Initialise the Derivate block list to empty }
    with p^ do
    begin
      LOOK_VAR( par_expres, true );     { Build the Derivate block list }
      par_lstder := dli;                { Set the Derivate block list of this LSQ_PARM ... }
      par_categ  := ctg;                { Set the LSQ_PARM category field of this LSQ_PARM }

      if ctg = prmc_itmblk then         { This LSQ_PARM must be append at the current item dependent list }
      begin
        case nod_vvsequ of
          virt_pha$scale..virt_pha$dga:
           { QUEUE_OBJECT(  ) };
          virt_pha$dtaa..virt_pha$rm33: { Current Phase depend virtual variable }
            ;
          virt_grp$m11..virt_gre$tz:    { Current AtmGroup depend virtual variable }
            ;
        otherwise
        end
      end
      else
      begin
        if ctb[ctg] = nil then pardhde[ctg] := p
                          else ctb[ctg]^.par_catlnk := p;
        ctb[ctg] := p; par_catlnk := nil
      end
    end;
    p := p^.itm_next
  end
end TREE_SET_DERIV;



procedure GVAL_INIT( p: ptr; var v: mxd_flt; var f: boolean );
begin
  if p = nil then begin  v := 0.0; f := true  end
  else
    with p^ do
    begin
      if par_categ = prmc_init then f := true
                               else begin  par_actval := FO_VALUE( par_expres ); f := false  end;
      v := par_actval
    end
end GVAL_INIT;



procedure WAVE_INIT( pw: ptr );
var
  bfix:                boolean;
  tbf:  array[1..3] of boolean;

begin
  with pw^ do
  begin
    bfix := true;                       { Assume fix unit cell until shown otherwise }
    for i := 1 to 3 do  GVAL_INIT( wav_par[i-1], wav_hkl[i], tbf[i] );

WRITE( ' The wave vector "', itm_name^, '" of phase "', wav_phase^.itm_name^, '" is [' );
for i := 1 to 3 do
begin
  WRITE( ' ', wav_hkl[i]:6:4, ' ' );
  if tbf[i] then WRITE( 'F,' )
            else WRITE( 'V,' )
end;
if bfix then WRITELN( '] is fixed.' )
        else WRITELN( '] will be fitted.' );

    for i := 1 to 3 do  for j := 1 to 6 do wav_vec[i,j] := 0.0;
    wav_fixed := bfix;
    CRYST_MULMAT_VDERV( wav_phase^.pha_cell.cell_rcmt, wav_par[0], wav_par[1], wav_par[2], wav_vec )
  end
end WAVE_INIT;



[global]
procedure PHASES_AND_DATA_INIT;
var
  p: ptr;
  bfix:  boolean;
  tbf: array[1..6] of boolean;

begin
  cphas := phashde;
  while cphas <> nil do
  begin
    CRYST_PHASE_COMPUTE( cphas );
    CRYST_GROUP_SET( cphas );
    cwave := cphas^.pha_wavhde;
    while cwave <> nil do
    begin
      WAVE_INIT( cwave );
      cwave := cwave^.itm_next
    end;

    cphas := cphas^.itm_next
  end;
  cphas := phashde;                     { Set to have a defined access to a current phase }

  cdata := datahde;
  while cdata <> nil do
  begin
    CRYST_DATA_COMPLETE( cdata );
    cdata := cdata ^.itm_next
  end;
  cdata := datahde                      { Set to have a defined acces to a current data }
end PHASES_AND_DATA_INIT;




[global]
procedure LSQ_VECTMAT_ALLOC;
{ Evaluate the diagonal block length and allocate the matrix(s) and vectors for the
  Least-Squares Engine.
}
const
  deflsqb_name = '.Default_Block.';

var
  lstvar, defblk:          ptr;
  nvok, nb, dim:       integer;

begin
  itopvect  :=       0;                 { Init the Matrxi/Vector size count }

  varnb     :=       0;
  nvok      :=       0;
  lstvar    :=     nil;
  varhde    :=     nil;
  cdblk     := dblkhde;
  cvarbl    := gvarhde;
  while (cvarbl <> nil) do
  with cvarbl^ do
  begin
    if (var_orgidx = 1) and             { When the LSQ_VAR is not fixed and referenced in ... }
       (var_matidx = 0) then            { ... some expressions we add it to the current Diag. Block }
    begin
      varnb      :=  varnb + 1;         { Update the count of active LSQ_VAR }
      var_orgidx :=      varnb;         { Set the original and the current LSQ_VAR matrix index }
      var_matidx :=      varnb;
      itm_link   :=     varhde;         { Set the list to be ca circular variable list }
      if lstvar = nil then varhde := cvarbl     { Form the list of free (active) LSQ_VAR }
                      else lstvar^.itm_link := cvarbl;
      lstvar     :=     cvarbl
    end;

    if cdblk <> nil then                { When a diagonal block is defined and ... }
      if cdblk^.blk_lstvar = cvarbl then        { ... his last LSQ_VAR is the current one }
      with cdblk^ do
      begin
        dim     :=        varnb - nvok; { Get the diagonal block size }
        blk_vardim      :=         dim; { We set the diagonal block size }
{       NEW( blk_matrix, (dim*(dim+1))/2 );     { Allocate the block matrix [as triangular matrix - always symetric] }
        nvok    :=               varnb; { Set the number of ready to fit LSQ_VAR(s) }
        cdblk   :=            itm_next; { Continue with the next Diagonal block }

        itopvect  := itopvect + (dim*(dim + 1)) div 2;

;WRITELN( ' Create the LSQ Block matrix "', itm_name^, '" of size ', blk_vardim:0 );

      end;
    cvarbl := itm_next
  end;

  { When some Free and referenced LSQ_VAR(s) are pending,
    we create a specific dedicated diagonal block (the default block) }
  if varnb > nvok then
  begin
    NEW( defblk, op_item, itm_lsqblk );
    with defblk^ do
    begin { Create a diagonal block for all forgotten variables }
      nod_typ       :=         op_item;
      itm_next      :=             nil;
      itm_link      :=             nil;
      NEW( itm_name, deflsqb_name.length );
      itm_name^     :=    deflsqb_name;
      itm_sequ      :=               0;
      itm_kind      :=      itm_lsqblk;
      dim           :=    varnb - nvok;
      blk_vardim    :=             dim;
      blk_dynmrq    :=        pcte_one;
      blk_dynmrq    :=        pcte_one;
      blk_lstvar    :=          lstvar;

      itopvect  := itopvect + (dim*(dim + 1)) div 2;

;WRITELN( ' Create the default LSQ Block matrix "', itm_name^, '" of size ', blk_vardim:0 );

{     NEW( blk_matrix, (dim*(dim+1))/2 )        { Allocate the matrix array }
    end;
    QUEUE_OBJECT( dblkhde, dblklst, defblk )
  end;

  WRITELN( ' There are ', varnb:0, ' free LSQ_VARiables.' );

  { Now we can allocate the memory space for
    each diagonal block and dedicated vectors }

  idervec := itopvect; itopvect  := itopvect + varnb;   { Allocate the partial derivative table }
  ishfvec := itopvect; itopvect  := itopvect + varnb;   { Allocate LSQ column vector }
  ishfvec := itopvect; itopvect  := itopvect + varnb;   { Allocate the shift LSQ vector }

  NEW( mdtab, itopvect )                { Allocate the LSQ Matrixs_and_Vectors Table }

;WRITELN( ' The total Size of Matrixs_and_Vectors Table is ', itopvect:0 )

end LSQ_VECTMAT_ALLOC;



end MXD_TREE_INIT.
