/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 440 ) = {
 10,  10, 105, 110, 115, 101, 114, 116,  95, 100, 101, 114,  56,  56,  47, 104,
111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,
 47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,
 95, 115, 114,  99,  47, 109, 120, 100,  95, 116, 114, 101, 101,  95, 105, 110,
105, 116,  46, 112,  97, 115,   8,   8, 108, 111, 111, 107,  95, 118,  97, 114,
 14,  14, 116, 114, 101, 101,  95, 115, 101, 116,  95, 100, 101, 114, 105, 118,
  9,   9, 103, 118,  97, 108,  95, 105, 110, 105, 116,   9,   9, 119,  97, 118,
101,  95, 105, 110, 105, 116,  18,  18,  32,  84, 104, 101,  32, 119,  97, 118,
101,  32, 118, 101,  99, 116, 111, 114,  32,  34,  12,  12,  34,  32, 111, 102,
 32, 112, 104,  97, 115, 101,  32,  34,   6,   6,  34,  32, 105, 115,  32,  91,
  2,   2,  70,  44,   2,   2,  86,  44,  11,  11,  93,  32, 105, 115,  32, 102,
105, 120, 101, 100,  46,  17,  17,  93,  32, 119, 105, 108, 108,  32,  98, 101,
 32, 102, 105, 116, 116, 101, 100,  46,  20,  20, 112, 104,  97, 115, 101, 115,
 95,  97, 110, 100,  95, 100,  97, 116,  97,  95, 105, 110, 105, 116,  17,  17,
108, 115, 113,  95, 118, 101,  99, 116, 109,  97, 116,  95,  97, 108, 108, 111,
 99,  30,  30,  32,  67, 114, 101,  97, 116, 101,  32, 116, 104, 101,  32,  76,
 83,  81,  32,  66, 108, 111,  99, 107,  32, 109,  97, 116, 114, 105, 120,  32,
 34,  10,  10,  34,  32, 111, 102,  32, 115, 105, 122, 101,  32,  15,  15,  46,
 68, 101, 102,  97, 117, 108, 116,  95,  66, 108, 111,  99, 107,  46,  38,  38,
 32,  67, 114, 101,  97, 116, 101,  32, 116, 104, 101,  32, 100, 101, 102,  97,
117, 108, 116,  32,  76,  83,  81,  32,  66, 108, 111,  99, 107,  32, 109,  97,
116, 114, 105, 120,  32,  34,  10,  10,  34,  32, 111, 102,  32, 115, 105, 122,
101,  32,  11,  11,  32,  84, 104, 101, 114, 101,  32,  97, 114, 101,  32,  20,
 20,  32, 102, 114, 101, 101,  32,  76,  83,  81,  95,  86,  65,  82, 105,  97,
 98, 108, 101, 115,  46,  48,  48,  32,  84, 104, 101,  32, 116, 111, 116,  97,
108,  32,  83, 105, 122, 101,  32, 111, 102,  32,  77,  97, 116, 114, 105, 120,
115,  95,  97, 110, 100,  95,  86, 101,  99, 116, 111, 114, 115,  32,  84,  97,
 98, 108, 101,  32, 105, 115,  32,   0
};

/* Declaration of external variables. */
extern V V_parhde;
extern Blk(V_pardhde, 56 );
extern V PAS__f_output;
extern V V_cphas;
extern V V_phashde;
extern V V_cwave;
extern V V_cdata;
extern V V_datahde;
extern SL V_itopvect;
extern SL V_varnb;
extern V V_varhde;
extern V V_cdblk;
extern V V_dblkhde;
extern V V_cvarbl;
extern V V_gvarhde;
extern V V_pcte_one;
extern V V_dblklst;
extern SL V_idervec;
extern SL V_ishfvec;
extern V V_mdtab;


/* Function/procedure prototypes. */
void P_cryst_mulmat_vderv(V F_mat, V F_pax, V F_pay, V F_paz, V F_vec);
void P_cryst_phase_compute(V F_p);
void P_cryst_data_complete(V F_p);
void P_cryst_group_set(V F_p);
void P_queue_object(V *F_frs, V *F_lst, V F_nod);
G P_fo_value(V F_p);


/* Procedure/Function : " insert_der "  */
void MXD_TREINIT_PRC_00000000(V F_vp){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=124; /* line # 124 */
  Rv0=((SL *)F_vp)[4];
  Ra.sl[3]=125; /* line # 125 */
  Rv1=-100;
  Ra.sl[3]=126; /* line # 126 */
  Rv2=Lx[0].v[0];
  Ra.sl[3]=127; /* line # 127 */
  Rv3=NULL;
  Ra.sl[3]=128; /* line # 128 */
  Rv4=0;
  Ra.sl[3]=129; /* line # 129 */
  while (Rv2!=NULL&&!Rv4){
    Ra.sl[3]=131; /* line # 131 */
    Rv1=((SL *)((V *)Rv2)[1])[4];
    Ra.sl[3]=132; /* line # 132 */
    Rv4=Rv0<=Rv1;
    Ra.sl[3]=133; /* line # 133 */
    if (!Rv4) {
      Rv3=Rv2;
      Rv2=((V *)Rv2)[0];
    }
  }
  Ra.sl[3]=135; /* line # 135 */
  if (Rv1!=Rv0) {
    Ra.sl[3]=137; /* line # 137 */
    Rv5=PAS__NEW(16);
    Ra.sl[3]=138; /* line # 138 */
    ((V *)Rv5)[0]=Rv2;
    Ra.sl[3]=139; /* line # 139 */
    ((V *)Rv5)[1]=F_vp;
    Ra.sl[3]=140; /* line # 140 */
    ((G *)Rv5)[1]=0.000000000000000E-001;
    Ra.sl[3]=141; /* line # 141 */
    if (Rv3==NULL) Lx[0].v[0]=Rv2;
    else {
      Ra.sl[3]=142; /* line # 142 */
      ((V *)Rv3)[0]=Rv2;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " look_var "  */
void MXD_TREINIT_PRC_00000001(V F_tp, UB F_bvok){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+70;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=163; /* line # 163 */
  Rv0=2;
  Ra.sl[3]=164; /* line # 164 */
  Rv1=F_tp;
  Ra.sl[3]=165; /* line # 165 */
  switch (((UB *)Rv1)[0]) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 11:
    case 12:Ra.sl[3]=170; /* line # 170 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],0);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],0);
    break;
    case 9:
    case 10:Ra.sl[3]=173; /* line # 173 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],F_bvok);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],F_bvok);
    break;
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:Ra.sl[3]=177; /* line # 177 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],F_bvok);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],F_bvok);
    break;
    case 19:
    case 20:
    case 21:
    case 22:Ra.sl[3]=181; /* line # 181 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],0);
    break;
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:Ra.sl[3]=189; /* line # 189 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],F_bvok);
    break;
    case 40:Ra.sl[3]=192; /* line # 192 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],F_bvok);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],0);
    break;
    case 41:Ra.sl[3]=195; /* line # 195 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],0);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],F_bvok);
    break;
    case 43:Ra.sl[3]=198; /* line # 198 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[3],F_bvok);
    break;
    case 42:Ra.sl[3]=201; /* line # 201 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],F_bvok);
    break;
    case 44:Ra.sl[3]=205; /* line # 205 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],0);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],0);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[3],0);
    Ra.sl[3]=206; /* line # 206 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[5],F_bvok);
    break;
    case 45:Ra.sl[3]=209; /* line # 209 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[5],F_bvok);
    break;
    case 46:
    case 47:Ra.sl[3]=213; /* line # 213 */
    Rv2=((SL *)((V *)Rv1)[1])[0];
    Ra.sl[3]=214; /* line # 214 */
    Rv3=0;
    Ra.sl[3]=215; /* line # 215 */
    while (Rv3<Rv2){
      Ra.sl[3]=217; /* line # 217 */
      MXD_TREINIT_PRC_00000001(((V *)((V *)Rv1)[1])[Rv3+1],F_bvok);
      Ra.sl[3]=218; /* line # 218 */
      Rv3=Rv3+1;
    }
    Ra.sl[3]=220; /* line # 220 */
    if (((UB *)Rv1)[1]) {
      Ra.sl[3]=222; /* line # 222 */
      Rv4=((V *)((V *)Rv1)[1])[Rv2+1];
      Ra.sl[3]=223; /* line # 223 */
      ((UB *)Rv1)[1]=0;
      Ra.sl[3]=224; /* line # 224 */
      if (((UB *)Rv1)[0]==47) Rv4=((V *)Rv4)[7];
      Ra.sl[3]=225; /* line # 225 */
      MXD_TREINIT_PRC_00000001(((V *)Rv4)[7],F_bvok);
      Ra.sl[3]=227; /* line # 227 */
      ((UB *)Rv1)[1]=1;
    }
    break;
    case 49:Ra.sl[3]=233; /* line # 233 */
    Rv5=0;
    for( Rf0=((SL *)((V *)Rv1)[2])[0]+1;Rf0>0;Rf0-- ) {
      MXD_TREINIT_PRC_00000001(((V *)((V *)Rv1)[2])[Rv5+1],Rv5>0&&F_bvok);
      Rv5++;
    }
    break;
    case 48:Ra.sl[3]=236; /* line # 236 */
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[1],0);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[2],F_bvok);
    MXD_TREINIT_PRC_00000001(((V *)Rv1)[3],F_bvok);
    break;
    case 54:Ra.sl[3]=239; /* line # 239 */
    switch (((UB *)Rv1)[1]) {
      case 1:
      case 2:
      case 3:
      case 14:
      case 46:
      case 47:
      case 48:
      case 50:
      case 51:
      case 52:
      case 53:Ra.sl[3]=245; /* line # 245 */
      Rv0=3;
      break;
      case 4:
      case 5:
      case 6:
      case 10:Ra.sl[3]=249; /* line # 249 */
      Rv0=4;
      break;
      case 7:
      case 8:
      case 9:Ra.sl[3]=252; /* line # 252 */
      Rv0=5;
      break;
      case 24:
      case 25:
      case 26:Ra.sl[3]=255; /* line # 255 */
      Rv0=6;
      break;
      case 11:
      case 12:
      case 13:Ra.sl[3]=258; /* line # 258 */
      Rv0=9;
      break;
      case 56:
      case 57:
      case 58:
      case 59:Ra.sl[3]=262; /* line # 262 */
      Rv0=14;
      break;
      default:break;
    }
    break;
    case 59:Ra.sl[3]=269; /* line # 269 */
    MXD_TREINIT_PRC_00000000(F_tp);
    Ra.sl[3]=270; /* line # 270 */
    Rv0=((UB *)Rv1)[2];
    break;
    case 57:Ra.sl[3]=275; /* line # 275 */
    ((SL *)Rv1)[7]=0;
    Ra.sl[3]=276; /* line # 276 */
    if (((SL *)Rv1)[6]!=0) {
      Ra.sl[3]=278; /* line # 278 */
      MXD_TREINIT_PRC_00000000(F_tp);
      Ra.sl[3]=279; /* line # 279 */
      Rv0=7;
    }
    break;
    case 58:Ra.sl[3]=285; /* line # 285 */
    Rv6=((V *)Rv1)[8];
    Ra.sl[3]=286; /* line # 286 */
    while (Rv6!=NULL){
      Ra.sl[3]=287; /* line # 287 */
      MXD_TREINIT_PRC_00000000(((V *)Rv6)[1]);
      Rv6=((V *)Rv6)[0];
    }
    Ra.sl[3]=288; /* line # 288 */
    Rv0=((UB *)Rv1)[21];
    break;
    case 64:Ra.sl[3]=293; /* line # 293 */
    switch ((UB)((SL *)Rv1)[1]) {
      case 2:Ra.sl[3]=294; /* line # 294 */
      Rv0=5;
      break;
      case 3:Ra.sl[3]=295; /* line # 295 */
      Rv0=6;
      break;
      case 4:Ra.sl[3]=296; /* line # 296 */
      Rv0=9;
      break;
      case 10:Ra.sl[3]=297; /* line # 297 */
      Rv0=7;
      break;
      case 11:
      case 15:
      case 17:
      case 18:Ra.sl[3]=301; /* line # 301 */
      Rv0=7;
      break;
      default:Ra.sl[3]=303; /* line # 303 */
      Rv4=NULL;
      break;
    }
    break;
    default:break;
  }
  Ra.sl[3]=310; /* line # 310 */
  switch (Rv0) {
    case 4:
    case 5:
    case 6:Ra.sl[3]=312; /* line # 312 */
    if (Lx[0].ub[4]==7) Lx[0].ub[4]=8;
    else {
      Ra.sl[3]=313; /* line # 313 */
      if (Rv0>Lx[0].ub[4]) Lx[0].ub[4]=Rv0;
    }
    break;
    case 7:Ra.sl[3]=315; /* line # 315 */
    if (Lx[0].ub[4]>=3&&Lx[0].ub[4]<=6) Lx[0].ub[4]=8;
    else {
      Ra.sl[3]=316; /* line # 316 */
      if (Rv0>Lx[0].ub[4]) Lx[0].ub[4]=Rv0;
    }
    break;
    case 1:Ra.sl[3]=318; /* line # 318 */
    if (Lx[0].ub[4]<=2) Lx[0].ub[4]=1;
    break;
    default:Ra.sl[3]=320; /* line # 320 */
    if (Rv0>Lx[0].ub[4]) Lx[0].ub[4]=Rv0;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tree_set_deriv "  */
void P_tree_set_deriv(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[3]=Rd.s+80;
  Ra.v[4]=Rd.s+12;
  Ra.sl[5]=327; /* line # 327 */
  Rv0=0;
  for( Rf0=16;Rf0>0;Rf0-- ) {
    Ra.v[Rv0+4]=NULL;
    Rv0++;
  }
  Ra.sl[5]=330; /* line # 330 */
  Rv1=V_parhde;
  Ra.sl[5]=331; /* line # 331 */
  while (Rv1!=NULL){
    Ra.sl[5]=333; /* line # 333 */
    Ra.ub[4]=2;
    Ra.sl[5]=334; /* line # 334 */
    Ra.v[0]=NULL;
    Ra.sl[5]=335; /* line # 335 */
    Rv2=Rv1;
    Ra.sl[5]=337; /* line # 337 */
    MXD_TREINIT_PRC_00000001(((V *)Rv2)[6],1);
    Ra.sl[5]=338; /* line # 338 */
    ((V *)Rv2)[8]=Ra.v[0];
    Ra.sl[5]=339; /* line # 339 */
    ((UB *)Rv2)[21]=Ra.ub[4];
    Ra.sl[5]=341; /* line # 341 */
    if (Ra.ub[4]==1) {
      Ra.sl[5]=343; /* line # 343 */
      switch (((UB *)Rv2)[1]) {
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:break;
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
        case 39:
        case 40:
        case 41:
        case 42:
        case 43:
        case 44:
        case 45:
        case 46:
        case 47:
        case 48:
        case 49:break;
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:
        case 58:
        case 59:
        case 60:
        case 61:
        case 62:
        case 63:
        case 64:
        case 65:
        case 66:
        case 67:
        case 68:
        case 69:
        case 70:
        case 71:
        case 72:
        case 73:break;
        default:break;
      }
    }
    else {
      Ra.sl[5]=355; /* line # 355 */
      if (Ra.v[Ra.ub[4]+4]==NULL) V_pardhde.v[Ra.ub[4]-2]=Rv1;
      else {
        Ra.sl[5]=356; /* line # 356 */
        ((V *)Ra.v[Ra.ub[4]+4])[7]=Rv1;
      }
      Ra.sl[5]=357; /* line # 357 */
      Ra.v[Ra.ub[4]+4]=Rv1;
      ((V *)Rv2)[7]=NULL;
    }
    Ra.sl[5]=360; /* line # 360 */
    Rv1=((V *)Rv1)[1];
  }
  PAS__curr_cntx=Ra.v[2];
  Lx[0]=Lx_Sv;
}


/* Procedure/Function : " gval_init "  */
void MXD_TREINIT_gval_init(V F_p, G *F_v, UB *F_f){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+96;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=368; /* line # 368 */
  if (F_p==NULL) {
    (*F_v)=0.000000000000000E-001;
    (*F_f)=1;
  }
  else {
    Ra.sl[3]=370; /* line # 370 */
    Rv0=F_p;
    Ra.sl[3]=372; /* line # 372 */
    if (((UB *)Rv0)[21]==2) (*F_f)=1;
    else {
      Ra.sl[3]=373; /* line # 373 */
      ((G *)Rv0)[5]=P_fo_value(((V *)Rv0)[6]);
      (*F_f)=0;
    }
    Ra.sl[3]=374; /* line # 374 */
    (*F_v)=((G *)Rv0)[5];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wave_init "  */
void MXD_TREINIT_wave_init(V F_pw){
  /* Define the automatic variable space. */
  Blk( Ra, 24 );

  /* Local variable stored in C variable */
  register V Rv0;
  UB Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+107;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=386; /* line # 386 */
  Rv0=F_pw;
  Ra.sl[3]=388; /* line # 388 */
  Rv1=1;
  Ra.sl[3]=389; /* line # 389 */
  Rv2=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    MXD_TREINIT_gval_init(((V *)Rv0)[(Rv2-1)+7],(((G *)Rv0)+Rv2+4),(Ra.ub+Rv2+15)
    );
    Rv2++;
  }
  Ra.sl[3]=391; /* line # 391 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+118,-1,-1,32);
  PAS__WRITE_STR(((V *)Rv0)[3],-1,-1,32);
  PAS__WRITE_STR(Rd.s+138,-1,-1,32);
  PAS__WRITE_STR(((V *)((V *)Rv0)[6])[3],-1,-1,32);
  PAS__WRITE_STR(Rd.s+152,-1,-1,32);
  Ra.sl[3]=392; /* line # 392 */
  Rv3=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=394; /* line # 394 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_CHAR(32);
    PAS__WRITE_DBLE(((G *)Rv0)[Rv3+4],6,4,0);
    PAS__WRITE_CHAR(32);
    Ra.sl[3]=395; /* line # 395 */
    if (Ra.ub[Rv3+15]) {
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+160,-1,-1,32);
    }
    else {
      Ra.sl[3]=396; /* line # 396 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+164,-1,-1,32);
    }
    Rv3++;
  }
  Ra.sl[3]=398; /* line # 398 */
  if (Rv1) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+168,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  else {
    Ra.sl[3]=399; /* line # 399 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+181,-1,-1,32);
    PAS__WRITE_EOLN();
  }
  Ra.sl[3]=401; /* line # 401 */
  Rv4=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Rv5=1;
    for( Rf0=6;Rf0>0;Rf0-- ) {
      ((G *)Rv0)[Rv4*7+Rv5+1]=0.000000000000000E-001;
      Rv5++;
    }
    Rv4++;
  }
  Ra.sl[3]=402; /* line # 402 */
  ((UB *)Rv0)[232]=Rv1;
  Ra.sl[3]=403; /* line # 403 */
  P_cryst_mulmat_vderv(((V *)Rv0)[6]+2072,((V *)Rv0)[7],((V *)Rv0)[8],((V *)Rv0)
  [9],Rv0+64);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " phases_and_data_init "  */
void P_phases_and_data_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+200;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=417; /* line # 417 */
  V_cphas=V_phashde;
  Ra.sl[3]=418; /* line # 418 */
  while (V_cphas!=NULL){
    Ra.sl[3]=420; /* line # 420 */
    P_cryst_phase_compute(V_cphas);
    Ra.sl[3]=421; /* line # 421 */
    P_cryst_group_set(V_cphas);
    Ra.sl[3]=422; /* line # 422 */
    V_cwave=((V *)V_cphas)[8];
    Ra.sl[3]=423; /* line # 423 */
    while (V_cwave!=NULL){
      Ra.sl[3]=425; /* line # 425 */
      MXD_TREINIT_wave_init(V_cwave);
      Ra.sl[3]=426; /* line # 426 */
      V_cwave=((V *)V_cwave)[1];
    }
    Ra.sl[3]=429; /* line # 429 */
    V_cphas=((V *)V_cphas)[1];
  }
  Ra.sl[3]=431; /* line # 431 */
  V_cphas=V_phashde;
  Ra.sl[3]=433; /* line # 433 */
  V_cdata=V_datahde;
  Ra.sl[3]=434; /* line # 434 */
  while (V_cdata!=NULL){
    Ra.sl[3]=436; /* line # 436 */
    P_cryst_data_complete(V_cdata);
    Ra.sl[3]=437; /* line # 437 */
    V_cdata=((V *)V_cdata)[1];
  }
  Ra.sl[3]=439; /* line # 439 */
  V_cdata=V_datahde;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lsq_vectmat_alloc "  */
void P_lsq_vectmat_alloc(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  V Rv5;
  register V Rv6;
  register SL Rv7;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+222;
  Ra.v[2]=Rd.s+12;
  Ra.sl[3]=458; /* line # 458 */
  V_itopvect=0;
  Ra.sl[3]=460; /* line # 460 */
  V_varnb=0;
  Ra.sl[3]=461; /* line # 461 */
  Rv0=0;
  Ra.sl[3]=462; /* line # 462 */
  Rv1=NULL;
  Ra.sl[3]=463; /* line # 463 */
  V_varhde=NULL;
  Ra.sl[3]=464; /* line # 464 */
  V_cdblk=V_dblkhde;
  Ra.sl[3]=465; /* line # 465 */
  V_cvarbl=V_gvarhde;
  Ra.sl[3]=466; /* line # 466 */
  while (V_cvarbl!=NULL){
    Ra.sl[3]=467; /* line # 467 */
    Rv2=V_cvarbl;
    Ra.sl[3]=469; /* line # 469 */
    if (((SL *)Rv2)[6]==1&&((SL *)Rv2)[7]==0) {
      Ra.sl[3]=472; /* line # 472 */
      V_varnb=V_varnb+1;
      Ra.sl[3]=473; /* line # 473 */
      ((SL *)Rv2)[6]=V_varnb;
      Ra.sl[3]=474; /* line # 474 */
      ((SL *)Rv2)[7]=V_varnb;
      Ra.sl[3]=475; /* line # 475 */
      ((V *)Rv2)[2]=V_varhde;
      Ra.sl[3]=476; /* line # 476 */
      if (Rv1==NULL) V_varhde=V_cvarbl;
      else {
        Ra.sl[3]=477; /* line # 477 */
        ((V *)Rv1)[2]=V_cvarbl;
      }
      Ra.sl[3]=478; /* line # 478 */
      Rv1=V_cvarbl;
    }
    Ra.sl[3]=481; /* line # 481 */
    if (V_cdblk!=NULL) {
      Ra.sl[3]=482; /* line # 482 */
      if (((V *)V_cdblk)[9]==V_cvarbl) {
        Ra.sl[3]=483; /* line # 483 */
        Rv3=V_cdblk;
        Ra.sl[3]=485; /* line # 485 */
        Rv4=V_varnb-Rv0;
        Ra.sl[3]=486; /* line # 486 */
        ((SL *)Rv3)[6]=Rv4;
        Ra.sl[3]=488; /* line # 488 */
        Rv0=V_varnb;
        Ra.sl[3]=489; /* line # 489 */
        V_cdblk=((V *)Rv3)[1];
        Ra.sl[3]=491; /* line # 491 */
        V_itopvect=V_itopvect+(Rv4*(Rv4+1))/2;
        Ra.sl[3]=493; /* line # 493 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+241,-1,-1,32);
        PAS__WRITE_STR(((V *)Rv3)[3],-1,-1,32);
        PAS__WRITE_STR(Rd.s+273,-1,-1,32);
        PAS__WRITE_INT(((SL *)Rv3)[6],0,0);
        PAS__WRITE_EOLN();
      }
    }
    Ra.sl[3]=496; /* line # 496 */
    V_cvarbl=((V *)Rv2)[1];
  }
  Ra.sl[3]=501; /* line # 501 */
  if (V_varnb>Rv0) {
    Ra.sl[3]=503; /* line # 503 */
    Rv5=PAS__NEW(40);
    Ra.sl[3]=504; /* line # 504 */
    Rv6=Rv5;
    Ra.sl[3]=506; /* line # 506 */
    ((UB *)Rv6)[0]=62;
    Ra.sl[3]=507; /* line # 507 */
    ((V *)Rv6)[1]=NULL;
    Ra.sl[3]=508; /* line # 508 */
    ((V *)Rv6)[2]=NULL;
    Ra.sl[3]=509; /* line # 509 */
    ((V *)Rv6)[3]=PAS__NEW(17);
    ((UB *)((V *)Rv6)[3])[0]=15;
    Ra.sl[3]=510; /* line # 510 */
    PAS__STR_TO_STR(((V *)Rv6)[3],Rd.s+285);
    Ra.sl[3]=511; /* line # 511 */
    ((SL *)Rv6)[4]=0;
    Ra.sl[3]=512; /* line # 512 */
    ((UB *)Rv6)[20]=14;
    Ra.sl[3]=513; /* line # 513 */
    Rv4=V_varnb-Rv0;
    Ra.sl[3]=514; /* line # 514 */
    ((SL *)Rv6)[6]=Rv4;
    Ra.sl[3]=515; /* line # 515 */
    ((V *)Rv6)[8]=V_pcte_one;
    Ra.sl[3]=516; /* line # 516 */
    ((V *)Rv6)[8]=V_pcte_one;
    Ra.sl[3]=517; /* line # 517 */
    ((V *)Rv6)[9]=Rv1;
    Ra.sl[3]=519; /* line # 519 */
    V_itopvect=V_itopvect+(Rv4*(Rv4+1))/2;
    Ra.sl[3]=521; /* line # 521 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+302,-1,-1,32);
    PAS__WRITE_STR(((V *)Rv6)[3],-1,-1,32);
    PAS__WRITE_STR(Rd.s+342,-1,-1,32);
    PAS__WRITE_INT(((SL *)Rv6)[6],0,0);
    PAS__WRITE_EOLN();
    Ra.sl[3]=525; /* line # 525 */
    P_queue_object(&V_dblkhde, &V_dblklst, Rv5);
  }
  Ra.sl[3]=528; /* line # 528 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+354,-1,-1,32);
  PAS__WRITE_INT(V_varnb,0,0);
  PAS__WRITE_STR(Rd.s+367,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[3]=533; /* line # 533 */
  V_idervec=V_itopvect;
  V_itopvect=V_itopvect+V_varnb;
  Ra.sl[3]=534; /* line # 534 */
  V_ishfvec=V_itopvect;
  V_itopvect=V_itopvect+V_varnb;
  Ra.sl[3]=535; /* line # 535 */
  V_ishfvec=V_itopvect;
  V_itopvect=V_itopvect+V_varnb;
  Ra.sl[3]=537; /* line # 537 */
  Rv7=V_itopvect;
  V_mdtab=PAS__NEW(Rv7*8+8);
  ((SL *)V_mdtab)[0]=Rv7;
  Ra.sl[3]=539; /* line # 539 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+389,-1,-1,32);
  PAS__WRITE_INT(V_itopvect,0,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}
