{ %pragma listlvl:2; }
{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



*******************************************************************************
*                                                                             *
*                                                                             *
*     MXD   Expression  and  Crystallographic  Object  Tree   Environment     *
*                                                                             *
*                                                                             *
*******************************************************************************


}


{****************     CPAS  version    *****************}
{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}

 %include     'pasenv:cpas_b__lst_env'; { Load the Listing environment. }

 %include     'pasenv:cpas_b__err_env'; { Load the Error message environment. }

 %include             'MXDSRC:mxd_env'; { Load the mxd global environment }

 %include      'MXDSRC:mxd_tree_codes'; { Get all codes of pcdf file to handle various ITEMs, DIRECTIVEs and COEFFICIENTs }



const

  mxd_tree_errfspc = 'mxd_tree.err_msg';{ Error message file for MXD_TREE Loader }
  mxd_setenvf      = 'MXDLIB:mxd_dcp.std_env'; { Standard Environment Setup file name (of MXD_DCP) }

  maxsel           =                64; { Maximum number of parameter in a select function }

  pcdf_mxd_name    =    'mxd_dcp.pcdf'; { MXD Pcode Default Statement File Name }

  parmcat_max      =                 7; { Maximum number of parameter evaluation categories }



type

  { * *  Define the node graph architecture  * * }

  nod_operty = (
      op_eq,       op_ne,       op_lt,  { All binary operator without ... }
      op_le,       op_ge,       op_gt,  { ... derivate specific float }
     op_and,      op_xor,       op_or,
     op_add,      op_sub,      op_mod,
     op_rem,     op_idiv,

     op_mul,      op_div,      op_pow,  { All binary operator with ... }
  op_phaser,   op_phased,               { ... derivate specific floats }

     op_not,      op_neg,    op_trunc,  { All unary operator without ... }
   op_round,                            { ... derivate specific float }

    op_sinr,     op_cosr,     op_tanr,  { All unary operator with ... }
   op_asinr,    op_acosr,    op_atanr,  { ... derivate specific float }
    op_sind,     op_cosd,     op_tand,
   op_asind,    op_acosd,    op_atand,
     op_exp,       op_ln,     op_tanh,
     op_abs,     op_sqrt,

     op_ipw,                            { Integer power }
   op_bessj,                            { Bessel function Bj }
op_interpol,                            { Table interpolation function }
  op_integr,                            { Integration function }
    op_summ,                            { Summation function }
  op_sumobs,                            { Observation data summation function }
 op_funcall,                            { User formula LSQ function Call }
op_formcall,                            { User formula LSQ function formal Call }
   op_ifsel,                            { Select by logical condition }
  op_select,                            { Selection function operator }
    op_call,                            { Call LSQ function -- not operational }
  op_return,                            { Return of Call LSQ function -- not operational }
   op_konst,                            { Constant value }
  op_tabref,                            { Table reference node }
   op_coeff,                            { Application Value == Internal application reference }
  op_adatfl,                            { Additional Data Field node }

  op_usrfun,                            { LSQ usr formula Function }
   op_varbl,                            { LSQ Variable node }
    op_parm,                            { LSQ Parameter (expression) node }
 op_virtvar,                            { LSQ Virtual variable node }
   op_index,                            { Loop index node }
  op_formal,                            { Formal argument node }
    op_item,                            { Item references node }
    op_data,                            { Data item reference }
  op_citmrf,                            { Current item field reference }
    op_noop,                            { No operation }
    op_null                             { Special Use of Tree Builder }
  );


  itm_kinds  = (                        { * Define all managed object types * }
    itm_varbl,                          { Refined Variable }
    itm_parm,                           { Expression Parameter }
    itm_index,                          { Index Loop }
    itm_formal,                         { LSQ user function formal }
    itm_function,                       { LSQ user function }
    itm_phase,                          { Cristal. Phase item }
    itm_atmgroup,                       { Partial contribution }
    itm_atom,                           { Atom }
    itm_wave,                           { Wave vector }
    itm_npola,                          { Neutron polarization direction }
    itm_moment,                         { Magnetic moment }
    itm_mdsdsp,                         { Modulated atom shift }
    itm_data,                           { Item Data collection }
    itm_sftcte,                         { Soft constante = constraint }
    itm_lsqblk,                         { Least-Squares diagonal block }
    itm_symtry                          { Symetry operator }
  );

  itmd_kinds = (                        { * Define the various kind of data * }
    itmd_hkl_xf2,                       { X-Ray F2 (Squared Structure factor magnitude) HKL based data }
    itmd_hkl_nf2,                       { Neutrons F2 (Squared Structure factor magnitude) HKL based data }
    itmd_hkl_xsf,                       { X-Ray SF (Structure factor magnitude) HKL based data }
    itmd_hkl_nsf,                       { Neutrons SF (Structure factor magnitude) HKL based data }
    itmd_hkl_xray,                      { X-Ray RAY (Powder diffraction line intensity - with packet management) HKL based data }
    itmd_hkl_nray,                      { Neutrons RAY (Powder diffraction line intensity - with packet management) HKL based data }
    itmd_xprofil,                       { X-Ray Profile refinement - ///for a possible future implementation/// }
    itmd_nprofil,                       { Neutrons Profile refinement - ///for a possible future implementation/// }
    itmd_curve                          { Curve (user defined function) to fit }
  );


  prmc_categ = (        { * Define the LSQ_PARM Category * }
    prmc_allparm,       { All LSQ_PARM EVAL }
    prmc_itmblk,        { LSQ_PARM evaluation driven by a specific item block evaluation }
    prmc_init,          { LSQ_PARM to evaluate on init time only }
    prmc_data,          { LSQ_PARM to evaluate when a new data is loaded }
    prmc_datc,          { LSQ_PARM to evaluate when a new data is loaded if the unit cell is not fixed (profile fit) }
    prmc_datw,          { LSQ_PARM is depending of data record and Wave vector }
    prmc_datp,          { LSQ_PARM is depending of data record and neutron polarization direction }
    prmc_varb,          { LSQ_PARM is depending of some variable and must be evaluated before each LSQ cycle }
    prmc_stp0,          { LSQ_PARM to evaluate before each data record computing }
    prmc_dats,          { LSQ_PARM is depending of data record and symtry operator }
    prmc_stp1,          { LSQ_PARM to evaluate summation step #1 of record computing ($FN2 or $FM2 dep.) }
    prmc_stp2,          { LSQ_PARM to evaluate summation step #2 of record computing ($F2POLA dep.) }
    prmc_stp3,          { LSQ_PARM to evaluate summation step #3 of record computing ($CALC dep.) }
    prmc_stp4,          { LSQ_PARM to evaluate after each data record computing }
    prmc_stpf,          { LSQ_PARM to evaluate on end of cycle }
    prmc_end            { LSQ_PARM to evaluate on final cycle time only }
  );

  cell_grpstr = record  { Pseudo String to skip a CPAS V2.1L bug }
    length: byte;
    body: array[1..15] of char
  end;

  cell_flagtyp = (
    celf_toinit,        { Unit cell to init }
    celf_fixed,         { Unit cell is fixed }
    celf_recip,         { The User unit cell was a reciprocal unit cell }
    celf_rhomb,         { Work space is rhomboedric }
    celf_center         { The center (symetry center at origine) mode is set }
  );

  cell_flagsty = set of cell_flagtyp;   { * Define the Cell Flags word type }

  ptr   =   ^nod_record;                { * Define the node pointer * }

  der_ptr   =  ^der_rec;                { * Define the derivation block pointer * }

  der_rec = record                      { * Define the derivation block record * }
    der_next:                  der_ptr; { Link to the next partial derivate block }
    der_var:                       ptr; { Link to the attached variable }
    der_val:                   mxd_flt  { Last value of the derivate }
  end;

  vect3d_typ =  array[1..3] of mxd_flt; { Define a 3D vector }

  tbty_vder  =  array[0..6] of mxd_flt; { Table for unit dependante value and related partial derivate (for 6 (virtual) variable) }

  tbty_valu = array[1..1] of tbty_vder; { Allocation for 1 (virtual) variable and its partial derivates (cell dependante) }
  tbty_vect = array[1..3] of tbty_vder; { Vector Allocation (for 6 (virtual) variable }
  tbty_parm = array[1..6] of tbty_vder; { Parameter and Metric tensor allocation (for 6 (virtual) variable) }

  tbty_tmat = array[1..9] of tbty_vder; { Matrix allocation (always for 6 (virtual) variable)  }


  cell_rec = record                     { * Define the cell (metric and symmetry) record * }
    cell_duc,  cell_ruc,                { Direct and Reciprocal Unit Cell }
    cell_dmt,  cell_rmt:     tbty_parm; { Direct and Reciprocal Metric Tensors }
    cell_dvol, cell_rvol:    tbty_valu; { Direct and Reciprocal Unit cell volume }
    cell_dcmt, cell_rcmt:    tbty_tmat; { Direct and Reciprocal Cartesian reference matrix change }
    cell_ngroup:               integer; { Space group number or - lattice code 0/-1/-2/-3/-4/-5/-6/-7 for P/A/B/C/I/F/H/R }
    cell_group:            cell_grpstr; { Space group name - or - lattice letter }
    cell_flags:           cell_flagsty  { Flag word for cell characteristics }
  end;

  { Define a variable selection table }
  ptr_table( size: integer ) = array[0..size] of ptr;

  lim_record = record                   { * Define a LSQ Variable limit block * }
    lim_inf, lim_sup: mxd_flt
  end;

  lim_ptr = ^lim_record;                { * Define the limit block pointer * }

  nod_record = record                   { * Define the node record * }
    case nod_typ: nod_operty of         { The operator code }
      op_eq,     op_ne,     op_lt,      { All binary operator without ... }
      op_le,     op_ge,     op_gt,      { ... derivate specific float }
      op_and,    op_xor,    op_or,
      op_add,    op_sub,    op_mod,
      op_rem:(
        nod_bin1, nod_bin2:        ptr
      );

      op_mul,    op_div,    op_pow,     { All binary operator with ... }
      op_phaser, op_phased:(            { ... derivate specific floats }
        nod_bind1, nod_bind2:      ptr;
        nod_vbin1, nod_vbin2:  mxd_flt
      );

      op_not,    op_neg,    op_trunc,   { All unary operator without ... }
      op_round:(                        { ... derivate specific float }
        nod_una:                   ptr
      );

      op_sinr,   op_cosr,   op_tanr,    { All unary operator with ... }
      op_asinr,  op_acosr,  op_atanr,   { ... derivate specific float }
      op_sind,   op_cosd,   op_tand,
      op_asind,  op_acosd,  op_atand,
      op_exp,    op_ln,     op_tanh,
      op_abs,    op_sqrt:(
        nod_unad:                  ptr;
        nod_vuna:              mxd_flt
      );

      op_ipw:(                          { Integer power }
        nod_iwo,                        { Argument x of x**i }
        nod_iwe:                   ptr; { Argument i of x**i }
        nod_vpw:               mxd_flt; { Keep value for derivation ... }
        nod_ipw:               integer  { ... and integer power }
      );

      op_bessj:(                        { Bessel function Bj (integer) }
        nod_bij_ne,                     { Order of Bessel function }
        nod_bij_xe:                ptr; { x of Bj( n, x ) }
        nod_bij_d:             mxd_flt; { Last df/dx value for derivation }
        nod_bij_n:             integer  { Keep last 2*n value for derivation }
      );

      op_interpol:(                     { Table interpolation function }
        nod_itpnxt,                     { Link between all interpol( <table>, $sithsl ) nodes }
        nod_itpexp:                ptr; { Expression of interpolation abscisse }
        nod_itptab:            ftb_ptr; { Interpolation table reference }
        nod_itpfco:            integer; { Index for suplementary data reference or 0 or -1 (normal interpalation) }
        nod_itpval,                     { X Value for interpolation }
        nod_itpder:            mxd_flt  { Partial derivate of interpolation }
      );

      op_integr:(                       { Integration function }
        nod_inttab:            ftb_ptr; { Integration table reference }
        nod_intvar,                     { Integration Variable }
        nod_intexpr:               ptr  { Expression to integrate }
      );

      op_summ:(                         { Summation function }
        nod_smlb, nod_smle, nod_smls,   { Summation loop index begin, end and step values }
        nod_smidx,                      { Summation loop index to use }
        nod_exp:                   ptr  { Summation expression object }
      );

      op_sumobs:(
        nod_osmv:              mxd_flt; { Summation value }
        nod_osmlnk,                     { Link to next sommation operator }
        nod_osmexp:                ptr  { Expression definition }
      );

      op_funcall, op_formcall:(         { Call LSQ functions -- temporary not operational }
        nod_parseflg:          boolean; { Flag to do not search dependance twice in LOOK_VAR }
        nod_arglist:        ^ptr_table  { Pointer to the user/function and argument pointer table }
      );

      op_select:(
        nod_selast:            integer; { Last selection index }
        nod_seltab:         ^ptr_table  { Pointer to the selection table }
      );

      op_ifsel:(
        nod_cond,                       { Condition expression }
        nod_wtrue,                      { Value when true }
        nod_wfalse:                ptr; { Value when false }
        nod_icnd:              integer  { Last condition value }
      );

      op_return:(                       { Return of Call LSQ function -- temporary not operational }
      );

      op_konst:(                        { Constant value }
        nod_val:               mxd_flt
       );

      op_coeff:(                        { Application Value == Internal application reference }
        nod_coeffid:       coef_codety  { Index of internal value }
      );

      op_adatfl:(                       { Additional Data Collection Field }
        nod_datname:           str_ptr; { Pointer to the user identifier name }
        nod_datsequ,                    { Integer identifier of the data field }
        nod_datoff:            integer  { Offset in the Data record }
      );

      op_tabref:(                       { Table reference }
        nod_tabide:            integer; { Table identifier index }
        nod_tabref:            ftb_ptr  { Pointer of float number Table }
      );

      op_citmrf:(                       { Current item field reference }
        nod_citmty,                     { Item code type to select the current pointer }
        nod_citmoff:           integer  { Field index }
      );

      op_virtvar:(                      { Virtual variable node }
        nod_vvsequ:        virt_codety; { Related sequence number }
        nod_vcateg:         prmc_categ; { Evaluation Category for the virtual variable }
        nod_curval:            mxd_flt  { Last value of the virtual variable }
      );

      op_usrfun,                        { LSQ Usr. Formulae Function }
      op_varbl,  op_parm,               { LSQ Variable node, LSQ Parameter (expression) node }
      op_index,  op_formal,             { Loop index node, LSQ user Function formal }
      op_item,   op_data:(              { All other Item references }
        itm_next,                       { Link to next item in the same type }
        itm_link:                  ptr; { Item Link to create the node graph }
        itm_name:              str_ptr; { Name of the object }
        itm_sequ:              integer; { Item sequence Number }
        case itm_kind: itm_kinds of
          itm_varbl:(                   { * LSQ Variable definitions * }
            var_orgidx,                 { Original and ... }
            var_matidx:        integer; { ... current matrix index }
            var_limptr:        lim_ptr; { Limit pointer }
            var_curval,                 { Current Value ... }
            var_cursig:        mxd_flt  { ... and sigma }
          );
          itm_parm:(                    { * LSQ Param definitions * }
            par_categ:      prmc_categ; { Evaluation Category for the LSQ_PARM }
            par_expres,                 { Parameter expression }
            par_catlnk:            ptr; { Evaluation list link }
            par_lstder:        der_ptr; { List of partial derivate value }
            par_actval,                 { Actual parameter value and sigma }
            par_actsig:        mxd_flt
          );
          itm_index:(                   { * Index definitions * }
            ind_val:           mxd_flt  { Index value }
          );
          itm_formal:(                  { * Formal definitions * }
            for_next,                   { Link to next formal }
            for_link:              ptr  { Pointer to actual definition }
          );
          itm_function:(                { * Usr LSQ Function definitions * }
            frm_list,                   { List of formal }
            frm_exprv:             ptr  { Function expression definition }
          );
          itm_phase:(                   { * Phase definitions * }
            pha_symhde,                 { Symtry list head }
            pha_symlst,
            pha_wavhde,                 { Wave Vector list head }
            pha_wavlst,
            pha_polhde,                 { Polarization Direction Vector list head }
            pha_pollst,
            pha_agrhde,                 { Atom/Atom_Group list head }
            pha_agrlst,
            pha_atmhde,                 { Atom list head }
            pha_atmlst,
            pha_momhde,                 { Magnetic Moments list head }
            pha_momlst,
            pha_dsphde,                 { Modulated Displacments Moment list head }
            pha_dsplst:             ptr;
            pha_par:array[0..6] of ptr; { Scale, Unit cell }
            pha_cell:          cell_rec { Unit Cell Data record }
          );
          itm_atmgroup:(                { * Partial group definitions * }
            atg_next,                   { Link to the next contribution in the same phase/contribution }
            atg_owner,                  { Link to the contribution owner }
            atg_atmhde,                 { Atom/Contribution list head in this atom group }
            atg_atmlst,
            atg_momhde,                 { Magnetic Moments list head in this atom group }
            atg_momlst,
            atg_dsphde,                 { Modulated Displacments list head in this atom group }
            atg_dsplst:            ptr;
            atg_calc,
            atg_calc2,                  { Additional for flipping ratio }
            atg_cnr, atg_cni,           { Partial nuclear structure factor }
            atg_cxr, atg_cxi,           { Partial magnetic structure factor }
            atg_cyr, atg_cyi,
            atg_czr, atg_czi:  mxd_flt;
            atg_par:array[0..6] of ptr; { Related position matrix }
          );
          itm_atom:(                    { * Atom definitions * }
            atm_next,                   { Link of the next atom in the same phase/contribution }
            atm_lstmom, atm_lstdsp,     { Link to associated moments and/or disp.}
            atm_owner:             ptr; { Link to contribution/phase owner }
            atm_par:array[0..11] of ptr;{ Atom specifications }
            atm_bcart,                  { Flags of cartesian coord. & b anis. }
            atm_banis:          boolean
           );
          itm_wave:(                    { * Wave vector definitions * }
            wav_phase:             ptr; { Phase owner of the wave vector (relatif to the phase unit cell) }
            wav_par:array[0..2] of ptr; { Wave vector components in reciprocal cell reference }
            wav_hkl:        vect3d_typ; { Reciprocal cell relative Wave vector componantes }
            wav_vec:         tbty_vect; { Value and Derivate vector table when not fixed (else nil) }
            wav_fixed,                  { Flag for fixed Wave vector }
            wav_relflg: boolean         { Rational flag }
          );
          itm_npola:(                   { * Polarized neutron Magn. Field definitions * }
            npo_phase:             ptr; { Phase owner of the polarization direction description (relative to work space) }
            npo_par:array[0..6] of ptr; { Magnetic field components, efficiencies, pol.extinction coef. }
            npo_hx,                     { Keep the last value of field components }
            npo_hy,
            npo_hz:            mxd_flt
          );
          itm_moment:(                  { * Magnetic Moment definitions * }
            mom_next,                   { Associated wave vector if not nil }
            mom_wave:              ptr; { Link to next moment for the same atome }
            mom_par:array[0..6] of ptr; { Moment specifications }
           );
          itm_mdsdsp:(                  { * Modulated displacement definitions * }
            dsp_next,                   { Link to next dsp for the same atom }
            dsp_wave:              ptr; { Associated  wave vector }
            dsp_par:array[0..7] of ptr  { Modulated Displacement specifications }
          );
          itm_lsqblk:(                  { * Least-Squares Block definitions * }
            blk_vardim:        integer; { Size of block }
            blk_dyndmp,                 { Dynamic damping factor pointer }
            blk_dynmrq,                 { Dynamic marquward factor pointer }
            blk_lstvar:            ptr  { Pointer of the last variable of block }
          );
          itm_symtry:(                  { * Symtry Operator definitions * }
            sym_oper:       symtry_ope; { Symetry operator }
            sym_spmat:          matrix  { Additional matrix for hexa. cart. atom }
          );
          itm_sftcte:(                  { * Soft constraint definitions * }
            sfc_calc,                   { Computed value expression and ... }
            sfc_obs,                    { ... its related weight (that can be dynamic) }
            sfc_sig,                    { Observed value and ... }
            sfc_weight:            ptr  { ... its standard error }
          );
          itm_data:(                    { * HKL Data definitions * }
            dat_fname:         str_ptr; { Data file specification }
            dat_dywecoef:          ptr; { Dynamic weight coefficient }
            dat_addidtb:    ^ptr_table; { Additional Identifier Table to take in account }
            dat_nval,                   { Number of value in table }
            dat_nrec:          integer; { Number of data record }
            dat_active:        boolean; { Flag for active data }
            case dat_kind:itmd_kinds of { Kind of data }
              itmd_hkl_xf2, itmd_hkl_nf2,
              itmd_hkl_xsf, itmd_hkl_nsf,
              itmd_hkl_xray,
              itmd_hkl_nray:(           { * For all HKL based data * }
                dhkl_scale,             { Scale specification }
                dhkl_fn2corr,           { Correction factors for extinction }
                dhkl_fm2corr:      ptr;
                dhkl_nobs:     integer; { Number of observations (intensities) }
                dhkl_lambda,            { Main Wave length }
                dhkl_sobs,              { Summation of : observed intensities reflection, ... }
                dhkl_sobs2,             { ... squared intensities, ... }
                dhkl_swobs,             { ... weighted intensities, ... }
                dhkl_swobs2:   mxd_flt  { ... squared and weighted intensities }
              );
              itmd_xprofil,
              itmd_nprofil:(            { * For profil fitting - an HKL related data ///Not presently implemented/// *}
                dprf_nptr:     integer;
                dprf_lambda1,           { Main and secondary Wave Length }
                dprf_lambda2:  mxd_flt
              );
              itmd_curve:(              { * For curve/function data * }
                dcrv_fnc:          ptr; { The parametric function to fit }
                dcrv_sobs,              { Summation of observed Y and ... }
                dcrv_sobs2:    mxd_flt  { ... squared observed Y }
              )
      )
    )
  end;


  curr_dat_typ = record
    ih,  ik,  il,  nq,  mul, npo,
    nwv, npd, nph, isent,  selnb:              integer;
    he,  ke,  le,  hh,  kk,  ll,
    sh,  sk,  sl,   sithsl, obs, sig, wei:     mxd_flt;
    tbv:          array[1..max_dattab_size] of mxd_flt
  end;


  pardep_tab = array[prmc_init..prmc_categ"last] of ptr; { Dependance table for LSQ Expression (parameter) }

  cselecty = 0..maxsel;

  magselty = array[0..maxsel] of boolean;

  virtvtabty = array[virt_codety] of ptr;




[external]
var
  elpstim,                              { Total elapsed time }
  topcpu:                      integer; { Total cpu time }

  mxd_libdir,                           { Standard MXD Library directory }
  mxd_proc_name:                string; { MXD Process Name }

  interphde,                            { List of Interpol from $sithsl coef. nodes }

  sumhhde,                              { List of all hkl sum op. }
  tablhde,                              { List of all table }
  gvarhde,                              { List of all variables }
  varhde,                               { List of free variables }
  parhde,                               { List of parameters }
  usfuncthde,                           { List of user function }
  formalhde,                            { List of formal }
  loopidxhde,                           { List of loop index }

  phashde,                              { List of phases }
  freeblk,                              { List of unused lsq block }
  dblkhde,                              { List of diagonal blocks }
  datahde:                         ptr; { List of data collection }

  pardhde:                  pardep_tab; { Lists of dep. param in seven levels }

  curr_data:              curr_dat_typ; { Current data record in use }

  tmd, tmr:                     matrix; { Cell matrix transformation }

  refcatsv,                             { Neutron polarized index copy }
  nbfixed,                              { Count of fixed variables }
  latticenb,                            { Lattice identifier }
  nbcoll,                               { Total number of collect }
  ncpobs:                      integer; { Total number of data observations }

  bfmagnetic,                           { Flag founded magnetic statement }
  bflimited,                            { Flag existing variable limits }
  buiso,                                { Indicator of u isotropic mode }
  bcentric:                    boolean; { Indicator of centric mode }

  job_name,                             { Name of the Job }
  job_title,                            { Title for the job }
  sav_fname:                   str_ptr; { Save LSQ Variable file specification }

  pttl,                                 { Title pointer }
  psav:                        str_ptr; { Save variable filename pointer }


  rgf,  igf,                            { Geometrical factor }
  fnr,  fni,                            { Nuclear struc. factor }
  fxr,  fyr,  fzr,                      { Projected magnetic structure factor }
  fxi,  fyi,  fzi,
  rp1,  ip1,                            { Modulated occupency factor }
  fmxr, fmyr, fmzr,                     { No projected magn. structure factor save }
  fmxi, fmyi, fmzi,

  fnucl2,                               { Squared nuclear structure factor }
  fmag2,                                { Squared magnetic structure factor }
  fcalc2s,                              { Total saved squared part for pol. neu. }
  fcalc2,                               { Total squared structure factor }
  fstr,                                 { Computed none scaled data }
  delta,                                { Difference with observation }
  curint:                      mxd_flt; { Current structure factor }

  cvarbl,                               { Current variable for derivation }
  cformula,                             { Current formula node pointer }
  cparam,                               { Current variable parameter pointer }

  cphas,                                { Current phase pointer }
  csymt,                                { Current symtry matrix pointer }
  cwave,                                { Current wave vector pointer }
  cpola,                                { Current polarization dir. pointer }
  cagrp,                                { Current atome group pointer }
  catom,                                { Current atome pointer }
  cmome,                                { Current moment pointer }
  cmdsd,                                { Current mdsdsp pointer }
  cdblk,                                { Current diagonal block }
  cdata,                                { Current data item pointer }

  pcte_one:                        ptr; { Pointer to the ONE (1.0) constante mode }

  sumhlst,                              { List of all hkl sum op. }
  gvarlst,                              { List of all variables }
  varlst,                               { List of free variables }
  parlst,                               { List of parameters }
  usfunctlst,                           { List of user function }
  formallst,                            { List of formal }
  loopidxlst,                           { List of loop index }

  phaslst,                              { Last pointer of Phase List}
  dblklst,                              { Last pointer of Diagonal-Blocks List }
  datalst:                         ptr; { Last pointer of Data-Collection List }

  cselect:                    cselecty; { Current nature selector }

  iqwave,                               { Last number of wave vector ident }
  mxcateg,                              { Maximum reflexion family }
  ccateg:                      integer; { Current reflexion family }

  fatal_error,                          { Indicate stop on error }
  b132,                                 { Option of listing form }
  bshort_flst:                 boolean; { Option of short output list }


  varnb:                       integer; { Total number of variable }


  virtvtab:                 virtvtabty; { Virtual variable pointers table }


(*
  cdrec:              data_rec;         { Current bdt record }
  crrec:                outblk;         { Current binary computed F record }
*)
  { Input files }

  pcdf:                   text;         { Reverse polish instructions input }

{ idat:               bdt_file;         { Cristal data input }


{ Routines of MXD_APPL_RTL module }

procedure SET_LISTING_TITLE( in_var title: string );
external;
procedure SET_LISTING_SUBTITLE( in_var subtitle: string );
external;
procedure EXEC_ERROR( md: error_mdnam; nb: integer; sev: error_sev := e_fatal; in_var ide: [optional] string );
external;
procedure SEARCH_FILE( in_var path, fname: string; acc: integer; var re: string; var fnd: boolean );
external;
procedure OPEN_LISTING( in_var task_name, fnm: string; bsup, bdel: boolean := true );
external;
procedure NEWPARAGRAPHE( n: integer );
external;
procedure WRITECPU( ti: integer );
external;


{ Routines of MXD_CRYST_RTL module }

function  GVAL( p: ptr ): mxd_flt;
external;
procedure CRYST_MULMAT_VDERV( var mat: tbty_tmat; pax, pay, paz: ptr; var vec: tbty_vect );
external;
procedure CRYST_PHASE_COMPUTE( p: ptr );
external;
procedure CRYST_DATA_COMPLETE( p: ptr );
external;
procedure CRYST_GROUP_SET( p: ptr );
external;



{ Routines of MXD_TREE_BLD module }

function  GET_REFERENCE( nsequ: integer ): ptr;
external;
procedure INIT_TREE( in_var mxdnam: string );
external;
procedure QUEUE_OBJECT( var frs, lst: ptr; nod: ptr );
external;
procedure BUILDTREE( pcdf_name: string );
external;


{ Routines of MXD_TREE_INIT module }

procedure TREE_SET_DERIV;
external;
procedure PHASES_AND_DATA_INIT;
external;
procedure LSQ_VECTMAT_ALLOC;
external;


{ Routines of MXD_TREE_WRK module }

procedure UPDATE_VIRTVAR( var obj: array[sz: integer] of tbty_vder; vcd: virt_codety );
external;
function  FO_VALUE( p: ptr ): mxd_flt;
external;
function  FO_DERIV( p, q: ptr ): mxd_flt;
external;
procedure PARM_EVAL( ctg: prmc_categ );
external;


{ Routines of MXD_LSQ_MAIN program }

procedure SET_OPTION( npa: integer );
external;


{ Routines of MXD_LSQ_FIT module }

procedure ALLOC_LSQ_MATVECT;
external;

