{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/07/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*            MXD   TREE BUILDER CODE Generator   for   MXD_DCP                *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


program MXD_TREE_DCP;

  %include 'MXDSRC:mxd_tree_codes';     { Get all codes of pcdf file to handle various ITEMs, DIRECTIVEs and COEFFICIENTs }


const

  version = 'V 1.0';

var
  symbol,
  date_st,
  time_st: string( 22 );

  inb:          integer;

  line,
  fspc:          string;        { Output file specification }
  outf:            text;        { Output file for MXD_DCP }

{ ****************************  Begin of PASCAL System Code Section  **************************** }

%pragma code_option (c_interface,      { To authorize the use of "standard" keyword }
    c_code '#define _FILE_DUPLICATE(fdst,fsrc) fdst = fsrc'
  );


  procedure DUPLICATE_FILE( f1, f2: $wild_file ); standard '_FILE_DUPLICATE';
  procedure CLEAR_FILE( f: $wild_file ); standard '_FILE_CLEAR';

%pragma code_option noc_interface;              { To disable usage of "standard" keyword }

{ *****************************  End of PASCAL System Code Section  ***************************** }


  procedure OUT_DEF( in_var symbol: string; ch: char; iv: integer; cte: boolean := false );
  var
    i, j:       integer;
    st: [static] string;

  begin
    if ch > ' ' then
    begin
      st[1] :=  ch;
      st[2] := '$';
      j := 2
    end
    else j := 0;
    i := INDEX( symbol, '_' );
    while i < symbol.length do
    begin  j := j + 1; i := i + 1; st[j] := symbol[i]  end;
    st.length := j;
    if inb mod 4 = 0 then
      if inb = 0 then
                   if cte then WRITE( outf, ' $int_cte ' )
                          else WRITE( outf, ' integer ' )
                 else
                 begin
                   WRITELN( outf, ',' );
                   WRITE( outf, ' ':9 ); if cte then WRITE( outf, ' ' )
                 end
    else WRITE( outf, ', ' );
    if cte then WRITE( outf, '1 ', st:12, ':=', iv:3 )
           else WRITE( outf, st:14, ':=', iv:3 );
    inb := inb + 1
  end OUT_DEF;


begin { MXD_TREE_DCP }
  if argc > 1 then fspc := argv[1]^
  else
    if TTY_FILE( output ) then
    begin  WRITE( ' Output file specification = ' ); READLN( fspc )  end;

  if fspc.length = 0 then DUPLICATE_FILE( outf, output );

  if fspc.length > 0 then
  begin
    if INDEX( fspc, '.', -1 ) = 0 then fspc := fspc||'.mxd_env';
    WRITELN( ' Create the MXD_DCP file "', fspc, '"' );
    OPEN( outf, fspc, [write_file,error_file] );
    if iostatus <> 0 then
    begin
      WRITELN( err, ' MXD_TREE_DCP Cannot create the file "', fspc, '" (error code = ', iostatus:0, ').' );
      PASCAL_EXIT( 4 )
    end
  end;

  DATE( date_st ); TIME( time_st );
  WRITELN( outf, ' { MXD-V4 System: P. Wolfers Software, CNRS institut Neel Grenoble FRANCE }' );
  WRITELN( outf, ' { MXD_DCP Code file generated by MXD_TREE_DCP ', version, ' program the ', date_st, ' at ', time_st, '. }' );
  WRITELN( outf );

  WRITELN( outf, ' { Item Codes definitions : }' );
  inb := 0;
  for itm := SUCC( citm_unused ) to citm_codety"last do
  begin
    WRITEV( symbol, itm );
    if not ((symbol[6] = 'n') and (symbol[7] = 'o') and (symbol[8] = '_')) then OUT_DEF( symbol, 'I', ORD( itm ) )
  end;
  WRITELN( outf, ';' );
  WRITELN( outf );

  WRITELN( outf, ' { Directive Codes definitions : }' );
  inb := 0;
  for cdir := SUCC( cdir_unused ) to cdir_codety"last do
  begin
    WRITEV( symbol, cdir );
    if not ((symbol[6] = 'n') and (symbol[7] = 'o') and (symbol[8] = '_')) then OUT_DEF( symbol, 'D', ORD( cdir ) )
  end;
  WRITELN( outf, ';' );
  WRITELN( outf );

  WRITELN( outf, ' { Coefficients Codes definitions : }' );
  inb := 0;
  for coef := SUCC( coef_unused ) to coef_codety"last do
  begin
    WRITEV( symbol, coef );
    if not ((symbol[6] = 'n') and (symbol[7] = 'o') and (symbol[8] = '_')) then OUT_DEF( symbol, 'C', ORD( coef ) )
  end;
  WRITELN( outf, ';' );
  WRITELN( outf );

  WRITELN( outf, ' { Virtual Variables Codes definitions : }' );
  inb := 0;
  for virt := SUCC( virt_unused ) to virt_codety"last do
  begin
    WRITEV( symbol, virt );
    if not ((symbol[6] = 'n') and (symbol[7] = 'o') and (symbol[8] = '_')) then OUT_DEF( symbol, 'V', - ORD( virt ) )
  end;
  WRITELN( outf, ';' );
  WRITELN( outf );

  WRITELN( outf, ' { Least-Squares Option Codes definitions : }' );
  inb := 0;
  for opls := SUCC( opls_unused ) to lsqopt_codes"last do
  begin
    WRITEV( symbol, opls );
    if not ((symbol[6] = 'n') and (symbol[7] = 'o') and (symbol[8] = '_')) then OUT_DEF( symbol, ' ', ORD( opls ), true )
  end;
  WRITELN( outf, ';' );
  WRITELN( outf );
  CLOSE( outf );
  WRITELN( ' Normal end of MXD_TREE_DCP' )
end MXD_TREE_DCP.

