{
 ******************************************************************************
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                        MMM    MMM   XXX      XXX  DDDDDDDD                 *
 *                        MMMM  MMMM    XXX    XXX   DDDDDDDDDD               *
 *                        MM MMMM MM     XXX  XXX    DD      DDD              *
 *                        MM  MM  MM      XXXXXX     DD       DD              *
 *                        MM      MM       XXXX      DD       DD              *
 *          T  H  E       MM      MM       XXXX      DD       DD              *
 *                        MM      MM      XXXXXX     DD       DD              *
 *                        MM      MM     XXX  XXX    DD      DDD              *
 *                        MM      MM    XXX    XXX   DDDDDDDDDD               *
 *                       MMMM    MMMM  XXX      XXX  DDDDDDDD                 *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *                 SSSSS Y     Y  SSSSS TTTTTTT EEEEEE M     M                *
 *                S       Y   Y  S         T    E      MM   MM                *
 *                S        Y Y   S         T    E      M M M M                *
 *                 SSSS     Y     SSSS     T    EEEEE  M  M  M                *
 *                     S    Y         S    T    E      M     M                *
 *                     S    Y         S    T    E      M     M  ..            *
 *                SSSSS     Y    SSSSS     T    EEEEEE M     M  ..            *
 *                                                                            *
 *                                                                            *
 *                                                                            *
 *              ---  Version  3.999 000 alpha -- 31/10/2010 ---               *
 *                                                                            *
 *                by :                                                        *
 *                                                                            *
 *                     P. Wolfers                                             *
 *                         c.n.r.s.                                           *
 *                         Institut Neel (MCMF), Bat F,                       *
 *                         B.P.  166 X   38042  Grenoble Cedex                *
 *                                                FRANCE.                     *
 *                                                                            *
 *                                                                            *
 ******************************************************************************


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                                                                           //
//                     Global Public Licence (GPL)                           //
//                                                                           //
//                                                                           //
//    This license described in this file overrides all other licenses       //
//    that might be specified in other files for this software.              //
//                                                                           //
//    This program is free software; you can redistribute it and/or          //
//    modify it under the terms of the GNU Lesser General Public             //
//    License as published by the Free Software Foundation; either           //
//    version 2.1 of the License, or (at your option) any later version.     //
//                                                                           //
//    This software is distributed in the hope that it will be useful,       //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      //
//    Library General Public License for more details.                       //
//                                                                           //
//    You should have received a copy of the GNU Lesser General Public       //
//    License along with this library (see COPYING.LIB); if not, write to    //
//    the Free Software Foundation :                                         //
//                         Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


*******************************************************************************
*                                                                             *
*                                                                             *
*           MXD   Expression  and  Object Tree  Builder  Module               *
*                                                                             *
*                                                                             *
*******************************************************************************

}

{************     CPAS  version    *************}

{
        *** Modification(s) from major version ***


                  ----

                 NOTHING

                  ----

}


module MXD_TREE_BUILDER;


  %include 'MXDSRC:mxd_tree_env';               { Get all tree definitions }



const
  fdebug        =                false;         { Flag for conditional debug output }

  task_name     =    'MXD_TREE_Loader';         { Task name loader }
  ref_table_incr        =          256;         { Standard table increment }


type
  rfp_rec = record                              { * Define the reference table model * }
    rfp_tab: array[0..ref_table_incr-1] of ptr  { A record is used to get advantage of optimization statement }
  end;

  rfp_ptr = ^rfp_rec;                           { * Define the reference record pointer * }

  rfi_rec( rfi_size: integer ) = record         { * Define the extensible reference index record * }
    rfi_tab: array[0..rfi_size-1] of rfp_ptr
  end;

  rfi_ptr = ^rfi_rec;                           { * Define the extensible reference index record pointer * }


[global]
var
  elpstim,                              { Total elapsed time }
  topcpu:                      integer; { Total cpu time }

  mxd_libdir,                           { Standard MXD Library directory }
  mxd_proc_name:    string      :=  ''; { MXD Process Name }

  interphde,                            { List of Interpol from $sithsl coef. nodes }

  sumhhde,                              { List of all hkl sum op. }
  gvarhde,                              { List of all variables }
  varhde,                               { List of free variables }
  parhde,                               { List of parameters }
  usfuncthde,                           { List of user function }
  formalhde,                            { List of formal }
  loopidxhde,                           { List of loop index }

  phashde,                              { List of phases }
(*
  symthde,                              { List of symmetry matrix }
  wavehde,                              { List of wave vectors }
  polahde,                              { List of polarisation direction }
  agrphde,                              { List of atom group }
  atomhde,                              { List of atoms }
  atmshde,                              { List of atoms without symtry }
  momehde,                              { List of magnetic moments }
  mdsphde,                              { List of modulated displacments }
*)
  freeblk,                              { List of unused lsq block }
  dblkhde,                              { List of diagonal blocks }
  datahde:      ptr     :=         nil; { List of data collection }

  pardhde:                  pardep_tab; { Lists of dep. param in six levels }

  hh, kk, ll,
  hc, kc, lc,
  hr, kr, lr,                           { Current h,k,l,he,ke,le and vh + nq * vw }
  h1, k1, l1, h2,  k2,  l2,             { Intermediate h k l }
  da, db, dc, dal, dbe, dga,
  ra, rb, rc, ral, rbe, rga,
  dvol, rvol:                  mxd_flt; { Unit cell }

  curr_data:              curr_dat_typ; { Current data record in use }

  tmd, tmr:                     matrix; { Cell matrix transformation }

  refcatsv,                             { Neutron polarized index copy }
  nbfixed,                              { Count of fixed variables }
  latticenb,                            { Lattice identifier }
  nbcoll,                               { Total number of collect }
  ncpobs:                      integer; { Total number of data observations }

  bfmagnetic,                           { Flag founded magnetic statement }
  bflimited,                            { Flag existing variable limits }
  buiso,                                { Indicator of u isotropic mode }
  bcentric:                    boolean; { Indicator of centric mode }

  job_name,                             { Name of the Job }
  job_title,                            { Title for the job }
  sav_fname:    str_ptr :=         nil; { Save LSQ Variable file specification }

  pttl,                                 { Title pointer }
  psav:         str_ptr :=         nil; { Save variable filename pointer }


  rgf,  igf,                            { Geometrical factor }
  fnr,  fni,                            { Nuclear struc. factor }
  fxr,  fyr,  fzr,                      { Projected magnetic structure factor }
  fxi,  fyi,  fzi,
  rp1,  ip1,                            { Modulated occupency factor }
  fmxr, fmyr, fmzr,                     { No projected magn. structure factor save }
  fmxi, fmyi, fmzi,

  fnucl2,                               { Squared nuclear structure factor }
  fmag2,                                { Squared magnetic structure factor }
  fcalc2s,                              { Total saved squared part for pol. neu. }
  fcalc2,                               { Total squared structure factor }
  fstr,                                 { Computed none scaled data }
  delta,                                { Difference with observation }
  curint:                      mxd_flt; { Current structure factor }

  cvarbl,                               { Current variable for derivation }
  cformula,                             { Current formula node pointer }
  cparam,                               { Current variable parameter pointer }

  cphas,                                { Current phase pointer }
  csymt,                                { Current symtry matrix pointer }
  cwave,                                { Current wave vector pointer }
  cpola,                                { Current polarization dir. pointer }
  cagrp,                                { Current atome group pointer }
  catom,                                { Current atome pointer }
  cmome,                                { Current magnetic moment pointer }
  cmdsp,                                { Current modulated displacement pointer }
  cdblk,                                { Current diagonal block }
  cdata,                                { Current data block pointer }

  pcte_one:     ptr     :=         nil; { Pointer to the ONE (1.0) constante mode }

  interplst,                            { Interpol from $sithsl coef. node end list }

  sumhlst,                              { List of all hkl sum op. }
  gvarlst,                              { List of all variables }
  varlst,                               { List of free variables }
  parlst,                               { List of parameters }
  usfunctlst,                           { List of user function }
  formallst,                            { List of formal }
  loopidxlst,                           { List of loop index }

  phaslst,                              { Last pointer of Phase List}
  dblklst,                              { Last pointer of Diagonal-Blocks List }
  datalst:      ptr     :=         nil; { Last pointer of Data-Collection List }

  cselect:                    cselecty; { Current nature selector }

  iqwave,                               { Last number of wave vector ident }
  mxcateg,                              { Maximum reflexion family }
  ccateg:                      integer; { Current reflexion family }

  fatal_error,                          { Indicate stop on error }
  b132,                                 { Option of listing form }
  bshort_list:  boolean :=       false; { Option of short output list }


  varnb:        integer :=           0; { Total number of variable }


  magsel:                     magselty; { Selection of magnetic mode }

  virtvtab:                 virtvtabty; { Virtual variable pointers table }


  { Input files }

  pcdf:                           text; { Reverse polish instructions input }

{ idat:                       bdt_file; { Cristal data input }



type
  nam_tab_typ( size: integer ) = array[1..size] of string( 6 );

const
  nam_tab = nam_tab_typ[ 66,
                         { Field names for Phase Metric tensor }
                         '.PSCA',                                               { 01     }
                          '.DAA',  '.DBB',  '.DCC',  '.DAL',  '.DBE',  '.DGA',  { 02..07 }

                         { Field names for Group }
                         '.CALC',                                               { 08     }
                         '.XORG', '.YORG', '.ZORG',  '.OME',  '.CHI',  '.PHI',  { 09..14

                         { Field names for Atomes }
                         '.RDIF', '.IDIF',  '.POP',    '.X',    '.Y',    '.Z',  { 15..20 }
                          '.U11',  '.U22',  '.U33',  '.U23',  '.U31',  '.U12',  { 21..26 }

                         { Field names for Moments }
                          '.MFF',                                               { 27     }
                          '.RMX',  '.RMY',  '.RMZ',  '.IMX',  '.IMY',  '.IMZ',  { 28..33 }

                         { Field names for Mdsdsp }
                          '.PPM',  '.PPH',                                      { 34..35 }
                          '.RUX',  '.RUY',  '.RUZ',  '.IUX',  '.IUY',  '.IUZ',  { 36..41 }

                         { field names for Wave-vectors }
                          '.VWX',  '.VWY',  '.VWZ',                             { 42..44 }

                         { Field names for Npola }
                         '.XPOL',  '.YPOL', '.ZPOL', '.EFFP', '.EFFM', '.CPOL', { 45..50 }

                         { Field names for soft Constraint }
                         '.CALC',  '.OBS',  '.SIG', 'WEIGHT',                   { 51..54 }

                         { Field names for Data }
                         '.SCALE', '.FN2C', '.FM2C', '.DYNW', '.LAMB', '.YFNC', { 55..60 }

                         { Field names for Lsq-Block }
                          '.DMP',  '.MRQ',                                      { 61..62 }

                         { Internal pseudo variable names }
                         '$CALC',  '$FN2',  '$FM2', '$F2POL'                    { 63..66 }
                       ];
  pha_nam_id =  1;
  atg_nam_id =  8;
  atm_nam_id = 15;
  mom_nam_id = 27;
  dsp_nam_id = 34;
  wav_nam_id = 42;
  npo_nam_id = 45;
  sfc_nam_id = 51;
  dat_nam_id = 55;
  lbk_nam_id = 61;
  vrt_nam_id = 63;



var { * Define variables objects * }

  rfi_root:     rfi_ptr :=         nil; { Root pointer for reference the extensible index table }

  iidmax,                               { Maximum of seen Integer Identifieur (IID) }
  iidshf:       integer :=          -1; { Integer Identifieur (IID) shift (for special references) }


  sumobs_last: ptr      :=         nil; { End of Sumobs node queue }


  { Conversion  table between pcdf file node code and operator code }

  ndop_tab: [static] array[node_code] of nod_operty := [
     op_null,     op_null,     op_null, { nd_jobname,    nd_title,     nd_savfnam   }
     op_null,     op_null,    op_konst, { nd_string,     nd_null,      nd_konst     }
     op_null,     op_null,    op_coeff, { nd_refer,      nd_paname,    nd_coeff     }
   op_tabref,     op_null,     op_null, { nd_tabref,     nd_definv,    nd_assvar    }
     op_null,     op_null,   op_adatfl, { nd_defvar,     nd_defpar,    nd_addatf    }
     op_null,     op_null,     op_null, { nd_item,       nd_itmref,    nd_itmfldr   }
     op_null,     op_null,     op_null, { nd_data,       nd_permut,    nd_directive }
      op_not,      op_neg,      op_pow, { nd_not,        nd_neg,       nd_pow       }
      op_ipw,      op_mul,      op_div, { nd_ipw,        nd_mul,       nd_div       }
     op_idiv,      op_mod,      op_rem, { nd_idiv,       nd_mod,       nd_rem       }
      op_add,      op_sub,              { nd_add,        nd_sub                     }
       op_eq,       op_ne,       op_lt, { nd_eq,         nd_ne,        nd_lt        }
       op_le,       op_ge,       op_gt, { nd_le,         nd_ge,        nd_gt        }
      op_and,      op_xor,       op_or, { nd_and,        nd_xor,       nd_or        }
      op_abs,     op_sqrt,              { nd_abs,        nd_sqrt                    }
     op_sinr,     op_cosr,     op_tanr, { nd_sinr,       nd_cosr,      nd_tanr      }
    op_asinr,    op_acosr,    op_atanr, { nd_asinr,      nd_acosr,     nd_atanr     }
   op_phaser,                           { nd_phaser                                 }
     op_sind,     op_cosd,     op_tand, { nd_sind,       nd_cosd,      nd_tand      }
    op_asind,    op_acosd,    op_atand, { nd_asind,      nd_acosd,     nd_atand     }
   op_phased,                           { nd_phased                                 }
      op_exp,       op_ln,     op_tanh, { nd_exp,        nd_ln,        nd_tanh      }
    op_bessj,    op_bessj, op_interpol, { nd_bessj,      nd_bessjh,    nd_interpol  }
   op_integr,     op_summ,              { nd_integr,     nd_summ                    }
    op_trunc,    op_round,              { nd_trunc,      nd_round                   }
     op_noop,   op_select,    op_ifsel, { nd_nop,        nd_select,    nd_ifsel     }
     op_call,   op_return,     op_null, { nd_call,       nd_return,    nd_modload   }
     op_noop                            { nd_end                                    }
  ];






[global]
procedure INIT_TREE( in_var mxdnam: string );
var
  bok, bprt, fnd: boolean;
  i, ierr: integer;
  str:      string;

begin
  topcpu        :=       CLOCK;        { Get origine CPU time }
  fatal_error   :=       false;

  str := 'MXD-Tree-Loader_Init '||mxd_heading;
  LST_G_INIT( mxd_deflst, str, ierr );
  if ierr <> 0 then
  begin
    WRITELN( ' *** ', task_name, ' FATAL ERROR : Cannot open the default Listing File "" error code = ', ierr:0 );
    PASCAL_EXIT( 4 )
  end;

  { Look for the initial MXD Standard Environment file in the MXD Search Path }
  SEARCH_FILE( mxd_search_path, mxd_setenvf, 4 { Read Access }, str, fnd );
  mxd_libdir := SUBSTR( str, 1, str.length - mxd_setenvf.length );      { Keep only the Path to access to MXD Executable directory }

  { Initialize the Error Message Sub-System }
  ERR_INIT( mxd_libdir||mxd_tree_errfspc );

  { Set all control to init state }
  fatal_error := false;
  psav        := nil;   pttl   := nil;
  iqwave      := -1;
  nbcoll      := 0;
  nbfixed     := 0;                      { No fixed variable }
  bflimited   := false;                  { No limits statement found }
  bfmagnetic  := false;                  { No magnetic statement found on init time }

  for vcd := virt_codety"first to virt_codety"last do  virtvtab[vcd] := nil;

  { Set all stucture list at empty state }
  parhde     := nil; gvarhde    := nil; freeblk    := nil;
  usfuncthde := nil; loopidxhde := nil; formalhde  := nil;
  sumhhde    := nil;
  freeblk    := nil;

  phashde    := nil; dblkhde    := nil; datahde    := nil;

  cselect    :=   0;


  { Set all default option }
  buiso         :=        true;
  latticenb     :=           1;         { P lattice default }
  bcentric      :=       false;

  { Set magnetic mode any spectra }
  for i := 0 to maxsel do  magsel[i] := true;
  mxcateg       :=          64;         { Set to no reject mode }

  NEW( rfi_root, ref_table_incr );
  for ii := 0 to ref_table_incr-1 do  rfi_root^.rfi_tab[ii] := nil;

  { Create the One constante for scale default values }
  NEW( pcte_one, op_konst );
  pcte_one^.nod_typ := op_konst;
  pcte_one^.nod_val := 1.0

end INIT_TREE;



{*************  Build Logical Tree routines  **************}


(*
{ Call a main module procedure }
procedure SETOPTION( i, id: integer ); external; { defined in the appl. prg. }
*)


procedure NEW_REFERENCE( nsequ: integer; p: ptr (* ; mod2usr: boolean := false *) );
var
  idc, idi, idt, idx:  integer;
  tmp:                 rfi_ptr;

begin
  if nsequ < iidmax then iidmax := nsequ;      { Update Maximum of IId when required }
(* ///
  if mod2usr then nsequ := nsequ - 1           { For special user reference from module tree }
             else nsequ := nsequ + iidshf;     { For internal module reference (and also user to user reference) }
*)
  nsequ := nsequ + iidshf;                     { All reference all always local to the current module }
  idx := rfi_root^.rfi_size;
  idi := nsequ div ref_table_incr;
  if idx <= idi then
  begin { We must extend the index table }
    idc := idx;
    idx := ((idi + (ref_table_incr - 1)) div ref_table_incr)*ref_table_incr;
    NEW( tmp, idx );
    with rfi_root^ do
      for ii := 0 to idc-1 do  tmp^.rfi_tab[ii] := rfi_tab[ii];
    DISPOSE( rfi_root );
    for ii := idc to idx-1 do  tmp^.rfi_tab[ii] := nil;
    rfi_root := tmp
  end;
  with rfi_root^ do
  begin
    if rfi_tab[idi] = nil then
    begin
      NEW( rfi_tab[idi] );
      with rfi_tab[idi]^ do
        for ii := 0 to ref_table_incr-1 do rfp_tab[ii] := nil
    end;
    rfi_tab[idi]^.rfp_tab[nsequ mod ref_table_incr] := p
  end
end NEW_REFERENCE;



[global]
function  GET_REFERENCE( nsequ: integer ): ptr;
begin
  if nsequ > 0 then
  begin
    nsequ := nsequ + iidshf;
    with rfi_root^ do
      GET_REFERENCE := rfi_tab[nsequ div ref_table_incr]^.rfp_tab[nsequ mod ref_table_incr]
  end
  else GET_REFERENCE := nil
end GET_REFERENCE;



[global]
function BUILDSYMBOL( var symb: [readonly] string ): str_ptr;
var
  p:   str_ptr;
  len: integer;

begin
  NEW( p, symb.length );
  p^ := symb;
  BUILDSYMBOL := p
end { BUILDSYMBOL };



[global]
procedure QUEUE_OBJECT( var frs, lst: ptr; nod: ptr );
begin
  if frs = nil then frs := nod
               else lst^.itm_next := nod;
  lst := nod
end QUEUE_OBJECT;



[global]
procedure BUILDTREE( pcdf_name: string );
{ Buildtree built all logical list and trees of the structure to fit
  and also set the various users options as specified. }
const
  mdnam     =   'BLDT';
  maxsp     =      256;

var
  sp:                -1..maxsp;
  stk:  array[0..maxsp] of ptr;
  tmp, tree:               ptr;
  lvar, pitm, p1, p2:      ptr;
  idx, i, j, narg, nsq:integer;
  virt_node:           boolean;
  r:                   mxd_flt;
  nd_cd:             node_code;
  op_cd:            nod_operty;


  procedure PUSH( p: ptr );
  { To push in stack an expression element. }
  begin
    if sp >= maxsp then EXEC_ERROR( 'PUSH', 1 ) else sp := SUCC( sp );
    stk[sp] := p
  end { PUSH };



  function POP: ptr;
  { To pop an expression element from the stack }
  begin
    if sp < 0 then
    begin  EXEC_ERROR( 'POPS', 2 ); POP := nil  end
    else
    begin  POP := stk[sp]; sp := PRED( sp )  end
  end { POP };



  procedure READ_STRING ( var str: string );
  var
    len: integer;
    ch:     char;

  begin
    READ( pcdf, len );
    if len > str.capacity then len := str.capacity;
    if len > 0 then
    begin
      READ( pcdf, ch );
      for ii := 1 to len do
        if ii <= len then READ( pcdf, str[ii] )
                     else READ( pcdf, ch )
    end;
    str.length := len
  end READ_STRING;



  procedure READ_STR( var pid: str_ptr; max: integer := 0 );
  { To read (from instruction file "int") a name identifier }
  var
    len, lmax:         integer;
    ic:                   char;
    str:       [static] string;

  begin
    READ( pcdf, len );
    lmax := len;
    if lmax > str.capacity then lmax := str.capacity;
    if (max > 0) and (max < lmax) then lmax := max;
    str.length := lmax;
    if len > 0 then
    begin
      READ( pcdf, ic );
      for ii := 1 to len do
        if ii <= lmax then READ( pcdf, str[ii] )
                      else READ( pcdf, ic )
    end;
    if lmax < 1 then pid := nil
                else begin  NEW( pid, lmax ); pid^ := str  end
  end { READ_STR };



  procedure READ_MATRIX( var mat: matrix );
  begin
    for ii := 1 to 3 do
      for jj := 1 to 3 do
        READ( pcdf, mat[i,j] );
  end READ_MATRIX;



  procedure READ_MATRIX_OPE( var ope: matrix_ope );
  begin
    for ii := 1 to 3 do
      for jj := 1 to 4 do
        READ( pcdf, ope[i,j] );
  end READ_MATRIX_OPE;



  procedure READ_SYMTRY_OPE( var ope: symtry_ope );
  begin
    for ii := 1 to 3 do
      for jj := 1 to 4 do
        READ( pcdf, ope[i,j] );
  end READ_SYMTRY_OPE;



  procedure GEN_DIRECTIVE;
  const
    mdnam = 'DIRM';

  var
    icd, bsq, npa, irf:    integer;
    st:           string( 14 );
    ch:                   char;
    dir:           cdir_codety;
    opt:          lsqopt_codes;
    vd, vu, rv:        mxd_flt;
    p:                     ptr;
    pl:                lim_ptr;

  begin
    READ( pcdf, icd, bsq, npa );
    dir := cdir_codety( icd );

    if fdebug then WRITELN ( ' ':4, 'Dir = ', dir );

    case dir of
      cdir_option:      if npa > 0 then SET_OPTION( npa );      { Perform the application specific option management }

      cdir_center:      begin
                          p := GET_REFERENCE( bsq );
                          if p = nil then EXEC_ERROR( mdnam, 4 )
                          else
                          with p^.pha_cell do
                          begin
                            cell_group.length   := 0;
                            cell_ngroup :=         0;
                            if icd > 0 then cell_flags := cell_flags + [celf_center]
                                       else cell_flags := cell_flags - [celf_center]
                          end;
                        end;

      cdir_space_group,
      cdir_lattice:     if npa > 0 then
                        begin
                          p := GET_REFERENCE( bsq );
                          if p = nil then
                          begin  EXEC_ERROR( mdnam, 5 ); READLN( pcdf )  end
                          else
                          with p^.pha_cell do
                          begin
                            READ_STRING( st );
                            cell_group.length := st.length;
                            for i := 1 to st.length do cell_group.body[i] := st[i];
                            if dir = cdir_space_group then cell_ngroup :=  -1
                                                      else cell_ngroup :=   0;
                            if cell_group.length > 0 then
                            begin
                              ch := cell_group.body[1];
                              if (ch = 'r') or (ch = 'R') then cell_flags := cell_flags + [celf_rhomb]
                                                          else cell_flags := cell_flags - [celf_rhomb]
                            end
                          end;

                          if fdebug then
                            with p^.pha_cell.cell_group do
                            WRITELN( ' ':8, 'Set group/lattice "', body:length, '" for the phase "', p^.itm_name^, '"' )

                        end;

      cdir_fixed,
      cdir_unfixed:     begin
                          READ( pcdf, irf ); p := GET_REFERENCE( irf );
                          if p <> nil then
                            if (p^.nod_typ = op_varbl) then
                            begin
                              p^.var_orgidx := ORD(dir = cdir_unfixed);

                              if fdebug then
                              begin
                                WRITE( ' ':8, 'Variable "', p^.itm_name^, '" is set as ' );
                                if dir = cdir_fixed then WRITELN( 'fixed' )
                                                    else WRITELN( 'unfixed' )
                              end

                            end
                        end;

      cdir_limits:      begin
                          READ( pcdf, vd, vu, irf ); p := GET_REFERENCE( irf );
                          if p <> nil then
                            if (p^.nod_typ = op_varbl) then
                            begin
                              NEW( pl ); p^.var_limptr := pl;
                              pl^.lim_inf := vd; pl^.lim_sup := vu;

                              if fdebug then
                                WRITELN( ' ':8, 'Set limits ', pl^.lim_inf:8:3, ', ', pl^.lim_sup:8:3, ' for variable "', p^.itm_name^, '"' )

                            end
                        end;
    otherwise
    end
  end GEN_DIRECTIVE;



  function VALPOP: mxd_flt;
  const
    mdnam = 'GCTE';

  var
    p:     ptr;
    v: mxd_flt;

  begin
    p := POP;
    v := 0.0;
    if p <> nil then
    begin
      if p^.nod_typ <> op_konst then EXEC_ERROR( mdnam, 15 )
                                else v := p^.nod_val;
      DISPOSE( p )
    end;
    VALPOP := v
  end VALPOP;



  function PARPOP( id_name: integer ): ptr;
  { PARPOP take the appropriate pointer of expression trees in stack
    and generate the internal parameters for each used item field. }
  var
    p, pa, pb: ptr;

  begin
    p := POP;
    if p = nil then PARPOP := nil else
    if p^.nod_typ = op_parm then PARPOP := p    { No duplicate parameter }
    else
    begin
      NEW( pa, op_parm, itm_parm );
      with pa^ do
      begin
        nod_typ     :=         op_parm;
        itm_next    :=             nil;
        itm_link    :=             nil;
        if id_name >= 0 then itm_name := nam_tab[id_name]"address
                        else itm_name := nil;
        itm_sequ    :=               0; { Never referenced parameter }
        itm_kind    :=        itm_parm;
        par_categ   :=       prmc_init;
        par_lstder  :=             nil;
        par_expres  :=               p;
        par_actval  :=             0.0;
        par_actsig  :=             0.0
      end;
      QUEUE_OBJECT( parhde, parlst, pa );
      PARPOP := pa
    end
  end { PARPOP };



  function NEW_ITEM( cd: nod_operty ): ptr;
  var
    p, ref, tmp:           ptr;
    kitm:            itm_kinds;
    kdat:           itmd_kinds;
    icd, narg, nsequ,
    irf1, irf2, iown:  integer;
    itmcd:         citm_codety;
    pflg, baniso:      boolean;
    str:       [static] string;

    kdat_tab: [static] array[citm_dathkl_xf2..citm_dathkl_nprf] of itmd_kinds := [ itmd_hkl_xf2,  itmd_hkl_xsf,
                                                                                   itmd_hkl_xray, itmd_xprofil,
                                                                                   itmd_hkl_nf2,  itmd_hkl_nsf,
                                                                                   itmd_hkl_nray, itmd_nprofil
                                                                                 ];

  begin
    p    :=   nil; { To don't trap on error where the item kind is not supported }
    pflg := false; { The push of result is an exception }
    case cd of
      op_varbl:  begin  NEW( p, op_varbl,  itm_varbl    ); kitm := itm_varbl     end;
      op_parm:   begin  NEW( p, op_parm,   itm_parm     ); kitm := itm_parm      end;
      op_index:  begin  NEW( p, op_index,  itm_index    ); kitm := itm_index     end;
      op_formal: begin  NEW( p, op_formal, itm_formal   ); kitm := itm_formal    end;
      op_usrfun: begin  NEW( p, op_usrfun, itm_function ); kitm := itm_function  end;
      op_item, op_data:
        begin
          READ( pcdf, icd, narg, nsequ );
          if cd <> op_data then READ( pcdf, iown );
          itmcd := citm_codety( icd );
          case itmcd of
            citm_lsqblock:    begin  NEW( p, op_item, itm_lsqblk );   kitm := itm_lsqblk   end;
            citm_wavevect:    begin  NEW( p, op_item, itm_wave );     kitm := itm_wave     end;
            citm_npoladir:    begin  NEW( p, op_item, itm_npola );    kitm := itm_npola    end;
            citm_symtry:      begin  NEW( p, op_item, itm_symtry );   kitm := itm_symtry   end;
            citm_phase:       begin  NEW( p, op_item, itm_phase );    kitm := itm_phase    end;
            citm_atmgroup:    begin  NEW( p, op_item, itm_atmgroup ); kitm := itm_atmgroup end;
            citm_atom,
            citm_catom:       begin  NEW( p, op_item, itm_atom );     kitm := itm_atom     end;
            citm_moment:      begin  NEW( p, op_item, itm_moment );   kitm := itm_moment   end;
            citm_mdsdsp:      begin  NEW( p, op_item, itm_mdsdsp );   kitm := itm_mdsdsp   end;
            citm_constraint:  begin  NEW( p, op_item, itm_sftcte );   kitm := itm_sftcte   end;

            citm_dathkl_xf2,  citm_dathkl_nf2,
            citm_dathkl_xsf,  citm_dathkl_nsf,
            citm_dathkl_xray, citm_dathkl_nray:
              begin
                NEW( p, op_data, itm_data, itmd_hkl_xf2 );
                kitm := itm_data; kdat := kdat_tab[itmcd]
              end;

            citm_dathkl_xprf, citm_dathkl_nprf:
              begin
                NEW( p, op_data, itm_data, itmd_xprofil );
                kitm := itm_data; kdat := kdat_tab[itmcd]
              end;

            citm_datcurve:
              begin
                NEW( p, op_data, itm_data, itmd_curve );
                kitm := itm_data; kdat := itmd_curve
              end;

          otherwise
          end;
          if p <> nil then
          with p^ do
          begin
            nod_typ  :=   cd;           { Set the node type }
            itm_next :=  nil;           { Init the next link }
            itm_link :=  nil;
            READ_STR( itm_name );       { Set the item name }
            itm_sequ := nsequ;          { Set the item sequence number (original value - not shifted) }
            itm_kind := kitm            { Set the kind of item/data_item }
          end
        end;
    otherwise
    end;
    if p <> nil then
    with p^ do
    begin
      if cd <> op_null then nod_typ := cd
                       else nod_typ := op_item;
      itm_next :=  nil;
      itm_link :=  nil;
      if (cd <> op_item) and (cd <> op_data) then itm_sequ := 0;
      itm_kind := kitm;
      case kitm of
        itm_varbl: begin { * LSQ Varbl definition * }
                     var_orgidx    :=           1;      { Assume free variable }
                     var_matidx    :=          -1;      { Mark this variable as not referenced until shown otherwise }
                     var_limptr    :=         nil;
                     READ( pcdf, itm_sequ, var_curval, var_cursig );
                     READ_STR( itm_name );

                     if fdebug then
                       WRITELN( ' ':8, 'Create Variable "', itm_name^, '" id = ', itm_sequ:0,
                                ' with init val = ', var_curval:8:3, ', ', var_cursig:8:3 );

                     QUEUE_OBJECT( gvarhde, gvarlst, p )
                   end;
        itm_parm:  begin { * LSQ Parm definition * }
                     READ( pcdf, itm_sequ ); READ_STR( itm_name );
                     par_categ  := prmc_init;           { Set the INIT Category until shown otherwise }
                     par_expres := POP; { Set the LSQ_PARM expression }
                     par_catlnk := nil;
                     par_lstder := nil;
                     par_actval := 0.0;
                     par_actsig := 0.0;
                     QUEUE_OBJECT( parhde, parlst, p );

                     if fdebug then
                       if itm_name <> nil then WRITELN( ' ':8, 'Create Param "', itm_name^, '" id = ', itm_sequ:0 )
                                          else WRITELN( ' ':8, 'Create Unnamed Param of id = ', itm_sequ:0 )

                   end;
        itm_index: begin { * Summation Index for Interpol, summ and Integration std functions * }
                     READ( pcdf, itm_sequ ); READ_STR( itm_name );
                     ind_val    := 0.0;
                     pflg := true;      { To push for SUMM or INTEGR operator }

                     if fdebug then WRITELN( ' ':8, 'Create index of id = ', itm_sequ:0 )

                   end;
        itm_formal:
                   begin { * Formal of a Usr LSQ function * }
                     READ( pcdf, itm_sequ ); READ_STR( itm_name );
                     for_next   := nil;
                     for_link   := nil;
                     pflg := true;      { To push for Usr LSQ function Link }

                     if fdebug then WRITELN( ' ':8, 'Create lsq formal of id = ', itm_sequ:0 )

                   end;
        itm_function:
                   begin { * Usr LSQ function * }
                     frm_list   := nil;
                     frm_exprv  := POP;
                     READ( pcdf, itm_sequ, narg );
                     while narg > 0 do
                     begin
                       tmp := POP;
                       tmp^.for_next := frm_list;
                       frm_list := tmp
                     end;

                     if fdebug then WRITELN( ' ':8, 'Create lsq function of id = ', itm_sequ:0 )

                   end;
        itm_phase: begin { * Define a Cristallographic Phase * }
                     for ii :=  6 downto 0 do  pha_par[ii] := PARPOP( pha_nam_id + ii );
                     if pha_par[0] = nil then pha_par[0] := pcte_one;
                     if pha_par[3] = nil then pha_par[3] := pha_par[1];
                     if pha_par[2] = nil then pha_par[2] := pha_par[1];
                     if pha_par[4] <> nil then
                     begin
                       if pha_par[5] = nil then pha_par[5] := pha_par[4];
                       if pha_par[6] = nil then pha_par[6] := pha_par[4]
                     end;
                     pha_symhde  := nil; pha_symlst := nil;
                     pha_atmhde  := nil; pha_atmlst := nil;
                     pha_wavhde  := nil; pha_wavlst := nil;
                     pha_polhde  := nil; pha_pollst := nil;
                     pha_atmhde  := nil; pha_atmlst := nil;
                     with pha_cell do
                     begin { This is a partial init to accept the Lattice, Center and Space-Groupe directive }
                       cell_group.length  :=    0;
                       cell_ngroup :=         999;
                       cell_flags := [celf_toinit] { To force the Computing init }
                     end;
                     QUEUE_OBJECT( phashde, phaslst, p );
                     cagrp := p;        { Set this phase as the owner of the next atoms/Atom_Groups }
                     cphas := p;        { Set this phase as active }

                     if fdebug then WRITELN( ' ':8, 'Create Phase "', itm_name^, '" id = ', itm_sequ:0 )

                   end;
        itm_symtry:
                   begin
                     ref := GET_REFERENCE( iown );
                     if ref = nil then EXEC_ERROR( mdnam, 3 )
                                     else with ref^ do QUEUE_OBJECT( pha_symhde, pha_symlst, p );
                     READLN( pcdf );
                     READ_SYMTRY_OPE( sym_oper );

                     if fdebug then
                       WRITELN( ' ':8, 'Create Symtry operator "', itm_name^, '" id = ',
                                itm_sequ:0, ' of phase "', ref^.itm_name^, '"' );

                   end;
        itm_wave:  begin
                     ref := GET_REFERENCE( iown );
                     if ref = nil then EXEC_ERROR( mdnam, 6 )
                                  else with ref^ do QUEUE_OBJECT( pha_wavhde, pha_wavlst, p );
                     wav_phase := ref;
                     for i := 2 downto 0 do  wav_par[i] := PARPOP( wav_nam_id + i );
                     for i := 1 to 3 do  for j := 0 to 6 do  wav_vec[i,j] := 0.0;
                     wav_fixed  := true;        { Until shown otherwise }

                     READLN( pcdf );
                     READ( pcdf, icd );
                     wav_relflg := (icd > 0);   { /// We can imagine to check for Rational mode /// }

                     if fdebug then
                       WRITELN( ' ':8, 'Create Wave vector "', itm_name^, '" id = ', itm_sequ:0,
                                ' with rational = ', wav_relflg, ' of phase "', ref^.itm_name^, '"' );

                   end;
        itm_npola: begin
                     ref := GET_REFERENCE( iown );
                     if ref = nil then EXEC_ERROR( mdnam, 7 )
                                  else with ref^ do QUEUE_OBJECT( pha_polhde, pha_pollst, p );
                     for ii := 5 downto 0 do npo_par[ii] := PARPOP( npo_nam_id + ii );
                     npo_hx := 0.0; npo_hy := 0.0; npo_hz := 0.0;
                     if fdebug then
                       WRITELN( ' ':8, 'Create Neutron polarization direction "', itm_name^, '" id = ',
                                itm_sequ:0, ' of phase "', ref^.itm_name^, '"' );

                   end;
        itm_atmgroup: { * Define an Atom Group * }
                   begin
                     atg_next  :=   nil;
                     atg_owner := cagrp;        { Set the owner of this atom group }
                     ref := GET_REFERENCE( iown );
                     if ref = nil then EXEC_ERROR( mdnam, 8 )
                     else
                       with ref^ do
                       case itm_kind of
                         itm_phase:    QUEUE_OBJECT( pha_atmhde, pha_atmlst, p );
                         itm_atmgroup: QUEUE_OBJECT( atg_atmhde, atg_atmlst, p );
                       otherwise
                         EXEC_ERROR( mdnam, 8 )
                       end;
                     cagrp := p;                { Set this atom group as the owner of the next atoms }

                     for ii := 6 downto 0 do  atg_par[ii] := PARPOP( atg_nam_id + ii );
                     atg_atmhde := nil;         { Init the atom/atom_group list of this atom group }
                     atg_atmlst := nil;
                     atg_calc   := 0.0;         { Init the atom group computing fields }
                     atg_calc2  := 0.0;
                     atg_cnr    := 0.0;
                     atg_cni    := 0.0;
                     atg_cxr    := 0.0;
                     atg_cxi    := 0.0;
                     atg_cyr    := 0.0;
                     atg_cyi    := 0.0;
                     atg_czr    := 0.0;
                     atg_czi    := 0.0;

                     if fdebug then WRITE( ' ':8, 'Create atom group "', itm_name^, '" id = ', itm_sequ:0, ' with owner "', ref^.itm_name^, '"' )

                    end;
        itm_atom:  begin { * Define a Cristallographic Atom * }
                     ref := GET_REFERENCE( iown );
                     if ref = nil then EXEC_ERROR( mdnam, 3 )
                     else
                     with ref^ do
                       case itm_kind of
                         itm_phase:    QUEUE_OBJECT( pha_atmhde, pha_atmlst, p );
                         itm_atmgroup: QUEUE_OBJECT( atg_atmhde, atg_atmlst, p );
                       otherwise
                         EXEC_ERROR( mdnam, 9 )
                       end;
                     atm_lstmom := nil;
                     atm_lstdsp := nil;
                     baniso := false;
                     for ii := 11 downto 0 do
                     begin
                       tmp := PARPOP( atm_nam_id + ii );
                       if (ii > 7) and (tmp <> nil) then baniso := true;
                       atm_par[ii] := tmp
                     end;
                     if atm_par[2] = nil then atm_par[2] := pcte_one;
                     atm_bcart := (itmcd = citm_catom);
                     atm_banis := baniso;

                     if fdebug then
                     begin
                       WRITE( ' ':8, 'Create atom "', itm_name^, '" id = ', itm_sequ:0, ' with ' );
                       if atm_bcart then WRITE( 'Cartesian' ) else WRITE( 'cristallographic' );
                       WRITE( ' coordinates, ');
                       if atm_banis then WRITE( 'anisotropic' ) else WRITE( ' isotropic' );
                       WRITELN( ' thermal factor with the owner "', ref^.itm_name^, '"' )
                     end

                   end;
        itm_moment:
                   begin
                     ref := GET_REFERENCE( iown );
                     if ref = nil then ref := cphas;    { The default owner is the current phase }
                     with ref^ do
                       case itm_kind of
                         itm_phase:    QUEUE_OBJECT( pha_momhde, pha_momlst, p );
                         itm_atmgroup: QUEUE_OBJECT( atg_momhde, atg_momlst, p );
                       otherwise
                         EXEC_ERROR( mdnam, 10 )
                       end;
                     READ( pcdf, irf1, irf2 );
                     mom_next := nil;
                     ref := GET_REFERENCE( irf1 );
                     if ref = nil then EXEC_ERROR( mdnam, 5 )
                     else
                     with ref^ do
                       if atm_lstmom = nil then atm_lstmom := p
                       else
                       begin
                         tmp := atm_lstmom;
                         while tmp^.mom_next <> nil do  tmp := tmp^.mom_next;
                         tmp^.mom_next := p
                       end;
                     mom_wave := GET_REFERENCE( irf2 );
                     for ii := 6 downto 0 do mom_par[ii] := PARPOP( mom_nam_id + ii );

                     if fdebug then
                       WRITELN( ' ':8, 'Create moment "', itm_name^, '" of atom "',
                                ref^.itm_name^, '" with id = ', itm_sequ:0 );

                   end;
        itm_mdsdsp:
                   begin
                     ref := GET_REFERENCE( iown );
                     if ref = nil then ref := cphas;    { The default owner is the current phase }
                     with ref^ do
                       case itm_kind of
                         itm_phase:    QUEUE_OBJECT( pha_dsphde, pha_dsplst, p );
                         itm_atmgroup: QUEUE_OBJECT( atg_dsphde, atg_dsplst, p );
                       otherwise
                         EXEC_ERROR( mdnam, 11 )
                       end;
                     READ( pcdf, irf1, irf2 );
                     dsp_next := nil;
                     ref := GET_REFERENCE( irf1 );
                     if ref = nil then EXEC_ERROR( mdnam, 5 )
                     else
                     with ref^ do
                       if atm_lstmom = nil then atm_lstmom := p
                       else
                       begin
                         tmp := atm_lstmom;
                         while tmp^.dsp_next <> nil do  tmp := tmp^.dsp_next;
                         tmp^.dsp_next := p
                       end;
                     dsp_wave := GET_REFERENCE( irf2 );
                     for ii := 7 downto 0 do dsp_par[ii] := PARPOP( dsp_nam_id + ii );

                     if fdebug then
                       WRITELN( ' ':8, 'Create mdsdsp "', itm_name^, '" of atom "',
                                ref^.itm_name^, '" with id = ', itm_sequ:0 );

                   end;
        itm_lsqblk:
                   begin
                     blk_dynmrq := PARPOP( lbk_nam_id + 1 );
                     blk_dyndmp := PARPOP( lbk_nam_id );
                     if blk_dyndmp = nil then blk_dyndmp := pcte_one;
                     blk_lstvar := varlst;
                     QUEUE_OBJECT( dblkhde, dblklst, p );

                     if fdebug then WRITELN( ' ':8, 'Create Least-Squares Block "', itm_name^, '"' )

                   end;
        itm_sftcte:
                   begin
                     sfc_weight := PARPOP( sfc_nam_id + 3 );
                     sfc_sig    := PARPOP( sfc_nam_id + 2 );
                     sfc_obs    := PARPOP( sfc_nam_id + 1 );
                     sfc_calc   := PARPOP( sfc_nam_id )
                   end;
        itm_data:  begin
                     READ( pcdf, icd, dat_nrec );
                     WRITEV( str, 'MXD_D_file_', icd:-4, '.dat' );
                     NEW( dat_fname, str.length );
                     dat_fname^ :=   str;
                     dat_active := false;
                     dat_dywecoef := PARPOP( dat_nam_id + 4 );
                     READ( pcdf, dat_nval );
                     if dat_nval <= 0 then dat_addidtb := nil
                     else
                     begin
                       NEW( dat_addidtb, dat_nval );
                       for ii := 1 to dat_nval do
                       begin  READ( pcdf, irf1 ); dat_addidtb^[ii] := GET_REFERENCE( irf1 );
(*
;WRITELN( ' Data with add-fields # ', irf1:0, ' name = "', dat_addidtb^[ii]^.nod_datname^, '"' )
*)
                       end
                     end;
                     dat_kind := kdat;
                     case kdat of
                       itmd_hkl_xf2,  itmd_hkl_nf2,
                       itmd_hkl_xsf,  itmd_hkl_nsf,
                       itmd_hkl_xray, itmd_hkl_nray:
                         begin
                           dhkl_fm2corr := PARPOP( dat_nam_id + 2 );
                           dhkl_fn2corr := PARPOP( dat_nam_id + 1 );
                           dhkl_lambda  := VALPOP;
                           dhkl_scale   := PARPOP( dat_nam_id );
                           dhkl_nobs    :=   0;
                           dhkl_sobs    := 0.0;
                           dhkl_sobs2   := 0.0;
                           dhkl_swobs   := 0.0;
                           dhkl_swobs2  := 0.0
                         end;
                       itmd_xprofil, itmd_nprofil:
                         begin
                           dprf_lambda2 := VALPOP;
                           dprf_lambda1 := VALPOP;

                         end;
                       itmd_curve:
                         begin
                           dcrv_fnc     := PARPOP( dat_nam_id + 5 );
                           dcrv_sobs    := 0.0;
                           dcrv_sobs2   := 0.0
                         end;
                     otherwise
                     end;
                     QUEUE_OBJECT( datahde, datalst, p );

                     if fdebug then
                     begin
                       WRITE( ' ':8, 'Create data ', dat_kind );
                       WRITELN( ' "', itm_name^, '" with id = ', itm_sequ:0, ' with ', dat_nrec:0, ' records' );
                       if dat_addidtb <> nil then
                       begin
                         WRITE( ' *** These data record define the following additional data field' );
                         if dat_addidtb^.size > 1 then WRITE( 's' ); WRITELN( ' :' );
                         for ii := 1 to dat_addidtb^.size do
                           if dat_addidtb^[ii] <> nil then
                             with dat_addidtb^[ii]^ do WRITELN( ii:12, ' # ', nod_datsequ:0, ' / "', nod_datname^, '"' )
                       end
                     end

                   end;
      otherwise
      end;
      NEW_REFERENCE( itm_sequ, p )
    end;
    if pflg then NEW_ITEM := p
            else NEW_ITEM := nil
  end NEW_ITEM;



  function CREATE_VIRTUAL_VARBL( sqnb: integer ): ptr;
  { To get or creates a virtual variable for $calc, $fn2 and $fm2 management }
  var
    p:             ptr;
    vcd:   virt_codety;

  begin
    vcd := virt_codety( ABS( sqnb ) );
    if virtvtab[vcd] = nil then
    begin { Create a new virtual variable reference }
      NEW( p, op_virtvar );
      with p^ do
      begin
        nod_typ     :=        op_varbl;
        nod_vvsequ  :=             vcd;
        case vcd of
          virt_dat$calc:
            nod_vcateg := prmc_stp3;

          virt_dat$fn2, virt_dat$fm2:
            nod_vcateg := prmc_stp1;

          virt_dat$f2pola:
            nod_vcateg := prmc_stp2;

        otherwise
          nod_vcateg  := prmc_itmblk;
        end;
        nod_curval  :=             0.0
      end;
      virtvtab[vcd] := p
    end;
    { Get the virtual variable reference }

    if fdebug then WRITELN( ' ':8, 'Virtual Variable. ref to iid  ', tree^.nod_coeffid:0 );

    CREATE_VIRTUAL_VARBL := virtvtab[vcd]
  end CREATE_VIRTUAL_VARBL;



  procedure GET_ND_CODE( var ncd: node_code; var ocd: nod_operty );
  var
    icd: integer;

  begin
    READ( pcdf, icd );
    ncd := node_code( icd );
    ocd := ndop_tab[ncd]
  end GET_ND_CODE;



begin { BUILDTREE }
  { Open the data file (Polish code) written by MXD_DCP program }
  OPEN( pcdf, pcdf_name, [read_file,error_file] );

  if iostatus <> 0 then
  begin
    WRITELN( ' *** ', task_name, ' FATAL ERROR : Cannot open the MXD code file "',
             pcdf_name, '" error code = ', iostatus:0 );
    PASCAL_EXIT( 4 )
  end;


  sp   :=  -1;                                  { Init the stack pointer }
  lvar := nil;
  { the buildtree body build the expression trees }
  repeat
    tree := nil;
    GET_ND_CODE( nd_cd, op_cd );
    virt_node := false;

    if fdebug then WRITELN( ' SP = ', sp:4, ' / RPN code = ', nd_cd, ', ', op_cd );

    if op_cd <> op_null then
    case op_cd of
      op_eq,     op_ne,     op_lt,      { All binary operator without ... }
      op_le,     op_ge,     op_gt,      { ... derivate specific float }
      op_and,    op_xor,    op_or,
      op_add,    op_sub,    op_mod,
      op_rem,    op_idiv:
        begin
          NEW( tree, op_eq );           { Allocate a binary operator node }
          tree^.nod_typ := op_cd;       { Set the operator code }
          tree^.nod_bin2 := POP;        { Set the two arguments }
          tree^.nod_bin1 := POP
        end;

      op_mul,    op_div,    op_pow,
      op_phaser, op_phased:
        begin
          NEW( tree, op_mul );          { Allocate a binary operator node }
          tree^.nod_typ := op_cd;       { Set the operator code }
          tree^.nod_bind2 := POP;       { Get the y argument of ATAN<d/r>( x, y ) }
          tree^.nod_bind1 := POP;       { Get the x argument of ATAN<d/r>( x, y ) }
          tree^.nod_vbin1 := 0.0;
          tree^.nod_vbin2 := 0.0
        end;

      op_not,    op_neg,    op_trunc,
      op_round:
        begin
          NEW( tree, op_not );          { Allocate a binary operator node }
          tree^.nod_typ := op_cd;       { Set the operator code }
          tree^.nod_una := POP
        end;

      op_sinr,   op_cosr,   op_tanr,    { All unary operator with ... }
      op_asinr,  op_acosr,  op_atanr,   { ... derivate specific float }
      op_sind,   op_cosd,   op_tand,
      op_asind,  op_acosd,  op_atand,
      op_exp,    op_ln,     op_tanh,
      op_abs,    op_sqrt:
        begin
          NEW( tree, op_sinr );         { Allocate a binary operator node }
          tree^.nod_typ := op_cd;       { Set the operator code }
          tree^.nod_unad := POP;
          tree^.nod_vuna := 0.0
        end;

      op_ipw:
        begin
          NEW( tree, op_ipw );          { Allocate a binary operator node }
          tree^.nod_typ := op_ipw;      { Set the operator code }
          tree^.nod_iwe := POP;         { Get exponant n of x**n }
          tree^.nod_iwo := POP;         { Get operand x of x**n }
          tree^.nod_vpw := 0.0;
          tree^.nod_ipw :=   0
        end;

      op_bessj:
        begin
          NEW( tree, op_bessj );        { Allocate a binary operator node }
          tree^.nod_typ := op_bessj;    { Set the operator code }
          tree^.nod_bij_xe := POP;      { Get the x or Bj( x ) }
          tree^.nod_bij_ne := POP;      { Get the j order of Bessel function }
          tree^.nod_bij_d  := 0.0;
          tree^.nod_bij_n  := 0
        end;

      op_interpol:
        begin
          NEW( tree, op_interpol );     { Allocate a binary operator node }
          tree^.nod_typ := op_interpol; { Set the operator code }
          p2 := POP;                    { Get Interpolation abcisse }
          tree^.nod_itpnxt := nil;
          tree^.nod_itpexp := p2;       { Set Interpolation abcisse }
          p1 := POP;                    { Get Interpolation table node }
          if p1 <> nil then tree^.nod_itptab := p1^.nod_tabref
                       else tree^.nod_itptab := nil;
          tree^.nod_itpfco := 0;        { Assume normal interpolation operation until shown otherwise }
          if p1 <> nil then             { When the abscisse value is the standard $sithsl coefficient ... }
            if p1^.nod_typ = op_coeff then      { ... we set the possible interpolation result storage in HKL binary data file(s) }
              if p1^.nod_coeffid = coef_sithsl then tree^.nod_itpfco := -1;
          tree^.nod_itpval := 0.0;
          tree^.nod_itpder := 0.0;
          if interphde = nil then interphde := tree
                             else interplst^.nod_itpnxt := tree;
          interplst := tree
        end;

      op_integr:
        begin
          NEW( tree, op_integr );       { Allocate a binary operator node }
          tree^.nod_typ := op_integr;   { Set the operator code }
          tree^.nod_intexpr := POP;     { Get the expression to integrate }
          tree^.nod_intvar  := POP;     { Get the integration variable }
          p1 := POP;                    { Get Interpolation table node }
          if p1 <> nil then tree^.nod_inttab := p1^.nod_tabref
                       else tree^.nod_inttab := nil
        end;

      op_summ:
        begin
          NEW( tree, op_summ );         { Allocate a binary operator node }
          tree^.nod_typ := op_summ;     { Set the operator code }
          tree^.nod_exp  :=  POP;       { Get the expression to summ }
          tree^.nod_smidx := POP;       { Get the index variable definition }
          tree^.nod_smlb :=  POP;       { Get the step index value }
          tree^.nod_smle :=  POP;       { Get the end index value }
          tree^.nod_smls :=  POP        { Get the start index value }
        end;

      op_sumobs:
        begin
          NEW( tree, op_sumobs );       { Allocate a binary operator node }
          tree^.nod_typ := op_sumobs;   { Set the operator code }
          tree^.nod_osmv   := 0.0;
          tree^.nod_osmexp := POP;
          tree^.nod_osmlnk := nil;
          if sumhhde = nil then sumhhde := tree
                           else sumobs_last^.nod_osmlnk := tree;
          sumobs_last := tree
        end;

      op_ifsel:
        begin
          NEW( tree, op_ifsel );
          tree^.nod_typ := op_ifsel;
          tree^.nod_wfalse := POP;
          tree^.nod_wtrue  := POP;
          tree^.nod_cond   := POP;
          tree^.nod_icnd   :=   0
        end;

      op_funcall, op_formcall:
        begin
          NEW( tree, op_funcall );      { Allocate a binary operator node }
          READ( pcdf, narg );
          tree^.nod_typ := op_cd;       { Set the operator code }
          tree^.nod_parseflg := true;   { Set the parsing (of LOOK_VAR) flag }
          NEW( tree^.nod_arglist, narg );
          for ii := narg downto 0 do    { Allocate and fill the effective argument list (top arg. is the function to call) }
            tree^.nod_arglist^[ii] := POP
        end;

      op_select:
        begin
          NEW( tree, op_select );       { Allocate a binary operator node }
          READ( pcdf, narg );
          tree^.nod_typ := op_select;   { Set the operator code }
          tree^.nod_selast := 0;
          NEW( tree^.nod_seltab, narg );
          for ii := narg downto 0 do
            tree^.nod_seltab^[ii] := POP
        end;

      op_return:
        begin
          NEW( tree, op_return );
          tree^.nod_typ := op_return
        end;

      op_konst: { * Create a constant node * }
        begin
          NEW( tree, op_konst );        { Allocate a binary operator node }
          tree^.nod_typ := op_konst;
          READ( pcdf, tree^.nod_val );

          if fdebug then WRITELN( ' ':8, 'Enter Constant ', tree^.nod_val )

        end;

      op_coeff: { * Reference to internal application value * }
        begin
          READ( pcdf, nsq );            { Get internal reference number }
          if nsq < 0 then
            CREATE_VIRTUAL_VARBL( - nsq )
          else
          begin
            NEW( tree, op_coeff );      { Allocate a binary operator node }
            tree^.nod_typ := op_coeff;
            tree^.nod_coeffid := coef_codety( nsq );

            if fdebug then WRITELN( ' ':8, 'Internal Coeff. ref to iid  ', tree^.nod_coeffid:0 )

          end
        end;

      op_adatfl: { * Define an Additional Data Collection Field * }
        begin
          NEW( p2, op_adatfl );         { Allocate a binary operator node }
          p2^.nod_typ := op_adatfl;
          READ( pcdf, idx );            { Get the data record IID ... }
          READ_STR( p2^.nod_datname );  { ... and set its User Id Name }
          p2^.nod_datsequ := idx;       { Set the IID }
          p2^.nod_datoff := -1;         { Set the offset as not defined }
          NEW_REFERENCE( idx, p2 );     { Create the reference }

          if fdebug then with p2^ do
            WRITELN( ' ':8, 'Add ref to id "', nod_datname^, '" iid = ', idx:0 )

        end;

      op_tabref: { * Define a new table for Interpolation/integration * }
        begin
          READ( pcdf, nsq, narg );      { Get the new table int. ide. and its size }
          NEW( tree, op_tabref );       { Allocate a binary operator node }
          tree^.nod_typ := op_tabref;
          tree^.nod_tabide := nsq;
          { We must search the table id idx, and allocate it if not found }
          NEW( tree^.nod_tabref, narg );
          with tree^.nod_tabref^ do
            for ii := 1 to narg do  READ( pcdf, val_ftb[ii] );
          NEW_REFERENCE( tree^.nod_tabide, tree )
        end;

    otherwise
    end
    else
    case nd_cd of
      nd_definv: tree := NEW_ITEM( op_index );  { * Create a new index variable * }
      nd_defvar: tree := NEW_ITEM( op_varbl );  { * Create a LSQ variable * }
      nd_defpar: tree := NEW_ITEM( op_parm );   { * Create a LSQ expression (parameter) * }
      nd_item:   tree := NEW_ITEM( op_item );   { * Create a new ITEM * }
      nd_data:   tree := NEW_ITEM( op_data );   { * Create a new DATA ITEM * }

      nd_permut: { * To Permut the two stack top references * }
        begin
          if sp < 1 then begin  EXEC_ERROR( mdnam, 12 ); sp := 1  end;
          tmp := stk[sp]; stk[sp] := stk[sp-1]; stk[sp-1] := tmp
        end;

      nd_null: { * Push a Null reference/value * }
        PUSH( nil );

      nd_assvar:
        begin { * Assign a new value at a previously defined LSQ variable * }
          READ( pcdf, nsq );
          p2 := GET_REFERENCE( nsq );
          with p2^ do
            READ( pcdf, var_curval, var_cursig );

          if fdebug then with p2^ do
            WRITELN( ' ':8, 'Assign value ',  var_curval:8:3, ':', var_cursig:8:3, ' to the LSQ_VAR "', itm_name^, '"' )

        end;

      nd_paname:
        begin { * Assign a name at a previuosly defined expression * }
          READ( pcdf, nsq );
          p2 := GET_REFERENCE( nsq );
          if p2 <> nil then READ_STR( p2^.itm_name );

          if fdebug then with p2^ do
            WRITELN( ' ':8, 'Assign the name "', itm_name^, '" to the LSQ_PARM id ', itm_sequ:0 )

        end;

      nd_refer:
        begin { * Object Reference * }
          READ( pcdf, nsq );
          tree := GET_REFERENCE( nsq )
        end;

      nd_jobname: begin
                    READ_STR( job_name );

                    if fdebug then
                      if job_name <> nil then WRITELN( ' JOB_NAME  = "', job_name^,  '"' )

                  end;

      nd_title:   begin
                    READ_STR( job_title );

                    if fdebug then
                      if job_title <> nil then WRITELN( ' JOB_TITLE = "', job_title^, '"' )

                  end;

      nd_savfnam: begin
                    READ_STR( sav_fname );

                    if fdebug then
                      if sav_fname <> nil then WRITELN( ' SAV_FNAME = "', sav_fname^, '"' )

                  end;

      nd_string: { /// unimplemented /// };

      nd_itmref: { /// unimplemented /// };

      nd_itmfldr:
        begin
          READ( pcdf, i, j, nsq, idx );         { Read the item kind code, the item id, the new param id (or 0) and the offset }
          if j <= 0 then                        { When a current reference is used }
          begin
            NEW( tree, op_citmrf );             { Create the specific reference node }
            p2^.nod_typ    :=        op_citmrf;
            p2^.nod_citmty :=                i;
            p2^.nod_citmoff :=             idx
          end
          else
          begin                                 { For a fix/user refernce to a particular item }
            p1 := GET_REFERENCE( j );           { Get the item reference }
            if p1 <> nil then
            with p1^ do
            begin
              p2 := nil;
              case itm_kind of
                itm_phase:    if idx <=  8 then p2 := pha_par[idx];
                itm_atmgroup: if idx <= 11 then p2 := atg_par[idx];
                itm_atom:     if idx <= 11 then p2 := atm_par[idx];
                itm_npola:    if idx <=  2 then p2 := npo_par[idx];
                itm_moment:   if idx <=  6 then p2 := mom_par[idx];
                itm_mdsdsp:   if idx <=  7 then p2 := dsp_par[idx];
              otherwise
              end
            end
            else EXEC_ERROR( mdnam, 13 )
          end;
          if p2 = nil then EXEC_ERROR( mdnam, 8 )
          else
            if nsq > 0 then NEW_REFERENCE( nsq, p2 )  { Create a synonyme of already created LSQ_PARM (by PARPOP) }
                       else tree := p2
        end;

      nd_directive: GEN_DIRECTIVE;

    otherwise
      EXEC_ERROR( mdnam, 14 )           { Illegal or unimplemented pcdf code }
    end;
    if tree <> nil then PUSH( tree );

    if not EOF( pcdf ) then READLN( pcdf )
  until EOF( pcdf ) or fatal_error;
  if not bshort_flst then b132 := true;
  CLOSE( pcdf );
  iidshf := iidmax      { Update the IID shift for any next pcdf module loading }
end { BUILDTREE };



end MXD_TREE_BUILDER.
