/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"
static P Lx[1];

/* Define the local data section. */
static Blk( Rd, 1200 ) = {
  9,   9, 105, 110, 105, 116,  95, 116, 114, 101, 101,  55,  55,  47, 104, 111,
109, 101,  47, 119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47,
 99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  77,  88,  68,  86,  52,  95,
115, 114,  99,  47, 109, 120, 100,  95, 116, 114, 101, 101,  95,  98, 108, 100,
 46, 112,  97, 115,  21,  21,  77,  88,  68,  45,  84, 114, 101, 101,  45,  76,
111,  97, 100, 101, 114,  95,  73, 110, 105, 116,  32,  47,  47,  80,  46,  87,
111, 108, 102, 101, 114, 115,  32,  83, 111, 102, 116, 119,  97, 114, 101,  58,
 32,  77,  88,  68,  32,  86,  52,  46,  48,  45,  48,  48,  48,  32, 111, 102,
 32,  51,  49,  45,  68,  69,  67,  45,  50,  48,  49,  48,   0,   0,   5,   5,
 32,  42,  42,  42,  32,  15,  15,  77,  88,  68,  95,  84,  82,  69,  69,  95,
 76, 111,  97, 100, 101, 114,  68,  68,  32,  70,  65,  84,  65,  76,  32,  69,
 82,  82,  79,  82,  32,  58,  32,  67,  97, 110, 110, 111, 116,  32, 111, 112,
101, 110,  32, 116, 104, 101,  32, 100, 101, 102,  97, 117, 108, 116,  32,  76,
105, 115, 116, 105, 110, 103,  32,  70, 105, 108, 101,  32,  34,  34,  32, 101,
114, 114, 111, 114,  32,  99, 111, 100, 101,  32,  61,  32,  38,  38,  46,  47,
 44,  72,  79,  77,  69,  58,  47,  46, 109, 120, 100,  47,  44,  77,  88,  68,
 76,  73,  66,  58,  44,  47, 117, 115, 114,  47, 108, 111,  99,  97, 108,  47,
101, 116,  99,  47,  22,  22,  77,  88,  68,  76,  73,  66,  58, 109, 120, 100,
 95, 100,  99, 112,  46, 115, 116, 100,  95, 101, 110, 118,  16,  16, 109, 120,
100,  95, 116, 114, 101, 101,  46, 101, 114, 114,  95, 109, 115, 103,  13,  13,
110, 101, 119,  95, 114, 101, 102, 101, 114, 101, 110,  99, 101,  13,  13, 103,
101, 116,  95, 114, 101, 102, 101, 114, 101, 110,  99, 101,  11,  11,  98, 117,
105, 108, 100, 115, 121, 109,  98, 111, 108,  12,  12, 113, 117, 101, 117, 101,
 95, 111,  98, 106, 101,  99, 116,   4,   4, 112, 117, 115, 104,   4,   4,  80,
 85,  83,  72,   3,   3, 112, 111, 112,   4,   4,  80,  79,  80,  83,  11,  11,
114, 101,  97, 100,  95, 115, 116, 114, 105, 110, 103,   8,   8, 114, 101,  97,
100,  95, 115, 116, 114,  11,  11, 114, 101,  97, 100,  95, 109,  97, 116, 114,
105, 120,  15,  15, 114, 101,  97, 100,  95, 109,  97, 116, 114, 105, 120,  95,
111, 112, 101,  15,  15, 114, 101,  97, 100,  95, 115, 121, 109, 116, 114, 121,
 95, 111, 112, 101,  13,  13, 103, 101, 110,  95, 100, 105, 114, 101,  99, 116,
105, 118, 101,   4,   4,  68,  73,  82,  77,   6,   6, 118,  97, 108, 112, 111,
112,   4,   4,  71,  67,  84,  69,   6,   6, 112,  97, 114, 112, 111, 112,   0,
 66,   0,   0,   0,   6,   5,  46,  80,  83,  67,  65,   0,   6,   4,  46,  68,
 65,  65,   0,   0,   6,   4,  46,  68,  66,  66,   0,   0,   6,   4,  46,  68,
 67,  67,   0,   0,   6,   4,  46,  68,  65,  76,   0,   0,   6,   4,  46,  68,
 66,  69,   0,   0,   6,   4,  46,  68,  71,  65,   0,   0,   6,   5,  46,  67,
 65,  76,  67,   0,   6,   5,  46,  88,  79,  82,  71,   0,   6,   5,  46,  89,
 79,  82,  71,   0,   6,   5,  46,  90,  79,  82,  71,   0,   6,   4,  46,  79,
 77,  69,   0,   0,   6,   4,  46,  67,  72,  73,   0,   0,   6,   4,  46,  80,
 72,  73,   0,   0,   6,   5,  46,  82,  68,  73,  70,   0,   6,   5,  46,  73,
 68,  73,  70,   0,   6,   4,  46,  80,  79,  80,   0,   0,   6,   2,  46,  88,
  0,   0,   0,   0,   6,   2,  46,  89,   0,   0,   0,   0,   6,   2,  46,  90,
  0,   0,   0,   0,   6,   4,  46,  85,  49,  49,   0,   0,   6,   4,  46,  85,
 50,  50,   0,   0,   6,   4,  46,  85,  51,  51,   0,   0,   6,   4,  46,  85,
 50,  51,   0,   0,   6,   4,  46,  85,  51,  49,   0,   0,   6,   4,  46,  85,
 49,  50,   0,   0,   6,   4,  46,  77,  70,  70,   0,   0,   6,   4,  46,  82,
 77,  88,   0,   0,   6,   4,  46,  82,  77,  89,   0,   0,   6,   4,  46,  82,
 77,  90,   0,   0,   6,   4,  46,  73,  77,  88,   0,   0,   6,   4,  46,  73,
 77,  89,   0,   0,   6,   4,  46,  73,  77,  90,   0,   0,   6,   4,  46,  80,
 80,  77,   0,   0,   6,   4,  46,  80,  80,  72,   0,   0,   6,   4,  46,  82,
 85,  88,   0,   0,   6,   4,  46,  82,  85,  89,   0,   0,   6,   4,  46,  82,
 85,  90,   0,   0,   6,   4,  46,  73,  85,  88,   0,   0,   6,   4,  46,  73,
 85,  89,   0,   0,   6,   4,  46,  73,  85,  90,   0,   0,   6,   4,  46,  86,
 87,  88,   0,   0,   6,   4,  46,  86,  87,  89,   0,   0,   6,   4,  46,  86,
 87,  90,   0,   0,   6,   5,  46,  88,  80,  79,  76,   0,   6,   5,  46,  89,
 80,  79,  76,   0,   6,   5,  46,  90,  80,  79,  76,   0,   6,   5,  46,  69,
 70,  70,  80,   0,   6,   5,  46,  69,  70,  70,  77,   0,   6,   5,  46,  67,
 80,  79,  76,   0,   6,   5,  46,  67,  65,  76,  67,   0,   6,   4,  46,  79,
 66,  83,   0,   0,   6,   4,  46,  83,  73,  71,   0,   0,   6,   6,  87,  69,
 73,  71,  72,  84,   6,   6,  46,  83,  67,  65,  76,  69,   6,   5,  46,  70,
 78,  50,  67,   0,   6,   5,  46,  70,  77,  50,  67,   0,   6,   5,  46,  68,
 89,  78,  87,   0,   6,   5,  46,  76,  65,  77,  66,   0,   6,   5,  46,  89,
 70,  78,  67,   0,   6,   4,  46,  68,  77,  80,   0,   0,   6,   4,  46,  77,
 82,  81,   0,   0,   6,   5,  36,  67,  65,  76,  67,   0,   6,   4,  36,  70,
 78,  50,   0,   0,   6,   4,  36,  70,  77,  50,   0,   0,   6,   6,  36,  70,
 50,  80,  79,  76,   8,   8, 110, 101, 119,  95, 105, 116, 101, 109,   4,   4,
 66,  76,  68,  84,  11,  11,  77,  88,  68,  95,  68,  95, 102, 105, 108, 101,
 95,   4,   4,  46, 100,  97, 116,  20,  20,  99, 114, 101,  97, 116, 101,  95,
118, 105, 114, 116, 117,  97, 108,  95, 118,  97, 114,  98, 108,  11,  11, 103,
101, 116,  95, 110, 100,  95,  99, 111, 100, 101,   9,   9,  98, 117, 105, 108,
100, 116, 114, 101, 101,   5,   5,  32,  42,  42,  42,  32,  46,  46,  32,  70,
 65,  84,  65,  76,  32,  69,  82,  82,  79,  82,  32,  58,  32,  67,  97, 110,
110, 111, 116,  32, 111, 112, 101, 110,  32, 116, 104, 101,  32,  77,  88,  68,
 32,  99, 111, 100, 101,  32, 102, 105, 108, 101,  32,  34,  15,  15,  34,  32,
101, 114, 114, 111, 114,  32,  99, 111, 100, 101,  32,  61,  32,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 616 ) = {
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   4,
  6,   1,   3,   5,   7, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,  66,  66,  66,  66,  66,  52,  66,  66,  54,  53,
 66,  66,  66,  66,  55,  66,  66,  66,  66,  66,  66,  19,  20,  16,  40,  14,
 15,  13,  11,  12,   9,  10,   0,   1,   2,   3,   4,   5,   6,   7,   8,  38,
 39,  23,  24,  25,  26,  27,  28,  17,  29,  30,  31,  32,  33,  34,  18,  35,
 36,  37,  41,  41,  42,  43,  44,  21,  22,  65,  49,  48,  50,  51,  66,  65,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL PAS__iostatus;
extern UB V_bshort_flst;

/* Declaration of global variables. */
SL V_elpstim;
SL V_topcpu;
Blk(V_mxd_libdir, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
Blk(V_mxd_proc_name, 264 ) = {
255,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0 };
V V_interphde = NULL;
V V_sumhhde = NULL;
V V_gvarhde = NULL;
V V_varhde = NULL;
V V_parhde = NULL;
V V_usfuncthde = NULL;
V V_formalhde = NULL;
V V_loopidxhde = NULL;
V V_phashde = NULL;
V V_freeblk = NULL;
V V_dblkhde = NULL;
V V_datahde = NULL;
Blk(V_pardhde, 56 );
G V_hh;
G V_kk;
G V_ll;
G V_hc;
G V_kc;
G V_lc;
G V_hr;
G V_kr;
G V_lr;
G V_h1;
G V_k1;
G V_l1;
G V_h2;
G V_k2;
G V_l2;
G V_da;
G V_db;
G V_dc;
G V_dal;
G V_dbe;
G V_dga;
G V_ra;
G V_rb;
G V_rc;
G V_ral;
G V_rbe;
G V_rga;
G V_dvol;
G V_rvol;
Blk(V_curr_data, 2192 );
Blk(V_tmd, 72 );
Blk(V_tmr, 72 );
SL V_refcatsv;
SL V_nbfixed;
SL V_latticenb;
SL V_nbcoll;
SL V_ncpobs;
UB V_bfmagnetic;
UB V_bflimited;
UB V_buiso;
UB V_bcentric;
V V_job_name = NULL;
V V_job_title = NULL;
V V_sav_fname = NULL;
V V_pttl = NULL;
V V_psav = NULL;
G V_rgf;
G V_igf;
G V_fnr;
G V_fni;
G V_fxr;
G V_fyr;
G V_fzr;
G V_fxi;
G V_fyi;
G V_fzi;
G V_rp1;
G V_ip1;
G V_fmxr;
G V_fmyr;
G V_fmzr;
G V_fmxi;
G V_fmyi;
G V_fmzi;
G V_fnucl2;
G V_fmag2;
G V_fcalc2s;
G V_fcalc2;
G V_fstr;
G V_delta;
G V_curint;
V V_cvarbl = NULL;
V V_cformula = NULL;
V V_cparam = NULL;
V V_cphas = NULL;
V V_csymt = NULL;
V V_cwave = NULL;
V V_cpola = NULL;
V V_cagrp = NULL;
V V_catom = NULL;
V V_cmome = NULL;
V V_cmdsp = NULL;
V V_cdblk = NULL;
V V_cdata = NULL;
V V_pcte_one = NULL;
V V_interplst = NULL;
V V_sumhlst = NULL;
V V_gvarlst = NULL;
V V_varlst = NULL;
V V_parlst = NULL;
V V_usfunctlst = NULL;
V V_formallst = NULL;
V V_loopidxlst = NULL;
V V_phaslst = NULL;
V V_dblklst = NULL;
V V_datalst = NULL;
UL V_cselect;
SL V_iqwave;
SL V_mxcateg;
SL V_ccateg;
UB V_fatal_error = 0;
UB V_b132 = 0;
UB V_bshort_list = 0;
SL V_varnb = 0;
Blk(V_magsel, 72 );
Blk(V_virtvtab, 296 );
V V_pcdf = NULL;

/* Function/procedure prototypes. */
void P_lst_g_init(V F_def_lst, V F_def_heading, SL *F_ierr);
void P_err_init(V F_errf_str);
void P_exec_error(V F_md, SL F_nb, UB F_sev, V F_ide);
void P_search_file(V F_path, V F_fname, SL F_acc, V F_re, UB *F_fnd);
void P_set_option(SL F_npa);


/* Procedure/Function : " init_tree "  */
void P_init_tree(V F_mxdnam){
  /* Define the automatic variable space. */
  Blk( Ra, 536 );

  /* Local variable stored in C variable */
  SL Rv0;
  UB Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  register G Rgg;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=255;
  Ra.v[65]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+260;
  Ra.v[66]=Rd.s;
  Ra.v[67]=Rd.s+11;
  Ra.sl[68]=377; /* line # 377 */
  V_topcpu=PAS__G_ROUND(PAS__CLOCK());
  Ra.sl[68]=378; /* line # 378 */
  V_fatal_error=0;
  Ra.sl[68]=380; /* line # 380 */
  PAS__STR_TO_STR(Ra.s,PAS__CON_STR_STR(Ra.s+276,Rd.s+68,Rd.s+91));
  Ra.sl[68]=381; /* line # 381 */
  P_lst_g_init(Rd.s+140,Ra.s,&Rv0);
  Ra.sl[68]=382; /* line # 382 */
  if (Rv0!=0) {
    Ra.sl[68]=384; /* line # 384 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+142,-1,-1,32);
    PAS__WRITE_STR(Rd.s+149,-1,-1,32);
    PAS__WRITE_STR(Rd.s+166,-1,-1,32);
    PAS__WRITE_INT(Rv0,0,0);
    PAS__WRITE_EOLN();
    Ra.sl[68]=385; /* line # 385 */
    PAS__EXIT(4);
  }
  Ra.sl[68]=389; /* line # 389 */
  P_search_file(Rd.s+236,Rd.s+276,4, Ra.s,&Rv1);
  Ra.sl[68]=390; /* line # 390 */
  PAS__STR_TO_STR(V_mxd_libdir.s,PAS__SUBSTR_STR(Ra.s+276,Ra.s,1, Ra.ub[1]-22));
  Ra.sl[68]=393; /* line # 393 */
  P_err_init(PAS__CON_STR_STR(Ra.s+276,V_mxd_libdir.s,Rd.s+300));
  Ra.sl[68]=396; /* line # 396 */
  V_fatal_error=0;
  Ra.sl[68]=397; /* line # 397 */
  V_psav=NULL;
  V_pttl=NULL;
  Ra.sl[68]=398; /* line # 398 */
  V_iqwave=-1;
  Ra.sl[68]=399; /* line # 399 */
  V_nbcoll=0;
  Ra.sl[68]=400; /* line # 400 */
  V_nbfixed=0;
  Ra.sl[68]=401; /* line # 401 */
  V_bflimited=0;
  Ra.sl[68]=402; /* line # 402 */
  V_bfmagnetic=0;
  Ra.sl[68]=404; /* line # 404 */
  Rv2=0;
  for( Rf0=74;Rf0>0;Rf0-- ) {
    V_virtvtab.v[Rv2]=NULL;
    Rv2++;
  }
  Ra.sl[68]=407; /* line # 407 */
  V_parhde=NULL;
  V_gvarhde=NULL;
  V_freeblk=NULL;
  Ra.sl[68]=408; /* line # 408 */
  V_usfuncthde=NULL;
  V_loopidxhde=NULL;
  V_formalhde=NULL;
  Ra.sl[68]=409; /* line # 409 */
  V_sumhhde=NULL;
  Ra.sl[68]=410; /* line # 410 */
  V_freeblk=NULL;
  Ra.sl[68]=412; /* line # 412 */
  V_phashde=NULL;
  V_dblkhde=NULL;
  V_datahde=NULL;
  Ra.sl[68]=414; /* line # 414 */
  V_cselect=0;
  Ra.sl[68]=418; /* line # 418 */
  V_buiso=1;
  Ra.sl[68]=419; /* line # 419 */
  V_latticenb=1;
  Ra.sl[68]=420; /* line # 420 */
  V_bcentric=0;
  Ra.sl[68]=423; /* line # 423 */
  Rv3=0;
  for( Rf0=65;Rf0>0;Rf0-- ) {
    V_magsel.ub[Rv3]=1;
    Rv3++;
  }
  Ra.sl[68]=424; /* line # 424 */
  V_mxcateg=64;
  Ra.sl[68]=426; /* line # 426 */
  Ri.v[0]=PAS__NEW(1028);
  ((SL *)Ri.v[0])[0]=256;
  Ra.sl[68]=427; /* line # 427 */
  Rv4=0;
  for( Rf0=256;Rf0>0;Rf0-- ) {
    ((V *)Ri.v[0])[Rv4+1]=NULL;
    Rv4++;
  }
  Ra.sl[68]=430; /* line # 430 */
  V_pcte_one=PAS__NEW(16);
  Ra.sl[68]=431; /* line # 431 */
  ((UB *)V_pcte_one)[0]=52;
  Ra.sl[68]=432; /* line # 432 */
  ((G *)V_pcte_one)[1]=1.000000000000000E+000;
  PAS__curr_cntx=Ra.v[65];
}


/* Procedure/Function : " new_reference "  */
void MXD_TRELDER_new_reference(SL F_nsequ, V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  SL Rv10;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+318;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=453; /* line # 453 */
  if (F_nsequ<Ri.sl[1]) Ri.sl[1]=F_nsequ;
  Ra.sl[3]=458; /* line # 458 */
  F_nsequ=F_nsequ+Ri.sl[2];
  Ra.sl[3]=459; /* line # 459 */
  Rv0=((SL *)Ri.v[0])[0];
  Ra.sl[3]=460; /* line # 460 */
  Rv1=F_nsequ/256;
  Ra.sl[3]=461; /* line # 461 */
  if (Rv0<=Rv1) {
    Ra.sl[3]=463; /* line # 463 */
    Rv2=Rv0;
    Ra.sl[3]=464; /* line # 464 */
    Rv0=((Rv1+255)/256)*256;
    Ra.sl[3]=465; /* line # 465 */
    Rv3=Rv0;
    Rv4=PAS__NEW(((Rv3-1)+1)*4+4);
    ((SL *)Rv4)[0]=Rv3;
    Ra.sl[3]=466; /* line # 466 */
    Rv5=Ri.v[0];
    Ra.sl[3]=467; /* line # 467 */
    Rv6=0;
    for( Rf0=(Rv2-1)+1;Rf0>0;Rf0-- ) {
      ((V *)Rv4)[Rv6+1]=((V *)Rv5)[Rv6+1];
      Rv6++;
    }
    Ra.sl[3]=468; /* line # 468 */
    PAS__DISPOSE(Ri.v);
    Ra.sl[3]=469; /* line # 469 */
    Rv7=Rv2;
    for( Rf0=((Rv0-1)+1)-Rv2;Rf0>0;Rf0-- ) {
      ((V *)Rv4)[Rv7+1]=NULL;
      Rv7++;
    }
    Ra.sl[3]=470; /* line # 470 */
    Ri.v[0]=Rv4;
  }
  Ra.sl[3]=472; /* line # 472 */
  Rv8=Ri.v[0];
  Ra.sl[3]=474; /* line # 474 */
  if (((V *)Rv8)[Rv1+1]==NULL) {
    Ra.sl[3]=476; /* line # 476 */
    ((V *)Rv8)[Rv1+1]=PAS__NEW(1024);
    Ra.sl[3]=477; /* line # 477 */
    Rv9=((V *)Rv8)[Rv1+1];
    Ra.sl[3]=478; /* line # 478 */
    Rv10=0;
    for( Rf0=256;Rf0>0;Rf0-- ) {
      ((V *)Rv9)[Rv10]=NULL;
      Rv10++;
    }
  }
  Ra.sl[3]=480; /* line # 480 */
  ((V *)((V *)Rv8)[Rv1+1])[(F_nsequ&255)]=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_reference "  */
V P_get_reference(SL F_nsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+333;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=489; /* line # 489 */
  if (F_nsequ>0) {
    Ra.sl[3]=491; /* line # 491 */
    F_nsequ=F_nsequ+Ri.sl[2];
    Ra.sl[3]=492; /* line # 492 */
    Rv0=Ri.v[0];
    Ra.sl[3]=493; /* line # 493 */
    Ret=((V *)((V *)Rv0)[(F_nsequ/256)+1])[(F_nsequ&255)];
  }
  else {
    Ra.sl[3]=495; /* line # 495 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " buildsymbol "  */
V P_buildsymbol(V F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  register UB Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+348;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=507; /* line # 507 */
  Rv0=((UB *)F_symb)[1];
  Rv1=PAS__NEW((SL)Rv0+2);
  ((UB *)Rv1)[0]=Rv0;
  Ra.sl[3]=508; /* line # 508 */
  PAS__STR_TO_STR(Rv1,F_symb);
  Ra.sl[3]=509; /* line # 509 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " queue_object "  */
void P_queue_object(V *F_frs, V *F_lst, V F_nod){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+361;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=517; /* line # 517 */
  if ((*F_frs)==NULL) (*F_frs)=F_nod;
  else {
    Ra.sl[3]=518; /* line # 518 */
    ((V *)(*F_lst))[1]=F_nod;
  }
  Ra.sl[3]=519; /* line # 519 */
  (*F_lst)=F_nod;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " push "  */
void MXD_TRELDER_PRC_00000000(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+375;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=547; /* line # 547 */
  if (Lx[0].sl[0]>=256) P_exec_error(Rd.s+383,1,4, NULL);
  else Lx[0].sl[0]=Lx[0].sl[0]+1;
  Ra.sl[3]=548; /* line # 548 */
  Lx[0].v[Lx[0].sl[0]+1]=F_p;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " pop "  */
V MXD_TRELDER_PRC_00000001(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+387;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=556; /* line # 556 */
  if (Lx[0].sl[0]<0) {
    Ra.sl[3]=557; /* line # 557 */
    P_exec_error(Rd.s+394,2,4, NULL);
    Ret=NULL;
  }
  else {
    Ra.sl[3]=559; /* line # 559 */
    Ret=Lx[0].v[Lx[0].sl[0]+1];
    Lx[0].sl[0]=Lx[0].sl[0] -1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " read_string "  */
void MXD_TRELDER_PRC_00000002(V F_str){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  C Rv1;
  SL Rv2;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+398;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=570; /* line # 570 */
  PAS__SELECT_INP(V_pcdf);
  PAS__READ_SL(&Rv0,0);
  Ra.sl[3]=571; /* line # 571 */
  if (Rv0>((UB *)F_str)[0]) Rv0=((UB *)F_str)[0];
  Ra.sl[3]=572; /* line # 572 */
  if (Rv0>0) {
    Ra.sl[3]=574; /* line # 574 */
    PAS__SELECT_INP(V_pcdf);
    PAS__READ_CHAR(&Rv1);
    Ra.sl[3]=575; /* line # 575 */
    Rv2=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=576; /* line # 576 */
      if (Rv2<=Rv0) {
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_CHAR((((C *)F_str)+Rv2+1));
      }
      else {
        Ra.sl[3]=577; /* line # 577 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_CHAR(&Rv1);
      }
      Rv2++;
    }
  }
  Ra.sl[3]=579; /* line # 579 */
  ((UB *)F_str)[1]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_str "  */
void MXD_TRELDER_PRC_00000003(V *F_pid, SL F_max){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  C Rv2;
  SL Rv3;
  register UB Rv4;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+411;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=592; /* line # 592 */
  PAS__SELECT_INP(V_pcdf);
  PAS__READ_SL(&Rv0,0);
  Ra.sl[3]=593; /* line # 593 */
  Rv1=Rv0;
  Ra.sl[3]=594; /* line # 594 */
  if (Rv1>Ri.ub[12]) Rv1=Ri.ub[12];
  Ra.sl[3]=595; /* line # 595 */
  if (F_max>0&&F_max<Rv1) Rv1=F_max;
  Ra.sl[3]=596; /* line # 596 */
  Ri.ub[13]=Rv1;
  Ra.sl[3]=597; /* line # 597 */
  if (Rv0>0) {
    Ra.sl[3]=599; /* line # 599 */
    PAS__SELECT_INP(V_pcdf);
    PAS__READ_CHAR(&Rv2);
    Ra.sl[3]=600; /* line # 600 */
    Rv3=1;
    for( Rf0=Rv0;Rf0>0;Rf0-- ) {
      Ra.sl[3]=601; /* line # 601 */
      if (Rv3<=Rv1) {
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_CHAR((Ri.c+Rv3+13));
      }
      else {
        Ra.sl[3]=602; /* line # 602 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_CHAR(&Rv2);
      }
      Rv3++;
    }
  }
  Ra.sl[3]=604; /* line # 604 */
  if (Rv1<1) (*F_pid)=NULL;
  else {
    Ra.sl[3]=605; /* line # 605 */
    Rv4=Rv1;
    (*F_pid)=PAS__NEW((SL)Rv4+2);
    ((UB *)(*F_pid))[0]=Rv4;
    PAS__STR_TO_STR((*F_pid),Ri.s+12);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_matrix "  */
void MXD_TRELDER_PRC_00000004(V F_mat){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+421;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=612; /* line # 612 */
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=613; /* line # 613 */
    for( Rf0=3;Rf0>0;Rf0-- ) {
      Ra.sl[3]=614; /* line # 614 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_DBLE((((G *)F_mat)+Lx[0].sl[258]*3+Lx[0].sl[259]-4),0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_matrix_ope "  */
void MXD_TRELDER_PRC_00000005(V F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+434;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=621; /* line # 621 */
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=622; /* line # 622 */
    for( Rf0=4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=623; /* line # 623 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_DBLE((((G *)F_ope)+Lx[0].sl[258]*4+Lx[0].sl[259]-5),0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " read_symtry_ope "  */
void MXD_TRELDER_PRC_00000006(V F_ope){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+451;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=630; /* line # 630 */
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=631; /* line # 631 */
    for( Rf0=4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=632; /* line # 632 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_UB((((UB *)F_ope)+Lx[0].sl[258]*4+Lx[0].sl[259]-5),0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_directive "  */
void MXD_TRELDER_PRC_00000007(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  SL Rv7;
  C Rv8;
  SL Rv9;
  G Rv10;
  G Rv11;
  V Rv12;
  register int Rf0;

  /* Code of procedure/function */
  Ra.ub[0]=14;
  Ra.v[4]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[5]=Rd.s+468;
  Ra.v[6]=Rd.s+11;
  Ra.sl[7]=652; /* line # 652 */
  PAS__SELECT_INP(V_pcdf);
  PAS__READ_SL(&Rv0,0);
  PAS__READ_SL(&Rv1,0);
  PAS__READ_SL(&Rv2,0);
  Ra.sl[7]=653; /* line # 653 */
  Rv3=(UB)Rv0;
  Ra.sl[7]=657; /* line # 657 */
  switch (Rv3) {
    case 10:Ra.sl[7]=658; /* line # 658 */
    if (Rv2>0) P_set_option(Rv2);
    break;
    case 1:Ra.sl[7]=661; /* line # 661 */
    Rv4=P_get_reference(Rv1);
    Ra.sl[7]=662; /* line # 662 */
    if (Rv4==NULL) P_exec_error(Rd.s+485,4,4, NULL);
    else {
      Ra.sl[7]=664; /* line # 664 */
      Rv5=Rv4+112;
      Ra.sl[7]=666; /* line # 666 */
      ((UB *)Rv5)[2468]=0;
      Ra.sl[7]=667; /* line # 667 */
      ((SL *)Rv5)[616]=0;
      Ra.sl[7]=668; /* line # 668 */
      if (Rv0>0) ((UB *)Rv5)[2484]=((UB *)Rv5)[2484]|16;
      else {
        Ra.sl[7]=669; /* line # 669 */
        ((UB *)Rv5)[2484]=((UB *)Rv5)[2484]&~16;
      }
    }
    break;
    case 2:
    case 3:Ra.sl[7]=674; /* line # 674 */
    if (Rv2>0) {
      Ra.sl[7]=676; /* line # 676 */
      Rv4=P_get_reference(Rv1);
      Ra.sl[7]=677; /* line # 677 */
      if (Rv4==NULL) {
        Ra.sl[7]=678; /* line # 678 */
        P_exec_error(Rd.s+485,5,4, NULL);
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_EOLN();
      }
      else {
        Ra.sl[7]=680; /* line # 680 */
        Rv6=Rv4+112;
        Ra.sl[7]=682; /* line # 682 */
        MXD_TRELDER_PRC_00000002(Ra.s);
        Ra.sl[7]=683; /* line # 683 */
        ((UB *)Rv6)[2468]=Ra.ub[1];
        Ra.sl[7]=684; /* line # 684 */
        Rv7=1;
        for( Rf0=Ra.ub[1];Rf0>0;Rf0-- ) {
          ((C *)Rv6)[Rv7+2468]=Ra.c[Rv7+1];
          Rv7++;
        }
        Ra.sl[7]=685; /* line # 685 */
        if (Rv3==3) ((SL *)Rv6)[616]=-1;
        else {
          Ra.sl[7]=686; /* line # 686 */
          ((SL *)Rv6)[616]=0;
        }
        Ra.sl[7]=687; /* line # 687 */
        if (((UB *)Rv6)[2468]>0) {
          Ra.sl[7]=689; /* line # 689 */
          Rv8=((C *)Rv6)[2469];
          Ra.sl[7]=690; /* line # 690 */
          if (Rv8==114||Rv8==82) ((UB *)Rv6)[2484]=((UB *)Rv6)[2484]|8;
          else {
            Ra.sl[7]=691; /* line # 691 */
            ((UB *)Rv6)[2484]=((UB *)Rv6)[2484]&~8;
          }
        }
      }
      Ra.sl[7]=695; /* line # 695 */
    }
    break;
    case 11:
    case 12:Ra.sl[7]=703; /* line # 703 */
    PAS__SELECT_INP(V_pcdf);
    PAS__READ_SL(&Rv9,0);
    Rv4=P_get_reference(Rv9);
    Ra.sl[7]=704; /* line # 704 */
    if (Rv4!=NULL) {
      Ra.sl[7]=705; /* line # 705 */
      if (((UB *)Rv4)[0]==57) {
        Ra.sl[7]=707; /* line # 707 */
        ((SL *)Rv4)[6]=(SL)(Rv3==12);
        Ra.sl[7]=709; /* line # 709 */
      }
    }
    break;
    case 13:Ra.sl[7]=720; /* line # 720 */
    PAS__SELECT_INP(V_pcdf);
    PAS__READ_DBLE(&Rv10,0);
    PAS__READ_DBLE(&Rv11,0);
    PAS__READ_SL(&Rv9,0);
    Rv4=P_get_reference(Rv9);
    Ra.sl[7]=721; /* line # 721 */
    if (Rv4!=NULL) {
      Ra.sl[7]=722; /* line # 722 */
      if (((UB *)Rv4)[0]==57) {
        Ra.sl[7]=724; /* line # 724 */
        Rv12=PAS__NEW(16);
        ((V *)Rv4)[8]=Rv12;
        Ra.sl[7]=725; /* line # 725 */
        ((G *)Rv12)[0]=Rv10;
        ((G *)Rv12)[1]=Rv11;
        Ra.sl[7]=727; /* line # 727 */
      }
    }
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[4];
}


/* Procedure/Function : " valpop "  */
G MXD_TRELDER_PRC_00000008(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  G Rv1;
  register G Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+489;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=747; /* line # 747 */
  Rv0=MXD_TRELDER_PRC_00000001();
  Ra.sl[3]=748; /* line # 748 */
  Rv1=0.000000000000000E-001;
  Ra.sl[3]=749; /* line # 749 */
  if (Rv0!=NULL) {
    Ra.sl[3]=751; /* line # 751 */
    if (((UB *)Rv0)[0]!=52) P_exec_error(Rd.s+499,15,4, NULL);
    else {
      Ra.sl[3]=752; /* line # 752 */
      Rv1=((G *)Rv0)[1];
    }
    Ra.sl[3]=753; /* line # 753 */
    PAS__DISPOSE(&Rv0);
  }
  Ra.sl[3]=755; /* line # 755 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " parpop "  */
V MXD_TRELDER_PRC_00000009(SL F_id_name){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+503;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=767; /* line # 767 */
  Rv0=MXD_TRELDER_PRC_00000001();
  Ra.sl[3]=768; /* line # 768 */
  if (Rv0==NULL) Ret=NULL;
  else {
    Ra.sl[3]=769; /* line # 769 */
    if (((UB *)Rv0)[0]==58) Ret=Rv0;
    else {
      Ra.sl[3]=772; /* line # 772 */
      Rv1=PAS__NEW(56);
      Ra.sl[3]=773; /* line # 773 */
      Rv2=Rv1;
      Ra.sl[3]=775; /* line # 775 */
      ((UB *)Rv2)[0]=58;
      Ra.sl[3]=776; /* line # 776 */
      ((V *)Rv2)[1]=NULL;
      Ra.sl[3]=777; /* line # 777 */
      ((V *)Rv2)[2]=NULL;
      Ra.sl[3]=778; /* line # 778 */
      if (F_id_name>=0) ((V *)Rv2)[3]=(Rd.s+F_id_name*8+508);
      else {
        Ra.sl[3]=779; /* line # 779 */
        ((V *)Rv2)[3]=NULL;
      }
      Ra.sl[3]=780; /* line # 780 */
      ((SL *)Rv2)[4]=0;
      Ra.sl[3]=781; /* line # 781 */
      ((UB *)Rv2)[20]=1;
      Ra.sl[3]=782; /* line # 782 */
      ((UB *)Rv2)[21]=2;
      Ra.sl[3]=783; /* line # 783 */
      ((V *)Rv2)[8]=NULL;
      Ra.sl[3]=784; /* line # 784 */
      ((V *)Rv2)[6]=Rv0;
      Ra.sl[3]=785; /* line # 785 */
      ((G *)Rv2)[5]=0.000000000000000E-001;
      Ra.sl[3]=786; /* line # 786 */
      ((G *)Rv2)[6]=0.000000000000000E-001;
      Ra.sl[3]=788; /* line # 788 */
      P_queue_object(&V_parhde, &V_parlst, Rv1);
      Ra.sl[3]=789; /* line # 789 */
      Ret=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_item "  */
V MXD_TRELDER_PRC_00000010(UB F_cd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  UB Rv2;
  SL Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  UB Rv7;
  UB Rv8;
  register V Rv9;
  register V Rv10;
  V Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  register V Rv20;
  SL Rv21;
  register V Rv22;
  SL Rv23;
  register V Rv24;
  UB Rv25;
  SL Rv26;
  register V Rv27;
  SL Rv28;
  SL Rv29;
  register V Rv30;
  SL Rv31;
  register V Rv32;
  register V Rv33;
  SL Rv34;
  register UB Rv35;
  register SL Rv36;
  SL Rv37;
  register int Rf1, Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1044;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=813; /* line # 813 */
  Rv0=NULL;
  Ra.sl[3]=814; /* line # 814 */
  Rv1=0;
  Ra.sl[3]=815; /* line # 815 */
  switch (F_cd) {
    case 57:Ra.sl[3]=816; /* line # 816 */
    Rv0=PAS__NEW(56);
    Rv2=0;
    break;
    case 58:Ra.sl[3]=817; /* line # 817 */
    Rv0=PAS__NEW(56);
    Rv2=1;
    break;
    case 60:Ra.sl[3]=818; /* line # 818 */
    Rv0=PAS__NEW(32);
    Rv2=2;
    break;
    case 61:Ra.sl[3]=819; /* line # 819 */
    Rv0=PAS__NEW(32);
    Rv2=3;
    break;
    case 56:Ra.sl[3]=820; /* line # 820 */
    Rv0=PAS__NEW(32);
    Rv2=4;
    break;
    case 62:
    case 63:Ra.sl[3]=823; /* line # 823 */
    PAS__SELECT_INP(V_pcdf);
    PAS__READ_SL(&Rv3,0);
    PAS__READ_SL(&Rv4,0);
    PAS__READ_SL(&Rv5,0);
    Ra.sl[3]=824; /* line # 824 */
    if (F_cd!=63) {
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(&Rv6,0);
    }
    Ra.sl[3]=825; /* line # 825 */
    Rv7=(UB)Rv3;
    Ra.sl[3]=826; /* line # 826 */
    switch (Rv7) {
      case 1:Ra.sl[3]=827; /* line # 827 */
      Rv0=PAS__NEW(40);
      Rv2=14;
      break;
      case 2:Ra.sl[3]=828; /* line # 828 */
      Rv0=PAS__NEW(234);
      Rv2=8;
      break;
      case 3:Ra.sl[3]=829; /* line # 829 */
      Rv0=PAS__NEW(80);
      Rv2=9;
      break;
      case 4:Ra.sl[3]=830; /* line # 830 */
      Rv0=PAS__NEW(112);
      Rv2=15;
      break;
      case 10:Ra.sl[3]=831; /* line # 831 */
      Rv0=PAS__NEW(2597);
      Rv2=5;
      break;
      case 11:Ra.sl[3]=832; /* line # 832 */
      Rv0=PAS__NEW(164);
      Rv2=6;
      break;
      case 15:
      case 16:Ra.sl[3]=834; /* line # 834 */
      Rv0=PAS__NEW(90);
      Rv2=7;
      break;
      case 17:Ra.sl[3]=835; /* line # 835 */
      Rv0=PAS__NEW(60);
      Rv2=10;
      break;
      case 18:Ra.sl[3]=836; /* line # 836 */
      Rv0=PAS__NEW(64);
      Rv2=11;
      break;
      case 20:Ra.sl[3]=837; /* line # 837 */
      Rv0=PAS__NEW(40);
      Rv2=13;
      break;
      case 21:
      case 22:
      case 23:
      case 25:
      case 26:
      case 27:Ra.sl[3]=843; /* line # 843 */
      Rv0=PAS__NEW(104);
      Ra.sl[3]=844; /* line # 844 */
      Rv2=12;
      Rv8=Ri.ub[Rv7+248];
      break;
      case 24:
      case 28:Ra.sl[3]=849; /* line # 849 */
      Rv0=PAS__NEW(72);
      Ra.sl[3]=850; /* line # 850 */
      Rv2=12;
      Rv8=Ri.ub[Rv7+248];
      break;
      case 29:Ra.sl[3]=855; /* line # 855 */
      Rv0=PAS__NEW(72);
      Ra.sl[3]=856; /* line # 856 */
      Rv2=12;
      Rv8=8;
      break;
      default:break;
    }
    Ra.sl[3]=861; /* line # 861 */
    if (Rv0!=NULL) {
      Ra.sl[3]=862; /* line # 862 */
      Rv9=Rv0;
      Ra.sl[3]=864; /* line # 864 */
      ((UB *)Rv9)[0]=F_cd;
      Ra.sl[3]=865; /* line # 865 */
      ((V *)Rv9)[1]=NULL;
      Ra.sl[3]=866; /* line # 866 */
      ((V *)Rv9)[2]=NULL;
      Ra.sl[3]=867; /* line # 867 */
      MXD_TRELDER_PRC_00000003(((V *)Rv9)+3,0);
      Ra.sl[3]=868; /* line # 868 */
      ((SL *)Rv9)[4]=Rv5;
      Ra.sl[3]=869; /* line # 869 */
      ((UB *)Rv9)[20]=Rv2;
    }
    break;
    default:break;
  }
  Ra.sl[3]=874; /* line # 874 */
  if (Rv0!=NULL) {
    Ra.sl[3]=875; /* line # 875 */
    Rv10=Rv0;
    Ra.sl[3]=877; /* line # 877 */
    if (F_cd!=66) ((UB *)Rv10)[0]=F_cd;
    else {
      Ra.sl[3]=878; /* line # 878 */
      ((UB *)Rv10)[0]=62;
    }
    Ra.sl[3]=879; /* line # 879 */
    ((V *)Rv10)[1]=NULL;
    Ra.sl[3]=880; /* line # 880 */
    ((V *)Rv10)[2]=NULL;
    Ra.sl[3]=881; /* line # 881 */
    if (F_cd!=62&&F_cd!=63) ((SL *)Rv10)[4]=0;
    Ra.sl[3]=882; /* line # 882 */
    ((UB *)Rv10)[20]=Rv2;
    Ra.sl[3]=883; /* line # 883 */
    switch (Rv2) {
      case 0:Ra.sl[3]=885; /* line # 885 */
      ((SL *)Rv10)[6]=1;
      Ra.sl[3]=886; /* line # 886 */
      ((SL *)Rv10)[7]=-1;
      Ra.sl[3]=887; /* line # 887 */
      ((V *)Rv10)[8]=NULL;
      Ra.sl[3]=888; /* line # 888 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+4,0);
      PAS__READ_DBLE(((G *)Rv10)+5,0);
      PAS__READ_DBLE(((G *)Rv10)+6,0);
      Ra.sl[3]=889; /* line # 889 */
      MXD_TRELDER_PRC_00000003(((V *)Rv10)+3,0);
      Ra.sl[3]=891; /* line # 891 */
      Ra.sl[3]=895; /* line # 895 */
      P_queue_object(&V_gvarhde, &V_gvarlst, Rv0);
      break;
      case 1:Ra.sl[3]=898; /* line # 898 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+4,0);
      MXD_TRELDER_PRC_00000003(((V *)Rv10)+3,0);
      Ra.sl[3]=899; /* line # 899 */
      ((UB *)Rv10)[21]=2;
      Ra.sl[3]=900; /* line # 900 */
      ((V *)Rv10)[6]=MXD_TRELDER_PRC_00000001();
      Ra.sl[3]=901; /* line # 901 */
      ((V *)Rv10)[7]=NULL;
      Ra.sl[3]=902; /* line # 902 */
      ((V *)Rv10)[8]=NULL;
      Ra.sl[3]=903; /* line # 903 */
      ((G *)Rv10)[5]=0.000000000000000E-001;
      Ra.sl[3]=904; /* line # 904 */
      ((G *)Rv10)[6]=0.000000000000000E-001;
      Ra.sl[3]=905; /* line # 905 */
      P_queue_object(&V_parhde, &V_parlst, Rv0);
      Ra.sl[3]=907; /* line # 907 */
      break;
      case 2:Ra.sl[3]=913; /* line # 913 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+4,0);
      MXD_TRELDER_PRC_00000003(((V *)Rv10)+3,0);
      Ra.sl[3]=914; /* line # 914 */
      ((G *)Rv10)[3]=0.000000000000000E-001;
      Ra.sl[3]=915; /* line # 915 */
      Rv1=1;
      Ra.sl[3]=917; /* line # 917 */
      break;
      case 3:Ra.sl[3]=922; /* line # 922 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+4,0);
      MXD_TRELDER_PRC_00000003(((V *)Rv10)+3,0);
      Ra.sl[3]=923; /* line # 923 */
      ((V *)Rv10)[6]=NULL;
      Ra.sl[3]=924; /* line # 924 */
      ((V *)Rv10)[7]=NULL;
      Ra.sl[3]=925; /* line # 925 */
      Rv1=1;
      Ra.sl[3]=927; /* line # 927 */
      break;
      case 4:Ra.sl[3]=932; /* line # 932 */
      ((V *)Rv10)[6]=NULL;
      Ra.sl[3]=933; /* line # 933 */
      ((V *)Rv10)[7]=MXD_TRELDER_PRC_00000001();
      Ra.sl[3]=934; /* line # 934 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+4,0);
      PAS__READ_SL(&Rv4,0);
      Ra.sl[3]=935; /* line # 935 */
      while (Rv4>0){
        Ra.sl[3]=937; /* line # 937 */
        Rv11=MXD_TRELDER_PRC_00000001();
        Ra.sl[3]=938; /* line # 938 */
        ((V *)Rv11)[6]=((V *)Rv10)[6];
        Ra.sl[3]=939; /* line # 939 */
        ((V *)Rv10)[6]=Rv11;
      }
      Ra.sl[3]=942; /* line # 942 */
      break;
      case 5:Ra.sl[3]=946; /* line # 946 */
      Rv12=6;
      for( Rf1=7;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv12+20]=MXD_TRELDER_PRC_00000009(1+Rv12);
        Rv12--;
      }
      Ra.sl[3]=947; /* line # 947 */
      if (((V *)Rv10)[20]==NULL) ((V *)Rv10)[20]=V_pcte_one;
      Ra.sl[3]=948; /* line # 948 */
      if (((V *)Rv10)[23]==NULL) ((V *)Rv10)[23]=((V *)Rv10)[21];
      Ra.sl[3]=949; /* line # 949 */
      if (((V *)Rv10)[22]==NULL) ((V *)Rv10)[22]=((V *)Rv10)[21];
      Ra.sl[3]=950; /* line # 950 */
      if (((V *)Rv10)[24]!=NULL) {
        Ra.sl[3]=952; /* line # 952 */
        if (((V *)Rv10)[25]==NULL) ((V *)Rv10)[25]=((V *)Rv10)[24];
        Ra.sl[3]=953; /* line # 953 */
        if (((V *)Rv10)[26]==NULL) ((V *)Rv10)[26]=((V *)Rv10)[24];
      }
      Ra.sl[3]=955; /* line # 955 */
      ((V *)Rv10)[6]=NULL;
      ((V *)Rv10)[7]=NULL;
      Ra.sl[3]=956; /* line # 956 */
      ((V *)Rv10)[14]=NULL;
      ((V *)Rv10)[15]=NULL;
      Ra.sl[3]=957; /* line # 957 */
      ((V *)Rv10)[8]=NULL;
      ((V *)Rv10)[9]=NULL;
      Ra.sl[3]=958; /* line # 958 */
      ((V *)Rv10)[10]=NULL;
      ((V *)Rv10)[11]=NULL;
      Ra.sl[3]=959; /* line # 959 */
      ((V *)Rv10)[14]=NULL;
      ((V *)Rv10)[15]=NULL;
      Ra.sl[3]=960; /* line # 960 */
      Rv13=Rv10+112;
      Ra.sl[3]=962; /* line # 962 */
      ((UB *)Rv13)[2468]=0;
      Ra.sl[3]=963; /* line # 963 */
      ((SL *)Rv13)[616]=999;
      Ra.sl[3]=964; /* line # 964 */
      ((UB *)Rv13)[2484]=1;
      Ra.sl[3]=966; /* line # 966 */
      P_queue_object(&V_phashde, &V_phaslst, Rv0);
      Ra.sl[3]=967; /* line # 967 */
      V_cagrp=Rv0;
      Ra.sl[3]=968; /* line # 968 */
      V_cphas=Rv0;
      Ra.sl[3]=970; /* line # 970 */
      break;
      case 15:Ra.sl[3]=975; /* line # 975 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=976; /* line # 976 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,3,4, NULL);
      else {
        Ra.sl[3]=977; /* line # 977 */
        Rv15=Rv14;
        P_queue_object(((V *)Rv15)+6,((V *)Rv15)+7,Rv0);
      }
      Ra.sl[3]=978; /* line # 978 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_EOLN();
      Ra.sl[3]=979; /* line # 979 */
      MXD_TRELDER_PRC_00000006(Rv10+21);
      Ra.sl[3]=981; /* line # 981 */
      break;
      case 8:Ra.sl[3]=987; /* line # 987 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=988; /* line # 988 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,6,4, NULL);
      else {
        Ra.sl[3]=989; /* line # 989 */
        Rv16=Rv14;
        P_queue_object(((V *)Rv16)+8,((V *)Rv16)+9,Rv0);
      }
      Ra.sl[3]=990; /* line # 990 */
      ((V *)Rv10)[6]=Rv14;
      Ra.sl[3]=991; /* line # 991 */
      Rv17=2;
      for( Rf1=3;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv17+7]=MXD_TRELDER_PRC_00000009(42+Rv17);
        Rv17--;
      }
      Ra.sl[3]=992; /* line # 992 */
      Rv18=1;
      for( Rf1=3;Rf1>0;Rf1-- ) {
        Rv19=0;
        for( Rf0=7;Rf0>0;Rf0-- ) {
          ((G *)Rv10)[Rv18*7+Rv19+1]=0.000000000000000E-001;
          Rv19++;
        }
        Rv18++;
      }
      Ra.sl[3]=993; /* line # 993 */
      ((UB *)Rv10)[232]=1;
      Ra.sl[3]=995; /* line # 995 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_EOLN();
      Ra.sl[3]=996; /* line # 996 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(&Rv3,0);
      Ra.sl[3]=997; /* line # 997 */
      ((UB *)Rv10)[233]=Rv3>0;
      Ra.sl[3]=999; /* line # 999 */
      break;
      case 9:Ra.sl[3]=1005; /* line # 1005 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=1006; /* line # 1006 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,7,4, NULL);
      else {
        Ra.sl[3]=1007; /* line # 1007 */
        Rv20=Rv14;
        P_queue_object(((V *)Rv20)+10,((V *)Rv20)+11,Rv0);
      }
      Ra.sl[3]=1008; /* line # 1008 */
      Rv21=5;
      for( Rf1=6;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv21+7]=MXD_TRELDER_PRC_00000009(45+Rv21);
        Rv21--;
      }
      Ra.sl[3]=1009; /* line # 1009 */
      ((G *)Rv10)[7]=0.000000000000000E-001;
      ((G *)Rv10)[8]=0.000000000000000E-001;
      ((G *)Rv10)[9]=0.000000000000000E-001;
      Ra.sl[3]=1010; /* line # 1010 */
      break;
      case 6:Ra.sl[3]=1017; /* line # 1017 */
      ((V *)Rv10)[6]=NULL;
      Ra.sl[3]=1018; /* line # 1018 */
      ((V *)Rv10)[7]=V_cagrp;
      Ra.sl[3]=1019; /* line # 1019 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=1020; /* line # 1020 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,8,4, NULL);
      else {
        Ra.sl[3]=1022; /* line # 1022 */
        Rv22=Rv14;
        Ra.sl[3]=1023; /* line # 1023 */
        switch (((UB *)Rv22)[20]) {
          case 5:Ra.sl[3]=1024; /* line # 1024 */
          P_queue_object(((V *)Rv22)+14,((V *)Rv22)+15,Rv0);
          break;
          case 6:Ra.sl[3]=1025; /* line # 1025 */
          P_queue_object(((V *)Rv22)+8,((V *)Rv22)+9,Rv0);
          break;
          default:Ra.sl[3]=1027; /* line # 1027 */
          P_exec_error(Rd.s+1056,8,4, NULL);
          break;
        }
      }
      Ra.sl[3]=1029; /* line # 1029 */
      V_cagrp=Rv0;
      Ra.sl[3]=1031; /* line # 1031 */
      Rv23=6;
      for( Rf1=7;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv23+34]=MXD_TRELDER_PRC_00000009(8+Rv23);
        Rv23--;
      }
      Ra.sl[3]=1032; /* line # 1032 */
      ((V *)Rv10)[8]=NULL;
      Ra.sl[3]=1033; /* line # 1033 */
      ((V *)Rv10)[9]=NULL;
      Ra.sl[3]=1034; /* line # 1034 */
      ((G *)Rv10)[7]=0.000000000000000E-001;
      Ra.sl[3]=1035; /* line # 1035 */
      ((G *)Rv10)[8]=0.000000000000000E-001;
      Ra.sl[3]=1036; /* line # 1036 */
      ((G *)Rv10)[9]=0.000000000000000E-001;
      Ra.sl[3]=1037; /* line # 1037 */
      ((G *)Rv10)[10]=0.000000000000000E-001;
      Ra.sl[3]=1038; /* line # 1038 */
      ((G *)Rv10)[11]=0.000000000000000E-001;
      Ra.sl[3]=1039; /* line # 1039 */
      ((G *)Rv10)[12]=0.000000000000000E-001;
      Ra.sl[3]=1040; /* line # 1040 */
      ((G *)Rv10)[13]=0.000000000000000E-001;
      Ra.sl[3]=1041; /* line # 1041 */
      ((G *)Rv10)[14]=0.000000000000000E-001;
      Ra.sl[3]=1042; /* line # 1042 */
      ((G *)Rv10)[15]=0.000000000000000E-001;
      Ra.sl[3]=1043; /* line # 1043 */
      ((G *)Rv10)[16]=0.000000000000000E-001;
      Ra.sl[3]=1045; /* line # 1045 */
      break;
      case 7:Ra.sl[3]=1049; /* line # 1049 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=1050; /* line # 1050 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,3,4, NULL);
      else {
        Ra.sl[3]=1052; /* line # 1052 */
        Rv24=Rv14;
        Ra.sl[3]=1053; /* line # 1053 */
        switch (((UB *)Rv24)[20]) {
          case 5:Ra.sl[3]=1054; /* line # 1054 */
          P_queue_object(((V *)Rv24)+14,((V *)Rv24)+15,Rv0);
          break;
          case 6:Ra.sl[3]=1055; /* line # 1055 */
          P_queue_object(((V *)Rv24)+8,((V *)Rv24)+9,Rv0);
          break;
          default:Ra.sl[3]=1057; /* line # 1057 */
          P_exec_error(Rd.s+1056,9,4, NULL);
          break;
        }
      }
      Ra.sl[3]=1059; /* line # 1059 */
      ((V *)Rv10)[7]=NULL;
      Ra.sl[3]=1060; /* line # 1060 */
      ((V *)Rv10)[8]=NULL;
      Ra.sl[3]=1061; /* line # 1061 */
      Rv25=0;
      Ra.sl[3]=1062; /* line # 1062 */
      Rv26=11;
      for( Rf1=12;Rf1>0;Rf1-- ) {
        Ra.sl[3]=1064; /* line # 1064 */
        Rv11=MXD_TRELDER_PRC_00000009(15+Rv26);
        Ra.sl[3]=1065; /* line # 1065 */
        if (Rv26>7&&Rv11!=NULL) Rv25=1;
        Ra.sl[3]=1066; /* line # 1066 */
        ((V *)Rv10)[Rv26+10]=Rv11;
        Rv26--;
      }
      Ra.sl[3]=1068; /* line # 1068 */
      if (((V *)Rv10)[12]==NULL) ((V *)Rv10)[12]=V_pcte_one;
      Ra.sl[3]=1069; /* line # 1069 */
      ((UB *)Rv10)[88]=Rv7==16;
      Ra.sl[3]=1070; /* line # 1070 */
      ((UB *)Rv10)[89]=Rv25;
      Ra.sl[3]=1072; /* line # 1072 */
      break;
      case 10:Ra.sl[3]=1084; /* line # 1084 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=1085; /* line # 1085 */
      if (Rv14==NULL) Rv14=V_cphas;
      Ra.sl[3]=1086; /* line # 1086 */
      Rv27=Rv14;
      Ra.sl[3]=1087; /* line # 1087 */
      switch (((UB *)Rv27)[20]) {
        case 5:Ra.sl[3]=1088; /* line # 1088 */
        P_queue_object(((V *)Rv27)+16,((V *)Rv27)+17,Rv0);
        break;
        case 6:Ra.sl[3]=1089; /* line # 1089 */
        P_queue_object(((V *)Rv27)+10,((V *)Rv27)+11,Rv0);
        break;
        default:Ra.sl[3]=1091; /* line # 1091 */
        P_exec_error(Rd.s+1056,10,4, NULL);
        break;
      }
      Ra.sl[3]=1093; /* line # 1093 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(&Rv28,0);
      PAS__READ_SL(&Rv29,0);
      Ra.sl[3]=1094; /* line # 1094 */
      ((V *)Rv10)[6]=NULL;
      Ra.sl[3]=1095; /* line # 1095 */
      Rv14=P_get_reference(Rv28);
      Ra.sl[3]=1096; /* line # 1096 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,5,4, NULL);
      else {
        Ra.sl[3]=1098; /* line # 1098 */
        Rv30=Rv14;
        Ra.sl[3]=1099; /* line # 1099 */
        if (((V *)Rv30)[7]==NULL) ((V *)Rv30)[7]=Rv0;
        else {
          Ra.sl[3]=1102; /* line # 1102 */
          Rv11=((V *)Rv30)[7];
          Ra.sl[3]=1103; /* line # 1103 */
          while (((V *)Rv11)[6]!=NULL)
          Rv11=((V *)Rv11)[6];
          Ra.sl[3]=1104; /* line # 1104 */
          ((V *)Rv11)[6]=Rv0;
        }
      }
      Ra.sl[3]=1106; /* line # 1106 */
      ((V *)Rv10)[7]=P_get_reference(Rv29);
      Ra.sl[3]=1107; /* line # 1107 */
      Rv31=6;
      for( Rf1=7;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv31+8]=MXD_TRELDER_PRC_00000009(27+Rv31);
        Rv31--;
      }
      Ra.sl[3]=1109; /* line # 1109 */
      break;
      case 11:Ra.sl[3]=1116; /* line # 1116 */
      Rv14=P_get_reference(Rv6);
      Ra.sl[3]=1117; /* line # 1117 */
      if (Rv14==NULL) Rv14=V_cphas;
      Ra.sl[3]=1118; /* line # 1118 */
      Rv32=Rv14;
      Ra.sl[3]=1119; /* line # 1119 */
      switch (((UB *)Rv32)[20]) {
        case 5:Ra.sl[3]=1120; /* line # 1120 */
        P_queue_object(((V *)Rv32)+18,((V *)Rv32)+19,Rv0);
        break;
        case 6:Ra.sl[3]=1121; /* line # 1121 */
        P_queue_object(((V *)Rv32)+12,((V *)Rv32)+13,Rv0);
        break;
        default:Ra.sl[3]=1123; /* line # 1123 */
        P_exec_error(Rd.s+1056,11,4, NULL);
        break;
      }
      Ra.sl[3]=1125; /* line # 1125 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(&Rv28,0);
      PAS__READ_SL(&Rv29,0);
      Ra.sl[3]=1126; /* line # 1126 */
      ((V *)Rv10)[6]=NULL;
      Ra.sl[3]=1127; /* line # 1127 */
      Rv14=P_get_reference(Rv28);
      Ra.sl[3]=1128; /* line # 1128 */
      if (Rv14==NULL) P_exec_error(Rd.s+1056,5,4, NULL);
      else {
        Ra.sl[3]=1130; /* line # 1130 */
        Rv33=Rv14;
        Ra.sl[3]=1131; /* line # 1131 */
        if (((V *)Rv33)[7]==NULL) ((V *)Rv33)[7]=Rv0;
        else {
          Ra.sl[3]=1134; /* line # 1134 */
          Rv11=((V *)Rv33)[7];
          Ra.sl[3]=1135; /* line # 1135 */
          while (((V *)Rv11)[6]!=NULL)
          Rv11=((V *)Rv11)[6];
          Ra.sl[3]=1136; /* line # 1136 */
          ((V *)Rv11)[6]=Rv0;
        }
      }
      Ra.sl[3]=1138; /* line # 1138 */
      ((V *)Rv10)[7]=P_get_reference(Rv29);
      Ra.sl[3]=1139; /* line # 1139 */
      Rv34=7;
      for( Rf1=8;Rf1>0;Rf1-- ) {
        ((V *)Rv10)[Rv34+8]=MXD_TRELDER_PRC_00000009(34+Rv34);
        Rv34--;
      }
      Ra.sl[3]=1141; /* line # 1141 */
      break;
      case 14:Ra.sl[3]=1148; /* line # 1148 */
      ((V *)Rv10)[8]=MXD_TRELDER_PRC_00000009(62);
      Ra.sl[3]=1149; /* line # 1149 */
      ((V *)Rv10)[7]=MXD_TRELDER_PRC_00000009(61);
      Ra.sl[3]=1150; /* line # 1150 */
      if (((V *)Rv10)[7]==NULL) ((V *)Rv10)[7]=V_pcte_one;
      Ra.sl[3]=1151; /* line # 1151 */
      ((V *)Rv10)[9]=V_varlst;
      Ra.sl[3]=1152; /* line # 1152 */
      P_queue_object(&V_dblkhde, &V_dblklst, Rv0);
      Ra.sl[3]=1154; /* line # 1154 */
      break;
      case 13:Ra.sl[3]=1159; /* line # 1159 */
      ((V *)Rv10)[9]=MXD_TRELDER_PRC_00000009(54);
      Ra.sl[3]=1160; /* line # 1160 */
      ((V *)Rv10)[8]=MXD_TRELDER_PRC_00000009(53);
      Ra.sl[3]=1161; /* line # 1161 */
      ((V *)Rv10)[7]=MXD_TRELDER_PRC_00000009(52);
      Ra.sl[3]=1162; /* line # 1162 */
      ((V *)Rv10)[6]=MXD_TRELDER_PRC_00000009(51);
      break;
      case 12:Ra.sl[3]=1165; /* line # 1165 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(&Rv3,0);
      PAS__READ_SL(((SL *)Rv10)+10,0);
      Ra.sl[3]=1166; /* line # 1166 */
      PAS__VWRITE_INIT(Ri.s+277,1);
      PAS__WRITE_STR(Rd.s+1060,-1,-1,32);
      PAS__WRITE_INT(Rv3,-4,0);
      PAS__WRITE_STR(Rd.s+1073,-1,-1,32);
      PAS__WRITE_EOLN();
      Ra.sl[3]=1167; /* line # 1167 */
      Rv35=Ri.ub[278];
      ((V *)Rv10)[6]=PAS__NEW((SL)Rv35+2);
      ((UB *)((V *)Rv10)[6])[0]=Rv35;
      Ra.sl[3]=1168; /* line # 1168 */
      PAS__STR_TO_STR(((V *)Rv10)[6],Ri.s+277);
      Ra.sl[3]=1169; /* line # 1169 */
      ((UB *)Rv10)[44]=0;
      Ra.sl[3]=1170; /* line # 1170 */
      ((V *)Rv10)[7]=MXD_TRELDER_PRC_00000009(59);
      Ra.sl[3]=1171; /* line # 1171 */
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_SL(((SL *)Rv10)+9,0);
      Ra.sl[3]=1172; /* line # 1172 */
      if (((SL *)Rv10)[9]<=0) ((V *)Rv10)[8]=NULL;
      else {
        Ra.sl[3]=1175; /* line # 1175 */
        Rv36=((SL *)Rv10)[9];
        ((V *)Rv10)[8]=PAS__NEW((Rv36+1)*4+4);
        ((SL *)((V *)Rv10)[8])[0]=Rv36;
        Ra.sl[3]=1176; /* line # 1176 */
        Rv37=1;
        for( Rf1=((SL *)Rv10)[9];Rf1>0;Rf1-- ) {
          Ra.sl[3]=1177; /* line # 1177 */
          PAS__SELECT_INP(V_pcdf);
          PAS__READ_SL(&Rv28,0);
          ((V *)((V *)Rv10)[8])[Rv37+1]=P_get_reference(Rv28);
          Rv37++;
        }
      }
      Ra.sl[3]=1183; /* line # 1183 */
      ((UB *)Rv10)[45]=Rv8;
      Ra.sl[3]=1184; /* line # 1184 */
      switch (Rv8) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:Ra.sl[3]=1189; /* line # 1189 */
        ((V *)Rv10)[14]=MXD_TRELDER_PRC_00000009(57);
        Ra.sl[3]=1190; /* line # 1190 */
        ((V *)Rv10)[13]=MXD_TRELDER_PRC_00000009(56);
        Ra.sl[3]=1191; /* line # 1191 */
        ((G *)Rv10)[8]=MXD_TRELDER_PRC_00000008();
        Ra.sl[3]=1192; /* line # 1192 */
        ((V *)Rv10)[12]=MXD_TRELDER_PRC_00000009(55);
        Ra.sl[3]=1193; /* line # 1193 */
        ((SL *)Rv10)[15]=0;
        Ra.sl[3]=1194; /* line # 1194 */
        ((G *)Rv10)[9]=0.000000000000000E-001;
        Ra.sl[3]=1195; /* line # 1195 */
        ((G *)Rv10)[10]=0.000000000000000E-001;
        Ra.sl[3]=1196; /* line # 1196 */
        ((G *)Rv10)[11]=0.000000000000000E-001;
        Ra.sl[3]=1197; /* line # 1197 */
        ((G *)Rv10)[12]=0.000000000000000E-001;
        break;
        case 6:
        case 7:Ra.sl[3]=1201; /* line # 1201 */
        ((G *)Rv10)[8]=MXD_TRELDER_PRC_00000008();
        Ra.sl[3]=1202; /* line # 1202 */
        ((G *)Rv10)[7]=MXD_TRELDER_PRC_00000008();
        break;
        case 8:Ra.sl[3]=1207; /* line # 1207 */
        ((V *)Rv10)[12]=MXD_TRELDER_PRC_00000009(60);
        Ra.sl[3]=1208; /* line # 1208 */
        ((G *)Rv10)[7]=0.000000000000000E-001;
        Ra.sl[3]=1209; /* line # 1209 */
        ((G *)Rv10)[8]=0.000000000000000E-001;
        break;
        default:break;
      }
      Ra.sl[3]=1213; /* line # 1213 */
      P_queue_object(&V_datahde, &V_datalst, Rv0);
      Ra.sl[3]=1215; /* line # 1215 */
      break;
      default:break;
    }
    Ra.sl[3]=1232; /* line # 1232 */
    MXD_TRELDER_new_reference(((SL *)Rv10)[4],Rv0);
  }
  Ra.sl[3]=1234; /* line # 1234 */
  if (Rv1) Ret=Rv0;
  else {
    Ra.sl[3]=1235; /* line # 1235 */
    Ret=NULL;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " create_virtual_varbl "  */
V MXD_TRELDER_PRC_00000011(SL F_sqnb){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1079;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=1247; /* line # 1247 */
  Rv0=(UB)abs(F_sqnb);
  Ra.sl[3]=1248; /* line # 1248 */
  if (V_virtvtab.v[Rv0]==NULL) {
    Ra.sl[3]=1250; /* line # 1250 */
    Rv1=PAS__NEW(16);
    Ra.sl[3]=1251; /* line # 1251 */
    Rv2=Rv1;
    Ra.sl[3]=1253; /* line # 1253 */
    ((UB *)Rv2)[0]=57;
    Ra.sl[3]=1254; /* line # 1254 */
    ((UB *)Rv2)[1]=Rv0;
    Ra.sl[3]=1255; /* line # 1255 */
    switch (Rv0) {
      case 1:Ra.sl[3]=1257; /* line # 1257 */
      ((UB *)Rv2)[2]=12;
      break;
      case 2:
      case 3:Ra.sl[3]=1260; /* line # 1260 */
      ((UB *)Rv2)[2]=10;
      break;
      case 4:Ra.sl[3]=1263; /* line # 1263 */
      ((UB *)Rv2)[2]=11;
      break;
      default:Ra.sl[3]=1266; /* line # 1266 */
      ((UB *)Rv2)[2]=1;
      break;
    }
    Ra.sl[3]=1268; /* line # 1268 */
    ((G *)Rv2)[1]=0.000000000000000E-001;
    Ra.sl[3]=1270; /* line # 1270 */
    V_virtvtab.v[Rv0]=Rv1;
  }
  Ra.sl[3]=1276; /* line # 1276 */
  Ret=V_virtvtab.v[Rv0];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_nd_code "  */
void MXD_TRELDER_PRC_00000012(UB *F_ncd, UB *F_ocd){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1101;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=1286; /* line # 1286 */
  PAS__SELECT_INP(V_pcdf);
  PAS__READ_SL(&Rv0,0);
  Ra.sl[3]=1287; /* line # 1287 */
  (*F_ncd)=(UB)Rv0;
  Ra.sl[3]=1288; /* line # 1288 */
  (*F_ocd)=Ri.ub[(*F_ncd)+534];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " buildtree "  */
void P_buildtree(V F_pcdf_name){
  /* Define the automatic variable space. */
  Blk( Ra, 1064 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  UB Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  SL Rv6;
  register SL Rv7;
  SL Rv8;
  register SL Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register SL Rv13;
  register V Rv14;
  SL Rv15;
  V Rv16;
  register V Rv17;
  register V Rv18;
  register int Rgi;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[265]=PAS__MEM_ALLOC((Rgi=(SL)((UB *)F_pcdf_name)[0]+2));
  memcpy( Ra.v[265],F_pcdf_name,Rgi);
  ;
  Ra.v[260]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+1040;
  Ra.v[261]=Rd.s+1114;
  Ra.v[262]=Rd.s+11;
  Ra.sl[263]=1295; /* line # 1295 */
  PAS__OPEN(&V_pcdf,0, Ra.p[265].s,4097,0,-1);
  Ra.sl[263]=1297; /* line # 1297 */
  if (PAS__iostatus!=0) {
    Ra.sl[263]=1299; /* line # 1299 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+1125,-1,-1,32);
    PAS__WRITE_STR(Rd.s+149,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1132,-1,-1,32);
    PAS__WRITE_STR(Ra.p[265].s,-1,-1,32);
    PAS__WRITE_STR(Rd.s+1180,-1,-1,32);
    PAS__WRITE_INT(PAS__iostatus,0,0);
    PAS__WRITE_EOLN();
    Ra.sl[263]=1301; /* line # 1301 */
    PAS__EXIT(4);
  }
  Ra.sl[263]=1305; /* line # 1305 */
  Ra.sl[0]=-1;
  Ra.sl[263]=1306; /* line # 1306 */
  Rv0=NULL;
  while (1){
    Ra.sl[263]=1309; /* line # 1309 */
    Ra.v[264]=NULL;
    Ra.sl[263]=1310; /* line # 1310 */
    MXD_TRELDER_PRC_00000012(&Rv1, &Rv2);
    Ra.sl[263]=1311; /* line # 1311 */
    Rv3=0;
    Ra.sl[263]=1315; /* line # 1315 */
    if (Rv2!=66) {
      Ra.sl[263]=1316; /* line # 1316 */
      switch (Rv2) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:Ra.sl[263]=1323; /* line # 1323 */
        Ra.v[264]=PAS__NEW(12);
        Ra.sl[263]=1324; /* line # 1324 */
        ((UB *)Ra.v[264])[0]=Rv2;
        Ra.sl[263]=1325; /* line # 1325 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1326; /* line # 1326 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        break;
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:Ra.sl[263]=1332; /* line # 1332 */
        Ra.v[264]=PAS__NEW(32);
        Ra.sl[263]=1333; /* line # 1333 */
        ((UB *)Ra.v[264])[0]=Rv2;
        Ra.sl[263]=1334; /* line # 1334 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1335; /* line # 1335 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1336; /* line # 1336 */
        ((G *)Ra.v[264])[2]=0.000000000000000E-001;
        Ra.sl[263]=1337; /* line # 1337 */
        ((G *)Ra.v[264])[3]=0.000000000000000E-001;
        break;
        case 19:
        case 20:
        case 21:
        case 22:Ra.sl[263]=1343; /* line # 1343 */
        Ra.v[264]=PAS__NEW(8);
        Ra.sl[263]=1344; /* line # 1344 */
        ((UB *)Ra.v[264])[0]=Rv2;
        Ra.sl[263]=1345; /* line # 1345 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        break;
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
        case 39:Ra.sl[263]=1355; /* line # 1355 */
        Ra.v[264]=PAS__NEW(16);
        Ra.sl[263]=1356; /* line # 1356 */
        ((UB *)Ra.v[264])[0]=Rv2;
        Ra.sl[263]=1357; /* line # 1357 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1358; /* line # 1358 */
        ((G *)Ra.v[264])[1]=0.000000000000000E-001;
        break;
        case 40:Ra.sl[263]=1363; /* line # 1363 */
        Ra.v[264]=PAS__NEW(28);
        Ra.sl[263]=1364; /* line # 1364 */
        ((UB *)Ra.v[264])[0]=40;
        Ra.sl[263]=1365; /* line # 1365 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1366; /* line # 1366 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1367; /* line # 1367 */
        ((G *)Ra.v[264])[2]=0.000000000000000E-001;
        Ra.sl[263]=1368; /* line # 1368 */
        ((SL *)Ra.v[264])[6]=0;
        break;
        case 41:Ra.sl[263]=1373; /* line # 1373 */
        Ra.v[264]=PAS__NEW(28);
        Ra.sl[263]=1374; /* line # 1374 */
        ((UB *)Ra.v[264])[0]=41;
        Ra.sl[263]=1375; /* line # 1375 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1376; /* line # 1376 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1377; /* line # 1377 */
        ((G *)Ra.v[264])[2]=0.000000000000000E-001;
        Ra.sl[263]=1378; /* line # 1378 */
        ((SL *)Ra.v[264])[6]=0;
        break;
        case 42:Ra.sl[263]=1383; /* line # 1383 */
        Ra.v[264]=PAS__NEW(40);
        Ra.sl[263]=1384; /* line # 1384 */
        ((UB *)Ra.v[264])[0]=42;
        Ra.sl[263]=1385; /* line # 1385 */
        Rv4=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1386; /* line # 1386 */
        ((V *)Ra.v[264])[1]=NULL;
        Ra.sl[263]=1387; /* line # 1387 */
        ((V *)Ra.v[264])[2]=Rv4;
        Ra.sl[263]=1388; /* line # 1388 */
        Rv5=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1389; /* line # 1389 */
        if (Rv5!=NULL) ((V *)Ra.v[264])[3]=((V *)Rv5)[2];
        else {
          Ra.sl[263]=1390; /* line # 1390 */
          ((V *)Ra.v[264])[3]=NULL;
        }
        Ra.sl[263]=1391; /* line # 1391 */
        ((SL *)Ra.v[264])[4]=0;
        Ra.sl[263]=1392; /* line # 1392 */
        if (Rv5!=NULL) {
          Ra.sl[263]=1393; /* line # 1393 */
          if (((UB *)Rv5)[0]==54) {
            Ra.sl[263]=1394; /* line # 1394 */
            if (((UB *)Rv5)[1]==10) ((SL *)Ra.v[264])[4]=-1;
          }
        }
        Ra.sl[263]=1395; /* line # 1395 */
        ((G *)Ra.v[264])[3]=0.000000000000000E-001;
        Ra.sl[263]=1396; /* line # 1396 */
        ((G *)Ra.v[264])[4]=0.000000000000000E-001;
        Ra.sl[263]=1397; /* line # 1397 */
        if (V_interphde==NULL) V_interphde=Ra.v[264];
        else {
          Ra.sl[263]=1398; /* line # 1398 */
          ((V *)V_interplst)[1]=Ra.v[264];
        }
        Ra.sl[263]=1399; /* line # 1399 */
        V_interplst=Ra.v[264];
        break;
        case 43:Ra.sl[263]=1404; /* line # 1404 */
        Ra.v[264]=PAS__NEW(16);
        Ra.sl[263]=1405; /* line # 1405 */
        ((UB *)Ra.v[264])[0]=43;
        Ra.sl[263]=1406; /* line # 1406 */
        ((V *)Ra.v[264])[3]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1407; /* line # 1407 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1408; /* line # 1408 */
        Rv5=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1409; /* line # 1409 */
        if (Rv5!=NULL) ((V *)Ra.v[264])[1]=((V *)Rv5)[2];
        else {
          Ra.sl[263]=1410; /* line # 1410 */
          ((V *)Ra.v[264])[1]=NULL;
        }
        break;
        case 44:Ra.sl[263]=1415; /* line # 1415 */
        Ra.v[264]=PAS__NEW(24);
        Ra.sl[263]=1416; /* line # 1416 */
        ((UB *)Ra.v[264])[0]=44;
        Ra.sl[263]=1417; /* line # 1417 */
        ((V *)Ra.v[264])[5]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1418; /* line # 1418 */
        ((V *)Ra.v[264])[4]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1419; /* line # 1419 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1420; /* line # 1420 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1421; /* line # 1421 */
        ((V *)Ra.v[264])[3]=MXD_TRELDER_PRC_00000001();
        break;
        case 45:Ra.sl[263]=1426; /* line # 1426 */
        Ra.v[264]=PAS__NEW(24);
        Ra.sl[263]=1427; /* line # 1427 */
        ((UB *)Ra.v[264])[0]=45;
        Ra.sl[263]=1428; /* line # 1428 */
        ((G *)Ra.v[264])[1]=0.000000000000000E-001;
        Ra.sl[263]=1429; /* line # 1429 */
        ((V *)Ra.v[264])[5]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1430; /* line # 1430 */
        ((V *)Ra.v[264])[4]=NULL;
        Ra.sl[263]=1431; /* line # 1431 */
        if (V_sumhhde==NULL) V_sumhhde=Ra.v[264];
        else {
          Ra.sl[263]=1432; /* line # 1432 */
          ((V *)Ri.v[152])[4]=Ra.v[264];
        }
        Ra.sl[263]=1433; /* line # 1433 */
        Ri.v[152]=Ra.v[264];
        break;
        case 48:Ra.sl[263]=1438; /* line # 1438 */
        Ra.v[264]=PAS__NEW(20);
        Ra.sl[263]=1439; /* line # 1439 */
        ((UB *)Ra.v[264])[0]=48;
        Ra.sl[263]=1440; /* line # 1440 */
        ((V *)Ra.v[264])[3]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1441; /* line # 1441 */
        ((V *)Ra.v[264])[2]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1442; /* line # 1442 */
        ((V *)Ra.v[264])[1]=MXD_TRELDER_PRC_00000001();
        Ra.sl[263]=1443; /* line # 1443 */
        ((SL *)Ra.v[264])[4]=0;
        break;
        case 46:
        case 47:Ra.sl[263]=1448; /* line # 1448 */
        Ra.v[264]=PAS__NEW(8);
        Ra.sl[263]=1449; /* line # 1449 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv6,0);
        Ra.sl[263]=1450; /* line # 1450 */
        ((UB *)Ra.v[264])[0]=Rv2;
        Ra.sl[263]=1451; /* line # 1451 */
        ((UB *)Ra.v[264])[1]=1;
        Ra.sl[263]=1452; /* line # 1452 */
        Rv7=Rv6;
        ((V *)Ra.v[264])[1]=PAS__NEW((Rv7+1)*4+4);
        ((SL *)((V *)Ra.v[264])[1])[0]=Rv7;
        Ra.sl[263]=1453; /* line # 1453 */
        Rv8=Rv6;
        for( Rf0=Rv6+1;Rf0>0;Rf0-- ) {
          Ra.sl[263]=1454; /* line # 1454 */
          ((V *)((V *)Ra.v[264])[1])[Rv8+1]=MXD_TRELDER_PRC_00000001();
          Rv8--;
        }
        break;
        case 49:Ra.sl[263]=1459; /* line # 1459 */
        Ra.v[264]=PAS__NEW(12);
        Ra.sl[263]=1460; /* line # 1460 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv6,0);
        Ra.sl[263]=1461; /* line # 1461 */
        ((UB *)Ra.v[264])[0]=49;
        Ra.sl[263]=1462; /* line # 1462 */
        ((SL *)Ra.v[264])[1]=0;
        Ra.sl[263]=1463; /* line # 1463 */
        Rv9=Rv6;
        ((V *)Ra.v[264])[2]=PAS__NEW((Rv9+1)*4+4);
        ((SL *)((V *)Ra.v[264])[2])[0]=Rv9;
        Ra.sl[263]=1464; /* line # 1464 */
        Rv10=Rv6;
        for( Rf0=Rv6+1;Rf0>0;Rf0-- ) {
          Ra.sl[263]=1465; /* line # 1465 */
          ((V *)((V *)Ra.v[264])[2])[Rv10+1]=MXD_TRELDER_PRC_00000001();
          Rv10--;
        }
        break;
        case 51:Ra.sl[263]=1470; /* line # 1470 */
        Ra.v[264]=PAS__NEW(1);
        Ra.sl[263]=1471; /* line # 1471 */
        ((UB *)Ra.v[264])[0]=51;
        break;
        case 52:Ra.sl[263]=1476; /* line # 1476 */
        Ra.v[264]=PAS__NEW(16);
        Ra.sl[263]=1477; /* line # 1477 */
        ((UB *)Ra.v[264])[0]=52;
        Ra.sl[263]=1478; /* line # 1478 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_DBLE(((G *)Ra.v[264])+1,0);
        Ra.sl[263]=1480; /* line # 1480 */
        break;
        case 54:Ra.sl[263]=1486; /* line # 1486 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv11,0);
        Ra.sl[263]=1487; /* line # 1487 */
        if (Rv11<0) {
          Ra.sl[263]=1488; /* line # 1488 */
          MXD_TRELDER_PRC_00000011( -Rv11);
        }
        else {
          Ra.sl[263]=1491; /* line # 1491 */
          Ra.v[264]=PAS__NEW(2);
          Ra.sl[263]=1492; /* line # 1492 */
          ((UB *)Ra.v[264])[0]=54;
          Ra.sl[263]=1493; /* line # 1493 */
          ((UB *)Ra.v[264])[1]=(UB)Rv11;
          Ra.sl[263]=1495; /* line # 1495 */
        }
        break;
        case 55:Ra.sl[263]=1502; /* line # 1502 */
        Rv4=PAS__NEW(16);
        Ra.sl[263]=1503; /* line # 1503 */
        ((UB *)Rv4)[0]=55;
        Ra.sl[263]=1504; /* line # 1504 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv12,0);
        Ra.sl[263]=1505; /* line # 1505 */
        MXD_TRELDER_PRC_00000003(((V *)Rv4)+1,0);
        Ra.sl[263]=1506; /* line # 1506 */
        ((SL *)Rv4)[2]=Rv12;
        Ra.sl[263]=1507; /* line # 1507 */
        ((SL *)Rv4)[3]=-1;
        Ra.sl[263]=1508; /* line # 1508 */
        MXD_TRELDER_new_reference(Rv12, Rv4);
        Ra.sl[263]=1510; /* line # 1510 */
        break;
        case 53:Ra.sl[263]=1517; /* line # 1517 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv11,0);
        PAS__READ_SL(&Rv6,0);
        Ra.sl[263]=1518; /* line # 1518 */
        Ra.v[264]=PAS__NEW(12);
        Ra.sl[263]=1519; /* line # 1519 */
        ((UB *)Ra.v[264])[0]=53;
        Ra.sl[263]=1520; /* line # 1520 */
        ((SL *)Ra.v[264])[1]=Rv11;
        Ra.sl[263]=1522; /* line # 1522 */
        Rv13=Rv6;
        ((V *)Ra.v[264])[2]=PAS__NEW(Rv13*8+8);
        ((SL *)((V *)Ra.v[264])[2])[0]=Rv13;
        Ra.sl[263]=1523; /* line # 1523 */
        Rv14=((V *)Ra.v[264])[2];
        Ra.sl[263]=1524; /* line # 1524 */
        Rv15=1;
        for( Rf0=Rv6;Rf0>0;Rf0-- ) {
          PAS__SELECT_INP(V_pcdf);
          PAS__READ_DBLE((((G *)Rv14)+Rv15),0);
          Rv15++;
        }
        Ra.sl[263]=1525; /* line # 1525 */
        MXD_TRELDER_new_reference(((SL *)Ra.v[264])[1],Ra.v[264]);
        break;
        default:break;
      }
    }
    else {
      Ra.sl[263]=1531; /* line # 1531 */
      switch (Rv1) {
        case 10:Ra.sl[263]=1532; /* line # 1532 */
        Ra.v[264]=MXD_TRELDER_PRC_00000010(60);
        break;
        case 12:Ra.sl[263]=1533; /* line # 1533 */
        Ra.v[264]=MXD_TRELDER_PRC_00000010(57);
        break;
        case 13:Ra.sl[263]=1534; /* line # 1534 */
        Ra.v[264]=MXD_TRELDER_PRC_00000010(58);
        break;
        case 15:Ra.sl[263]=1535; /* line # 1535 */
        Ra.v[264]=MXD_TRELDER_PRC_00000010(62);
        break;
        case 18:Ra.sl[263]=1536; /* line # 1536 */
        Ra.v[264]=MXD_TRELDER_PRC_00000010(63);
        break;
        case 19:Ra.sl[263]=1540; /* line # 1540 */
        if (Ra.sl[0]<1) {
          P_exec_error(Rd.s+1056,12,4, NULL);
          Ra.sl[0]=1;
        }
        Ra.sl[263]=1541; /* line # 1541 */
        Rv16=Ra.v[Ra.sl[0]+1];
        Ra.v[Ra.sl[0]+1]=Ra.v[(Ra.sl[0]-1)+1];
        Ra.v[(Ra.sl[0]-1)+1]=Rv16;
        break;
        case 4:Ra.sl[263]=1545; /* line # 1545 */
        MXD_TRELDER_PRC_00000000(NULL);
        break;
        case 11:Ra.sl[263]=1549; /* line # 1549 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv11,0);
        Ra.sl[263]=1550; /* line # 1550 */
        Rv4=P_get_reference(Rv11);
        Ra.sl[263]=1551; /* line # 1551 */
        Rv17=Rv4;
        Ra.sl[263]=1552; /* line # 1552 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_DBLE(((G *)Rv17)+5,0);
        PAS__READ_DBLE(((G *)Rv17)+6,0);
        Ra.sl[263]=1554; /* line # 1554 */
        break;
        case 7:Ra.sl[263]=1561; /* line # 1561 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv11,0);
        Ra.sl[263]=1562; /* line # 1562 */
        Rv4=P_get_reference(Rv11);
        Ra.sl[263]=1563; /* line # 1563 */
        if (Rv4!=NULL) MXD_TRELDER_PRC_00000003(((V *)Rv4)+3,0);
        Ra.sl[263]=1565; /* line # 1565 */
        break;
        case 6:Ra.sl[263]=1572; /* line # 1572 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(&Rv11,0);
        Ra.sl[263]=1573; /* line # 1573 */
        Ra.v[264]=P_get_reference(Rv11);
        break;
        case 0:Ra.sl[263]=1577; /* line # 1577 */
        MXD_TRELDER_PRC_00000003(&V_job_name,0);
        Ra.sl[263]=1579; /* line # 1579 */
        break;
        case 1:Ra.sl[263]=1585; /* line # 1585 */
        MXD_TRELDER_PRC_00000003(&V_job_title,0);
        Ra.sl[263]=1587; /* line # 1587 */
        break;
        case 2:Ra.sl[263]=1593; /* line # 1593 */
        MXD_TRELDER_PRC_00000003(&V_sav_fname,0);
        Ra.sl[263]=1595; /* line # 1595 */
        break;
        case 3:break;
        case 16:break;
        case 17:Ra.sl[263]=1606; /* line # 1606 */
        PAS__SELECT_INP(V_pcdf);
        PAS__READ_SL(Ra.sl+258,0);
        PAS__READ_SL(Ra.sl+259,0);
        PAS__READ_SL(&Rv11,0);
        PAS__READ_SL(&Rv12,0);
        Ra.sl[263]=1607; /* line # 1607 */
        if (Ra.sl[259]<=0) {
          Ra.sl[263]=1609; /* line # 1609 */
          Ra.v[264]=PAS__NEW(12);
          Ra.sl[263]=1610; /* line # 1610 */
          ((UB *)Rv4)[0]=64;
          Ra.sl[263]=1611; /* line # 1611 */
          ((SL *)Rv4)[1]=Ra.sl[258];
          Ra.sl[263]=1612; /* line # 1612 */
          ((SL *)Rv4)[2]=Rv12;
        }
        else {
          Ra.sl[263]=1616; /* line # 1616 */
          Rv5=P_get_reference(Ra.sl[259]);
          Ra.sl[263]=1617; /* line # 1617 */
          if (Rv5!=NULL) {
            Ra.sl[263]=1618; /* line # 1618 */
            Rv18=Rv5;
            Ra.sl[263]=1620; /* line # 1620 */
            Rv4=NULL;
            Ra.sl[263]=1621; /* line # 1621 */
            switch (((UB *)Rv18)[20]) {
              case 5:Ra.sl[263]=1622; /* line # 1622 */
              if (Rv12<=8) Rv4=((V *)Rv18)[Rv12+20];
              break;
              case 6:Ra.sl[263]=1623; /* line # 1623 */
              if (Rv12<=11) Rv4=((V *)Rv18)[Rv12+34];
              break;
              case 7:Ra.sl[263]=1624; /* line # 1624 */
              if (Rv12<=11) Rv4=((V *)Rv18)[Rv12+10];
              break;
              case 9:Ra.sl[263]=1625; /* line # 1625 */
              if (Rv12<=2) Rv4=((V *)Rv18)[Rv12+7];
              break;
              case 10:Ra.sl[263]=1626; /* line # 1626 */
              if (Rv12<=6) Rv4=((V *)Rv18)[Rv12+8];
              break;
              case 11:Ra.sl[263]=1627; /* line # 1627 */
              if (Rv12<=7) Rv4=((V *)Rv18)[Rv12+8];
              break;
              default:break;
            }
          }
          else {
            Ra.sl[263]=1631; /* line # 1631 */
            P_exec_error(Rd.s+1056,13,4, NULL);
          }
        }
        Ra.sl[263]=1633; /* line # 1633 */
        if (Rv4==NULL) P_exec_error(Rd.s+1056,8,4, NULL);
        else {
          Ra.sl[263]=1635; /* line # 1635 */
          if (Rv11>0) MXD_TRELDER_new_reference(Rv11, Rv4);
          else {
            Ra.sl[263]=1636; /* line # 1636 */
            Ra.v[264]=Rv4;
          }
        }
        break;
        case 20:Ra.sl[263]=1639; /* line # 1639 */
        MXD_TRELDER_PRC_00000007();
        break;
        default:Ra.sl[263]=1642; /* line # 1642 */
        P_exec_error(Rd.s+1056,14,4, NULL);
        break;
      }
    }
    Ra.sl[263]=1644; /* line # 1644 */
    if (Ra.v[264]!=NULL) MXD_TRELDER_PRC_00000000(Ra.v[264]);
    Ra.sl[263]=1646; /* line # 1646 */
    if (!PAS__EOF(V_pcdf)) {
      PAS__SELECT_INP(V_pcdf);
      PAS__READ_EOLN();
    }
    if (PAS__EOF(V_pcdf)||V_fatal_error)  break;
  }
  Ra.sl[263]=1648; /* line # 1648 */
  if (!V_bshort_flst) V_b132=1;
  Ra.sl[263]=1649; /* line # 1649 */
  PAS__CLOSE(&V_pcdf,0);
  Ra.sl[263]=1650; /* line # 1650 */
  Ri.sl[2]=Ri.sl[1];
  PAS__curr_cntx=Ra.v[260];
  PAS__MEM_FREE(Ra.v[265]);
  Lx[0]=Lx_Sv;
}
