{		*  M  X  D  *  S Y S T E M  *

        ***   R U N   T I M E    L I B R A R Y   ***


	BY :
	    P. WOLFERS
		C.N.R.S.
		LABORATOIRE DE CRISTALLOGRAPHIE
		B.P.  166 X   38042  GRENOBLE CEDEX
					FRANCE.

}
{  VERSION 3.9-L3    OF  M-X-D  SYSTEM   }
{**********   CPAS    VERSION  **********}

const
  max_intdig  =  12;   { maximum of digit for integer (maxi 32 bits) }
  str_ln10    = 2.30258512E+00;       { Ln(10) for number conversions }
  str_log9o5  = 9.997E-01; { value to set a new scale change in conversion }

  inrd = 0.0174532931; { pi /180 }
  pagesize    =  55;   { size of a page listing in line }
  maxerrline  =  80;   { size of one error message line }
  maxshortsz  =  32;   { maximum size of an internal file specification }
  maxoptv     =   8;   { we can have until 8 value for an option statement }
  maxlinesz   = 132;   { maximum size for a data line }
  maxidsize   =  16;   { maximum size of an identifier }
  maxffrm     =  15;   { maximum number - 1 of form facteur }
  maxsel      =  31;   { maximum value of nbsel for select function }
  ofilespcpos =  9;    { output fourier file spc. position modification }

  colmnsize   =  32;   { ??? }

  maxiline    = CHR( maxlinesz );     { maxlinesz as a character }


type

  timety  = packed array[1..11] of char; { use for date and time procedure }

  errline = packed array[1..maxerrline] of char; { error line type }

  shortstring = packed array[1..maxshortsz] of char; { for file specif. }

  strline = packed array[1..maxlinesz] of char; { string-line definition }

  filespc = string( maxlinesz );      { file reference type }


  { strings definitions }
  stp = ^mxd_string;

  mxd_string = record
    n: stp;                           { link to next record }
    s: strline;                       { string line }
    l: char                           { used length of the string }
  end;


  { module name definition ( for error message proceding ) }
  mdnam = packed array[1..4] of char;


  { identifier name string definition }
  identifier = packed array[1..maxidsize] of char;

  nameid = record
    l: char;                          { used length of the identifier }
    s: identifier                     { identifier string }
  end;


  { data file record definition }

  datrec = record
    h, k, l, m, nq, mlq, is,          { reciprocal cell diff vector }
    ipl,  refcat: integer;            { reflexion data type }
    he,   ke,   le, stsl,             { reciprocal diffusion vector }
    dobs, pds,  sig: real;            { intensity, weight and sigma }
    tbdif: array[0..maxffrm] of real  { scattering table }
  end;

  bdt_file = file of datrec;          { Binary Data File type }



  { data information definition }

  datadef = record
    filenbr,                          { data file sequence number }
    optref,                           { observation type (0/1/2 for sf/f2/ray) }
    ncp, ncpv,                        { number of hkl and intensities }
    hm,  hn,   km,
    kn,  lm,   ln: integer;           { mini-maxi of h k l }
    swobs2,    swobs,                 { weighted obs. summations }
    sobs2,     sobs: real             { unweighted obs. summations }
  end;


  { ddi table record structure }

  ddirec = record
    nam: nameid;                      { name of the data collection }
    inf: datadef                      { related informations }
  end;

  ddi_file = file of ddirec;          { DDI file type }



  { fourier output file record definition }
  outblk = record
    refskip: integer;		      { skip reflexion count }
    csca, cfn2, cfm2,		      { scale and extinction coefficients }
    crf,  cif,  cmag, delssg: real    { fourier and reject information }
  end;

  bcf_file = file of outblk;          { BCR file type }


var

  linewrt,                            { line number to write in lst }
  pagenb,                             { page number }
  errcnt:       [external] integer;   { error count }

  errmsgspecif: [external] filespc;   { file specification for the error message }

  majorfmode,                         { Flag for major case file specification enabled }
  fatalerror:   [external] boolean;   { boolean to signal fatal error stop }

  lst:          [external] text;      { output listing file }

  { error messages random access file }
  errmsg:       [external] file of errline;

  strempty:     [external] stp;       { list of unused string }

{
  ****************************************************
  *                                                  *
  *         Not  PASCAL  Standard  functions         *
  *                                                  *
  ****************************************************
}

function BESSEL_J( n: integer; x: real ): real; external;
{ result is Jn( x ) First kind bessel function }


function FBJN( var dbjn: real; x: real; n: integer ): real; external;
{ result is Jn( x ) and d(Jn(x))/dx of First kind bessel function }



{
  ****************************************************
  *                                                  *
  *     String composition PASCAL  Routines          *
  *                                                  *
  ****************************************************
}

{ *** Routines derived from the BASIC$STR library *** }


function  ST_CREATE: stp;
external;

procedure ST_FREE( var p: stp );
external;

procedure ST_PUT_CHAR( var st: mxd_string; ch: char );
external;

procedure ST_PUT_MCHAR( var st: mxd_string; ch: char; m: integer );
external;

procedure ST_PUT_PASTR( var trg: mxd_string;
                        var src: [readonly] string ); external;


procedure ST_PUT_STRING( var trg, src: mxd_string ); external;



procedure ST_PUT_IDENT( var trg: mxd_string;
                        var src: [readonly] nameid;
                            fld: integer ); external;


procedure ST_WRT_FLOAT(     dv: real; ndig, pent: integer;
                        var st: mxd_string ); external;
{ dv is a positive normalized number in the range [0.1,1.0[. or 0.0 }
{ ndig is the number of digit to write }
{ pent is the number of digit for the integer part }


procedure ST_PUT_B_INT(  var st: mxd_string; iv, ndig, base: integer );
external;


procedure ST_PUT_INT(  var st: mxd_string; iv, ndig: integer );
external;


function  ST_SIZE_REAL( var iexp: integer; var dv: real ): boolean;
external;


procedure ST_PUT_FLOAT( var st: mxd_string;
                            dv: real; fs, intsz, dcsz, es: integer );
external;


procedure ST_PUT_FIXED( var st: mxd_string;
                            dv: real; fs, dcsz, dcmin: integer );
external;





{
  ****************************************************
  *                                                  *
  *   Interface routines with the operating system   *
  *                                                  *
  ****************************************************
}

procedure OUT_PAGE( var f: text ); external;


procedure GET_DATE( var st: timety ); external;


procedure GET_TIME( var st: timety ); external;


procedure PUT_NEWLINELST( var title: [readonly] string ); external;


procedure OUTERRMSGLINE( n: integer ); external;
{ to display an information line related to an error }


procedure OPEN_LISTING( var     f: text;
                        var fname: [readonly]
                                   packed array[$sz: integer] of char;
                            mdflg: integer ); external;


procedure OPENW_TXTFILE( var f: text; fname: stp; mdflg: integer );
external;


procedure CLOSE_TXTFILE( var f: text );
external;
{ close if already open for chaine statement }


(** CPAS **) { open an input text file }
procedure OPEN_INPUT_TXTFILE( var f: text; fname: stp;
                              var bok, bprt: boolean; var ierr: integer );
external;
{ try to open a text file f with the name specified by stp
  on output if bok is false: the file is not open,
  not existing file is not an error, but other problem
  generate an error code as 2000 + OPEN-VMS/RMS error code }


function  CPU_CLOCK: integer;
external;


function  OPEN_DDIFILE( var   f: ddi_file;
                        var spc: [readonly] string;
                            wrt: boolean ): boolean;
external;


procedure CLOSE_DDIFILE( var f: ddi_file );
external;


procedure OPEN_BDTFILE( var f: bdt_file; spc: stp );
external;


function  OPENR_BDTFILE( var f: bdt_file; spc: stp ): boolean;
external;


procedure CLOSE_BDTFILE( var f: bdt_file );
external;


procedure OPEN_BCFFILE( var f: bcf_file; spc: stp );
external;


procedure CLOSE_BCFFILE( var f: bcf_file );
external;


{end.}
